# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GooglePrivacyDlpV2ActionResponse',
    'GooglePrivacyDlpV2AnalyzeDataSourceRiskDetailsResponse',
    'GooglePrivacyDlpV2AuxiliaryTableResponse',
    'GooglePrivacyDlpV2BigQueryFieldResponse',
    'GooglePrivacyDlpV2BigQueryOptionsResponse',
    'GooglePrivacyDlpV2BigQueryTableResponse',
    'GooglePrivacyDlpV2BucketResponse',
    'GooglePrivacyDlpV2BucketingConfigResponse',
    'GooglePrivacyDlpV2CategoricalStatsConfigResponse',
    'GooglePrivacyDlpV2CategoricalStatsHistogramBucketResponse',
    'GooglePrivacyDlpV2CategoricalStatsResultResponse',
    'GooglePrivacyDlpV2CharacterMaskConfigResponse',
    'GooglePrivacyDlpV2CharsToIgnoreResponse',
    'GooglePrivacyDlpV2CloudStorageFileSetResponse',
    'GooglePrivacyDlpV2CloudStorageOptionsResponse',
    'GooglePrivacyDlpV2CloudStoragePathResponse',
    'GooglePrivacyDlpV2CloudStorageRegexFileSetResponse',
    'GooglePrivacyDlpV2ConditionResponse',
    'GooglePrivacyDlpV2ConditionsResponse',
    'GooglePrivacyDlpV2CryptoDeterministicConfigResponse',
    'GooglePrivacyDlpV2CryptoHashConfigResponse',
    'GooglePrivacyDlpV2CryptoKeyResponse',
    'GooglePrivacyDlpV2CryptoReplaceFfxFpeConfigResponse',
    'GooglePrivacyDlpV2CustomInfoTypeResponse',
    'GooglePrivacyDlpV2DatastoreOptionsResponse',
    'GooglePrivacyDlpV2DateShiftConfigResponse',
    'GooglePrivacyDlpV2DeidentifyConfigResponse',
    'GooglePrivacyDlpV2DeltaPresenceEstimationConfigResponse',
    'GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucketResponse',
    'GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValuesResponse',
    'GooglePrivacyDlpV2DeltaPresenceEstimationResultResponse',
    'GooglePrivacyDlpV2DetectionRuleResponse',
    'GooglePrivacyDlpV2DictionaryResponse',
    'GooglePrivacyDlpV2EntityIdResponse',
    'GooglePrivacyDlpV2ErrorResponse',
    'GooglePrivacyDlpV2ExcludeInfoTypesResponse',
    'GooglePrivacyDlpV2ExclusionRuleResponse',
    'GooglePrivacyDlpV2ExpressionsResponse',
    'GooglePrivacyDlpV2FieldIdResponse',
    'GooglePrivacyDlpV2FieldTransformationResponse',
    'GooglePrivacyDlpV2FileSetResponse',
    'GooglePrivacyDlpV2FindingLimitsResponse',
    'GooglePrivacyDlpV2FixedSizeBucketingConfigResponse',
    'GooglePrivacyDlpV2HotwordRuleResponse',
    'GooglePrivacyDlpV2HybridInspectStatisticsResponse',
    'GooglePrivacyDlpV2HybridOptionsResponse',
    'GooglePrivacyDlpV2InfoTypeLimitResponse',
    'GooglePrivacyDlpV2InfoTypeResponse',
    'GooglePrivacyDlpV2InfoTypeStatsResponse',
    'GooglePrivacyDlpV2InfoTypeTransformationResponse',
    'GooglePrivacyDlpV2InfoTypeTransformationsResponse',
    'GooglePrivacyDlpV2InspectConfigResponse',
    'GooglePrivacyDlpV2InspectDataSourceDetailsResponse',
    'GooglePrivacyDlpV2InspectJobConfigResponse',
    'GooglePrivacyDlpV2InspectTemplateResponse',
    'GooglePrivacyDlpV2InspectionRuleResponse',
    'GooglePrivacyDlpV2InspectionRuleSetResponse',
    'GooglePrivacyDlpV2JobNotificationEmailsResponse',
    'GooglePrivacyDlpV2KAnonymityConfigResponse',
    'GooglePrivacyDlpV2KAnonymityEquivalenceClassResponse',
    'GooglePrivacyDlpV2KAnonymityHistogramBucketResponse',
    'GooglePrivacyDlpV2KAnonymityResultResponse',
    'GooglePrivacyDlpV2KMapEstimationConfigResponse',
    'GooglePrivacyDlpV2KMapEstimationHistogramBucketResponse',
    'GooglePrivacyDlpV2KMapEstimationQuasiIdValuesResponse',
    'GooglePrivacyDlpV2KMapEstimationResultResponse',
    'GooglePrivacyDlpV2KindExpressionResponse',
    'GooglePrivacyDlpV2KmsWrappedCryptoKeyResponse',
    'GooglePrivacyDlpV2LDiversityConfigResponse',
    'GooglePrivacyDlpV2LDiversityEquivalenceClassResponse',
    'GooglePrivacyDlpV2LDiversityHistogramBucketResponse',
    'GooglePrivacyDlpV2LDiversityResultResponse',
    'GooglePrivacyDlpV2LargeCustomDictionaryConfigResponse',
    'GooglePrivacyDlpV2LargeCustomDictionaryStatsResponse',
    'GooglePrivacyDlpV2LeaveUntransformedResponse',
    'GooglePrivacyDlpV2LikelihoodAdjustmentResponse',
    'GooglePrivacyDlpV2ManualResponse',
    'GooglePrivacyDlpV2NumericalStatsConfigResponse',
    'GooglePrivacyDlpV2NumericalStatsResultResponse',
    'GooglePrivacyDlpV2OutputStorageConfigResponse',
    'GooglePrivacyDlpV2PartitionIdResponse',
    'GooglePrivacyDlpV2PrimitiveTransformationResponse',
    'GooglePrivacyDlpV2PrivacyMetricResponse',
    'GooglePrivacyDlpV2ProximityResponse',
    'GooglePrivacyDlpV2PublishFindingsToCloudDataCatalogResponse',
    'GooglePrivacyDlpV2PublishSummaryToCsccResponse',
    'GooglePrivacyDlpV2PublishToPubSubResponse',
    'GooglePrivacyDlpV2PublishToStackdriverResponse',
    'GooglePrivacyDlpV2QuasiIdFieldResponse',
    'GooglePrivacyDlpV2QuasiIdResponse',
    'GooglePrivacyDlpV2QuasiIdentifierFieldResponse',
    'GooglePrivacyDlpV2RecordConditionResponse',
    'GooglePrivacyDlpV2RecordSuppressionResponse',
    'GooglePrivacyDlpV2RecordTransformationsResponse',
    'GooglePrivacyDlpV2RedactConfigResponse',
    'GooglePrivacyDlpV2RegexResponse',
    'GooglePrivacyDlpV2ReplaceDictionaryConfigResponse',
    'GooglePrivacyDlpV2ReplaceValueConfigResponse',
    'GooglePrivacyDlpV2ReplaceWithInfoTypeConfigResponse',
    'GooglePrivacyDlpV2RequestedOptionsResponse',
    'GooglePrivacyDlpV2RequestedRiskAnalysisOptionsResponse',
    'GooglePrivacyDlpV2ResultResponse',
    'GooglePrivacyDlpV2RiskAnalysisJobConfigResponse',
    'GooglePrivacyDlpV2SaveFindingsResponse',
    'GooglePrivacyDlpV2ScheduleResponse',
    'GooglePrivacyDlpV2StatisticalTableResponse',
    'GooglePrivacyDlpV2StorageConfigResponse',
    'GooglePrivacyDlpV2StoredInfoTypeConfigResponse',
    'GooglePrivacyDlpV2StoredInfoTypeStatsResponse',
    'GooglePrivacyDlpV2StoredInfoTypeVersionResponse',
    'GooglePrivacyDlpV2StoredTypeResponse',
    'GooglePrivacyDlpV2SurrogateTypeResponse',
    'GooglePrivacyDlpV2TableOptionsResponse',
    'GooglePrivacyDlpV2TaggedFieldResponse',
    'GooglePrivacyDlpV2ThrowErrorResponse',
    'GooglePrivacyDlpV2TimePartConfigResponse',
    'GooglePrivacyDlpV2TimespanConfigResponse',
    'GooglePrivacyDlpV2TransformationErrorHandlingResponse',
    'GooglePrivacyDlpV2TransientCryptoKeyResponse',
    'GooglePrivacyDlpV2TriggerResponse',
    'GooglePrivacyDlpV2UnwrappedCryptoKeyResponse',
    'GooglePrivacyDlpV2ValueFrequencyResponse',
    'GooglePrivacyDlpV2ValueResponse',
    'GooglePrivacyDlpV2WordListResponse',
    'GoogleProtobufEmptyResponse',
    'GoogleRpcStatusResponse',
    'GoogleTypeDateResponse',
    'GoogleTypeTimeOfDayResponse',
]

@pulumi.output_type
class GooglePrivacyDlpV2ActionResponse(dict):
    """
    A task to execute on the completion of a job. See https://cloud.google.com/dlp/docs/concepts-actions to learn more.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobNotificationEmails":
            suggest = "job_notification_emails"
        elif key == "pubSub":
            suggest = "pub_sub"
        elif key == "publishFindingsToCloudDataCatalog":
            suggest = "publish_findings_to_cloud_data_catalog"
        elif key == "publishSummaryToCscc":
            suggest = "publish_summary_to_cscc"
        elif key == "publishToStackdriver":
            suggest = "publish_to_stackdriver"
        elif key == "saveFindings":
            suggest = "save_findings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_notification_emails: 'outputs.GooglePrivacyDlpV2JobNotificationEmailsResponse',
                 pub_sub: 'outputs.GooglePrivacyDlpV2PublishToPubSubResponse',
                 publish_findings_to_cloud_data_catalog: 'outputs.GooglePrivacyDlpV2PublishFindingsToCloudDataCatalogResponse',
                 publish_summary_to_cscc: 'outputs.GooglePrivacyDlpV2PublishSummaryToCsccResponse',
                 publish_to_stackdriver: 'outputs.GooglePrivacyDlpV2PublishToStackdriverResponse',
                 save_findings: 'outputs.GooglePrivacyDlpV2SaveFindingsResponse'):
        """
        A task to execute on the completion of a job. See https://cloud.google.com/dlp/docs/concepts-actions to learn more.
        :param 'GooglePrivacyDlpV2JobNotificationEmailsResponse' job_notification_emails: Enable email notification for project owners and editors on job's completion/failure.
        :param 'GooglePrivacyDlpV2PublishToPubSubResponse' pub_sub: Publish a notification to a pubsub topic.
        :param 'GooglePrivacyDlpV2PublishFindingsToCloudDataCatalogResponse' publish_findings_to_cloud_data_catalog: Publish findings to Cloud Datahub.
        :param 'GooglePrivacyDlpV2PublishSummaryToCsccResponse' publish_summary_to_cscc: Publish summary to Cloud Security Command Center (Alpha).
        :param 'GooglePrivacyDlpV2PublishToStackdriverResponse' publish_to_stackdriver: Enable Stackdriver metric dlp.googleapis.com/finding_count.
        :param 'GooglePrivacyDlpV2SaveFindingsResponse' save_findings: Save resulting findings in a provided location.
        """
        pulumi.set(__self__, "job_notification_emails", job_notification_emails)
        pulumi.set(__self__, "pub_sub", pub_sub)
        pulumi.set(__self__, "publish_findings_to_cloud_data_catalog", publish_findings_to_cloud_data_catalog)
        pulumi.set(__self__, "publish_summary_to_cscc", publish_summary_to_cscc)
        pulumi.set(__self__, "publish_to_stackdriver", publish_to_stackdriver)
        pulumi.set(__self__, "save_findings", save_findings)

    @property
    @pulumi.getter(name="jobNotificationEmails")
    def job_notification_emails(self) -> 'outputs.GooglePrivacyDlpV2JobNotificationEmailsResponse':
        """
        Enable email notification for project owners and editors on job's completion/failure.
        """
        return pulumi.get(self, "job_notification_emails")

    @property
    @pulumi.getter(name="pubSub")
    def pub_sub(self) -> 'outputs.GooglePrivacyDlpV2PublishToPubSubResponse':
        """
        Publish a notification to a pubsub topic.
        """
        return pulumi.get(self, "pub_sub")

    @property
    @pulumi.getter(name="publishFindingsToCloudDataCatalog")
    def publish_findings_to_cloud_data_catalog(self) -> 'outputs.GooglePrivacyDlpV2PublishFindingsToCloudDataCatalogResponse':
        """
        Publish findings to Cloud Datahub.
        """
        return pulumi.get(self, "publish_findings_to_cloud_data_catalog")

    @property
    @pulumi.getter(name="publishSummaryToCscc")
    def publish_summary_to_cscc(self) -> 'outputs.GooglePrivacyDlpV2PublishSummaryToCsccResponse':
        """
        Publish summary to Cloud Security Command Center (Alpha).
        """
        return pulumi.get(self, "publish_summary_to_cscc")

    @property
    @pulumi.getter(name="publishToStackdriver")
    def publish_to_stackdriver(self) -> 'outputs.GooglePrivacyDlpV2PublishToStackdriverResponse':
        """
        Enable Stackdriver metric dlp.googleapis.com/finding_count.
        """
        return pulumi.get(self, "publish_to_stackdriver")

    @property
    @pulumi.getter(name="saveFindings")
    def save_findings(self) -> 'outputs.GooglePrivacyDlpV2SaveFindingsResponse':
        """
        Save resulting findings in a provided location.
        """
        return pulumi.get(self, "save_findings")


@pulumi.output_type
class GooglePrivacyDlpV2AnalyzeDataSourceRiskDetailsResponse(dict):
    """
    Result of a risk analysis operation request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "categoricalStatsResult":
            suggest = "categorical_stats_result"
        elif key == "deltaPresenceEstimationResult":
            suggest = "delta_presence_estimation_result"
        elif key == "kAnonymityResult":
            suggest = "k_anonymity_result"
        elif key == "kMapEstimationResult":
            suggest = "k_map_estimation_result"
        elif key == "lDiversityResult":
            suggest = "l_diversity_result"
        elif key == "numericalStatsResult":
            suggest = "numerical_stats_result"
        elif key == "requestedOptions":
            suggest = "requested_options"
        elif key == "requestedPrivacyMetric":
            suggest = "requested_privacy_metric"
        elif key == "requestedSourceTable":
            suggest = "requested_source_table"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2AnalyzeDataSourceRiskDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2AnalyzeDataSourceRiskDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2AnalyzeDataSourceRiskDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categorical_stats_result: 'outputs.GooglePrivacyDlpV2CategoricalStatsResultResponse',
                 delta_presence_estimation_result: 'outputs.GooglePrivacyDlpV2DeltaPresenceEstimationResultResponse',
                 k_anonymity_result: 'outputs.GooglePrivacyDlpV2KAnonymityResultResponse',
                 k_map_estimation_result: 'outputs.GooglePrivacyDlpV2KMapEstimationResultResponse',
                 l_diversity_result: 'outputs.GooglePrivacyDlpV2LDiversityResultResponse',
                 numerical_stats_result: 'outputs.GooglePrivacyDlpV2NumericalStatsResultResponse',
                 requested_options: 'outputs.GooglePrivacyDlpV2RequestedRiskAnalysisOptionsResponse',
                 requested_privacy_metric: 'outputs.GooglePrivacyDlpV2PrivacyMetricResponse',
                 requested_source_table: 'outputs.GooglePrivacyDlpV2BigQueryTableResponse'):
        """
        Result of a risk analysis operation request.
        :param 'GooglePrivacyDlpV2CategoricalStatsResultResponse' categorical_stats_result: Categorical stats result
        :param 'GooglePrivacyDlpV2DeltaPresenceEstimationResultResponse' delta_presence_estimation_result: Delta-presence result
        :param 'GooglePrivacyDlpV2KAnonymityResultResponse' k_anonymity_result: K-anonymity result
        :param 'GooglePrivacyDlpV2KMapEstimationResultResponse' k_map_estimation_result: K-map result
        :param 'GooglePrivacyDlpV2LDiversityResultResponse' l_diversity_result: L-divesity result
        :param 'GooglePrivacyDlpV2NumericalStatsResultResponse' numerical_stats_result: Numerical stats result
        :param 'GooglePrivacyDlpV2RequestedRiskAnalysisOptionsResponse' requested_options: The configuration used for this job.
        :param 'GooglePrivacyDlpV2PrivacyMetricResponse' requested_privacy_metric: Privacy metric to compute.
        :param 'GooglePrivacyDlpV2BigQueryTableResponse' requested_source_table: Input dataset to compute metrics over.
        """
        pulumi.set(__self__, "categorical_stats_result", categorical_stats_result)
        pulumi.set(__self__, "delta_presence_estimation_result", delta_presence_estimation_result)
        pulumi.set(__self__, "k_anonymity_result", k_anonymity_result)
        pulumi.set(__self__, "k_map_estimation_result", k_map_estimation_result)
        pulumi.set(__self__, "l_diversity_result", l_diversity_result)
        pulumi.set(__self__, "numerical_stats_result", numerical_stats_result)
        pulumi.set(__self__, "requested_options", requested_options)
        pulumi.set(__self__, "requested_privacy_metric", requested_privacy_metric)
        pulumi.set(__self__, "requested_source_table", requested_source_table)

    @property
    @pulumi.getter(name="categoricalStatsResult")
    def categorical_stats_result(self) -> 'outputs.GooglePrivacyDlpV2CategoricalStatsResultResponse':
        """
        Categorical stats result
        """
        return pulumi.get(self, "categorical_stats_result")

    @property
    @pulumi.getter(name="deltaPresenceEstimationResult")
    def delta_presence_estimation_result(self) -> 'outputs.GooglePrivacyDlpV2DeltaPresenceEstimationResultResponse':
        """
        Delta-presence result
        """
        return pulumi.get(self, "delta_presence_estimation_result")

    @property
    @pulumi.getter(name="kAnonymityResult")
    def k_anonymity_result(self) -> 'outputs.GooglePrivacyDlpV2KAnonymityResultResponse':
        """
        K-anonymity result
        """
        return pulumi.get(self, "k_anonymity_result")

    @property
    @pulumi.getter(name="kMapEstimationResult")
    def k_map_estimation_result(self) -> 'outputs.GooglePrivacyDlpV2KMapEstimationResultResponse':
        """
        K-map result
        """
        return pulumi.get(self, "k_map_estimation_result")

    @property
    @pulumi.getter(name="lDiversityResult")
    def l_diversity_result(self) -> 'outputs.GooglePrivacyDlpV2LDiversityResultResponse':
        """
        L-divesity result
        """
        return pulumi.get(self, "l_diversity_result")

    @property
    @pulumi.getter(name="numericalStatsResult")
    def numerical_stats_result(self) -> 'outputs.GooglePrivacyDlpV2NumericalStatsResultResponse':
        """
        Numerical stats result
        """
        return pulumi.get(self, "numerical_stats_result")

    @property
    @pulumi.getter(name="requestedOptions")
    def requested_options(self) -> 'outputs.GooglePrivacyDlpV2RequestedRiskAnalysisOptionsResponse':
        """
        The configuration used for this job.
        """
        return pulumi.get(self, "requested_options")

    @property
    @pulumi.getter(name="requestedPrivacyMetric")
    def requested_privacy_metric(self) -> 'outputs.GooglePrivacyDlpV2PrivacyMetricResponse':
        """
        Privacy metric to compute.
        """
        return pulumi.get(self, "requested_privacy_metric")

    @property
    @pulumi.getter(name="requestedSourceTable")
    def requested_source_table(self) -> 'outputs.GooglePrivacyDlpV2BigQueryTableResponse':
        """
        Input dataset to compute metrics over.
        """
        return pulumi.get(self, "requested_source_table")


@pulumi.output_type
class GooglePrivacyDlpV2AuxiliaryTableResponse(dict):
    """
    An auxiliary table contains statistical information on the relative frequency of different quasi-identifiers values. It has one or several quasi-identifiers columns, and one column that indicates the relative frequency of each quasi-identifier tuple. If a tuple is present in the data but not in the auxiliary table, the corresponding relative frequency is assumed to be zero (and thus, the tuple is highly reidentifiable).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quasiIds":
            suggest = "quasi_ids"
        elif key == "relativeFrequency":
            suggest = "relative_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2AuxiliaryTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2AuxiliaryTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2AuxiliaryTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quasi_ids: Sequence['outputs.GooglePrivacyDlpV2QuasiIdFieldResponse'],
                 relative_frequency: 'outputs.GooglePrivacyDlpV2FieldIdResponse',
                 table: 'outputs.GooglePrivacyDlpV2BigQueryTableResponse'):
        """
        An auxiliary table contains statistical information on the relative frequency of different quasi-identifiers values. It has one or several quasi-identifiers columns, and one column that indicates the relative frequency of each quasi-identifier tuple. If a tuple is present in the data but not in the auxiliary table, the corresponding relative frequency is assumed to be zero (and thus, the tuple is highly reidentifiable).
        :param Sequence['GooglePrivacyDlpV2QuasiIdFieldResponse'] quasi_ids: Quasi-identifier columns.
        :param 'GooglePrivacyDlpV2FieldIdResponse' relative_frequency: The relative frequency column must contain a floating-point number between 0 and 1 (inclusive). Null values are assumed to be zero.
        :param 'GooglePrivacyDlpV2BigQueryTableResponse' table: Auxiliary table location.
        """
        pulumi.set(__self__, "quasi_ids", quasi_ids)
        pulumi.set(__self__, "relative_frequency", relative_frequency)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="quasiIds")
    def quasi_ids(self) -> Sequence['outputs.GooglePrivacyDlpV2QuasiIdFieldResponse']:
        """
        Quasi-identifier columns.
        """
        return pulumi.get(self, "quasi_ids")

    @property
    @pulumi.getter(name="relativeFrequency")
    def relative_frequency(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        The relative frequency column must contain a floating-point number between 0 and 1 (inclusive). Null values are assumed to be zero.
        """
        return pulumi.get(self, "relative_frequency")

    @property
    @pulumi.getter
    def table(self) -> 'outputs.GooglePrivacyDlpV2BigQueryTableResponse':
        """
        Auxiliary table location.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class GooglePrivacyDlpV2BigQueryFieldResponse(dict):
    """
    Message defining a field of a BigQuery table.
    """
    def __init__(__self__, *,
                 field: 'outputs.GooglePrivacyDlpV2FieldIdResponse',
                 table: 'outputs.GooglePrivacyDlpV2BigQueryTableResponse'):
        """
        Message defining a field of a BigQuery table.
        :param 'GooglePrivacyDlpV2FieldIdResponse' field: Designated field in the BigQuery table.
        :param 'GooglePrivacyDlpV2BigQueryTableResponse' table: Source table of the field.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Designated field in the BigQuery table.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def table(self) -> 'outputs.GooglePrivacyDlpV2BigQueryTableResponse':
        """
        Source table of the field.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class GooglePrivacyDlpV2BigQueryOptionsResponse(dict):
    """
    Options defining BigQuery table and row identifiers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedFields":
            suggest = "excluded_fields"
        elif key == "identifyingFields":
            suggest = "identifying_fields"
        elif key == "includedFields":
            suggest = "included_fields"
        elif key == "rowsLimit":
            suggest = "rows_limit"
        elif key == "rowsLimitPercent":
            suggest = "rows_limit_percent"
        elif key == "sampleMethod":
            suggest = "sample_method"
        elif key == "tableReference":
            suggest = "table_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2BigQueryOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2BigQueryOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2BigQueryOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_fields: Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse'],
                 identifying_fields: Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse'],
                 included_fields: Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse'],
                 rows_limit: str,
                 rows_limit_percent: int,
                 sample_method: str,
                 table_reference: 'outputs.GooglePrivacyDlpV2BigQueryTableResponse'):
        """
        Options defining BigQuery table and row identifiers.
        :param Sequence['GooglePrivacyDlpV2FieldIdResponse'] excluded_fields: References to fields excluded from scanning. This allows you to skip inspection of entire columns which you know have no findings.
        :param Sequence['GooglePrivacyDlpV2FieldIdResponse'] identifying_fields: Table fields that may uniquely identify a row within the table. When `actions.saveFindings.outputConfig.table` is specified, the values of columns specified here are available in the output table under `location.content_locations.record_location.record_key.id_values`. Nested fields such as `person.birthdate.year` are allowed.
        :param Sequence['GooglePrivacyDlpV2FieldIdResponse'] included_fields: Limit scanning only to these fields.
        :param str rows_limit: Max number of rows to scan. If the table has more rows than this value, the rest of the rows are omitted. If not set, or if set to 0, all rows will be scanned. Only one of rows_limit and rows_limit_percent can be specified. Cannot be used in conjunction with TimespanConfig.
        :param int rows_limit_percent: Max percentage of rows to scan. The rest are omitted. The number of rows scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one of rows_limit and rows_limit_percent can be specified. Cannot be used in conjunction with TimespanConfig.
        :param 'GooglePrivacyDlpV2BigQueryTableResponse' table_reference: Complete BigQuery table reference.
        """
        pulumi.set(__self__, "excluded_fields", excluded_fields)
        pulumi.set(__self__, "identifying_fields", identifying_fields)
        pulumi.set(__self__, "included_fields", included_fields)
        pulumi.set(__self__, "rows_limit", rows_limit)
        pulumi.set(__self__, "rows_limit_percent", rows_limit_percent)
        pulumi.set(__self__, "sample_method", sample_method)
        pulumi.set(__self__, "table_reference", table_reference)

    @property
    @pulumi.getter(name="excludedFields")
    def excluded_fields(self) -> Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse']:
        """
        References to fields excluded from scanning. This allows you to skip inspection of entire columns which you know have no findings.
        """
        return pulumi.get(self, "excluded_fields")

    @property
    @pulumi.getter(name="identifyingFields")
    def identifying_fields(self) -> Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse']:
        """
        Table fields that may uniquely identify a row within the table. When `actions.saveFindings.outputConfig.table` is specified, the values of columns specified here are available in the output table under `location.content_locations.record_location.record_key.id_values`. Nested fields such as `person.birthdate.year` are allowed.
        """
        return pulumi.get(self, "identifying_fields")

    @property
    @pulumi.getter(name="includedFields")
    def included_fields(self) -> Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse']:
        """
        Limit scanning only to these fields.
        """
        return pulumi.get(self, "included_fields")

    @property
    @pulumi.getter(name="rowsLimit")
    def rows_limit(self) -> str:
        """
        Max number of rows to scan. If the table has more rows than this value, the rest of the rows are omitted. If not set, or if set to 0, all rows will be scanned. Only one of rows_limit and rows_limit_percent can be specified. Cannot be used in conjunction with TimespanConfig.
        """
        return pulumi.get(self, "rows_limit")

    @property
    @pulumi.getter(name="rowsLimitPercent")
    def rows_limit_percent(self) -> int:
        """
        Max percentage of rows to scan. The rest are omitted. The number of rows scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one of rows_limit and rows_limit_percent can be specified. Cannot be used in conjunction with TimespanConfig.
        """
        return pulumi.get(self, "rows_limit_percent")

    @property
    @pulumi.getter(name="sampleMethod")
    def sample_method(self) -> str:
        return pulumi.get(self, "sample_method")

    @property
    @pulumi.getter(name="tableReference")
    def table_reference(self) -> 'outputs.GooglePrivacyDlpV2BigQueryTableResponse':
        """
        Complete BigQuery table reference.
        """
        return pulumi.get(self, "table_reference")


@pulumi.output_type
class GooglePrivacyDlpV2BigQueryTableResponse(dict):
    """
    Message defining the location of a BigQuery table. A table is uniquely identified by its project_id, dataset_id, and table_name. Within a query a table is often referenced with a string in the format of: `:.` or `..`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2BigQueryTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2BigQueryTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2BigQueryTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project: str,
                 table_id: str):
        """
        Message defining the location of a BigQuery table. A table is uniquely identified by its project_id, dataset_id, and table_name. Within a query a table is often referenced with a string in the format of: `:.` or `..`.
        :param str dataset_id: Dataset ID of the table.
        :param str project: The Google Cloud Platform project ID of the project containing the table. If omitted, project ID is inferred from the API call.
        :param str table_id: Name of the table.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Dataset ID of the table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The Google Cloud Platform project ID of the project containing the table. If omitted, project ID is inferred from the API call.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        Name of the table.
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class GooglePrivacyDlpV2BucketResponse(dict):
    """
    Bucket is represented as a range, along with replacement values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replacementValue":
            suggest = "replacement_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2BucketResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2BucketResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2BucketResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max: 'outputs.GooglePrivacyDlpV2ValueResponse',
                 min: 'outputs.GooglePrivacyDlpV2ValueResponse',
                 replacement_value: 'outputs.GooglePrivacyDlpV2ValueResponse'):
        """
        Bucket is represented as a range, along with replacement values.
        :param 'GooglePrivacyDlpV2ValueResponse' max: Upper bound of the range, exclusive; type must match min.
        :param 'GooglePrivacyDlpV2ValueResponse' min: Lower bound of the range, inclusive. Type should be the same as max if used.
        :param 'GooglePrivacyDlpV2ValueResponse' replacement_value: Replacement value for this bucket.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "replacement_value", replacement_value)

    @property
    @pulumi.getter
    def max(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        Upper bound of the range, exclusive; type must match min.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        Lower bound of the range, inclusive. Type should be the same as max if used.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="replacementValue")
    def replacement_value(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        Replacement value for this bucket.
        """
        return pulumi.get(self, "replacement_value")


@pulumi.output_type
class GooglePrivacyDlpV2BucketingConfigResponse(dict):
    """
    Generalization function that buckets values based on ranges. The ranges and replacement values are dynamically provided by the user for custom behavior, such as 1-30 -> LOW 31-65 -> MEDIUM 66-100 -> HIGH This can be used on data of type: number, long, string, timestamp. If the bound `Value` type differs from the type of data being transformed, we will first attempt converting the type of the data to be transformed to match the type of the bound before comparing. See https://cloud.google.com/dlp/docs/concepts-bucketing to learn more.
    """
    def __init__(__self__, *,
                 buckets: Sequence['outputs.GooglePrivacyDlpV2BucketResponse']):
        """
        Generalization function that buckets values based on ranges. The ranges and replacement values are dynamically provided by the user for custom behavior, such as 1-30 -> LOW 31-65 -> MEDIUM 66-100 -> HIGH This can be used on data of type: number, long, string, timestamp. If the bound `Value` type differs from the type of data being transformed, we will first attempt converting the type of the data to be transformed to match the type of the bound before comparing. See https://cloud.google.com/dlp/docs/concepts-bucketing to learn more.
        :param Sequence['GooglePrivacyDlpV2BucketResponse'] buckets: Set of buckets. Ranges must be non-overlapping.
        """
        pulumi.set(__self__, "buckets", buckets)

    @property
    @pulumi.getter
    def buckets(self) -> Sequence['outputs.GooglePrivacyDlpV2BucketResponse']:
        """
        Set of buckets. Ranges must be non-overlapping.
        """
        return pulumi.get(self, "buckets")


@pulumi.output_type
class GooglePrivacyDlpV2CategoricalStatsConfigResponse(dict):
    """
    Compute numerical stats over an individual column, including number of distinct values and value count distribution.
    """
    def __init__(__self__, *,
                 field: 'outputs.GooglePrivacyDlpV2FieldIdResponse'):
        """
        Compute numerical stats over an individual column, including number of distinct values and value count distribution.
        :param 'GooglePrivacyDlpV2FieldIdResponse' field: Field to compute categorical stats on. All column types are supported except for arrays and structs. However, it may be more informative to use NumericalStats when the field type is supported, depending on the data.
        """
        pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Field to compute categorical stats on. All column types are supported except for arrays and structs. However, it may be more informative to use NumericalStats when the field type is supported, depending on the data.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class GooglePrivacyDlpV2CategoricalStatsHistogramBucketResponse(dict):
    """
    Histogram of value frequencies in the column.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketSize":
            suggest = "bucket_size"
        elif key == "bucketValueCount":
            suggest = "bucket_value_count"
        elif key == "bucketValues":
            suggest = "bucket_values"
        elif key == "valueFrequencyLowerBound":
            suggest = "value_frequency_lower_bound"
        elif key == "valueFrequencyUpperBound":
            suggest = "value_frequency_upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CategoricalStatsHistogramBucketResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CategoricalStatsHistogramBucketResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CategoricalStatsHistogramBucketResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_size: str,
                 bucket_value_count: str,
                 bucket_values: Sequence['outputs.GooglePrivacyDlpV2ValueFrequencyResponse'],
                 value_frequency_lower_bound: str,
                 value_frequency_upper_bound: str):
        """
        Histogram of value frequencies in the column.
        :param str bucket_size: Total number of values in this bucket.
        :param str bucket_value_count: Total number of distinct values in this bucket.
        :param Sequence['GooglePrivacyDlpV2ValueFrequencyResponse'] bucket_values: Sample of value frequencies in this bucket. The total number of values returned per bucket is capped at 20.
        :param str value_frequency_lower_bound: Lower bound on the value frequency of the values in this bucket.
        :param str value_frequency_upper_bound: Upper bound on the value frequency of the values in this bucket.
        """
        pulumi.set(__self__, "bucket_size", bucket_size)
        pulumi.set(__self__, "bucket_value_count", bucket_value_count)
        pulumi.set(__self__, "bucket_values", bucket_values)
        pulumi.set(__self__, "value_frequency_lower_bound", value_frequency_lower_bound)
        pulumi.set(__self__, "value_frequency_upper_bound", value_frequency_upper_bound)

    @property
    @pulumi.getter(name="bucketSize")
    def bucket_size(self) -> str:
        """
        Total number of values in this bucket.
        """
        return pulumi.get(self, "bucket_size")

    @property
    @pulumi.getter(name="bucketValueCount")
    def bucket_value_count(self) -> str:
        """
        Total number of distinct values in this bucket.
        """
        return pulumi.get(self, "bucket_value_count")

    @property
    @pulumi.getter(name="bucketValues")
    def bucket_values(self) -> Sequence['outputs.GooglePrivacyDlpV2ValueFrequencyResponse']:
        """
        Sample of value frequencies in this bucket. The total number of values returned per bucket is capped at 20.
        """
        return pulumi.get(self, "bucket_values")

    @property
    @pulumi.getter(name="valueFrequencyLowerBound")
    def value_frequency_lower_bound(self) -> str:
        """
        Lower bound on the value frequency of the values in this bucket.
        """
        return pulumi.get(self, "value_frequency_lower_bound")

    @property
    @pulumi.getter(name="valueFrequencyUpperBound")
    def value_frequency_upper_bound(self) -> str:
        """
        Upper bound on the value frequency of the values in this bucket.
        """
        return pulumi.get(self, "value_frequency_upper_bound")


@pulumi.output_type
class GooglePrivacyDlpV2CategoricalStatsResultResponse(dict):
    """
    Result of the categorical stats computation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrequencyHistogramBuckets":
            suggest = "value_frequency_histogram_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CategoricalStatsResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CategoricalStatsResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CategoricalStatsResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value_frequency_histogram_buckets: Sequence['outputs.GooglePrivacyDlpV2CategoricalStatsHistogramBucketResponse']):
        """
        Result of the categorical stats computation.
        :param Sequence['GooglePrivacyDlpV2CategoricalStatsHistogramBucketResponse'] value_frequency_histogram_buckets: Histogram of value frequencies in the column.
        """
        pulumi.set(__self__, "value_frequency_histogram_buckets", value_frequency_histogram_buckets)

    @property
    @pulumi.getter(name="valueFrequencyHistogramBuckets")
    def value_frequency_histogram_buckets(self) -> Sequence['outputs.GooglePrivacyDlpV2CategoricalStatsHistogramBucketResponse']:
        """
        Histogram of value frequencies in the column.
        """
        return pulumi.get(self, "value_frequency_histogram_buckets")


@pulumi.output_type
class GooglePrivacyDlpV2CharacterMaskConfigResponse(dict):
    """
    Partially mask a string by replacing a given number of characters with a fixed character. Masking can start from the beginning or end of the string. This can be used on data of any type (numbers, longs, and so on) and when de-identifying structured data we'll attempt to preserve the original data's type. (This allows you to take a long like 123 and modify it to a string like **3.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "charactersToIgnore":
            suggest = "characters_to_ignore"
        elif key == "maskingCharacter":
            suggest = "masking_character"
        elif key == "numberToMask":
            suggest = "number_to_mask"
        elif key == "reverseOrder":
            suggest = "reverse_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CharacterMaskConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CharacterMaskConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CharacterMaskConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 characters_to_ignore: Sequence['outputs.GooglePrivacyDlpV2CharsToIgnoreResponse'],
                 masking_character: str,
                 number_to_mask: int,
                 reverse_order: bool):
        """
        Partially mask a string by replacing a given number of characters with a fixed character. Masking can start from the beginning or end of the string. This can be used on data of any type (numbers, longs, and so on) and when de-identifying structured data we'll attempt to preserve the original data's type. (This allows you to take a long like 123 and modify it to a string like **3.
        :param Sequence['GooglePrivacyDlpV2CharsToIgnoreResponse'] characters_to_ignore: When masking a string, items in this list will be skipped when replacing characters. For example, if the input string is `555-555-5555` and you instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP returns `***-**5-5555`.
        :param str masking_character: Character to use to mask the sensitive values—for example, `*` for an alphabetic string such as a name, or `0` for a numeric string such as ZIP code or credit card number. This string must have a length of 1. If not supplied, this value defaults to `*` for strings, and `0` for digits.
        :param int number_to_mask: Number of characters to mask. If not set, all matching chars will be masked. Skipped characters do not count towards this tally.
        :param bool reverse_order: Mask characters in reverse order. For example, if `masking_character` is `0`, `number_to_mask` is `14`, and `reverse_order` is `false`, then the input string `1234-5678-9012-3456` is masked as `00000000000000-3456`. If `masking_character` is `*`, `number_to_mask` is `3`, and `reverse_order` is `true`, then the string `12345` is masked as `12***`.
        """
        pulumi.set(__self__, "characters_to_ignore", characters_to_ignore)
        pulumi.set(__self__, "masking_character", masking_character)
        pulumi.set(__self__, "number_to_mask", number_to_mask)
        pulumi.set(__self__, "reverse_order", reverse_order)

    @property
    @pulumi.getter(name="charactersToIgnore")
    def characters_to_ignore(self) -> Sequence['outputs.GooglePrivacyDlpV2CharsToIgnoreResponse']:
        """
        When masking a string, items in this list will be skipped when replacing characters. For example, if the input string is `555-555-5555` and you instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP returns `***-**5-5555`.
        """
        return pulumi.get(self, "characters_to_ignore")

    @property
    @pulumi.getter(name="maskingCharacter")
    def masking_character(self) -> str:
        """
        Character to use to mask the sensitive values—for example, `*` for an alphabetic string such as a name, or `0` for a numeric string such as ZIP code or credit card number. This string must have a length of 1. If not supplied, this value defaults to `*` for strings, and `0` for digits.
        """
        return pulumi.get(self, "masking_character")

    @property
    @pulumi.getter(name="numberToMask")
    def number_to_mask(self) -> int:
        """
        Number of characters to mask. If not set, all matching chars will be masked. Skipped characters do not count towards this tally.
        """
        return pulumi.get(self, "number_to_mask")

    @property
    @pulumi.getter(name="reverseOrder")
    def reverse_order(self) -> bool:
        """
        Mask characters in reverse order. For example, if `masking_character` is `0`, `number_to_mask` is `14`, and `reverse_order` is `false`, then the input string `1234-5678-9012-3456` is masked as `00000000000000-3456`. If `masking_character` is `*`, `number_to_mask` is `3`, and `reverse_order` is `true`, then the string `12345` is masked as `12***`.
        """
        return pulumi.get(self, "reverse_order")


@pulumi.output_type
class GooglePrivacyDlpV2CharsToIgnoreResponse(dict):
    """
    Characters to skip when doing deidentification of a value. These will be left alone and skipped.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "charactersToSkip":
            suggest = "characters_to_skip"
        elif key == "commonCharactersToIgnore":
            suggest = "common_characters_to_ignore"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CharsToIgnoreResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CharsToIgnoreResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CharsToIgnoreResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 characters_to_skip: str,
                 common_characters_to_ignore: str):
        """
        Characters to skip when doing deidentification of a value. These will be left alone and skipped.
        :param str characters_to_skip: Characters to not transform when masking.
        :param str common_characters_to_ignore: Common characters to not transform when masking. Useful to avoid removing punctuation.
        """
        pulumi.set(__self__, "characters_to_skip", characters_to_skip)
        pulumi.set(__self__, "common_characters_to_ignore", common_characters_to_ignore)

    @property
    @pulumi.getter(name="charactersToSkip")
    def characters_to_skip(self) -> str:
        """
        Characters to not transform when masking.
        """
        return pulumi.get(self, "characters_to_skip")

    @property
    @pulumi.getter(name="commonCharactersToIgnore")
    def common_characters_to_ignore(self) -> str:
        """
        Common characters to not transform when masking. Useful to avoid removing punctuation.
        """
        return pulumi.get(self, "common_characters_to_ignore")


@pulumi.output_type
class GooglePrivacyDlpV2CloudStorageFileSetResponse(dict):
    """
    Message representing a set of files in Cloud Storage.
    """
    def __init__(__self__, *,
                 url: str):
        """
        Message representing a set of files in Cloud Storage.
        :param str url: The url, in the format `gs:///`. Trailing wildcard in the path is allowed.
        """
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The url, in the format `gs:///`. Trailing wildcard in the path is allowed.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GooglePrivacyDlpV2CloudStorageOptionsResponse(dict):
    """
    Options defining a file or a set of files within a Google Cloud Storage bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bytesLimitPerFile":
            suggest = "bytes_limit_per_file"
        elif key == "bytesLimitPerFilePercent":
            suggest = "bytes_limit_per_file_percent"
        elif key == "fileSet":
            suggest = "file_set"
        elif key == "fileTypes":
            suggest = "file_types"
        elif key == "filesLimitPercent":
            suggest = "files_limit_percent"
        elif key == "sampleMethod":
            suggest = "sample_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CloudStorageOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CloudStorageOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CloudStorageOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bytes_limit_per_file: str,
                 bytes_limit_per_file_percent: int,
                 file_set: 'outputs.GooglePrivacyDlpV2FileSetResponse',
                 file_types: Sequence[str],
                 files_limit_percent: int,
                 sample_method: str):
        """
        Options defining a file or a set of files within a Google Cloud Storage bucket.
        :param str bytes_limit_per_file: Max number of bytes to scan from a file. If a scanned file's size is bigger than this value then the rest of the bytes are omitted. Only one of bytes_limit_per_file and bytes_limit_per_file_percent can be specified. Cannot be set if de-identification is requested.
        :param int bytes_limit_per_file_percent: Max percentage of bytes to scan from a file. The rest are omitted. The number of bytes scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one of bytes_limit_per_file and bytes_limit_per_file_percent can be specified. Cannot be set if de-identification is requested.
        :param 'GooglePrivacyDlpV2FileSetResponse' file_set: The set of one or more files to scan.
        :param Sequence[str] file_types: List of file type groups to include in the scan. If empty, all files are scanned and available data format processors are applied. In addition, the binary content of the selected files is always scanned as well. Images are scanned only as binary if the specified region does not support image inspection and no file_types were specified. Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
        :param int files_limit_percent: Limits the number of files to scan to this percentage of the input FileSet. Number of files scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults to 0.
        """
        pulumi.set(__self__, "bytes_limit_per_file", bytes_limit_per_file)
        pulumi.set(__self__, "bytes_limit_per_file_percent", bytes_limit_per_file_percent)
        pulumi.set(__self__, "file_set", file_set)
        pulumi.set(__self__, "file_types", file_types)
        pulumi.set(__self__, "files_limit_percent", files_limit_percent)
        pulumi.set(__self__, "sample_method", sample_method)

    @property
    @pulumi.getter(name="bytesLimitPerFile")
    def bytes_limit_per_file(self) -> str:
        """
        Max number of bytes to scan from a file. If a scanned file's size is bigger than this value then the rest of the bytes are omitted. Only one of bytes_limit_per_file and bytes_limit_per_file_percent can be specified. Cannot be set if de-identification is requested.
        """
        return pulumi.get(self, "bytes_limit_per_file")

    @property
    @pulumi.getter(name="bytesLimitPerFilePercent")
    def bytes_limit_per_file_percent(self) -> int:
        """
        Max percentage of bytes to scan from a file. The rest are omitted. The number of bytes scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one of bytes_limit_per_file and bytes_limit_per_file_percent can be specified. Cannot be set if de-identification is requested.
        """
        return pulumi.get(self, "bytes_limit_per_file_percent")

    @property
    @pulumi.getter(name="fileSet")
    def file_set(self) -> 'outputs.GooglePrivacyDlpV2FileSetResponse':
        """
        The set of one or more files to scan.
        """
        return pulumi.get(self, "file_set")

    @property
    @pulumi.getter(name="fileTypes")
    def file_types(self) -> Sequence[str]:
        """
        List of file type groups to include in the scan. If empty, all files are scanned and available data format processors are applied. In addition, the binary content of the selected files is always scanned as well. Images are scanned only as binary if the specified region does not support image inspection and no file_types were specified. Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
        """
        return pulumi.get(self, "file_types")

    @property
    @pulumi.getter(name="filesLimitPercent")
    def files_limit_percent(self) -> int:
        """
        Limits the number of files to scan to this percentage of the input FileSet. Number of files scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults to 0.
        """
        return pulumi.get(self, "files_limit_percent")

    @property
    @pulumi.getter(name="sampleMethod")
    def sample_method(self) -> str:
        return pulumi.get(self, "sample_method")


@pulumi.output_type
class GooglePrivacyDlpV2CloudStoragePathResponse(dict):
    """
    Message representing a single file or path in Cloud Storage.
    """
    def __init__(__self__, *,
                 path: str):
        """
        Message representing a single file or path in Cloud Storage.
        :param str path: A url representing a file or path (no wildcards) in Cloud Storage. Example: gs://[BUCKET_NAME]/dictionary.txt
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        A url representing a file or path (no wildcards) in Cloud Storage. Example: gs://[BUCKET_NAME]/dictionary.txt
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GooglePrivacyDlpV2CloudStorageRegexFileSetResponse(dict):
    """
    Message representing a set of files in a Cloud Storage bucket. Regular expressions are used to allow fine-grained control over which files in the bucket to include. Included files are those that match at least one item in `include_regex` and do not match any items in `exclude_regex`. Note that a file that matches items from both lists will _not_ be included. For a match to occur, the entire file path (i.e., everything in the url after the bucket name) must match the regular expression. For example, given the input `{bucket_name: "mybucket", include_regex: ["directory1/.*"], exclude_regex: ["directory1/excluded.*"]}`: * `gs://mybucket/directory1/myfile` will be included * `gs://mybucket/directory1/directory2/myfile` will be included (`.*` matches across `/`) * `gs://mybucket/directory0/directory1/myfile` will _not_ be included (the full path doesn't match any items in `include_regex`) * `gs://mybucket/directory1/excludedfile` will _not_ be included (the path matches an item in `exclude_regex`) If `include_regex` is left empty, it will match all files by default (this is equivalent to setting `include_regex: [".*"]`). Some other common use cases: * `{bucket_name: "mybucket", exclude_regex: [".*\.pdf"]}` will include all files in `mybucket` except for .pdf files * `{bucket_name: "mybucket", include_regex: ["directory/[^/]+"]}` will include all files directly under `gs://mybucket/directory/`, without matching across `/`
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "excludeRegex":
            suggest = "exclude_regex"
        elif key == "includeRegex":
            suggest = "include_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CloudStorageRegexFileSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CloudStorageRegexFileSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CloudStorageRegexFileSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 exclude_regex: Sequence[str],
                 include_regex: Sequence[str]):
        """
        Message representing a set of files in a Cloud Storage bucket. Regular expressions are used to allow fine-grained control over which files in the bucket to include. Included files are those that match at least one item in `include_regex` and do not match any items in `exclude_regex`. Note that a file that matches items from both lists will _not_ be included. For a match to occur, the entire file path (i.e., everything in the url after the bucket name) must match the regular expression. For example, given the input `{bucket_name: "mybucket", include_regex: ["directory1/.*"], exclude_regex: ["directory1/excluded.*"]}`: * `gs://mybucket/directory1/myfile` will be included * `gs://mybucket/directory1/directory2/myfile` will be included (`.*` matches across `/`) * `gs://mybucket/directory0/directory1/myfile` will _not_ be included (the full path doesn't match any items in `include_regex`) * `gs://mybucket/directory1/excludedfile` will _not_ be included (the path matches an item in `exclude_regex`) If `include_regex` is left empty, it will match all files by default (this is equivalent to setting `include_regex: [".*"]`). Some other common use cases: * `{bucket_name: "mybucket", exclude_regex: [".*\.pdf"]}` will include all files in `mybucket` except for .pdf files * `{bucket_name: "mybucket", include_regex: ["directory/[^/]+"]}` will include all files directly under `gs://mybucket/directory/`, without matching across `/`
        :param str bucket_name: The name of a Cloud Storage bucket. Required.
        :param Sequence[str] exclude_regex: A list of regular expressions matching file paths to exclude. All files in the bucket that match at least one of these regular expressions will be excluded from the scan. Regular expressions use RE2 [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found under the google/re2 repository on GitHub.
        :param Sequence[str] include_regex: A list of regular expressions matching file paths to include. All files in the bucket that match at least one of these regular expressions will be included in the set of files, except for those that also match an item in `exclude_regex`. Leaving this field empty will match all files by default (this is equivalent to including `.*` in the list). Regular expressions use RE2 [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found under the google/re2 repository on GitHub.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "exclude_regex", exclude_regex)
        pulumi.set(__self__, "include_regex", include_regex)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of a Cloud Storage bucket. Required.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="excludeRegex")
    def exclude_regex(self) -> Sequence[str]:
        """
        A list of regular expressions matching file paths to exclude. All files in the bucket that match at least one of these regular expressions will be excluded from the scan. Regular expressions use RE2 [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found under the google/re2 repository on GitHub.
        """
        return pulumi.get(self, "exclude_regex")

    @property
    @pulumi.getter(name="includeRegex")
    def include_regex(self) -> Sequence[str]:
        """
        A list of regular expressions matching file paths to include. All files in the bucket that match at least one of these regular expressions will be included in the set of files, except for those that also match an item in `exclude_regex`. Leaving this field empty will match all files by default (this is equivalent to including `.*` in the list). Regular expressions use RE2 [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found under the google/re2 repository on GitHub.
        """
        return pulumi.get(self, "include_regex")


@pulumi.output_type
class GooglePrivacyDlpV2ConditionResponse(dict):
    """
    The field type of `value` and `field` do not need to match to be considered equal, but not all comparisons are possible. EQUAL_TO and NOT_EQUAL_TO attempt to compare even with incompatible types, but all other comparisons are invalid with incompatible types. A `value` of type: - `string` can be compared against all other types - `boolean` can only be compared against other booleans - `integer` can be compared against doubles or a string if the string value can be parsed as an integer. - `double` can be compared against integers or a string if the string can be parsed as a double. - `Timestamp` can be compared against strings in RFC 3339 date string format. - `TimeOfDay` can be compared against timestamps and strings in the format of 'HH:mm:ss'. If we fail to compare do to type mismatch, a warning will be given and the condition will evaluate to false.
    """
    def __init__(__self__, *,
                 field: 'outputs.GooglePrivacyDlpV2FieldIdResponse',
                 operator: str,
                 value: 'outputs.GooglePrivacyDlpV2ValueResponse'):
        """
        The field type of `value` and `field` do not need to match to be considered equal, but not all comparisons are possible. EQUAL_TO and NOT_EQUAL_TO attempt to compare even with incompatible types, but all other comparisons are invalid with incompatible types. A `value` of type: - `string` can be compared against all other types - `boolean` can only be compared against other booleans - `integer` can be compared against doubles or a string if the string value can be parsed as an integer. - `double` can be compared against integers or a string if the string can be parsed as a double. - `Timestamp` can be compared against strings in RFC 3339 date string format. - `TimeOfDay` can be compared against timestamps and strings in the format of 'HH:mm:ss'. If we fail to compare do to type mismatch, a warning will be given and the condition will evaluate to false.
        :param 'GooglePrivacyDlpV2FieldIdResponse' field: Field within the record this condition is evaluated against.
        :param str operator: Operator used to compare the field or infoType to the value.
        :param 'GooglePrivacyDlpV2ValueResponse' value: Value to compare against. [Mandatory, except for `EXISTS` tests.]
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Field within the record this condition is evaluated against.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Operator used to compare the field or infoType to the value.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        Value to compare against. [Mandatory, except for `EXISTS` tests.]
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GooglePrivacyDlpV2ConditionsResponse(dict):
    """
    A collection of conditions.
    """
    def __init__(__self__, *,
                 conditions: Sequence['outputs.GooglePrivacyDlpV2ConditionResponse']):
        """
        A collection of conditions.
        :param Sequence['GooglePrivacyDlpV2ConditionResponse'] conditions: A collection of conditions.
        """
        pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GooglePrivacyDlpV2ConditionResponse']:
        """
        A collection of conditions.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class GooglePrivacyDlpV2CryptoDeterministicConfigResponse(dict):
    """
    Pseudonymization method that generates deterministic encryption for the given input. Outputs a base64 encoded representation of the encrypted output. Uses AES-SIV based on the RFC https://tools.ietf.org/html/rfc5297.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cryptoKey":
            suggest = "crypto_key"
        elif key == "surrogateInfoType":
            suggest = "surrogate_info_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CryptoDeterministicConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CryptoDeterministicConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CryptoDeterministicConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context: 'outputs.GooglePrivacyDlpV2FieldIdResponse',
                 crypto_key: 'outputs.GooglePrivacyDlpV2CryptoKeyResponse',
                 surrogate_info_type: 'outputs.GooglePrivacyDlpV2InfoTypeResponse'):
        """
        Pseudonymization method that generates deterministic encryption for the given input. Outputs a base64 encoded representation of the encrypted output. Uses AES-SIV based on the RFC https://tools.ietf.org/html/rfc5297.
        :param 'GooglePrivacyDlpV2FieldIdResponse' context: A context may be used for higher security and maintaining referential integrity such that the same identifier in two different contexts will be given a distinct surrogate. The context is appended to plaintext value being encrypted. On decryption the provided context is validated against the value used during encryption. If a context was provided during encryption, same context must be provided during decryption as well. If the context is not set, plaintext would be used as is for encryption. If the context is set but: 1. there is no record present when transforming a given value or 2. the field is not present when transforming a given value, plaintext would be used as is for encryption. Note that case (1) is expected when an `InfoTypeTransformation` is applied to both structured and non-structured `ContentItem`s.
        :param 'GooglePrivacyDlpV2CryptoKeyResponse' crypto_key: The key used by the encryption function. For deterministic encryption using AES-SIV, the provided key is internally expanded to 64 bytes prior to use.
        :param 'GooglePrivacyDlpV2InfoTypeResponse' surrogate_info_type: The custom info type to annotate the surrogate with. This annotation will be applied to the surrogate by prefixing it with the name of the custom info type followed by the number of characters comprising the surrogate. The following scheme defines the format: {info type name}({surrogate character count}):{surrogate} For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and the surrogate is 'abc', the full replacement value will be: 'MY_TOKEN_INFO_TYPE(3):abc' This annotation identifies the surrogate when inspecting content using the custom info type 'Surrogate'. This facilitates reversal of the surrogate when it occurs in free text. Note: For record transformations where the entire cell in a table is being transformed, surrogates are not mandatory. Surrogates are used to denote the location of the token and are necessary for re-identification in free form text. In order for inspection to work properly, the name of this info type must not occur naturally anywhere in your data; otherwise, inspection may either - reverse a surrogate that does not correspond to an actual identifier - be unable to parse the surrogate and result in an error Therefore, choose your custom info type name carefully after considering what your data looks like. One way to select a name that has a high chance of yielding reliable detection is to include one or more unicode characters that are highly improbable to exist in your data. For example, assuming your data is entered from a regular ASCII keyboard, the symbol with the hex code point 29DD might be used like so: ⧝MY_TOKEN_TYPE.
        """
        pulumi.set(__self__, "context", context)
        pulumi.set(__self__, "crypto_key", crypto_key)
        pulumi.set(__self__, "surrogate_info_type", surrogate_info_type)

    @property
    @pulumi.getter
    def context(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        A context may be used for higher security and maintaining referential integrity such that the same identifier in two different contexts will be given a distinct surrogate. The context is appended to plaintext value being encrypted. On decryption the provided context is validated against the value used during encryption. If a context was provided during encryption, same context must be provided during decryption as well. If the context is not set, plaintext would be used as is for encryption. If the context is set but: 1. there is no record present when transforming a given value or 2. the field is not present when transforming a given value, plaintext would be used as is for encryption. Note that case (1) is expected when an `InfoTypeTransformation` is applied to both structured and non-structured `ContentItem`s.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> 'outputs.GooglePrivacyDlpV2CryptoKeyResponse':
        """
        The key used by the encryption function. For deterministic encryption using AES-SIV, the provided key is internally expanded to 64 bytes prior to use.
        """
        return pulumi.get(self, "crypto_key")

    @property
    @pulumi.getter(name="surrogateInfoType")
    def surrogate_info_type(self) -> 'outputs.GooglePrivacyDlpV2InfoTypeResponse':
        """
        The custom info type to annotate the surrogate with. This annotation will be applied to the surrogate by prefixing it with the name of the custom info type followed by the number of characters comprising the surrogate. The following scheme defines the format: {info type name}({surrogate character count}):{surrogate} For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and the surrogate is 'abc', the full replacement value will be: 'MY_TOKEN_INFO_TYPE(3):abc' This annotation identifies the surrogate when inspecting content using the custom info type 'Surrogate'. This facilitates reversal of the surrogate when it occurs in free text. Note: For record transformations where the entire cell in a table is being transformed, surrogates are not mandatory. Surrogates are used to denote the location of the token and are necessary for re-identification in free form text. In order for inspection to work properly, the name of this info type must not occur naturally anywhere in your data; otherwise, inspection may either - reverse a surrogate that does not correspond to an actual identifier - be unable to parse the surrogate and result in an error Therefore, choose your custom info type name carefully after considering what your data looks like. One way to select a name that has a high chance of yielding reliable detection is to include one or more unicode characters that are highly improbable to exist in your data. For example, assuming your data is entered from a regular ASCII keyboard, the symbol with the hex code point 29DD might be used like so: ⧝MY_TOKEN_TYPE.
        """
        return pulumi.get(self, "surrogate_info_type")


@pulumi.output_type
class GooglePrivacyDlpV2CryptoHashConfigResponse(dict):
    """
    Pseudonymization method that generates surrogates via cryptographic hashing. Uses SHA-256. The key size must be either 32 or 64 bytes. Outputs a base64 encoded representation of the hashed output (for example, L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=). Currently, only string and integer values can be hashed. See https://cloud.google.com/dlp/docs/pseudonymization to learn more.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cryptoKey":
            suggest = "crypto_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CryptoHashConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CryptoHashConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CryptoHashConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crypto_key: 'outputs.GooglePrivacyDlpV2CryptoKeyResponse'):
        """
        Pseudonymization method that generates surrogates via cryptographic hashing. Uses SHA-256. The key size must be either 32 or 64 bytes. Outputs a base64 encoded representation of the hashed output (for example, L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=). Currently, only string and integer values can be hashed. See https://cloud.google.com/dlp/docs/pseudonymization to learn more.
        :param 'GooglePrivacyDlpV2CryptoKeyResponse' crypto_key: The key used by the hash function.
        """
        pulumi.set(__self__, "crypto_key", crypto_key)

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> 'outputs.GooglePrivacyDlpV2CryptoKeyResponse':
        """
        The key used by the hash function.
        """
        return pulumi.get(self, "crypto_key")


@pulumi.output_type
class GooglePrivacyDlpV2CryptoKeyResponse(dict):
    """
    This is a data encryption key (DEK) (as opposed to a key encryption key (KEK) stored by Cloud Key Management Service (Cloud KMS). When using Cloud KMS to wrap or unwrap a DEK, be sure to set an appropriate IAM policy on the KEK to ensure an attacker cannot unwrap the DEK.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsWrapped":
            suggest = "kms_wrapped"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CryptoKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CryptoKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CryptoKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_wrapped: 'outputs.GooglePrivacyDlpV2KmsWrappedCryptoKeyResponse',
                 transient: 'outputs.GooglePrivacyDlpV2TransientCryptoKeyResponse',
                 unwrapped: 'outputs.GooglePrivacyDlpV2UnwrappedCryptoKeyResponse'):
        """
        This is a data encryption key (DEK) (as opposed to a key encryption key (KEK) stored by Cloud Key Management Service (Cloud KMS). When using Cloud KMS to wrap or unwrap a DEK, be sure to set an appropriate IAM policy on the KEK to ensure an attacker cannot unwrap the DEK.
        :param 'GooglePrivacyDlpV2KmsWrappedCryptoKeyResponse' kms_wrapped: Key wrapped using Cloud KMS
        :param 'GooglePrivacyDlpV2TransientCryptoKeyResponse' transient: Transient crypto key
        :param 'GooglePrivacyDlpV2UnwrappedCryptoKeyResponse' unwrapped: Unwrapped crypto key
        """
        pulumi.set(__self__, "kms_wrapped", kms_wrapped)
        pulumi.set(__self__, "transient", transient)
        pulumi.set(__self__, "unwrapped", unwrapped)

    @property
    @pulumi.getter(name="kmsWrapped")
    def kms_wrapped(self) -> 'outputs.GooglePrivacyDlpV2KmsWrappedCryptoKeyResponse':
        """
        Key wrapped using Cloud KMS
        """
        return pulumi.get(self, "kms_wrapped")

    @property
    @pulumi.getter
    def transient(self) -> 'outputs.GooglePrivacyDlpV2TransientCryptoKeyResponse':
        """
        Transient crypto key
        """
        return pulumi.get(self, "transient")

    @property
    @pulumi.getter
    def unwrapped(self) -> 'outputs.GooglePrivacyDlpV2UnwrappedCryptoKeyResponse':
        """
        Unwrapped crypto key
        """
        return pulumi.get(self, "unwrapped")


@pulumi.output_type
class GooglePrivacyDlpV2CryptoReplaceFfxFpeConfigResponse(dict):
    """
    Replaces an identifier with a surrogate using Format Preserving Encryption (FPE) with the FFX mode of operation; however when used in the `ReidentifyContent` API method, it serves the opposite function by reversing the surrogate back into the original identifier. The identifier must be encoded as ASCII. For a given crypto key and context, the same identifier will be replaced with the same surrogate. Identifiers must be at least two characters long. In the case that the identifier is the empty string, it will be skipped. See https://cloud.google.com/dlp/docs/pseudonymization to learn more. Note: We recommend using CryptoDeterministicConfig for all use cases which do not require preserving the input alphabet space and size, plus warrant referential integrity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonAlphabet":
            suggest = "common_alphabet"
        elif key == "cryptoKey":
            suggest = "crypto_key"
        elif key == "customAlphabet":
            suggest = "custom_alphabet"
        elif key == "surrogateInfoType":
            suggest = "surrogate_info_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CryptoReplaceFfxFpeConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CryptoReplaceFfxFpeConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CryptoReplaceFfxFpeConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_alphabet: str,
                 context: 'outputs.GooglePrivacyDlpV2FieldIdResponse',
                 crypto_key: 'outputs.GooglePrivacyDlpV2CryptoKeyResponse',
                 custom_alphabet: str,
                 radix: int,
                 surrogate_info_type: 'outputs.GooglePrivacyDlpV2InfoTypeResponse'):
        """
        Replaces an identifier with a surrogate using Format Preserving Encryption (FPE) with the FFX mode of operation; however when used in the `ReidentifyContent` API method, it serves the opposite function by reversing the surrogate back into the original identifier. The identifier must be encoded as ASCII. For a given crypto key and context, the same identifier will be replaced with the same surrogate. Identifiers must be at least two characters long. In the case that the identifier is the empty string, it will be skipped. See https://cloud.google.com/dlp/docs/pseudonymization to learn more. Note: We recommend using CryptoDeterministicConfig for all use cases which do not require preserving the input alphabet space and size, plus warrant referential integrity.
        :param str common_alphabet: Common alphabets.
        :param 'GooglePrivacyDlpV2FieldIdResponse' context: The 'tweak', a context may be used for higher security since the same identifier in two different contexts won't be given the same surrogate. If the context is not set, a default tweak will be used. If the context is set but: 1. there is no record present when transforming a given value or 1. the field is not present when transforming a given value, a default tweak will be used. Note that case (1) is expected when an `InfoTypeTransformation` is applied to both structured and non-structured `ContentItem`s. Currently, the referenced field may be of value type integer or string. The tweak is constructed as a sequence of bytes in big endian byte order such that: - a 64 bit integer is encoded followed by a single byte of value 1 - a string is encoded in UTF-8 format followed by a single byte of value 2
        :param 'GooglePrivacyDlpV2CryptoKeyResponse' crypto_key: The key used by the encryption algorithm.
        :param str custom_alphabet: This is supported by mapping these to the alphanumeric characters that the FFX mode natively supports. This happens before/after encryption/decryption. Each character listed must appear only once. Number of characters must be in the range [2, 95]. This must be encoded as ASCII. The order of characters does not matter. The full list of allowed characters is: 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz ~`!@#$%^&*()_-+={[}]|\:;"'<,>.?/
        :param int radix: The native way to select the alphabet. Must be in the range [2, 95].
        :param 'GooglePrivacyDlpV2InfoTypeResponse' surrogate_info_type: The custom infoType to annotate the surrogate with. This annotation will be applied to the surrogate by prefixing it with the name of the custom infoType followed by the number of characters comprising the surrogate. The following scheme defines the format: info_type_name(surrogate_character_count):surrogate For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and the surrogate is 'abc', the full replacement value will be: 'MY_TOKEN_INFO_TYPE(3):abc' This annotation identifies the surrogate when inspecting content using the custom infoType [`SurrogateType`](https://cloud.google.com/dlp/docs/reference/rest/v2/InspectConfig#surrogatetype). This facilitates reversal of the surrogate when it occurs in free text. In order for inspection to work properly, the name of this infoType must not occur naturally anywhere in your data; otherwise, inspection may find a surrogate that does not correspond to an actual identifier. Therefore, choose your custom infoType name carefully after considering what your data looks like. One way to select a name that has a high chance of yielding reliable detection is to include one or more unicode characters that are highly improbable to exist in your data. For example, assuming your data is entered from a regular ASCII keyboard, the symbol with the hex code point 29DD might be used like so: ⧝MY_TOKEN_TYPE
        """
        pulumi.set(__self__, "common_alphabet", common_alphabet)
        pulumi.set(__self__, "context", context)
        pulumi.set(__self__, "crypto_key", crypto_key)
        pulumi.set(__self__, "custom_alphabet", custom_alphabet)
        pulumi.set(__self__, "radix", radix)
        pulumi.set(__self__, "surrogate_info_type", surrogate_info_type)

    @property
    @pulumi.getter(name="commonAlphabet")
    def common_alphabet(self) -> str:
        """
        Common alphabets.
        """
        return pulumi.get(self, "common_alphabet")

    @property
    @pulumi.getter
    def context(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        The 'tweak', a context may be used for higher security since the same identifier in two different contexts won't be given the same surrogate. If the context is not set, a default tweak will be used. If the context is set but: 1. there is no record present when transforming a given value or 1. the field is not present when transforming a given value, a default tweak will be used. Note that case (1) is expected when an `InfoTypeTransformation` is applied to both structured and non-structured `ContentItem`s. Currently, the referenced field may be of value type integer or string. The tweak is constructed as a sequence of bytes in big endian byte order such that: - a 64 bit integer is encoded followed by a single byte of value 1 - a string is encoded in UTF-8 format followed by a single byte of value 2
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> 'outputs.GooglePrivacyDlpV2CryptoKeyResponse':
        """
        The key used by the encryption algorithm.
        """
        return pulumi.get(self, "crypto_key")

    @property
    @pulumi.getter(name="customAlphabet")
    def custom_alphabet(self) -> str:
        """
        This is supported by mapping these to the alphanumeric characters that the FFX mode natively supports. This happens before/after encryption/decryption. Each character listed must appear only once. Number of characters must be in the range [2, 95]. This must be encoded as ASCII. The order of characters does not matter. The full list of allowed characters is: 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz ~`!@#$%^&*()_-+={[}]|\:;"'<,>.?/
        """
        return pulumi.get(self, "custom_alphabet")

    @property
    @pulumi.getter
    def radix(self) -> int:
        """
        The native way to select the alphabet. Must be in the range [2, 95].
        """
        return pulumi.get(self, "radix")

    @property
    @pulumi.getter(name="surrogateInfoType")
    def surrogate_info_type(self) -> 'outputs.GooglePrivacyDlpV2InfoTypeResponse':
        """
        The custom infoType to annotate the surrogate with. This annotation will be applied to the surrogate by prefixing it with the name of the custom infoType followed by the number of characters comprising the surrogate. The following scheme defines the format: info_type_name(surrogate_character_count):surrogate For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and the surrogate is 'abc', the full replacement value will be: 'MY_TOKEN_INFO_TYPE(3):abc' This annotation identifies the surrogate when inspecting content using the custom infoType [`SurrogateType`](https://cloud.google.com/dlp/docs/reference/rest/v2/InspectConfig#surrogatetype). This facilitates reversal of the surrogate when it occurs in free text. In order for inspection to work properly, the name of this infoType must not occur naturally anywhere in your data; otherwise, inspection may find a surrogate that does not correspond to an actual identifier. Therefore, choose your custom infoType name carefully after considering what your data looks like. One way to select a name that has a high chance of yielding reliable detection is to include one or more unicode characters that are highly improbable to exist in your data. For example, assuming your data is entered from a regular ASCII keyboard, the symbol with the hex code point 29DD might be used like so: ⧝MY_TOKEN_TYPE
        """
        return pulumi.get(self, "surrogate_info_type")


@pulumi.output_type
class GooglePrivacyDlpV2CustomInfoTypeResponse(dict):
    """
    Custom information type provided by the user. Used to find domain-specific sensitive information configurable to the data in question.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectionRules":
            suggest = "detection_rules"
        elif key == "exclusionType":
            suggest = "exclusion_type"
        elif key == "infoType":
            suggest = "info_type"
        elif key == "storedType":
            suggest = "stored_type"
        elif key == "surrogateType":
            suggest = "surrogate_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2CustomInfoTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2CustomInfoTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2CustomInfoTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detection_rules: Sequence['outputs.GooglePrivacyDlpV2DetectionRuleResponse'],
                 dictionary: 'outputs.GooglePrivacyDlpV2DictionaryResponse',
                 exclusion_type: str,
                 info_type: 'outputs.GooglePrivacyDlpV2InfoTypeResponse',
                 likelihood: str,
                 regex: 'outputs.GooglePrivacyDlpV2RegexResponse',
                 stored_type: 'outputs.GooglePrivacyDlpV2StoredTypeResponse',
                 surrogate_type: 'outputs.GooglePrivacyDlpV2SurrogateTypeResponse'):
        """
        Custom information type provided by the user. Used to find domain-specific sensitive information configurable to the data in question.
        :param Sequence['GooglePrivacyDlpV2DetectionRuleResponse'] detection_rules: Set of detection rules to apply to all findings of this CustomInfoType. Rules are applied in order that they are specified. Not supported for the `surrogate_type` CustomInfoType.
        :param 'GooglePrivacyDlpV2DictionaryResponse' dictionary: A list of phrases to detect as a CustomInfoType.
        :param str exclusion_type: If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding to be returned. It still can be used for rules matching.
        :param 'GooglePrivacyDlpV2InfoTypeResponse' info_type: CustomInfoType can either be a new infoType, or an extension of built-in infoType, when the name matches one of existing infoTypes and that infoType is specified in `InspectContent.info_types` field. Specifying the latter adds findings to the one detected by the system. If built-in info type is not specified in `InspectContent.info_types` list then the name is treated as a custom info type.
        :param str likelihood: Likelihood to return for this CustomInfoType. This base value can be altered by a detection rule if the finding meets the criteria specified by the rule. Defaults to `VERY_LIKELY` if not specified.
        :param 'GooglePrivacyDlpV2RegexResponse' regex: Regular expression based CustomInfoType.
        :param 'GooglePrivacyDlpV2StoredTypeResponse' stored_type: Load an existing `StoredInfoType` resource for use in `InspectDataSource`. Not currently supported in `InspectContent`.
        :param 'GooglePrivacyDlpV2SurrogateTypeResponse' surrogate_type: Message for detecting output from deidentification transformations that support reversing.
        """
        pulumi.set(__self__, "detection_rules", detection_rules)
        pulumi.set(__self__, "dictionary", dictionary)
        pulumi.set(__self__, "exclusion_type", exclusion_type)
        pulumi.set(__self__, "info_type", info_type)
        pulumi.set(__self__, "likelihood", likelihood)
        pulumi.set(__self__, "regex", regex)
        pulumi.set(__self__, "stored_type", stored_type)
        pulumi.set(__self__, "surrogate_type", surrogate_type)

    @property
    @pulumi.getter(name="detectionRules")
    def detection_rules(self) -> Sequence['outputs.GooglePrivacyDlpV2DetectionRuleResponse']:
        """
        Set of detection rules to apply to all findings of this CustomInfoType. Rules are applied in order that they are specified. Not supported for the `surrogate_type` CustomInfoType.
        """
        return pulumi.get(self, "detection_rules")

    @property
    @pulumi.getter
    def dictionary(self) -> 'outputs.GooglePrivacyDlpV2DictionaryResponse':
        """
        A list of phrases to detect as a CustomInfoType.
        """
        return pulumi.get(self, "dictionary")

    @property
    @pulumi.getter(name="exclusionType")
    def exclusion_type(self) -> str:
        """
        If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding to be returned. It still can be used for rules matching.
        """
        return pulumi.get(self, "exclusion_type")

    @property
    @pulumi.getter(name="infoType")
    def info_type(self) -> 'outputs.GooglePrivacyDlpV2InfoTypeResponse':
        """
        CustomInfoType can either be a new infoType, or an extension of built-in infoType, when the name matches one of existing infoTypes and that infoType is specified in `InspectContent.info_types` field. Specifying the latter adds findings to the one detected by the system. If built-in info type is not specified in `InspectContent.info_types` list then the name is treated as a custom info type.
        """
        return pulumi.get(self, "info_type")

    @property
    @pulumi.getter
    def likelihood(self) -> str:
        """
        Likelihood to return for this CustomInfoType. This base value can be altered by a detection rule if the finding meets the criteria specified by the rule. Defaults to `VERY_LIKELY` if not specified.
        """
        return pulumi.get(self, "likelihood")

    @property
    @pulumi.getter
    def regex(self) -> 'outputs.GooglePrivacyDlpV2RegexResponse':
        """
        Regular expression based CustomInfoType.
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter(name="storedType")
    def stored_type(self) -> 'outputs.GooglePrivacyDlpV2StoredTypeResponse':
        """
        Load an existing `StoredInfoType` resource for use in `InspectDataSource`. Not currently supported in `InspectContent`.
        """
        return pulumi.get(self, "stored_type")

    @property
    @pulumi.getter(name="surrogateType")
    def surrogate_type(self) -> 'outputs.GooglePrivacyDlpV2SurrogateTypeResponse':
        """
        Message for detecting output from deidentification transformations that support reversing.
        """
        return pulumi.get(self, "surrogate_type")


@pulumi.output_type
class GooglePrivacyDlpV2DatastoreOptionsResponse(dict):
    """
    Options defining a data set within Google Cloud Datastore.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionId":
            suggest = "partition_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2DatastoreOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2DatastoreOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2DatastoreOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: 'outputs.GooglePrivacyDlpV2KindExpressionResponse',
                 partition_id: 'outputs.GooglePrivacyDlpV2PartitionIdResponse'):
        """
        Options defining a data set within Google Cloud Datastore.
        :param 'GooglePrivacyDlpV2KindExpressionResponse' kind: The kind to process.
        :param 'GooglePrivacyDlpV2PartitionIdResponse' partition_id: A partition ID identifies a grouping of entities. The grouping is always by project and namespace, however the namespace ID may be empty.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "partition_id", partition_id)

    @property
    @pulumi.getter
    def kind(self) -> 'outputs.GooglePrivacyDlpV2KindExpressionResponse':
        """
        The kind to process.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="partitionId")
    def partition_id(self) -> 'outputs.GooglePrivacyDlpV2PartitionIdResponse':
        """
        A partition ID identifies a grouping of entities. The grouping is always by project and namespace, however the namespace ID may be empty.
        """
        return pulumi.get(self, "partition_id")


@pulumi.output_type
class GooglePrivacyDlpV2DateShiftConfigResponse(dict):
    """
    Shifts dates by random number of days, with option to be consistent for the same context. See https://cloud.google.com/dlp/docs/concepts-date-shifting to learn more.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cryptoKey":
            suggest = "crypto_key"
        elif key == "lowerBoundDays":
            suggest = "lower_bound_days"
        elif key == "upperBoundDays":
            suggest = "upper_bound_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2DateShiftConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2DateShiftConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2DateShiftConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context: 'outputs.GooglePrivacyDlpV2FieldIdResponse',
                 crypto_key: 'outputs.GooglePrivacyDlpV2CryptoKeyResponse',
                 lower_bound_days: int,
                 upper_bound_days: int):
        """
        Shifts dates by random number of days, with option to be consistent for the same context. See https://cloud.google.com/dlp/docs/concepts-date-shifting to learn more.
        :param 'GooglePrivacyDlpV2FieldIdResponse' context: Points to the field that contains the context, for example, an entity id. If set, must also set cryptoKey. If set, shift will be consistent for the given context.
        :param 'GooglePrivacyDlpV2CryptoKeyResponse' crypto_key: Causes the shift to be computed based on this key and the context. This results in the same shift for the same context and crypto_key. If set, must also set context. Can only be applied to table items.
        :param int lower_bound_days: For example, -5 means shift date to at most 5 days back in the past.
        :param int upper_bound_days: Range of shift in days. Actual shift will be selected at random within this range (inclusive ends). Negative means shift to earlier in time. Must not be more than 365250 days (1000 years) each direction. For example, 3 means shift date to at most 3 days into the future.
        """
        pulumi.set(__self__, "context", context)
        pulumi.set(__self__, "crypto_key", crypto_key)
        pulumi.set(__self__, "lower_bound_days", lower_bound_days)
        pulumi.set(__self__, "upper_bound_days", upper_bound_days)

    @property
    @pulumi.getter
    def context(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Points to the field that contains the context, for example, an entity id. If set, must also set cryptoKey. If set, shift will be consistent for the given context.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> 'outputs.GooglePrivacyDlpV2CryptoKeyResponse':
        """
        Causes the shift to be computed based on this key and the context. This results in the same shift for the same context and crypto_key. If set, must also set context. Can only be applied to table items.
        """
        return pulumi.get(self, "crypto_key")

    @property
    @pulumi.getter(name="lowerBoundDays")
    def lower_bound_days(self) -> int:
        """
        For example, -5 means shift date to at most 5 days back in the past.
        """
        return pulumi.get(self, "lower_bound_days")

    @property
    @pulumi.getter(name="upperBoundDays")
    def upper_bound_days(self) -> int:
        """
        Range of shift in days. Actual shift will be selected at random within this range (inclusive ends). Negative means shift to earlier in time. Must not be more than 365250 days (1000 years) each direction. For example, 3 means shift date to at most 3 days into the future.
        """
        return pulumi.get(self, "upper_bound_days")


@pulumi.output_type
class GooglePrivacyDlpV2DeidentifyConfigResponse(dict):
    """
    The configuration that controls how the data will change.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infoTypeTransformations":
            suggest = "info_type_transformations"
        elif key == "recordTransformations":
            suggest = "record_transformations"
        elif key == "transformationErrorHandling":
            suggest = "transformation_error_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2DeidentifyConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2DeidentifyConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2DeidentifyConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 info_type_transformations: 'outputs.GooglePrivacyDlpV2InfoTypeTransformationsResponse',
                 record_transformations: 'outputs.GooglePrivacyDlpV2RecordTransformationsResponse',
                 transformation_error_handling: 'outputs.GooglePrivacyDlpV2TransformationErrorHandlingResponse'):
        """
        The configuration that controls how the data will change.
        :param 'GooglePrivacyDlpV2InfoTypeTransformationsResponse' info_type_transformations: Treat the dataset as free-form text and apply the same free text transformation everywhere.
        :param 'GooglePrivacyDlpV2RecordTransformationsResponse' record_transformations: Treat the dataset as structured. Transformations can be applied to specific locations within structured datasets, such as transforming a column within a table.
        :param 'GooglePrivacyDlpV2TransformationErrorHandlingResponse' transformation_error_handling: Mode for handling transformation errors. If left unspecified, the default mode is `TransformationErrorHandling.ThrowError`.
        """
        pulumi.set(__self__, "info_type_transformations", info_type_transformations)
        pulumi.set(__self__, "record_transformations", record_transformations)
        pulumi.set(__self__, "transformation_error_handling", transformation_error_handling)

    @property
    @pulumi.getter(name="infoTypeTransformations")
    def info_type_transformations(self) -> 'outputs.GooglePrivacyDlpV2InfoTypeTransformationsResponse':
        """
        Treat the dataset as free-form text and apply the same free text transformation everywhere.
        """
        return pulumi.get(self, "info_type_transformations")

    @property
    @pulumi.getter(name="recordTransformations")
    def record_transformations(self) -> 'outputs.GooglePrivacyDlpV2RecordTransformationsResponse':
        """
        Treat the dataset as structured. Transformations can be applied to specific locations within structured datasets, such as transforming a column within a table.
        """
        return pulumi.get(self, "record_transformations")

    @property
    @pulumi.getter(name="transformationErrorHandling")
    def transformation_error_handling(self) -> 'outputs.GooglePrivacyDlpV2TransformationErrorHandlingResponse':
        """
        Mode for handling transformation errors. If left unspecified, the default mode is `TransformationErrorHandling.ThrowError`.
        """
        return pulumi.get(self, "transformation_error_handling")


@pulumi.output_type
class GooglePrivacyDlpV2DeltaPresenceEstimationConfigResponse(dict):
    """
    δ-presence metric, used to estimate how likely it is for an attacker to figure out that one given individual appears in a de-identified dataset. Similarly to the k-map metric, we cannot compute δ-presence exactly without knowing the attack dataset, so we use a statistical model instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auxiliaryTables":
            suggest = "auxiliary_tables"
        elif key == "quasiIds":
            suggest = "quasi_ids"
        elif key == "regionCode":
            suggest = "region_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2DeltaPresenceEstimationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2DeltaPresenceEstimationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2DeltaPresenceEstimationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auxiliary_tables: Sequence['outputs.GooglePrivacyDlpV2StatisticalTableResponse'],
                 quasi_ids: Sequence['outputs.GooglePrivacyDlpV2QuasiIdResponse'],
                 region_code: str):
        """
        δ-presence metric, used to estimate how likely it is for an attacker to figure out that one given individual appears in a de-identified dataset. Similarly to the k-map metric, we cannot compute δ-presence exactly without knowing the attack dataset, so we use a statistical model instead.
        :param Sequence['GooglePrivacyDlpV2StatisticalTableResponse'] auxiliary_tables: Several auxiliary tables can be used in the analysis. Each custom_tag used to tag a quasi-identifiers field must appear in exactly one field of one auxiliary table.
        :param Sequence['GooglePrivacyDlpV2QuasiIdResponse'] quasi_ids: Fields considered to be quasi-identifiers. No two fields can have the same tag.
        :param str region_code: ISO 3166-1 alpha-2 region code to use in the statistical modeling. Set if no column is tagged with a region-specific InfoType (like US_ZIP_5) or a region code.
        """
        pulumi.set(__self__, "auxiliary_tables", auxiliary_tables)
        pulumi.set(__self__, "quasi_ids", quasi_ids)
        pulumi.set(__self__, "region_code", region_code)

    @property
    @pulumi.getter(name="auxiliaryTables")
    def auxiliary_tables(self) -> Sequence['outputs.GooglePrivacyDlpV2StatisticalTableResponse']:
        """
        Several auxiliary tables can be used in the analysis. Each custom_tag used to tag a quasi-identifiers field must appear in exactly one field of one auxiliary table.
        """
        return pulumi.get(self, "auxiliary_tables")

    @property
    @pulumi.getter(name="quasiIds")
    def quasi_ids(self) -> Sequence['outputs.GooglePrivacyDlpV2QuasiIdResponse']:
        """
        Fields considered to be quasi-identifiers. No two fields can have the same tag.
        """
        return pulumi.get(self, "quasi_ids")

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> str:
        """
        ISO 3166-1 alpha-2 region code to use in the statistical modeling. Set if no column is tagged with a region-specific InfoType (like US_ZIP_5) or a region code.
        """
        return pulumi.get(self, "region_code")


@pulumi.output_type
class GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucketResponse(dict):
    """
    A DeltaPresenceEstimationHistogramBucket message with the following values: min_probability: 0.1 max_probability: 0.2 frequency: 42 means that there are 42 records for which δ is in [0.1, 0.2). An important particular case is when min_probability = max_probability = 1: then, every individual who shares this quasi-identifier combination is in the dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketSize":
            suggest = "bucket_size"
        elif key == "bucketValueCount":
            suggest = "bucket_value_count"
        elif key == "bucketValues":
            suggest = "bucket_values"
        elif key == "maxProbability":
            suggest = "max_probability"
        elif key == "minProbability":
            suggest = "min_probability"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucketResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucketResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucketResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_size: str,
                 bucket_value_count: str,
                 bucket_values: Sequence['outputs.GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValuesResponse'],
                 max_probability: float,
                 min_probability: float):
        """
        A DeltaPresenceEstimationHistogramBucket message with the following values: min_probability: 0.1 max_probability: 0.2 frequency: 42 means that there are 42 records for which δ is in [0.1, 0.2). An important particular case is when min_probability = max_probability = 1: then, every individual who shares this quasi-identifier combination is in the dataset.
        :param str bucket_size: Number of records within these probability bounds.
        :param str bucket_value_count: Total number of distinct quasi-identifier tuple values in this bucket.
        :param Sequence['GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValuesResponse'] bucket_values: Sample of quasi-identifier tuple values in this bucket. The total number of classes returned per bucket is capped at 20.
        :param float max_probability: Always greater than or equal to min_probability.
        :param float min_probability: Between 0 and 1.
        """
        pulumi.set(__self__, "bucket_size", bucket_size)
        pulumi.set(__self__, "bucket_value_count", bucket_value_count)
        pulumi.set(__self__, "bucket_values", bucket_values)
        pulumi.set(__self__, "max_probability", max_probability)
        pulumi.set(__self__, "min_probability", min_probability)

    @property
    @pulumi.getter(name="bucketSize")
    def bucket_size(self) -> str:
        """
        Number of records within these probability bounds.
        """
        return pulumi.get(self, "bucket_size")

    @property
    @pulumi.getter(name="bucketValueCount")
    def bucket_value_count(self) -> str:
        """
        Total number of distinct quasi-identifier tuple values in this bucket.
        """
        return pulumi.get(self, "bucket_value_count")

    @property
    @pulumi.getter(name="bucketValues")
    def bucket_values(self) -> Sequence['outputs.GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValuesResponse']:
        """
        Sample of quasi-identifier tuple values in this bucket. The total number of classes returned per bucket is capped at 20.
        """
        return pulumi.get(self, "bucket_values")

    @property
    @pulumi.getter(name="maxProbability")
    def max_probability(self) -> float:
        """
        Always greater than or equal to min_probability.
        """
        return pulumi.get(self, "max_probability")

    @property
    @pulumi.getter(name="minProbability")
    def min_probability(self) -> float:
        """
        Between 0 and 1.
        """
        return pulumi.get(self, "min_probability")


@pulumi.output_type
class GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValuesResponse(dict):
    """
    A tuple of values for the quasi-identifier columns.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "estimatedProbability":
            suggest = "estimated_probability"
        elif key == "quasiIdsValues":
            suggest = "quasi_ids_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValuesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValuesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValuesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 estimated_probability: float,
                 quasi_ids_values: Sequence['outputs.GooglePrivacyDlpV2ValueResponse']):
        """
        A tuple of values for the quasi-identifier columns.
        :param float estimated_probability: The estimated probability that a given individual sharing these quasi-identifier values is in the dataset. This value, typically called δ, is the ratio between the number of records in the dataset with these quasi-identifier values, and the total number of individuals (inside *and* outside the dataset) with these quasi-identifier values. For example, if there are 15 individuals in the dataset who share the same quasi-identifier values, and an estimated 100 people in the entire population with these values, then δ is 0.15.
        :param Sequence['GooglePrivacyDlpV2ValueResponse'] quasi_ids_values: The quasi-identifier values.
        """
        pulumi.set(__self__, "estimated_probability", estimated_probability)
        pulumi.set(__self__, "quasi_ids_values", quasi_ids_values)

    @property
    @pulumi.getter(name="estimatedProbability")
    def estimated_probability(self) -> float:
        """
        The estimated probability that a given individual sharing these quasi-identifier values is in the dataset. This value, typically called δ, is the ratio between the number of records in the dataset with these quasi-identifier values, and the total number of individuals (inside *and* outside the dataset) with these quasi-identifier values. For example, if there are 15 individuals in the dataset who share the same quasi-identifier values, and an estimated 100 people in the entire population with these values, then δ is 0.15.
        """
        return pulumi.get(self, "estimated_probability")

    @property
    @pulumi.getter(name="quasiIdsValues")
    def quasi_ids_values(self) -> Sequence['outputs.GooglePrivacyDlpV2ValueResponse']:
        """
        The quasi-identifier values.
        """
        return pulumi.get(self, "quasi_ids_values")


@pulumi.output_type
class GooglePrivacyDlpV2DeltaPresenceEstimationResultResponse(dict):
    """
    Result of the δ-presence computation. Note that these results are an estimation, not exact values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deltaPresenceEstimationHistogram":
            suggest = "delta_presence_estimation_histogram"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2DeltaPresenceEstimationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2DeltaPresenceEstimationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2DeltaPresenceEstimationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delta_presence_estimation_histogram: Sequence['outputs.GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucketResponse']):
        """
        Result of the δ-presence computation. Note that these results are an estimation, not exact values.
        :param Sequence['GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucketResponse'] delta_presence_estimation_histogram: The intervals [min_probability, max_probability) do not overlap. If a value doesn't correspond to any such interval, the associated frequency is zero. For example, the following records: {min_probability: 0, max_probability: 0.1, frequency: 17} {min_probability: 0.2, max_probability: 0.3, frequency: 42} {min_probability: 0.3, max_probability: 0.4, frequency: 99} mean that there are no record with an estimated probability in [0.1, 0.2) nor larger or equal to 0.4.
        """
        pulumi.set(__self__, "delta_presence_estimation_histogram", delta_presence_estimation_histogram)

    @property
    @pulumi.getter(name="deltaPresenceEstimationHistogram")
    def delta_presence_estimation_histogram(self) -> Sequence['outputs.GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucketResponse']:
        """
        The intervals [min_probability, max_probability) do not overlap. If a value doesn't correspond to any such interval, the associated frequency is zero. For example, the following records: {min_probability: 0, max_probability: 0.1, frequency: 17} {min_probability: 0.2, max_probability: 0.3, frequency: 42} {min_probability: 0.3, max_probability: 0.4, frequency: 99} mean that there are no record with an estimated probability in [0.1, 0.2) nor larger or equal to 0.4.
        """
        return pulumi.get(self, "delta_presence_estimation_histogram")


@pulumi.output_type
class GooglePrivacyDlpV2DetectionRuleResponse(dict):
    """
    Deprecated; use `InspectionRuleSet` instead. Rule for modifying a `CustomInfoType` to alter behavior under certain circumstances, depending on the specific details of the rule. Not supported for the `surrogate_type` custom infoType.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hotwordRule":
            suggest = "hotword_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2DetectionRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2DetectionRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2DetectionRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hotword_rule: 'outputs.GooglePrivacyDlpV2HotwordRuleResponse'):
        """
        Deprecated; use `InspectionRuleSet` instead. Rule for modifying a `CustomInfoType` to alter behavior under certain circumstances, depending on the specific details of the rule. Not supported for the `surrogate_type` custom infoType.
        :param 'GooglePrivacyDlpV2HotwordRuleResponse' hotword_rule: Hotword-based detection rule.
        """
        pulumi.set(__self__, "hotword_rule", hotword_rule)

    @property
    @pulumi.getter(name="hotwordRule")
    def hotword_rule(self) -> 'outputs.GooglePrivacyDlpV2HotwordRuleResponse':
        """
        Hotword-based detection rule.
        """
        return pulumi.get(self, "hotword_rule")


@pulumi.output_type
class GooglePrivacyDlpV2DictionaryResponse(dict):
    """
    Custom information type based on a dictionary of words or phrases. This can be used to match sensitive information specific to the data, such as a list of employee IDs or job titles. Dictionary words are case-insensitive and all characters other than letters and digits in the unicode [Basic Multilingual Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane) will be replaced with whitespace when scanning for matches, so the dictionary phrase "Sam Johnson" will match all three phrases "sam johnson", "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters surrounding any match must be of a different type than the adjacent characters within the word, so letters must be next to non-letters and digits next to non-digits. For example, the dictionary word "jen" will match the first three letters of the text "jen123" but will return no matches for "jennifer". Dictionary words containing a large number of characters that are not letters or digits may result in unexpected findings because such characters are treated as whitespace. The [limits](https://cloud.google.com/dlp/limits) page contains details about the size limits of dictionaries. For dictionaries that do not fit within these constraints, consider using `LargeCustomDictionaryConfig` in the `StoredInfoType` API.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudStoragePath":
            suggest = "cloud_storage_path"
        elif key == "wordList":
            suggest = "word_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2DictionaryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2DictionaryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2DictionaryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_storage_path: 'outputs.GooglePrivacyDlpV2CloudStoragePathResponse',
                 word_list: 'outputs.GooglePrivacyDlpV2WordListResponse'):
        """
        Custom information type based on a dictionary of words or phrases. This can be used to match sensitive information specific to the data, such as a list of employee IDs or job titles. Dictionary words are case-insensitive and all characters other than letters and digits in the unicode [Basic Multilingual Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane) will be replaced with whitespace when scanning for matches, so the dictionary phrase "Sam Johnson" will match all three phrases "sam johnson", "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters surrounding any match must be of a different type than the adjacent characters within the word, so letters must be next to non-letters and digits next to non-digits. For example, the dictionary word "jen" will match the first three letters of the text "jen123" but will return no matches for "jennifer". Dictionary words containing a large number of characters that are not letters or digits may result in unexpected findings because such characters are treated as whitespace. The [limits](https://cloud.google.com/dlp/limits) page contains details about the size limits of dictionaries. For dictionaries that do not fit within these constraints, consider using `LargeCustomDictionaryConfig` in the `StoredInfoType` API.
        :param 'GooglePrivacyDlpV2CloudStoragePathResponse' cloud_storage_path: Newline-delimited file of words in Cloud Storage. Only a single file is accepted.
        :param 'GooglePrivacyDlpV2WordListResponse' word_list: List of words or phrases to search for.
        """
        pulumi.set(__self__, "cloud_storage_path", cloud_storage_path)
        pulumi.set(__self__, "word_list", word_list)

    @property
    @pulumi.getter(name="cloudStoragePath")
    def cloud_storage_path(self) -> 'outputs.GooglePrivacyDlpV2CloudStoragePathResponse':
        """
        Newline-delimited file of words in Cloud Storage. Only a single file is accepted.
        """
        return pulumi.get(self, "cloud_storage_path")

    @property
    @pulumi.getter(name="wordList")
    def word_list(self) -> 'outputs.GooglePrivacyDlpV2WordListResponse':
        """
        List of words or phrases to search for.
        """
        return pulumi.get(self, "word_list")


@pulumi.output_type
class GooglePrivacyDlpV2EntityIdResponse(dict):
    """
    An entity in a dataset is a field or set of fields that correspond to a single person. For example, in medical records the `EntityId` might be a patient identifier, or for financial records it might be an account identifier. This message is used when generalizations or analysis must take into account that multiple rows correspond to the same entity.
    """
    def __init__(__self__, *,
                 field: 'outputs.GooglePrivacyDlpV2FieldIdResponse'):
        """
        An entity in a dataset is a field or set of fields that correspond to a single person. For example, in medical records the `EntityId` might be a patient identifier, or for financial records it might be an account identifier. This message is used when generalizations or analysis must take into account that multiple rows correspond to the same entity.
        :param 'GooglePrivacyDlpV2FieldIdResponse' field: Composite key indicating which field contains the entity identifier.
        """
        pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Composite key indicating which field contains the entity identifier.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class GooglePrivacyDlpV2ErrorResponse(dict):
    """
    Details information about an error encountered during job execution or the results of an unsuccessful activation of the JobTrigger.
    """
    def __init__(__self__, *,
                 details: 'outputs.GoogleRpcStatusResponse',
                 timestamps: Sequence[str]):
        """
        Details information about an error encountered during job execution or the results of an unsuccessful activation of the JobTrigger.
        :param 'GoogleRpcStatusResponse' details: Detailed error codes and messages.
        :param Sequence[str] timestamps: The times the error occurred.
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "timestamps", timestamps)

    @property
    @pulumi.getter
    def details(self) -> 'outputs.GoogleRpcStatusResponse':
        """
        Detailed error codes and messages.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def timestamps(self) -> Sequence[str]:
        """
        The times the error occurred.
        """
        return pulumi.get(self, "timestamps")


@pulumi.output_type
class GooglePrivacyDlpV2ExcludeInfoTypesResponse(dict):
    """
    List of exclude infoTypes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infoTypes":
            suggest = "info_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ExcludeInfoTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ExcludeInfoTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ExcludeInfoTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 info_types: Sequence['outputs.GooglePrivacyDlpV2InfoTypeResponse']):
        """
        List of exclude infoTypes.
        :param Sequence['GooglePrivacyDlpV2InfoTypeResponse'] info_types: InfoType list in ExclusionRule rule drops a finding when it overlaps or contained within with a finding of an infoType from this list. For example, for `InspectionRuleSet.info_types` containing "PHONE_NUMBER"` and `exclusion_rule` containing `exclude_info_types.info_types` with "EMAIL_ADDRESS" the phone number findings are dropped if they overlap with EMAIL_ADDRESS finding. That leads to "555-222-2222@example.org" to generate only a single finding, namely email address.
        """
        pulumi.set(__self__, "info_types", info_types)

    @property
    @pulumi.getter(name="infoTypes")
    def info_types(self) -> Sequence['outputs.GooglePrivacyDlpV2InfoTypeResponse']:
        """
        InfoType list in ExclusionRule rule drops a finding when it overlaps or contained within with a finding of an infoType from this list. For example, for `InspectionRuleSet.info_types` containing "PHONE_NUMBER"` and `exclusion_rule` containing `exclude_info_types.info_types` with "EMAIL_ADDRESS" the phone number findings are dropped if they overlap with EMAIL_ADDRESS finding. That leads to "555-222-2222@example.org" to generate only a single finding, namely email address.
        """
        return pulumi.get(self, "info_types")


@pulumi.output_type
class GooglePrivacyDlpV2ExclusionRuleResponse(dict):
    """
    The rule that specifies conditions when findings of infoTypes specified in `InspectionRuleSet` are removed from results.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeInfoTypes":
            suggest = "exclude_info_types"
        elif key == "matchingType":
            suggest = "matching_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ExclusionRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ExclusionRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ExclusionRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dictionary: 'outputs.GooglePrivacyDlpV2DictionaryResponse',
                 exclude_info_types: 'outputs.GooglePrivacyDlpV2ExcludeInfoTypesResponse',
                 matching_type: str,
                 regex: 'outputs.GooglePrivacyDlpV2RegexResponse'):
        """
        The rule that specifies conditions when findings of infoTypes specified in `InspectionRuleSet` are removed from results.
        :param 'GooglePrivacyDlpV2DictionaryResponse' dictionary: Dictionary which defines the rule.
        :param 'GooglePrivacyDlpV2ExcludeInfoTypesResponse' exclude_info_types: Set of infoTypes for which findings would affect this rule.
        :param str matching_type: How the rule is applied, see MatchingType documentation for details.
        :param 'GooglePrivacyDlpV2RegexResponse' regex: Regular expression which defines the rule.
        """
        pulumi.set(__self__, "dictionary", dictionary)
        pulumi.set(__self__, "exclude_info_types", exclude_info_types)
        pulumi.set(__self__, "matching_type", matching_type)
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def dictionary(self) -> 'outputs.GooglePrivacyDlpV2DictionaryResponse':
        """
        Dictionary which defines the rule.
        """
        return pulumi.get(self, "dictionary")

    @property
    @pulumi.getter(name="excludeInfoTypes")
    def exclude_info_types(self) -> 'outputs.GooglePrivacyDlpV2ExcludeInfoTypesResponse':
        """
        Set of infoTypes for which findings would affect this rule.
        """
        return pulumi.get(self, "exclude_info_types")

    @property
    @pulumi.getter(name="matchingType")
    def matching_type(self) -> str:
        """
        How the rule is applied, see MatchingType documentation for details.
        """
        return pulumi.get(self, "matching_type")

    @property
    @pulumi.getter
    def regex(self) -> 'outputs.GooglePrivacyDlpV2RegexResponse':
        """
        Regular expression which defines the rule.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class GooglePrivacyDlpV2ExpressionsResponse(dict):
    """
    An expression, consisting or an operator and conditions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logicalOperator":
            suggest = "logical_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ExpressionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ExpressionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ExpressionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: 'outputs.GooglePrivacyDlpV2ConditionsResponse',
                 logical_operator: str):
        """
        An expression, consisting or an operator and conditions.
        :param 'GooglePrivacyDlpV2ConditionsResponse' conditions: Conditions to apply to the expression.
        :param str logical_operator: The operator to apply to the result of conditions. Default and currently only supported value is `AND`.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "logical_operator", logical_operator)

    @property
    @pulumi.getter
    def conditions(self) -> 'outputs.GooglePrivacyDlpV2ConditionsResponse':
        """
        Conditions to apply to the expression.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="logicalOperator")
    def logical_operator(self) -> str:
        """
        The operator to apply to the result of conditions. Default and currently only supported value is `AND`.
        """
        return pulumi.get(self, "logical_operator")


@pulumi.output_type
class GooglePrivacyDlpV2FieldIdResponse(dict):
    """
    General identifier of a data field in a storage service.
    """
    def __init__(__self__, *,
                 name: str):
        """
        General identifier of a data field in a storage service.
        :param str name: Name describing the field.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name describing the field.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GooglePrivacyDlpV2FieldTransformationResponse(dict):
    """
    The transformation to apply to the field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infoTypeTransformations":
            suggest = "info_type_transformations"
        elif key == "primitiveTransformation":
            suggest = "primitive_transformation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2FieldTransformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2FieldTransformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2FieldTransformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: 'outputs.GooglePrivacyDlpV2RecordConditionResponse',
                 fields: Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse'],
                 info_type_transformations: 'outputs.GooglePrivacyDlpV2InfoTypeTransformationsResponse',
                 primitive_transformation: 'outputs.GooglePrivacyDlpV2PrimitiveTransformationResponse'):
        """
        The transformation to apply to the field.
        :param 'GooglePrivacyDlpV2RecordConditionResponse' condition: Only apply the transformation if the condition evaluates to true for the given `RecordCondition`. The conditions are allowed to reference fields that are not used in the actual transformation. Example Use Cases: - Apply a different bucket transformation to an age column if the zip code column for the same record is within a specific range. - Redact a field if the date of birth field is greater than 85.
        :param Sequence['GooglePrivacyDlpV2FieldIdResponse'] fields: Input field(s) to apply the transformation to. When you have columns that reference their position within a list, omit the index from the FieldId. FieldId name matching ignores the index. For example, instead of "contact.nums[0].type", use "contact.nums.type".
        :param 'GooglePrivacyDlpV2InfoTypeTransformationsResponse' info_type_transformations: Treat the contents of the field as free text, and selectively transform content that matches an `InfoType`.
        :param 'GooglePrivacyDlpV2PrimitiveTransformationResponse' primitive_transformation: Apply the transformation to the entire field.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "info_type_transformations", info_type_transformations)
        pulumi.set(__self__, "primitive_transformation", primitive_transformation)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GooglePrivacyDlpV2RecordConditionResponse':
        """
        Only apply the transformation if the condition evaluates to true for the given `RecordCondition`. The conditions are allowed to reference fields that are not used in the actual transformation. Example Use Cases: - Apply a different bucket transformation to an age column if the zip code column for the same record is within a specific range. - Redact a field if the date of birth field is greater than 85.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse']:
        """
        Input field(s) to apply the transformation to. When you have columns that reference their position within a list, omit the index from the FieldId. FieldId name matching ignores the index. For example, instead of "contact.nums[0].type", use "contact.nums.type".
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="infoTypeTransformations")
    def info_type_transformations(self) -> 'outputs.GooglePrivacyDlpV2InfoTypeTransformationsResponse':
        """
        Treat the contents of the field as free text, and selectively transform content that matches an `InfoType`.
        """
        return pulumi.get(self, "info_type_transformations")

    @property
    @pulumi.getter(name="primitiveTransformation")
    def primitive_transformation(self) -> 'outputs.GooglePrivacyDlpV2PrimitiveTransformationResponse':
        """
        Apply the transformation to the entire field.
        """
        return pulumi.get(self, "primitive_transformation")


@pulumi.output_type
class GooglePrivacyDlpV2FileSetResponse(dict):
    """
    Set of files to scan.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regexFileSet":
            suggest = "regex_file_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2FileSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2FileSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2FileSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 regex_file_set: 'outputs.GooglePrivacyDlpV2CloudStorageRegexFileSetResponse',
                 url: str):
        """
        Set of files to scan.
        :param 'GooglePrivacyDlpV2CloudStorageRegexFileSetResponse' regex_file_set: The regex-filtered set of files to scan. Exactly one of `url` or `regex_file_set` must be set.
        :param str url: The Cloud Storage url of the file(s) to scan, in the format `gs:///`. Trailing wildcard in the path is allowed. If the url ends in a trailing slash, the bucket or directory represented by the url will be scanned non-recursively (content in sub-directories will not be scanned). This means that `gs://mybucket/` is equivalent to `gs://mybucket/*`, and `gs://mybucket/directory/` is equivalent to `gs://mybucket/directory/*`. Exactly one of `url` or `regex_file_set` must be set.
        """
        pulumi.set(__self__, "regex_file_set", regex_file_set)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="regexFileSet")
    def regex_file_set(self) -> 'outputs.GooglePrivacyDlpV2CloudStorageRegexFileSetResponse':
        """
        The regex-filtered set of files to scan. Exactly one of `url` or `regex_file_set` must be set.
        """
        return pulumi.get(self, "regex_file_set")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Cloud Storage url of the file(s) to scan, in the format `gs:///`. Trailing wildcard in the path is allowed. If the url ends in a trailing slash, the bucket or directory represented by the url will be scanned non-recursively (content in sub-directories will not be scanned). This means that `gs://mybucket/` is equivalent to `gs://mybucket/*`, and `gs://mybucket/directory/` is equivalent to `gs://mybucket/directory/*`. Exactly one of `url` or `regex_file_set` must be set.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GooglePrivacyDlpV2FindingLimitsResponse(dict):
    """
    Configuration to control the number of findings returned for inspection. This is not used for de-identification or data profiling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxFindingsPerInfoType":
            suggest = "max_findings_per_info_type"
        elif key == "maxFindingsPerItem":
            suggest = "max_findings_per_item"
        elif key == "maxFindingsPerRequest":
            suggest = "max_findings_per_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2FindingLimitsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2FindingLimitsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2FindingLimitsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_findings_per_info_type: Sequence['outputs.GooglePrivacyDlpV2InfoTypeLimitResponse'],
                 max_findings_per_item: int,
                 max_findings_per_request: int):
        """
        Configuration to control the number of findings returned for inspection. This is not used for de-identification or data profiling.
        :param Sequence['GooglePrivacyDlpV2InfoTypeLimitResponse'] max_findings_per_info_type: Configuration of findings limit given for specified infoTypes.
        :param int max_findings_per_item: Max number of findings that will be returned for each item scanned. When set within `InspectJobConfig`, the maximum returned is 2000 regardless if this is set higher. When set within `InspectContentRequest`, this field is ignored.
        :param int max_findings_per_request: Max number of findings that will be returned per request/job. When set within `InspectContentRequest`, the maximum returned is 2000 regardless if this is set higher.
        """
        pulumi.set(__self__, "max_findings_per_info_type", max_findings_per_info_type)
        pulumi.set(__self__, "max_findings_per_item", max_findings_per_item)
        pulumi.set(__self__, "max_findings_per_request", max_findings_per_request)

    @property
    @pulumi.getter(name="maxFindingsPerInfoType")
    def max_findings_per_info_type(self) -> Sequence['outputs.GooglePrivacyDlpV2InfoTypeLimitResponse']:
        """
        Configuration of findings limit given for specified infoTypes.
        """
        return pulumi.get(self, "max_findings_per_info_type")

    @property
    @pulumi.getter(name="maxFindingsPerItem")
    def max_findings_per_item(self) -> int:
        """
        Max number of findings that will be returned for each item scanned. When set within `InspectJobConfig`, the maximum returned is 2000 regardless if this is set higher. When set within `InspectContentRequest`, this field is ignored.
        """
        return pulumi.get(self, "max_findings_per_item")

    @property
    @pulumi.getter(name="maxFindingsPerRequest")
    def max_findings_per_request(self) -> int:
        """
        Max number of findings that will be returned per request/job. When set within `InspectContentRequest`, the maximum returned is 2000 regardless if this is set higher.
        """
        return pulumi.get(self, "max_findings_per_request")


@pulumi.output_type
class GooglePrivacyDlpV2FixedSizeBucketingConfigResponse(dict):
    """
    Buckets values based on fixed size ranges. The Bucketing transformation can provide all of this functionality, but requires more configuration. This message is provided as a convenience to the user for simple bucketing strategies. The transformed value will be a hyphenated string of {lower_bound}-{upper_bound}. For example, if lower_bound = 10 and upper_bound = 20, all values that are within this bucket will be replaced with "10-20". This can be used on data of type: double, long. If the bound Value type differs from the type of data being transformed, we will first attempt converting the type of the data to be transformed to match the type of the bound before comparing. See https://cloud.google.com/dlp/docs/concepts-bucketing to learn more.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketSize":
            suggest = "bucket_size"
        elif key == "lowerBound":
            suggest = "lower_bound"
        elif key == "upperBound":
            suggest = "upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2FixedSizeBucketingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2FixedSizeBucketingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2FixedSizeBucketingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_size: float,
                 lower_bound: 'outputs.GooglePrivacyDlpV2ValueResponse',
                 upper_bound: 'outputs.GooglePrivacyDlpV2ValueResponse'):
        """
        Buckets values based on fixed size ranges. The Bucketing transformation can provide all of this functionality, but requires more configuration. This message is provided as a convenience to the user for simple bucketing strategies. The transformed value will be a hyphenated string of {lower_bound}-{upper_bound}. For example, if lower_bound = 10 and upper_bound = 20, all values that are within this bucket will be replaced with "10-20". This can be used on data of type: double, long. If the bound Value type differs from the type of data being transformed, we will first attempt converting the type of the data to be transformed to match the type of the bound before comparing. See https://cloud.google.com/dlp/docs/concepts-bucketing to learn more.
        :param float bucket_size: Size of each bucket (except for minimum and maximum buckets). So if `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60, 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
        :param 'GooglePrivacyDlpV2ValueResponse' lower_bound: Lower bound value of buckets. All values less than `lower_bound` are grouped together into a single bucket; for example if `lower_bound` = 10, then all values less than 10 are replaced with the value "-10".
        :param 'GooglePrivacyDlpV2ValueResponse' upper_bound: Upper bound value of buckets. All values greater than upper_bound are grouped together into a single bucket; for example if `upper_bound` = 89, then all values greater than 89 are replaced with the value "89+".
        """
        pulumi.set(__self__, "bucket_size", bucket_size)
        pulumi.set(__self__, "lower_bound", lower_bound)
        pulumi.set(__self__, "upper_bound", upper_bound)

    @property
    @pulumi.getter(name="bucketSize")
    def bucket_size(self) -> float:
        """
        Size of each bucket (except for minimum and maximum buckets). So if `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60, 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
        """
        return pulumi.get(self, "bucket_size")

    @property
    @pulumi.getter(name="lowerBound")
    def lower_bound(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        Lower bound value of buckets. All values less than `lower_bound` are grouped together into a single bucket; for example if `lower_bound` = 10, then all values less than 10 are replaced with the value "-10".
        """
        return pulumi.get(self, "lower_bound")

    @property
    @pulumi.getter(name="upperBound")
    def upper_bound(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        Upper bound value of buckets. All values greater than upper_bound are grouped together into a single bucket; for example if `upper_bound` = 89, then all values greater than 89 are replaced with the value "89+".
        """
        return pulumi.get(self, "upper_bound")


@pulumi.output_type
class GooglePrivacyDlpV2HotwordRuleResponse(dict):
    """
    The rule that adjusts the likelihood of findings within a certain proximity of hotwords.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hotwordRegex":
            suggest = "hotword_regex"
        elif key == "likelihoodAdjustment":
            suggest = "likelihood_adjustment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2HotwordRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2HotwordRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2HotwordRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hotword_regex: 'outputs.GooglePrivacyDlpV2RegexResponse',
                 likelihood_adjustment: 'outputs.GooglePrivacyDlpV2LikelihoodAdjustmentResponse',
                 proximity: 'outputs.GooglePrivacyDlpV2ProximityResponse'):
        """
        The rule that adjusts the likelihood of findings within a certain proximity of hotwords.
        :param 'GooglePrivacyDlpV2RegexResponse' hotword_regex: Regular expression pattern defining what qualifies as a hotword.
        :param 'GooglePrivacyDlpV2LikelihoodAdjustmentResponse' likelihood_adjustment: Likelihood adjustment to apply to all matching findings.
        :param 'GooglePrivacyDlpV2ProximityResponse' proximity: Proximity of the finding within which the entire hotword must reside. The total length of the window cannot exceed 1000 characters. Note that the finding itself will be included in the window, so that hotwords may be used to match substrings of the finding itself. For example, the certainty of a phone number regex "\(\d{3}\) \d{3}-\d{4}" could be adjusted upwards if the area code is known to be the local area code of a company office using the hotword regex "\(xxx\)", where "xxx" is the area code in question.
        """
        pulumi.set(__self__, "hotword_regex", hotword_regex)
        pulumi.set(__self__, "likelihood_adjustment", likelihood_adjustment)
        pulumi.set(__self__, "proximity", proximity)

    @property
    @pulumi.getter(name="hotwordRegex")
    def hotword_regex(self) -> 'outputs.GooglePrivacyDlpV2RegexResponse':
        """
        Regular expression pattern defining what qualifies as a hotword.
        """
        return pulumi.get(self, "hotword_regex")

    @property
    @pulumi.getter(name="likelihoodAdjustment")
    def likelihood_adjustment(self) -> 'outputs.GooglePrivacyDlpV2LikelihoodAdjustmentResponse':
        """
        Likelihood adjustment to apply to all matching findings.
        """
        return pulumi.get(self, "likelihood_adjustment")

    @property
    @pulumi.getter
    def proximity(self) -> 'outputs.GooglePrivacyDlpV2ProximityResponse':
        """
        Proximity of the finding within which the entire hotword must reside. The total length of the window cannot exceed 1000 characters. Note that the finding itself will be included in the window, so that hotwords may be used to match substrings of the finding itself. For example, the certainty of a phone number regex "\(\d{3}\) \d{3}-\d{4}" could be adjusted upwards if the area code is known to be the local area code of a company office using the hotword regex "\(xxx\)", where "xxx" is the area code in question.
        """
        return pulumi.get(self, "proximity")


@pulumi.output_type
class GooglePrivacyDlpV2HybridInspectStatisticsResponse(dict):
    """
    Statistics related to processing hybrid inspect requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortedCount":
            suggest = "aborted_count"
        elif key == "pendingCount":
            suggest = "pending_count"
        elif key == "processedCount":
            suggest = "processed_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2HybridInspectStatisticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2HybridInspectStatisticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2HybridInspectStatisticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aborted_count: str,
                 pending_count: str,
                 processed_count: str):
        """
        Statistics related to processing hybrid inspect requests.
        :param str aborted_count: The number of hybrid inspection requests aborted because the job ran out of quota or was ended before they could be processed.
        :param str pending_count: The number of hybrid requests currently being processed. Only populated when called via method `getDlpJob`. A burst of traffic may cause hybrid inspect requests to be enqueued. Processing will take place as quickly as possible, but resource limitations may impact how long a request is enqueued for.
        :param str processed_count: The number of hybrid inspection requests processed within this job.
        """
        pulumi.set(__self__, "aborted_count", aborted_count)
        pulumi.set(__self__, "pending_count", pending_count)
        pulumi.set(__self__, "processed_count", processed_count)

    @property
    @pulumi.getter(name="abortedCount")
    def aborted_count(self) -> str:
        """
        The number of hybrid inspection requests aborted because the job ran out of quota or was ended before they could be processed.
        """
        return pulumi.get(self, "aborted_count")

    @property
    @pulumi.getter(name="pendingCount")
    def pending_count(self) -> str:
        """
        The number of hybrid requests currently being processed. Only populated when called via method `getDlpJob`. A burst of traffic may cause hybrid inspect requests to be enqueued. Processing will take place as quickly as possible, but resource limitations may impact how long a request is enqueued for.
        """
        return pulumi.get(self, "pending_count")

    @property
    @pulumi.getter(name="processedCount")
    def processed_count(self) -> str:
        """
        The number of hybrid inspection requests processed within this job.
        """
        return pulumi.get(self, "processed_count")


@pulumi.output_type
class GooglePrivacyDlpV2HybridOptionsResponse(dict):
    """
    Configuration to control jobs where the content being inspected is outside of Google Cloud Platform.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requiredFindingLabelKeys":
            suggest = "required_finding_label_keys"
        elif key == "tableOptions":
            suggest = "table_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2HybridOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2HybridOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2HybridOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 labels: Mapping[str, str],
                 required_finding_label_keys: Sequence[str],
                 table_options: 'outputs.GooglePrivacyDlpV2TableOptionsResponse'):
        """
        Configuration to control jobs where the content being inspected is outside of Google Cloud Platform.
        :param str description: A short description of where the data is coming from. Will be stored once in the job. 256 max length.
        :param Mapping[str, str] labels: To organize findings, these labels will be added to each finding. Label keys must be between 1 and 63 characters long and must conform to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`. Label values must be between 0 and 63 characters long and must conform to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`. No more than 10 labels can be associated with a given finding. Examples: * `"environment" : "production"` * `"pipeline" : "etl"`
        :param Sequence[str] required_finding_label_keys: These are labels that each inspection request must include within their 'finding_labels' map. Request may contain others, but any missing one of these will be rejected. Label keys must be between 1 and 63 characters long and must conform to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`. No more than 10 keys can be required.
        :param 'GooglePrivacyDlpV2TableOptionsResponse' table_options: If the container is a table, additional information to make findings meaningful such as the columns that are primary keys.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "required_finding_label_keys", required_finding_label_keys)
        pulumi.set(__self__, "table_options", table_options)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of where the data is coming from. Will be stored once in the job. 256 max length.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        To organize findings, these labels will be added to each finding. Label keys must be between 1 and 63 characters long and must conform to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`. Label values must be between 0 and 63 characters long and must conform to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`. No more than 10 labels can be associated with a given finding. Examples: * `"environment" : "production"` * `"pipeline" : "etl"`
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="requiredFindingLabelKeys")
    def required_finding_label_keys(self) -> Sequence[str]:
        """
        These are labels that each inspection request must include within their 'finding_labels' map. Request may contain others, but any missing one of these will be rejected. Label keys must be between 1 and 63 characters long and must conform to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`. No more than 10 keys can be required.
        """
        return pulumi.get(self, "required_finding_label_keys")

    @property
    @pulumi.getter(name="tableOptions")
    def table_options(self) -> 'outputs.GooglePrivacyDlpV2TableOptionsResponse':
        """
        If the container is a table, additional information to make findings meaningful such as the columns that are primary keys.
        """
        return pulumi.get(self, "table_options")


@pulumi.output_type
class GooglePrivacyDlpV2InfoTypeLimitResponse(dict):
    """
    Max findings configuration per infoType, per content item or long running DlpJob.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infoType":
            suggest = "info_type"
        elif key == "maxFindings":
            suggest = "max_findings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2InfoTypeLimitResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2InfoTypeLimitResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2InfoTypeLimitResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 info_type: 'outputs.GooglePrivacyDlpV2InfoTypeResponse',
                 max_findings: int):
        """
        Max findings configuration per infoType, per content item or long running DlpJob.
        :param 'GooglePrivacyDlpV2InfoTypeResponse' info_type: Type of information the findings limit applies to. Only one limit per info_type should be provided. If InfoTypeLimit does not have an info_type, the DLP API applies the limit against all info_types that are found but not specified in another InfoTypeLimit.
        :param int max_findings: Max findings limit for the given infoType.
        """
        pulumi.set(__self__, "info_type", info_type)
        pulumi.set(__self__, "max_findings", max_findings)

    @property
    @pulumi.getter(name="infoType")
    def info_type(self) -> 'outputs.GooglePrivacyDlpV2InfoTypeResponse':
        """
        Type of information the findings limit applies to. Only one limit per info_type should be provided. If InfoTypeLimit does not have an info_type, the DLP API applies the limit against all info_types that are found but not specified in another InfoTypeLimit.
        """
        return pulumi.get(self, "info_type")

    @property
    @pulumi.getter(name="maxFindings")
    def max_findings(self) -> int:
        """
        Max findings limit for the given infoType.
        """
        return pulumi.get(self, "max_findings")


@pulumi.output_type
class GooglePrivacyDlpV2InfoTypeResponse(dict):
    """
    Type of information detected by the API.
    """
    def __init__(__self__, *,
                 name: str,
                 version: str):
        """
        Type of information detected by the API.
        :param str name: Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type. When sending Cloud DLP results to Data Catalog, infoType names should conform to the pattern `[A-Za-z0-9$-_]{1,64}`.
        :param str version: Optional version name for this InfoType.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the information type. Either a name of your choosing when creating a CustomInfoType, or one of the names listed at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type. When sending Cloud DLP results to Data Catalog, infoType names should conform to the pattern `[A-Za-z0-9$-_]{1,64}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Optional version name for this InfoType.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GooglePrivacyDlpV2InfoTypeStatsResponse(dict):
    """
    Statistics regarding a specific InfoType.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infoType":
            suggest = "info_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2InfoTypeStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2InfoTypeStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2InfoTypeStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: str,
                 info_type: 'outputs.GooglePrivacyDlpV2InfoTypeResponse'):
        """
        Statistics regarding a specific InfoType.
        :param str count: Number of findings for this infoType.
        :param 'GooglePrivacyDlpV2InfoTypeResponse' info_type: The type of finding this stat is for.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "info_type", info_type)

    @property
    @pulumi.getter
    def count(self) -> str:
        """
        Number of findings for this infoType.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="infoType")
    def info_type(self) -> 'outputs.GooglePrivacyDlpV2InfoTypeResponse':
        """
        The type of finding this stat is for.
        """
        return pulumi.get(self, "info_type")


@pulumi.output_type
class GooglePrivacyDlpV2InfoTypeTransformationResponse(dict):
    """
    A transformation to apply to text that is identified as a specific info_type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infoTypes":
            suggest = "info_types"
        elif key == "primitiveTransformation":
            suggest = "primitive_transformation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2InfoTypeTransformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2InfoTypeTransformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2InfoTypeTransformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 info_types: Sequence['outputs.GooglePrivacyDlpV2InfoTypeResponse'],
                 primitive_transformation: 'outputs.GooglePrivacyDlpV2PrimitiveTransformationResponse'):
        """
        A transformation to apply to text that is identified as a specific info_type.
        :param Sequence['GooglePrivacyDlpV2InfoTypeResponse'] info_types: InfoTypes to apply the transformation to. An empty list will cause this transformation to apply to all findings that correspond to infoTypes that were requested in `InspectConfig`.
        :param 'GooglePrivacyDlpV2PrimitiveTransformationResponse' primitive_transformation: Primitive transformation to apply to the infoType.
        """
        pulumi.set(__self__, "info_types", info_types)
        pulumi.set(__self__, "primitive_transformation", primitive_transformation)

    @property
    @pulumi.getter(name="infoTypes")
    def info_types(self) -> Sequence['outputs.GooglePrivacyDlpV2InfoTypeResponse']:
        """
        InfoTypes to apply the transformation to. An empty list will cause this transformation to apply to all findings that correspond to infoTypes that were requested in `InspectConfig`.
        """
        return pulumi.get(self, "info_types")

    @property
    @pulumi.getter(name="primitiveTransformation")
    def primitive_transformation(self) -> 'outputs.GooglePrivacyDlpV2PrimitiveTransformationResponse':
        """
        Primitive transformation to apply to the infoType.
        """
        return pulumi.get(self, "primitive_transformation")


@pulumi.output_type
class GooglePrivacyDlpV2InfoTypeTransformationsResponse(dict):
    """
    A type of transformation that will scan unstructured text and apply various `PrimitiveTransformation`s to each finding, where the transformation is applied to only values that were identified as a specific info_type.
    """
    def __init__(__self__, *,
                 transformations: Sequence['outputs.GooglePrivacyDlpV2InfoTypeTransformationResponse']):
        """
        A type of transformation that will scan unstructured text and apply various `PrimitiveTransformation`s to each finding, where the transformation is applied to only values that were identified as a specific info_type.
        :param Sequence['GooglePrivacyDlpV2InfoTypeTransformationResponse'] transformations: Transformation for each infoType. Cannot specify more than one for a given infoType.
        """
        pulumi.set(__self__, "transformations", transformations)

    @property
    @pulumi.getter
    def transformations(self) -> Sequence['outputs.GooglePrivacyDlpV2InfoTypeTransformationResponse']:
        """
        Transformation for each infoType. Cannot specify more than one for a given infoType.
        """
        return pulumi.get(self, "transformations")


@pulumi.output_type
class GooglePrivacyDlpV2InspectConfigResponse(dict):
    """
    Configuration description of the scanning process. When used with redactContent only info_types and min_likelihood are currently used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customInfoTypes":
            suggest = "custom_info_types"
        elif key == "excludeInfoTypes":
            suggest = "exclude_info_types"
        elif key == "includeQuote":
            suggest = "include_quote"
        elif key == "infoTypes":
            suggest = "info_types"
        elif key == "minLikelihood":
            suggest = "min_likelihood"
        elif key == "ruleSet":
            suggest = "rule_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2InspectConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2InspectConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2InspectConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_info_types: Sequence['outputs.GooglePrivacyDlpV2CustomInfoTypeResponse'],
                 exclude_info_types: bool,
                 include_quote: bool,
                 info_types: Sequence['outputs.GooglePrivacyDlpV2InfoTypeResponse'],
                 limits: 'outputs.GooglePrivacyDlpV2FindingLimitsResponse',
                 min_likelihood: str,
                 rule_set: Sequence['outputs.GooglePrivacyDlpV2InspectionRuleSetResponse']):
        """
        Configuration description of the scanning process. When used with redactContent only info_types and min_likelihood are currently used.
        :param Sequence['GooglePrivacyDlpV2CustomInfoTypeResponse'] custom_info_types: CustomInfoTypes provided by the user. See https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
        :param bool exclude_info_types: When true, excludes type information of the findings. This is not used for data profiling.
        :param bool include_quote: When true, a contextual quote from the data that triggered a finding is included in the response; see Finding.quote. This is not used for data profiling.
        :param Sequence['GooglePrivacyDlpV2InfoTypeResponse'] info_types: Restricts what info_types to look for. The values must correspond to InfoType values returned by ListInfoTypes or listed at https://cloud.google.com/dlp/docs/infotypes-reference. When no InfoTypes or CustomInfoTypes are specified in a request, the system may automatically choose what detectors to run. By default this may be all types, but may change over time as detectors are updated. If you need precise control and predictability as to what detectors are run you should specify specific InfoTypes listed in the reference, otherwise a default list will be used, which may change over time.
        :param 'GooglePrivacyDlpV2FindingLimitsResponse' limits: Configuration to control the number of findings returned. This is not used for data profiling.
        :param str min_likelihood: Only returns findings equal or above this threshold. The default is POSSIBLE. See https://cloud.google.com/dlp/docs/likelihood to learn more.
        :param Sequence['GooglePrivacyDlpV2InspectionRuleSetResponse'] rule_set: Set of rules to apply to the findings for this InspectConfig. Exclusion rules, contained in the set are executed in the end, other rules are executed in the order they are specified for each info type.
        """
        pulumi.set(__self__, "custom_info_types", custom_info_types)
        pulumi.set(__self__, "exclude_info_types", exclude_info_types)
        pulumi.set(__self__, "include_quote", include_quote)
        pulumi.set(__self__, "info_types", info_types)
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "min_likelihood", min_likelihood)
        pulumi.set(__self__, "rule_set", rule_set)

    @property
    @pulumi.getter(name="customInfoTypes")
    def custom_info_types(self) -> Sequence['outputs.GooglePrivacyDlpV2CustomInfoTypeResponse']:
        """
        CustomInfoTypes provided by the user. See https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
        """
        return pulumi.get(self, "custom_info_types")

    @property
    @pulumi.getter(name="excludeInfoTypes")
    def exclude_info_types(self) -> bool:
        """
        When true, excludes type information of the findings. This is not used for data profiling.
        """
        return pulumi.get(self, "exclude_info_types")

    @property
    @pulumi.getter(name="includeQuote")
    def include_quote(self) -> bool:
        """
        When true, a contextual quote from the data that triggered a finding is included in the response; see Finding.quote. This is not used for data profiling.
        """
        return pulumi.get(self, "include_quote")

    @property
    @pulumi.getter(name="infoTypes")
    def info_types(self) -> Sequence['outputs.GooglePrivacyDlpV2InfoTypeResponse']:
        """
        Restricts what info_types to look for. The values must correspond to InfoType values returned by ListInfoTypes or listed at https://cloud.google.com/dlp/docs/infotypes-reference. When no InfoTypes or CustomInfoTypes are specified in a request, the system may automatically choose what detectors to run. By default this may be all types, but may change over time as detectors are updated. If you need precise control and predictability as to what detectors are run you should specify specific InfoTypes listed in the reference, otherwise a default list will be used, which may change over time.
        """
        return pulumi.get(self, "info_types")

    @property
    @pulumi.getter
    def limits(self) -> 'outputs.GooglePrivacyDlpV2FindingLimitsResponse':
        """
        Configuration to control the number of findings returned. This is not used for data profiling.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="minLikelihood")
    def min_likelihood(self) -> str:
        """
        Only returns findings equal or above this threshold. The default is POSSIBLE. See https://cloud.google.com/dlp/docs/likelihood to learn more.
        """
        return pulumi.get(self, "min_likelihood")

    @property
    @pulumi.getter(name="ruleSet")
    def rule_set(self) -> Sequence['outputs.GooglePrivacyDlpV2InspectionRuleSetResponse']:
        """
        Set of rules to apply to the findings for this InspectConfig. Exclusion rules, contained in the set are executed in the end, other rules are executed in the order they are specified for each info type.
        """
        return pulumi.get(self, "rule_set")


@pulumi.output_type
class GooglePrivacyDlpV2InspectDataSourceDetailsResponse(dict):
    """
    The results of an inspect DataSource job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestedOptions":
            suggest = "requested_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2InspectDataSourceDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2InspectDataSourceDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2InspectDataSourceDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 requested_options: 'outputs.GooglePrivacyDlpV2RequestedOptionsResponse',
                 result: 'outputs.GooglePrivacyDlpV2ResultResponse'):
        """
        The results of an inspect DataSource job.
        :param 'GooglePrivacyDlpV2RequestedOptionsResponse' requested_options: The configuration used for this job.
        :param 'GooglePrivacyDlpV2ResultResponse' result: A summary of the outcome of this inspection job.
        """
        pulumi.set(__self__, "requested_options", requested_options)
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter(name="requestedOptions")
    def requested_options(self) -> 'outputs.GooglePrivacyDlpV2RequestedOptionsResponse':
        """
        The configuration used for this job.
        """
        return pulumi.get(self, "requested_options")

    @property
    @pulumi.getter
    def result(self) -> 'outputs.GooglePrivacyDlpV2ResultResponse':
        """
        A summary of the outcome of this inspection job.
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class GooglePrivacyDlpV2InspectJobConfigResponse(dict):
    """
    Controls what and how to inspect for findings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inspectConfig":
            suggest = "inspect_config"
        elif key == "inspectTemplateName":
            suggest = "inspect_template_name"
        elif key == "storageConfig":
            suggest = "storage_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2InspectJobConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2InspectJobConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2InspectJobConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence['outputs.GooglePrivacyDlpV2ActionResponse'],
                 inspect_config: 'outputs.GooglePrivacyDlpV2InspectConfigResponse',
                 inspect_template_name: str,
                 storage_config: 'outputs.GooglePrivacyDlpV2StorageConfigResponse'):
        """
        Controls what and how to inspect for findings.
        :param Sequence['GooglePrivacyDlpV2ActionResponse'] actions: Actions to execute at the completion of the job.
        :param 'GooglePrivacyDlpV2InspectConfigResponse' inspect_config: How and what to scan for.
        :param str inspect_template_name: If provided, will be used as the default for all values in InspectConfig. `inspect_config` will be merged into the values persisted as part of the template.
        :param 'GooglePrivacyDlpV2StorageConfigResponse' storage_config: The data to scan.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "inspect_config", inspect_config)
        pulumi.set(__self__, "inspect_template_name", inspect_template_name)
        pulumi.set(__self__, "storage_config", storage_config)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GooglePrivacyDlpV2ActionResponse']:
        """
        Actions to execute at the completion of the job.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="inspectConfig")
    def inspect_config(self) -> 'outputs.GooglePrivacyDlpV2InspectConfigResponse':
        """
        How and what to scan for.
        """
        return pulumi.get(self, "inspect_config")

    @property
    @pulumi.getter(name="inspectTemplateName")
    def inspect_template_name(self) -> str:
        """
        If provided, will be used as the default for all values in InspectConfig. `inspect_config` will be merged into the values persisted as part of the template.
        """
        return pulumi.get(self, "inspect_template_name")

    @property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> 'outputs.GooglePrivacyDlpV2StorageConfigResponse':
        """
        The data to scan.
        """
        return pulumi.get(self, "storage_config")


@pulumi.output_type
class GooglePrivacyDlpV2InspectTemplateResponse(dict):
    """
    The inspectTemplate contains a configuration (set of types of sensitive data to be detected) to be used anywhere you otherwise would normally specify InspectConfig. See https://cloud.google.com/dlp/docs/concepts-templates to learn more.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "inspectConfig":
            suggest = "inspect_config"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2InspectTemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2InspectTemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2InspectTemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 display_name: str,
                 inspect_config: 'outputs.GooglePrivacyDlpV2InspectConfigResponse',
                 name: str,
                 update_time: str):
        """
        The inspectTemplate contains a configuration (set of types of sensitive data to be detected) to be used anywhere you otherwise would normally specify InspectConfig. See https://cloud.google.com/dlp/docs/concepts-templates to learn more.
        :param str create_time: The creation timestamp of an inspectTemplate.
        :param str description: Short description (max 256 chars).
        :param str display_name: Display name (max 256 chars).
        :param 'GooglePrivacyDlpV2InspectConfigResponse' inspect_config: The core content of the template. Configuration of the scanning process.
        :param str name: The template name. The template will have one of the following formats: `projects/PROJECT_ID/inspectTemplates/TEMPLATE_ID` OR `organizations/ORGANIZATION_ID/inspectTemplates/TEMPLATE_ID`;
        :param str update_time: The last update timestamp of an inspectTemplate.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "inspect_config", inspect_config)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation timestamp of an inspectTemplate.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Short description (max 256 chars).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name (max 256 chars).
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inspectConfig")
    def inspect_config(self) -> 'outputs.GooglePrivacyDlpV2InspectConfigResponse':
        """
        The core content of the template. Configuration of the scanning process.
        """
        return pulumi.get(self, "inspect_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The template name. The template will have one of the following formats: `projects/PROJECT_ID/inspectTemplates/TEMPLATE_ID` OR `organizations/ORGANIZATION_ID/inspectTemplates/TEMPLATE_ID`;
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last update timestamp of an inspectTemplate.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GooglePrivacyDlpV2InspectionRuleResponse(dict):
    """
    A single inspection rule to be applied to infoTypes, specified in `InspectionRuleSet`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusionRule":
            suggest = "exclusion_rule"
        elif key == "hotwordRule":
            suggest = "hotword_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2InspectionRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2InspectionRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2InspectionRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclusion_rule: 'outputs.GooglePrivacyDlpV2ExclusionRuleResponse',
                 hotword_rule: 'outputs.GooglePrivacyDlpV2HotwordRuleResponse'):
        """
        A single inspection rule to be applied to infoTypes, specified in `InspectionRuleSet`.
        :param 'GooglePrivacyDlpV2ExclusionRuleResponse' exclusion_rule: Exclusion rule.
        :param 'GooglePrivacyDlpV2HotwordRuleResponse' hotword_rule: Hotword-based detection rule.
        """
        pulumi.set(__self__, "exclusion_rule", exclusion_rule)
        pulumi.set(__self__, "hotword_rule", hotword_rule)

    @property
    @pulumi.getter(name="exclusionRule")
    def exclusion_rule(self) -> 'outputs.GooglePrivacyDlpV2ExclusionRuleResponse':
        """
        Exclusion rule.
        """
        return pulumi.get(self, "exclusion_rule")

    @property
    @pulumi.getter(name="hotwordRule")
    def hotword_rule(self) -> 'outputs.GooglePrivacyDlpV2HotwordRuleResponse':
        """
        Hotword-based detection rule.
        """
        return pulumi.get(self, "hotword_rule")


@pulumi.output_type
class GooglePrivacyDlpV2InspectionRuleSetResponse(dict):
    """
    Rule set for modifying a set of infoTypes to alter behavior under certain circumstances, depending on the specific details of the rules within the set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infoTypes":
            suggest = "info_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2InspectionRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2InspectionRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2InspectionRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 info_types: Sequence['outputs.GooglePrivacyDlpV2InfoTypeResponse'],
                 rules: Sequence['outputs.GooglePrivacyDlpV2InspectionRuleResponse']):
        """
        Rule set for modifying a set of infoTypes to alter behavior under certain circumstances, depending on the specific details of the rules within the set.
        :param Sequence['GooglePrivacyDlpV2InfoTypeResponse'] info_types: List of infoTypes this rule set is applied to.
        :param Sequence['GooglePrivacyDlpV2InspectionRuleResponse'] rules: Set of rules to be applied to infoTypes. The rules are applied in order.
        """
        pulumi.set(__self__, "info_types", info_types)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="infoTypes")
    def info_types(self) -> Sequence['outputs.GooglePrivacyDlpV2InfoTypeResponse']:
        """
        List of infoTypes this rule set is applied to.
        """
        return pulumi.get(self, "info_types")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GooglePrivacyDlpV2InspectionRuleResponse']:
        """
        Set of rules to be applied to infoTypes. The rules are applied in order.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class GooglePrivacyDlpV2JobNotificationEmailsResponse(dict):
    """
    Enable email notification to project owners and editors on jobs's completion/failure.
    """
    def __init__(__self__):
        """
        Enable email notification to project owners and editors on jobs's completion/failure.
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2KAnonymityConfigResponse(dict):
    """
    k-anonymity metric, used for analysis of reidentification risk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"
        elif key == "quasiIds":
            suggest = "quasi_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2KAnonymityConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2KAnonymityConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2KAnonymityConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_id: 'outputs.GooglePrivacyDlpV2EntityIdResponse',
                 quasi_ids: Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse']):
        """
        k-anonymity metric, used for analysis of reidentification risk.
        :param 'GooglePrivacyDlpV2EntityIdResponse' entity_id: Message indicating that multiple rows might be associated to a single individual. If the same entity_id is associated to multiple quasi-identifier tuples over distinct rows, we consider the entire collection of tuples as the composite quasi-identifier. This collection is a multiset: the order in which the different tuples appear in the dataset is ignored, but their frequency is taken into account. Important note: a maximum of 1000 rows can be associated to a single entity ID. If more rows are associated with the same entity ID, some might be ignored.
        :param Sequence['GooglePrivacyDlpV2FieldIdResponse'] quasi_ids: Set of fields to compute k-anonymity over. When multiple fields are specified, they are considered a single composite key. Structs and repeated data types are not supported; however, nested fields are supported so long as they are not structs themselves or nested within a repeated field.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "quasi_ids", quasi_ids)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> 'outputs.GooglePrivacyDlpV2EntityIdResponse':
        """
        Message indicating that multiple rows might be associated to a single individual. If the same entity_id is associated to multiple quasi-identifier tuples over distinct rows, we consider the entire collection of tuples as the composite quasi-identifier. This collection is a multiset: the order in which the different tuples appear in the dataset is ignored, but their frequency is taken into account. Important note: a maximum of 1000 rows can be associated to a single entity ID. If more rows are associated with the same entity ID, some might be ignored.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="quasiIds")
    def quasi_ids(self) -> Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse']:
        """
        Set of fields to compute k-anonymity over. When multiple fields are specified, they are considered a single composite key. Structs and repeated data types are not supported; however, nested fields are supported so long as they are not structs themselves or nested within a repeated field.
        """
        return pulumi.get(self, "quasi_ids")


@pulumi.output_type
class GooglePrivacyDlpV2KAnonymityEquivalenceClassResponse(dict):
    """
    The set of columns' values that share the same ldiversity value
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "equivalenceClassSize":
            suggest = "equivalence_class_size"
        elif key == "quasiIdsValues":
            suggest = "quasi_ids_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2KAnonymityEquivalenceClassResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2KAnonymityEquivalenceClassResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2KAnonymityEquivalenceClassResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 equivalence_class_size: str,
                 quasi_ids_values: Sequence['outputs.GooglePrivacyDlpV2ValueResponse']):
        """
        The set of columns' values that share the same ldiversity value
        :param str equivalence_class_size: Size of the equivalence class, for example number of rows with the above set of values.
        :param Sequence['GooglePrivacyDlpV2ValueResponse'] quasi_ids_values: Set of values defining the equivalence class. One value per quasi-identifier column in the original KAnonymity metric message. The order is always the same as the original request.
        """
        pulumi.set(__self__, "equivalence_class_size", equivalence_class_size)
        pulumi.set(__self__, "quasi_ids_values", quasi_ids_values)

    @property
    @pulumi.getter(name="equivalenceClassSize")
    def equivalence_class_size(self) -> str:
        """
        Size of the equivalence class, for example number of rows with the above set of values.
        """
        return pulumi.get(self, "equivalence_class_size")

    @property
    @pulumi.getter(name="quasiIdsValues")
    def quasi_ids_values(self) -> Sequence['outputs.GooglePrivacyDlpV2ValueResponse']:
        """
        Set of values defining the equivalence class. One value per quasi-identifier column in the original KAnonymity metric message. The order is always the same as the original request.
        """
        return pulumi.get(self, "quasi_ids_values")


@pulumi.output_type
class GooglePrivacyDlpV2KAnonymityHistogramBucketResponse(dict):
    """
    Histogram of k-anonymity equivalence classes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketSize":
            suggest = "bucket_size"
        elif key == "bucketValueCount":
            suggest = "bucket_value_count"
        elif key == "bucketValues":
            suggest = "bucket_values"
        elif key == "equivalenceClassSizeLowerBound":
            suggest = "equivalence_class_size_lower_bound"
        elif key == "equivalenceClassSizeUpperBound":
            suggest = "equivalence_class_size_upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2KAnonymityHistogramBucketResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2KAnonymityHistogramBucketResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2KAnonymityHistogramBucketResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_size: str,
                 bucket_value_count: str,
                 bucket_values: Sequence['outputs.GooglePrivacyDlpV2KAnonymityEquivalenceClassResponse'],
                 equivalence_class_size_lower_bound: str,
                 equivalence_class_size_upper_bound: str):
        """
        Histogram of k-anonymity equivalence classes.
        :param str bucket_size: Total number of equivalence classes in this bucket.
        :param str bucket_value_count: Total number of distinct equivalence classes in this bucket.
        :param Sequence['GooglePrivacyDlpV2KAnonymityEquivalenceClassResponse'] bucket_values: Sample of equivalence classes in this bucket. The total number of classes returned per bucket is capped at 20.
        :param str equivalence_class_size_lower_bound: Lower bound on the size of the equivalence classes in this bucket.
        :param str equivalence_class_size_upper_bound: Upper bound on the size of the equivalence classes in this bucket.
        """
        pulumi.set(__self__, "bucket_size", bucket_size)
        pulumi.set(__self__, "bucket_value_count", bucket_value_count)
        pulumi.set(__self__, "bucket_values", bucket_values)
        pulumi.set(__self__, "equivalence_class_size_lower_bound", equivalence_class_size_lower_bound)
        pulumi.set(__self__, "equivalence_class_size_upper_bound", equivalence_class_size_upper_bound)

    @property
    @pulumi.getter(name="bucketSize")
    def bucket_size(self) -> str:
        """
        Total number of equivalence classes in this bucket.
        """
        return pulumi.get(self, "bucket_size")

    @property
    @pulumi.getter(name="bucketValueCount")
    def bucket_value_count(self) -> str:
        """
        Total number of distinct equivalence classes in this bucket.
        """
        return pulumi.get(self, "bucket_value_count")

    @property
    @pulumi.getter(name="bucketValues")
    def bucket_values(self) -> Sequence['outputs.GooglePrivacyDlpV2KAnonymityEquivalenceClassResponse']:
        """
        Sample of equivalence classes in this bucket. The total number of classes returned per bucket is capped at 20.
        """
        return pulumi.get(self, "bucket_values")

    @property
    @pulumi.getter(name="equivalenceClassSizeLowerBound")
    def equivalence_class_size_lower_bound(self) -> str:
        """
        Lower bound on the size of the equivalence classes in this bucket.
        """
        return pulumi.get(self, "equivalence_class_size_lower_bound")

    @property
    @pulumi.getter(name="equivalenceClassSizeUpperBound")
    def equivalence_class_size_upper_bound(self) -> str:
        """
        Upper bound on the size of the equivalence classes in this bucket.
        """
        return pulumi.get(self, "equivalence_class_size_upper_bound")


@pulumi.output_type
class GooglePrivacyDlpV2KAnonymityResultResponse(dict):
    """
    Result of the k-anonymity computation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "equivalenceClassHistogramBuckets":
            suggest = "equivalence_class_histogram_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2KAnonymityResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2KAnonymityResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2KAnonymityResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 equivalence_class_histogram_buckets: Sequence['outputs.GooglePrivacyDlpV2KAnonymityHistogramBucketResponse']):
        """
        Result of the k-anonymity computation.
        :param Sequence['GooglePrivacyDlpV2KAnonymityHistogramBucketResponse'] equivalence_class_histogram_buckets: Histogram of k-anonymity equivalence classes.
        """
        pulumi.set(__self__, "equivalence_class_histogram_buckets", equivalence_class_histogram_buckets)

    @property
    @pulumi.getter(name="equivalenceClassHistogramBuckets")
    def equivalence_class_histogram_buckets(self) -> Sequence['outputs.GooglePrivacyDlpV2KAnonymityHistogramBucketResponse']:
        """
        Histogram of k-anonymity equivalence classes.
        """
        return pulumi.get(self, "equivalence_class_histogram_buckets")


@pulumi.output_type
class GooglePrivacyDlpV2KMapEstimationConfigResponse(dict):
    """
    Reidentifiability metric. This corresponds to a risk model similar to what is called "journalist risk" in the literature, except the attack dataset is statistically modeled instead of being perfectly known. This can be done using publicly available data (like the US Census), or using a custom statistical model (indicated as one or several BigQuery tables), or by extrapolating from the distribution of values in the input dataset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auxiliaryTables":
            suggest = "auxiliary_tables"
        elif key == "quasiIds":
            suggest = "quasi_ids"
        elif key == "regionCode":
            suggest = "region_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2KMapEstimationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2KMapEstimationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2KMapEstimationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auxiliary_tables: Sequence['outputs.GooglePrivacyDlpV2AuxiliaryTableResponse'],
                 quasi_ids: Sequence['outputs.GooglePrivacyDlpV2TaggedFieldResponse'],
                 region_code: str):
        """
        Reidentifiability metric. This corresponds to a risk model similar to what is called "journalist risk" in the literature, except the attack dataset is statistically modeled instead of being perfectly known. This can be done using publicly available data (like the US Census), or using a custom statistical model (indicated as one or several BigQuery tables), or by extrapolating from the distribution of values in the input dataset.
        :param Sequence['GooglePrivacyDlpV2AuxiliaryTableResponse'] auxiliary_tables: Several auxiliary tables can be used in the analysis. Each custom_tag used to tag a quasi-identifiers column must appear in exactly one column of one auxiliary table.
        :param Sequence['GooglePrivacyDlpV2TaggedFieldResponse'] quasi_ids: Fields considered to be quasi-identifiers. No two columns can have the same tag.
        :param str region_code: ISO 3166-1 alpha-2 region code to use in the statistical modeling. Set if no column is tagged with a region-specific InfoType (like US_ZIP_5) or a region code.
        """
        pulumi.set(__self__, "auxiliary_tables", auxiliary_tables)
        pulumi.set(__self__, "quasi_ids", quasi_ids)
        pulumi.set(__self__, "region_code", region_code)

    @property
    @pulumi.getter(name="auxiliaryTables")
    def auxiliary_tables(self) -> Sequence['outputs.GooglePrivacyDlpV2AuxiliaryTableResponse']:
        """
        Several auxiliary tables can be used in the analysis. Each custom_tag used to tag a quasi-identifiers column must appear in exactly one column of one auxiliary table.
        """
        return pulumi.get(self, "auxiliary_tables")

    @property
    @pulumi.getter(name="quasiIds")
    def quasi_ids(self) -> Sequence['outputs.GooglePrivacyDlpV2TaggedFieldResponse']:
        """
        Fields considered to be quasi-identifiers. No two columns can have the same tag.
        """
        return pulumi.get(self, "quasi_ids")

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> str:
        """
        ISO 3166-1 alpha-2 region code to use in the statistical modeling. Set if no column is tagged with a region-specific InfoType (like US_ZIP_5) or a region code.
        """
        return pulumi.get(self, "region_code")


@pulumi.output_type
class GooglePrivacyDlpV2KMapEstimationHistogramBucketResponse(dict):
    """
    A KMapEstimationHistogramBucket message with the following values: min_anonymity: 3 max_anonymity: 5 frequency: 42 means that there are 42 records whose quasi-identifier values correspond to 3, 4 or 5 people in the overlying population. An important particular case is when min_anonymity = max_anonymity = 1: the frequency field then corresponds to the number of uniquely identifiable records.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketSize":
            suggest = "bucket_size"
        elif key == "bucketValueCount":
            suggest = "bucket_value_count"
        elif key == "bucketValues":
            suggest = "bucket_values"
        elif key == "maxAnonymity":
            suggest = "max_anonymity"
        elif key == "minAnonymity":
            suggest = "min_anonymity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2KMapEstimationHistogramBucketResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2KMapEstimationHistogramBucketResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2KMapEstimationHistogramBucketResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_size: str,
                 bucket_value_count: str,
                 bucket_values: Sequence['outputs.GooglePrivacyDlpV2KMapEstimationQuasiIdValuesResponse'],
                 max_anonymity: str,
                 min_anonymity: str):
        """
        A KMapEstimationHistogramBucket message with the following values: min_anonymity: 3 max_anonymity: 5 frequency: 42 means that there are 42 records whose quasi-identifier values correspond to 3, 4 or 5 people in the overlying population. An important particular case is when min_anonymity = max_anonymity = 1: the frequency field then corresponds to the number of uniquely identifiable records.
        :param str bucket_size: Number of records within these anonymity bounds.
        :param str bucket_value_count: Total number of distinct quasi-identifier tuple values in this bucket.
        :param Sequence['GooglePrivacyDlpV2KMapEstimationQuasiIdValuesResponse'] bucket_values: Sample of quasi-identifier tuple values in this bucket. The total number of classes returned per bucket is capped at 20.
        :param str max_anonymity: Always greater than or equal to min_anonymity.
        :param str min_anonymity: Always positive.
        """
        pulumi.set(__self__, "bucket_size", bucket_size)
        pulumi.set(__self__, "bucket_value_count", bucket_value_count)
        pulumi.set(__self__, "bucket_values", bucket_values)
        pulumi.set(__self__, "max_anonymity", max_anonymity)
        pulumi.set(__self__, "min_anonymity", min_anonymity)

    @property
    @pulumi.getter(name="bucketSize")
    def bucket_size(self) -> str:
        """
        Number of records within these anonymity bounds.
        """
        return pulumi.get(self, "bucket_size")

    @property
    @pulumi.getter(name="bucketValueCount")
    def bucket_value_count(self) -> str:
        """
        Total number of distinct quasi-identifier tuple values in this bucket.
        """
        return pulumi.get(self, "bucket_value_count")

    @property
    @pulumi.getter(name="bucketValues")
    def bucket_values(self) -> Sequence['outputs.GooglePrivacyDlpV2KMapEstimationQuasiIdValuesResponse']:
        """
        Sample of quasi-identifier tuple values in this bucket. The total number of classes returned per bucket is capped at 20.
        """
        return pulumi.get(self, "bucket_values")

    @property
    @pulumi.getter(name="maxAnonymity")
    def max_anonymity(self) -> str:
        """
        Always greater than or equal to min_anonymity.
        """
        return pulumi.get(self, "max_anonymity")

    @property
    @pulumi.getter(name="minAnonymity")
    def min_anonymity(self) -> str:
        """
        Always positive.
        """
        return pulumi.get(self, "min_anonymity")


@pulumi.output_type
class GooglePrivacyDlpV2KMapEstimationQuasiIdValuesResponse(dict):
    """
    A tuple of values for the quasi-identifier columns.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "estimatedAnonymity":
            suggest = "estimated_anonymity"
        elif key == "quasiIdsValues":
            suggest = "quasi_ids_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2KMapEstimationQuasiIdValuesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2KMapEstimationQuasiIdValuesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2KMapEstimationQuasiIdValuesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 estimated_anonymity: str,
                 quasi_ids_values: Sequence['outputs.GooglePrivacyDlpV2ValueResponse']):
        """
        A tuple of values for the quasi-identifier columns.
        :param str estimated_anonymity: The estimated anonymity for these quasi-identifier values.
        :param Sequence['GooglePrivacyDlpV2ValueResponse'] quasi_ids_values: The quasi-identifier values.
        """
        pulumi.set(__self__, "estimated_anonymity", estimated_anonymity)
        pulumi.set(__self__, "quasi_ids_values", quasi_ids_values)

    @property
    @pulumi.getter(name="estimatedAnonymity")
    def estimated_anonymity(self) -> str:
        """
        The estimated anonymity for these quasi-identifier values.
        """
        return pulumi.get(self, "estimated_anonymity")

    @property
    @pulumi.getter(name="quasiIdsValues")
    def quasi_ids_values(self) -> Sequence['outputs.GooglePrivacyDlpV2ValueResponse']:
        """
        The quasi-identifier values.
        """
        return pulumi.get(self, "quasi_ids_values")


@pulumi.output_type
class GooglePrivacyDlpV2KMapEstimationResultResponse(dict):
    """
    Result of the reidentifiability analysis. Note that these results are an estimation, not exact values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kMapEstimationHistogram":
            suggest = "k_map_estimation_histogram"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2KMapEstimationResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2KMapEstimationResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2KMapEstimationResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 k_map_estimation_histogram: Sequence['outputs.GooglePrivacyDlpV2KMapEstimationHistogramBucketResponse']):
        """
        Result of the reidentifiability analysis. Note that these results are an estimation, not exact values.
        :param Sequence['GooglePrivacyDlpV2KMapEstimationHistogramBucketResponse'] k_map_estimation_histogram: The intervals [min_anonymity, max_anonymity] do not overlap. If a value doesn't correspond to any such interval, the associated frequency is zero. For example, the following records: {min_anonymity: 1, max_anonymity: 1, frequency: 17} {min_anonymity: 2, max_anonymity: 3, frequency: 42} {min_anonymity: 5, max_anonymity: 10, frequency: 99} mean that there are no record with an estimated anonymity of 4, 5, or larger than 10.
        """
        pulumi.set(__self__, "k_map_estimation_histogram", k_map_estimation_histogram)

    @property
    @pulumi.getter(name="kMapEstimationHistogram")
    def k_map_estimation_histogram(self) -> Sequence['outputs.GooglePrivacyDlpV2KMapEstimationHistogramBucketResponse']:
        """
        The intervals [min_anonymity, max_anonymity] do not overlap. If a value doesn't correspond to any such interval, the associated frequency is zero. For example, the following records: {min_anonymity: 1, max_anonymity: 1, frequency: 17} {min_anonymity: 2, max_anonymity: 3, frequency: 42} {min_anonymity: 5, max_anonymity: 10, frequency: 99} mean that there are no record with an estimated anonymity of 4, 5, or larger than 10.
        """
        return pulumi.get(self, "k_map_estimation_histogram")


@pulumi.output_type
class GooglePrivacyDlpV2KindExpressionResponse(dict):
    """
    A representation of a Datastore kind.
    """
    def __init__(__self__, *,
                 name: str):
        """
        A representation of a Datastore kind.
        :param str name: The name of the kind.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the kind.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GooglePrivacyDlpV2KmsWrappedCryptoKeyResponse(dict):
    """
    Include to use an existing data crypto key wrapped by KMS. The wrapped key must be a 128-, 192-, or 256-bit key. Authorization requires the following IAM permissions when sending a request to perform a crypto transformation using a KMS-wrapped crypto key: dlp.kms.encrypt For more information, see [Creating a wrapped key] (https://cloud.google.com/dlp/docs/create-wrapped-key). Note: When you use Cloud KMS for cryptographic operations, [charges apply](https://cloud.google.com/kms/pricing).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cryptoKeyName":
            suggest = "crypto_key_name"
        elif key == "wrappedKey":
            suggest = "wrapped_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2KmsWrappedCryptoKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2KmsWrappedCryptoKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2KmsWrappedCryptoKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crypto_key_name: str,
                 wrapped_key: str):
        """
        Include to use an existing data crypto key wrapped by KMS. The wrapped key must be a 128-, 192-, or 256-bit key. Authorization requires the following IAM permissions when sending a request to perform a crypto transformation using a KMS-wrapped crypto key: dlp.kms.encrypt For more information, see [Creating a wrapped key] (https://cloud.google.com/dlp/docs/create-wrapped-key). Note: When you use Cloud KMS for cryptographic operations, [charges apply](https://cloud.google.com/kms/pricing).
        :param str crypto_key_name: The resource name of the KMS CryptoKey to use for unwrapping.
        :param str wrapped_key: The wrapped data crypto key.
        """
        pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        pulumi.set(__self__, "wrapped_key", wrapped_key)

    @property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> str:
        """
        The resource name of the KMS CryptoKey to use for unwrapping.
        """
        return pulumi.get(self, "crypto_key_name")

    @property
    @pulumi.getter(name="wrappedKey")
    def wrapped_key(self) -> str:
        """
        The wrapped data crypto key.
        """
        return pulumi.get(self, "wrapped_key")


@pulumi.output_type
class GooglePrivacyDlpV2LDiversityConfigResponse(dict):
    """
    l-diversity metric, used for analysis of reidentification risk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quasiIds":
            suggest = "quasi_ids"
        elif key == "sensitiveAttribute":
            suggest = "sensitive_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2LDiversityConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2LDiversityConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2LDiversityConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quasi_ids: Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse'],
                 sensitive_attribute: 'outputs.GooglePrivacyDlpV2FieldIdResponse'):
        """
        l-diversity metric, used for analysis of reidentification risk.
        :param Sequence['GooglePrivacyDlpV2FieldIdResponse'] quasi_ids: Set of quasi-identifiers indicating how equivalence classes are defined for the l-diversity computation. When multiple fields are specified, they are considered a single composite key.
        :param 'GooglePrivacyDlpV2FieldIdResponse' sensitive_attribute: Sensitive field for computing the l-value.
        """
        pulumi.set(__self__, "quasi_ids", quasi_ids)
        pulumi.set(__self__, "sensitive_attribute", sensitive_attribute)

    @property
    @pulumi.getter(name="quasiIds")
    def quasi_ids(self) -> Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse']:
        """
        Set of quasi-identifiers indicating how equivalence classes are defined for the l-diversity computation. When multiple fields are specified, they are considered a single composite key.
        """
        return pulumi.get(self, "quasi_ids")

    @property
    @pulumi.getter(name="sensitiveAttribute")
    def sensitive_attribute(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Sensitive field for computing the l-value.
        """
        return pulumi.get(self, "sensitive_attribute")


@pulumi.output_type
class GooglePrivacyDlpV2LDiversityEquivalenceClassResponse(dict):
    """
    The set of columns' values that share the same ldiversity value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "equivalenceClassSize":
            suggest = "equivalence_class_size"
        elif key == "numDistinctSensitiveValues":
            suggest = "num_distinct_sensitive_values"
        elif key == "quasiIdsValues":
            suggest = "quasi_ids_values"
        elif key == "topSensitiveValues":
            suggest = "top_sensitive_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2LDiversityEquivalenceClassResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2LDiversityEquivalenceClassResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2LDiversityEquivalenceClassResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 equivalence_class_size: str,
                 num_distinct_sensitive_values: str,
                 quasi_ids_values: Sequence['outputs.GooglePrivacyDlpV2ValueResponse'],
                 top_sensitive_values: Sequence['outputs.GooglePrivacyDlpV2ValueFrequencyResponse']):
        """
        The set of columns' values that share the same ldiversity value.
        :param str equivalence_class_size: Size of the k-anonymity equivalence class.
        :param str num_distinct_sensitive_values: Number of distinct sensitive values in this equivalence class.
        :param Sequence['GooglePrivacyDlpV2ValueResponse'] quasi_ids_values: Quasi-identifier values defining the k-anonymity equivalence class. The order is always the same as the original request.
        :param Sequence['GooglePrivacyDlpV2ValueFrequencyResponse'] top_sensitive_values: Estimated frequencies of top sensitive values.
        """
        pulumi.set(__self__, "equivalence_class_size", equivalence_class_size)
        pulumi.set(__self__, "num_distinct_sensitive_values", num_distinct_sensitive_values)
        pulumi.set(__self__, "quasi_ids_values", quasi_ids_values)
        pulumi.set(__self__, "top_sensitive_values", top_sensitive_values)

    @property
    @pulumi.getter(name="equivalenceClassSize")
    def equivalence_class_size(self) -> str:
        """
        Size of the k-anonymity equivalence class.
        """
        return pulumi.get(self, "equivalence_class_size")

    @property
    @pulumi.getter(name="numDistinctSensitiveValues")
    def num_distinct_sensitive_values(self) -> str:
        """
        Number of distinct sensitive values in this equivalence class.
        """
        return pulumi.get(self, "num_distinct_sensitive_values")

    @property
    @pulumi.getter(name="quasiIdsValues")
    def quasi_ids_values(self) -> Sequence['outputs.GooglePrivacyDlpV2ValueResponse']:
        """
        Quasi-identifier values defining the k-anonymity equivalence class. The order is always the same as the original request.
        """
        return pulumi.get(self, "quasi_ids_values")

    @property
    @pulumi.getter(name="topSensitiveValues")
    def top_sensitive_values(self) -> Sequence['outputs.GooglePrivacyDlpV2ValueFrequencyResponse']:
        """
        Estimated frequencies of top sensitive values.
        """
        return pulumi.get(self, "top_sensitive_values")


@pulumi.output_type
class GooglePrivacyDlpV2LDiversityHistogramBucketResponse(dict):
    """
    Histogram of l-diversity equivalence class sensitive value frequencies.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketSize":
            suggest = "bucket_size"
        elif key == "bucketValueCount":
            suggest = "bucket_value_count"
        elif key == "bucketValues":
            suggest = "bucket_values"
        elif key == "sensitiveValueFrequencyLowerBound":
            suggest = "sensitive_value_frequency_lower_bound"
        elif key == "sensitiveValueFrequencyUpperBound":
            suggest = "sensitive_value_frequency_upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2LDiversityHistogramBucketResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2LDiversityHistogramBucketResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2LDiversityHistogramBucketResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_size: str,
                 bucket_value_count: str,
                 bucket_values: Sequence['outputs.GooglePrivacyDlpV2LDiversityEquivalenceClassResponse'],
                 sensitive_value_frequency_lower_bound: str,
                 sensitive_value_frequency_upper_bound: str):
        """
        Histogram of l-diversity equivalence class sensitive value frequencies.
        :param str bucket_size: Total number of equivalence classes in this bucket.
        :param str bucket_value_count: Total number of distinct equivalence classes in this bucket.
        :param Sequence['GooglePrivacyDlpV2LDiversityEquivalenceClassResponse'] bucket_values: Sample of equivalence classes in this bucket. The total number of classes returned per bucket is capped at 20.
        :param str sensitive_value_frequency_lower_bound: Lower bound on the sensitive value frequencies of the equivalence classes in this bucket.
        :param str sensitive_value_frequency_upper_bound: Upper bound on the sensitive value frequencies of the equivalence classes in this bucket.
        """
        pulumi.set(__self__, "bucket_size", bucket_size)
        pulumi.set(__self__, "bucket_value_count", bucket_value_count)
        pulumi.set(__self__, "bucket_values", bucket_values)
        pulumi.set(__self__, "sensitive_value_frequency_lower_bound", sensitive_value_frequency_lower_bound)
        pulumi.set(__self__, "sensitive_value_frequency_upper_bound", sensitive_value_frequency_upper_bound)

    @property
    @pulumi.getter(name="bucketSize")
    def bucket_size(self) -> str:
        """
        Total number of equivalence classes in this bucket.
        """
        return pulumi.get(self, "bucket_size")

    @property
    @pulumi.getter(name="bucketValueCount")
    def bucket_value_count(self) -> str:
        """
        Total number of distinct equivalence classes in this bucket.
        """
        return pulumi.get(self, "bucket_value_count")

    @property
    @pulumi.getter(name="bucketValues")
    def bucket_values(self) -> Sequence['outputs.GooglePrivacyDlpV2LDiversityEquivalenceClassResponse']:
        """
        Sample of equivalence classes in this bucket. The total number of classes returned per bucket is capped at 20.
        """
        return pulumi.get(self, "bucket_values")

    @property
    @pulumi.getter(name="sensitiveValueFrequencyLowerBound")
    def sensitive_value_frequency_lower_bound(self) -> str:
        """
        Lower bound on the sensitive value frequencies of the equivalence classes in this bucket.
        """
        return pulumi.get(self, "sensitive_value_frequency_lower_bound")

    @property
    @pulumi.getter(name="sensitiveValueFrequencyUpperBound")
    def sensitive_value_frequency_upper_bound(self) -> str:
        """
        Upper bound on the sensitive value frequencies of the equivalence classes in this bucket.
        """
        return pulumi.get(self, "sensitive_value_frequency_upper_bound")


@pulumi.output_type
class GooglePrivacyDlpV2LDiversityResultResponse(dict):
    """
    Result of the l-diversity computation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sensitiveValueFrequencyHistogramBuckets":
            suggest = "sensitive_value_frequency_histogram_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2LDiversityResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2LDiversityResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2LDiversityResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sensitive_value_frequency_histogram_buckets: Sequence['outputs.GooglePrivacyDlpV2LDiversityHistogramBucketResponse']):
        """
        Result of the l-diversity computation.
        :param Sequence['GooglePrivacyDlpV2LDiversityHistogramBucketResponse'] sensitive_value_frequency_histogram_buckets: Histogram of l-diversity equivalence class sensitive value frequencies.
        """
        pulumi.set(__self__, "sensitive_value_frequency_histogram_buckets", sensitive_value_frequency_histogram_buckets)

    @property
    @pulumi.getter(name="sensitiveValueFrequencyHistogramBuckets")
    def sensitive_value_frequency_histogram_buckets(self) -> Sequence['outputs.GooglePrivacyDlpV2LDiversityHistogramBucketResponse']:
        """
        Histogram of l-diversity equivalence class sensitive value frequencies.
        """
        return pulumi.get(self, "sensitive_value_frequency_histogram_buckets")


@pulumi.output_type
class GooglePrivacyDlpV2LargeCustomDictionaryConfigResponse(dict):
    """
    Configuration for a custom dictionary created from a data source of any size up to the maximum size defined in the [limits](https://cloud.google.com/dlp/limits) page. The artifacts of dictionary creation are stored in the specified Google Cloud Storage location. Consider using `CustomInfoType.Dictionary` for smaller dictionaries that satisfy the size requirements.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigQueryField":
            suggest = "big_query_field"
        elif key == "cloudStorageFileSet":
            suggest = "cloud_storage_file_set"
        elif key == "outputPath":
            suggest = "output_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2LargeCustomDictionaryConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2LargeCustomDictionaryConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2LargeCustomDictionaryConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 big_query_field: 'outputs.GooglePrivacyDlpV2BigQueryFieldResponse',
                 cloud_storage_file_set: 'outputs.GooglePrivacyDlpV2CloudStorageFileSetResponse',
                 output_path: 'outputs.GooglePrivacyDlpV2CloudStoragePathResponse'):
        """
        Configuration for a custom dictionary created from a data source of any size up to the maximum size defined in the [limits](https://cloud.google.com/dlp/limits) page. The artifacts of dictionary creation are stored in the specified Google Cloud Storage location. Consider using `CustomInfoType.Dictionary` for smaller dictionaries that satisfy the size requirements.
        :param 'GooglePrivacyDlpV2BigQueryFieldResponse' big_query_field: Field in a BigQuery table where each cell represents a dictionary phrase.
        :param 'GooglePrivacyDlpV2CloudStorageFileSetResponse' cloud_storage_file_set: Set of files containing newline-delimited lists of dictionary phrases.
        :param 'GooglePrivacyDlpV2CloudStoragePathResponse' output_path: Location to store dictionary artifacts in Google Cloud Storage. These files will only be accessible by project owners and the DLP API. If any of these artifacts are modified, the dictionary is considered invalid and can no longer be used.
        """
        pulumi.set(__self__, "big_query_field", big_query_field)
        pulumi.set(__self__, "cloud_storage_file_set", cloud_storage_file_set)
        pulumi.set(__self__, "output_path", output_path)

    @property
    @pulumi.getter(name="bigQueryField")
    def big_query_field(self) -> 'outputs.GooglePrivacyDlpV2BigQueryFieldResponse':
        """
        Field in a BigQuery table where each cell represents a dictionary phrase.
        """
        return pulumi.get(self, "big_query_field")

    @property
    @pulumi.getter(name="cloudStorageFileSet")
    def cloud_storage_file_set(self) -> 'outputs.GooglePrivacyDlpV2CloudStorageFileSetResponse':
        """
        Set of files containing newline-delimited lists of dictionary phrases.
        """
        return pulumi.get(self, "cloud_storage_file_set")

    @property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> 'outputs.GooglePrivacyDlpV2CloudStoragePathResponse':
        """
        Location to store dictionary artifacts in Google Cloud Storage. These files will only be accessible by project owners and the DLP API. If any of these artifacts are modified, the dictionary is considered invalid and can no longer be used.
        """
        return pulumi.get(self, "output_path")


@pulumi.output_type
class GooglePrivacyDlpV2LargeCustomDictionaryStatsResponse(dict):
    """
    Summary statistics of a custom dictionary.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approxNumPhrases":
            suggest = "approx_num_phrases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2LargeCustomDictionaryStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2LargeCustomDictionaryStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2LargeCustomDictionaryStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approx_num_phrases: str):
        """
        Summary statistics of a custom dictionary.
        :param str approx_num_phrases: Approximate number of distinct phrases in the dictionary.
        """
        pulumi.set(__self__, "approx_num_phrases", approx_num_phrases)

    @property
    @pulumi.getter(name="approxNumPhrases")
    def approx_num_phrases(self) -> str:
        """
        Approximate number of distinct phrases in the dictionary.
        """
        return pulumi.get(self, "approx_num_phrases")


@pulumi.output_type
class GooglePrivacyDlpV2LeaveUntransformedResponse(dict):
    """
    Skips the data without modifying it if the requested transformation would cause an error. For example, if a `DateShift` transformation were applied an an IP address, this mode would leave the IP address unchanged in the response.
    """
    def __init__(__self__):
        """
        Skips the data without modifying it if the requested transformation would cause an error. For example, if a `DateShift` transformation were applied an an IP address, this mode would leave the IP address unchanged in the response.
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2LikelihoodAdjustmentResponse(dict):
    """
    Message for specifying an adjustment to the likelihood of a finding as part of a detection rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedLikelihood":
            suggest = "fixed_likelihood"
        elif key == "relativeLikelihood":
            suggest = "relative_likelihood"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2LikelihoodAdjustmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2LikelihoodAdjustmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2LikelihoodAdjustmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_likelihood: str,
                 relative_likelihood: int):
        """
        Message for specifying an adjustment to the likelihood of a finding as part of a detection rule.
        :param str fixed_likelihood: Set the likelihood of a finding to a fixed value.
        :param int relative_likelihood: Increase or decrease the likelihood by the specified number of levels. For example, if a finding would be `POSSIBLE` without the detection rule and `relative_likelihood` is 1, then it is upgraded to `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`. Likelihood may never drop below `VERY_UNLIKELY` or exceed `VERY_LIKELY`, so applying an adjustment of 1 followed by an adjustment of -1 when base likelihood is `VERY_LIKELY` will result in a final likelihood of `LIKELY`.
        """
        pulumi.set(__self__, "fixed_likelihood", fixed_likelihood)
        pulumi.set(__self__, "relative_likelihood", relative_likelihood)

    @property
    @pulumi.getter(name="fixedLikelihood")
    def fixed_likelihood(self) -> str:
        """
        Set the likelihood of a finding to a fixed value.
        """
        return pulumi.get(self, "fixed_likelihood")

    @property
    @pulumi.getter(name="relativeLikelihood")
    def relative_likelihood(self) -> int:
        """
        Increase or decrease the likelihood by the specified number of levels. For example, if a finding would be `POSSIBLE` without the detection rule and `relative_likelihood` is 1, then it is upgraded to `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`. Likelihood may never drop below `VERY_UNLIKELY` or exceed `VERY_LIKELY`, so applying an adjustment of 1 followed by an adjustment of -1 when base likelihood is `VERY_LIKELY` will result in a final likelihood of `LIKELY`.
        """
        return pulumi.get(self, "relative_likelihood")


@pulumi.output_type
class GooglePrivacyDlpV2ManualResponse(dict):
    """
    Job trigger option for hybrid jobs. Jobs must be manually created and finished.
    """
    def __init__(__self__):
        """
        Job trigger option for hybrid jobs. Jobs must be manually created and finished.
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2NumericalStatsConfigResponse(dict):
    """
    Compute numerical stats over an individual column, including min, max, and quantiles.
    """
    def __init__(__self__, *,
                 field: 'outputs.GooglePrivacyDlpV2FieldIdResponse'):
        """
        Compute numerical stats over an individual column, including min, max, and quantiles.
        :param 'GooglePrivacyDlpV2FieldIdResponse' field: Field to compute numerical stats on. Supported types are integer, float, date, datetime, timestamp, time.
        """
        pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Field to compute numerical stats on. Supported types are integer, float, date, datetime, timestamp, time.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class GooglePrivacyDlpV2NumericalStatsResultResponse(dict):
    """
    Result of the numerical stats computation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"
        elif key == "quantileValues":
            suggest = "quantile_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2NumericalStatsResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2NumericalStatsResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2NumericalStatsResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: 'outputs.GooglePrivacyDlpV2ValueResponse',
                 min_value: 'outputs.GooglePrivacyDlpV2ValueResponse',
                 quantile_values: Sequence['outputs.GooglePrivacyDlpV2ValueResponse']):
        """
        Result of the numerical stats computation.
        :param 'GooglePrivacyDlpV2ValueResponse' max_value: Maximum value appearing in the column.
        :param 'GooglePrivacyDlpV2ValueResponse' min_value: Minimum value appearing in the column.
        :param Sequence['GooglePrivacyDlpV2ValueResponse'] quantile_values: List of 99 values that partition the set of field values into 100 equal sized buckets.
        """
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)
        pulumi.set(__self__, "quantile_values", quantile_values)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        Maximum value appearing in the column.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        Minimum value appearing in the column.
        """
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter(name="quantileValues")
    def quantile_values(self) -> Sequence['outputs.GooglePrivacyDlpV2ValueResponse']:
        """
        List of 99 values that partition the set of field values into 100 equal sized buckets.
        """
        return pulumi.get(self, "quantile_values")


@pulumi.output_type
class GooglePrivacyDlpV2OutputStorageConfigResponse(dict):
    """
    Cloud repository for storing output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputSchema":
            suggest = "output_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2OutputStorageConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2OutputStorageConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2OutputStorageConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_schema: str,
                 table: 'outputs.GooglePrivacyDlpV2BigQueryTableResponse'):
        """
        Cloud repository for storing output.
        :param str output_schema: Schema used for writing the findings for Inspect jobs. This field is only used for Inspect and must be unspecified for Risk jobs. Columns are derived from the `Finding` object. If appending to an existing table, any columns from the predefined schema that are missing will be added. No columns in the existing table will be deleted. If unspecified, then all available columns will be used for a new table or an (existing) table with no schema, and no changes will be made to an existing table that has a schema. Only for use with external storage.
        :param 'GooglePrivacyDlpV2BigQueryTableResponse' table: Store findings in an existing table or a new table in an existing dataset. If table_id is not set a new one will be generated for you with the following format: dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific timezone will be used for generating the date details. For Inspect, each column in an existing output table must have the same name, type, and mode of a field in the `Finding` object. For Risk, an existing output table should be the output of a previous Risk analysis job run on the same source table, with the same privacy metric and quasi-identifiers. Risk jobs that analyze the same table but compute a different privacy metric, or use different sets of quasi-identifiers, cannot store their results in the same table.
        """
        pulumi.set(__self__, "output_schema", output_schema)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="outputSchema")
    def output_schema(self) -> str:
        """
        Schema used for writing the findings for Inspect jobs. This field is only used for Inspect and must be unspecified for Risk jobs. Columns are derived from the `Finding` object. If appending to an existing table, any columns from the predefined schema that are missing will be added. No columns in the existing table will be deleted. If unspecified, then all available columns will be used for a new table or an (existing) table with no schema, and no changes will be made to an existing table that has a schema. Only for use with external storage.
        """
        return pulumi.get(self, "output_schema")

    @property
    @pulumi.getter
    def table(self) -> 'outputs.GooglePrivacyDlpV2BigQueryTableResponse':
        """
        Store findings in an existing table or a new table in an existing dataset. If table_id is not set a new one will be generated for you with the following format: dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific timezone will be used for generating the date details. For Inspect, each column in an existing output table must have the same name, type, and mode of a field in the `Finding` object. For Risk, an existing output table should be the output of a previous Risk analysis job run on the same source table, with the same privacy metric and quasi-identifiers. Risk jobs that analyze the same table but compute a different privacy metric, or use different sets of quasi-identifiers, cannot store their results in the same table.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class GooglePrivacyDlpV2PartitionIdResponse(dict):
    """
    Datastore partition ID. A partition ID identifies a grouping of entities. The grouping is always by project and namespace, however the namespace ID may be empty. A partition ID contains several dimensions: project ID and namespace ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespaceId":
            suggest = "namespace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2PartitionIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2PartitionIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2PartitionIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace_id: str,
                 project: str):
        """
        Datastore partition ID. A partition ID identifies a grouping of entities. The grouping is always by project and namespace, however the namespace ID may be empty. A partition ID contains several dimensions: project ID and namespace ID.
        :param str namespace_id: If not empty, the ID of the namespace to which the entities belong.
        :param str project: The ID of the project to which the entities belong.
        """
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> str:
        """
        If not empty, the ID of the namespace to which the entities belong.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project to which the entities belong.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GooglePrivacyDlpV2PrimitiveTransformationResponse(dict):
    """
    A rule for transforming a value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketingConfig":
            suggest = "bucketing_config"
        elif key == "characterMaskConfig":
            suggest = "character_mask_config"
        elif key == "cryptoDeterministicConfig":
            suggest = "crypto_deterministic_config"
        elif key == "cryptoHashConfig":
            suggest = "crypto_hash_config"
        elif key == "cryptoReplaceFfxFpeConfig":
            suggest = "crypto_replace_ffx_fpe_config"
        elif key == "dateShiftConfig":
            suggest = "date_shift_config"
        elif key == "fixedSizeBucketingConfig":
            suggest = "fixed_size_bucketing_config"
        elif key == "redactConfig":
            suggest = "redact_config"
        elif key == "replaceConfig":
            suggest = "replace_config"
        elif key == "replaceDictionaryConfig":
            suggest = "replace_dictionary_config"
        elif key == "replaceWithInfoTypeConfig":
            suggest = "replace_with_info_type_config"
        elif key == "timePartConfig":
            suggest = "time_part_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2PrimitiveTransformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2PrimitiveTransformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2PrimitiveTransformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucketing_config: 'outputs.GooglePrivacyDlpV2BucketingConfigResponse',
                 character_mask_config: 'outputs.GooglePrivacyDlpV2CharacterMaskConfigResponse',
                 crypto_deterministic_config: 'outputs.GooglePrivacyDlpV2CryptoDeterministicConfigResponse',
                 crypto_hash_config: 'outputs.GooglePrivacyDlpV2CryptoHashConfigResponse',
                 crypto_replace_ffx_fpe_config: 'outputs.GooglePrivacyDlpV2CryptoReplaceFfxFpeConfigResponse',
                 date_shift_config: 'outputs.GooglePrivacyDlpV2DateShiftConfigResponse',
                 fixed_size_bucketing_config: 'outputs.GooglePrivacyDlpV2FixedSizeBucketingConfigResponse',
                 redact_config: 'outputs.GooglePrivacyDlpV2RedactConfigResponse',
                 replace_config: 'outputs.GooglePrivacyDlpV2ReplaceValueConfigResponse',
                 replace_dictionary_config: 'outputs.GooglePrivacyDlpV2ReplaceDictionaryConfigResponse',
                 replace_with_info_type_config: 'outputs.GooglePrivacyDlpV2ReplaceWithInfoTypeConfigResponse',
                 time_part_config: 'outputs.GooglePrivacyDlpV2TimePartConfigResponse'):
        """
        A rule for transforming a value.
        :param 'GooglePrivacyDlpV2BucketingConfigResponse' bucketing_config: Bucketing
        :param 'GooglePrivacyDlpV2CharacterMaskConfigResponse' character_mask_config: Mask
        :param 'GooglePrivacyDlpV2CryptoDeterministicConfigResponse' crypto_deterministic_config: Deterministic Crypto
        :param 'GooglePrivacyDlpV2CryptoHashConfigResponse' crypto_hash_config: Crypto
        :param 'GooglePrivacyDlpV2CryptoReplaceFfxFpeConfigResponse' crypto_replace_ffx_fpe_config: Ffx-Fpe
        :param 'GooglePrivacyDlpV2DateShiftConfigResponse' date_shift_config: Date Shift
        :param 'GooglePrivacyDlpV2FixedSizeBucketingConfigResponse' fixed_size_bucketing_config: Fixed size bucketing
        :param 'GooglePrivacyDlpV2RedactConfigResponse' redact_config: Redact
        :param 'GooglePrivacyDlpV2ReplaceValueConfigResponse' replace_config: Replace with a specified value.
        :param 'GooglePrivacyDlpV2ReplaceDictionaryConfigResponse' replace_dictionary_config: Replace with a value randomly drawn (with replacement) from a dictionary.
        :param 'GooglePrivacyDlpV2ReplaceWithInfoTypeConfigResponse' replace_with_info_type_config: Replace with infotype
        :param 'GooglePrivacyDlpV2TimePartConfigResponse' time_part_config: Time extraction
        """
        pulumi.set(__self__, "bucketing_config", bucketing_config)
        pulumi.set(__self__, "character_mask_config", character_mask_config)
        pulumi.set(__self__, "crypto_deterministic_config", crypto_deterministic_config)
        pulumi.set(__self__, "crypto_hash_config", crypto_hash_config)
        pulumi.set(__self__, "crypto_replace_ffx_fpe_config", crypto_replace_ffx_fpe_config)
        pulumi.set(__self__, "date_shift_config", date_shift_config)
        pulumi.set(__self__, "fixed_size_bucketing_config", fixed_size_bucketing_config)
        pulumi.set(__self__, "redact_config", redact_config)
        pulumi.set(__self__, "replace_config", replace_config)
        pulumi.set(__self__, "replace_dictionary_config", replace_dictionary_config)
        pulumi.set(__self__, "replace_with_info_type_config", replace_with_info_type_config)
        pulumi.set(__self__, "time_part_config", time_part_config)

    @property
    @pulumi.getter(name="bucketingConfig")
    def bucketing_config(self) -> 'outputs.GooglePrivacyDlpV2BucketingConfigResponse':
        """
        Bucketing
        """
        return pulumi.get(self, "bucketing_config")

    @property
    @pulumi.getter(name="characterMaskConfig")
    def character_mask_config(self) -> 'outputs.GooglePrivacyDlpV2CharacterMaskConfigResponse':
        """
        Mask
        """
        return pulumi.get(self, "character_mask_config")

    @property
    @pulumi.getter(name="cryptoDeterministicConfig")
    def crypto_deterministic_config(self) -> 'outputs.GooglePrivacyDlpV2CryptoDeterministicConfigResponse':
        """
        Deterministic Crypto
        """
        return pulumi.get(self, "crypto_deterministic_config")

    @property
    @pulumi.getter(name="cryptoHashConfig")
    def crypto_hash_config(self) -> 'outputs.GooglePrivacyDlpV2CryptoHashConfigResponse':
        """
        Crypto
        """
        return pulumi.get(self, "crypto_hash_config")

    @property
    @pulumi.getter(name="cryptoReplaceFfxFpeConfig")
    def crypto_replace_ffx_fpe_config(self) -> 'outputs.GooglePrivacyDlpV2CryptoReplaceFfxFpeConfigResponse':
        """
        Ffx-Fpe
        """
        return pulumi.get(self, "crypto_replace_ffx_fpe_config")

    @property
    @pulumi.getter(name="dateShiftConfig")
    def date_shift_config(self) -> 'outputs.GooglePrivacyDlpV2DateShiftConfigResponse':
        """
        Date Shift
        """
        return pulumi.get(self, "date_shift_config")

    @property
    @pulumi.getter(name="fixedSizeBucketingConfig")
    def fixed_size_bucketing_config(self) -> 'outputs.GooglePrivacyDlpV2FixedSizeBucketingConfigResponse':
        """
        Fixed size bucketing
        """
        return pulumi.get(self, "fixed_size_bucketing_config")

    @property
    @pulumi.getter(name="redactConfig")
    def redact_config(self) -> 'outputs.GooglePrivacyDlpV2RedactConfigResponse':
        """
        Redact
        """
        return pulumi.get(self, "redact_config")

    @property
    @pulumi.getter(name="replaceConfig")
    def replace_config(self) -> 'outputs.GooglePrivacyDlpV2ReplaceValueConfigResponse':
        """
        Replace with a specified value.
        """
        return pulumi.get(self, "replace_config")

    @property
    @pulumi.getter(name="replaceDictionaryConfig")
    def replace_dictionary_config(self) -> 'outputs.GooglePrivacyDlpV2ReplaceDictionaryConfigResponse':
        """
        Replace with a value randomly drawn (with replacement) from a dictionary.
        """
        return pulumi.get(self, "replace_dictionary_config")

    @property
    @pulumi.getter(name="replaceWithInfoTypeConfig")
    def replace_with_info_type_config(self) -> 'outputs.GooglePrivacyDlpV2ReplaceWithInfoTypeConfigResponse':
        """
        Replace with infotype
        """
        return pulumi.get(self, "replace_with_info_type_config")

    @property
    @pulumi.getter(name="timePartConfig")
    def time_part_config(self) -> 'outputs.GooglePrivacyDlpV2TimePartConfigResponse':
        """
        Time extraction
        """
        return pulumi.get(self, "time_part_config")


@pulumi.output_type
class GooglePrivacyDlpV2PrivacyMetricResponse(dict):
    """
    Privacy metric to compute for reidentification risk analysis.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "categoricalStatsConfig":
            suggest = "categorical_stats_config"
        elif key == "deltaPresenceEstimationConfig":
            suggest = "delta_presence_estimation_config"
        elif key == "kAnonymityConfig":
            suggest = "k_anonymity_config"
        elif key == "kMapEstimationConfig":
            suggest = "k_map_estimation_config"
        elif key == "lDiversityConfig":
            suggest = "l_diversity_config"
        elif key == "numericalStatsConfig":
            suggest = "numerical_stats_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2PrivacyMetricResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2PrivacyMetricResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2PrivacyMetricResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categorical_stats_config: 'outputs.GooglePrivacyDlpV2CategoricalStatsConfigResponse',
                 delta_presence_estimation_config: 'outputs.GooglePrivacyDlpV2DeltaPresenceEstimationConfigResponse',
                 k_anonymity_config: 'outputs.GooglePrivacyDlpV2KAnonymityConfigResponse',
                 k_map_estimation_config: 'outputs.GooglePrivacyDlpV2KMapEstimationConfigResponse',
                 l_diversity_config: 'outputs.GooglePrivacyDlpV2LDiversityConfigResponse',
                 numerical_stats_config: 'outputs.GooglePrivacyDlpV2NumericalStatsConfigResponse'):
        """
        Privacy metric to compute for reidentification risk analysis.
        :param 'GooglePrivacyDlpV2CategoricalStatsConfigResponse' categorical_stats_config: Categorical stats
        :param 'GooglePrivacyDlpV2DeltaPresenceEstimationConfigResponse' delta_presence_estimation_config: delta-presence
        :param 'GooglePrivacyDlpV2KAnonymityConfigResponse' k_anonymity_config: K-anonymity
        :param 'GooglePrivacyDlpV2KMapEstimationConfigResponse' k_map_estimation_config: k-map
        :param 'GooglePrivacyDlpV2LDiversityConfigResponse' l_diversity_config: l-diversity
        :param 'GooglePrivacyDlpV2NumericalStatsConfigResponse' numerical_stats_config: Numerical stats
        """
        pulumi.set(__self__, "categorical_stats_config", categorical_stats_config)
        pulumi.set(__self__, "delta_presence_estimation_config", delta_presence_estimation_config)
        pulumi.set(__self__, "k_anonymity_config", k_anonymity_config)
        pulumi.set(__self__, "k_map_estimation_config", k_map_estimation_config)
        pulumi.set(__self__, "l_diversity_config", l_diversity_config)
        pulumi.set(__self__, "numerical_stats_config", numerical_stats_config)

    @property
    @pulumi.getter(name="categoricalStatsConfig")
    def categorical_stats_config(self) -> 'outputs.GooglePrivacyDlpV2CategoricalStatsConfigResponse':
        """
        Categorical stats
        """
        return pulumi.get(self, "categorical_stats_config")

    @property
    @pulumi.getter(name="deltaPresenceEstimationConfig")
    def delta_presence_estimation_config(self) -> 'outputs.GooglePrivacyDlpV2DeltaPresenceEstimationConfigResponse':
        """
        delta-presence
        """
        return pulumi.get(self, "delta_presence_estimation_config")

    @property
    @pulumi.getter(name="kAnonymityConfig")
    def k_anonymity_config(self) -> 'outputs.GooglePrivacyDlpV2KAnonymityConfigResponse':
        """
        K-anonymity
        """
        return pulumi.get(self, "k_anonymity_config")

    @property
    @pulumi.getter(name="kMapEstimationConfig")
    def k_map_estimation_config(self) -> 'outputs.GooglePrivacyDlpV2KMapEstimationConfigResponse':
        """
        k-map
        """
        return pulumi.get(self, "k_map_estimation_config")

    @property
    @pulumi.getter(name="lDiversityConfig")
    def l_diversity_config(self) -> 'outputs.GooglePrivacyDlpV2LDiversityConfigResponse':
        """
        l-diversity
        """
        return pulumi.get(self, "l_diversity_config")

    @property
    @pulumi.getter(name="numericalStatsConfig")
    def numerical_stats_config(self) -> 'outputs.GooglePrivacyDlpV2NumericalStatsConfigResponse':
        """
        Numerical stats
        """
        return pulumi.get(self, "numerical_stats_config")


@pulumi.output_type
class GooglePrivacyDlpV2ProximityResponse(dict):
    """
    Message for specifying a window around a finding to apply a detection rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "windowAfter":
            suggest = "window_after"
        elif key == "windowBefore":
            suggest = "window_before"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ProximityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ProximityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ProximityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 window_after: int,
                 window_before: int):
        """
        Message for specifying a window around a finding to apply a detection rule.
        :param int window_after: Number of characters after the finding to consider.
        :param int window_before: Number of characters before the finding to consider.
        """
        pulumi.set(__self__, "window_after", window_after)
        pulumi.set(__self__, "window_before", window_before)

    @property
    @pulumi.getter(name="windowAfter")
    def window_after(self) -> int:
        """
        Number of characters after the finding to consider.
        """
        return pulumi.get(self, "window_after")

    @property
    @pulumi.getter(name="windowBefore")
    def window_before(self) -> int:
        """
        Number of characters before the finding to consider.
        """
        return pulumi.get(self, "window_before")


@pulumi.output_type
class GooglePrivacyDlpV2PublishFindingsToCloudDataCatalogResponse(dict):
    """
    Publish findings of a DlpJob to Data Catalog. Labels summarizing the results of the DlpJob will be applied to the entry for the resource scanned in Data Catalog. Any labels previously written by another DlpJob will be deleted. InfoType naming patterns are strictly enforced when using this feature. Note that the findings will be persisted in Data Catalog storage and are governed by Data Catalog service-specific policy, see https://cloud.google.com/terms/service-terms Only a single instance of this action can be specified and only allowed if all resources being scanned are BigQuery tables. Compatible with: Inspect
    """
    def __init__(__self__):
        """
        Publish findings of a DlpJob to Data Catalog. Labels summarizing the results of the DlpJob will be applied to the entry for the resource scanned in Data Catalog. Any labels previously written by another DlpJob will be deleted. InfoType naming patterns are strictly enforced when using this feature. Note that the findings will be persisted in Data Catalog storage and are governed by Data Catalog service-specific policy, see https://cloud.google.com/terms/service-terms Only a single instance of this action can be specified and only allowed if all resources being scanned are BigQuery tables. Compatible with: Inspect
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2PublishSummaryToCsccResponse(dict):
    """
    Publish the result summary of a DlpJob to the Cloud Security Command Center (CSCC Alpha). This action is only available for projects which are parts of an organization and whitelisted for the alpha Cloud Security Command Center. The action will publish count of finding instances and their info types. The summary of findings will be persisted in CSCC and are governed by CSCC service-specific policy, see https://cloud.google.com/terms/service-terms Only a single instance of this action can be specified. Compatible with: Inspect
    """
    def __init__(__self__):
        """
        Publish the result summary of a DlpJob to the Cloud Security Command Center (CSCC Alpha). This action is only available for projects which are parts of an organization and whitelisted for the alpha Cloud Security Command Center. The action will publish count of finding instances and their info types. The summary of findings will be persisted in CSCC and are governed by CSCC service-specific policy, see https://cloud.google.com/terms/service-terms Only a single instance of this action can be specified. Compatible with: Inspect
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2PublishToPubSubResponse(dict):
    """
    Publish a message into given Pub/Sub topic when DlpJob has completed. The message contains a single field, `DlpJobName`, which is equal to the finished job's [`DlpJob.name`](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.dlpJobs#DlpJob). Compatible with: Inspect, Risk
    """
    def __init__(__self__, *,
                 topic: str):
        """
        Publish a message into given Pub/Sub topic when DlpJob has completed. The message contains a single field, `DlpJobName`, which is equal to the finished job's [`DlpJob.name`](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.dlpJobs#DlpJob). Compatible with: Inspect, Risk
        :param str topic: Cloud Pub/Sub topic to send notifications to. The topic must have given publishing access rights to the DLP API service account executing the long running DlpJob sending the notifications. Format is projects/{project}/topics/{topic}.
        """
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        Cloud Pub/Sub topic to send notifications to. The topic must have given publishing access rights to the DLP API service account executing the long running DlpJob sending the notifications. Format is projects/{project}/topics/{topic}.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class GooglePrivacyDlpV2PublishToStackdriverResponse(dict):
    """
    Enable Stackdriver metric dlp.googleapis.com/finding_count. This will publish a metric to stack driver on each infotype requested and how many findings were found for it. CustomDetectors will be bucketed as 'Custom' under the Stackdriver label 'info_type'.
    """
    def __init__(__self__):
        """
        Enable Stackdriver metric dlp.googleapis.com/finding_count. This will publish a metric to stack driver on each infotype requested and how many findings were found for it. CustomDetectors will be bucketed as 'Custom' under the Stackdriver label 'info_type'.
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2QuasiIdFieldResponse(dict):
    """
    A quasi-identifier column has a custom_tag, used to know which column in the data corresponds to which column in the statistical model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTag":
            suggest = "custom_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2QuasiIdFieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2QuasiIdFieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2QuasiIdFieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_tag: str,
                 field: 'outputs.GooglePrivacyDlpV2FieldIdResponse'):
        """
        A quasi-identifier column has a custom_tag, used to know which column in the data corresponds to which column in the statistical model.
        :param str custom_tag: A auxiliary field.
        :param 'GooglePrivacyDlpV2FieldIdResponse' field: Identifies the column.
        """
        pulumi.set(__self__, "custom_tag", custom_tag)
        pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter(name="customTag")
    def custom_tag(self) -> str:
        """
        A auxiliary field.
        """
        return pulumi.get(self, "custom_tag")

    @property
    @pulumi.getter
    def field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Identifies the column.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class GooglePrivacyDlpV2QuasiIdResponse(dict):
    """
    A column with a semantic tag attached.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTag":
            suggest = "custom_tag"
        elif key == "infoType":
            suggest = "info_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2QuasiIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2QuasiIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2QuasiIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_tag: str,
                 field: 'outputs.GooglePrivacyDlpV2FieldIdResponse',
                 inferred: 'outputs.GoogleProtobufEmptyResponse',
                 info_type: 'outputs.GooglePrivacyDlpV2InfoTypeResponse'):
        """
        A column with a semantic tag attached.
        :param str custom_tag: A column can be tagged with a custom tag. In this case, the user must indicate an auxiliary table that contains statistical information on the possible values of this column (below).
        :param 'GooglePrivacyDlpV2FieldIdResponse' field: Identifies the column.
        :param 'GoogleProtobufEmptyResponse' inferred: If no semantic tag is indicated, we infer the statistical model from the distribution of values in the input data
        :param 'GooglePrivacyDlpV2InfoTypeResponse' info_type: A column can be tagged with a InfoType to use the relevant public dataset as a statistical model of population, if available. We currently support US ZIP codes, region codes, ages and genders. To programmatically obtain the list of supported InfoTypes, use ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
        """
        pulumi.set(__self__, "custom_tag", custom_tag)
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "inferred", inferred)
        pulumi.set(__self__, "info_type", info_type)

    @property
    @pulumi.getter(name="customTag")
    def custom_tag(self) -> str:
        """
        A column can be tagged with a custom tag. In this case, the user must indicate an auxiliary table that contains statistical information on the possible values of this column (below).
        """
        return pulumi.get(self, "custom_tag")

    @property
    @pulumi.getter
    def field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Identifies the column.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def inferred(self) -> 'outputs.GoogleProtobufEmptyResponse':
        """
        If no semantic tag is indicated, we infer the statistical model from the distribution of values in the input data
        """
        return pulumi.get(self, "inferred")

    @property
    @pulumi.getter(name="infoType")
    def info_type(self) -> 'outputs.GooglePrivacyDlpV2InfoTypeResponse':
        """
        A column can be tagged with a InfoType to use the relevant public dataset as a statistical model of population, if available. We currently support US ZIP codes, region codes, ages and genders. To programmatically obtain the list of supported InfoTypes, use ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
        """
        return pulumi.get(self, "info_type")


@pulumi.output_type
class GooglePrivacyDlpV2QuasiIdentifierFieldResponse(dict):
    """
    A quasi-identifier column has a custom_tag, used to know which column in the data corresponds to which column in the statistical model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTag":
            suggest = "custom_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2QuasiIdentifierFieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2QuasiIdentifierFieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2QuasiIdentifierFieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_tag: str,
                 field: 'outputs.GooglePrivacyDlpV2FieldIdResponse'):
        """
        A quasi-identifier column has a custom_tag, used to know which column in the data corresponds to which column in the statistical model.
        :param str custom_tag: A column can be tagged with a custom tag. In this case, the user must indicate an auxiliary table that contains statistical information on the possible values of this column (below).
        :param 'GooglePrivacyDlpV2FieldIdResponse' field: Identifies the column.
        """
        pulumi.set(__self__, "custom_tag", custom_tag)
        pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter(name="customTag")
    def custom_tag(self) -> str:
        """
        A column can be tagged with a custom tag. In this case, the user must indicate an auxiliary table that contains statistical information on the possible values of this column (below).
        """
        return pulumi.get(self, "custom_tag")

    @property
    @pulumi.getter
    def field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Identifies the column.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class GooglePrivacyDlpV2RecordConditionResponse(dict):
    """
    A condition for determining whether a transformation should be applied to a field.
    """
    def __init__(__self__, *,
                 expressions: 'outputs.GooglePrivacyDlpV2ExpressionsResponse'):
        """
        A condition for determining whether a transformation should be applied to a field.
        :param 'GooglePrivacyDlpV2ExpressionsResponse' expressions: An expression.
        """
        pulumi.set(__self__, "expressions", expressions)

    @property
    @pulumi.getter
    def expressions(self) -> 'outputs.GooglePrivacyDlpV2ExpressionsResponse':
        """
        An expression.
        """
        return pulumi.get(self, "expressions")


@pulumi.output_type
class GooglePrivacyDlpV2RecordSuppressionResponse(dict):
    """
    Configuration to suppress records whose suppression conditions evaluate to true.
    """
    def __init__(__self__, *,
                 condition: 'outputs.GooglePrivacyDlpV2RecordConditionResponse'):
        """
        Configuration to suppress records whose suppression conditions evaluate to true.
        :param 'GooglePrivacyDlpV2RecordConditionResponse' condition: A condition that when it evaluates to true will result in the record being evaluated to be suppressed from the transformed content.
        """
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GooglePrivacyDlpV2RecordConditionResponse':
        """
        A condition that when it evaluates to true will result in the record being evaluated to be suppressed from the transformed content.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class GooglePrivacyDlpV2RecordTransformationsResponse(dict):
    """
    A type of transformation that is applied over structured data such as a table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldTransformations":
            suggest = "field_transformations"
        elif key == "recordSuppressions":
            suggest = "record_suppressions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2RecordTransformationsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2RecordTransformationsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2RecordTransformationsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_transformations: Sequence['outputs.GooglePrivacyDlpV2FieldTransformationResponse'],
                 record_suppressions: Sequence['outputs.GooglePrivacyDlpV2RecordSuppressionResponse']):
        """
        A type of transformation that is applied over structured data such as a table.
        :param Sequence['GooglePrivacyDlpV2FieldTransformationResponse'] field_transformations: Transform the record by applying various field transformations.
        :param Sequence['GooglePrivacyDlpV2RecordSuppressionResponse'] record_suppressions: Configuration defining which records get suppressed entirely. Records that match any suppression rule are omitted from the output.
        """
        pulumi.set(__self__, "field_transformations", field_transformations)
        pulumi.set(__self__, "record_suppressions", record_suppressions)

    @property
    @pulumi.getter(name="fieldTransformations")
    def field_transformations(self) -> Sequence['outputs.GooglePrivacyDlpV2FieldTransformationResponse']:
        """
        Transform the record by applying various field transformations.
        """
        return pulumi.get(self, "field_transformations")

    @property
    @pulumi.getter(name="recordSuppressions")
    def record_suppressions(self) -> Sequence['outputs.GooglePrivacyDlpV2RecordSuppressionResponse']:
        """
        Configuration defining which records get suppressed entirely. Records that match any suppression rule are omitted from the output.
        """
        return pulumi.get(self, "record_suppressions")


@pulumi.output_type
class GooglePrivacyDlpV2RedactConfigResponse(dict):
    """
    Redact a given value. For example, if used with an `InfoTypeTransformation` transforming PHONE_NUMBER, and input 'My phone number is 206-555-0123', the output would be 'My phone number is '.
    """
    def __init__(__self__):
        """
        Redact a given value. For example, if used with an `InfoTypeTransformation` transforming PHONE_NUMBER, and input 'My phone number is 206-555-0123', the output would be 'My phone number is '.
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2RegexResponse(dict):
    """
    Message defining a custom regular expression.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupIndexes":
            suggest = "group_indexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2RegexResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2RegexResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2RegexResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_indexes: Sequence[int],
                 pattern: str):
        """
        Message defining a custom regular expression.
        :param Sequence[int] group_indexes: The index of the submatch to extract as findings. When not specified, the entire match is returned. No more than 3 may be included.
        :param str pattern: Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
        """
        pulumi.set(__self__, "group_indexes", group_indexes)
        pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="groupIndexes")
    def group_indexes(self) -> Sequence[int]:
        """
        The index of the submatch to extract as findings. When not specified, the entire match is returned. No more than 3 may be included.
        """
        return pulumi.get(self, "group_indexes")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class GooglePrivacyDlpV2ReplaceDictionaryConfigResponse(dict):
    """
    Replace each input value with a value randomly selected from the dictionary.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "wordList":
            suggest = "word_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ReplaceDictionaryConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ReplaceDictionaryConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ReplaceDictionaryConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 word_list: 'outputs.GooglePrivacyDlpV2WordListResponse'):
        """
        Replace each input value with a value randomly selected from the dictionary.
        :param 'GooglePrivacyDlpV2WordListResponse' word_list: A list of words to select from for random replacement. The [limits](https://cloud.google.com/dlp/limits) page contains details about the size limits of dictionaries.
        """
        pulumi.set(__self__, "word_list", word_list)

    @property
    @pulumi.getter(name="wordList")
    def word_list(self) -> 'outputs.GooglePrivacyDlpV2WordListResponse':
        """
        A list of words to select from for random replacement. The [limits](https://cloud.google.com/dlp/limits) page contains details about the size limits of dictionaries.
        """
        return pulumi.get(self, "word_list")


@pulumi.output_type
class GooglePrivacyDlpV2ReplaceValueConfigResponse(dict):
    """
    Replace each input value with a given `Value`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newValue":
            suggest = "new_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ReplaceValueConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ReplaceValueConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ReplaceValueConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_value: 'outputs.GooglePrivacyDlpV2ValueResponse'):
        """
        Replace each input value with a given `Value`.
        :param 'GooglePrivacyDlpV2ValueResponse' new_value: Value to replace it with.
        """
        pulumi.set(__self__, "new_value", new_value)

    @property
    @pulumi.getter(name="newValue")
    def new_value(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        Value to replace it with.
        """
        return pulumi.get(self, "new_value")


@pulumi.output_type
class GooglePrivacyDlpV2ReplaceWithInfoTypeConfigResponse(dict):
    """
    Replace each matching finding with the name of the info_type.
    """
    def __init__(__self__):
        """
        Replace each matching finding with the name of the info_type.
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2RequestedOptionsResponse(dict):
    """
    Snapshot of the inspection configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobConfig":
            suggest = "job_config"
        elif key == "snapshotInspectTemplate":
            suggest = "snapshot_inspect_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2RequestedOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2RequestedOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2RequestedOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_config: 'outputs.GooglePrivacyDlpV2InspectJobConfigResponse',
                 snapshot_inspect_template: 'outputs.GooglePrivacyDlpV2InspectTemplateResponse'):
        """
        Snapshot of the inspection configuration.
        :param 'GooglePrivacyDlpV2InspectJobConfigResponse' job_config: Inspect config.
        :param 'GooglePrivacyDlpV2InspectTemplateResponse' snapshot_inspect_template: If run with an InspectTemplate, a snapshot of its state at the time of this run.
        """
        pulumi.set(__self__, "job_config", job_config)
        pulumi.set(__self__, "snapshot_inspect_template", snapshot_inspect_template)

    @property
    @pulumi.getter(name="jobConfig")
    def job_config(self) -> 'outputs.GooglePrivacyDlpV2InspectJobConfigResponse':
        """
        Inspect config.
        """
        return pulumi.get(self, "job_config")

    @property
    @pulumi.getter(name="snapshotInspectTemplate")
    def snapshot_inspect_template(self) -> 'outputs.GooglePrivacyDlpV2InspectTemplateResponse':
        """
        If run with an InspectTemplate, a snapshot of its state at the time of this run.
        """
        return pulumi.get(self, "snapshot_inspect_template")


@pulumi.output_type
class GooglePrivacyDlpV2RequestedRiskAnalysisOptionsResponse(dict):
    """
    Risk analysis options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobConfig":
            suggest = "job_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2RequestedRiskAnalysisOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2RequestedRiskAnalysisOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2RequestedRiskAnalysisOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_config: 'outputs.GooglePrivacyDlpV2RiskAnalysisJobConfigResponse'):
        """
        Risk analysis options.
        :param 'GooglePrivacyDlpV2RiskAnalysisJobConfigResponse' job_config: The job config for the risk job.
        """
        pulumi.set(__self__, "job_config", job_config)

    @property
    @pulumi.getter(name="jobConfig")
    def job_config(self) -> 'outputs.GooglePrivacyDlpV2RiskAnalysisJobConfigResponse':
        """
        The job config for the risk job.
        """
        return pulumi.get(self, "job_config")


@pulumi.output_type
class GooglePrivacyDlpV2ResultResponse(dict):
    """
    All result fields mentioned below are updated while the job is processing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hybridStats":
            suggest = "hybrid_stats"
        elif key == "infoTypeStats":
            suggest = "info_type_stats"
        elif key == "processedBytes":
            suggest = "processed_bytes"
        elif key == "totalEstimatedBytes":
            suggest = "total_estimated_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hybrid_stats: 'outputs.GooglePrivacyDlpV2HybridInspectStatisticsResponse',
                 info_type_stats: Sequence['outputs.GooglePrivacyDlpV2InfoTypeStatsResponse'],
                 processed_bytes: str,
                 total_estimated_bytes: str):
        """
        All result fields mentioned below are updated while the job is processing.
        :param 'GooglePrivacyDlpV2HybridInspectStatisticsResponse' hybrid_stats: Statistics related to the processing of hybrid inspect.
        :param Sequence['GooglePrivacyDlpV2InfoTypeStatsResponse'] info_type_stats: Statistics of how many instances of each info type were found during inspect job.
        :param str processed_bytes: Total size in bytes that were processed.
        :param str total_estimated_bytes: Estimate of the number of bytes to process.
        """
        pulumi.set(__self__, "hybrid_stats", hybrid_stats)
        pulumi.set(__self__, "info_type_stats", info_type_stats)
        pulumi.set(__self__, "processed_bytes", processed_bytes)
        pulumi.set(__self__, "total_estimated_bytes", total_estimated_bytes)

    @property
    @pulumi.getter(name="hybridStats")
    def hybrid_stats(self) -> 'outputs.GooglePrivacyDlpV2HybridInspectStatisticsResponse':
        """
        Statistics related to the processing of hybrid inspect.
        """
        return pulumi.get(self, "hybrid_stats")

    @property
    @pulumi.getter(name="infoTypeStats")
    def info_type_stats(self) -> Sequence['outputs.GooglePrivacyDlpV2InfoTypeStatsResponse']:
        """
        Statistics of how many instances of each info type were found during inspect job.
        """
        return pulumi.get(self, "info_type_stats")

    @property
    @pulumi.getter(name="processedBytes")
    def processed_bytes(self) -> str:
        """
        Total size in bytes that were processed.
        """
        return pulumi.get(self, "processed_bytes")

    @property
    @pulumi.getter(name="totalEstimatedBytes")
    def total_estimated_bytes(self) -> str:
        """
        Estimate of the number of bytes to process.
        """
        return pulumi.get(self, "total_estimated_bytes")


@pulumi.output_type
class GooglePrivacyDlpV2RiskAnalysisJobConfigResponse(dict):
    """
    Configuration for a risk analysis job. See https://cloud.google.com/dlp/docs/concepts-risk-analysis to learn more.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privacyMetric":
            suggest = "privacy_metric"
        elif key == "sourceTable":
            suggest = "source_table"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2RiskAnalysisJobConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2RiskAnalysisJobConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2RiskAnalysisJobConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence['outputs.GooglePrivacyDlpV2ActionResponse'],
                 privacy_metric: 'outputs.GooglePrivacyDlpV2PrivacyMetricResponse',
                 source_table: 'outputs.GooglePrivacyDlpV2BigQueryTableResponse'):
        """
        Configuration for a risk analysis job. See https://cloud.google.com/dlp/docs/concepts-risk-analysis to learn more.
        :param Sequence['GooglePrivacyDlpV2ActionResponse'] actions: Actions to execute at the completion of the job. Are executed in the order provided.
        :param 'GooglePrivacyDlpV2PrivacyMetricResponse' privacy_metric: Privacy metric to compute.
        :param 'GooglePrivacyDlpV2BigQueryTableResponse' source_table: Input dataset to compute metrics over.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "privacy_metric", privacy_metric)
        pulumi.set(__self__, "source_table", source_table)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GooglePrivacyDlpV2ActionResponse']:
        """
        Actions to execute at the completion of the job. Are executed in the order provided.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="privacyMetric")
    def privacy_metric(self) -> 'outputs.GooglePrivacyDlpV2PrivacyMetricResponse':
        """
        Privacy metric to compute.
        """
        return pulumi.get(self, "privacy_metric")

    @property
    @pulumi.getter(name="sourceTable")
    def source_table(self) -> 'outputs.GooglePrivacyDlpV2BigQueryTableResponse':
        """
        Input dataset to compute metrics over.
        """
        return pulumi.get(self, "source_table")


@pulumi.output_type
class GooglePrivacyDlpV2SaveFindingsResponse(dict):
    """
    If set, the detailed findings will be persisted to the specified OutputStorageConfig. Only a single instance of this action can be specified. Compatible with: Inspect, Risk
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputConfig":
            suggest = "output_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2SaveFindingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2SaveFindingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2SaveFindingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_config: 'outputs.GooglePrivacyDlpV2OutputStorageConfigResponse'):
        """
        If set, the detailed findings will be persisted to the specified OutputStorageConfig. Only a single instance of this action can be specified. Compatible with: Inspect, Risk
        :param 'GooglePrivacyDlpV2OutputStorageConfigResponse' output_config: Location to store findings outside of DLP.
        """
        pulumi.set(__self__, "output_config", output_config)

    @property
    @pulumi.getter(name="outputConfig")
    def output_config(self) -> 'outputs.GooglePrivacyDlpV2OutputStorageConfigResponse':
        """
        Location to store findings outside of DLP.
        """
        return pulumi.get(self, "output_config")


@pulumi.output_type
class GooglePrivacyDlpV2ScheduleResponse(dict):
    """
    Schedule for inspect job triggers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurrencePeriodDuration":
            suggest = "recurrence_period_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurrence_period_duration: str):
        """
        Schedule for inspect job triggers.
        :param str recurrence_period_duration: With this option a job is started a regular periodic basis. For example: every day (86400 seconds). A scheduled start time will be skipped if the previous execution has not ended when its scheduled time occurs. This value must be set to a time duration greater than or equal to 1 day and can be no longer than 60 days.
        """
        pulumi.set(__self__, "recurrence_period_duration", recurrence_period_duration)

    @property
    @pulumi.getter(name="recurrencePeriodDuration")
    def recurrence_period_duration(self) -> str:
        """
        With this option a job is started a regular periodic basis. For example: every day (86400 seconds). A scheduled start time will be skipped if the previous execution has not ended when its scheduled time occurs. This value must be set to a time duration greater than or equal to 1 day and can be no longer than 60 days.
        """
        return pulumi.get(self, "recurrence_period_duration")


@pulumi.output_type
class GooglePrivacyDlpV2StatisticalTableResponse(dict):
    """
    An auxiliary table containing statistical information on the relative frequency of different quasi-identifiers values. It has one or several quasi-identifiers columns, and one column that indicates the relative frequency of each quasi-identifier tuple. If a tuple is present in the data but not in the auxiliary table, the corresponding relative frequency is assumed to be zero (and thus, the tuple is highly reidentifiable).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quasiIds":
            suggest = "quasi_ids"
        elif key == "relativeFrequency":
            suggest = "relative_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2StatisticalTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2StatisticalTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2StatisticalTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quasi_ids: Sequence['outputs.GooglePrivacyDlpV2QuasiIdentifierFieldResponse'],
                 relative_frequency: 'outputs.GooglePrivacyDlpV2FieldIdResponse',
                 table: 'outputs.GooglePrivacyDlpV2BigQueryTableResponse'):
        """
        An auxiliary table containing statistical information on the relative frequency of different quasi-identifiers values. It has one or several quasi-identifiers columns, and one column that indicates the relative frequency of each quasi-identifier tuple. If a tuple is present in the data but not in the auxiliary table, the corresponding relative frequency is assumed to be zero (and thus, the tuple is highly reidentifiable).
        :param Sequence['GooglePrivacyDlpV2QuasiIdentifierFieldResponse'] quasi_ids: Quasi-identifier columns.
        :param 'GooglePrivacyDlpV2FieldIdResponse' relative_frequency: The relative frequency column must contain a floating-point number between 0 and 1 (inclusive). Null values are assumed to be zero.
        :param 'GooglePrivacyDlpV2BigQueryTableResponse' table: Auxiliary table location.
        """
        pulumi.set(__self__, "quasi_ids", quasi_ids)
        pulumi.set(__self__, "relative_frequency", relative_frequency)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="quasiIds")
    def quasi_ids(self) -> Sequence['outputs.GooglePrivacyDlpV2QuasiIdentifierFieldResponse']:
        """
        Quasi-identifier columns.
        """
        return pulumi.get(self, "quasi_ids")

    @property
    @pulumi.getter(name="relativeFrequency")
    def relative_frequency(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        The relative frequency column must contain a floating-point number between 0 and 1 (inclusive). Null values are assumed to be zero.
        """
        return pulumi.get(self, "relative_frequency")

    @property
    @pulumi.getter
    def table(self) -> 'outputs.GooglePrivacyDlpV2BigQueryTableResponse':
        """
        Auxiliary table location.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class GooglePrivacyDlpV2StorageConfigResponse(dict):
    """
    Shared message indicating Cloud storage type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigQueryOptions":
            suggest = "big_query_options"
        elif key == "cloudStorageOptions":
            suggest = "cloud_storage_options"
        elif key == "datastoreOptions":
            suggest = "datastore_options"
        elif key == "hybridOptions":
            suggest = "hybrid_options"
        elif key == "timespanConfig":
            suggest = "timespan_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2StorageConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2StorageConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2StorageConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 big_query_options: 'outputs.GooglePrivacyDlpV2BigQueryOptionsResponse',
                 cloud_storage_options: 'outputs.GooglePrivacyDlpV2CloudStorageOptionsResponse',
                 datastore_options: 'outputs.GooglePrivacyDlpV2DatastoreOptionsResponse',
                 hybrid_options: 'outputs.GooglePrivacyDlpV2HybridOptionsResponse',
                 timespan_config: 'outputs.GooglePrivacyDlpV2TimespanConfigResponse'):
        """
        Shared message indicating Cloud storage type.
        :param 'GooglePrivacyDlpV2BigQueryOptionsResponse' big_query_options: BigQuery options.
        :param 'GooglePrivacyDlpV2CloudStorageOptionsResponse' cloud_storage_options: Google Cloud Storage options.
        :param 'GooglePrivacyDlpV2DatastoreOptionsResponse' datastore_options: Google Cloud Datastore options.
        :param 'GooglePrivacyDlpV2HybridOptionsResponse' hybrid_options: Hybrid inspection options.
        """
        pulumi.set(__self__, "big_query_options", big_query_options)
        pulumi.set(__self__, "cloud_storage_options", cloud_storage_options)
        pulumi.set(__self__, "datastore_options", datastore_options)
        pulumi.set(__self__, "hybrid_options", hybrid_options)
        pulumi.set(__self__, "timespan_config", timespan_config)

    @property
    @pulumi.getter(name="bigQueryOptions")
    def big_query_options(self) -> 'outputs.GooglePrivacyDlpV2BigQueryOptionsResponse':
        """
        BigQuery options.
        """
        return pulumi.get(self, "big_query_options")

    @property
    @pulumi.getter(name="cloudStorageOptions")
    def cloud_storage_options(self) -> 'outputs.GooglePrivacyDlpV2CloudStorageOptionsResponse':
        """
        Google Cloud Storage options.
        """
        return pulumi.get(self, "cloud_storage_options")

    @property
    @pulumi.getter(name="datastoreOptions")
    def datastore_options(self) -> 'outputs.GooglePrivacyDlpV2DatastoreOptionsResponse':
        """
        Google Cloud Datastore options.
        """
        return pulumi.get(self, "datastore_options")

    @property
    @pulumi.getter(name="hybridOptions")
    def hybrid_options(self) -> 'outputs.GooglePrivacyDlpV2HybridOptionsResponse':
        """
        Hybrid inspection options.
        """
        return pulumi.get(self, "hybrid_options")

    @property
    @pulumi.getter(name="timespanConfig")
    def timespan_config(self) -> 'outputs.GooglePrivacyDlpV2TimespanConfigResponse':
        return pulumi.get(self, "timespan_config")


@pulumi.output_type
class GooglePrivacyDlpV2StoredInfoTypeConfigResponse(dict):
    """
    Configuration for stored infoTypes. All fields and subfield are provided by the user. For more information, see https://cloud.google.com/dlp/docs/creating-custom-infotypes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "largeCustomDictionary":
            suggest = "large_custom_dictionary"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2StoredInfoTypeConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2StoredInfoTypeConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2StoredInfoTypeConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 dictionary: 'outputs.GooglePrivacyDlpV2DictionaryResponse',
                 display_name: str,
                 large_custom_dictionary: 'outputs.GooglePrivacyDlpV2LargeCustomDictionaryConfigResponse',
                 regex: 'outputs.GooglePrivacyDlpV2RegexResponse'):
        """
        Configuration for stored infoTypes. All fields and subfield are provided by the user. For more information, see https://cloud.google.com/dlp/docs/creating-custom-infotypes.
        :param str description: Description of the StoredInfoType (max 256 characters).
        :param 'GooglePrivacyDlpV2DictionaryResponse' dictionary: Store dictionary-based CustomInfoType.
        :param str display_name: Display name of the StoredInfoType (max 256 characters).
        :param 'GooglePrivacyDlpV2LargeCustomDictionaryConfigResponse' large_custom_dictionary: StoredInfoType where findings are defined by a dictionary of phrases.
        :param 'GooglePrivacyDlpV2RegexResponse' regex: Store regular expression-based StoredInfoType.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dictionary", dictionary)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "large_custom_dictionary", large_custom_dictionary)
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the StoredInfoType (max 256 characters).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dictionary(self) -> 'outputs.GooglePrivacyDlpV2DictionaryResponse':
        """
        Store dictionary-based CustomInfoType.
        """
        return pulumi.get(self, "dictionary")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of the StoredInfoType (max 256 characters).
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="largeCustomDictionary")
    def large_custom_dictionary(self) -> 'outputs.GooglePrivacyDlpV2LargeCustomDictionaryConfigResponse':
        """
        StoredInfoType where findings are defined by a dictionary of phrases.
        """
        return pulumi.get(self, "large_custom_dictionary")

    @property
    @pulumi.getter
    def regex(self) -> 'outputs.GooglePrivacyDlpV2RegexResponse':
        """
        Store regular expression-based StoredInfoType.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class GooglePrivacyDlpV2StoredInfoTypeStatsResponse(dict):
    """
    Statistics for a StoredInfoType.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "largeCustomDictionary":
            suggest = "large_custom_dictionary"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2StoredInfoTypeStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2StoredInfoTypeStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2StoredInfoTypeStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 large_custom_dictionary: 'outputs.GooglePrivacyDlpV2LargeCustomDictionaryStatsResponse'):
        """
        Statistics for a StoredInfoType.
        :param 'GooglePrivacyDlpV2LargeCustomDictionaryStatsResponse' large_custom_dictionary: StoredInfoType where findings are defined by a dictionary of phrases.
        """
        pulumi.set(__self__, "large_custom_dictionary", large_custom_dictionary)

    @property
    @pulumi.getter(name="largeCustomDictionary")
    def large_custom_dictionary(self) -> 'outputs.GooglePrivacyDlpV2LargeCustomDictionaryStatsResponse':
        """
        StoredInfoType where findings are defined by a dictionary of phrases.
        """
        return pulumi.get(self, "large_custom_dictionary")


@pulumi.output_type
class GooglePrivacyDlpV2StoredInfoTypeVersionResponse(dict):
    """
    Version of a StoredInfoType, including the configuration used to build it, create timestamp, and current state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2StoredInfoTypeVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2StoredInfoTypeVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2StoredInfoTypeVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: 'outputs.GooglePrivacyDlpV2StoredInfoTypeConfigResponse',
                 create_time: str,
                 errors: Sequence['outputs.GooglePrivacyDlpV2ErrorResponse'],
                 state: str,
                 stats: 'outputs.GooglePrivacyDlpV2StoredInfoTypeStatsResponse'):
        """
        Version of a StoredInfoType, including the configuration used to build it, create timestamp, and current state.
        :param 'GooglePrivacyDlpV2StoredInfoTypeConfigResponse' config: StoredInfoType configuration.
        :param str create_time: Create timestamp of the version. Read-only, determined by the system when the version is created.
        :param Sequence['GooglePrivacyDlpV2ErrorResponse'] errors: Errors that occurred when creating this storedInfoType version, or anomalies detected in the storedInfoType data that render it unusable. Only the five most recent errors will be displayed, with the most recent error appearing first. For example, some of the data for stored custom dictionaries is put in the user's Google Cloud Storage bucket, and if this data is modified or deleted by the user or another system, the dictionary becomes invalid. If any errors occur, fix the problem indicated by the error message and use the UpdateStoredInfoType API method to create another version of the storedInfoType to continue using it, reusing the same `config` if it was not the source of the error.
        :param str state: Stored info type version state. Read-only, updated by the system during dictionary creation.
        :param 'GooglePrivacyDlpV2StoredInfoTypeStatsResponse' stats: Statistics about this storedInfoType version.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "stats", stats)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.GooglePrivacyDlpV2StoredInfoTypeConfigResponse':
        """
        StoredInfoType configuration.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Create timestamp of the version. Read-only, determined by the system when the version is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.GooglePrivacyDlpV2ErrorResponse']:
        """
        Errors that occurred when creating this storedInfoType version, or anomalies detected in the storedInfoType data that render it unusable. Only the five most recent errors will be displayed, with the most recent error appearing first. For example, some of the data for stored custom dictionaries is put in the user's Google Cloud Storage bucket, and if this data is modified or deleted by the user or another system, the dictionary becomes invalid. If any errors occur, fix the problem indicated by the error message and use the UpdateStoredInfoType API method to create another version of the storedInfoType to continue using it, reusing the same `config` if it was not the source of the error.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Stored info type version state. Read-only, updated by the system during dictionary creation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> 'outputs.GooglePrivacyDlpV2StoredInfoTypeStatsResponse':
        """
        Statistics about this storedInfoType version.
        """
        return pulumi.get(self, "stats")


@pulumi.output_type
class GooglePrivacyDlpV2StoredTypeResponse(dict):
    """
    A reference to a StoredInfoType to use with scanning.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2StoredTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2StoredTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2StoredTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: str,
                 name: str):
        """
        A reference to a StoredInfoType to use with scanning.
        :param str create_time: Timestamp indicating when the version of the `StoredInfoType` used for inspection was created. Output-only field, populated by the system.
        :param str name: Resource name of the requested `StoredInfoType`, for example `organizations/433245324/storedInfoTypes/432452342` or `projects/project-id/storedInfoTypes/432452342`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Timestamp indicating when the version of the `StoredInfoType` used for inspection was created. Output-only field, populated by the system.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of the requested `StoredInfoType`, for example `organizations/433245324/storedInfoTypes/432452342` or `projects/project-id/storedInfoTypes/432452342`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GooglePrivacyDlpV2SurrogateTypeResponse(dict):
    """
    Message for detecting output from deidentification transformations such as [`CryptoReplaceFfxFpeConfig`](https://cloud.google.com/dlp/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig). These types of transformations are those that perform pseudonymization, thereby producing a "surrogate" as output. This should be used in conjunction with a field on the transformation such as `surrogate_info_type`. This CustomInfoType does not support the use of `detection_rules`.
    """
    def __init__(__self__):
        """
        Message for detecting output from deidentification transformations such as [`CryptoReplaceFfxFpeConfig`](https://cloud.google.com/dlp/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig). These types of transformations are those that perform pseudonymization, thereby producing a "surrogate" as output. This should be used in conjunction with a field on the transformation such as `surrogate_info_type`. This CustomInfoType does not support the use of `detection_rules`.
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2TableOptionsResponse(dict):
    """
    Instructions regarding the table content being inspected.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identifyingFields":
            suggest = "identifying_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2TableOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2TableOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2TableOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identifying_fields: Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse']):
        """
        Instructions regarding the table content being inspected.
        :param Sequence['GooglePrivacyDlpV2FieldIdResponse'] identifying_fields: The columns that are the primary keys for table objects included in ContentItem. A copy of this cell's value will stored alongside alongside each finding so that the finding can be traced to the specific row it came from. No more than 3 may be provided.
        """
        pulumi.set(__self__, "identifying_fields", identifying_fields)

    @property
    @pulumi.getter(name="identifyingFields")
    def identifying_fields(self) -> Sequence['outputs.GooglePrivacyDlpV2FieldIdResponse']:
        """
        The columns that are the primary keys for table objects included in ContentItem. A copy of this cell's value will stored alongside alongside each finding so that the finding can be traced to the specific row it came from. No more than 3 may be provided.
        """
        return pulumi.get(self, "identifying_fields")


@pulumi.output_type
class GooglePrivacyDlpV2TaggedFieldResponse(dict):
    """
    A column with a semantic tag attached.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTag":
            suggest = "custom_tag"
        elif key == "infoType":
            suggest = "info_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2TaggedFieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2TaggedFieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2TaggedFieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_tag: str,
                 field: 'outputs.GooglePrivacyDlpV2FieldIdResponse',
                 inferred: 'outputs.GoogleProtobufEmptyResponse',
                 info_type: 'outputs.GooglePrivacyDlpV2InfoTypeResponse'):
        """
        A column with a semantic tag attached.
        :param str custom_tag: A column can be tagged with a custom tag. In this case, the user must indicate an auxiliary table that contains statistical information on the possible values of this column (below).
        :param 'GooglePrivacyDlpV2FieldIdResponse' field: Identifies the column.
        :param 'GoogleProtobufEmptyResponse' inferred: If no semantic tag is indicated, we infer the statistical model from the distribution of values in the input data
        :param 'GooglePrivacyDlpV2InfoTypeResponse' info_type: A column can be tagged with a InfoType to use the relevant public dataset as a statistical model of population, if available. We currently support US ZIP codes, region codes, ages and genders. To programmatically obtain the list of supported InfoTypes, use ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
        """
        pulumi.set(__self__, "custom_tag", custom_tag)
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "inferred", inferred)
        pulumi.set(__self__, "info_type", info_type)

    @property
    @pulumi.getter(name="customTag")
    def custom_tag(self) -> str:
        """
        A column can be tagged with a custom tag. In this case, the user must indicate an auxiliary table that contains statistical information on the possible values of this column (below).
        """
        return pulumi.get(self, "custom_tag")

    @property
    @pulumi.getter
    def field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Identifies the column.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def inferred(self) -> 'outputs.GoogleProtobufEmptyResponse':
        """
        If no semantic tag is indicated, we infer the statistical model from the distribution of values in the input data
        """
        return pulumi.get(self, "inferred")

    @property
    @pulumi.getter(name="infoType")
    def info_type(self) -> 'outputs.GooglePrivacyDlpV2InfoTypeResponse':
        """
        A column can be tagged with a InfoType to use the relevant public dataset as a statistical model of population, if available. We currently support US ZIP codes, region codes, ages and genders. To programmatically obtain the list of supported InfoTypes, use ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
        """
        return pulumi.get(self, "info_type")


@pulumi.output_type
class GooglePrivacyDlpV2ThrowErrorResponse(dict):
    """
    Throw an error and fail the request when a transformation error occurs.
    """
    def __init__(__self__):
        """
        Throw an error and fail the request when a transformation error occurs.
        """
        pass


@pulumi.output_type
class GooglePrivacyDlpV2TimePartConfigResponse(dict):
    """
    For use with `Date`, `Timestamp`, and `TimeOfDay`, extract or preserve a portion of the value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partToExtract":
            suggest = "part_to_extract"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2TimePartConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2TimePartConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2TimePartConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 part_to_extract: str):
        """
        For use with `Date`, `Timestamp`, and `TimeOfDay`, extract or preserve a portion of the value.
        :param str part_to_extract: The part of the time to keep.
        """
        pulumi.set(__self__, "part_to_extract", part_to_extract)

    @property
    @pulumi.getter(name="partToExtract")
    def part_to_extract(self) -> str:
        """
        The part of the time to keep.
        """
        return pulumi.get(self, "part_to_extract")


@pulumi.output_type
class GooglePrivacyDlpV2TimespanConfigResponse(dict):
    """
    Configuration of the timespan of the items to include in scanning. Currently only supported when inspecting Google Cloud Storage and BigQuery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAutoPopulationOfTimespanConfig":
            suggest = "enable_auto_population_of_timespan_config"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timestampField":
            suggest = "timestamp_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2TimespanConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2TimespanConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2TimespanConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_auto_population_of_timespan_config: bool,
                 end_time: str,
                 start_time: str,
                 timestamp_field: 'outputs.GooglePrivacyDlpV2FieldIdResponse'):
        """
        Configuration of the timespan of the items to include in scanning. Currently only supported when inspecting Google Cloud Storage and BigQuery.
        :param bool enable_auto_population_of_timespan_config: When the job is started by a JobTrigger we will automatically figure out a valid start_time to avoid scanning files that have not been modified since the last time the JobTrigger executed. This will be based on the time of the execution of the last run of the JobTrigger.
        :param str end_time: Exclude files, tables, or rows newer than this value. If not set, no upper time limit is applied.
        :param str start_time: Exclude files, tables, or rows older than this value. If not set, no lower time limit is applied.
        :param 'GooglePrivacyDlpV2FieldIdResponse' timestamp_field: Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery. For BigQuery: If this value is not specified and the table was modified between the given start and end times, the entire table will be scanned. If this value is specified, then rows are filtered based on the given start and end times. Rows with a `NULL` value in the provided BigQuery column are skipped. Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`, `TIMESTAMP`, and `DATETIME`. For Datastore: If this value is specified, then entities are filtered based on the given start and end times. If an entity does not contain the provided timestamp property or contains empty or invalid values, then it is included. Valid data types of the provided timestamp property are: `TIMESTAMP`.
        """
        pulumi.set(__self__, "enable_auto_population_of_timespan_config", enable_auto_population_of_timespan_config)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "timestamp_field", timestamp_field)

    @property
    @pulumi.getter(name="enableAutoPopulationOfTimespanConfig")
    def enable_auto_population_of_timespan_config(self) -> bool:
        """
        When the job is started by a JobTrigger we will automatically figure out a valid start_time to avoid scanning files that have not been modified since the last time the JobTrigger executed. This will be based on the time of the execution of the last run of the JobTrigger.
        """
        return pulumi.get(self, "enable_auto_population_of_timespan_config")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Exclude files, tables, or rows newer than this value. If not set, no upper time limit is applied.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Exclude files, tables, or rows older than this value. If not set, no lower time limit is applied.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timestampField")
    def timestamp_field(self) -> 'outputs.GooglePrivacyDlpV2FieldIdResponse':
        """
        Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery. For BigQuery: If this value is not specified and the table was modified between the given start and end times, the entire table will be scanned. If this value is specified, then rows are filtered based on the given start and end times. Rows with a `NULL` value in the provided BigQuery column are skipped. Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`, `TIMESTAMP`, and `DATETIME`. For Datastore: If this value is specified, then entities are filtered based on the given start and end times. If an entity does not contain the provided timestamp property or contains empty or invalid values, then it is included. Valid data types of the provided timestamp property are: `TIMESTAMP`.
        """
        return pulumi.get(self, "timestamp_field")


@pulumi.output_type
class GooglePrivacyDlpV2TransformationErrorHandlingResponse(dict):
    """
    How to handle transformation errors during de-identification. A transformation error occurs when the requested transformation is incompatible with the data. For example, trying to de-identify an IP address using a `DateShift` transformation would result in a transformation error, since date info cannot be extracted from an IP address. Information about any incompatible transformations, and how they were handled, is returned in the response as part of the `TransformationOverviews`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "leaveUntransformed":
            suggest = "leave_untransformed"
        elif key == "throwError":
            suggest = "throw_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2TransformationErrorHandlingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2TransformationErrorHandlingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2TransformationErrorHandlingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 leave_untransformed: 'outputs.GooglePrivacyDlpV2LeaveUntransformedResponse',
                 throw_error: 'outputs.GooglePrivacyDlpV2ThrowErrorResponse'):
        """
        How to handle transformation errors during de-identification. A transformation error occurs when the requested transformation is incompatible with the data. For example, trying to de-identify an IP address using a `DateShift` transformation would result in a transformation error, since date info cannot be extracted from an IP address. Information about any incompatible transformations, and how they were handled, is returned in the response as part of the `TransformationOverviews`.
        :param 'GooglePrivacyDlpV2LeaveUntransformedResponse' leave_untransformed: Ignore errors
        :param 'GooglePrivacyDlpV2ThrowErrorResponse' throw_error: Throw an error
        """
        pulumi.set(__self__, "leave_untransformed", leave_untransformed)
        pulumi.set(__self__, "throw_error", throw_error)

    @property
    @pulumi.getter(name="leaveUntransformed")
    def leave_untransformed(self) -> 'outputs.GooglePrivacyDlpV2LeaveUntransformedResponse':
        """
        Ignore errors
        """
        return pulumi.get(self, "leave_untransformed")

    @property
    @pulumi.getter(name="throwError")
    def throw_error(self) -> 'outputs.GooglePrivacyDlpV2ThrowErrorResponse':
        """
        Throw an error
        """
        return pulumi.get(self, "throw_error")


@pulumi.output_type
class GooglePrivacyDlpV2TransientCryptoKeyResponse(dict):
    """
    Use this to have a random data crypto key generated. It will be discarded after the request finishes.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Use this to have a random data crypto key generated. It will be discarded after the request finishes.
        :param str name: Name of the key. This is an arbitrary string used to differentiate different keys. A unique key is generated per name: two separate `TransientCryptoKey` protos share the same generated key if their names are the same. When the data crypto key is generated, this name is not used in any way (repeating the api call will result in a different key being generated).
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the key. This is an arbitrary string used to differentiate different keys. A unique key is generated per name: two separate `TransientCryptoKey` protos share the same generated key if their names are the same. When the data crypto key is generated, this name is not used in any way (repeating the api call will result in a different key being generated).
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GooglePrivacyDlpV2TriggerResponse(dict):
    """
    What event needs to occur for a new job to be started.
    """
    def __init__(__self__, *,
                 manual: 'outputs.GooglePrivacyDlpV2ManualResponse',
                 schedule: 'outputs.GooglePrivacyDlpV2ScheduleResponse'):
        """
        What event needs to occur for a new job to be started.
        :param 'GooglePrivacyDlpV2ManualResponse' manual: For use with hybrid jobs. Jobs must be manually created and finished.
        :param 'GooglePrivacyDlpV2ScheduleResponse' schedule: Create a job on a repeating basis based on the elapse of time.
        """
        pulumi.set(__self__, "manual", manual)
        pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def manual(self) -> 'outputs.GooglePrivacyDlpV2ManualResponse':
        """
        For use with hybrid jobs. Jobs must be manually created and finished.
        """
        return pulumi.get(self, "manual")

    @property
    @pulumi.getter
    def schedule(self) -> 'outputs.GooglePrivacyDlpV2ScheduleResponse':
        """
        Create a job on a repeating basis based on the elapse of time.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class GooglePrivacyDlpV2UnwrappedCryptoKeyResponse(dict):
    """
    Using raw keys is prone to security risks due to accidentally leaking the key. Choose another type of key if possible.
    """
    def __init__(__self__, *,
                 key: str):
        """
        Using raw keys is prone to security risks due to accidentally leaking the key. Choose another type of key if possible.
        :param str key: A 128/192/256 bit key.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A 128/192/256 bit key.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GooglePrivacyDlpV2ValueFrequencyResponse(dict):
    """
    A value of a field, including its frequency.
    """
    def __init__(__self__, *,
                 count: str,
                 value: 'outputs.GooglePrivacyDlpV2ValueResponse'):
        """
        A value of a field, including its frequency.
        :param str count: How many times the value is contained in the field.
        :param 'GooglePrivacyDlpV2ValueResponse' value: A value contained in the field in question.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def count(self) -> str:
        """
        How many times the value is contained in the field.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def value(self) -> 'outputs.GooglePrivacyDlpV2ValueResponse':
        """
        A value contained in the field in question.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GooglePrivacyDlpV2ValueResponse(dict):
    """
    Set of primitive values supported by the system. Note that for the purposes of inspection or transformation, the number of bytes considered to comprise a 'Value' is based on its representation as a UTF-8 encoded string. For example, if 'integer_value' is set to 123456789, the number of bytes would be counted as 9, even though an int64 only holds up to 8 bytes of data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "dateValue":
            suggest = "date_value"
        elif key == "dayOfWeekValue":
            suggest = "day_of_week_value"
        elif key == "floatValue":
            suggest = "float_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "stringValue":
            suggest = "string_value"
        elif key == "timeValue":
            suggest = "time_value"
        elif key == "timestampValue":
            suggest = "timestamp_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GooglePrivacyDlpV2ValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GooglePrivacyDlpV2ValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GooglePrivacyDlpV2ValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boolean_value: bool,
                 date_value: 'outputs.GoogleTypeDateResponse',
                 day_of_week_value: str,
                 float_value: float,
                 integer_value: str,
                 string_value: str,
                 time_value: 'outputs.GoogleTypeTimeOfDayResponse',
                 timestamp_value: str):
        """
        Set of primitive values supported by the system. Note that for the purposes of inspection or transformation, the number of bytes considered to comprise a 'Value' is based on its representation as a UTF-8 encoded string. For example, if 'integer_value' is set to 123456789, the number of bytes would be counted as 9, even though an int64 only holds up to 8 bytes of data.
        :param bool boolean_value: boolean
        :param 'GoogleTypeDateResponse' date_value: date
        :param str day_of_week_value: day of week
        :param float float_value: float
        :param str integer_value: integer
        :param str string_value: string
        :param 'GoogleTypeTimeOfDayResponse' time_value: time of day
        :param str timestamp_value: timestamp
        """
        pulumi.set(__self__, "boolean_value", boolean_value)
        pulumi.set(__self__, "date_value", date_value)
        pulumi.set(__self__, "day_of_week_value", day_of_week_value)
        pulumi.set(__self__, "float_value", float_value)
        pulumi.set(__self__, "integer_value", integer_value)
        pulumi.set(__self__, "string_value", string_value)
        pulumi.set(__self__, "time_value", time_value)
        pulumi.set(__self__, "timestamp_value", timestamp_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> bool:
        """
        boolean
        """
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="dateValue")
    def date_value(self) -> 'outputs.GoogleTypeDateResponse':
        """
        date
        """
        return pulumi.get(self, "date_value")

    @property
    @pulumi.getter(name="dayOfWeekValue")
    def day_of_week_value(self) -> str:
        """
        day of week
        """
        return pulumi.get(self, "day_of_week_value")

    @property
    @pulumi.getter(name="floatValue")
    def float_value(self) -> float:
        """
        float
        """
        return pulumi.get(self, "float_value")

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> str:
        """
        integer
        """
        return pulumi.get(self, "integer_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> str:
        """
        string
        """
        return pulumi.get(self, "string_value")

    @property
    @pulumi.getter(name="timeValue")
    def time_value(self) -> 'outputs.GoogleTypeTimeOfDayResponse':
        """
        time of day
        """
        return pulumi.get(self, "time_value")

    @property
    @pulumi.getter(name="timestampValue")
    def timestamp_value(self) -> str:
        """
        timestamp
        """
        return pulumi.get(self, "timestamp_value")


@pulumi.output_type
class GooglePrivacyDlpV2WordListResponse(dict):
    """
    Message defining a list of words or phrases to search for in the data.
    """
    def __init__(__self__, *,
                 words: Sequence[str]):
        """
        Message defining a list of words or phrases to search for in the data.
        :param Sequence[str] words: Words or phrases defining the dictionary. The dictionary must contain at least one phrase and every phrase must contain at least 2 characters that are letters or digits. [required]
        """
        pulumi.set(__self__, "words", words)

    @property
    @pulumi.getter
    def words(self) -> Sequence[str]:
        """
        Words or phrases defining the dictionary. The dictionary must contain at least one phrase and every phrase must contain at least 2 characters that are letters or digits. [required]
        """
        return pulumi.get(self, "words")


@pulumi.output_type
class GoogleProtobufEmptyResponse(dict):
    """
    A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON representation for `Empty` is empty JSON object `{}`.
    """
    def __init__(__self__):
        """
        A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON representation for `Empty` is empty JSON object `{}`.
        """
        pass


@pulumi.output_type
class GoogleRpcStatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class GoogleTypeDateResponse(dict):
    """
    Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values * A month and day, with a zero year (e.g., an anniversary) * A year on its own, with a zero month and a zero day * A year and month, with a zero day (e.g., a credit card expiration date) Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
    """
    def __init__(__self__, *,
                 day: int,
                 month: int,
                 year: int):
        """
        Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values * A month and day, with a zero year (e.g., an anniversary) * A year on its own, with a zero month and a zero day * A year and month, with a zero day (e.g., a credit card expiration date) Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
        :param int day: Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        :param int month: Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        :param int year: Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> int:
        """
        Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> int:
        """
        Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class GoogleTypeTimeOfDayResponse(dict):
    """
    Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
    """
    def __init__(__self__, *,
                 hours: int,
                 minutes: int,
                 nanos: int,
                 seconds: int):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


