# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ArtifactArgs',
    'AttestationAuthorityHintArgs',
    'AttestationAuthorityArgs',
    'AttestationArgs',
    'BasisArgs',
    'BindingArgs',
    'BuildDetailsArgs',
    'BuildProvenanceArgs',
    'BuildSignatureArgs',
    'BuildTypeArgs',
    'BuilderConfigArgs',
    'CVSSArgs',
    'CisBenchmarkArgs',
    'CommandArgs',
    'CompletenessArgs',
    'ComplianceNoteArgs',
    'ComplianceOccurrenceArgs',
    'ComplianceVersionArgs',
    'DSSEAttestationNoteArgs',
    'DSSEAttestationOccurrenceArgs',
    'DSSEHintArgs',
    'DeployableArgs',
    'DeploymentArgs',
    'DerivedArgs',
    'DetailArgs',
    'DiscoveredArgs',
    'DiscoveryArgs',
    'DistributionArgs',
    'DocumentNoteArgs',
    'DocumentOccurrenceArgs',
    'EnvelopeSignatureArgs',
    'EnvelopeArgs',
    'ExprArgs',
    'ExternalRefArgs',
    'FileNoteArgs',
    'FileOccurrenceArgs',
    'FingerprintArgs',
    'GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs',
    'GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextArgs',
    'GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextArgs',
    'GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextArgs',
    'GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdArgs',
    'GoogleDevtoolsContaineranalysisV1alpha1RepoIdArgs',
    'GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs',
    'HashArgs',
    'InTotoProvenanceArgs',
    'InTotoStatementArgs',
    'InstallationArgs',
    'LayerArgs',
    'LicenseArgs',
    'LocationArgs',
    'MaterialArgs',
    'MetadataArgs',
    'NonCompliantFileArgs',
    'PackageInfoNoteArgs',
    'PackageInfoOccurrenceArgs',
    'PackageIssueArgs',
    'PackageArgs',
    'PgpSignedAttestationArgs',
    'RecipeArgs',
    'RelatedUrlArgs',
    'RelationshipNoteArgs',
    'RelationshipOccurrenceArgs',
    'RepoSourceArgs',
    'ResourceArgs',
    'SlsaBuilderArgs',
    'SlsaCompletenessArgs',
    'SlsaMetadataArgs',
    'SlsaProvenanceArgs',
    'SlsaRecipeArgs',
    'SourceArgs',
    'StatusArgs',
    'StorageSourceArgs',
    'SubjectArgs',
    'UpgradeDistributionArgs',
    'UpgradeNoteArgs',
    'UpgradeOccurrenceArgs',
    'VersionArgs',
    'VulnerabilityDetailsArgs',
    'VulnerabilityLocationArgs',
    'VulnerabilityTypeArgs',
]

@pulumi.input_type
class ArtifactArgs:
    def __init__(__self__, *,
                 checksum: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Artifact describes a build product.
        :param pulumi.Input[str] checksum: Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        :param pulumi.Input[str] id: Artifact ID, if any; for container images, this will be a URL by digest like gcr.io/projectID/imagename@sha256:123456
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[str]]:
        """
        Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Artifact ID, if any; for container images, this will be a URL by digest like gcr.io/projectID/imagename@sha256:123456
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "names", value)


@pulumi.input_type
class AttestationAuthorityHintArgs:
    def __init__(__self__, *,
                 human_readable_name: Optional[pulumi.Input[str]] = None):
        """
        This submessage provides human-readable hints about the purpose of the AttestationAuthority. Because the name of a Note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should NOT be used to look up AttestationAuthorities in security sensitive contexts, such as when looking up Attestations to verify.
        :param pulumi.Input[str] human_readable_name: The human readable name of this Attestation Authority, for example "qa".
        """
        if human_readable_name is not None:
            pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> Optional[pulumi.Input[str]]:
        """
        The human readable name of this Attestation Authority, for example "qa".
        """
        return pulumi.get(self, "human_readable_name")

    @human_readable_name.setter
    def human_readable_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "human_readable_name", value)


@pulumi.input_type
class AttestationAuthorityArgs:
    def __init__(__self__, *,
                 hint: Optional[pulumi.Input['AttestationAuthorityHintArgs']] = None):
        """
        Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `AttestationAuthority` for "QA" and one for "build". This Note is intended to act strictly as a grouping mechanism for the attached Occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an Occurrence to a given Note. It also provides a single point of lookup to find all attached Attestation Occurrences, even if they don't all live in the same project.
        """
        if hint is not None:
            pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> Optional[pulumi.Input['AttestationAuthorityHintArgs']]:
        return pulumi.get(self, "hint")

    @hint.setter
    def hint(self, value: Optional[pulumi.Input['AttestationAuthorityHintArgs']]):
        pulumi.set(self, "hint", value)


@pulumi.input_type
class AttestationArgs:
    def __init__(__self__, *,
                 pgp_signed_attestation: Optional[pulumi.Input['PgpSignedAttestationArgs']] = None):
        """
        Occurrence that represents a single "attestation". The authenticity of an Attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the AttestationAuthority to which this Attestation is attached is primarily useful for look-up (how to find this Attestation if you already know the Authority and artifact to be verified) and intent (which authority was this attestation intended to sign for).
        """
        if pgp_signed_attestation is not None:
            pulumi.set(__self__, "pgp_signed_attestation", pgp_signed_attestation)

    @property
    @pulumi.getter(name="pgpSignedAttestation")
    def pgp_signed_attestation(self) -> Optional[pulumi.Input['PgpSignedAttestationArgs']]:
        return pulumi.get(self, "pgp_signed_attestation")

    @pgp_signed_attestation.setter
    def pgp_signed_attestation(self, value: Optional[pulumi.Input['PgpSignedAttestationArgs']]):
        pulumi.set(self, "pgp_signed_attestation", value)


@pulumi.input_type
class BasisArgs:
    def __init__(__self__, *,
                 fingerprint: Optional[pulumi.Input['FingerprintArgs']] = None,
                 resource_url: Optional[pulumi.Input[str]] = None):
        """
        Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g. a tag of the resource_url.
        :param pulumi.Input['FingerprintArgs'] fingerprint: The fingerprint of the base image.
        :param pulumi.Input[str] resource_url: The resource_url for the resource representing the basis of associated occurrence images.
        """
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if resource_url is not None:
            pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input['FingerprintArgs']]:
        """
        The fingerprint of the base image.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input['FingerprintArgs']]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> Optional[pulumi.Input[str]]:
        """
        The resource_url for the resource representing the basis of associated occurrence images.
        """
        return pulumi.get(self, "resource_url")

    @resource_url.setter
    def resource_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_url", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class BuildDetailsArgs:
    def __init__(__self__, *,
                 intoto_statement: Optional[pulumi.Input['InTotoStatementArgs']] = None,
                 provenance: Optional[pulumi.Input['BuildProvenanceArgs']] = None,
                 provenance_bytes: Optional[pulumi.Input[str]] = None):
        """
        Message encapsulating build provenance details.
        :param pulumi.Input['InTotoStatementArgs'] intoto_statement: In-toto Statement representation as defined in spec. The intoto_statement can contain any type of provenance. The serialized payload of the statement can be stored and signed in the Occurrence's envelope.
        :param pulumi.Input['BuildProvenanceArgs'] provenance: The actual provenance
        :param pulumi.Input[str] provenance_bytes: Serialized JSON representation of the provenance, used in generating the `BuildSignature` in the corresponding Result. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        if intoto_statement is not None:
            pulumi.set(__self__, "intoto_statement", intoto_statement)
        if provenance is not None:
            pulumi.set(__self__, "provenance", provenance)
        if provenance_bytes is not None:
            pulumi.set(__self__, "provenance_bytes", provenance_bytes)

    @property
    @pulumi.getter(name="intotoStatement")
    def intoto_statement(self) -> Optional[pulumi.Input['InTotoStatementArgs']]:
        """
        In-toto Statement representation as defined in spec. The intoto_statement can contain any type of provenance. The serialized payload of the statement can be stored and signed in the Occurrence's envelope.
        """
        return pulumi.get(self, "intoto_statement")

    @intoto_statement.setter
    def intoto_statement(self, value: Optional[pulumi.Input['InTotoStatementArgs']]):
        pulumi.set(self, "intoto_statement", value)

    @property
    @pulumi.getter
    def provenance(self) -> Optional[pulumi.Input['BuildProvenanceArgs']]:
        """
        The actual provenance
        """
        return pulumi.get(self, "provenance")

    @provenance.setter
    def provenance(self, value: Optional[pulumi.Input['BuildProvenanceArgs']]):
        pulumi.set(self, "provenance", value)

    @property
    @pulumi.getter(name="provenanceBytes")
    def provenance_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Serialized JSON representation of the provenance, used in generating the `BuildSignature` in the corresponding Result. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        return pulumi.get(self, "provenance_bytes")

    @provenance_bytes.setter
    def provenance_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provenance_bytes", value)


@pulumi.input_type
class BuildProvenanceArgs:
    def __init__(__self__, *,
                 build_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 builder_version: Optional[pulumi.Input[str]] = None,
                 built_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input['CommandArgs']]]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 creator: Optional[pulumi.Input[str]] = None,
                 finish_time: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 logs_bucket: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_provenance: Optional[pulumi.Input['SourceArgs']] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 trigger_id: Optional[pulumi.Input[str]] = None):
        """
        Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_options: Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        :param pulumi.Input[str] builder_version: Version string of the builder at the time this build was executed.
        :param pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]] built_artifacts: Output of the build.
        :param pulumi.Input[Sequence[pulumi.Input['CommandArgs']]] commands: Commands requested by the build.
        :param pulumi.Input[str] create_time: Time at which the build was created.
        :param pulumi.Input[str] creator: E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        :param pulumi.Input[str] finish_time: Time at which execution of the build was finished.
        :param pulumi.Input[str] id: Unique identifier of the build.
        :param pulumi.Input[str] logs_bucket: Google Cloud Storage bucket where logs were written.
        :param pulumi.Input[str] project: ID of the project.
        :param pulumi.Input['SourceArgs'] source_provenance: Details of the Source input to the build.
        :param pulumi.Input[str] start_time: Time at which execution of the build was started.
        :param pulumi.Input[str] trigger_id: Trigger identifier if the build was triggered automatically; empty if not.
        """
        if build_options is not None:
            pulumi.set(__self__, "build_options", build_options)
        if builder_version is not None:
            pulumi.set(__self__, "builder_version", builder_version)
        if built_artifacts is not None:
            pulumi.set(__self__, "built_artifacts", built_artifacts)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if finish_time is not None:
            pulumi.set(__self__, "finish_time", finish_time)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logs_bucket is not None:
            pulumi.set(__self__, "logs_bucket", logs_bucket)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if source_provenance is not None:
            pulumi.set(__self__, "source_provenance", source_provenance)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter(name="buildOptions")
    def build_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        """
        return pulumi.get(self, "build_options")

    @build_options.setter
    def build_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "build_options", value)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version string of the builder at the time this build was executed.
        """
        return pulumi.get(self, "builder_version")

    @builder_version.setter
    def builder_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "builder_version", value)

    @property
    @pulumi.getter(name="builtArtifacts")
    def built_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]]]:
        """
        Output of the build.
        """
        return pulumi.get(self, "built_artifacts")

    @built_artifacts.setter
    def built_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]]]):
        pulumi.set(self, "built_artifacts", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CommandArgs']]]]:
        """
        Commands requested by the build.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CommandArgs']]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the build was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[str]]:
        """
        E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creator", value)

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which execution of the build was finished.
        """
        return pulumi.get(self, "finish_time")

    @finish_time.setter
    def finish_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "finish_time", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the build.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage bucket where logs were written.
        """
        return pulumi.get(self, "logs_bucket")

    @logs_bucket.setter
    def logs_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_bucket", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sourceProvenance")
    def source_provenance(self) -> Optional[pulumi.Input['SourceArgs']]:
        """
        Details of the Source input to the build.
        """
        return pulumi.get(self, "source_provenance")

    @source_provenance.setter
    def source_provenance(self, value: Optional[pulumi.Input['SourceArgs']]):
        pulumi.set(self, "source_provenance", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which execution of the build was started.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[str]]:
        """
        Trigger identifier if the build was triggered automatically; empty if not.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_id", value)


@pulumi.input_type
class BuildSignatureArgs:
    def __init__(__self__, *,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['BuildSignatureKeyType']] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None):
        """
        Message encapsulating the signature of the verified build.
        :param pulumi.Input[str] key_id: An Id for the key used to sign. This could be either an Id for the key stored in `public_key` (such as the Id or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        :param pulumi.Input['BuildSignatureKeyType'] key_type: The type of the key, either stored in `public_key` or referenced in `key_id`
        :param pulumi.Input[str] public_key: Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        :param pulumi.Input[str] signature: Signature of the related `BuildProvenance`, encoded in a base64 string.
        """
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        An Id for the key used to sign. This could be either an Id for the key stored in `public_key` (such as the Id or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['BuildSignatureKeyType']]:
        """
        The type of the key, either stored in `public_key` or referenced in `key_id`
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['BuildSignatureKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        Signature of the related `BuildProvenance`, encoded in a base64 string.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)


@pulumi.input_type
class BuildTypeArgs:
    def __init__(__self__, *,
                 builder_version: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input['BuildSignatureArgs']] = None):
        """
        Note holding the version of the provider's builder and the signature of the provenance message in linked BuildDetails.
        :param pulumi.Input[str] builder_version: Version of the builder which produced this Note.
        :param pulumi.Input['BuildSignatureArgs'] signature: Signature of the build in Occurrences pointing to the Note containing this `BuilderDetails`.
        """
        if builder_version is not None:
            pulumi.set(__self__, "builder_version", builder_version)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the builder which produced this Note.
        """
        return pulumi.get(self, "builder_version")

    @builder_version.setter
    def builder_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "builder_version", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input['BuildSignatureArgs']]:
        """
        Signature of the build in Occurrences pointing to the Note containing this `BuilderDetails`.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input['BuildSignatureArgs']]):
        pulumi.set(self, "signature", value)


@pulumi.input_type
class BuilderConfigArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class CVSSArgs:
    def __init__(__self__, *,
                 attack_complexity: Optional[pulumi.Input['CVSSAttackComplexity']] = None,
                 attack_vector: Optional[pulumi.Input['CVSSAttackVector']] = None,
                 authentication: Optional[pulumi.Input['CVSSAuthentication']] = None,
                 availability_impact: Optional[pulumi.Input['CVSSAvailabilityImpact']] = None,
                 base_score: Optional[pulumi.Input[float]] = None,
                 confidentiality_impact: Optional[pulumi.Input['CVSSConfidentialityImpact']] = None,
                 exploitability_score: Optional[pulumi.Input[float]] = None,
                 impact_score: Optional[pulumi.Input[float]] = None,
                 integrity_impact: Optional[pulumi.Input['CVSSIntegrityImpact']] = None,
                 privileges_required: Optional[pulumi.Input['CVSSPrivilegesRequired']] = None,
                 scope: Optional[pulumi.Input['CVSSScope']] = None,
                 user_interaction: Optional[pulumi.Input['CVSSUserInteraction']] = None):
        """
        Common Vulnerability Scoring System.
        :param pulumi.Input['CVSSAttackVector'] attack_vector: Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        :param pulumi.Input[float] base_score: The base score is a function of the base metric scores.
        """
        if attack_complexity is not None:
            pulumi.set(__self__, "attack_complexity", attack_complexity)
        if attack_vector is not None:
            pulumi.set(__self__, "attack_vector", attack_vector)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if availability_impact is not None:
            pulumi.set(__self__, "availability_impact", availability_impact)
        if base_score is not None:
            pulumi.set(__self__, "base_score", base_score)
        if confidentiality_impact is not None:
            pulumi.set(__self__, "confidentiality_impact", confidentiality_impact)
        if exploitability_score is not None:
            pulumi.set(__self__, "exploitability_score", exploitability_score)
        if impact_score is not None:
            pulumi.set(__self__, "impact_score", impact_score)
        if integrity_impact is not None:
            pulumi.set(__self__, "integrity_impact", integrity_impact)
        if privileges_required is not None:
            pulumi.set(__self__, "privileges_required", privileges_required)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if user_interaction is not None:
            pulumi.set(__self__, "user_interaction", user_interaction)

    @property
    @pulumi.getter(name="attackComplexity")
    def attack_complexity(self) -> Optional[pulumi.Input['CVSSAttackComplexity']]:
        return pulumi.get(self, "attack_complexity")

    @attack_complexity.setter
    def attack_complexity(self, value: Optional[pulumi.Input['CVSSAttackComplexity']]):
        pulumi.set(self, "attack_complexity", value)

    @property
    @pulumi.getter(name="attackVector")
    def attack_vector(self) -> Optional[pulumi.Input['CVSSAttackVector']]:
        """
        Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        """
        return pulumi.get(self, "attack_vector")

    @attack_vector.setter
    def attack_vector(self, value: Optional[pulumi.Input['CVSSAttackVector']]):
        pulumi.set(self, "attack_vector", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['CVSSAuthentication']]:
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['CVSSAuthentication']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="availabilityImpact")
    def availability_impact(self) -> Optional[pulumi.Input['CVSSAvailabilityImpact']]:
        return pulumi.get(self, "availability_impact")

    @availability_impact.setter
    def availability_impact(self, value: Optional[pulumi.Input['CVSSAvailabilityImpact']]):
        pulumi.set(self, "availability_impact", value)

    @property
    @pulumi.getter(name="baseScore")
    def base_score(self) -> Optional[pulumi.Input[float]]:
        """
        The base score is a function of the base metric scores.
        """
        return pulumi.get(self, "base_score")

    @base_score.setter
    def base_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "base_score", value)

    @property
    @pulumi.getter(name="confidentialityImpact")
    def confidentiality_impact(self) -> Optional[pulumi.Input['CVSSConfidentialityImpact']]:
        return pulumi.get(self, "confidentiality_impact")

    @confidentiality_impact.setter
    def confidentiality_impact(self, value: Optional[pulumi.Input['CVSSConfidentialityImpact']]):
        pulumi.set(self, "confidentiality_impact", value)

    @property
    @pulumi.getter(name="exploitabilityScore")
    def exploitability_score(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "exploitability_score")

    @exploitability_score.setter
    def exploitability_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "exploitability_score", value)

    @property
    @pulumi.getter(name="impactScore")
    def impact_score(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "impact_score")

    @impact_score.setter
    def impact_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "impact_score", value)

    @property
    @pulumi.getter(name="integrityImpact")
    def integrity_impact(self) -> Optional[pulumi.Input['CVSSIntegrityImpact']]:
        return pulumi.get(self, "integrity_impact")

    @integrity_impact.setter
    def integrity_impact(self, value: Optional[pulumi.Input['CVSSIntegrityImpact']]):
        pulumi.set(self, "integrity_impact", value)

    @property
    @pulumi.getter(name="privilegesRequired")
    def privileges_required(self) -> Optional[pulumi.Input['CVSSPrivilegesRequired']]:
        return pulumi.get(self, "privileges_required")

    @privileges_required.setter
    def privileges_required(self, value: Optional[pulumi.Input['CVSSPrivilegesRequired']]):
        pulumi.set(self, "privileges_required", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['CVSSScope']]:
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['CVSSScope']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="userInteraction")
    def user_interaction(self) -> Optional[pulumi.Input['CVSSUserInteraction']]:
        return pulumi.get(self, "user_interaction")

    @user_interaction.setter
    def user_interaction(self, value: Optional[pulumi.Input['CVSSUserInteraction']]):
        pulumi.set(self, "user_interaction", value)


@pulumi.input_type
class CisBenchmarkArgs:
    def __init__(__self__, *,
                 profile_level: Optional[pulumi.Input[int]] = None,
                 severity: Optional[pulumi.Input['CisBenchmarkSeverity']] = None):
        """
        A compliance check that is a CIS benchmark.
        :param pulumi.Input[int] profile_level: The profile level of this CIS benchmark check.
        :param pulumi.Input['CisBenchmarkSeverity'] severity: The severity level of this CIS benchmark check.
        """
        if profile_level is not None:
            pulumi.set(__self__, "profile_level", profile_level)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="profileLevel")
    def profile_level(self) -> Optional[pulumi.Input[int]]:
        """
        The profile level of this CIS benchmark check.
        """
        return pulumi.get(self, "profile_level")

    @profile_level.setter
    def profile_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "profile_level", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input['CisBenchmarkSeverity']]:
        """
        The severity level of this CIS benchmark check.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input['CisBenchmarkSeverity']]):
        pulumi.set(self, "severity", value)


@pulumi.input_type
class CommandArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 wait_for: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Command describes a step performed as part of the build pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Command-line arguments used when executing this Command.
        :param pulumi.Input[str] dir: Working directory (relative to project source root) used when running this Command.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] env: Environment variables set before running this Command.
        :param pulumi.Input[str] id: Optional unique identifier for this Command, used in wait_for to reference this Command as a dependency.
        :param pulumi.Input[str] name: Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wait_for: The ID(s) of the Command(s) that this Command depends on.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if wait_for is not None:
            pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Command-line arguments used when executing this Command.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Working directory (relative to project source root) used when running this Command.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Environment variables set before running this Command.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional unique identifier for this Command, used in wait_for to reference this Command as a dependency.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID(s) of the Command(s) that this Command depends on.
        """
        return pulumi.get(self, "wait_for")

    @wait_for.setter
    def wait_for(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wait_for", value)


@pulumi.input_type
class CompletenessArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[bool]] = None,
                 environment: Optional[pulumi.Input[bool]] = None,
                 materials: Optional[pulumi.Input[bool]] = None):
        """
        Indicates that the builder claims certain fields in this message to be complete.
        :param pulumi.Input[bool] arguments: If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        :param pulumi.Input[bool] environment: If true, the builder claims that recipe.environment is claimed to be complete.
        :param pulumi.Input[bool] materials: If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if materials is not None:
            pulumi.set(__self__, "materials", materials)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that recipe.environment is claimed to be complete.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def materials(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        return pulumi.get(self, "materials")

    @materials.setter
    def materials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "materials", value)


@pulumi.input_type
class ComplianceNoteArgs:
    def __init__(__self__, *,
                 cis_benchmark: Optional[pulumi.Input['CisBenchmarkArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 rationale: Optional[pulumi.Input[str]] = None,
                 remediation: Optional[pulumi.Input[str]] = None,
                 scan_instructions: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceVersionArgs']]]] = None):
        """
        ComplianceNote encapsulates all information about a specific compliance check.
        :param pulumi.Input['CisBenchmarkArgs'] cis_benchmark: Right now we only have one compliance type, but we may add additional types in the future.
        :param pulumi.Input[str] description: A description about this compliance check.
        :param pulumi.Input[str] rationale: A rationale for the existence of this compliance check.
        :param pulumi.Input[str] remediation: A description of remediation steps if the compliance check fails.
        :param pulumi.Input[str] scan_instructions: Serialized scan instructions with a predefined format.
        :param pulumi.Input[str] title: The title that identifies this compliance check.
        :param pulumi.Input[Sequence[pulumi.Input['ComplianceVersionArgs']]] version: The OS and config versions the benchmark applies to.
        """
        if cis_benchmark is not None:
            pulumi.set(__self__, "cis_benchmark", cis_benchmark)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if rationale is not None:
            pulumi.set(__self__, "rationale", rationale)
        if remediation is not None:
            pulumi.set(__self__, "remediation", remediation)
        if scan_instructions is not None:
            pulumi.set(__self__, "scan_instructions", scan_instructions)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cisBenchmark")
    def cis_benchmark(self) -> Optional[pulumi.Input['CisBenchmarkArgs']]:
        """
        Right now we only have one compliance type, but we may add additional types in the future.
        """
        return pulumi.get(self, "cis_benchmark")

    @cis_benchmark.setter
    def cis_benchmark(self, value: Optional[pulumi.Input['CisBenchmarkArgs']]):
        pulumi.set(self, "cis_benchmark", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description about this compliance check.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def rationale(self) -> Optional[pulumi.Input[str]]:
        """
        A rationale for the existence of this compliance check.
        """
        return pulumi.get(self, "rationale")

    @rationale.setter
    def rationale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rationale", value)

    @property
    @pulumi.getter
    def remediation(self) -> Optional[pulumi.Input[str]]:
        """
        A description of remediation steps if the compliance check fails.
        """
        return pulumi.get(self, "remediation")

    @remediation.setter
    def remediation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remediation", value)

    @property
    @pulumi.getter(name="scanInstructions")
    def scan_instructions(self) -> Optional[pulumi.Input[str]]:
        """
        Serialized scan instructions with a predefined format.
        """
        return pulumi.get(self, "scan_instructions")

    @scan_instructions.setter
    def scan_instructions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_instructions", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The title that identifies this compliance check.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceVersionArgs']]]]:
        """
        The OS and config versions the benchmark applies to.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceVersionArgs']]]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ComplianceOccurrenceArgs:
    def __init__(__self__, *,
                 non_compliance_reason: Optional[pulumi.Input[str]] = None,
                 non_compliant_files: Optional[pulumi.Input[Sequence[pulumi.Input['NonCompliantFileArgs']]]] = None):
        """
        An indication that the compliance checks in the associated ComplianceNote were not satisfied for particular resources or a specified reason.
        :param pulumi.Input[str] non_compliance_reason: The reason for non compliance of these files.
        :param pulumi.Input[Sequence[pulumi.Input['NonCompliantFileArgs']]] non_compliant_files: A list of files which are violating compliance checks.
        """
        if non_compliance_reason is not None:
            pulumi.set(__self__, "non_compliance_reason", non_compliance_reason)
        if non_compliant_files is not None:
            pulumi.set(__self__, "non_compliant_files", non_compliant_files)

    @property
    @pulumi.getter(name="nonComplianceReason")
    def non_compliance_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for non compliance of these files.
        """
        return pulumi.get(self, "non_compliance_reason")

    @non_compliance_reason.setter
    def non_compliance_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "non_compliance_reason", value)

    @property
    @pulumi.getter(name="nonCompliantFiles")
    def non_compliant_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NonCompliantFileArgs']]]]:
        """
        A list of files which are violating compliance checks.
        """
        return pulumi.get(self, "non_compliant_files")

    @non_compliant_files.setter
    def non_compliant_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NonCompliantFileArgs']]]]):
        pulumi.set(self, "non_compliant_files", value)


@pulumi.input_type
class ComplianceVersionArgs:
    def __init__(__self__, *,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Describes the CIS benchmark version that is applicable to a given OS and os version.
        :param pulumi.Input[str] cpe_uri: The CPE URI (https://cpe.mitre.org/specification/) this benchmark is applicable to.
        :param pulumi.Input[str] version: The version of the benchmark. This is set to the version of the OS-specific CIS document the benchmark is defined in.
        """
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The CPE URI (https://cpe.mitre.org/specification/) this benchmark is applicable to.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the benchmark. This is set to the version of the OS-specific CIS document the benchmark is defined in.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class DSSEAttestationNoteArgs:
    def __init__(__self__, *,
                 hint: Optional[pulumi.Input['DSSEHintArgs']] = None):
        """
        A note describing an attestation
        :param pulumi.Input['DSSEHintArgs'] hint: DSSEHint hints at the purpose of the attestation authority.
        """
        if hint is not None:
            pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> Optional[pulumi.Input['DSSEHintArgs']]:
        """
        DSSEHint hints at the purpose of the attestation authority.
        """
        return pulumi.get(self, "hint")

    @hint.setter
    def hint(self, value: Optional[pulumi.Input['DSSEHintArgs']]):
        pulumi.set(self, "hint", value)


@pulumi.input_type
class DSSEAttestationOccurrenceArgs:
    def __init__(__self__, *,
                 envelope: Optional[pulumi.Input['EnvelopeArgs']] = None,
                 statement: Optional[pulumi.Input['InTotoStatementArgs']] = None):
        """
        An occurrence describing an attestation on a resource
        :param pulumi.Input['EnvelopeArgs'] envelope: If doing something security critical, make sure to verify the signatures in this metadata.
        """
        if envelope is not None:
            pulumi.set(__self__, "envelope", envelope)
        if statement is not None:
            pulumi.set(__self__, "statement", statement)

    @property
    @pulumi.getter
    def envelope(self) -> Optional[pulumi.Input['EnvelopeArgs']]:
        """
        If doing something security critical, make sure to verify the signatures in this metadata.
        """
        return pulumi.get(self, "envelope")

    @envelope.setter
    def envelope(self, value: Optional[pulumi.Input['EnvelopeArgs']]):
        pulumi.set(self, "envelope", value)

    @property
    @pulumi.getter
    def statement(self) -> Optional[pulumi.Input['InTotoStatementArgs']]:
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: Optional[pulumi.Input['InTotoStatementArgs']]):
        pulumi.set(self, "statement", value)


@pulumi.input_type
class DSSEHintArgs:
    def __init__(__self__, *,
                 human_readable_name: pulumi.Input[str]):
        """
        This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
        :param pulumi.Input[str] human_readable_name: The human readable name of this attestation authority, for example "cloudbuild-prod".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> pulumi.Input[str]:
        """
        The human readable name of this attestation authority, for example "cloudbuild-prod".
        """
        return pulumi.get(self, "human_readable_name")

    @human_readable_name.setter
    def human_readable_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "human_readable_name", value)


@pulumi.input_type
class DeployableArgs:
    def __init__(__self__, *,
                 resource_uri: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An artifact that can be deployed in some runtime.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_uri: Resource URI for the artifact being deployed.
        """
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource URI for the artifact being deployed.
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_uri", value)


@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[str]] = None,
                 deploy_time: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input['DeploymentPlatform']] = None,
                 undeploy_time: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None):
        """
        The period during which some deployable was active in a runtime.
        :param pulumi.Input[str] address: Address of the runtime element hosting this deployment.
        :param pulumi.Input[str] config: Configuration used to create this deployment.
        :param pulumi.Input[str] deploy_time: Beginning of the lifetime of this deployment.
        :param pulumi.Input['DeploymentPlatform'] platform: Platform hosting this deployment.
        :param pulumi.Input[str] undeploy_time: End of the lifetime of this deployment.
        :param pulumi.Input[str] user_email: Identity of the user that triggered this deployment.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if deploy_time is not None:
            pulumi.set(__self__, "deploy_time", deploy_time)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if undeploy_time is not None:
            pulumi.set(__self__, "undeploy_time", undeploy_time)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Address of the runtime element hosting this deployment.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration used to create this deployment.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="deployTime")
    def deploy_time(self) -> Optional[pulumi.Input[str]]:
        """
        Beginning of the lifetime of this deployment.
        """
        return pulumi.get(self, "deploy_time")

    @deploy_time.setter
    def deploy_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_time", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['DeploymentPlatform']]:
        """
        Platform hosting this deployment.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['DeploymentPlatform']]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="undeployTime")
    def undeploy_time(self) -> Optional[pulumi.Input[str]]:
        """
        End of the lifetime of this deployment.
        """
        return pulumi.get(self, "undeploy_time")

    @undeploy_time.setter
    def undeploy_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "undeploy_time", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[str]]:
        """
        Identity of the user that triggered this deployment.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email", value)


@pulumi.input_type
class DerivedArgs:
    def __init__(__self__, *,
                 fingerprint: Optional[pulumi.Input['FingerprintArgs']] = None,
                 layer_info: Optional[pulumi.Input[Sequence[pulumi.Input['LayerArgs']]]] = None):
        """
        Derived describes the derived image portion (Occurrence) of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
        :param pulumi.Input['FingerprintArgs'] fingerprint: The fingerprint of the derived image.
        :param pulumi.Input[Sequence[pulumi.Input['LayerArgs']]] layer_info: This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if layer_info is not None:
            pulumi.set(__self__, "layer_info", layer_info)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input['FingerprintArgs']]:
        """
        The fingerprint of the derived image.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input['FingerprintArgs']]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="layerInfo")
    def layer_info(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LayerArgs']]]]:
        """
        This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        return pulumi.get(self, "layer_info")

    @layer_info.setter
    def layer_info(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LayerArgs']]]]):
        pulumi.set(self, "layer_info", value)


@pulumi.input_type
class DetailArgs:
    def __init__(__self__, *,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fixed_location: Optional[pulumi.Input['VulnerabilityLocationArgs']] = None,
                 is_obsolete: Optional[pulumi.Input[bool]] = None,
                 max_affected_version: Optional[pulumi.Input['VersionArgs']] = None,
                 min_affected_version: Optional[pulumi.Input['VersionArgs']] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 severity_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[str]] = None):
        """
        Identifies all occurrences of this vulnerability in the package for a specific distro/location For example: glibc in cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
        :param pulumi.Input[str] cpe_uri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        :param pulumi.Input[str] description: A vendor-specific description of this note.
        :param pulumi.Input['VulnerabilityLocationArgs'] fixed_location: The fix for this specific package version.
        :param pulumi.Input[bool] is_obsolete: Whether this Detail is obsolete. Occurrences are expected not to point to obsolete details.
        :param pulumi.Input['VersionArgs'] max_affected_version: The max version of the package in which the vulnerability exists.
        :param pulumi.Input['VersionArgs'] min_affected_version: The min version of the package in which the vulnerability exists.
        :param pulumi.Input[str] package: The name of the package where the vulnerability was found. This field can be used as a filter in list requests.
        :param pulumi.Input[str] package_type: The type of package; whether native or non native(ruby gems, node.js packages etc)
        :param pulumi.Input[str] severity_name: The severity (eg: distro assigned severity) for this vulnerability.
        :param pulumi.Input[str] source: The source from which the information in this Detail was obtained.
        :param pulumi.Input[str] vendor: The vendor of the product. e.g. "google"
        """
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fixed_location is not None:
            pulumi.set(__self__, "fixed_location", fixed_location)
        if is_obsolete is not None:
            pulumi.set(__self__, "is_obsolete", is_obsolete)
        if max_affected_version is not None:
            pulumi.set(__self__, "max_affected_version", max_affected_version)
        if min_affected_version is not None:
            pulumi.set(__self__, "min_affected_version", min_affected_version)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if severity_name is not None:
            pulumi.set(__self__, "severity_name", severity_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A vendor-specific description of this note.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> Optional[pulumi.Input['VulnerabilityLocationArgs']]:
        """
        The fix for this specific package version.
        """
        return pulumi.get(self, "fixed_location")

    @fixed_location.setter
    def fixed_location(self, value: Optional[pulumi.Input['VulnerabilityLocationArgs']]):
        pulumi.set(self, "fixed_location", value)

    @property
    @pulumi.getter(name="isObsolete")
    def is_obsolete(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this Detail is obsolete. Occurrences are expected not to point to obsolete details.
        """
        return pulumi.get(self, "is_obsolete")

    @is_obsolete.setter
    def is_obsolete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_obsolete", value)

    @property
    @pulumi.getter(name="maxAffectedVersion")
    def max_affected_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The max version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "max_affected_version")

    @max_affected_version.setter
    def max_affected_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "max_affected_version", value)

    @property
    @pulumi.getter(name="minAffectedVersion")
    def min_affected_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The min version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "min_affected_version")

    @min_affected_version.setter
    def min_affected_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "min_affected_version", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the package where the vulnerability was found. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc)
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> Optional[pulumi.Input[str]]:
        """
        The severity (eg: distro assigned severity) for this vulnerability.
        """
        return pulumi.get(self, "severity_name")

    @severity_name.setter
    def severity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity_name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source from which the information in this Detail was obtained.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[str]]:
        """
        The vendor of the product. e.g. "google"
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor", value)


@pulumi.input_type
class DiscoveredArgs:
    def __init__(__self__, *,
                 analysis_status: Optional[pulumi.Input['DiscoveredAnalysisStatus']] = None,
                 analysis_status_error: Optional[pulumi.Input['StatusArgs']] = None,
                 archive_time: Optional[pulumi.Input[str]] = None,
                 continuous_analysis: Optional[pulumi.Input['DiscoveredContinuousAnalysis']] = None,
                 cpe: Optional[pulumi.Input[str]] = None,
                 last_scan_time: Optional[pulumi.Input[str]] = None):
        """
        Provides information about the scan status of a discovered resource.
        :param pulumi.Input['DiscoveredAnalysisStatus'] analysis_status: The status of discovery for the resource.
        :param pulumi.Input['StatusArgs'] analysis_status_error: When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage output only and populated by the API.
        :param pulumi.Input[str] archive_time: The time occurrences related to this discovery occurrence were archived.
        :param pulumi.Input['DiscoveredContinuousAnalysis'] continuous_analysis: Whether the resource is continuously analyzed.
        :param pulumi.Input[str] cpe: The CPE of the resource being scanned.
        :param pulumi.Input[str] last_scan_time: The last time this resource was scanned.
        """
        if analysis_status is not None:
            pulumi.set(__self__, "analysis_status", analysis_status)
        if analysis_status_error is not None:
            pulumi.set(__self__, "analysis_status_error", analysis_status_error)
        if archive_time is not None:
            pulumi.set(__self__, "archive_time", archive_time)
        if continuous_analysis is not None:
            pulumi.set(__self__, "continuous_analysis", continuous_analysis)
        if cpe is not None:
            pulumi.set(__self__, "cpe", cpe)
        if last_scan_time is not None:
            pulumi.set(__self__, "last_scan_time", last_scan_time)

    @property
    @pulumi.getter(name="analysisStatus")
    def analysis_status(self) -> Optional[pulumi.Input['DiscoveredAnalysisStatus']]:
        """
        The status of discovery for the resource.
        """
        return pulumi.get(self, "analysis_status")

    @analysis_status.setter
    def analysis_status(self, value: Optional[pulumi.Input['DiscoveredAnalysisStatus']]):
        pulumi.set(self, "analysis_status", value)

    @property
    @pulumi.getter(name="analysisStatusError")
    def analysis_status_error(self) -> Optional[pulumi.Input['StatusArgs']]:
        """
        When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage output only and populated by the API.
        """
        return pulumi.get(self, "analysis_status_error")

    @analysis_status_error.setter
    def analysis_status_error(self, value: Optional[pulumi.Input['StatusArgs']]):
        pulumi.set(self, "analysis_status_error", value)

    @property
    @pulumi.getter(name="archiveTime")
    def archive_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time occurrences related to this discovery occurrence were archived.
        """
        return pulumi.get(self, "archive_time")

    @archive_time.setter
    def archive_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "archive_time", value)

    @property
    @pulumi.getter(name="continuousAnalysis")
    def continuous_analysis(self) -> Optional[pulumi.Input['DiscoveredContinuousAnalysis']]:
        """
        Whether the resource is continuously analyzed.
        """
        return pulumi.get(self, "continuous_analysis")

    @continuous_analysis.setter
    def continuous_analysis(self, value: Optional[pulumi.Input['DiscoveredContinuousAnalysis']]):
        pulumi.set(self, "continuous_analysis", value)

    @property
    @pulumi.getter
    def cpe(self) -> Optional[pulumi.Input[str]]:
        """
        The CPE of the resource being scanned.
        """
        return pulumi.get(self, "cpe")

    @cpe.setter
    def cpe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe", value)

    @property
    @pulumi.getter(name="lastScanTime")
    def last_scan_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last time this resource was scanned.
        """
        return pulumi.get(self, "last_scan_time")

    @last_scan_time.setter
    def last_scan_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_scan_time", value)


@pulumi.input_type
class DiscoveryArgs:
    def __init__(__self__, *,
                 analysis_kind: Optional[pulumi.Input['DiscoveryAnalysisKind']] = None):
        """
        A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis. The occurrence's operation will indicate the status of the analysis. Absence of an occurrence linked to this note for a resource indicates that analysis hasn't started.
        :param pulumi.Input['DiscoveryAnalysisKind'] analysis_kind: The kind of analysis that is handled by this discovery.
        """
        if analysis_kind is not None:
            pulumi.set(__self__, "analysis_kind", analysis_kind)

    @property
    @pulumi.getter(name="analysisKind")
    def analysis_kind(self) -> Optional[pulumi.Input['DiscoveryAnalysisKind']]:
        """
        The kind of analysis that is handled by this discovery.
        """
        return pulumi.get(self, "analysis_kind")

    @analysis_kind.setter
    def analysis_kind(self, value: Optional[pulumi.Input['DiscoveryAnalysisKind']]):
        pulumi.set(self, "analysis_kind", value)


@pulumi.input_type
class DistributionArgs:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input['DistributionArchitecture']] = None,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 latest_version: Optional[pulumi.Input['VersionArgs']] = None,
                 maintainer: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        This represents a particular channel of distribution for a given package. e.g. Debian's jessie-backports dpkg mirror
        :param pulumi.Input['DistributionArchitecture'] architecture: The CPU architecture for which packages in this distribution channel were built
        :param pulumi.Input[str] cpe_uri: The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param pulumi.Input[str] description: The distribution channel-specific description of this package.
        :param pulumi.Input['VersionArgs'] latest_version: The latest available version of this package in this distribution channel.
        :param pulumi.Input[str] maintainer: A freeform string denoting the maintainer of this package.
        :param pulumi.Input[str] url: The distribution channel-specific homepage for this package.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if maintainer is not None:
            pulumi.set(__self__, "maintainer", maintainer)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input['DistributionArchitecture']]:
        """
        The CPU architecture for which packages in this distribution channel were built
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input['DistributionArchitecture']]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The distribution channel-specific description of this package.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The latest available version of this package in this distribution channel.
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "latest_version", value)

    @property
    @pulumi.getter
    def maintainer(self) -> Optional[pulumi.Input[str]]:
        """
        A freeform string denoting the maintainer of this package.
        """
        return pulumi.get(self, "maintainer")

    @maintainer.setter
    def maintainer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintainer", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The distribution channel-specific homepage for this package.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class DocumentNoteArgs:
    def __init__(__self__, *,
                 data_licence: Optional[pulumi.Input[str]] = None,
                 spdx_version: Optional[pulumi.Input[str]] = None):
        """
        DocumentNote represents an SPDX Document Creation Infromation section: https://spdx.github.io/spdx-spec/2-document-creation-information/
        :param pulumi.Input[str] data_licence: Compliance with the SPDX specification includes populating the SPDX fields therein with data related to such fields ("SPDX-Metadata")
        :param pulumi.Input[str] spdx_version: Provide a reference number that can be used to understand how to parse and interpret the rest of the file
        """
        if data_licence is not None:
            pulumi.set(__self__, "data_licence", data_licence)
        if spdx_version is not None:
            pulumi.set(__self__, "spdx_version", spdx_version)

    @property
    @pulumi.getter(name="dataLicence")
    def data_licence(self) -> Optional[pulumi.Input[str]]:
        """
        Compliance with the SPDX specification includes populating the SPDX fields therein with data related to such fields ("SPDX-Metadata")
        """
        return pulumi.get(self, "data_licence")

    @data_licence.setter
    def data_licence(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_licence", value)

    @property
    @pulumi.getter(name="spdxVersion")
    def spdx_version(self) -> Optional[pulumi.Input[str]]:
        """
        Provide a reference number that can be used to understand how to parse and interpret the rest of the file
        """
        return pulumi.get(self, "spdx_version")

    @spdx_version.setter
    def spdx_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spdx_version", value)


@pulumi.input_type
class DocumentOccurrenceArgs:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 creator_comment: Optional[pulumi.Input[str]] = None,
                 creators: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 document_comment: Optional[pulumi.Input[str]] = None,
                 external_document_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 license_list_version: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        DocumentOccurrence represents an SPDX Document Creation Information section: https://spdx.github.io/spdx-spec/2-document-creation-information/
        :param pulumi.Input[str] create_time: Identify when the SPDX file was originally created. The date is to be specified according to combined date and time in UTC format as specified in ISO 8601 standard
        :param pulumi.Input[str] creator_comment: A field for creators of the SPDX file to provide general comments about the creation of the SPDX file or any other relevant comment not included in the other fields
        :param pulumi.Input[Sequence[pulumi.Input[str]]] creators: Identify who (or what, in the case of a tool) created the SPDX file. If the SPDX file was created by an individual, indicate the person's name
        :param pulumi.Input[str] document_comment: A field for creators of the SPDX file content to provide comments to the consumers of the SPDX document
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_document_refs: Identify any external SPDX documents referenced within this SPDX document
        :param pulumi.Input[str] id: Identify the current SPDX document which may be referenced in relationships by other files, packages internally and documents externally
        :param pulumi.Input[str] license_list_version: A field for creators of the SPDX file to provide the version of the SPDX License List used when the SPDX file was created
        :param pulumi.Input[str] namespace: Provide an SPDX document specific namespace as a unique absolute Uniform Resource Identifier (URI) as specified in RFC-3986, with the exception of the ‘#’ delimiter
        :param pulumi.Input[str] title: Identify name of this document as designated by creator
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator_comment is not None:
            pulumi.set(__self__, "creator_comment", creator_comment)
        if creators is not None:
            pulumi.set(__self__, "creators", creators)
        if document_comment is not None:
            pulumi.set(__self__, "document_comment", document_comment)
        if external_document_refs is not None:
            pulumi.set(__self__, "external_document_refs", external_document_refs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if license_list_version is not None:
            pulumi.set(__self__, "license_list_version", license_list_version)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Identify when the SPDX file was originally created. The date is to be specified according to combined date and time in UTC format as specified in ISO 8601 standard
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="creatorComment")
    def creator_comment(self) -> Optional[pulumi.Input[str]]:
        """
        A field for creators of the SPDX file to provide general comments about the creation of the SPDX file or any other relevant comment not included in the other fields
        """
        return pulumi.get(self, "creator_comment")

    @creator_comment.setter
    def creator_comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creator_comment", value)

    @property
    @pulumi.getter
    def creators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Identify who (or what, in the case of a tool) created the SPDX file. If the SPDX file was created by an individual, indicate the person's name
        """
        return pulumi.get(self, "creators")

    @creators.setter
    def creators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "creators", value)

    @property
    @pulumi.getter(name="documentComment")
    def document_comment(self) -> Optional[pulumi.Input[str]]:
        """
        A field for creators of the SPDX file content to provide comments to the consumers of the SPDX document
        """
        return pulumi.get(self, "document_comment")

    @document_comment.setter
    def document_comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_comment", value)

    @property
    @pulumi.getter(name="externalDocumentRefs")
    def external_document_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Identify any external SPDX documents referenced within this SPDX document
        """
        return pulumi.get(self, "external_document_refs")

    @external_document_refs.setter
    def external_document_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "external_document_refs", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Identify the current SPDX document which may be referenced in relationships by other files, packages internally and documents externally
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="licenseListVersion")
    def license_list_version(self) -> Optional[pulumi.Input[str]]:
        """
        A field for creators of the SPDX file to provide the version of the SPDX License List used when the SPDX file was created
        """
        return pulumi.get(self, "license_list_version")

    @license_list_version.setter
    def license_list_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_list_version", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Provide an SPDX document specific namespace as a unique absolute Uniform Resource Identifier (URI) as specified in RFC-3986, with the exception of the ‘#’ delimiter
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Identify name of this document as designated by creator
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class EnvelopeSignatureArgs:
    def __init__(__self__, *,
                 keyid: Optional[pulumi.Input[str]] = None,
                 sig: Optional[pulumi.Input[str]] = None):
        """
        A DSSE signature
        :param pulumi.Input[str] keyid: A reference id to the key being used for signing
        :param pulumi.Input[str] sig: The signature itself
        """
        if keyid is not None:
            pulumi.set(__self__, "keyid", keyid)
        if sig is not None:
            pulumi.set(__self__, "sig", sig)

    @property
    @pulumi.getter
    def keyid(self) -> Optional[pulumi.Input[str]]:
        """
        A reference id to the key being used for signing
        """
        return pulumi.get(self, "keyid")

    @keyid.setter
    def keyid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyid", value)

    @property
    @pulumi.getter
    def sig(self) -> Optional[pulumi.Input[str]]:
        """
        The signature itself
        """
        return pulumi.get(self, "sig")

    @sig.setter
    def sig(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sig", value)


@pulumi.input_type
class EnvelopeArgs:
    def __init__(__self__, *,
                 payload: Optional[pulumi.Input[str]] = None,
                 payload_type: Optional[pulumi.Input[str]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input['EnvelopeSignatureArgs']]]] = None):
        """
        MUST match https://github.com/secure-systems-lab/dsse/blob/master/envelope.proto. An authenticated message of arbitrary type.
        :param pulumi.Input[str] payload: The bytes being signed
        :param pulumi.Input[str] payload_type: The type of payload being signed
        :param pulumi.Input[Sequence[pulumi.Input['EnvelopeSignatureArgs']]] signatures: The signatures over the payload
        """
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_type is not None:
            pulumi.set(__self__, "payload_type", payload_type)
        if signatures is not None:
            pulumi.set(__self__, "signatures", signatures)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[str]]:
        """
        The bytes being signed
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of payload being signed
        """
        return pulumi.get(self, "payload_type")

    @payload_type.setter
    def payload_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_type", value)

    @property
    @pulumi.getter
    def signatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvelopeSignatureArgs']]]]:
        """
        The signatures over the payload
        """
        return pulumi.get(self, "signatures")

    @signatures.setter
    def signatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvelopeSignatureArgs']]]]):
        pulumi.set(self, "signatures", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class ExternalRefArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input['ExternalRefCategory']] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 locator: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
        :param pulumi.Input['ExternalRefCategory'] category: An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
        :param pulumi.Input[str] comment: Human-readable information about the purpose and target of the reference
        :param pulumi.Input[str] locator: The unique string with no spaces necessary to access the package-specific information, metadata, or content within the target location
        :param pulumi.Input[str] type: Type of category (e.g. 'npm' for the PACKAGE_MANAGER category)
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if locator is not None:
            pulumi.set(__self__, "locator", locator)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input['ExternalRefCategory']]:
        """
        An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input['ExternalRefCategory']]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable information about the purpose and target of the reference
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def locator(self) -> Optional[pulumi.Input[str]]:
        """
        The unique string with no spaces necessary to access the package-specific information, metadata, or content within the target location
        """
        return pulumi.get(self, "locator")

    @locator.setter
    def locator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locator", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of category (e.g. 'npm' for the PACKAGE_MANAGER category)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FileNoteArgs:
    def __init__(__self__, *,
                 checksum: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_type: Optional[pulumi.Input['FileNoteFileType']] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        FileNote represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
        :param pulumi.Input[Sequence[pulumi.Input[str]]] checksum: Provide a unique identifier to match analysis information on each specific file in a package
        :param pulumi.Input['FileNoteFileType'] file_type: This field provides information about the type of file identified
        :param pulumi.Input[str] title: Identify the full path and filename that corresponds to the file information in this section
        """
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Provide a unique identifier to match analysis information on each specific file in a package
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[pulumi.Input['FileNoteFileType']]:
        """
        This field provides information about the type of file identified
        """
        return pulumi.get(self, "file_type")

    @file_type.setter
    def file_type(self, value: Optional[pulumi.Input['FileNoteFileType']]):
        pulumi.set(self, "file_type", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Identify the full path and filename that corresponds to the file information in this section
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class FileOccurrenceArgs:
    def __init__(__self__, *,
                 attributions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 contributors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 copyright: Optional[pulumi.Input[str]] = None,
                 files_license_info: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 license_concluded: Optional[pulumi.Input['LicenseArgs']] = None,
                 notice: Optional[pulumi.Input[str]] = None):
        """
        FileOccurrence represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attributions: This field provides a place for the SPDX data creator to record, at the file level, acknowledgements that may be needed to be communicated in some contexts
        :param pulumi.Input[str] comment: This field provides a place for the SPDX file creator to record any general comments about the file
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contributors: This field provides a place for the SPDX file creator to record file contributors
        :param pulumi.Input[str] copyright: Identify the copyright holder of the file, as well as any dates present
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files_license_info: This field contains the license information actually found in the file, if any
        :param pulumi.Input[str] id: Uniquely identify any element in an SPDX document which may be referenced by other elements
        :param pulumi.Input['LicenseArgs'] license_concluded: This field contains the license the SPDX file creator has concluded as governing the file or alternative values if the governing license cannot be determined
        :param pulumi.Input[str] notice: This field provides a place for the SPDX file creator to record license notices or other such related notices found in the file
        """
        if attributions is not None:
            pulumi.set(__self__, "attributions", attributions)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if contributors is not None:
            pulumi.set(__self__, "contributors", contributors)
        if copyright is not None:
            pulumi.set(__self__, "copyright", copyright)
        if files_license_info is not None:
            pulumi.set(__self__, "files_license_info", files_license_info)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if license_concluded is not None:
            pulumi.set(__self__, "license_concluded", license_concluded)
        if notice is not None:
            pulumi.set(__self__, "notice", notice)

    @property
    @pulumi.getter
    def attributions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This field provides a place for the SPDX data creator to record, at the file level, acknowledgements that may be needed to be communicated in some contexts
        """
        return pulumi.get(self, "attributions")

    @attributions.setter
    def attributions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attributions", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        This field provides a place for the SPDX file creator to record any general comments about the file
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def contributors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This field provides a place for the SPDX file creator to record file contributors
        """
        return pulumi.get(self, "contributors")

    @contributors.setter
    def contributors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contributors", value)

    @property
    @pulumi.getter
    def copyright(self) -> Optional[pulumi.Input[str]]:
        """
        Identify the copyright holder of the file, as well as any dates present
        """
        return pulumi.get(self, "copyright")

    @copyright.setter
    def copyright(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copyright", value)

    @property
    @pulumi.getter(name="filesLicenseInfo")
    def files_license_info(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This field contains the license information actually found in the file, if any
        """
        return pulumi.get(self, "files_license_info")

    @files_license_info.setter
    def files_license_info(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files_license_info", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Uniquely identify any element in an SPDX document which may be referenced by other elements
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="licenseConcluded")
    def license_concluded(self) -> Optional[pulumi.Input['LicenseArgs']]:
        """
        This field contains the license the SPDX file creator has concluded as governing the file or alternative values if the governing license cannot be determined
        """
        return pulumi.get(self, "license_concluded")

    @license_concluded.setter
    def license_concluded(self, value: Optional[pulumi.Input['LicenseArgs']]):
        pulumi.set(self, "license_concluded", value)

    @property
    @pulumi.getter
    def notice(self) -> Optional[pulumi.Input[str]]:
        """
        This field provides a place for the SPDX file creator to record license notices or other such related notices found in the file
        """
        return pulumi.get(self, "notice")

    @notice.setter
    def notice(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notice", value)


@pulumi.input_type
class FingerprintArgs:
    def __init__(__self__, *,
                 v1_name: Optional[pulumi.Input[str]] = None,
                 v2_blob: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A set of properties that uniquely identify a given Docker image.
        :param pulumi.Input[str] v1_name: The layer-id of the final layer in the Docker image's v1 representation. This field can be used as a filter in list requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] v2_blob: The ordered list of v2 blobs that represent a given image.
        """
        if v1_name is not None:
            pulumi.set(__self__, "v1_name", v1_name)
        if v2_blob is not None:
            pulumi.set(__self__, "v2_blob", v2_blob)

    @property
    @pulumi.getter(name="v1Name")
    def v1_name(self) -> Optional[pulumi.Input[str]]:
        """
        The layer-id of the final layer in the Docker image's v1 representation. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "v1_name")

    @v1_name.setter
    def v1_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v1_name", value)

    @property
    @pulumi.getter(name="v2Blob")
    def v2_blob(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ordered list of v2 blobs that represent a given image.
        """
        return pulumi.get(self, "v2_blob")

    @v2_blob.setter
    def v2_blob(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "v2_blob", value)


@pulumi.input_type
class GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextKind']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        An alias to a repo revision.
        :param pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextKind'] kind: The alias kind.
        :param pulumi.Input[str] name: The alias name.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextKind']]:
        """
        The alias kind.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextKind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The alias name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextArgs:
    def __init__(__self__, *,
                 alias_context: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs']] = None,
                 repo_id: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1RepoIdArgs']] = None,
                 revision_id: Optional[pulumi.Input[str]] = None):
        """
        A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
        :param pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs'] alias_context: An alias, which may be a branch or tag.
        :param pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1RepoIdArgs'] repo_id: The ID of the repo.
        :param pulumi.Input[str] revision_id: A revision ID.
        """
        if alias_context is not None:
            pulumi.set(__self__, "alias_context", alias_context)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs']]:
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @alias_context.setter
    def alias_context(self, value: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs']]):
        pulumi.set(self, "alias_context", value)

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1RepoIdArgs']]:
        """
        The ID of the repo.
        """
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1RepoIdArgs']]):
        pulumi.set(self, "repo_id", value)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        A revision ID.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)


@pulumi.input_type
class GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextArgs:
    def __init__(__self__, *,
                 alias_context: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs']] = None,
                 gerrit_project: Optional[pulumi.Input[str]] = None,
                 host_uri: Optional[pulumi.Input[str]] = None,
                 revision_id: Optional[pulumi.Input[str]] = None):
        """
        A SourceContext referring to a Gerrit project.
        :param pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs'] alias_context: An alias, which may be a branch or tag.
        :param pulumi.Input[str] gerrit_project: The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        :param pulumi.Input[str] host_uri: The URI of a running Gerrit instance.
        :param pulumi.Input[str] revision_id: A revision (commit) ID.
        """
        if alias_context is not None:
            pulumi.set(__self__, "alias_context", alias_context)
        if gerrit_project is not None:
            pulumi.set(__self__, "gerrit_project", gerrit_project)
        if host_uri is not None:
            pulumi.set(__self__, "host_uri", host_uri)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs']]:
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @alias_context.setter
    def alias_context(self, value: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1AliasContextArgs']]):
        pulumi.set(self, "alias_context", value)

    @property
    @pulumi.getter(name="gerritProject")
    def gerrit_project(self) -> Optional[pulumi.Input[str]]:
        """
        The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        """
        return pulumi.get(self, "gerrit_project")

    @gerrit_project.setter
    def gerrit_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gerrit_project", value)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of a running Gerrit instance.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        A revision (commit) ID.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)


@pulumi.input_type
class GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextArgs:
    def __init__(__self__, *,
                 revision_id: pulumi.Input[str],
                 url: Optional[pulumi.Input[str]] = None):
        """
        A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
        :param pulumi.Input[str] revision_id: Git commit hash.
        :param pulumi.Input[str] url: Git repository URL.
        """
        pulumi.set(__self__, "revision_id", revision_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Input[str]:
        """
        Git commit hash.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "revision_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Git repository URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdArgs:
    def __init__(__self__, *,
                 project: Optional[pulumi.Input[str]] = None,
                 repo_name: Optional[pulumi.Input[str]] = None):
        """
        Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
        :param pulumi.Input[str] project: The ID of the project.
        :param pulumi.Input[str] repo_name: The name of the repo. Leave empty for the default repo.
        """
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo. Leave empty for the default repo.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_name", value)


@pulumi.input_type
class GoogleDevtoolsContaineranalysisV1alpha1RepoIdArgs:
    def __init__(__self__, *,
                 project_repo_id: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdArgs']] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        A unique identifier for a Cloud Repo.
        :param pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdArgs'] project_repo_id: A combination of a project ID and a repo name.
        :param pulumi.Input[str] uid: A server-assigned, globally unique identifier.
        """
        if project_repo_id is not None:
            pulumi.set(__self__, "project_repo_id", project_repo_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="projectRepoId")
    def project_repo_id(self) -> Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdArgs']]:
        """
        A combination of a project ID and a repo name.
        """
        return pulumi.get(self, "project_repo_id")

    @project_repo_id.setter
    def project_repo_id(self, value: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdArgs']]):
        pulumi.set(self, "project_repo_id", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        A server-assigned, globally unique identifier.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs:
    def __init__(__self__, *,
                 cloud_repo: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextArgs']] = None,
                 gerrit: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextArgs']] = None,
                 git: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
        :param pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextArgs'] cloud_repo: A SourceContext referring to a revision in a Google Cloud Source Repo.
        :param pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextArgs'] gerrit: A SourceContext referring to a Gerrit project.
        :param pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextArgs'] git: A SourceContext referring to any third party Git repo (e.g., GitHub).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user defined metadata.
        """
        if cloud_repo is not None:
            pulumi.set(__self__, "cloud_repo", cloud_repo)
        if gerrit is not None:
            pulumi.set(__self__, "gerrit", gerrit)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="cloudRepo")
    def cloud_repo(self) -> Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextArgs']]:
        """
        A SourceContext referring to a revision in a Google Cloud Source Repo.
        """
        return pulumi.get(self, "cloud_repo")

    @cloud_repo.setter
    def cloud_repo(self, value: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextArgs']]):
        pulumi.set(self, "cloud_repo", value)

    @property
    @pulumi.getter
    def gerrit(self) -> Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextArgs']]:
        """
        A SourceContext referring to a Gerrit project.
        """
        return pulumi.get(self, "gerrit")

    @gerrit.setter
    def gerrit(self, value: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextArgs']]):
        pulumi.set(self, "gerrit", value)

    @property
    @pulumi.getter
    def git(self) -> Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextArgs']]:
        """
        A SourceContext referring to any third party Git repo (e.g., GitHub).
        """
        return pulumi.get(self, "git")

    @git.setter
    def git(self, value: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextArgs']]):
        pulumi.set(self, "git", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels with user defined metadata.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class HashArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['HashType']] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Container message for hash values.
        :param pulumi.Input['HashType'] type: The type of hash that was performed.
        :param pulumi.Input[str] value: The hash value.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['HashType']]:
        """
        The type of hash that was performed.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['HashType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The hash value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class InTotoProvenanceArgs:
    def __init__(__self__, *,
                 builder_config: Optional[pulumi.Input['BuilderConfigArgs']] = None,
                 materials: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input['MetadataArgs']] = None,
                 recipe: Optional[pulumi.Input['RecipeArgs']] = None):
        """
        :param pulumi.Input['BuilderConfigArgs'] builder_config: required
        :param pulumi.Input[Sequence[pulumi.Input[str]]] materials: The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        :param pulumi.Input['RecipeArgs'] recipe: Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        if builder_config is not None:
            pulumi.set(__self__, "builder_config", builder_config)
        if materials is not None:
            pulumi.set(__self__, "materials", materials)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if recipe is not None:
            pulumi.set(__self__, "recipe", recipe)

    @property
    @pulumi.getter(name="builderConfig")
    def builder_config(self) -> Optional[pulumi.Input['BuilderConfigArgs']]:
        """
        required
        """
        return pulumi.get(self, "builder_config")

    @builder_config.setter
    def builder_config(self, value: Optional[pulumi.Input['BuilderConfigArgs']]):
        pulumi.set(self, "builder_config", value)

    @property
    @pulumi.getter
    def materials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        """
        return pulumi.get(self, "materials")

    @materials.setter
    def materials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "materials", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['MetadataArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['MetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def recipe(self) -> Optional[pulumi.Input['RecipeArgs']]:
        """
        Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        return pulumi.get(self, "recipe")

    @recipe.setter
    def recipe(self, value: Optional[pulumi.Input['RecipeArgs']]):
        pulumi.set(self, "recipe", value)


@pulumi.input_type
class InTotoStatementArgs:
    def __init__(__self__, *,
                 predicate_type: Optional[pulumi.Input[str]] = None,
                 provenance: Optional[pulumi.Input['InTotoProvenanceArgs']] = None,
                 slsa_provenance: Optional[pulumi.Input['SlsaProvenanceArgs']] = None,
                 subject: Optional[pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Spec defined at https://github.com/in-toto/attestation/tree/main/spec#statement The serialized InTotoStatement will be stored as Envelope.payload. Envelope.payloadType is always "application/vnd.in-toto+json".
        :param pulumi.Input[str] predicate_type: "https://slsa.dev/provenance/v0.1" for SlsaProvenance.
        :param pulumi.Input['InTotoProvenanceArgs'] provenance: provenance is a predicate of type intotoprovenance
        :param pulumi.Input['SlsaProvenanceArgs'] slsa_provenance: slsa_provenance is a predicate of type slsaProvenance
        :param pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]] subject: subject is the subjects of the intoto statement
        :param pulumi.Input[str] type: Always "https://in-toto.io/Statement/v0.1".
        """
        if predicate_type is not None:
            pulumi.set(__self__, "predicate_type", predicate_type)
        if provenance is not None:
            pulumi.set(__self__, "provenance", provenance)
        if slsa_provenance is not None:
            pulumi.set(__self__, "slsa_provenance", slsa_provenance)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="predicateType")
    def predicate_type(self) -> Optional[pulumi.Input[str]]:
        """
        "https://slsa.dev/provenance/v0.1" for SlsaProvenance.
        """
        return pulumi.get(self, "predicate_type")

    @predicate_type.setter
    def predicate_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "predicate_type", value)

    @property
    @pulumi.getter
    def provenance(self) -> Optional[pulumi.Input['InTotoProvenanceArgs']]:
        """
        provenance is a predicate of type intotoprovenance
        """
        return pulumi.get(self, "provenance")

    @provenance.setter
    def provenance(self, value: Optional[pulumi.Input['InTotoProvenanceArgs']]):
        pulumi.set(self, "provenance", value)

    @property
    @pulumi.getter(name="slsaProvenance")
    def slsa_provenance(self) -> Optional[pulumi.Input['SlsaProvenanceArgs']]:
        """
        slsa_provenance is a predicate of type slsaProvenance
        """
        return pulumi.get(self, "slsa_provenance")

    @slsa_provenance.setter
    def slsa_provenance(self, value: Optional[pulumi.Input['SlsaProvenanceArgs']]):
        pulumi.set(self, "slsa_provenance", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]]:
        """
        subject is the subjects of the intoto statement
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Always "https://in-toto.io/Statement/v0.1".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class InstallationArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]] = None):
        """
        This represents how a particular software package may be installed on a system.
        :param pulumi.Input[Sequence[pulumi.Input['LocationArgs']]] location: All of the places within the filesystem versions of this package have been found.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]]:
        """
        All of the places within the filesystem versions of this package have been found.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class LayerArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[str]] = None,
                 directive: Optional[pulumi.Input['LayerDirective']] = None):
        """
        Layer holds metadata specific to a layer of a Docker image.
        :param pulumi.Input[str] arguments: The recovered arguments to the Dockerfile directive.
        :param pulumi.Input['LayerDirective'] directive: The recovered Dockerfile directive used to construct this layer.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if directive is not None:
            pulumi.set(__self__, "directive", directive)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[str]]:
        """
        The recovered arguments to the Dockerfile directive.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def directive(self) -> Optional[pulumi.Input['LayerDirective']]:
        """
        The recovered Dockerfile directive used to construct this layer.
        """
        return pulumi.get(self, "directive")

    @directive.setter
    def directive(self, value: Optional[pulumi.Input['LayerDirective']]):
        pulumi.set(self, "directive", value)


@pulumi.input_type
class LicenseArgs:
    def __init__(__self__, *,
                 comments: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None):
        """
        License information: https://spdx.github.io/spdx-spec/3-package-information/#315-declared-license
        :param pulumi.Input[str] comments: Comments
        :param pulumi.Input[str] expression: Expression: https://spdx.github.io/spdx-spec/appendix-IV-SPDX-license-expressions/
        """
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[str]]:
        """
        Comments
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comments", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Expression: https://spdx.github.io/spdx-spec/appendix-IV-SPDX-license-expressions/
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)


@pulumi.input_type
class LocationArgs:
    def __init__(__self__, *,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input['VersionArgs']] = None):
        """
        An occurrence of a particular package installation found within a system's filesystem. e.g. glibc was found in /var/lib/dpkg/status
        :param pulumi.Input[str] cpe_uri: The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param pulumi.Input[str] path: The path from which we gathered that this package/version is installed.
        :param pulumi.Input['VersionArgs'] version: The version installed at this location.
        """
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path from which we gathered that this package/version is installed.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The version installed at this location.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class MaterialArgs:
    def __init__(__self__, *,
                 digest: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Material is a material used in the generation of the provenance
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] digest: digest is a map from a hash algorithm (e.g. sha256) to the value in the material
        :param pulumi.Input[str] uri: uri is the uri of the material
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        digest is a map from a hash algorithm (e.g. sha256) to the value in the material
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "digest", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        uri is the uri of the material
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class MetadataArgs:
    def __init__(__self__, *,
                 build_finished_on: Optional[pulumi.Input[str]] = None,
                 build_invocation_id: Optional[pulumi.Input[str]] = None,
                 build_started_on: Optional[pulumi.Input[str]] = None,
                 completeness: Optional[pulumi.Input['CompletenessArgs']] = None,
                 reproducible: Optional[pulumi.Input[bool]] = None):
        """
        Other properties of the build.
        :param pulumi.Input[str] build_finished_on: The timestamp of when the build completed.
        :param pulumi.Input[str] build_invocation_id: Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        :param pulumi.Input[str] build_started_on: The timestamp of when the build started.
        :param pulumi.Input['CompletenessArgs'] completeness: Indicates that the builder claims certain fields in this message to be complete.
        :param pulumi.Input[bool] reproducible: If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        if build_finished_on is not None:
            pulumi.set(__self__, "build_finished_on", build_finished_on)
        if build_invocation_id is not None:
            pulumi.set(__self__, "build_invocation_id", build_invocation_id)
        if build_started_on is not None:
            pulumi.set(__self__, "build_started_on", build_started_on)
        if completeness is not None:
            pulumi.set(__self__, "completeness", completeness)
        if reproducible is not None:
            pulumi.set(__self__, "reproducible", reproducible)

    @property
    @pulumi.getter(name="buildFinishedOn")
    def build_finished_on(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the build completed.
        """
        return pulumi.get(self, "build_finished_on")

    @build_finished_on.setter
    def build_finished_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_finished_on", value)

    @property
    @pulumi.getter(name="buildInvocationId")
    def build_invocation_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        """
        return pulumi.get(self, "build_invocation_id")

    @build_invocation_id.setter
    def build_invocation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_invocation_id", value)

    @property
    @pulumi.getter(name="buildStartedOn")
    def build_started_on(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the build started.
        """
        return pulumi.get(self, "build_started_on")

    @build_started_on.setter
    def build_started_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_started_on", value)

    @property
    @pulumi.getter
    def completeness(self) -> Optional[pulumi.Input['CompletenessArgs']]:
        """
        Indicates that the builder claims certain fields in this message to be complete.
        """
        return pulumi.get(self, "completeness")

    @completeness.setter
    def completeness(self, value: Optional[pulumi.Input['CompletenessArgs']]):
        pulumi.set(self, "completeness", value)

    @property
    @pulumi.getter
    def reproducible(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        return pulumi.get(self, "reproducible")

    @reproducible.setter
    def reproducible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reproducible", value)


@pulumi.input_type
class NonCompliantFileArgs:
    def __init__(__self__, *,
                 display_command: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        Details about files that caused a compliance check to fail.
        :param pulumi.Input[str] display_command: Command to display the non-compliant files.
        :param pulumi.Input[str] path: display_command is a single command that can be used to display a list of non compliant files. When there is no such command, we can also iterate a list of non compliant file using 'path'. Empty if `display_command` is set.
        :param pulumi.Input[str] reason: Explains why a file is non compliant for a CIS check.
        """
        if display_command is not None:
            pulumi.set(__self__, "display_command", display_command)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter(name="displayCommand")
    def display_command(self) -> Optional[pulumi.Input[str]]:
        """
        Command to display the non-compliant files.
        """
        return pulumi.get(self, "display_command")

    @display_command.setter
    def display_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_command", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        display_command is a single command that can be used to display a list of non compliant files. When there is no such command, we can also iterate a list of non compliant file using 'path'. Empty if `display_command` is set.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Explains why a file is non compliant for a CIS check.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class PackageInfoNoteArgs:
    def __init__(__self__, *,
                 analyzed: Optional[pulumi.Input[bool]] = None,
                 attribution: Optional[pulumi.Input[str]] = None,
                 checksum: Optional[pulumi.Input[str]] = None,
                 copyright: Optional[pulumi.Input[str]] = None,
                 detailed_description: Optional[pulumi.Input[str]] = None,
                 download_location: Optional[pulumi.Input[str]] = None,
                 external_refs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalRefArgs']]]] = None,
                 files_license_info: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 home_page: Optional[pulumi.Input[str]] = None,
                 license_declared: Optional[pulumi.Input['LicenseArgs']] = None,
                 originator: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 summary_description: Optional[pulumi.Input[str]] = None,
                 supplier: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 verification_code: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        PackageInfoNote represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
        :param pulumi.Input[bool] analyzed: Indicates whether the file content of this package has been available for or subjected to analysis when creating the SPDX document
        :param pulumi.Input[str] attribution: A place for the SPDX data creator to record, at the package level, acknowledgements that may be needed to be communicated in some contexts
        :param pulumi.Input[str] checksum: Provide an independently reproducible mechanism that permits unique identification of a specific package that correlates to the data in this SPDX file
        :param pulumi.Input[str] copyright: Identify the copyright holders of the package, as well as any dates present
        :param pulumi.Input[str] detailed_description: A more detailed description of the package
        :param pulumi.Input[str] download_location: This section identifies the download Universal Resource Locator (URL), or a specific location within a version control system (VCS) for the package at the time that the SPDX file was created
        :param pulumi.Input[Sequence[pulumi.Input['ExternalRefArgs']]] external_refs: ExternalRef
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files_license_info: Contain the license the SPDX file creator has concluded as governing the This field is to contain a list of all licenses found in the package. The relationship between licenses (i.e., conjunctive, disjunctive) is not specified in this field – it is simply a listing of all licenses found
        :param pulumi.Input[str] home_page: Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        :param pulumi.Input['LicenseArgs'] license_declared: List the licenses that have been declared by the authors of the package
        :param pulumi.Input[str] originator: If the package identified in the SPDX file originated from a different person or organization than identified as Package Supplier, this field identifies from where or whom the package originally came
        :param pulumi.Input[str] package_type: The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        :param pulumi.Input[str] summary_description: A short description of the package
        :param pulumi.Input[str] supplier: Identify the actual distribution source for the package/directory identified in the SPDX file
        :param pulumi.Input[str] title: Identify the full name of the package as given by the Package Originator
        :param pulumi.Input[str] verification_code: This field provides an independently reproducible mechanism identifying specific contents of a package based on the actual files (except the SPDX file itself, if it is included in the package) that make up each package and that correlates to the data in this SPDX file
        :param pulumi.Input[str] version: Identify the version of the package
        """
        if analyzed is not None:
            pulumi.set(__self__, "analyzed", analyzed)
        if attribution is not None:
            pulumi.set(__self__, "attribution", attribution)
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if copyright is not None:
            pulumi.set(__self__, "copyright", copyright)
        if detailed_description is not None:
            pulumi.set(__self__, "detailed_description", detailed_description)
        if download_location is not None:
            pulumi.set(__self__, "download_location", download_location)
        if external_refs is not None:
            pulumi.set(__self__, "external_refs", external_refs)
        if files_license_info is not None:
            pulumi.set(__self__, "files_license_info", files_license_info)
        if home_page is not None:
            pulumi.set(__self__, "home_page", home_page)
        if license_declared is not None:
            pulumi.set(__self__, "license_declared", license_declared)
        if originator is not None:
            pulumi.set(__self__, "originator", originator)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if summary_description is not None:
            pulumi.set(__self__, "summary_description", summary_description)
        if supplier is not None:
            pulumi.set(__self__, "supplier", supplier)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if verification_code is not None:
            pulumi.set(__self__, "verification_code", verification_code)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def analyzed(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the file content of this package has been available for or subjected to analysis when creating the SPDX document
        """
        return pulumi.get(self, "analyzed")

    @analyzed.setter
    def analyzed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "analyzed", value)

    @property
    @pulumi.getter
    def attribution(self) -> Optional[pulumi.Input[str]]:
        """
        A place for the SPDX data creator to record, at the package level, acknowledgements that may be needed to be communicated in some contexts
        """
        return pulumi.get(self, "attribution")

    @attribution.setter
    def attribution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attribution", value)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[str]]:
        """
        Provide an independently reproducible mechanism that permits unique identification of a specific package that correlates to the data in this SPDX file
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter
    def copyright(self) -> Optional[pulumi.Input[str]]:
        """
        Identify the copyright holders of the package, as well as any dates present
        """
        return pulumi.get(self, "copyright")

    @copyright.setter
    def copyright(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copyright", value)

    @property
    @pulumi.getter(name="detailedDescription")
    def detailed_description(self) -> Optional[pulumi.Input[str]]:
        """
        A more detailed description of the package
        """
        return pulumi.get(self, "detailed_description")

    @detailed_description.setter
    def detailed_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detailed_description", value)

    @property
    @pulumi.getter(name="downloadLocation")
    def download_location(self) -> Optional[pulumi.Input[str]]:
        """
        This section identifies the download Universal Resource Locator (URL), or a specific location within a version control system (VCS) for the package at the time that the SPDX file was created
        """
        return pulumi.get(self, "download_location")

    @download_location.setter
    def download_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "download_location", value)

    @property
    @pulumi.getter(name="externalRefs")
    def external_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalRefArgs']]]]:
        """
        ExternalRef
        """
        return pulumi.get(self, "external_refs")

    @external_refs.setter
    def external_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalRefArgs']]]]):
        pulumi.set(self, "external_refs", value)

    @property
    @pulumi.getter(name="filesLicenseInfo")
    def files_license_info(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Contain the license the SPDX file creator has concluded as governing the This field is to contain a list of all licenses found in the package. The relationship between licenses (i.e., conjunctive, disjunctive) is not specified in this field – it is simply a listing of all licenses found
        """
        return pulumi.get(self, "files_license_info")

    @files_license_info.setter
    def files_license_info(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files_license_info", value)

    @property
    @pulumi.getter(name="homePage")
    def home_page(self) -> Optional[pulumi.Input[str]]:
        """
        Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        """
        return pulumi.get(self, "home_page")

    @home_page.setter
    def home_page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "home_page", value)

    @property
    @pulumi.getter(name="licenseDeclared")
    def license_declared(self) -> Optional[pulumi.Input['LicenseArgs']]:
        """
        List the licenses that have been declared by the authors of the package
        """
        return pulumi.get(self, "license_declared")

    @license_declared.setter
    def license_declared(self, value: Optional[pulumi.Input['LicenseArgs']]):
        pulumi.set(self, "license_declared", value)

    @property
    @pulumi.getter
    def originator(self) -> Optional[pulumi.Input[str]]:
        """
        If the package identified in the SPDX file originated from a different person or organization than identified as Package Supplier, this field identifies from where or whom the package originally came
        """
        return pulumi.get(self, "originator")

    @originator.setter
    def originator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "originator", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter(name="summaryDescription")
    def summary_description(self) -> Optional[pulumi.Input[str]]:
        """
        A short description of the package
        """
        return pulumi.get(self, "summary_description")

    @summary_description.setter
    def summary_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary_description", value)

    @property
    @pulumi.getter
    def supplier(self) -> Optional[pulumi.Input[str]]:
        """
        Identify the actual distribution source for the package/directory identified in the SPDX file
        """
        return pulumi.get(self, "supplier")

    @supplier.setter
    def supplier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "supplier", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Identify the full name of the package as given by the Package Originator
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="verificationCode")
    def verification_code(self) -> Optional[pulumi.Input[str]]:
        """
        This field provides an independently reproducible mechanism identifying specific contents of a package based on the actual files (except the SPDX file itself, if it is included in the package) that make up each package and that correlates to the data in this SPDX file
        """
        return pulumi.get(self, "verification_code")

    @verification_code.setter
    def verification_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verification_code", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Identify the version of the package
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class PackageInfoOccurrenceArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 filename: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 license_concluded: Optional[pulumi.Input['LicenseArgs']] = None,
                 source_info: Optional[pulumi.Input[str]] = None):
        """
        PackageInfoOccurrence represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
        :param pulumi.Input[str] comment: A place for the SPDX file creator to record any general comments about the package being described
        :param pulumi.Input[str] filename: Provide the actual file name of the package, or path of the directory being treated as a package
        :param pulumi.Input[str] id: Uniquely identify any element in an SPDX document which may be referenced by other elements
        :param pulumi.Input['LicenseArgs'] license_concluded: package or alternative values, if the governing license cannot be determined
        :param pulumi.Input[str] source_info: Provide a place for the SPDX file creator to record any relevant background information or additional comments about the origin of the package
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if license_concluded is not None:
            pulumi.set(__self__, "license_concluded", license_concluded)
        if source_info is not None:
            pulumi.set(__self__, "source_info", source_info)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A place for the SPDX file creator to record any general comments about the package being described
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[str]]:
        """
        Provide the actual file name of the package, or path of the directory being treated as a package
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Uniquely identify any element in an SPDX document which may be referenced by other elements
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="licenseConcluded")
    def license_concluded(self) -> Optional[pulumi.Input['LicenseArgs']]:
        """
        package or alternative values, if the governing license cannot be determined
        """
        return pulumi.get(self, "license_concluded")

    @license_concluded.setter
    def license_concluded(self, value: Optional[pulumi.Input['LicenseArgs']]):
        pulumi.set(self, "license_concluded", value)

    @property
    @pulumi.getter(name="sourceInfo")
    def source_info(self) -> Optional[pulumi.Input[str]]:
        """
        Provide a place for the SPDX file creator to record any relevant background information or additional comments about the origin of the package
        """
        return pulumi.get(self, "source_info")

    @source_info.setter
    def source_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_info", value)


@pulumi.input_type
class PackageIssueArgs:
    def __init__(__self__, *,
                 affected_location: Optional[pulumi.Input['VulnerabilityLocationArgs']] = None,
                 fixed_location: Optional[pulumi.Input['VulnerabilityLocationArgs']] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 severity_name: Optional[pulumi.Input[str]] = None):
        """
        This message wraps a location affected by a vulnerability and its associated fix (if one is available).
        :param pulumi.Input['VulnerabilityLocationArgs'] affected_location: The location of the vulnerability.
        :param pulumi.Input['VulnerabilityLocationArgs'] fixed_location: The location of the available fix for vulnerability.
        :param pulumi.Input[str] package_type: The type of package (e.g. OS, MAVEN, GO).
        """
        if affected_location is not None:
            pulumi.set(__self__, "affected_location", affected_location)
        if fixed_location is not None:
            pulumi.set(__self__, "fixed_location", fixed_location)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if severity_name is not None:
            pulumi.set(__self__, "severity_name", severity_name)

    @property
    @pulumi.getter(name="affectedLocation")
    def affected_location(self) -> Optional[pulumi.Input['VulnerabilityLocationArgs']]:
        """
        The location of the vulnerability.
        """
        return pulumi.get(self, "affected_location")

    @affected_location.setter
    def affected_location(self, value: Optional[pulumi.Input['VulnerabilityLocationArgs']]):
        pulumi.set(self, "affected_location", value)

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> Optional[pulumi.Input['VulnerabilityLocationArgs']]:
        """
        The location of the available fix for vulnerability.
        """
        return pulumi.get(self, "fixed_location")

    @fixed_location.setter
    def fixed_location(self, value: Optional[pulumi.Input['VulnerabilityLocationArgs']]):
        pulumi.set(self, "fixed_location", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of package (e.g. OS, MAVEN, GO).
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "severity_name")

    @severity_name.setter
    def severity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity_name", value)


@pulumi.input_type
class PackageArgs:
    def __init__(__self__, *,
                 distribution: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        This represents a particular package that is distributed over various channels. e.g. glibc (aka libc6) is distributed by many, at various versions.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]] distribution: The various channels by which a package is distributed.
        :param pulumi.Input[str] name: The name of the package.
        """
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]]]:
        """
        The various channels by which a package is distributed.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]]]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the package.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PgpSignedAttestationArgs:
    def __init__(__self__, *,
                 content_type: Optional[pulumi.Input['PgpSignedAttestationContentType']] = None,
                 pgp_key_id: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None):
        """
        An attestation wrapper with a PGP-compatible signature. This message only supports `ATTACHED` signatures, where the payload that is signed is included alongside the signature itself in the same file.
        :param pulumi.Input['PgpSignedAttestationContentType'] content_type: Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        :param pulumi.Input[str] pgp_key_id: The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexadecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        :param pulumi.Input[str] signature: The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if pgp_key_id is not None:
            pulumi.set(__self__, "pgp_key_id", pgp_key_id)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input['PgpSignedAttestationContentType']]:
        """
        Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input['PgpSignedAttestationContentType']]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="pgpKeyId")
    def pgp_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexadecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        """
        return pulumi.get(self, "pgp_key_id")

    @pgp_key_id.setter
    def pgp_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pgp_key_id", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)


@pulumi.input_type
class RecipeArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 defined_in_material: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] arguments: Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint.
        :param pulumi.Input[str] defined_in_material: Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        :param pulumi.Input[str] entry_point: String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] environment: Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy.
        :param pulumi.Input[str] type: URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defined_in_material is not None:
            pulumi.set(__self__, "defined_in_material", defined_in_material)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="definedInMaterial")
    def defined_in_material(self) -> Optional[pulumi.Input[str]]:
        """
        Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        """
        return pulumi.get(self, "defined_in_material")

    @defined_in_material.setter
    def defined_in_material(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "defined_in_material", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[str]]:
        """
        String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RelatedUrlArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Metadata for any related URL information
        :param pulumi.Input[str] label: Label to describe usage of the URL
        :param pulumi.Input[str] url: Specific URL to associate with the note
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label to describe usage of the URL
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Specific URL to associate with the note
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class RelationshipNoteArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['RelationshipNoteType']] = None):
        """
        RelationshipNote represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
        :param pulumi.Input['RelationshipNoteType'] type: The type of relationship between the source and target SPDX elements
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['RelationshipNoteType']]:
        """
        The type of relationship between the source and target SPDX elements
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['RelationshipNoteType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RelationshipOccurrenceArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        RelationshipOccurrence represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
        :param pulumi.Input[str] comment: A place for the SPDX file creator to record any general comments about the relationship
        :param pulumi.Input[str] source: Also referred to as SPDXRef-A The source SPDX element (file, package, etc)
        :param pulumi.Input[str] target: Also referred to as SPDXRef-B The target SPDC element (file, package, etc) In cases where there are "known unknowns", the use of the keyword NOASSERTION can be used The keywords NONE can be used to indicate that an SPDX element (package/file/snippet) has no other elements connected by some relationship to it
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A place for the SPDX file creator to record any general comments about the relationship
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Also referred to as SPDXRef-A The source SPDX element (file, package, etc)
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Also referred to as SPDXRef-B The target SPDC element (file, package, etc) In cases where there are "known unknowns", the use of the keyword NOASSERTION can be used The keywords NONE can be used to indicate that an SPDX element (package/file/snippet) has no other elements connected by some relationship to it
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class RepoSourceArgs:
    def __init__(__self__, *,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 commit_sha: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 repo_name: Optional[pulumi.Input[str]] = None,
                 tag_name: Optional[pulumi.Input[str]] = None):
        """
        RepoSource describes the location of the source in a Google Cloud Source Repository.
        :param pulumi.Input[str] branch_name: Name of the branch to build.
        :param pulumi.Input[str] commit_sha: Explicit commit SHA to build.
        :param pulumi.Input[str] project: ID of the project that owns the repo.
        :param pulumi.Input[str] repo_name: Name of the repo.
        :param pulumi.Input[str] tag_name: Name of the tag to build.
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the branch to build.
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[str]]:
        """
        Explicit commit SHA to build.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_sha", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project that owns the repo.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the repo.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_name", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the tag to build.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_name", value)


@pulumi.input_type
class ResourceArgs:
    def __init__(__self__, *,
                 content_hash: Optional[pulumi.Input['HashArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
         Resource is an entity that can have metadata. E.g., a Docker image.
        :param pulumi.Input['HashArgs'] content_hash: The hash of the resource content. E.g., the Docker digest.
        :param pulumi.Input[str] name: The name of the resource. E.g., the name of a Docker image - "Debian".
        :param pulumi.Input[str] uri: The unique URI of the resource. E.g., "https://gcr.io/project/image@sha256:foo" for a Docker image.
        """
        if content_hash is not None:
            pulumi.set(__self__, "content_hash", content_hash)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> Optional[pulumi.Input['HashArgs']]:
        """
        The hash of the resource content. E.g., the Docker digest.
        """
        return pulumi.get(self, "content_hash")

    @content_hash.setter
    def content_hash(self, value: Optional[pulumi.Input['HashArgs']]):
        pulumi.set(self, "content_hash", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource. E.g., the name of a Docker image - "Debian".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The unique URI of the resource. E.g., "https://gcr.io/project/image@sha256:foo" for a Docker image.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class SlsaBuilderArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        SlsaBuilder encapsulates the identity of the builder of this provenance.
        :param pulumi.Input[str] id: id is the id of the slsa provenance builder
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        id is the id of the slsa provenance builder
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SlsaCompletenessArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[bool]] = None,
                 environment: Optional[pulumi.Input[bool]] = None,
                 materials: Optional[pulumi.Input[bool]] = None):
        """
        Indicates that the builder claims certain fields in this message to be complete.
        :param pulumi.Input[bool] arguments: If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        :param pulumi.Input[bool] environment: If true, the builder claims that recipe.environment is claimed to be complete.
        :param pulumi.Input[bool] materials: If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if materials is not None:
            pulumi.set(__self__, "materials", materials)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that recipe.environment is claimed to be complete.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def materials(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        return pulumi.get(self, "materials")

    @materials.setter
    def materials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "materials", value)


@pulumi.input_type
class SlsaMetadataArgs:
    def __init__(__self__, *,
                 build_finished_on: Optional[pulumi.Input[str]] = None,
                 build_invocation_id: Optional[pulumi.Input[str]] = None,
                 build_started_on: Optional[pulumi.Input[str]] = None,
                 completeness: Optional[pulumi.Input['SlsaCompletenessArgs']] = None,
                 reproducible: Optional[pulumi.Input[bool]] = None):
        """
        Other properties of the build.
        :param pulumi.Input[str] build_finished_on: The timestamp of when the build completed.
        :param pulumi.Input[str] build_invocation_id: Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        :param pulumi.Input[str] build_started_on: The timestamp of when the build started.
        :param pulumi.Input['SlsaCompletenessArgs'] completeness: Indicates that the builder claims certain fields in this message to be complete.
        :param pulumi.Input[bool] reproducible: If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        if build_finished_on is not None:
            pulumi.set(__self__, "build_finished_on", build_finished_on)
        if build_invocation_id is not None:
            pulumi.set(__self__, "build_invocation_id", build_invocation_id)
        if build_started_on is not None:
            pulumi.set(__self__, "build_started_on", build_started_on)
        if completeness is not None:
            pulumi.set(__self__, "completeness", completeness)
        if reproducible is not None:
            pulumi.set(__self__, "reproducible", reproducible)

    @property
    @pulumi.getter(name="buildFinishedOn")
    def build_finished_on(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the build completed.
        """
        return pulumi.get(self, "build_finished_on")

    @build_finished_on.setter
    def build_finished_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_finished_on", value)

    @property
    @pulumi.getter(name="buildInvocationId")
    def build_invocation_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        """
        return pulumi.get(self, "build_invocation_id")

    @build_invocation_id.setter
    def build_invocation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_invocation_id", value)

    @property
    @pulumi.getter(name="buildStartedOn")
    def build_started_on(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the build started.
        """
        return pulumi.get(self, "build_started_on")

    @build_started_on.setter
    def build_started_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_started_on", value)

    @property
    @pulumi.getter
    def completeness(self) -> Optional[pulumi.Input['SlsaCompletenessArgs']]:
        """
        Indicates that the builder claims certain fields in this message to be complete.
        """
        return pulumi.get(self, "completeness")

    @completeness.setter
    def completeness(self, value: Optional[pulumi.Input['SlsaCompletenessArgs']]):
        pulumi.set(self, "completeness", value)

    @property
    @pulumi.getter
    def reproducible(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        return pulumi.get(self, "reproducible")

    @reproducible.setter
    def reproducible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reproducible", value)


@pulumi.input_type
class SlsaProvenanceArgs:
    def __init__(__self__, *,
                 builder: Optional[pulumi.Input['SlsaBuilderArgs']] = None,
                 materials: Optional[pulumi.Input[Sequence[pulumi.Input['MaterialArgs']]]] = None,
                 metadata: Optional[pulumi.Input['SlsaMetadataArgs']] = None,
                 recipe: Optional[pulumi.Input['SlsaRecipeArgs']] = None):
        """
        SlsaProvenance is the slsa provenance as defined by the slsa spec.
        :param pulumi.Input['SlsaBuilderArgs'] builder: builder is the builder of this provenance
        :param pulumi.Input[Sequence[pulumi.Input['MaterialArgs']]] materials: The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        :param pulumi.Input['SlsaMetadataArgs'] metadata: metadata is the metadata of the provenance
        :param pulumi.Input['SlsaRecipeArgs'] recipe: Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible).
        """
        if builder is not None:
            pulumi.set(__self__, "builder", builder)
        if materials is not None:
            pulumi.set(__self__, "materials", materials)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if recipe is not None:
            pulumi.set(__self__, "recipe", recipe)

    @property
    @pulumi.getter
    def builder(self) -> Optional[pulumi.Input['SlsaBuilderArgs']]:
        """
        builder is the builder of this provenance
        """
        return pulumi.get(self, "builder")

    @builder.setter
    def builder(self, value: Optional[pulumi.Input['SlsaBuilderArgs']]):
        pulumi.set(self, "builder", value)

    @property
    @pulumi.getter
    def materials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MaterialArgs']]]]:
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        """
        return pulumi.get(self, "materials")

    @materials.setter
    def materials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MaterialArgs']]]]):
        pulumi.set(self, "materials", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SlsaMetadataArgs']]:
        """
        metadata is the metadata of the provenance
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SlsaMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def recipe(self) -> Optional[pulumi.Input['SlsaRecipeArgs']]:
        """
        Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible).
        """
        return pulumi.get(self, "recipe")

    @recipe.setter
    def recipe(self, value: Optional[pulumi.Input['SlsaRecipeArgs']]):
        pulumi.set(self, "recipe", value)


@pulumi.input_type
class SlsaRecipeArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 defined_in_material: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] arguments: Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Depending on the recipe Type, the structure may be different.
        :param pulumi.Input[str] defined_in_material: Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        :param pulumi.Input[str] entry_point: String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment: Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Depending on the recipe Type, the structure may be different.
        :param pulumi.Input[str] type: URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defined_in_material is not None:
            pulumi.set(__self__, "defined_in_material", defined_in_material)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Depending on the recipe Type, the structure may be different.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="definedInMaterial")
    def defined_in_material(self) -> Optional[pulumi.Input[str]]:
        """
        Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        """
        return pulumi.get(self, "defined_in_material")

    @defined_in_material.setter
    def defined_in_material(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "defined_in_material", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[str]]:
        """
        String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Depending on the recipe Type, the structure may be different.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SourceArgs:
    def __init__(__self__, *,
                 additional_contexts: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs']]]] = None,
                 artifact_storage_source: Optional[pulumi.Input['StorageSourceArgs']] = None,
                 context: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs']] = None,
                 file_hashes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 repo_source: Optional[pulumi.Input['RepoSourceArgs']] = None,
                 storage_source: Optional[pulumi.Input['StorageSourceArgs']] = None):
        """
        Source describes the location of the source used for the build.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs']]] additional_contexts: If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        :param pulumi.Input['StorageSourceArgs'] artifact_storage_source: If provided, the input binary artifacts for the build came from this location.
        :param pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs'] context: If provided, the source code used for the build came from this location.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] file_hashes: Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        :param pulumi.Input['RepoSourceArgs'] repo_source: If provided, get source from this location in a Cloud Repo.
        :param pulumi.Input['StorageSourceArgs'] storage_source: If provided, get the source from this location in in Google Cloud Storage.
        """
        if additional_contexts is not None:
            pulumi.set(__self__, "additional_contexts", additional_contexts)
        if artifact_storage_source is not None:
            pulumi.set(__self__, "artifact_storage_source", artifact_storage_source)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if file_hashes is not None:
            pulumi.set(__self__, "file_hashes", file_hashes)
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="additionalContexts")
    def additional_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs']]]]:
        """
        If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        """
        return pulumi.get(self, "additional_contexts")

    @additional_contexts.setter
    def additional_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs']]]]):
        pulumi.set(self, "additional_contexts", value)

    @property
    @pulumi.getter(name="artifactStorageSource")
    def artifact_storage_source(self) -> Optional[pulumi.Input['StorageSourceArgs']]:
        """
        If provided, the input binary artifacts for the build came from this location.
        """
        return pulumi.get(self, "artifact_storage_source")

    @artifact_storage_source.setter
    def artifact_storage_source(self, value: Optional[pulumi.Input['StorageSourceArgs']]):
        pulumi.set(self, "artifact_storage_source", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs']]:
        """
        If provided, the source code used for the build came from this location.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input['GoogleDevtoolsContaineranalysisV1alpha1SourceContextArgs']]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        return pulumi.get(self, "file_hashes")

    @file_hashes.setter
    def file_hashes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "file_hashes", value)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional[pulumi.Input['RepoSourceArgs']]:
        """
        If provided, get source from this location in a Cloud Repo.
        """
        return pulumi.get(self, "repo_source")

    @repo_source.setter
    def repo_source(self, value: Optional[pulumi.Input['RepoSourceArgs']]):
        pulumi.set(self, "repo_source", value)

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional[pulumi.Input['StorageSourceArgs']]:
        """
        If provided, get the source from this location in in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_source")

    @storage_source.setter
    def storage_source(self, value: Optional[pulumi.Input['StorageSourceArgs']]):
        pulumi.set(self, "storage_source", value)


@pulumi.input_type
class StatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param pulumi.Input[int] code: The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param pulumi.Input[str] message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class StorageSourceArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        StorageSource describes the location of the source in an archive file in Google Cloud Storage.
        :param pulumi.Input[str] bucket: Google Cloud Storage bucket containing source (see [Bucket Name Requirements] (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param pulumi.Input[str] generation: Google Cloud Storage generation for the object.
        :param pulumi.Input[str] object: Google Cloud Storage object containing source.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage bucket containing source (see [Bucket Name Requirements] (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage generation for the object.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage object containing source.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class SubjectArgs:
    def __init__(__self__, *,
                 digest: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Subject refers to the subject of the intoto statement
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] digest: "": "" Algorithms can be e.g. sha256, sha512 See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
        :param pulumi.Input[str] name: name is the name of the Subject used here
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        "": "" Algorithms can be e.g. sha256, sha512 See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "digest", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the name of the Subject used here
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class UpgradeDistributionArgs:
    def __init__(__self__, *,
                 classification: Optional[pulumi.Input[str]] = None,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 cve: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 severity: Optional[pulumi.Input[str]] = None):
        """
        The Upgrade Distribution represents metadata about the Upgrade for each operating system (CPE). Some distributions have additional metadata around updates, classifying them into various categories and severities.
        :param pulumi.Input[str] classification: The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed.
        :param pulumi.Input[str] cpe_uri: Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cve: The cve that would be resolved by this upgrade.
        :param pulumi.Input[str] severity: The severity as specified by the upstream operating system.
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if cve is not None:
            pulumi.set(__self__, "cve", cve)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def classification(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed.
        """
        return pulumi.get(self, "classification")

    @classification.setter
    def classification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "classification", value)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def cve(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The cve that would be resolved by this upgrade.
        """
        return pulumi.get(self, "cve")

    @cve.setter
    def cve(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cve", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        The severity as specified by the upstream operating system.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)


@pulumi.input_type
class UpgradeNoteArgs:
    def __init__(__self__, *,
                 distributions: Optional[pulumi.Input[Sequence[pulumi.Input['UpgradeDistributionArgs']]]] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input['VersionArgs']] = None):
        """
        An Upgrade Note represents a potential upgrade of a package to a given version. For each package version combination (i.e. bash 4.0, bash 4.1, bash 4.1.2), there will be a Upgrade Note.
        :param pulumi.Input[Sequence[pulumi.Input['UpgradeDistributionArgs']]] distributions: Metadata about the upgrade for each specific operating system.
        :param pulumi.Input[str] package: Required - The package this Upgrade is for.
        :param pulumi.Input['VersionArgs'] version: Required - The version of the package in machine + human readable form.
        """
        if distributions is not None:
            pulumi.set(__self__, "distributions", distributions)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def distributions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UpgradeDistributionArgs']]]]:
        """
        Metadata about the upgrade for each specific operating system.
        """
        return pulumi.get(self, "distributions")

    @distributions.setter
    def distributions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UpgradeDistributionArgs']]]]):
        pulumi.set(self, "distributions", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        """
        Required - The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        Required - The version of the package in machine + human readable form.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class UpgradeOccurrenceArgs:
    def __init__(__self__, *,
                 distribution: Optional[pulumi.Input['UpgradeDistributionArgs']] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 parsed_version: Optional[pulumi.Input['VersionArgs']] = None):
        """
        An Upgrade Occurrence represents that a specific resource_url could install a specific upgrade. This presence is supplied via local sources (i.e. it is present in the mirror and the running system has noticed its availability).
        :param pulumi.Input['UpgradeDistributionArgs'] distribution: Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        :param pulumi.Input[str] package: Required - The package this Upgrade is for.
        :param pulumi.Input['VersionArgs'] parsed_version: Required - The version of the package in a machine + human readable form.
        """
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if parsed_version is not None:
            pulumi.set(__self__, "parsed_version", parsed_version)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input['UpgradeDistributionArgs']]:
        """
        Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input['UpgradeDistributionArgs']]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        """
        Required - The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter(name="parsedVersion")
    def parsed_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        Required - The version of the package in a machine + human readable form.
        """
        return pulumi.get(self, "parsed_version")

    @parsed_version.setter
    def parsed_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "parsed_version", value)


@pulumi.input_type
class VersionArgs:
    def __init__(__self__, *,
                 epoch: Optional[pulumi.Input[int]] = None,
                 inclusive: Optional[pulumi.Input[bool]] = None,
                 kind: Optional[pulumi.Input['VersionKind']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[str]] = None):
        """
        Version contains structured information about the version of the package. For a discussion of this in Debian/Ubuntu: http://serverfault.com/questions/604541/debian-packages-version-convention For a discussion of this in Redhat/Fedora/Centos: http://blog.jasonantman.com/2014/07/how-yum-and-rpm-compare-versions/
        :param pulumi.Input[int] epoch: Used to correct mistakes in the version numbering scheme.
        :param pulumi.Input[bool] inclusive: Whether this version is vulnerable, when defining the version bounds. For example, if the minimum version is 2.0, inclusive=true would say 2.0 is vulnerable, while inclusive=false would say it's not
        :param pulumi.Input['VersionKind'] kind: Distinguish between sentinel MIN/MAX versions and normal versions. If kind is not NORMAL, then the other fields are ignored.
        :param pulumi.Input[str] name: The main part of the version name.
        :param pulumi.Input[str] revision: The iteration of the package build from the above version.
        """
        if epoch is not None:
            pulumi.set(__self__, "epoch", epoch)
        if inclusive is not None:
            pulumi.set(__self__, "inclusive", inclusive)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def epoch(self) -> Optional[pulumi.Input[int]]:
        """
        Used to correct mistakes in the version numbering scheme.
        """
        return pulumi.get(self, "epoch")

    @epoch.setter
    def epoch(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "epoch", value)

    @property
    @pulumi.getter
    def inclusive(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this version is vulnerable, when defining the version bounds. For example, if the minimum version is 2.0, inclusive=true would say 2.0 is vulnerable, while inclusive=false would say it's not
        """
        return pulumi.get(self, "inclusive")

    @inclusive.setter
    def inclusive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inclusive", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input['VersionKind']]:
        """
        Distinguish between sentinel MIN/MAX versions and normal versions. If kind is not NORMAL, then the other fields are ignored.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input['VersionKind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The main part of the version name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        The iteration of the package build from the above version.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)


@pulumi.input_type
class VulnerabilityDetailsArgs:
    def __init__(__self__, *,
                 cvss_v3: Optional[pulumi.Input['CVSSArgs']] = None,
                 effective_severity: Optional[pulumi.Input['VulnerabilityDetailsEffectiveSeverity']] = None,
                 package_issue: Optional[pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Used by Occurrence to point to where the vulnerability exists and how to fix it.
        :param pulumi.Input['CVSSArgs'] cvss_v3: The CVSS v3 score of this vulnerability.
        :param pulumi.Input['VulnerabilityDetailsEffectiveSeverity'] effective_severity: The distro assigned severity for this vulnerability when that is available and note provider assigned severity when distro has not yet assigned a severity for this vulnerability. When there are multiple package issues for this vulnerability, they can have different effective severities because some might come from the distro and some might come from installed language packs (e.g. Maven JARs or Go binaries). For this reason, it is advised to use the effective severity on the PackageIssue level, as this field may eventually be deprecated. In the case where multiple PackageIssues have different effective severities, the one set here will be the highest severity of any of the PackageIssues.
        :param pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]] package_issue: The set of affected locations and their fixes (if available) within the associated resource.
        :param pulumi.Input[str] type: The type of package; whether native or non native(ruby gems, node.js packages etc). This may be deprecated in the future because we can have multiple PackageIssues with different package types.
        """
        if cvss_v3 is not None:
            pulumi.set(__self__, "cvss_v3", cvss_v3)
        if effective_severity is not None:
            pulumi.set(__self__, "effective_severity", effective_severity)
        if package_issue is not None:
            pulumi.set(__self__, "package_issue", package_issue)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cvssV3")
    def cvss_v3(self) -> Optional[pulumi.Input['CVSSArgs']]:
        """
        The CVSS v3 score of this vulnerability.
        """
        return pulumi.get(self, "cvss_v3")

    @cvss_v3.setter
    def cvss_v3(self, value: Optional[pulumi.Input['CVSSArgs']]):
        pulumi.set(self, "cvss_v3", value)

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> Optional[pulumi.Input['VulnerabilityDetailsEffectiveSeverity']]:
        """
        The distro assigned severity for this vulnerability when that is available and note provider assigned severity when distro has not yet assigned a severity for this vulnerability. When there are multiple package issues for this vulnerability, they can have different effective severities because some might come from the distro and some might come from installed language packs (e.g. Maven JARs or Go binaries). For this reason, it is advised to use the effective severity on the PackageIssue level, as this field may eventually be deprecated. In the case where multiple PackageIssues have different effective severities, the one set here will be the highest severity of any of the PackageIssues.
        """
        return pulumi.get(self, "effective_severity")

    @effective_severity.setter
    def effective_severity(self, value: Optional[pulumi.Input['VulnerabilityDetailsEffectiveSeverity']]):
        pulumi.set(self, "effective_severity", value)

    @property
    @pulumi.getter(name="packageIssue")
    def package_issue(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]]]:
        """
        The set of affected locations and their fixes (if available) within the associated resource.
        """
        return pulumi.get(self, "package_issue")

    @package_issue.setter
    def package_issue(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]]]):
        pulumi.set(self, "package_issue", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc). This may be deprecated in the future because we can have multiple PackageIssues with different package types.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class VulnerabilityLocationArgs:
    def __init__(__self__, *,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input['VersionArgs']] = None):
        """
        The location of the vulnerability
        :param pulumi.Input[str] cpe_uri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        :param pulumi.Input[str] package: The package being described.
        :param pulumi.Input['VersionArgs'] version: The version of the package being described. This field can be used as a filter in list requests.
        """
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        """
        The package being described.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The version of the package being described. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class VulnerabilityTypeArgs:
    def __init__(__self__, *,
                 cvss_score: Optional[pulumi.Input[float]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['DetailArgs']]]] = None,
                 severity: Optional[pulumi.Input['VulnerabilityTypeSeverity']] = None):
        """
        VulnerabilityType provides metadata about a security vulnerability.
        :param pulumi.Input[float] cvss_score: The CVSS score for this Vulnerability.
        :param pulumi.Input[Sequence[pulumi.Input['DetailArgs']]] details: All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        :param pulumi.Input['VulnerabilityTypeSeverity'] severity: Note provider assigned impact of the vulnerability
        """
        if cvss_score is not None:
            pulumi.set(__self__, "cvss_score", cvss_score)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> Optional[pulumi.Input[float]]:
        """
        The CVSS score for this Vulnerability.
        """
        return pulumi.get(self, "cvss_score")

    @cvss_score.setter
    def cvss_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cvss_score", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetailArgs']]]]:
        """
        All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input['VulnerabilityTypeSeverity']]:
        """
        Note provider assigned impact of the vulnerability
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input['VulnerabilityTypeSeverity']]):
        pulumi.set(self, "severity", value)


