# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AcceleratorConfigResponse',
    'AccessConfigResponse',
    'AdvancedMachineFeaturesResponse',
    'AliasIpRangeResponse',
    'AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskResponse',
    'AllocationSpecificSKUAllocationReservedInstancePropertiesResponse',
    'AllocationSpecificSKUReservationResponse',
    'AttachedDiskInitializeParamsResponse',
    'AttachedDiskResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'AuthorizationLoggingOptionsResponse',
    'AutoscalerStatusDetailsResponse',
    'AutoscalingPolicyCpuUtilizationResponse',
    'AutoscalingPolicyCustomMetricUtilizationResponse',
    'AutoscalingPolicyLoadBalancingUtilizationResponse',
    'AutoscalingPolicyResponse',
    'AutoscalingPolicyScaleDownControlResponse',
    'AutoscalingPolicyScaleInControlResponse',
    'BackendBucketCdnPolicyBypassCacheOnRequestHeaderResponse',
    'BackendBucketCdnPolicyCacheKeyPolicyResponse',
    'BackendBucketCdnPolicyNegativeCachingPolicyResponse',
    'BackendBucketCdnPolicyResponse',
    'BackendResponse',
    'BackendServiceCdnPolicyBypassCacheOnRequestHeaderResponse',
    'BackendServiceCdnPolicyNegativeCachingPolicyResponse',
    'BackendServiceCdnPolicyResponse',
    'BackendServiceConnectionTrackingPolicyResponse',
    'BackendServiceFailoverPolicyResponse',
    'BackendServiceIAPResponse',
    'BackendServiceLogConfigResponse',
    'BindingResponse',
    'CacheKeyPolicyResponse',
    'CircuitBreakersResponse',
    'ConditionResponse',
    'ConfidentialInstanceConfigResponse',
    'ConnectionDrainingResponse',
    'ConsistentHashLoadBalancerSettingsHttpCookieResponse',
    'ConsistentHashLoadBalancerSettingsResponse',
    'CorsPolicyResponse',
    'CustomerEncryptionKeyResponse',
    'DeprecationStatusResponse',
    'DiskInstantiationConfigResponse',
    'DisplayDeviceResponse',
    'DistributionPolicyResponse',
    'DistributionPolicyZoneConfigurationResponse',
    'DurationResponse',
    'ExprResponse',
    'ExternalVpnGatewayInterfaceResponse',
    'FileContentBufferResponse',
    'FirewallAllowedItemResponse',
    'FirewallDeniedItemResponse',
    'FirewallLogConfigResponse',
    'FirewallPolicyAssociationResponse',
    'FirewallPolicyRuleMatcherLayer4ConfigResponse',
    'FirewallPolicyRuleMatcherResponse',
    'FirewallPolicyRuleResponse',
    'FixedOrPercentResponse',
    'ForwardingRuleServiceDirectoryRegistrationResponse',
    'GRPCHealthCheckResponse',
    'GuestOsFeatureResponse',
    'HTTP2HealthCheckResponse',
    'HTTPHealthCheckResponse',
    'HTTPSHealthCheckResponse',
    'HealthCheckLogConfigResponse',
    'HostRuleResponse',
    'HttpFaultAbortResponse',
    'HttpFaultDelayResponse',
    'HttpFaultInjectionResponse',
    'HttpFilterConfigResponse',
    'HttpHeaderActionResponse',
    'HttpHeaderMatchResponse',
    'HttpHeaderOptionResponse',
    'HttpQueryParameterMatchResponse',
    'HttpRedirectActionResponse',
    'HttpRetryPolicyResponse',
    'HttpRouteActionResponse',
    'HttpRouteRuleMatchResponse',
    'HttpRouteRuleResponse',
    'ImageRawDiskResponse',
    'InitialStateConfigResponse',
    'InstanceGroupManagerActionsSummaryResponse',
    'InstanceGroupManagerAutoHealingPolicyResponse',
    'InstanceGroupManagerStatusResponse',
    'InstanceGroupManagerStatusStatefulPerInstanceConfigsResponse',
    'InstanceGroupManagerStatusStatefulResponse',
    'InstanceGroupManagerStatusVersionTargetResponse',
    'InstanceGroupManagerUpdatePolicyResponse',
    'InstanceGroupManagerVersionResponse',
    'InstanceParamsResponse',
    'InstancePropertiesResponse',
    'Int64RangeMatchResponse',
    'InterconnectAttachmentPartnerMetadataResponse',
    'InterconnectAttachmentPrivateInfoResponse',
    'InterconnectCircuitInfoResponse',
    'InterconnectOutageNotificationResponse',
    'LicenseResourceCommitmentResponse',
    'LicenseResourceRequirementsResponse',
    'LocalDiskResponse',
    'LogConfigCloudAuditOptionsResponse',
    'LogConfigCounterOptionsCustomFieldResponse',
    'LogConfigCounterOptionsResponse',
    'LogConfigDataAccessOptionsResponse',
    'LogConfigResponse',
    'MetadataFilterLabelMatchResponse',
    'MetadataFilterResponse',
    'MetadataItemsItemResponse',
    'MetadataResponse',
    'NamedPortResponse',
    'NetworkEndpointGroupAppEngineResponse',
    'NetworkEndpointGroupCloudFunctionResponse',
    'NetworkEndpointGroupCloudRunResponse',
    'NetworkEndpointGroupServerlessDeploymentResponse',
    'NetworkInterfaceResponse',
    'NetworkPeeringResponse',
    'NetworkPerformanceConfigResponse',
    'NetworkRoutingConfigResponse',
    'NodeGroupAutoscalingPolicyResponse',
    'NodeGroupMaintenanceWindowResponse',
    'NodeTemplateNodeTypeFlexibilityResponse',
    'NotificationEndpointGrpcSettingsResponse',
    'OutlierDetectionResponse',
    'PacketMirroringFilterResponse',
    'PacketMirroringForwardingRuleInfoResponse',
    'PacketMirroringMirroredResourceInfoInstanceInfoResponse',
    'PacketMirroringMirroredResourceInfoResponse',
    'PacketMirroringMirroredResourceInfoSubnetInfoResponse',
    'PacketMirroringNetworkInfoResponse',
    'PathMatcherResponse',
    'PathRuleResponse',
    'PublicAdvertisedPrefixPublicDelegatedPrefixResponse',
    'PublicDelegatedPrefixPublicDelegatedSubPrefixResponse',
    'RequestMirrorPolicyResponse',
    'ReservationAffinityResponse',
    'ReservationResponse',
    'ResourceCommitmentResponse',
    'ResourcePolicyDailyCycleResponse',
    'ResourcePolicyGroupPlacementPolicyResponse',
    'ResourcePolicyHourlyCycleResponse',
    'ResourcePolicyInstanceSchedulePolicyResponse',
    'ResourcePolicyInstanceSchedulePolicyScheduleResponse',
    'ResourcePolicyResourceStatusInstanceSchedulePolicyStatusResponse',
    'ResourcePolicyResourceStatusResponse',
    'ResourcePolicySnapshotSchedulePolicyResponse',
    'ResourcePolicySnapshotSchedulePolicyRetentionPolicyResponse',
    'ResourcePolicySnapshotSchedulePolicyScheduleResponse',
    'ResourcePolicySnapshotSchedulePolicySnapshotPropertiesResponse',
    'ResourcePolicyWeeklyCycleDayOfWeekResponse',
    'ResourcePolicyWeeklyCycleResponse',
    'RolloutPolicyResponse',
    'RouteAsPathResponse',
    'RouteWarningsItemDataItemResponse',
    'RouteWarningsItemResponse',
    'RouterAdvertisedIpRangeResponse',
    'RouterBgpPeerBfdResponse',
    'RouterBgpPeerResponse',
    'RouterBgpResponse',
    'RouterInterfaceResponse',
    'RouterNatLogConfigResponse',
    'RouterNatResponse',
    'RouterNatRuleActionResponse',
    'RouterNatRuleResponse',
    'RouterNatSubnetworkToNatResponse',
    'RuleResponse',
    'SSLHealthCheckResponse',
    'SavedAttachedDiskResponse',
    'SavedDiskResponse',
    'SchedulingNodeAffinityResponse',
    'SchedulingResponse',
    'SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigResponse',
    'SecurityPolicyAdaptiveProtectionConfigResponse',
    'SecurityPolicyAdvancedOptionsConfigResponse',
    'SecurityPolicyAssociationResponse',
    'SecurityPolicyRecaptchaOptionsConfigResponse',
    'SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionResponse',
    'SecurityPolicyRuleHttpHeaderActionResponse',
    'SecurityPolicyRuleMatcherConfigLayer4ConfigResponse',
    'SecurityPolicyRuleMatcherConfigResponse',
    'SecurityPolicyRuleMatcherResponse',
    'SecurityPolicyRuleRateLimitOptionsResponse',
    'SecurityPolicyRuleRateLimitOptionsThresholdResponse',
    'SecurityPolicyRuleRedirectOptionsResponse',
    'SecurityPolicyRuleResponse',
    'SecuritySettingsResponse',
    'ServerBindingResponse',
    'ServiceAccountResponse',
    'ServiceAttachmentConnectedEndpointResponse',
    'ServiceAttachmentConsumerProjectLimitResponse',
    'ShareSettingsResponse',
    'ShieldedInstanceConfigResponse',
    'ShieldedInstanceIntegrityPolicyResponse',
    'ShieldedVmConfigResponse',
    'ShieldedVmIntegrityPolicyResponse',
    'SourceDiskEncryptionKeyResponse',
    'SourceInstanceParamsResponse',
    'SourceInstancePropertiesResponse',
    'SslCertificateManagedSslCertificateResponse',
    'SslCertificateSelfManagedSslCertificateResponse',
    'SslPolicyWarningsItemDataItemResponse',
    'SslPolicyWarningsItemResponse',
    'StatefulPolicyPreservedStateResponse',
    'StatefulPolicyResponse',
    'SubnetworkLogConfigResponse',
    'SubnetworkSecondaryRangeResponse',
    'SubsettingResponse',
    'TCPHealthCheckResponse',
    'TagsResponse',
    'Uint128Response',
    'UrlMapTestHeaderResponse',
    'UrlMapTestResponse',
    'UrlRewriteResponse',
    'VpnGatewayVpnGatewayInterfaceResponse',
    'WeightedBackendServiceResponse',
]

@pulumi.output_type
class AcceleratorConfigResponse(dict):
    """
    A specification of the type and number of accelerator cards attached to the instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AcceleratorConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AcceleratorConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AcceleratorConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: int,
                 accelerator_type: str):
        """
        A specification of the type and number of accelerator cards attached to the instance.
        :param int accelerator_count: The number of the guest accelerator cards exposed to this instance.
        :param str accelerator_type: Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> int:
        """
        The number of the guest accelerator cards exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> str:
        """
        Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
        """
        return pulumi.get(self, "accelerator_type")


@pulumi.output_type
class AccessConfigResponse(dict):
    """
    An access configuration attached to an instance's network interface. Only one access config per instance is supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalIpv6":
            suggest = "external_ipv6"
        elif key == "externalIpv6PrefixLength":
            suggest = "external_ipv6_prefix_length"
        elif key == "natIP":
            suggest = "nat_ip"
        elif key == "networkTier":
            suggest = "network_tier"
        elif key == "publicPtrDomainName":
            suggest = "public_ptr_domain_name"
        elif key == "setPublicPtr":
            suggest = "set_public_ptr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_ipv6: str,
                 external_ipv6_prefix_length: int,
                 kind: str,
                 name: str,
                 nat_ip: str,
                 network_tier: str,
                 public_ptr_domain_name: str,
                 set_public_ptr: bool,
                 type: str):
        """
        An access configuration attached to an instance's network interface. Only one access config per instance is supported.
        :param str external_ipv6: The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. The field is output only, an IPv6 address from a subnetwork associated with the instance will be allocated dynamically.
        :param int external_ipv6_prefix_length: The prefix length of the external IPv6 range.
        :param str kind: Type of the resource. Always compute#accessConfig for access configs.
        :param str name: The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.
        :param str nat_ip: An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
        :param str network_tier: This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
        :param str public_ptr_domain_name: The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be createc for first IP in associated external IPv6 range.
        :param bool set_public_ptr: Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
        :param str type: The type of configuration. The default and only option is ONE_TO_ONE_NAT.
        """
        pulumi.set(__self__, "external_ipv6", external_ipv6)
        pulumi.set(__self__, "external_ipv6_prefix_length", external_ipv6_prefix_length)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_ip", nat_ip)
        pulumi.set(__self__, "network_tier", network_tier)
        pulumi.set(__self__, "public_ptr_domain_name", public_ptr_domain_name)
        pulumi.set(__self__, "set_public_ptr", set_public_ptr)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="externalIpv6")
    def external_ipv6(self) -> str:
        """
        The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. The field is output only, an IPv6 address from a subnetwork associated with the instance will be allocated dynamically.
        """
        return pulumi.get(self, "external_ipv6")

    @property
    @pulumi.getter(name="externalIpv6PrefixLength")
    def external_ipv6_prefix_length(self) -> int:
        """
        The prefix length of the external IPv6 range.
        """
        return pulumi.get(self, "external_ipv6_prefix_length")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#accessConfig for access configs.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natIP")
    def nat_ip(self) -> str:
        """
        An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
        """
        return pulumi.get(self, "nat_ip")

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> str:
        """
        This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
        """
        return pulumi.get(self, "network_tier")

    @property
    @pulumi.getter(name="publicPtrDomainName")
    def public_ptr_domain_name(self) -> str:
        """
        The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be createc for first IP in associated external IPv6 range.
        """
        return pulumi.get(self, "public_ptr_domain_name")

    @property
    @pulumi.getter(name="setPublicPtr")
    def set_public_ptr(self) -> bool:
        """
        Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
        """
        return pulumi.get(self, "set_public_ptr")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of configuration. The default and only option is ONE_TO_ONE_NAT.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AdvancedMachineFeaturesResponse(dict):
    """
    Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableNestedVirtualization":
            suggest = "enable_nested_virtualization"
        elif key == "enableUefiNetworking":
            suggest = "enable_uefi_networking"
        elif key == "threadsPerCore":
            suggest = "threads_per_core"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdvancedMachineFeaturesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdvancedMachineFeaturesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdvancedMachineFeaturesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_nested_virtualization: bool,
                 enable_uefi_networking: bool,
                 threads_per_core: int):
        """
        Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
        :param bool enable_nested_virtualization: Whether to enable nested virtualization or not (default is false).
        :param bool enable_uefi_networking: Whether to enable UEFI networking for instance creation.
        :param int threads_per_core: The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
        """
        pulumi.set(__self__, "enable_nested_virtualization", enable_nested_virtualization)
        pulumi.set(__self__, "enable_uefi_networking", enable_uefi_networking)
        pulumi.set(__self__, "threads_per_core", threads_per_core)

    @property
    @pulumi.getter(name="enableNestedVirtualization")
    def enable_nested_virtualization(self) -> bool:
        """
        Whether to enable nested virtualization or not (default is false).
        """
        return pulumi.get(self, "enable_nested_virtualization")

    @property
    @pulumi.getter(name="enableUefiNetworking")
    def enable_uefi_networking(self) -> bool:
        """
        Whether to enable UEFI networking for instance creation.
        """
        return pulumi.get(self, "enable_uefi_networking")

    @property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> int:
        """
        The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class AliasIpRangeResponse(dict):
    """
    An alias IP range attached to an instance's network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipCidrRange":
            suggest = "ip_cidr_range"
        elif key == "subnetworkRangeName":
            suggest = "subnetwork_range_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasIpRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasIpRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasIpRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_cidr_range: str,
                 subnetwork_range_name: str):
        """
        An alias IP range attached to an instance's network interface.
        :param str ip_cidr_range: The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
        :param str subnetwork_range_name: The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
        """
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        pulumi.set(__self__, "subnetwork_range_name", subnetwork_range_name)

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> str:
        """
        The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
        """
        return pulumi.get(self, "ip_cidr_range")

    @property
    @pulumi.getter(name="subnetworkRangeName")
    def subnetwork_range_name(self) -> str:
        """
        The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
        """
        return pulumi.get(self, "subnetwork_range_name")


@pulumi.output_type
class AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: str,
                 interface: str):
        """
        :param str disk_size_gb: Specifies the size of the disk in base-2 GB.
        :param str interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "interface", interface)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> str:
        """
        Specifies the size of the disk in base-2 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter
    def interface(self) -> str:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
        """
        return pulumi.get(self, "interface")


@pulumi.output_type
class AllocationSpecificSKUAllocationReservedInstancePropertiesResponse(dict):
    """
    Properties of the SKU instances being reserved. Next ID: 9
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "guestAccelerators":
            suggest = "guest_accelerators"
        elif key == "localSsds":
            suggest = "local_ssds"
        elif key == "locationHint":
            suggest = "location_hint"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "maintenanceFreezeDurationHours":
            suggest = "maintenance_freeze_duration_hours"
        elif key == "maintenanceInterval":
            suggest = "maintenance_interval"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationSpecificSKUAllocationReservedInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationSpecificSKUAllocationReservedInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationSpecificSKUAllocationReservedInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 guest_accelerators: Sequence['outputs.AcceleratorConfigResponse'],
                 local_ssds: Sequence['outputs.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskResponse'],
                 location_hint: str,
                 machine_type: str,
                 maintenance_freeze_duration_hours: int,
                 maintenance_interval: str,
                 min_cpu_platform: str):
        """
        Properties of the SKU instances being reserved. Next ID: 9
        :param Sequence['AcceleratorConfigResponse'] guest_accelerators: Specifies accelerator type and count.
        :param Sequence['AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskResponse'] local_ssds: Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
        :param str location_hint: An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
        :param str machine_type: Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
        :param int maintenance_freeze_duration_hours: Specifies the number of hours after reservation creation where instances using the reservation won't be scheduled for maintenance.
        :param str maintenance_interval: For more information about maintenance intervals, see Setting maintenance intervals.
        :param str min_cpu_platform: Minimum cpu platform the reservation.
        """
        pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        pulumi.set(__self__, "local_ssds", local_ssds)
        pulumi.set(__self__, "location_hint", location_hint)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "maintenance_freeze_duration_hours", maintenance_freeze_duration_hours)
        pulumi.set(__self__, "maintenance_interval", maintenance_interval)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Sequence['outputs.AcceleratorConfigResponse']:
        """
        Specifies accelerator type and count.
        """
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter(name="localSsds")
    def local_ssds(self) -> Sequence['outputs.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskResponse']:
        """
        Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
        """
        return pulumi.get(self, "local_ssds")

    @property
    @pulumi.getter(name="locationHint")
    def location_hint(self) -> str:
        """
        An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
        """
        return pulumi.get(self, "location_hint")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="maintenanceFreezeDurationHours")
    def maintenance_freeze_duration_hours(self) -> int:
        """
        Specifies the number of hours after reservation creation where instances using the reservation won't be scheduled for maintenance.
        """
        return pulumi.get(self, "maintenance_freeze_duration_hours")

    @property
    @pulumi.getter(name="maintenanceInterval")
    def maintenance_interval(self) -> str:
        """
        For more information about maintenance intervals, see Setting maintenance intervals.
        """
        return pulumi.get(self, "maintenance_interval")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        Minimum cpu platform the reservation.
        """
        return pulumi.get(self, "min_cpu_platform")


@pulumi.output_type
class AllocationSpecificSKUReservationResponse(dict):
    """
    This reservation type allows to pre allocate specific instance configuration. Next ID: 5
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assuredCount":
            suggest = "assured_count"
        elif key == "inUseCount":
            suggest = "in_use_count"
        elif key == "instanceProperties":
            suggest = "instance_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationSpecificSKUReservationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationSpecificSKUReservationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationSpecificSKUReservationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assured_count: str,
                 count: str,
                 in_use_count: str,
                 instance_properties: 'outputs.AllocationSpecificSKUAllocationReservedInstancePropertiesResponse'):
        """
        This reservation type allows to pre allocate specific instance configuration. Next ID: 5
        :param str assured_count: Indicates how many instances are actually usable currently.
        :param str count: Specifies the number of resources that are allocated.
        :param str in_use_count: Indicates how many instances are in use.
        :param 'AllocationSpecificSKUAllocationReservedInstancePropertiesResponse' instance_properties: The instance properties for the reservation.
        """
        pulumi.set(__self__, "assured_count", assured_count)
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "in_use_count", in_use_count)
        pulumi.set(__self__, "instance_properties", instance_properties)

    @property
    @pulumi.getter(name="assuredCount")
    def assured_count(self) -> str:
        """
        Indicates how many instances are actually usable currently.
        """
        return pulumi.get(self, "assured_count")

    @property
    @pulumi.getter
    def count(self) -> str:
        """
        Specifies the number of resources that are allocated.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="inUseCount")
    def in_use_count(self) -> str:
        """
        Indicates how many instances are in use.
        """
        return pulumi.get(self, "in_use_count")

    @property
    @pulumi.getter(name="instanceProperties")
    def instance_properties(self) -> 'outputs.AllocationSpecificSKUAllocationReservedInstancePropertiesResponse':
        """
        The instance properties for the reservation.
        """
        return pulumi.get(self, "instance_properties")


@pulumi.output_type
class AttachedDiskInitializeParamsResponse(dict):
    """
    [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskName":
            suggest = "disk_name"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "guestOsFeatures":
            suggest = "guest_os_features"
        elif key == "multiWriter":
            suggest = "multi_writer"
        elif key == "onUpdateAction":
            suggest = "on_update_action"
        elif key == "provisionedIops":
            suggest = "provisioned_iops"
        elif key == "resourcePolicies":
            suggest = "resource_policies"
        elif key == "sourceImage":
            suggest = "source_image"
        elif key == "sourceImageEncryptionKey":
            suggest = "source_image_encryption_key"
        elif key == "sourceSnapshot":
            suggest = "source_snapshot"
        elif key == "sourceSnapshotEncryptionKey":
            suggest = "source_snapshot_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttachedDiskInitializeParamsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttachedDiskInitializeParamsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttachedDiskInitializeParamsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 disk_name: str,
                 disk_size_gb: str,
                 disk_type: str,
                 guest_os_features: Sequence['outputs.GuestOsFeatureResponse'],
                 labels: Mapping[str, str],
                 licenses: Sequence[str],
                 multi_writer: bool,
                 on_update_action: str,
                 provisioned_iops: str,
                 resource_policies: Sequence[str],
                 source_image: str,
                 source_image_encryption_key: 'outputs.CustomerEncryptionKeyResponse',
                 source_snapshot: str,
                 source_snapshot_encryption_key: 'outputs.CustomerEncryptionKeyResponse'):
        """
        [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        :param str description: An optional description. Provide this property when creating the disk.
        :param str disk_name: Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
        :param str disk_size_gb: Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
        :param str disk_type: Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you define this field, you can provide either the full or partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType Note that for InstanceTemplate, this is the name of the disk type, not URL.
        :param Sequence['GuestOsFeatureResponse'] guest_os_features: A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options. Guest OS features are applied by merging initializeParams.guestOsFeatures and disks.guestOsFeatures
        :param Mapping[str, str] labels: Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
        :param Sequence[str] licenses: A list of publicly visible licenses. Reserved for Google's use.
        :param bool multi_writer: Indicates whether or not the disk can be read/write attached to more than one instance.
        :param str on_update_action: Specifies which action to take on instance update with this disk. Default is to use the existing disk.
        :param str provisioned_iops: Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        :param Sequence[str] resource_policies: Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
        :param str source_image: The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
        :param 'CustomerEncryptionKeyResponse' source_image_encryption_key: The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
        :param str source_snapshot: The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
        :param 'CustomerEncryptionKeyResponse' source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "guest_os_features", guest_os_features)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "multi_writer", multi_writer)
        pulumi.set(__self__, "on_update_action", on_update_action)
        pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        pulumi.set(__self__, "resource_policies", resource_policies)
        pulumi.set(__self__, "source_image", source_image)
        pulumi.set(__self__, "source_image_encryption_key", source_image_encryption_key)
        pulumi.set(__self__, "source_snapshot", source_snapshot)
        pulumi.set(__self__, "source_snapshot_encryption_key", source_snapshot_encryption_key)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description. Provide this property when creating the disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        """
        Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> str:
        """
        Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you define this field, you can provide either the full or partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType Note that for InstanceTemplate, this is the name of the disk type, not URL.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Sequence['outputs.GuestOsFeatureResponse']:
        """
        A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options. Guest OS features are applied by merging initializeParams.guestOsFeatures and disks.guestOsFeatures
        """
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def licenses(self) -> Sequence[str]:
        """
        A list of publicly visible licenses. Reserved for Google's use.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter(name="multiWriter")
    def multi_writer(self) -> bool:
        """
        Indicates whether or not the disk can be read/write attached to more than one instance.
        """
        return pulumi.get(self, "multi_writer")

    @property
    @pulumi.getter(name="onUpdateAction")
    def on_update_action(self) -> str:
        """
        Specifies which action to take on instance update with this disk. Default is to use the existing disk.
        """
        return pulumi.get(self, "on_update_action")

    @property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> str:
        """
        Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        """
        return pulumi.get(self, "provisioned_iops")

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Sequence[str]:
        """
        Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
        """
        return pulumi.get(self, "resource_policies")

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> str:
        """
        The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
        """
        return pulumi.get(self, "source_image")

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> 'outputs.CustomerEncryptionKeyResponse':
        """
        The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> str:
        """
        The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
        """
        return pulumi.get(self, "source_snapshot")

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> 'outputs.CustomerEncryptionKeyResponse':
        """
        The customer-supplied encryption key of the source snapshot.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")


@pulumi.output_type
class AttachedDiskResponse(dict):
    """
    An instance-attached disk resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDelete":
            suggest = "auto_delete"
        elif key == "deviceName":
            suggest = "device_name"
        elif key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "guestOsFeatures":
            suggest = "guest_os_features"
        elif key == "initializeParams":
            suggest = "initialize_params"
        elif key == "shieldedInstanceInitialState":
            suggest = "shielded_instance_initial_state"
        elif key == "userLicenses":
            suggest = "user_licenses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttachedDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttachedDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttachedDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete: bool,
                 boot: bool,
                 device_name: str,
                 disk_encryption_key: 'outputs.CustomerEncryptionKeyResponse',
                 disk_size_gb: str,
                 guest_os_features: Sequence['outputs.GuestOsFeatureResponse'],
                 index: int,
                 initialize_params: 'outputs.AttachedDiskInitializeParamsResponse',
                 interface: str,
                 kind: str,
                 licenses: Sequence[str],
                 locked: bool,
                 mode: str,
                 shielded_instance_initial_state: 'outputs.InitialStateConfigResponse',
                 source: str,
                 type: str,
                 user_licenses: Sequence[str]):
        """
        An instance-attached disk resource.
        :param bool auto_delete: Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        :param bool boot: Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        :param str device_name: Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
        :param 'CustomerEncryptionKeyResponse' disk_encryption_key: Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
        :param str disk_size_gb: The size of the disk in GB.
        :param Sequence['GuestOsFeatureResponse'] guest_os_features: A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        :param int index: A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
        :param 'AttachedDiskInitializeParamsResponse' initialize_params: [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        :param str interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
        :param str kind: Type of the resource. Always compute#attachedDisk for attached disks.
        :param Sequence[str] licenses: Any valid publicly visible licenses.
        :param bool locked: Whether to indicate the attached disk is locked. The locked disk is not allowed to be detached from the instance, or to be used as the source of the snapshot creation, and the image creation. The instance with at least one locked attached disk is not allow to be used as source of machine image creation, instant snapshot creation, and not allowed to be deleted with --keep-disk parameter set to true for locked disks.
        :param str mode: The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
        :param 'InitialStateConfigResponse' shielded_instance_initial_state: shielded vm initial state stored on disk
        :param str source: Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
        :param str type: Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
        :param Sequence[str] user_licenses: A list of user provided licenses. It represents a list of URLs to the license resource. Unlike regular licenses, user provided licenses can be modified after the disk is created.
        """
        pulumi.set(__self__, "auto_delete", auto_delete)
        pulumi.set(__self__, "boot", boot)
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "guest_os_features", guest_os_features)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "initialize_params", initialize_params)
        pulumi.set(__self__, "interface", interface)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "locked", locked)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "shielded_instance_initial_state", shielded_instance_initial_state)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_licenses", user_licenses)

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> bool:
        """
        Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        """
        return pulumi.get(self, "auto_delete")

    @property
    @pulumi.getter
    def boot(self) -> bool:
        """
        Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        """
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> 'outputs.CustomerEncryptionKeyResponse':
        """
        Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> str:
        """
        The size of the disk in GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Sequence['outputs.GuestOsFeatureResponse']:
        """
        A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        """
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="initializeParams")
    def initialize_params(self) -> 'outputs.AttachedDiskInitializeParamsResponse':
        """
        [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        """
        return pulumi.get(self, "initialize_params")

    @property
    @pulumi.getter
    def interface(self) -> str:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#attachedDisk for attached disks.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def licenses(self) -> Sequence[str]:
        """
        Any valid publicly visible licenses.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter
    def locked(self) -> bool:
        """
        Whether to indicate the attached disk is locked. The locked disk is not allowed to be detached from the instance, or to be used as the source of the snapshot creation, and the image creation. The instance with at least one locked attached disk is not allow to be used as source of machine image creation, instant snapshot creation, and not allowed to be deleted with --keep-disk parameter set to true for locked disks.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="shieldedInstanceInitialState")
    def shielded_instance_initial_state(self) -> 'outputs.InitialStateConfigResponse':
        """
        shielded vm initial state stored on disk
        """
        return pulumi.get(self, "shielded_instance_initial_state")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userLicenses")
    def user_licenses(self) -> Sequence[str]:
        """
        A list of user provided licenses. It represents a list of URLs to the license resource. Unlike regular licenses, user provided licenses can be modified after the disk is created.
        """
        return pulumi.get(self, "user_licenses")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"
        elif key == "exemptedMembers":
            suggest = "exempted_members"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 exempted_members: Sequence[str],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param Sequence[str] exempted_members: This is deprecated and has no effect. Do not use.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "ignoreChildExemptions":
            suggest = "ignore_child_exemptions"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 ignore_child_exemptions: bool,
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param bool ignore_child_exemptions: This is deprecated and has no effect. Do not use.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "ignore_child_exemptions", ignore_child_exemptions)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="ignoreChildExemptions")
    def ignore_child_exemptions(self) -> bool:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "ignore_child_exemptions")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class AuthorizationLoggingOptionsResponse(dict):
    """
    This is deprecated and has no effect. Do not use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionType":
            suggest = "permission_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizationLoggingOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizationLoggingOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizationLoggingOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission_type: str):
        """
        This is deprecated and has no effect. Do not use.
        :param str permission_type: This is deprecated and has no effect. Do not use.
        """
        pulumi.set(__self__, "permission_type", permission_type)

    @property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "permission_type")


@pulumi.output_type
class AutoscalerStatusDetailsResponse(dict):
    def __init__(__self__, *,
                 message: str,
                 type: str):
        """
        :param str message: The status message.
        :param str type: The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The status message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AutoscalingPolicyCpuUtilizationResponse(dict):
    """
    CPU utilization policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predictiveMethod":
            suggest = "predictive_method"
        elif key == "utilizationTarget":
            suggest = "utilization_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicyCpuUtilizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicyCpuUtilizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicyCpuUtilizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predictive_method: str,
                 utilization_target: float):
        """
        CPU utilization policy.
        :param str predictive_method: Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
        :param float utilization_target: The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6. If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization. If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
        """
        pulumi.set(__self__, "predictive_method", predictive_method)
        pulumi.set(__self__, "utilization_target", utilization_target)

    @property
    @pulumi.getter(name="predictiveMethod")
    def predictive_method(self) -> str:
        """
        Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
        """
        return pulumi.get(self, "predictive_method")

    @property
    @pulumi.getter(name="utilizationTarget")
    def utilization_target(self) -> float:
        """
        The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6. If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization. If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
        """
        return pulumi.get(self, "utilization_target")


@pulumi.output_type
class AutoscalingPolicyCustomMetricUtilizationResponse(dict):
    """
    Custom utilization metric policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "singleInstanceAssignment":
            suggest = "single_instance_assignment"
        elif key == "utilizationTarget":
            suggest = "utilization_target"
        elif key == "utilizationTargetType":
            suggest = "utilization_target_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicyCustomMetricUtilizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicyCustomMetricUtilizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicyCustomMetricUtilizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: str,
                 metric: str,
                 single_instance_assignment: float,
                 utilization_target: float,
                 utilization_target_type: str):
        """
        Custom utilization metric policy.
        :param str filter: A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data. For the filter to be valid for autoscaling purposes, the following rules apply: - You can only use the AND operator for joining selectors. - You can only use direct equality comparison operator (=) without any functions for each selector. - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical. - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels. If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a *per-group metric* for the purpose of autoscaling. If not specified, the type defaults to gce_instance. Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.
        :param str metric: The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values. The metric must have a value type of INT64 or DOUBLE.
        :param float single_instance_assignment: If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing. A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances. A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.
        :param float utilization_target: The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric. For example, a good metric to use as a utilization_target is https://www.googleapis.com/compute/v1/instance/network/received_bytes_count. The autoscaler works to keep this value constant for each of the instances.
        :param str utilization_target_type: Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "single_instance_assignment", single_instance_assignment)
        pulumi.set(__self__, "utilization_target", utilization_target)
        pulumi.set(__self__, "utilization_target_type", utilization_target_type)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data. For the filter to be valid for autoscaling purposes, the following rules apply: - You can only use the AND operator for joining selectors. - You can only use direct equality comparison operator (=) without any functions for each selector. - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical. - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels. If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a *per-group metric* for the purpose of autoscaling. If not specified, the type defaults to gce_instance. Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def metric(self) -> str:
        """
        The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values. The metric must have a value type of INT64 or DOUBLE.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter(name="singleInstanceAssignment")
    def single_instance_assignment(self) -> float:
        """
        If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing. A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances. A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.
        """
        return pulumi.get(self, "single_instance_assignment")

    @property
    @pulumi.getter(name="utilizationTarget")
    def utilization_target(self) -> float:
        """
        The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric. For example, a good metric to use as a utilization_target is https://www.googleapis.com/compute/v1/instance/network/received_bytes_count. The autoscaler works to keep this value constant for each of the instances.
        """
        return pulumi.get(self, "utilization_target")

    @property
    @pulumi.getter(name="utilizationTargetType")
    def utilization_target_type(self) -> str:
        """
        Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
        """
        return pulumi.get(self, "utilization_target_type")


@pulumi.output_type
class AutoscalingPolicyLoadBalancingUtilizationResponse(dict):
    """
    Configuration parameters of autoscaling based on load balancing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "utilizationTarget":
            suggest = "utilization_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicyLoadBalancingUtilizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicyLoadBalancingUtilizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicyLoadBalancingUtilizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 utilization_target: float):
        """
        Configuration parameters of autoscaling based on load balancing.
        :param float utilization_target: Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.
        """
        pulumi.set(__self__, "utilization_target", utilization_target)

    @property
    @pulumi.getter(name="utilizationTarget")
    def utilization_target(self) -> float:
        """
        Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.
        """
        return pulumi.get(self, "utilization_target")


@pulumi.output_type
class AutoscalingPolicyResponse(dict):
    """
    Cloud Autoscaler policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolDownPeriodSec":
            suggest = "cool_down_period_sec"
        elif key == "cpuUtilization":
            suggest = "cpu_utilization"
        elif key == "customMetricUtilizations":
            suggest = "custom_metric_utilizations"
        elif key == "loadBalancingUtilization":
            suggest = "load_balancing_utilization"
        elif key == "maxNumReplicas":
            suggest = "max_num_replicas"
        elif key == "minNumReplicas":
            suggest = "min_num_replicas"
        elif key == "scaleDownControl":
            suggest = "scale_down_control"
        elif key == "scaleInControl":
            suggest = "scale_in_control"
        elif key == "scalingSchedules":
            suggest = "scaling_schedules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cool_down_period_sec: int,
                 cpu_utilization: 'outputs.AutoscalingPolicyCpuUtilizationResponse',
                 custom_metric_utilizations: Sequence['outputs.AutoscalingPolicyCustomMetricUtilizationResponse'],
                 load_balancing_utilization: 'outputs.AutoscalingPolicyLoadBalancingUtilizationResponse',
                 max_num_replicas: int,
                 min_num_replicas: int,
                 mode: str,
                 scale_down_control: 'outputs.AutoscalingPolicyScaleDownControlResponse',
                 scale_in_control: 'outputs.AutoscalingPolicyScaleInControlResponse',
                 scaling_schedules: Mapping[str, str]):
        """
        Cloud Autoscaler policy.
        :param int cool_down_period_sec: The number of seconds that the autoscaler waits before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. The default time autoscaler waits is 60 seconds. Virtual machine initialization times might vary because of numerous factors. We recommend that you test how long an instance may take to initialize. To do this, create an instance and time the startup process.
        :param 'AutoscalingPolicyCpuUtilizationResponse' cpu_utilization: Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
        :param Sequence['AutoscalingPolicyCustomMetricUtilizationResponse'] custom_metric_utilizations: Configuration parameters of autoscaling based on a custom metric.
        :param 'AutoscalingPolicyLoadBalancingUtilizationResponse' load_balancing_utilization: Configuration parameters of autoscaling based on load balancer.
        :param int max_num_replicas: The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.
        :param int min_num_replicas: The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.
        :param str mode: Defines operating mode for this policy.
        :param Mapping[str, str] scaling_schedules: Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.
        """
        pulumi.set(__self__, "cool_down_period_sec", cool_down_period_sec)
        pulumi.set(__self__, "cpu_utilization", cpu_utilization)
        pulumi.set(__self__, "custom_metric_utilizations", custom_metric_utilizations)
        pulumi.set(__self__, "load_balancing_utilization", load_balancing_utilization)
        pulumi.set(__self__, "max_num_replicas", max_num_replicas)
        pulumi.set(__self__, "min_num_replicas", min_num_replicas)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "scale_down_control", scale_down_control)
        pulumi.set(__self__, "scale_in_control", scale_in_control)
        pulumi.set(__self__, "scaling_schedules", scaling_schedules)

    @property
    @pulumi.getter(name="coolDownPeriodSec")
    def cool_down_period_sec(self) -> int:
        """
        The number of seconds that the autoscaler waits before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. The default time autoscaler waits is 60 seconds. Virtual machine initialization times might vary because of numerous factors. We recommend that you test how long an instance may take to initialize. To do this, create an instance and time the startup process.
        """
        return pulumi.get(self, "cool_down_period_sec")

    @property
    @pulumi.getter(name="cpuUtilization")
    def cpu_utilization(self) -> 'outputs.AutoscalingPolicyCpuUtilizationResponse':
        """
        Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
        """
        return pulumi.get(self, "cpu_utilization")

    @property
    @pulumi.getter(name="customMetricUtilizations")
    def custom_metric_utilizations(self) -> Sequence['outputs.AutoscalingPolicyCustomMetricUtilizationResponse']:
        """
        Configuration parameters of autoscaling based on a custom metric.
        """
        return pulumi.get(self, "custom_metric_utilizations")

    @property
    @pulumi.getter(name="loadBalancingUtilization")
    def load_balancing_utilization(self) -> 'outputs.AutoscalingPolicyLoadBalancingUtilizationResponse':
        """
        Configuration parameters of autoscaling based on load balancer.
        """
        return pulumi.get(self, "load_balancing_utilization")

    @property
    @pulumi.getter(name="maxNumReplicas")
    def max_num_replicas(self) -> int:
        """
        The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.
        """
        return pulumi.get(self, "max_num_replicas")

    @property
    @pulumi.getter(name="minNumReplicas")
    def min_num_replicas(self) -> int:
        """
        The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.
        """
        return pulumi.get(self, "min_num_replicas")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Defines operating mode for this policy.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="scaleDownControl")
    def scale_down_control(self) -> 'outputs.AutoscalingPolicyScaleDownControlResponse':
        return pulumi.get(self, "scale_down_control")

    @property
    @pulumi.getter(name="scaleInControl")
    def scale_in_control(self) -> 'outputs.AutoscalingPolicyScaleInControlResponse':
        return pulumi.get(self, "scale_in_control")

    @property
    @pulumi.getter(name="scalingSchedules")
    def scaling_schedules(self) -> Mapping[str, str]:
        """
        Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.
        """
        return pulumi.get(self, "scaling_schedules")


@pulumi.output_type
class AutoscalingPolicyScaleDownControlResponse(dict):
    """
    Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxScaledDownReplicas":
            suggest = "max_scaled_down_replicas"
        elif key == "timeWindowSec":
            suggest = "time_window_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicyScaleDownControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicyScaleDownControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicyScaleDownControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_scaled_down_replicas: 'outputs.FixedOrPercentResponse',
                 time_window_sec: int):
        """
        Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
        :param 'FixedOrPercentResponse' max_scaled_down_replicas: Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
        :param int time_window_sec: How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
        """
        pulumi.set(__self__, "max_scaled_down_replicas", max_scaled_down_replicas)
        pulumi.set(__self__, "time_window_sec", time_window_sec)

    @property
    @pulumi.getter(name="maxScaledDownReplicas")
    def max_scaled_down_replicas(self) -> 'outputs.FixedOrPercentResponse':
        """
        Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
        """
        return pulumi.get(self, "max_scaled_down_replicas")

    @property
    @pulumi.getter(name="timeWindowSec")
    def time_window_sec(self) -> int:
        """
        How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
        """
        return pulumi.get(self, "time_window_sec")


@pulumi.output_type
class AutoscalingPolicyScaleInControlResponse(dict):
    """
    Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxScaledInReplicas":
            suggest = "max_scaled_in_replicas"
        elif key == "timeWindowSec":
            suggest = "time_window_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingPolicyScaleInControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingPolicyScaleInControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingPolicyScaleInControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_scaled_in_replicas: 'outputs.FixedOrPercentResponse',
                 time_window_sec: int):
        """
        Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
        :param 'FixedOrPercentResponse' max_scaled_in_replicas: Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
        :param int time_window_sec: How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
        """
        pulumi.set(__self__, "max_scaled_in_replicas", max_scaled_in_replicas)
        pulumi.set(__self__, "time_window_sec", time_window_sec)

    @property
    @pulumi.getter(name="maxScaledInReplicas")
    def max_scaled_in_replicas(self) -> 'outputs.FixedOrPercentResponse':
        """
        Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
        """
        return pulumi.get(self, "max_scaled_in_replicas")

    @property
    @pulumi.getter(name="timeWindowSec")
    def time_window_sec(self) -> int:
        """
        How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
        """
        return pulumi.get(self, "time_window_sec")


@pulumi.output_type
class BackendBucketCdnPolicyBypassCacheOnRequestHeaderResponse(dict):
    """
    Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendBucketCdnPolicyBypassCacheOnRequestHeaderResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendBucketCdnPolicyBypassCacheOnRequestHeaderResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendBucketCdnPolicyBypassCacheOnRequestHeaderResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str):
        """
        Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
        :param str header_name: The header field name to match on when bypassing cache. Values are case-insensitive.
        """
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        The header field name to match on when bypassing cache. Values are case-insensitive.
        """
        return pulumi.get(self, "header_name")


@pulumi.output_type
class BackendBucketCdnPolicyCacheKeyPolicyResponse(dict):
    """
    Message containing what to include in the cache key for a request for Cloud CDN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeHttpHeaders":
            suggest = "include_http_headers"
        elif key == "queryStringWhitelist":
            suggest = "query_string_whitelist"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendBucketCdnPolicyCacheKeyPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendBucketCdnPolicyCacheKeyPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendBucketCdnPolicyCacheKeyPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_http_headers: Sequence[str],
                 query_string_whitelist: Sequence[str]):
        """
        Message containing what to include in the cache key for a request for Cloud CDN.
        :param Sequence[str] include_http_headers: Allows HTTP request headers (by name) to be used in the cache key.
        :param Sequence[str] query_string_whitelist: Names of query string parameters to include in cache keys. All other parameters will be excluded. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        pulumi.set(__self__, "include_http_headers", include_http_headers)
        pulumi.set(__self__, "query_string_whitelist", query_string_whitelist)

    @property
    @pulumi.getter(name="includeHttpHeaders")
    def include_http_headers(self) -> Sequence[str]:
        """
        Allows HTTP request headers (by name) to be used in the cache key.
        """
        return pulumi.get(self, "include_http_headers")

    @property
    @pulumi.getter(name="queryStringWhitelist")
    def query_string_whitelist(self) -> Sequence[str]:
        """
        Names of query string parameters to include in cache keys. All other parameters will be excluded. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "query_string_whitelist")


@pulumi.output_type
class BackendBucketCdnPolicyNegativeCachingPolicyResponse(dict):
    """
    Specify CDN TTLs for response error codes.
    """
    def __init__(__self__, *,
                 code: int,
                 ttl: int):
        """
        Specify CDN TTLs for response error codes.
        :param int code: The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        :param int ttl: The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class BackendBucketCdnPolicyResponse(dict):
    """
    Message containing Cloud CDN configuration for a backend bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bypassCacheOnRequestHeaders":
            suggest = "bypass_cache_on_request_headers"
        elif key == "cacheKeyPolicy":
            suggest = "cache_key_policy"
        elif key == "cacheMode":
            suggest = "cache_mode"
        elif key == "clientTtl":
            suggest = "client_ttl"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "negativeCaching":
            suggest = "negative_caching"
        elif key == "negativeCachingPolicy":
            suggest = "negative_caching_policy"
        elif key == "requestCoalescing":
            suggest = "request_coalescing"
        elif key == "serveWhileStale":
            suggest = "serve_while_stale"
        elif key == "signedUrlCacheMaxAgeSec":
            suggest = "signed_url_cache_max_age_sec"
        elif key == "signedUrlKeyNames":
            suggest = "signed_url_key_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendBucketCdnPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendBucketCdnPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendBucketCdnPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bypass_cache_on_request_headers: Sequence['outputs.BackendBucketCdnPolicyBypassCacheOnRequestHeaderResponse'],
                 cache_key_policy: 'outputs.BackendBucketCdnPolicyCacheKeyPolicyResponse',
                 cache_mode: str,
                 client_ttl: int,
                 default_ttl: int,
                 max_ttl: int,
                 negative_caching: bool,
                 negative_caching_policy: Sequence['outputs.BackendBucketCdnPolicyNegativeCachingPolicyResponse'],
                 request_coalescing: bool,
                 serve_while_stale: int,
                 signed_url_cache_max_age_sec: str,
                 signed_url_key_names: Sequence[str]):
        """
        Message containing Cloud CDN configuration for a backend bucket.
        :param Sequence['BackendBucketCdnPolicyBypassCacheOnRequestHeaderResponse'] bypass_cache_on_request_headers: Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        :param 'BackendBucketCdnPolicyCacheKeyPolicyResponse' cache_key_policy: The CacheKeyPolicy for this CdnPolicy.
        :param str cache_mode: Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        :param int client_ttl: Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        :param int default_ttl: Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        :param int max_ttl: Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        :param bool negative_caching: Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        :param Sequence['BackendBucketCdnPolicyNegativeCachingPolicyResponse'] negative_caching_policy: Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        :param bool request_coalescing: If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        :param int serve_while_stale: Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        :param str signed_url_cache_max_age_sec: Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        :param Sequence[str] signed_url_key_names: Names of the keys for signing request URLs.
        """
        pulumi.set(__self__, "bypass_cache_on_request_headers", bypass_cache_on_request_headers)
        pulumi.set(__self__, "cache_key_policy", cache_key_policy)
        pulumi.set(__self__, "cache_mode", cache_mode)
        pulumi.set(__self__, "client_ttl", client_ttl)
        pulumi.set(__self__, "default_ttl", default_ttl)
        pulumi.set(__self__, "max_ttl", max_ttl)
        pulumi.set(__self__, "negative_caching", negative_caching)
        pulumi.set(__self__, "negative_caching_policy", negative_caching_policy)
        pulumi.set(__self__, "request_coalescing", request_coalescing)
        pulumi.set(__self__, "serve_while_stale", serve_while_stale)
        pulumi.set(__self__, "signed_url_cache_max_age_sec", signed_url_cache_max_age_sec)
        pulumi.set(__self__, "signed_url_key_names", signed_url_key_names)

    @property
    @pulumi.getter(name="bypassCacheOnRequestHeaders")
    def bypass_cache_on_request_headers(self) -> Sequence['outputs.BackendBucketCdnPolicyBypassCacheOnRequestHeaderResponse']:
        """
        Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        """
        return pulumi.get(self, "bypass_cache_on_request_headers")

    @property
    @pulumi.getter(name="cacheKeyPolicy")
    def cache_key_policy(self) -> 'outputs.BackendBucketCdnPolicyCacheKeyPolicyResponse':
        """
        The CacheKeyPolicy for this CdnPolicy.
        """
        return pulumi.get(self, "cache_key_policy")

    @property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> str:
        """
        Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        """
        return pulumi.get(self, "cache_mode")

    @property
    @pulumi.getter(name="clientTtl")
    def client_ttl(self) -> int:
        """
        Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        """
        return pulumi.get(self, "client_ttl")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> int:
        """
        Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> int:
        """
        Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="negativeCaching")
    def negative_caching(self) -> bool:
        """
        Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        """
        return pulumi.get(self, "negative_caching")

    @property
    @pulumi.getter(name="negativeCachingPolicy")
    def negative_caching_policy(self) -> Sequence['outputs.BackendBucketCdnPolicyNegativeCachingPolicyResponse']:
        """
        Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        """
        return pulumi.get(self, "negative_caching_policy")

    @property
    @pulumi.getter(name="requestCoalescing")
    def request_coalescing(self) -> bool:
        """
        If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        """
        return pulumi.get(self, "request_coalescing")

    @property
    @pulumi.getter(name="serveWhileStale")
    def serve_while_stale(self) -> int:
        """
        Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        """
        return pulumi.get(self, "serve_while_stale")

    @property
    @pulumi.getter(name="signedUrlCacheMaxAgeSec")
    def signed_url_cache_max_age_sec(self) -> str:
        """
        Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        """
        return pulumi.get(self, "signed_url_cache_max_age_sec")

    @property
    @pulumi.getter(name="signedUrlKeyNames")
    def signed_url_key_names(self) -> Sequence[str]:
        """
        Names of the keys for signing request URLs.
        """
        return pulumi.get(self, "signed_url_key_names")


@pulumi.output_type
class BackendResponse(dict):
    """
    Message containing information of one individual backend.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "balancingMode":
            suggest = "balancing_mode"
        elif key == "capacityScaler":
            suggest = "capacity_scaler"
        elif key == "maxConnections":
            suggest = "max_connections"
        elif key == "maxConnectionsPerEndpoint":
            suggest = "max_connections_per_endpoint"
        elif key == "maxConnectionsPerInstance":
            suggest = "max_connections_per_instance"
        elif key == "maxRate":
            suggest = "max_rate"
        elif key == "maxRatePerEndpoint":
            suggest = "max_rate_per_endpoint"
        elif key == "maxRatePerInstance":
            suggest = "max_rate_per_instance"
        elif key == "maxUtilization":
            suggest = "max_utilization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 balancing_mode: str,
                 capacity_scaler: float,
                 description: str,
                 failover: bool,
                 group: str,
                 max_connections: int,
                 max_connections_per_endpoint: int,
                 max_connections_per_instance: int,
                 max_rate: int,
                 max_rate_per_endpoint: float,
                 max_rate_per_instance: float,
                 max_utilization: float):
        """
        Message containing information of one individual backend.
        :param str balancing_mode: Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
        :param float capacity_scaler: A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
        :param str description: An optional description of this resource. Provide this property when you create the resource.
        :param bool failover: This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
        :param str group: The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
        :param int max_connections: Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        :param int max_connections_per_endpoint: Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        :param int max_connections_per_instance: Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        :param int max_rate: Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        :param float max_rate_per_endpoint: Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        :param float max_rate_per_instance: Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        :param float max_utilization: Optional parameter to define a target capacity for the UTILIZATIONbalancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
        """
        pulumi.set(__self__, "balancing_mode", balancing_mode)
        pulumi.set(__self__, "capacity_scaler", capacity_scaler)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "failover", failover)
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "max_connections_per_endpoint", max_connections_per_endpoint)
        pulumi.set(__self__, "max_connections_per_instance", max_connections_per_instance)
        pulumi.set(__self__, "max_rate", max_rate)
        pulumi.set(__self__, "max_rate_per_endpoint", max_rate_per_endpoint)
        pulumi.set(__self__, "max_rate_per_instance", max_rate_per_instance)
        pulumi.set(__self__, "max_utilization", max_utilization)

    @property
    @pulumi.getter(name="balancingMode")
    def balancing_mode(self) -> str:
        """
        Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
        """
        return pulumi.get(self, "balancing_mode")

    @property
    @pulumi.getter(name="capacityScaler")
    def capacity_scaler(self) -> float:
        """
        A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
        """
        return pulumi.get(self, "capacity_scaler")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def failover(self) -> bool:
        """
        This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
        """
        return pulumi.get(self, "failover")

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> int:
        """
        Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter(name="maxConnectionsPerEndpoint")
    def max_connections_per_endpoint(self) -> int:
        """
        Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        """
        return pulumi.get(self, "max_connections_per_endpoint")

    @property
    @pulumi.getter(name="maxConnectionsPerInstance")
    def max_connections_per_instance(self) -> int:
        """
        Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        """
        return pulumi.get(self, "max_connections_per_instance")

    @property
    @pulumi.getter(name="maxRate")
    def max_rate(self) -> int:
        """
        Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        """
        return pulumi.get(self, "max_rate")

    @property
    @pulumi.getter(name="maxRatePerEndpoint")
    def max_rate_per_endpoint(self) -> float:
        """
        Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        """
        return pulumi.get(self, "max_rate_per_endpoint")

    @property
    @pulumi.getter(name="maxRatePerInstance")
    def max_rate_per_instance(self) -> float:
        """
        Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        """
        return pulumi.get(self, "max_rate_per_instance")

    @property
    @pulumi.getter(name="maxUtilization")
    def max_utilization(self) -> float:
        """
        Optional parameter to define a target capacity for the UTILIZATIONbalancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
        """
        return pulumi.get(self, "max_utilization")


@pulumi.output_type
class BackendServiceCdnPolicyBypassCacheOnRequestHeaderResponse(dict):
    """
    Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceCdnPolicyBypassCacheOnRequestHeaderResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceCdnPolicyBypassCacheOnRequestHeaderResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceCdnPolicyBypassCacheOnRequestHeaderResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str):
        """
        Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
        :param str header_name: The header field name to match on when bypassing cache. Values are case-insensitive.
        """
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        The header field name to match on when bypassing cache. Values are case-insensitive.
        """
        return pulumi.get(self, "header_name")


@pulumi.output_type
class BackendServiceCdnPolicyNegativeCachingPolicyResponse(dict):
    """
    Specify CDN TTLs for response error codes.
    """
    def __init__(__self__, *,
                 code: int,
                 ttl: int):
        """
        Specify CDN TTLs for response error codes.
        :param int code: The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        :param int ttl: The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class BackendServiceCdnPolicyResponse(dict):
    """
    Message containing Cloud CDN configuration for a backend service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bypassCacheOnRequestHeaders":
            suggest = "bypass_cache_on_request_headers"
        elif key == "cacheKeyPolicy":
            suggest = "cache_key_policy"
        elif key == "cacheMode":
            suggest = "cache_mode"
        elif key == "clientTtl":
            suggest = "client_ttl"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "negativeCaching":
            suggest = "negative_caching"
        elif key == "negativeCachingPolicy":
            suggest = "negative_caching_policy"
        elif key == "requestCoalescing":
            suggest = "request_coalescing"
        elif key == "serveWhileStale":
            suggest = "serve_while_stale"
        elif key == "signedUrlCacheMaxAgeSec":
            suggest = "signed_url_cache_max_age_sec"
        elif key == "signedUrlKeyNames":
            suggest = "signed_url_key_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceCdnPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceCdnPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceCdnPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bypass_cache_on_request_headers: Sequence['outputs.BackendServiceCdnPolicyBypassCacheOnRequestHeaderResponse'],
                 cache_key_policy: 'outputs.CacheKeyPolicyResponse',
                 cache_mode: str,
                 client_ttl: int,
                 default_ttl: int,
                 max_ttl: int,
                 negative_caching: bool,
                 negative_caching_policy: Sequence['outputs.BackendServiceCdnPolicyNegativeCachingPolicyResponse'],
                 request_coalescing: bool,
                 serve_while_stale: int,
                 signed_url_cache_max_age_sec: str,
                 signed_url_key_names: Sequence[str]):
        """
        Message containing Cloud CDN configuration for a backend service.
        :param Sequence['BackendServiceCdnPolicyBypassCacheOnRequestHeaderResponse'] bypass_cache_on_request_headers: Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        :param 'CacheKeyPolicyResponse' cache_key_policy: The CacheKeyPolicy for this CdnPolicy.
        :param str cache_mode: Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        :param int client_ttl: Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        :param int default_ttl: Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        :param int max_ttl: Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        :param bool negative_caching: Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        :param Sequence['BackendServiceCdnPolicyNegativeCachingPolicyResponse'] negative_caching_policy: Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        :param bool request_coalescing: If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        :param int serve_while_stale: Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        :param str signed_url_cache_max_age_sec: Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        :param Sequence[str] signed_url_key_names: Names of the keys for signing request URLs.
        """
        pulumi.set(__self__, "bypass_cache_on_request_headers", bypass_cache_on_request_headers)
        pulumi.set(__self__, "cache_key_policy", cache_key_policy)
        pulumi.set(__self__, "cache_mode", cache_mode)
        pulumi.set(__self__, "client_ttl", client_ttl)
        pulumi.set(__self__, "default_ttl", default_ttl)
        pulumi.set(__self__, "max_ttl", max_ttl)
        pulumi.set(__self__, "negative_caching", negative_caching)
        pulumi.set(__self__, "negative_caching_policy", negative_caching_policy)
        pulumi.set(__self__, "request_coalescing", request_coalescing)
        pulumi.set(__self__, "serve_while_stale", serve_while_stale)
        pulumi.set(__self__, "signed_url_cache_max_age_sec", signed_url_cache_max_age_sec)
        pulumi.set(__self__, "signed_url_key_names", signed_url_key_names)

    @property
    @pulumi.getter(name="bypassCacheOnRequestHeaders")
    def bypass_cache_on_request_headers(self) -> Sequence['outputs.BackendServiceCdnPolicyBypassCacheOnRequestHeaderResponse']:
        """
        Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        """
        return pulumi.get(self, "bypass_cache_on_request_headers")

    @property
    @pulumi.getter(name="cacheKeyPolicy")
    def cache_key_policy(self) -> 'outputs.CacheKeyPolicyResponse':
        """
        The CacheKeyPolicy for this CdnPolicy.
        """
        return pulumi.get(self, "cache_key_policy")

    @property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> str:
        """
        Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
        """
        return pulumi.get(self, "cache_mode")

    @property
    @pulumi.getter(name="clientTtl")
    def client_ttl(self) -> int:
        """
        Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        """
        return pulumi.get(self, "client_ttl")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> int:
        """
        Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> int:
        """
        Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="negativeCaching")
    def negative_caching(self) -> bool:
        """
        Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        """
        return pulumi.get(self, "negative_caching")

    @property
    @pulumi.getter(name="negativeCachingPolicy")
    def negative_caching_policy(self) -> Sequence['outputs.BackendServiceCdnPolicyNegativeCachingPolicyResponse']:
        """
        Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        """
        return pulumi.get(self, "negative_caching_policy")

    @property
    @pulumi.getter(name="requestCoalescing")
    def request_coalescing(self) -> bool:
        """
        If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        """
        return pulumi.get(self, "request_coalescing")

    @property
    @pulumi.getter(name="serveWhileStale")
    def serve_while_stale(self) -> int:
        """
        Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        """
        return pulumi.get(self, "serve_while_stale")

    @property
    @pulumi.getter(name="signedUrlCacheMaxAgeSec")
    def signed_url_cache_max_age_sec(self) -> str:
        """
        Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        """
        return pulumi.get(self, "signed_url_cache_max_age_sec")

    @property
    @pulumi.getter(name="signedUrlKeyNames")
    def signed_url_key_names(self) -> Sequence[str]:
        """
        Names of the keys for signing request URLs.
        """
        return pulumi.get(self, "signed_url_key_names")


@pulumi.output_type
class BackendServiceConnectionTrackingPolicyResponse(dict):
    """
    Connection Tracking configuration for this BackendService.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionPersistenceOnUnhealthyBackends":
            suggest = "connection_persistence_on_unhealthy_backends"
        elif key == "enableStrongAffinity":
            suggest = "enable_strong_affinity"
        elif key == "idleTimeoutSec":
            suggest = "idle_timeout_sec"
        elif key == "trackingMode":
            suggest = "tracking_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceConnectionTrackingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceConnectionTrackingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceConnectionTrackingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_persistence_on_unhealthy_backends: str,
                 enable_strong_affinity: bool,
                 idle_timeout_sec: int,
                 tracking_mode: str):
        """
        Connection Tracking configuration for this BackendService.
        :param str connection_persistence_on_unhealthy_backends: Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
        :param bool enable_strong_affinity: Enable Strong Session Affinity for Network Load Balancing. This option is not available publicly.
        :param int idle_timeout_sec: Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For Internal TCP/UDP Load Balancing: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For Network Load Balancer the default is 60 seconds. This option is not available publicly.
        :param str tracking_mode: Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
        """
        pulumi.set(__self__, "connection_persistence_on_unhealthy_backends", connection_persistence_on_unhealthy_backends)
        pulumi.set(__self__, "enable_strong_affinity", enable_strong_affinity)
        pulumi.set(__self__, "idle_timeout_sec", idle_timeout_sec)
        pulumi.set(__self__, "tracking_mode", tracking_mode)

    @property
    @pulumi.getter(name="connectionPersistenceOnUnhealthyBackends")
    def connection_persistence_on_unhealthy_backends(self) -> str:
        """
        Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
        """
        return pulumi.get(self, "connection_persistence_on_unhealthy_backends")

    @property
    @pulumi.getter(name="enableStrongAffinity")
    def enable_strong_affinity(self) -> bool:
        """
        Enable Strong Session Affinity for Network Load Balancing. This option is not available publicly.
        """
        return pulumi.get(self, "enable_strong_affinity")

    @property
    @pulumi.getter(name="idleTimeoutSec")
    def idle_timeout_sec(self) -> int:
        """
        Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For Internal TCP/UDP Load Balancing: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For Network Load Balancer the default is 60 seconds. This option is not available publicly.
        """
        return pulumi.get(self, "idle_timeout_sec")

    @property
    @pulumi.getter(name="trackingMode")
    def tracking_mode(self) -> str:
        """
        Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
        """
        return pulumi.get(self, "tracking_mode")


@pulumi.output_type
class BackendServiceFailoverPolicyResponse(dict):
    """
    For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). On failover or failback, this field indicates whether connection draining will be honored. Google Cloud has a fixed connection draining timeout of 10 minutes. A setting of true terminates existing TCP connections to the active pool during failover and failback, immediately draining traffic. A setting of false allows existing TCP connections to persist, even on VMs no longer in the active pool, for up to the duration of the connection draining timeout (10 minutes).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableConnectionDrainOnFailover":
            suggest = "disable_connection_drain_on_failover"
        elif key == "dropTrafficIfUnhealthy":
            suggest = "drop_traffic_if_unhealthy"
        elif key == "failoverRatio":
            suggest = "failover_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceFailoverPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceFailoverPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceFailoverPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_connection_drain_on_failover: bool,
                 drop_traffic_if_unhealthy: bool,
                 failover_ratio: float):
        """
        For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). On failover or failback, this field indicates whether connection draining will be honored. Google Cloud has a fixed connection draining timeout of 10 minutes. A setting of true terminates existing TCP connections to the active pool during failover and failback, immediately draining traffic. A setting of false allows existing TCP connections to persist, even on VMs no longer in the active pool, for up to the duration of the connection draining timeout (10 minutes).
        :param bool disable_connection_drain_on_failover: This can be set to true only if the protocol is TCP. The default is false.
        :param bool drop_traffic_if_unhealthy: If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). The default is false.
        :param float failover_ratio: The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
        """
        pulumi.set(__self__, "disable_connection_drain_on_failover", disable_connection_drain_on_failover)
        pulumi.set(__self__, "drop_traffic_if_unhealthy", drop_traffic_if_unhealthy)
        pulumi.set(__self__, "failover_ratio", failover_ratio)

    @property
    @pulumi.getter(name="disableConnectionDrainOnFailover")
    def disable_connection_drain_on_failover(self) -> bool:
        """
        This can be set to true only if the protocol is TCP. The default is false.
        """
        return pulumi.get(self, "disable_connection_drain_on_failover")

    @property
    @pulumi.getter(name="dropTrafficIfUnhealthy")
    def drop_traffic_if_unhealthy(self) -> bool:
        """
        If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). The default is false.
        """
        return pulumi.get(self, "drop_traffic_if_unhealthy")

    @property
    @pulumi.getter(name="failoverRatio")
    def failover_ratio(self) -> float:
        """
        The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
        """
        return pulumi.get(self, "failover_ratio")


@pulumi.output_type
class BackendServiceIAPResponse(dict):
    """
    Identity-Aware Proxy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oauth2ClientId":
            suggest = "oauth2_client_id"
        elif key == "oauth2ClientSecret":
            suggest = "oauth2_client_secret"
        elif key == "oauth2ClientSecretSha256":
            suggest = "oauth2_client_secret_sha256"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceIAPResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceIAPResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceIAPResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 oauth2_client_id: str,
                 oauth2_client_secret: str,
                 oauth2_client_secret_sha256: str):
        """
        Identity-Aware Proxy
        :param bool enabled: Whether the serving infrastructure will authenticate and authorize all incoming requests. If true, the oauth2ClientId and oauth2ClientSecret fields must be non-empty.
        :param str oauth2_client_id: OAuth2 client ID to use for the authentication flow.
        :param str oauth2_client_secret: OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field. @InputOnly
        :param str oauth2_client_secret_sha256: SHA256 hash value for the field oauth2_client_secret above.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "oauth2_client_id", oauth2_client_id)
        pulumi.set(__self__, "oauth2_client_secret", oauth2_client_secret)
        pulumi.set(__self__, "oauth2_client_secret_sha256", oauth2_client_secret_sha256)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the serving infrastructure will authenticate and authorize all incoming requests. If true, the oauth2ClientId and oauth2ClientSecret fields must be non-empty.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> str:
        """
        OAuth2 client ID to use for the authentication flow.
        """
        return pulumi.get(self, "oauth2_client_id")

    @property
    @pulumi.getter(name="oauth2ClientSecret")
    def oauth2_client_secret(self) -> str:
        """
        OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field. @InputOnly
        """
        return pulumi.get(self, "oauth2_client_secret")

    @property
    @pulumi.getter(name="oauth2ClientSecretSha256")
    def oauth2_client_secret_sha256(self) -> str:
        """
        SHA256 hash value for the field oauth2_client_secret above.
        """
        return pulumi.get(self, "oauth2_client_secret_sha256")


@pulumi.output_type
class BackendServiceLogConfigResponse(dict):
    """
    The available logging options for the load balancer traffic served by this backend service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sampleRate":
            suggest = "sample_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: bool,
                 sample_rate: float):
        """
        The available logging options for the load balancer traffic served by this backend service.
        :param bool enable: This field denotes whether to enable logging for the load balancer traffic served by this backend service.
        :param float sample_rate: This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "sample_rate", sample_rate)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        This field denotes whether to enable logging for the load balancer traffic served by this backend service.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> float:
        """
        This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.
        """
        return pulumi.get(self, "sample_rate")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindingId":
            suggest = "binding_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BindingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BindingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BindingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 binding_id: str,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param str binding_id: This is deprecated and has no effect. Do not use.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "binding_id", binding_id)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="bindingId")
    def binding_id(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "binding_id")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class CacheKeyPolicyResponse(dict):
    """
    Message containing what to include in the cache key for a request for Cloud CDN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeHost":
            suggest = "include_host"
        elif key == "includeHttpHeaders":
            suggest = "include_http_headers"
        elif key == "includeNamedCookies":
            suggest = "include_named_cookies"
        elif key == "includeProtocol":
            suggest = "include_protocol"
        elif key == "includeQueryString":
            suggest = "include_query_string"
        elif key == "queryStringBlacklist":
            suggest = "query_string_blacklist"
        elif key == "queryStringWhitelist":
            suggest = "query_string_whitelist"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheKeyPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheKeyPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheKeyPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_host: bool,
                 include_http_headers: Sequence[str],
                 include_named_cookies: Sequence[str],
                 include_protocol: bool,
                 include_query_string: bool,
                 query_string_blacklist: Sequence[str],
                 query_string_whitelist: Sequence[str]):
        """
        Message containing what to include in the cache key for a request for Cloud CDN.
        :param bool include_host: If true, requests to different hosts will be cached separately.
        :param Sequence[str] include_http_headers: Allows HTTP request headers (by name) to be used in the cache key.
        :param Sequence[str] include_named_cookies: Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
        :param bool include_protocol: If true, http and https requests will be cached separately.
        :param bool include_query_string: If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
        :param Sequence[str] query_string_blacklist: Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        :param Sequence[str] query_string_whitelist: Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        pulumi.set(__self__, "include_host", include_host)
        pulumi.set(__self__, "include_http_headers", include_http_headers)
        pulumi.set(__self__, "include_named_cookies", include_named_cookies)
        pulumi.set(__self__, "include_protocol", include_protocol)
        pulumi.set(__self__, "include_query_string", include_query_string)
        pulumi.set(__self__, "query_string_blacklist", query_string_blacklist)
        pulumi.set(__self__, "query_string_whitelist", query_string_whitelist)

    @property
    @pulumi.getter(name="includeHost")
    def include_host(self) -> bool:
        """
        If true, requests to different hosts will be cached separately.
        """
        return pulumi.get(self, "include_host")

    @property
    @pulumi.getter(name="includeHttpHeaders")
    def include_http_headers(self) -> Sequence[str]:
        """
        Allows HTTP request headers (by name) to be used in the cache key.
        """
        return pulumi.get(self, "include_http_headers")

    @property
    @pulumi.getter(name="includeNamedCookies")
    def include_named_cookies(self) -> Sequence[str]:
        """
        Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
        """
        return pulumi.get(self, "include_named_cookies")

    @property
    @pulumi.getter(name="includeProtocol")
    def include_protocol(self) -> bool:
        """
        If true, http and https requests will be cached separately.
        """
        return pulumi.get(self, "include_protocol")

    @property
    @pulumi.getter(name="includeQueryString")
    def include_query_string(self) -> bool:
        """
        If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
        """
        return pulumi.get(self, "include_query_string")

    @property
    @pulumi.getter(name="queryStringBlacklist")
    def query_string_blacklist(self) -> Sequence[str]:
        """
        Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "query_string_blacklist")

    @property
    @pulumi.getter(name="queryStringWhitelist")
    def query_string_whitelist(self) -> Sequence[str]:
        """
        Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "query_string_whitelist")


@pulumi.output_type
class CircuitBreakersResponse(dict):
    """
    Settings controlling the volume of requests, connections and retries to this backend service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "maxConnections":
            suggest = "max_connections"
        elif key == "maxPendingRequests":
            suggest = "max_pending_requests"
        elif key == "maxRequests":
            suggest = "max_requests"
        elif key == "maxRequestsPerConnection":
            suggest = "max_requests_per_connection"
        elif key == "maxRetries":
            suggest = "max_retries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CircuitBreakersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CircuitBreakersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CircuitBreakersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_timeout: 'outputs.DurationResponse',
                 max_connections: int,
                 max_pending_requests: int,
                 max_requests: int,
                 max_requests_per_connection: int,
                 max_retries: int):
        """
        Settings controlling the volume of requests, connections and retries to this backend service.
        :param 'DurationResponse' connect_timeout: The timeout for new network connections to hosts.
        :param int max_connections: Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param int max_pending_requests: Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param int max_requests: The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.
        :param int max_requests_per_connection: Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param int max_retries: Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        pulumi.set(__self__, "connect_timeout", connect_timeout)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "max_pending_requests", max_pending_requests)
        pulumi.set(__self__, "max_requests", max_requests)
        pulumi.set(__self__, "max_requests_per_connection", max_requests_per_connection)
        pulumi.set(__self__, "max_retries", max_retries)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> 'outputs.DurationResponse':
        """
        The timeout for new network connections to hosts.
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> int:
        """
        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter(name="maxPendingRequests")
    def max_pending_requests(self) -> int:
        """
        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "max_pending_requests")

    @property
    @pulumi.getter(name="maxRequests")
    def max_requests(self) -> int:
        """
        The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.
        """
        return pulumi.get(self, "max_requests")

    @property
    @pulumi.getter(name="maxRequestsPerConnection")
    def max_requests_per_connection(self) -> int:
        """
        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "max_requests_per_connection")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> int:
        """
        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "max_retries")


@pulumi.output_type
class ConditionResponse(dict):
    """
    This is deprecated and has no effect. Do not use.
    """
    def __init__(__self__, *,
                 iam: str,
                 op: str,
                 svc: str,
                 sys: str,
                 values: Sequence[str]):
        """
        This is deprecated and has no effect. Do not use.
        :param str iam: This is deprecated and has no effect. Do not use.
        :param str op: This is deprecated and has no effect. Do not use.
        :param str svc: This is deprecated and has no effect. Do not use.
        :param str sys: This is deprecated and has no effect. Do not use.
        :param Sequence[str] values: This is deprecated and has no effect. Do not use.
        """
        pulumi.set(__self__, "iam", iam)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "svc", svc)
        pulumi.set(__self__, "sys", sys)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def iam(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def svc(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "svc")

    @property
    @pulumi.getter
    def sys(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "sys")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ConfidentialInstanceConfigResponse(dict):
    """
    A set of Confidential Instance options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableConfidentialCompute":
            suggest = "enable_confidential_compute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfidentialInstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfidentialInstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfidentialInstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_confidential_compute: bool):
        """
        A set of Confidential Instance options.
        :param bool enable_confidential_compute: Defines whether the instance should have confidential compute enabled.
        """
        pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)

    @property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> bool:
        """
        Defines whether the instance should have confidential compute enabled.
        """
        return pulumi.get(self, "enable_confidential_compute")


@pulumi.output_type
class ConnectionDrainingResponse(dict):
    """
    Message containing connection draining configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drainingTimeoutSec":
            suggest = "draining_timeout_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionDrainingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionDrainingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionDrainingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 draining_timeout_sec: int):
        """
        Message containing connection draining configuration.
        :param int draining_timeout_sec: Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.
        """
        pulumi.set(__self__, "draining_timeout_sec", draining_timeout_sec)

    @property
    @pulumi.getter(name="drainingTimeoutSec")
    def draining_timeout_sec(self) -> int:
        """
        Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.
        """
        return pulumi.get(self, "draining_timeout_sec")


@pulumi.output_type
class ConsistentHashLoadBalancerSettingsHttpCookieResponse(dict):
    """
    The information about the HTTP Cookie on which the hash function is based for load balancing policies that use a consistent hash.
    """
    def __init__(__self__, *,
                 name: str,
                 path: str,
                 ttl: 'outputs.DurationResponse'):
        """
        The information about the HTTP Cookie on which the hash function is based for load balancing policies that use a consistent hash.
        :param str name: Name of the cookie.
        :param str path: Path to set for the cookie.
        :param 'DurationResponse' ttl: Lifetime of the cookie.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the cookie.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path to set for the cookie.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def ttl(self) -> 'outputs.DurationResponse':
        """
        Lifetime of the cookie.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class ConsistentHashLoadBalancerSettingsResponse(dict):
    """
    This message defines settings for a consistent hash style load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpCookie":
            suggest = "http_cookie"
        elif key == "httpHeaderName":
            suggest = "http_header_name"
        elif key == "minimumRingSize":
            suggest = "minimum_ring_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConsistentHashLoadBalancerSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConsistentHashLoadBalancerSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConsistentHashLoadBalancerSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_cookie: 'outputs.ConsistentHashLoadBalancerSettingsHttpCookieResponse',
                 http_header_name: str,
                 minimum_ring_size: str):
        """
        This message defines settings for a consistent hash style load balancer.
        :param 'ConsistentHashLoadBalancerSettingsHttpCookieResponse' http_cookie: Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param str http_header_name: The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.
        :param str minimum_ring_size: The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.
        """
        pulumi.set(__self__, "http_cookie", http_cookie)
        pulumi.set(__self__, "http_header_name", http_header_name)
        pulumi.set(__self__, "minimum_ring_size", minimum_ring_size)

    @property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> 'outputs.ConsistentHashLoadBalancerSettingsHttpCookieResponse':
        """
        Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "http_cookie")

    @property
    @pulumi.getter(name="httpHeaderName")
    def http_header_name(self) -> str:
        """
        The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.
        """
        return pulumi.get(self, "http_header_name")

    @property
    @pulumi.getter(name="minimumRingSize")
    def minimum_ring_size(self) -> str:
        """
        The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.
        """
        return pulumi.get(self, "minimum_ring_size")


@pulumi.output_type
class CorsPolicyResponse(dict):
    """
    The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOriginRegexes":
            suggest = "allow_origin_regexes"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CorsPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CorsPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CorsPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: bool,
                 allow_headers: Sequence[str],
                 allow_methods: Sequence[str],
                 allow_origin_regexes: Sequence[str],
                 allow_origins: Sequence[str],
                 disabled: bool,
                 expose_headers: Sequence[str],
                 max_age: int):
        """
        The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard.
        :param bool allow_credentials: In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
        :param Sequence[str] allow_headers: Specifies the content for the Access-Control-Allow-Headers header.
        :param Sequence[str] allow_methods: Specifies the content for the Access-Control-Allow-Methods header.
        :param Sequence[str] allow_origin_regexes: Specifies a regular expression that matches allowed origins. For more information about the regular expression syntax, see Syntax. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
        :param Sequence[str] allow_origins: Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
        :param bool disabled: If true, the setting specifies the CORS policy is disabled. The default value of false, which indicates that the CORS policy is in effect.
        :param Sequence[str] expose_headers: Specifies the content for the Access-Control-Expose-Headers header.
        :param int max_age: Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
        """
        pulumi.set(__self__, "allow_credentials", allow_credentials)
        pulumi.set(__self__, "allow_headers", allow_headers)
        pulumi.set(__self__, "allow_methods", allow_methods)
        pulumi.set(__self__, "allow_origin_regexes", allow_origin_regexes)
        pulumi.set(__self__, "allow_origins", allow_origins)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> bool:
        """
        In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Sequence[str]:
        """
        Specifies the content for the Access-Control-Allow-Headers header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Sequence[str]:
        """
        Specifies the content for the Access-Control-Allow-Methods header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOriginRegexes")
    def allow_origin_regexes(self) -> Sequence[str]:
        """
        Specifies a regular expression that matches allowed origins. For more information about the regular expression syntax, see Syntax. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
        """
        return pulumi.get(self, "allow_origin_regexes")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Sequence[str]:
        """
        Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        If true, the setting specifies the CORS policy is disabled. The default value of false, which indicates that the CORS policy is in effect.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[str]:
        """
        Specifies the content for the Access-Control-Expose-Headers header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> int:
        """
        Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class CustomerEncryptionKeyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyServiceAccount":
            suggest = "kms_key_service_account"
        elif key == "rawKey":
            suggest = "raw_key"
        elif key == "rsaEncryptedKey":
            suggest = "rsa_encrypted_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomerEncryptionKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomerEncryptionKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomerEncryptionKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 kms_key_service_account: str,
                 raw_key: str,
                 rsa_encrypted_key: str,
                 sha256: str):
        """
        :param str kms_key_name: The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key 
        :param str kms_key_service_account: The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/ 
        :param str raw_key: Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0=" 
        :param str rsa_encrypted_key: Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem 
        :param str sha256: [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        pulumi.set(__self__, "kms_key_service_account", kms_key_service_account)
        pulumi.set(__self__, "raw_key", raw_key)
        pulumi.set(__self__, "rsa_encrypted_key", rsa_encrypted_key)
        pulumi.set(__self__, "sha256", sha256)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key 
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyServiceAccount")
    def kms_key_service_account(self) -> str:
        """
        The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/ 
        """
        return pulumi.get(self, "kms_key_service_account")

    @property
    @pulumi.getter(name="rawKey")
    def raw_key(self) -> str:
        """
        Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0=" 
        """
        return pulumi.get(self, "raw_key")

    @property
    @pulumi.getter(name="rsaEncryptedKey")
    def rsa_encrypted_key(self) -> str:
        """
        Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem 
        """
        return pulumi.get(self, "rsa_encrypted_key")

    @property
    @pulumi.getter
    def sha256(self) -> str:
        """
        [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
        """
        return pulumi.get(self, "sha256")


@pulumi.output_type
class DeprecationStatusResponse(dict):
    """
    Deprecation status for a public resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateOverride":
            suggest = "state_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeprecationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeprecationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeprecationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deleted: str,
                 deprecated: str,
                 obsolete: str,
                 replacement: str,
                 state: str,
                 state_override: 'outputs.RolloutPolicyResponse'):
        """
        Deprecation status for a public resource.
        :param str deleted: An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
        :param str deprecated: An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
        :param str obsolete: An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
        :param str replacement: The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
        :param str state: The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
        :param 'RolloutPolicyResponse' state_override: The rollout policy for this deprecation. This policy is only enforced by image family views. The rollout policy restricts the zones where the associated resource is considered in a deprecated state. When the rollout policy does not include the user specified zone, or if the zone is rolled out, the associated resource is considered in a deprecated state. The rollout policy for this deprecation is read-only, except for allowlisted users. This field might not be configured. To view the latest non-deprecated image in a specific zone, use the imageFamilyViews.get method.
        """
        pulumi.set(__self__, "deleted", deleted)
        pulumi.set(__self__, "deprecated", deprecated)
        pulumi.set(__self__, "obsolete", obsolete)
        pulumi.set(__self__, "replacement", replacement)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_override", state_override)

    @property
    @pulumi.getter
    def deleted(self) -> str:
        """
        An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
        """
        return pulumi.get(self, "deleted")

    @property
    @pulumi.getter
    def deprecated(self) -> str:
        """
        An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
        """
        return pulumi.get(self, "deprecated")

    @property
    @pulumi.getter
    def obsolete(self) -> str:
        """
        An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
        """
        return pulumi.get(self, "obsolete")

    @property
    @pulumi.getter
    def replacement(self) -> str:
        """
        The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
        """
        return pulumi.get(self, "replacement")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateOverride")
    def state_override(self) -> 'outputs.RolloutPolicyResponse':
        """
        The rollout policy for this deprecation. This policy is only enforced by image family views. The rollout policy restricts the zones where the associated resource is considered in a deprecated state. When the rollout policy does not include the user specified zone, or if the zone is rolled out, the associated resource is considered in a deprecated state. The rollout policy for this deprecation is read-only, except for allowlisted users. This field might not be configured. To view the latest non-deprecated image in a specific zone, use the imageFamilyViews.get method.
        """
        return pulumi.get(self, "state_override")


@pulumi.output_type
class DiskInstantiationConfigResponse(dict):
    """
    A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDelete":
            suggest = "auto_delete"
        elif key == "customImage":
            suggest = "custom_image"
        elif key == "deviceName":
            suggest = "device_name"
        elif key == "instantiateFrom":
            suggest = "instantiate_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskInstantiationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskInstantiationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskInstantiationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete: bool,
                 custom_image: str,
                 device_name: str,
                 instantiate_from: str):
        """
        A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
        :param bool auto_delete: Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        :param str custom_image: The custom source image to be used to restore this disk when instantiating this instance template.
        :param str device_name: Specifies the device name of the disk to which the configurations apply to.
        :param str instantiate_from: Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks. 
        """
        pulumi.set(__self__, "auto_delete", auto_delete)
        pulumi.set(__self__, "custom_image", custom_image)
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "instantiate_from", instantiate_from)

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> bool:
        """
        Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        """
        return pulumi.get(self, "auto_delete")

    @property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> str:
        """
        The custom source image to be used to restore this disk when instantiating this instance template.
        """
        return pulumi.get(self, "custom_image")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Specifies the device name of the disk to which the configurations apply to.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="instantiateFrom")
    def instantiate_from(self) -> str:
        """
        Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks. 
        """
        return pulumi.get(self, "instantiate_from")


@pulumi.output_type
class DisplayDeviceResponse(dict):
    """
    A set of Display Device options
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDisplay":
            suggest = "enable_display"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DisplayDeviceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DisplayDeviceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DisplayDeviceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_display: bool):
        """
        A set of Display Device options
        :param bool enable_display: Defines whether the instance has Display enabled.
        """
        pulumi.set(__self__, "enable_display", enable_display)

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> bool:
        """
        Defines whether the instance has Display enabled.
        """
        return pulumi.get(self, "enable_display")


@pulumi.output_type
class DistributionPolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetShape":
            suggest = "target_shape"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_shape: str,
                 zones: Sequence['outputs.DistributionPolicyZoneConfigurationResponse']):
        """
        :param str target_shape: The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
        :param Sequence['DistributionPolicyZoneConfigurationResponse'] zones: Zones where the regional managed instance group will create and manage its instances.
        """
        pulumi.set(__self__, "target_shape", target_shape)
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="targetShape")
    def target_shape(self) -> str:
        """
        The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
        """
        return pulumi.get(self, "target_shape")

    @property
    @pulumi.getter
    def zones(self) -> Sequence['outputs.DistributionPolicyZoneConfigurationResponse']:
        """
        Zones where the regional managed instance group will create and manage its instances.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class DistributionPolicyZoneConfigurationResponse(dict):
    def __init__(__self__, *,
                 zone: str):
        """
        :param str zone: The URL of the zone. The zone must exist in the region where the managed instance group is located.
        """
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The URL of the zone. The zone must exist in the region where the managed instance group is located.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DurationResponse(dict):
    """
    A Duration represents a fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". Range is approximately 10,000 years.
    """
    def __init__(__self__, *,
                 nanos: int,
                 seconds: str):
        """
        A Duration represents a fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". Range is approximately 10,000 years.
        :param int nanos: Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
        :param str seconds: Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        """
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> str:
        """
        Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class ExternalVpnGatewayInterfaceResponse(dict):
    """
    The interface for the external VPN gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalVpnGatewayInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalVpnGatewayInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalVpnGatewayInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: str):
        """
        The interface for the external VPN gateway.
        :param str ip_address: IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.
        """
        pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class FileContentBufferResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileType":
            suggest = "file_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileContentBufferResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileContentBufferResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileContentBufferResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 file_type: str):
        """
        :param str content: The raw content in the secure keys file.
        :param str file_type: The file type of source file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "file_type", file_type)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The raw content in the secure keys file.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> str:
        """
        The file type of source file.
        """
        return pulumi.get(self, "file_type")


@pulumi.output_type
class FirewallAllowedItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipProtocol":
            suggest = "ip_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallAllowedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallAllowedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallAllowedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_protocol: str,
                 ports: Sequence[str]):
        """
        :param str ip_protocol: The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        :param Sequence[str] ports: An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> str:
        """
        The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[str]:
        """
        An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class FirewallDeniedItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipProtocol":
            suggest = "ip_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallDeniedItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallDeniedItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallDeniedItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_protocol: str,
                 ports: Sequence[str]):
        """
        :param str ip_protocol: The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        :param Sequence[str] ports: An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> str:
        """
        The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[str]:
        """
        An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class FirewallLogConfigResponse(dict):
    """
    The available logging options for a firewall rule.
    """
    def __init__(__self__, *,
                 enable: bool,
                 metadata: str):
        """
        The available logging options for a firewall rule.
        :param bool enable: This field denotes whether to enable logging for a particular firewall rule.
        :param str metadata: This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        This field denotes whether to enable logging for a particular firewall rule.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def metadata(self) -> str:
        """
        This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class FirewallPolicyAssociationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attachmentTarget":
            suggest = "attachment_target"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "firewallPolicyId":
            suggest = "firewall_policy_id"
        elif key == "shortName":
            suggest = "short_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyAssociationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyAssociationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyAssociationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attachment_target: str,
                 display_name: str,
                 firewall_policy_id: str,
                 name: str,
                 short_name: str):
        """
        :param str attachment_target: The target that the firewall policy is attached to.
        :param str display_name: Deprecated, please use short name instead. The display name of the firewall policy of the association.
        :param str firewall_policy_id: The firewall policy ID of the association.
        :param str name: The name for an association.
        :param str short_name: The short name of the firewall policy of the association.
        """
        pulumi.set(__self__, "attachment_target", attachment_target)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "firewall_policy_id", firewall_policy_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "short_name", short_name)

    @property
    @pulumi.getter(name="attachmentTarget")
    def attachment_target(self) -> str:
        """
        The target that the firewall policy is attached to.
        """
        return pulumi.get(self, "attachment_target")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Deprecated, please use short name instead. The display name of the firewall policy of the association.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> str:
        """
        The firewall policy ID of the association.
        """
        return pulumi.get(self, "firewall_policy_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name for an association.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> str:
        """
        The short name of the firewall policy of the association.
        """
        return pulumi.get(self, "short_name")


@pulumi.output_type
class FirewallPolicyRuleMatcherLayer4ConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipProtocol":
            suggest = "ip_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyRuleMatcherLayer4ConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyRuleMatcherLayer4ConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyRuleMatcherLayer4ConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_protocol: str,
                 ports: Sequence[str]):
        """
        :param str ip_protocol: The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
        :param Sequence[str] ports: An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> str:
        """
        The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[str]:
        """
        An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class FirewallPolicyRuleMatcherResponse(dict):
    """
    Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destIpRanges":
            suggest = "dest_ip_ranges"
        elif key == "layer4Configs":
            suggest = "layer4_configs"
        elif key == "srcIpRanges":
            suggest = "src_ip_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyRuleMatcherResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyRuleMatcherResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyRuleMatcherResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dest_ip_ranges: Sequence[str],
                 layer4_configs: Sequence['outputs.FirewallPolicyRuleMatcherLayer4ConfigResponse'],
                 src_ip_ranges: Sequence[str]):
        """
        Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
        :param Sequence[str] dest_ip_ranges: CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
        :param Sequence['FirewallPolicyRuleMatcherLayer4ConfigResponse'] layer4_configs: Pairs of IP protocols and ports that the rule should match.
        :param Sequence[str] src_ip_ranges: CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
        """
        pulumi.set(__self__, "dest_ip_ranges", dest_ip_ranges)
        pulumi.set(__self__, "layer4_configs", layer4_configs)
        pulumi.set(__self__, "src_ip_ranges", src_ip_ranges)

    @property
    @pulumi.getter(name="destIpRanges")
    def dest_ip_ranges(self) -> Sequence[str]:
        """
        CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
        """
        return pulumi.get(self, "dest_ip_ranges")

    @property
    @pulumi.getter(name="layer4Configs")
    def layer4_configs(self) -> Sequence['outputs.FirewallPolicyRuleMatcherLayer4ConfigResponse']:
        """
        Pairs of IP protocols and ports that the rule should match.
        """
        return pulumi.get(self, "layer4_configs")

    @property
    @pulumi.getter(name="srcIpRanges")
    def src_ip_ranges(self) -> Sequence[str]:
        """
        CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
        """
        return pulumi.get(self, "src_ip_ranges")


@pulumi.output_type
class FirewallPolicyRuleResponse(dict):
    """
    Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableLogging":
            suggest = "enable_logging"
        elif key == "ruleTupleCount":
            suggest = "rule_tuple_count"
        elif key == "targetResources":
            suggest = "target_resources"
        elif key == "targetServiceAccounts":
            suggest = "target_service_accounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 description: str,
                 direction: str,
                 disabled: bool,
                 enable_logging: bool,
                 kind: str,
                 match: 'outputs.FirewallPolicyRuleMatcherResponse',
                 priority: int,
                 rule_tuple_count: int,
                 target_resources: Sequence[str],
                 target_service_accounts: Sequence[str]):
        """
        Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
        :param str action: The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
        :param str description: An optional description for this resource.
        :param str direction: The direction in which this rule applies.
        :param bool disabled: Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        :param bool enable_logging: Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
        :param str kind: [Output only] Type of the resource. Always compute#firewallPolicyRule for firewall policy rules
        :param 'FirewallPolicyRuleMatcherResponse' match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        :param int priority: An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        :param int rule_tuple_count: Calculation of the complexity of a single firewall policy rule.
        :param Sequence[str] target_resources: A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
        :param Sequence[str] target_service_accounts: A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "enable_logging", enable_logging)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_tuple_count", rule_tuple_count)
        pulumi.set(__self__, "target_resources", target_resources)
        pulumi.set(__self__, "target_service_accounts", target_service_accounts)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction in which this rule applies.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> bool:
        """
        Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        [Output only] Type of the resource. Always compute#firewallPolicyRule for firewall policy rules
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def match(self) -> 'outputs.FirewallPolicyRuleMatcherResponse':
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> int:
        """
        Calculation of the complexity of a single firewall policy rule.
        """
        return pulumi.get(self, "rule_tuple_count")

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Sequence[str]:
        """
        A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
        """
        return pulumi.get(self, "target_resources")

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Sequence[str]:
        """
        A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        return pulumi.get(self, "target_service_accounts")


@pulumi.output_type
class FixedOrPercentResponse(dict):
    """
    Encapsulates numeric value that can be either absolute or relative.
    """
    def __init__(__self__, *,
                 calculated: int,
                 fixed: int,
                 percent: int):
        """
        Encapsulates numeric value that can be either absolute or relative.
        :param int calculated: Absolute value of VM instances calculated based on the specific mode. - If the value is fixed, then the calculated value is equal to the fixed value. - If the value is a percent, then the calculated value is percent/100 * targetSize. For example, the calculated value of a 80% of a managed instance group with 150 instances would be (80/100 * 150) = 120 VM instances. If there is a remainder, the number is rounded. 
        :param int fixed: Specifies a fixed number of VM instances. This must be a positive integer.
        :param int percent: Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
        """
        pulumi.set(__self__, "calculated", calculated)
        pulumi.set(__self__, "fixed", fixed)
        pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def calculated(self) -> int:
        """
        Absolute value of VM instances calculated based on the specific mode. - If the value is fixed, then the calculated value is equal to the fixed value. - If the value is a percent, then the calculated value is percent/100 * targetSize. For example, the calculated value of a 80% of a managed instance group with 150 instances would be (80/100 * 150) = 120 VM instances. If there is a remainder, the number is rounded. 
        """
        return pulumi.get(self, "calculated")

    @property
    @pulumi.getter
    def fixed(self) -> int:
        """
        Specifies a fixed number of VM instances. This must be a positive integer.
        """
        return pulumi.get(self, "fixed")

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class ForwardingRuleServiceDirectoryRegistrationResponse(dict):
    """
    Describes the auto-registration of the Forwarding Rule to Service Directory. The region and project of the Service Directory resource generated from this registration will be the same as this Forwarding Rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceDirectoryRegion":
            suggest = "service_directory_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardingRuleServiceDirectoryRegistrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardingRuleServiceDirectoryRegistrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardingRuleServiceDirectoryRegistrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: str,
                 service: str,
                 service_directory_region: str):
        """
        Describes the auto-registration of the Forwarding Rule to Service Directory. The region and project of the Service Directory resource generated from this registration will be the same as this Forwarding Rule.
        :param str namespace: Service Directory namespace to register the forwarding rule under.
        :param str service: Service Directory service to register the forwarding rule under.
        :param str service_directory_region: [Optional] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs Forwarding Rules on the same network should use the same Service Directory region.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "service_directory_region", service_directory_region)

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Service Directory namespace to register the forwarding rule under.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service Directory service to register the forwarding rule under.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceDirectoryRegion")
    def service_directory_region(self) -> str:
        """
        [Optional] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs Forwarding Rules on the same network should use the same Service Directory region.
        """
        return pulumi.get(self, "service_directory_region")


@pulumi.output_type
class GRPCHealthCheckResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "grpcServiceName":
            suggest = "grpc_service_name"
        elif key == "portName":
            suggest = "port_name"
        elif key == "portSpecification":
            suggest = "port_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GRPCHealthCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GRPCHealthCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GRPCHealthCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grpc_service_name: str,
                 port: int,
                 port_name: str,
                 port_specification: str):
        """
        :param str grpc_service_name: The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
        :param int port: The port number for the health check request. Must be specified if port_name and port_specification are not set or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
        :param str port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence. The port_name should conform to RFC1035.
        :param str port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, gRPC health check follows behavior specified in port and portName fields.
        """
        pulumi.set(__self__, "grpc_service_name", grpc_service_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_name", port_name)
        pulumi.set(__self__, "port_specification", port_specification)

    @property
    @pulumi.getter(name="grpcServiceName")
    def grpc_service_name(self) -> str:
        """
        The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
        """
        return pulumi.get(self, "grpc_service_name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number for the health check request. Must be specified if port_name and port_specification are not set or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> str:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence. The port_name should conform to RFC1035.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> str:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, gRPC health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")


@pulumi.output_type
class GuestOsFeatureResponse(dict):
    """
    Guest OS features.
    """
    def __init__(__self__, *,
                 type: str):
        """
        Guest OS features.
        :param str type: The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - SECURE_BOOT - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE For more information, see Enabling guest operating system features.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - SECURE_BOOT - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE For more information, see Enabling guest operating system features.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HTTP2HealthCheckResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"
        elif key == "portSpecification":
            suggest = "port_specification"
        elif key == "proxyHeader":
            suggest = "proxy_header"
        elif key == "requestPath":
            suggest = "request_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTP2HealthCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTP2HealthCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTP2HealthCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 port: int,
                 port_name: str,
                 port_specification: str,
                 proxy_header: str,
                 request_path: str,
                 response: str):
        """
        :param str host: The value of the host header in the HTTP/2 health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        :param int port: The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        :param str port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param str port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP2 health check follows behavior specified in port and portName fields.
        :param str proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param str request_path: The request path of the HTTP/2 health check request. The default value is /.
        :param str response: The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_name", port_name)
        pulumi.set(__self__, "port_specification", port_specification)
        pulumi.set(__self__, "proxy_header", proxy_header)
        pulumi.set(__self__, "request_path", request_path)
        pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The value of the host header in the HTTP/2 health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> str:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> str:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP2 health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> str:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> str:
        """
        The request path of the HTTP/2 health check request. The default value is /.
        """
        return pulumi.get(self, "request_path")

    @property
    @pulumi.getter
    def response(self) -> str:
        """
        The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class HTTPHealthCheckResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"
        elif key == "portSpecification":
            suggest = "port_specification"
        elif key == "proxyHeader":
            suggest = "proxy_header"
        elif key == "requestPath":
            suggest = "request_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPHealthCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPHealthCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPHealthCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 port: int,
                 port_name: str,
                 port_specification: str,
                 proxy_header: str,
                 request_path: str,
                 response: str):
        """
        :param str host: The value of the host header in the HTTP health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        :param int port: The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
        :param str port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param str port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP health check follows behavior specified in port and portName fields.
        :param str proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param str request_path: The request path of the HTTP health check request. The default value is /.
        :param str response: The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_name", port_name)
        pulumi.set(__self__, "port_specification", port_specification)
        pulumi.set(__self__, "proxy_header", proxy_header)
        pulumi.set(__self__, "request_path", request_path)
        pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The value of the host header in the HTTP health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> str:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> str:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTP health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> str:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> str:
        """
        The request path of the HTTP health check request. The default value is /.
        """
        return pulumi.get(self, "request_path")

    @property
    @pulumi.getter
    def response(self) -> str:
        """
        The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class HTTPSHealthCheckResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"
        elif key == "portSpecification":
            suggest = "port_specification"
        elif key == "proxyHeader":
            suggest = "proxy_header"
        elif key == "requestPath":
            suggest = "request_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPSHealthCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPSHealthCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPSHealthCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 port: int,
                 port_name: str,
                 port_specification: str,
                 proxy_header: str,
                 request_path: str,
                 response: str):
        """
        :param str host: The value of the host header in the HTTPS health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        :param int port: The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        :param str port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param str port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTPS health check follows behavior specified in port and portName fields.
        :param str proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param str request_path: The request path of the HTTPS health check request. The default value is /.
        :param str response: The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_name", port_name)
        pulumi.set(__self__, "port_specification", port_specification)
        pulumi.set(__self__, "proxy_header", proxy_header)
        pulumi.set(__self__, "request_path", request_path)
        pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The value of the host header in the HTTPS health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> str:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> str:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, HTTPS health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> str:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> str:
        """
        The request path of the HTTPS health check request. The default value is /.
        """
        return pulumi.get(self, "request_path")

    @property
    @pulumi.getter
    def response(self) -> str:
        """
        The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class HealthCheckLogConfigResponse(dict):
    """
    Configuration of logging on a health check. If logging is enabled, logs will be exported to Stackdriver.
    """
    def __init__(__self__, *,
                 enable: bool):
        """
        Configuration of logging on a health check. If logging is enabled, logs will be exported to Stackdriver.
        :param bool enable: Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.
        """
        pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.
        """
        return pulumi.get(self, "enable")


@pulumi.output_type
class HostRuleResponse(dict):
    """
    UrlMaps A host-matching rule for a URL. If matched, will use the named PathMatcher to select the BackendService.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathMatcher":
            suggest = "path_matcher"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 hosts: Sequence[str],
                 path_matcher: str):
        """
        UrlMaps A host-matching rule for a URL. If matched, will use the named PathMatcher to select the BackendService.
        :param str description: An optional description of this resource. Provide this property when you create the resource.
        :param Sequence[str] hosts: The list of host patterns to match. They must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in the pattern by either - or .. * based matching is not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        :param str path_matcher: The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "path_matcher", path_matcher)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def hosts(self) -> Sequence[str]:
        """
        The list of host patterns to match. They must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in the pattern by either - or .. * based matching is not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="pathMatcher")
    def path_matcher(self) -> str:
        """
        The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
        """
        return pulumi.get(self, "path_matcher")


@pulumi.output_type
class HttpFaultAbortResponse(dict):
    """
    Specification for how requests are aborted as part of fault injection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpStatus":
            suggest = "http_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpFaultAbortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpFaultAbortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpFaultAbortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_status: int,
                 percentage: float):
        """
        Specification for how requests are aborted as part of fault injection.
        :param int http_status: The HTTP status code used to abort the request. The value must be from 200 to 599 inclusive. For gRPC protocol, the gRPC status code is mapped to HTTP status code according to this mapping table. HTTP status 200 is mapped to gRPC status UNKNOWN. Injecting an OK status is currently not supported by Traffic Director.
        :param float percentage: The percentage of traffic for connections, operations, or requests that is aborted as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
        """
        pulumi.set(__self__, "http_status", http_status)
        pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="httpStatus")
    def http_status(self) -> int:
        """
        The HTTP status code used to abort the request. The value must be from 200 to 599 inclusive. For gRPC protocol, the gRPC status code is mapped to HTTP status code according to this mapping table. HTTP status 200 is mapped to gRPC status UNKNOWN. Injecting an OK status is currently not supported by Traffic Director.
        """
        return pulumi.get(self, "http_status")

    @property
    @pulumi.getter
    def percentage(self) -> float:
        """
        The percentage of traffic for connections, operations, or requests that is aborted as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class HttpFaultDelayResponse(dict):
    """
    Specifies the delay introduced by the load balancer before forwarding the request to the backend service as part of fault injection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedDelay":
            suggest = "fixed_delay"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpFaultDelayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpFaultDelayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpFaultDelayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_delay: 'outputs.DurationResponse',
                 percentage: float):
        """
        Specifies the delay introduced by the load balancer before forwarding the request to the backend service as part of fault injection.
        :param 'DurationResponse' fixed_delay: Specifies the value of the fixed delay interval.
        :param float percentage: The percentage of traffic for connections, operations, or requests for which a delay is introduced as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
        """
        pulumi.set(__self__, "fixed_delay", fixed_delay)
        pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="fixedDelay")
    def fixed_delay(self) -> 'outputs.DurationResponse':
        """
        Specifies the value of the fixed delay interval.
        """
        return pulumi.get(self, "fixed_delay")

    @property
    @pulumi.getter
    def percentage(self) -> float:
        """
        The percentage of traffic for connections, operations, or requests for which a delay is introduced as part of fault injection. The value must be from 0.0 to 100.0 inclusive.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class HttpFaultInjectionResponse(dict):
    """
    The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by the load balancer on a percentage of requests before sending those request to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests.
    """
    def __init__(__self__, *,
                 abort: 'outputs.HttpFaultAbortResponse',
                 delay: 'outputs.HttpFaultDelayResponse'):
        """
        The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by the load balancer on a percentage of requests before sending those request to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests.
        :param 'HttpFaultAbortResponse' abort: The specification for how client requests are aborted as part of fault injection.
        :param 'HttpFaultDelayResponse' delay: The specification for how client requests are delayed as part of fault injection, before being sent to a backend service.
        """
        pulumi.set(__self__, "abort", abort)
        pulumi.set(__self__, "delay", delay)

    @property
    @pulumi.getter
    def abort(self) -> 'outputs.HttpFaultAbortResponse':
        """
        The specification for how client requests are aborted as part of fault injection.
        """
        return pulumi.get(self, "abort")

    @property
    @pulumi.getter
    def delay(self) -> 'outputs.HttpFaultDelayResponse':
        """
        The specification for how client requests are delayed as part of fault injection, before being sent to a backend service.
        """
        return pulumi.get(self, "delay")


@pulumi.output_type
class HttpFilterConfigResponse(dict):
    """
    HttpFilterConfiguration supplies additional contextual settings for networkservices.HttpFilter resources enabled by Traffic Director.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configTypeUrl":
            suggest = "config_type_url"
        elif key == "filterName":
            suggest = "filter_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpFilterConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpFilterConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpFilterConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: str,
                 config_type_url: str,
                 filter_name: str):
        """
        HttpFilterConfiguration supplies additional contextual settings for networkservices.HttpFilter resources enabled by Traffic Director.
        :param str config: The configuration needed to enable the networkservices.HttpFilter resource. The configuration must be YAML formatted and only contain fields defined in the protobuf identified in configTypeUrl
        :param str config_type_url: The fully qualified versioned proto3 type url of the protobuf that the filter expects for its contextual settings, for example: type.googleapis.com/google.protobuf.Struct
        :param str filter_name: Name of the networkservices.HttpFilter resource this configuration belongs to. This name must be known to the xDS client. Example: envoy.wasm
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "config_type_url", config_type_url)
        pulumi.set(__self__, "filter_name", filter_name)

    @property
    @pulumi.getter
    def config(self) -> str:
        """
        The configuration needed to enable the networkservices.HttpFilter resource. The configuration must be YAML formatted and only contain fields defined in the protobuf identified in configTypeUrl
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="configTypeUrl")
    def config_type_url(self) -> str:
        """
        The fully qualified versioned proto3 type url of the protobuf that the filter expects for its contextual settings, for example: type.googleapis.com/google.protobuf.Struct
        """
        return pulumi.get(self, "config_type_url")

    @property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> str:
        """
        Name of the networkservices.HttpFilter resource this configuration belongs to. This name must be known to the xDS client. Example: envoy.wasm
        """
        return pulumi.get(self, "filter_name")


@pulumi.output_type
class HttpHeaderActionResponse(dict):
    """
    The request and response header transformations that take effect before the request is passed along to the selected backendService.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestHeadersToAdd":
            suggest = "request_headers_to_add"
        elif key == "requestHeadersToRemove":
            suggest = "request_headers_to_remove"
        elif key == "responseHeadersToAdd":
            suggest = "response_headers_to_add"
        elif key == "responseHeadersToRemove":
            suggest = "response_headers_to_remove"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpHeaderActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpHeaderActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpHeaderActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_headers_to_add: Sequence['outputs.HttpHeaderOptionResponse'],
                 request_headers_to_remove: Sequence[str],
                 response_headers_to_add: Sequence['outputs.HttpHeaderOptionResponse'],
                 response_headers_to_remove: Sequence[str]):
        """
        The request and response header transformations that take effect before the request is passed along to the selected backendService.
        :param Sequence['HttpHeaderOptionResponse'] request_headers_to_add: Headers to add to a matching request before forwarding the request to the backendService.
        :param Sequence[str] request_headers_to_remove: A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
        :param Sequence['HttpHeaderOptionResponse'] response_headers_to_add: Headers to add the response before sending the response back to the client.
        :param Sequence[str] response_headers_to_remove: A list of header names for headers that need to be removed from the response before sending the response back to the client.
        """
        pulumi.set(__self__, "request_headers_to_add", request_headers_to_add)
        pulumi.set(__self__, "request_headers_to_remove", request_headers_to_remove)
        pulumi.set(__self__, "response_headers_to_add", response_headers_to_add)
        pulumi.set(__self__, "response_headers_to_remove", response_headers_to_remove)

    @property
    @pulumi.getter(name="requestHeadersToAdd")
    def request_headers_to_add(self) -> Sequence['outputs.HttpHeaderOptionResponse']:
        """
        Headers to add to a matching request before forwarding the request to the backendService.
        """
        return pulumi.get(self, "request_headers_to_add")

    @property
    @pulumi.getter(name="requestHeadersToRemove")
    def request_headers_to_remove(self) -> Sequence[str]:
        """
        A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
        """
        return pulumi.get(self, "request_headers_to_remove")

    @property
    @pulumi.getter(name="responseHeadersToAdd")
    def response_headers_to_add(self) -> Sequence['outputs.HttpHeaderOptionResponse']:
        """
        Headers to add the response before sending the response back to the client.
        """
        return pulumi.get(self, "response_headers_to_add")

    @property
    @pulumi.getter(name="responseHeadersToRemove")
    def response_headers_to_remove(self) -> Sequence[str]:
        """
        A list of header names for headers that need to be removed from the response before sending the response back to the client.
        """
        return pulumi.get(self, "response_headers_to_remove")


@pulumi.output_type
class HttpHeaderMatchResponse(dict):
    """
    matchRule criteria for request header matches.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactMatch":
            suggest = "exact_match"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "invertMatch":
            suggest = "invert_match"
        elif key == "prefixMatch":
            suggest = "prefix_match"
        elif key == "presentMatch":
            suggest = "present_match"
        elif key == "rangeMatch":
            suggest = "range_match"
        elif key == "regexMatch":
            suggest = "regex_match"
        elif key == "suffixMatch":
            suggest = "suffix_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpHeaderMatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpHeaderMatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpHeaderMatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exact_match: str,
                 header_name: str,
                 invert_match: bool,
                 prefix_match: str,
                 present_match: bool,
                 range_match: 'outputs.Int64RangeMatchResponse',
                 regex_match: str,
                 suffix_match: str):
        """
        matchRule criteria for request header matches.
        :param str exact_match: The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        :param str header_name: The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method". When the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin`.
        :param bool invert_match: If set to false, the headerMatch is considered a match if the preceding match criteria are met. If set to true, the headerMatch is considered a match if the preceding match criteria are NOT met. The default setting is false. 
        :param str prefix_match: The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        :param bool present_match: A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        :param 'Int64RangeMatchResponse' range_match: The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. rangeMatch is not supported for load balancers that have loadBalancingScheme set to EXTERNAL.
        :param str regex_match: The value of the header must match the regular expression specified in regexMatch. For more information about regular expression syntax, see Syntax. For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        :param str suffix_match: The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        pulumi.set(__self__, "exact_match", exact_match)
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "invert_match", invert_match)
        pulumi.set(__self__, "prefix_match", prefix_match)
        pulumi.set(__self__, "present_match", present_match)
        pulumi.set(__self__, "range_match", range_match)
        pulumi.set(__self__, "regex_match", regex_match)
        pulumi.set(__self__, "suffix_match", suffix_match)

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> str:
        """
        The value should exactly match contents of exactMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method". When the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true, only non-binary user-specified custom metadata and the `content-type` header are supported. The following transport-level headers cannot be used in header matching rules: `:authority`, `:method`, `:path`, `:scheme`, `user-agent`, `accept-encoding`, `content-encoding`, `grpc-accept-encoding`, `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and `grpc-trace-bin`.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="invertMatch")
    def invert_match(self) -> bool:
        """
        If set to false, the headerMatch is considered a match if the preceding match criteria are met. If set to true, the headerMatch is considered a match if the preceding match criteria are NOT met. The default setting is false. 
        """
        return pulumi.get(self, "invert_match")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> str:
        """
        The value of the header must start with the contents of prefixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        return pulumi.get(self, "prefix_match")

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> bool:
        """
        A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        return pulumi.get(self, "present_match")

    @property
    @pulumi.getter(name="rangeMatch")
    def range_match(self) -> 'outputs.Int64RangeMatchResponse':
        """
        The header value must be an integer and its value must be in the range specified in rangeMatch. If the header does not contain an integer, number or is empty, the match fails. For example for a range [-5, 0] - -3 will match. - 0 will not match. - 0.25 will not match. - -3someString will not match. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. rangeMatch is not supported for load balancers that have loadBalancingScheme set to EXTERNAL.
        """
        return pulumi.get(self, "range_match")

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> str:
        """
        The value of the header must match the regular expression specified in regexMatch. For more information about regular expression syntax, see Syntax. For matching against a port specified in the HTTP request, use a headerMatch with headerName set to PORT and a regular expression that satisfies the RFC2616 Host header's port specifier. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "regex_match")

    @property
    @pulumi.getter(name="suffixMatch")
    def suffix_match(self) -> str:
        """
        The value of the header must end with the contents of suffixMatch. Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
        """
        return pulumi.get(self, "suffix_match")


@pulumi.output_type
class HttpHeaderOptionResponse(dict):
    """
    Specification determining how headers are added to requests or responses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpHeaderOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpHeaderOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpHeaderOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str,
                 header_value: str,
                 replace: bool):
        """
        Specification determining how headers are added to requests or responses.
        :param str header_name: The name of the header.
        :param str header_value: The value of the header to add.
        :param bool replace: If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header. The default value is false. 
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)
        pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        The name of the header.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> str:
        """
        The value of the header to add.
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter
    def replace(self) -> bool:
        """
        If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header. The default value is false. 
        """
        return pulumi.get(self, "replace")


@pulumi.output_type
class HttpQueryParameterMatchResponse(dict):
    """
    HttpRouteRuleMatch criteria for a request's query parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactMatch":
            suggest = "exact_match"
        elif key == "presentMatch":
            suggest = "present_match"
        elif key == "regexMatch":
            suggest = "regex_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpQueryParameterMatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpQueryParameterMatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpQueryParameterMatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exact_match: str,
                 name: str,
                 present_match: bool,
                 regex_match: str):
        """
        HttpRouteRuleMatch criteria for a request's query parameter.
        :param str exact_match: The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch. Only one of presentMatch, exactMatch, or regexMatch must be set. 
        :param str name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param bool present_match: Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch, or regexMatch must be set. 
        :param str regex_match: The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch. For more information about regular expression syntax, see Syntax. Only one of presentMatch, exactMatch, or regexMatch must be set. regexMatch only applies when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED. 
        """
        pulumi.set(__self__, "exact_match", exact_match)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "present_match", present_match)
        pulumi.set(__self__, "regex_match", regex_match)

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> str:
        """
        The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch. Only one of presentMatch, exactMatch, or regexMatch must be set. 
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> bool:
        """
        Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not. Only one of presentMatch, exactMatch, or regexMatch must be set. 
        """
        return pulumi.get(self, "present_match")

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> str:
        """
        The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch. For more information about regular expression syntax, see Syntax. Only one of presentMatch, exactMatch, or regexMatch must be set. regexMatch only applies when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED. 
        """
        return pulumi.get(self, "regex_match")


@pulumi.output_type
class HttpRedirectActionResponse(dict):
    """
    Specifies settings for an HTTP redirect.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRedirect":
            suggest = "host_redirect"
        elif key == "httpsRedirect":
            suggest = "https_redirect"
        elif key == "pathRedirect":
            suggest = "path_redirect"
        elif key == "prefixRedirect":
            suggest = "prefix_redirect"
        elif key == "redirectResponseCode":
            suggest = "redirect_response_code"
        elif key == "stripQuery":
            suggest = "strip_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRedirectActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRedirectActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRedirectActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_redirect: str,
                 https_redirect: bool,
                 path_redirect: str,
                 prefix_redirect: str,
                 redirect_response_code: str,
                 strip_query: bool):
        """
        Specifies settings for an HTTP redirect.
        :param str host_redirect: The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
        :param bool https_redirect: If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
        :param str path_redirect: The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
        :param str prefix_redirect: The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
        :param str redirect_response_code: The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained. 
        :param bool strip_query: If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false. 
        """
        pulumi.set(__self__, "host_redirect", host_redirect)
        pulumi.set(__self__, "https_redirect", https_redirect)
        pulumi.set(__self__, "path_redirect", path_redirect)
        pulumi.set(__self__, "prefix_redirect", prefix_redirect)
        pulumi.set(__self__, "redirect_response_code", redirect_response_code)
        pulumi.set(__self__, "strip_query", strip_query)

    @property
    @pulumi.getter(name="hostRedirect")
    def host_redirect(self) -> str:
        """
        The host that is used in the redirect response instead of the one that was supplied in the request. The value must be from 1 to 255 characters.
        """
        return pulumi.get(self, "host_redirect")

    @property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> bool:
        """
        If set to true, the URL scheme in the redirected request is set to HTTPS. If set to false, the URL scheme of the redirected request remains the same as that of the request. This must only be set for URL maps used in TargetHttpProxys. Setting this true for TargetHttpsProxy is not permitted. The default is set to false.
        """
        return pulumi.get(self, "https_redirect")

    @property
    @pulumi.getter(name="pathRedirect")
    def path_redirect(self) -> str:
        """
        The path that is used in the redirect response instead of the one that was supplied in the request. pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
        """
        return pulumi.get(self, "path_redirect")

    @property
    @pulumi.getter(name="prefixRedirect")
    def prefix_redirect(self) -> str:
        """
        The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request. prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request is used for the redirect. The value must be from 1 to 1024 characters.
        """
        return pulumi.get(self, "prefix_redirect")

    @property
    @pulumi.getter(name="redirectResponseCode")
    def redirect_response_code(self) -> str:
        """
        The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained. 
        """
        return pulumi.get(self, "redirect_response_code")

    @property
    @pulumi.getter(name="stripQuery")
    def strip_query(self) -> bool:
        """
        If set to true, any accompanying query portion of the original URL is removed before redirecting the request. If set to false, the query portion of the original URL is retained. The default is set to false. 
        """
        return pulumi.get(self, "strip_query")


@pulumi.output_type
class HttpRetryPolicyResponse(dict):
    """
    The retry policy associates with HttpRouteRule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numRetries":
            suggest = "num_retries"
        elif key == "perTryTimeout":
            suggest = "per_try_timeout"
        elif key == "retryConditions":
            suggest = "retry_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRetryPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRetryPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRetryPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_retries: int,
                 per_try_timeout: 'outputs.DurationResponse',
                 retry_conditions: Sequence[str]):
        """
        The retry policy associates with HttpRouteRule
        :param int num_retries: Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
        :param 'DurationResponse' per_try_timeout: Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        :param Sequence[str] retry_conditions: Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable 
        """
        pulumi.set(__self__, "num_retries", num_retries)
        pulumi.set(__self__, "per_try_timeout", per_try_timeout)
        pulumi.set(__self__, "retry_conditions", retry_conditions)

    @property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> int:
        """
        Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
        """
        return pulumi.get(self, "num_retries")

    @property
    @pulumi.getter(name="perTryTimeout")
    def per_try_timeout(self) -> 'outputs.DurationResponse':
        """
        Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        """
        return pulumi.get(self, "per_try_timeout")

    @property
    @pulumi.getter(name="retryConditions")
    def retry_conditions(self) -> Sequence[str]:
        """
        Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable 
        """
        return pulumi.get(self, "retry_conditions")


@pulumi.output_type
class HttpRouteActionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsPolicy":
            suggest = "cors_policy"
        elif key == "faultInjectionPolicy":
            suggest = "fault_injection_policy"
        elif key == "maxStreamDuration":
            suggest = "max_stream_duration"
        elif key == "requestMirrorPolicy":
            suggest = "request_mirror_policy"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "urlRewrite":
            suggest = "url_rewrite"
        elif key == "weightedBackendServices":
            suggest = "weighted_backend_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cors_policy: 'outputs.CorsPolicyResponse',
                 fault_injection_policy: 'outputs.HttpFaultInjectionResponse',
                 max_stream_duration: 'outputs.DurationResponse',
                 request_mirror_policy: 'outputs.RequestMirrorPolicyResponse',
                 retry_policy: 'outputs.HttpRetryPolicyResponse',
                 timeout: 'outputs.DurationResponse',
                 url_rewrite: 'outputs.UrlRewriteResponse',
                 weighted_backend_services: Sequence['outputs.WeightedBackendServiceResponse']):
        """
        :param 'CorsPolicyResponse' cors_policy: The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
        :param 'HttpFaultInjectionResponse' fault_injection_policy: The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. For the requests impacted by fault injection, timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy.
        :param 'DurationResponse' max_stream_duration: Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        :param 'RequestMirrorPolicyResponse' request_mirror_policy: Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        :param 'HttpRetryPolicyResponse' retry_policy: Specifies the retry policy associated with this route.
        :param 'DurationResponse' timeout: Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param 'UrlRewriteResponse' url_rewrite: The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for external HTTP(S) load balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        :param Sequence['WeightedBackendServiceResponse'] weighted_backend_services: A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
        """
        pulumi.set(__self__, "cors_policy", cors_policy)
        pulumi.set(__self__, "fault_injection_policy", fault_injection_policy)
        pulumi.set(__self__, "max_stream_duration", max_stream_duration)
        pulumi.set(__self__, "request_mirror_policy", request_mirror_policy)
        pulumi.set(__self__, "retry_policy", retry_policy)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "url_rewrite", url_rewrite)
        pulumi.set(__self__, "weighted_backend_services", weighted_backend_services)

    @property
    @pulumi.getter(name="corsPolicy")
    def cors_policy(self) -> 'outputs.CorsPolicyResponse':
        """
        The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "cors_policy")

    @property
    @pulumi.getter(name="faultInjectionPolicy")
    def fault_injection_policy(self) -> 'outputs.HttpFaultInjectionResponse':
        """
        The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by a load balancer on a percentage of requests before sending those requests to the backend service. Similarly requests from clients can be aborted by the load balancer for a percentage of requests. For the requests impacted by fault injection, timeout and retry_policy is ignored by clients that are configured with a fault_injection_policy.
        """
        return pulumi.get(self, "fault_injection_policy")

    @property
    @pulumi.getter(name="maxStreamDuration")
    def max_stream_duration(self) -> 'outputs.DurationResponse':
        """
        Specifies the maximum duration (timeout) for streams on the selected route. Unlike the timeout field where the timeout duration starts from the time the request has been fully processed (known as *end-of-stream*), the duration in this field is computed from the beginning of the stream until the response has been processed, including all retries. A stream that does not complete in this duration is closed. If not specified, this field uses the maximum maxStreamDuration value among all backend services associated with the route. This field is only allowed if the Url map is used with backend services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "max_stream_duration")

    @property
    @pulumi.getter(name="requestMirrorPolicy")
    def request_mirror_policy(self) -> 'outputs.RequestMirrorPolicyResponse':
        """
        Specifies the policy on how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer does not wait for responses from the shadow service. Before sending traffic to the shadow service, the host / authority header is suffixed with -shadow. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        """
        return pulumi.get(self, "request_mirror_policy")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> 'outputs.HttpRetryPolicyResponse':
        """
        Specifies the retry policy associated with this route.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter
    def timeout(self) -> 'outputs.DurationResponse':
        """
        Specifies the timeout for the selected route. Timeout is computed from the time the request has been fully processed (known as *end-of-stream*) up until the response has been processed. Timeout includes all retries. If not specified, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="urlRewrite")
    def url_rewrite(self) -> 'outputs.UrlRewriteResponse':
        """
        The spec to modify the URL of the request, before forwarding the request to the matched service. urlRewrite is the only action supported in UrlMaps for external HTTP(S) load balancers. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        """
        return pulumi.get(self, "url_rewrite")

    @property
    @pulumi.getter(name="weightedBackendServices")
    def weighted_backend_services(self) -> Sequence['outputs.WeightedBackendServiceResponse']:
        """
        A list of weighted backend services to send traffic to when a route match occurs. The weights determine the fraction of traffic that flows to their corresponding backend service. If all traffic needs to go to a single backend service, there must be one weightedBackendService with weight set to a non-zero number. After a backend service is identified and before forwarding the request to the backend service, advanced routing actions such as URL rewrites and header transformations are applied depending on additional settings specified in this HttpRouteAction.
        """
        return pulumi.get(self, "weighted_backend_services")


@pulumi.output_type
class HttpRouteRuleMatchResponse(dict):
    """
    HttpRouteRuleMatch specifies a set of criteria for matching requests to an HttpRouteRule. All specified criteria must be satisfied for a match to occur.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullPathMatch":
            suggest = "full_path_match"
        elif key == "headerMatches":
            suggest = "header_matches"
        elif key == "ignoreCase":
            suggest = "ignore_case"
        elif key == "metadataFilters":
            suggest = "metadata_filters"
        elif key == "prefixMatch":
            suggest = "prefix_match"
        elif key == "queryParameterMatches":
            suggest = "query_parameter_matches"
        elif key == "regexMatch":
            suggest = "regex_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleMatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleMatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleMatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 full_path_match: str,
                 header_matches: Sequence['outputs.HttpHeaderMatchResponse'],
                 ignore_case: bool,
                 metadata_filters: Sequence['outputs.MetadataFilterResponse'],
                 prefix_match: str,
                 query_parameter_matches: Sequence['outputs.HttpQueryParameterMatchResponse'],
                 regex_match: str):
        """
        HttpRouteRuleMatch specifies a set of criteria for matching requests to an HttpRouteRule. All specified criteria must be satisfied for a match to occur.
        :param str full_path_match: For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        :param Sequence['HttpHeaderMatchResponse'] header_matches: Specifies a list of header match criteria, all of which must match corresponding headers in the request.
        :param bool ignore_case: Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
        :param Sequence['MetadataFilterResponse'] metadata_filters: Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param str prefix_match: For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        :param Sequence['HttpQueryParameterMatchResponse'] query_parameter_matches: Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
        :param str regex_match: For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        pulumi.set(__self__, "full_path_match", full_path_match)
        pulumi.set(__self__, "header_matches", header_matches)
        pulumi.set(__self__, "ignore_case", ignore_case)
        pulumi.set(__self__, "metadata_filters", metadata_filters)
        pulumi.set(__self__, "prefix_match", prefix_match)
        pulumi.set(__self__, "query_parameter_matches", query_parameter_matches)
        pulumi.set(__self__, "regex_match", regex_match)

    @property
    @pulumi.getter(name="fullPathMatch")
    def full_path_match(self) -> str:
        """
        For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        """
        return pulumi.get(self, "full_path_match")

    @property
    @pulumi.getter(name="headerMatches")
    def header_matches(self) -> Sequence['outputs.HttpHeaderMatchResponse']:
        """
        Specifies a list of header match criteria, all of which must match corresponding headers in the request.
        """
        return pulumi.get(self, "header_matches")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> bool:
        """
        Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter(name="metadataFilters")
    def metadata_filters(self) -> Sequence['outputs.MetadataFilterResponse']:
        """
        Opaque filter criteria used by the load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present node metadata. When there is a match, the relevant routing configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadata filters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here is applied after those specified in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "metadata_filters")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> str:
        """
        For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        """
        return pulumi.get(self, "prefix_match")

    @property
    @pulumi.getter(name="queryParameterMatches")
    def query_parameter_matches(self) -> Sequence['outputs.HttpQueryParameterMatchResponse']:
        """
        Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "query_parameter_matches")

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> str:
        """
        For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL. For more information about regular expression syntax, see Syntax. Only one of prefixMatch, fullPathMatch or regexMatch must be specified. regexMatch only applies to load balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "regex_match")


@pulumi.output_type
class HttpRouteRuleResponse(dict):
    """
    The HttpRouteRule setting specifies how to match an HTTP request and the corresponding routing action that load balancing proxies perform.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerAction":
            suggest = "header_action"
        elif key == "httpFilterConfigs":
            suggest = "http_filter_configs"
        elif key == "httpFilterMetadata":
            suggest = "http_filter_metadata"
        elif key == "matchRules":
            suggest = "match_rules"
        elif key == "routeAction":
            suggest = "route_action"
        elif key == "urlRedirect":
            suggest = "url_redirect"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 header_action: 'outputs.HttpHeaderActionResponse',
                 http_filter_configs: Sequence['outputs.HttpFilterConfigResponse'],
                 http_filter_metadata: Sequence['outputs.HttpFilterConfigResponse'],
                 match_rules: Sequence['outputs.HttpRouteRuleMatchResponse'],
                 priority: int,
                 route_action: 'outputs.HttpRouteActionResponse',
                 service: str,
                 url_redirect: 'outputs.HttpRedirectActionResponse'):
        """
        The HttpRouteRule setting specifies how to match an HTTP request and the corresponding routing action that load balancing proxies perform.
        :param str description: The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
        :param 'HttpHeaderActionResponse' header_action: Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param Sequence['HttpFilterConfigResponse'] http_filter_configs: Outbound route specific configuration for networkservices.HttpFilter resources enabled by Traffic Director. httpFilterConfigs only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param Sequence['HttpFilterConfigResponse'] http_filter_metadata: Outbound route specific metadata supplied to networkservices.HttpFilter resources enabled by Traffic Director. httpFilterMetadata only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. The only configTypeUrl supported is type.googleapis.com/google.protobuf.Struct Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param Sequence['HttpRouteRuleMatchResponse'] match_rules: The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
        :param int priority: For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        :param 'HttpRouteActionResponse' route_action: In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a route rule's routeAction.
        :param str service: The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
        :param 'HttpRedirectActionResponse' url_redirect: When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "header_action", header_action)
        pulumi.set(__self__, "http_filter_configs", http_filter_configs)
        pulumi.set(__self__, "http_filter_metadata", http_filter_metadata)
        pulumi.set(__self__, "match_rules", match_rules)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "route_action", route_action)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "url_redirect", url_redirect)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> 'outputs.HttpHeaderActionResponse':
        """
        Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter(name="httpFilterConfigs")
    def http_filter_configs(self) -> Sequence['outputs.HttpFilterConfigResponse']:
        """
        Outbound route specific configuration for networkservices.HttpFilter resources enabled by Traffic Director. httpFilterConfigs only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "http_filter_configs")

    @property
    @pulumi.getter(name="httpFilterMetadata")
    def http_filter_metadata(self) -> Sequence['outputs.HttpFilterConfigResponse']:
        """
        Outbound route specific metadata supplied to networkservices.HttpFilter resources enabled by Traffic Director. httpFilterMetadata only applies for load balancers with loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details. The only configTypeUrl supported is type.googleapis.com/google.protobuf.Struct Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "http_filter_metadata")

    @property
    @pulumi.getter(name="matchRules")
    def match_rules(self) -> Sequence['outputs.HttpRouteRuleMatchResponse']:
        """
        The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
        """
        return pulumi.get(self, "match_rules")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="routeAction")
    def route_action(self) -> 'outputs.HttpRouteActionResponse':
        """
        In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a route rule's routeAction.
        """
        return pulumi.get(self, "route_action")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="urlRedirect")
    def url_redirect(self) -> 'outputs.HttpRedirectActionResponse':
        """
        When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "url_redirect")


@pulumi.output_type
class ImageRawDiskResponse(dict):
    """
    The parameters of the raw disk image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerType":
            suggest = "container_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRawDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRawDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRawDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_type: str,
                 source: str):
        """
        The parameters of the raw disk image.
        :param str container_type: The format used to encode and transmit the block device, which should be TAR. This is just a container and transmission format and not a runtime format. Provided by the client when the disk image is created.
        :param str source: The full Google Cloud Storage URL where the raw disk image archive is stored. The following are valid formats for the URL: - https://storage.googleapis.com/bucket_name/image_archive_name - https://storage.googleapis.com/bucket_name/folder_name/ image_archive_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL 
        """
        pulumi.set(__self__, "container_type", container_type)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> str:
        """
        The format used to encode and transmit the block device, which should be TAR. This is just a container and transmission format and not a runtime format. Provided by the client when the disk image is created.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The full Google Cloud Storage URL where the raw disk image archive is stored. The following are valid formats for the URL: - https://storage.googleapis.com/bucket_name/image_archive_name - https://storage.googleapis.com/bucket_name/folder_name/ image_archive_name In order to create an image, you must provide the full or partial URL of one of the following: - The rawDisk.source URL - The sourceDisk URL - The sourceImage URL - The sourceSnapshot URL 
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class InitialStateConfigResponse(dict):
    """
    Initial State for shielded instance, these are public keys which are safe to store in public
    """
    def __init__(__self__, *,
                 dbs: Sequence['outputs.FileContentBufferResponse'],
                 dbxs: Sequence['outputs.FileContentBufferResponse'],
                 keks: Sequence['outputs.FileContentBufferResponse'],
                 pk: 'outputs.FileContentBufferResponse'):
        """
        Initial State for shielded instance, these are public keys which are safe to store in public
        :param Sequence['FileContentBufferResponse'] dbs: The Key Database (db).
        :param Sequence['FileContentBufferResponse'] dbxs: The forbidden key database (dbx).
        :param Sequence['FileContentBufferResponse'] keks: The Key Exchange Key (KEK).
        :param 'FileContentBufferResponse' pk: The Platform Key (PK).
        """
        pulumi.set(__self__, "dbs", dbs)
        pulumi.set(__self__, "dbxs", dbxs)
        pulumi.set(__self__, "keks", keks)
        pulumi.set(__self__, "pk", pk)

    @property
    @pulumi.getter
    def dbs(self) -> Sequence['outputs.FileContentBufferResponse']:
        """
        The Key Database (db).
        """
        return pulumi.get(self, "dbs")

    @property
    @pulumi.getter
    def dbxs(self) -> Sequence['outputs.FileContentBufferResponse']:
        """
        The forbidden key database (dbx).
        """
        return pulumi.get(self, "dbxs")

    @property
    @pulumi.getter
    def keks(self) -> Sequence['outputs.FileContentBufferResponse']:
        """
        The Key Exchange Key (KEK).
        """
        return pulumi.get(self, "keks")

    @property
    @pulumi.getter
    def pk(self) -> 'outputs.FileContentBufferResponse':
        """
        The Platform Key (PK).
        """
        return pulumi.get(self, "pk")


@pulumi.output_type
class InstanceGroupManagerActionsSummaryResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creatingWithoutRetries":
            suggest = "creating_without_retries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupManagerActionsSummaryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupManagerActionsSummaryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupManagerActionsSummaryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 abandoning: int,
                 creating: int,
                 creating_without_retries: int,
                 deleting: int,
                 none: int,
                 recreating: int,
                 refreshing: int,
                 restarting: int,
                 resuming: int,
                 starting: int,
                 stopping: int,
                 suspending: int,
                 verifying: int):
        """
        :param int abandoning: The total number of instances in the managed instance group that are scheduled to be abandoned. Abandoning an instance removes it from the managed instance group without deleting it.
        :param int creating: The number of instances in the managed instance group that are scheduled to be created or are currently being created. If the group fails to create any of these instances, it tries again until it creates the instance successfully. If you have disabled creation retries, this field will not be populated; instead, the creatingWithoutRetries field will be populated.
        :param int creating_without_retries: The number of instances that the managed instance group will attempt to create. The group attempts to create each instance only once. If the group fails to create any of these instances, it decreases the group's targetSize value accordingly.
        :param int deleting: The number of instances in the managed instance group that are scheduled to be deleted or are currently being deleted.
        :param int none: The number of instances in the managed instance group that are running and have no scheduled actions.
        :param int recreating: The number of instances in the managed instance group that are scheduled to be recreated or are currently being being recreated. Recreating an instance deletes the existing root persistent disk and creates a new disk from the image that is defined in the instance template.
        :param int refreshing: The number of instances in the managed instance group that are being reconfigured with properties that do not require a restart or a recreate action. For example, setting or removing target pools for the instance.
        :param int restarting: The number of instances in the managed instance group that are scheduled to be restarted or are currently being restarted.
        :param int resuming: The number of instances in the managed instance group that are scheduled to be resumed or are currently being resumed.
        :param int starting: The number of instances in the managed instance group that are scheduled to be started or are currently being started.
        :param int stopping: The number of instances in the managed instance group that are scheduled to be stopped or are currently being stopped.
        :param int suspending: The number of instances in the managed instance group that are scheduled to be suspended or are currently being suspended.
        :param int verifying: The number of instances in the managed instance group that are being verified. See the managedInstances[].currentAction property in the listManagedInstances method documentation.
        """
        pulumi.set(__self__, "abandoning", abandoning)
        pulumi.set(__self__, "creating", creating)
        pulumi.set(__self__, "creating_without_retries", creating_without_retries)
        pulumi.set(__self__, "deleting", deleting)
        pulumi.set(__self__, "none", none)
        pulumi.set(__self__, "recreating", recreating)
        pulumi.set(__self__, "refreshing", refreshing)
        pulumi.set(__self__, "restarting", restarting)
        pulumi.set(__self__, "resuming", resuming)
        pulumi.set(__self__, "starting", starting)
        pulumi.set(__self__, "stopping", stopping)
        pulumi.set(__self__, "suspending", suspending)
        pulumi.set(__self__, "verifying", verifying)

    @property
    @pulumi.getter
    def abandoning(self) -> int:
        """
        The total number of instances in the managed instance group that are scheduled to be abandoned. Abandoning an instance removes it from the managed instance group without deleting it.
        """
        return pulumi.get(self, "abandoning")

    @property
    @pulumi.getter
    def creating(self) -> int:
        """
        The number of instances in the managed instance group that are scheduled to be created or are currently being created. If the group fails to create any of these instances, it tries again until it creates the instance successfully. If you have disabled creation retries, this field will not be populated; instead, the creatingWithoutRetries field will be populated.
        """
        return pulumi.get(self, "creating")

    @property
    @pulumi.getter(name="creatingWithoutRetries")
    def creating_without_retries(self) -> int:
        """
        The number of instances that the managed instance group will attempt to create. The group attempts to create each instance only once. If the group fails to create any of these instances, it decreases the group's targetSize value accordingly.
        """
        return pulumi.get(self, "creating_without_retries")

    @property
    @pulumi.getter
    def deleting(self) -> int:
        """
        The number of instances in the managed instance group that are scheduled to be deleted or are currently being deleted.
        """
        return pulumi.get(self, "deleting")

    @property
    @pulumi.getter
    def none(self) -> int:
        """
        The number of instances in the managed instance group that are running and have no scheduled actions.
        """
        return pulumi.get(self, "none")

    @property
    @pulumi.getter
    def recreating(self) -> int:
        """
        The number of instances in the managed instance group that are scheduled to be recreated or are currently being being recreated. Recreating an instance deletes the existing root persistent disk and creates a new disk from the image that is defined in the instance template.
        """
        return pulumi.get(self, "recreating")

    @property
    @pulumi.getter
    def refreshing(self) -> int:
        """
        The number of instances in the managed instance group that are being reconfigured with properties that do not require a restart or a recreate action. For example, setting or removing target pools for the instance.
        """
        return pulumi.get(self, "refreshing")

    @property
    @pulumi.getter
    def restarting(self) -> int:
        """
        The number of instances in the managed instance group that are scheduled to be restarted or are currently being restarted.
        """
        return pulumi.get(self, "restarting")

    @property
    @pulumi.getter
    def resuming(self) -> int:
        """
        The number of instances in the managed instance group that are scheduled to be resumed or are currently being resumed.
        """
        return pulumi.get(self, "resuming")

    @property
    @pulumi.getter
    def starting(self) -> int:
        """
        The number of instances in the managed instance group that are scheduled to be started or are currently being started.
        """
        return pulumi.get(self, "starting")

    @property
    @pulumi.getter
    def stopping(self) -> int:
        """
        The number of instances in the managed instance group that are scheduled to be stopped or are currently being stopped.
        """
        return pulumi.get(self, "stopping")

    @property
    @pulumi.getter
    def suspending(self) -> int:
        """
        The number of instances in the managed instance group that are scheduled to be suspended or are currently being suspended.
        """
        return pulumi.get(self, "suspending")

    @property
    @pulumi.getter
    def verifying(self) -> int:
        """
        The number of instances in the managed instance group that are being verified. See the managedInstances[].currentAction property in the listManagedInstances method documentation.
        """
        return pulumi.get(self, "verifying")


@pulumi.output_type
class InstanceGroupManagerAutoHealingPolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheck":
            suggest = "health_check"
        elif key == "initialDelaySec":
            suggest = "initial_delay_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupManagerAutoHealingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupManagerAutoHealingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupManagerAutoHealingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check: str,
                 initial_delay_sec: int):
        """
        :param str health_check: The URL for the health check that signals autohealing.
        :param int initial_delay_sec: The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. This initial delay allows instances to initialize and run their startup scripts before the instance group determines that they are UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely. This value must be from range [0, 3600].
        """
        pulumi.set(__self__, "health_check", health_check)
        pulumi.set(__self__, "initial_delay_sec", initial_delay_sec)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> str:
        """
        The URL for the health check that signals autohealing.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="initialDelaySec")
    def initial_delay_sec(self) -> int:
        """
        The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. This initial delay allows instances to initialize and run their startup scripts before the instance group determines that they are UNHEALTHY. This prevents the managed instance group from recreating its instances prematurely. This value must be from range [0, 3600].
        """
        return pulumi.get(self, "initial_delay_sec")


@pulumi.output_type
class InstanceGroupManagerStatusResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isStable":
            suggest = "is_stable"
        elif key == "versionTarget":
            suggest = "version_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupManagerStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupManagerStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupManagerStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaler: str,
                 is_stable: bool,
                 stateful: 'outputs.InstanceGroupManagerStatusStatefulResponse',
                 version_target: 'outputs.InstanceGroupManagerStatusVersionTargetResponse'):
        """
        :param str autoscaler: The URL of the Autoscaler that targets this instance group manager.
        :param bool is_stable: A bit indicating whether the managed instance group is in a stable state. A stable state means that: none of the instances in the managed instance group is currently undergoing any type of change (for example, creation, restart, or deletion); no future changes are scheduled for instances in the managed instance group; and the managed instance group itself is not being modified.
        :param 'InstanceGroupManagerStatusStatefulResponse' stateful: Stateful status of the given Instance Group Manager.
        :param 'InstanceGroupManagerStatusVersionTargetResponse' version_target: A status of consistency of Instances' versions with their target version specified by version field on Instance Group Manager.
        """
        pulumi.set(__self__, "autoscaler", autoscaler)
        pulumi.set(__self__, "is_stable", is_stable)
        pulumi.set(__self__, "stateful", stateful)
        pulumi.set(__self__, "version_target", version_target)

    @property
    @pulumi.getter
    def autoscaler(self) -> str:
        """
        The URL of the Autoscaler that targets this instance group manager.
        """
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter(name="isStable")
    def is_stable(self) -> bool:
        """
        A bit indicating whether the managed instance group is in a stable state. A stable state means that: none of the instances in the managed instance group is currently undergoing any type of change (for example, creation, restart, or deletion); no future changes are scheduled for instances in the managed instance group; and the managed instance group itself is not being modified.
        """
        return pulumi.get(self, "is_stable")

    @property
    @pulumi.getter
    def stateful(self) -> 'outputs.InstanceGroupManagerStatusStatefulResponse':
        """
        Stateful status of the given Instance Group Manager.
        """
        return pulumi.get(self, "stateful")

    @property
    @pulumi.getter(name="versionTarget")
    def version_target(self) -> 'outputs.InstanceGroupManagerStatusVersionTargetResponse':
        """
        A status of consistency of Instances' versions with their target version specified by version field on Instance Group Manager.
        """
        return pulumi.get(self, "version_target")


@pulumi.output_type
class InstanceGroupManagerStatusStatefulPerInstanceConfigsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allEffective":
            suggest = "all_effective"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupManagerStatusStatefulPerInstanceConfigsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupManagerStatusStatefulPerInstanceConfigsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupManagerStatusStatefulPerInstanceConfigsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_effective: bool):
        """
        :param bool all_effective: A bit indicating if all of the group's per-instance configs (listed in the output of a listPerInstanceConfigs API call) have status EFFECTIVE or there are no per-instance-configs.
        """
        pulumi.set(__self__, "all_effective", all_effective)

    @property
    @pulumi.getter(name="allEffective")
    def all_effective(self) -> bool:
        """
        A bit indicating if all of the group's per-instance configs (listed in the output of a listPerInstanceConfigs API call) have status EFFECTIVE or there are no per-instance-configs.
        """
        return pulumi.get(self, "all_effective")


@pulumi.output_type
class InstanceGroupManagerStatusStatefulResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hasStatefulConfig":
            suggest = "has_stateful_config"
        elif key == "perInstanceConfigs":
            suggest = "per_instance_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupManagerStatusStatefulResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupManagerStatusStatefulResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupManagerStatusStatefulResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 has_stateful_config: bool,
                 per_instance_configs: 'outputs.InstanceGroupManagerStatusStatefulPerInstanceConfigsResponse'):
        """
        :param bool has_stateful_config: A bit indicating whether the managed instance group has stateful configuration, that is, if you have configured any items in a stateful policy or in per-instance configs. The group might report that it has no stateful config even when there is still some preserved state on a managed instance, for example, if you have deleted all PICs but not yet applied those deletions.
        :param 'InstanceGroupManagerStatusStatefulPerInstanceConfigsResponse' per_instance_configs: Status of per-instance configs on the instance.
        """
        pulumi.set(__self__, "has_stateful_config", has_stateful_config)
        pulumi.set(__self__, "per_instance_configs", per_instance_configs)

    @property
    @pulumi.getter(name="hasStatefulConfig")
    def has_stateful_config(self) -> bool:
        """
        A bit indicating whether the managed instance group has stateful configuration, that is, if you have configured any items in a stateful policy or in per-instance configs. The group might report that it has no stateful config even when there is still some preserved state on a managed instance, for example, if you have deleted all PICs but not yet applied those deletions.
        """
        return pulumi.get(self, "has_stateful_config")

    @property
    @pulumi.getter(name="perInstanceConfigs")
    def per_instance_configs(self) -> 'outputs.InstanceGroupManagerStatusStatefulPerInstanceConfigsResponse':
        """
        Status of per-instance configs on the instance.
        """
        return pulumi.get(self, "per_instance_configs")


@pulumi.output_type
class InstanceGroupManagerStatusVersionTargetResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isReached":
            suggest = "is_reached"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupManagerStatusVersionTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupManagerStatusVersionTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupManagerStatusVersionTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_reached: bool):
        """
        :param bool is_reached: A bit indicating whether version target has been reached in this managed instance group, i.e. all instances are in their target version. Instances' target version are specified by version field on Instance Group Manager.
        """
        pulumi.set(__self__, "is_reached", is_reached)

    @property
    @pulumi.getter(name="isReached")
    def is_reached(self) -> bool:
        """
        A bit indicating whether version target has been reached in this managed instance group, i.e. all instances are in their target version. Instances' target version are specified by version field on Instance Group Manager.
        """
        return pulumi.get(self, "is_reached")


@pulumi.output_type
class InstanceGroupManagerUpdatePolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceRedistributionType":
            suggest = "instance_redistribution_type"
        elif key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"
        elif key == "minReadySec":
            suggest = "min_ready_sec"
        elif key == "minimalAction":
            suggest = "minimal_action"
        elif key == "mostDisruptiveAllowedAction":
            suggest = "most_disruptive_allowed_action"
        elif key == "replacementMethod":
            suggest = "replacement_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupManagerUpdatePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupManagerUpdatePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupManagerUpdatePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_redistribution_type: str,
                 max_surge: 'outputs.FixedOrPercentResponse',
                 max_unavailable: 'outputs.FixedOrPercentResponse',
                 min_ready_sec: int,
                 minimal_action: str,
                 most_disruptive_allowed_action: str,
                 replacement_method: str,
                 type: str):
        """
        :param str instance_redistribution_type: The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled. 
        :param 'FixedOrPercentResponse' max_surge: The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
        :param 'FixedOrPercentResponse' max_unavailable: The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
        :param int min_ready_sec: Minimum number of seconds to wait for after a newly created instance becomes available. This value must be from range [0, 3600].
        :param str minimal_action: Minimal action to be taken on an instance. You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
        :param str most_disruptive_allowed_action: Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
        :param str replacement_method: What action should be used to replace instances. See minimal_action.REPLACE
        :param str type: The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
        """
        pulumi.set(__self__, "instance_redistribution_type", instance_redistribution_type)
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)
        pulumi.set(__self__, "min_ready_sec", min_ready_sec)
        pulumi.set(__self__, "minimal_action", minimal_action)
        pulumi.set(__self__, "most_disruptive_allowed_action", most_disruptive_allowed_action)
        pulumi.set(__self__, "replacement_method", replacement_method)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="instanceRedistributionType")
    def instance_redistribution_type(self) -> str:
        """
        The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled. 
        """
        return pulumi.get(self, "instance_redistribution_type")

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> 'outputs.FixedOrPercentResponse':
        """
        The maximum number of instances that can be created above the specified targetSize during the update process. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxSurge is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxSurge.
        """
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> 'outputs.FixedOrPercentResponse':
        """
        The maximum number of instances that can be unavailable during the update process. An instance is considered available if all of the following conditions are satisfied: - The instance's status is RUNNING. - If there is a health check on the instance group, the instance's health check status must be HEALTHY at least once. If there is no health check on the group, then the instance only needs to have a status of RUNNING to be considered available. This value can be either a fixed number or, if the group has 10 or more instances, a percentage. If you set a percentage, the number of instances is rounded if necessary. The default value for maxUnavailable is a fixed value equal to the number of zones in which the managed instance group operates. At least one of either maxSurge or maxUnavailable must be greater than 0. Learn more about maxUnavailable.
        """
        return pulumi.get(self, "max_unavailable")

    @property
    @pulumi.getter(name="minReadySec")
    def min_ready_sec(self) -> int:
        """
        Minimum number of seconds to wait for after a newly created instance becomes available. This value must be from range [0, 3600].
        """
        return pulumi.get(self, "min_ready_sec")

    @property
    @pulumi.getter(name="minimalAction")
    def minimal_action(self) -> str:
        """
        Minimal action to be taken on an instance. You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
        """
        return pulumi.get(self, "minimal_action")

    @property
    @pulumi.getter(name="mostDisruptiveAllowedAction")
    def most_disruptive_allowed_action(self) -> str:
        """
        Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
        """
        return pulumi.get(self, "most_disruptive_allowed_action")

    @property
    @pulumi.getter(name="replacementMethod")
    def replacement_method(self) -> str:
        """
        What action should be used to replace instances. See minimal_action.REPLACE
        """
        return pulumi.get(self, "replacement_method")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstanceGroupManagerVersionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceTemplate":
            suggest = "instance_template"
        elif key == "targetSize":
            suggest = "target_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupManagerVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupManagerVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupManagerVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_template: str,
                 name: str,
                 target_size: 'outputs.FixedOrPercentResponse'):
        """
        :param str instance_template: The URL of the instance template that is specified for this managed instance group. The group uses this template to create new instances in the managed instance group until the `targetSize` for this version is reached. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE; in those cases, existing instances are updated until the `targetSize` for this version is reached.
        :param str name: Name of the version. Unique among all versions in the scope of this managed instance group.
        :param 'FixedOrPercentResponse' target_size: Specifies the intended number of instances to be created from the instanceTemplate. The final number of instances created from the template will be equal to: - If expressed as a fixed number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used. - if expressed as a percent, the targetSize would be (targetSize.percent/100 * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded. If unset, this version will update any remaining instances not updated by another version. Read Starting a canary update for more information.
        """
        pulumi.set(__self__, "instance_template", instance_template)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target_size", target_size)

    @property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> str:
        """
        The URL of the instance template that is specified for this managed instance group. The group uses this template to create new instances in the managed instance group until the `targetSize` for this version is reached. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE; in those cases, existing instances are updated until the `targetSize` for this version is reached.
        """
        return pulumi.get(self, "instance_template")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the version. Unique among all versions in the scope of this managed instance group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetSize")
    def target_size(self) -> 'outputs.FixedOrPercentResponse':
        """
        Specifies the intended number of instances to be created from the instanceTemplate. The final number of instances created from the template will be equal to: - If expressed as a fixed number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used. - if expressed as a percent, the targetSize would be (targetSize.percent/100 * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded. If unset, this version will update any remaining instances not updated by another version. Read Starting a canary update for more information.
        """
        return pulumi.get(self, "target_size")


@pulumi.output_type
class InstanceParamsResponse(dict):
    """
    Additional instance params.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceManagerTags":
            suggest = "resource_manager_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceParamsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceParamsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceParamsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_manager_tags: Mapping[str, str]):
        """
        Additional instance params.
        :param Mapping[str, str] resource_manager_tags: Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        """
        pulumi.set(__self__, "resource_manager_tags", resource_manager_tags)

    @property
    @pulumi.getter(name="resourceManagerTags")
    def resource_manager_tags(self) -> Mapping[str, str]:
        """
        Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        """
        return pulumi.get(self, "resource_manager_tags")


@pulumi.output_type
class InstancePropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedMachineFeatures":
            suggest = "advanced_machine_features"
        elif key == "canIpForward":
            suggest = "can_ip_forward"
        elif key == "confidentialInstanceConfig":
            suggest = "confidential_instance_config"
        elif key == "displayDevice":
            suggest = "display_device"
        elif key == "guestAccelerators":
            suggest = "guest_accelerators"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "networkPerformanceConfig":
            suggest = "network_performance_config"
        elif key == "postKeyRevocationActionType":
            suggest = "post_key_revocation_action_type"
        elif key == "privateIpv6GoogleAccess":
            suggest = "private_ipv6_google_access"
        elif key == "reservationAffinity":
            suggest = "reservation_affinity"
        elif key == "resourceManagerTags":
            suggest = "resource_manager_tags"
        elif key == "resourcePolicies":
            suggest = "resource_policies"
        elif key == "serviceAccounts":
            suggest = "service_accounts"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"
        elif key == "shieldedVmConfig":
            suggest = "shielded_vm_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_machine_features: 'outputs.AdvancedMachineFeaturesResponse',
                 can_ip_forward: bool,
                 confidential_instance_config: 'outputs.ConfidentialInstanceConfigResponse',
                 description: str,
                 disks: Sequence['outputs.AttachedDiskResponse'],
                 display_device: 'outputs.DisplayDeviceResponse',
                 guest_accelerators: Sequence['outputs.AcceleratorConfigResponse'],
                 labels: Mapping[str, str],
                 machine_type: str,
                 metadata: 'outputs.MetadataResponse',
                 min_cpu_platform: str,
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 network_performance_config: 'outputs.NetworkPerformanceConfigResponse',
                 post_key_revocation_action_type: str,
                 private_ipv6_google_access: str,
                 reservation_affinity: 'outputs.ReservationAffinityResponse',
                 resource_manager_tags: Mapping[str, str],
                 resource_policies: Sequence[str],
                 scheduling: 'outputs.SchedulingResponse',
                 service_accounts: Sequence['outputs.ServiceAccountResponse'],
                 shielded_instance_config: 'outputs.ShieldedInstanceConfigResponse',
                 shielded_vm_config: 'outputs.ShieldedVmConfigResponse',
                 tags: 'outputs.TagsResponse'):
        """
        :param 'AdvancedMachineFeaturesResponse' advanced_machine_features: Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
        :param bool can_ip_forward: Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
        :param 'ConfidentialInstanceConfigResponse' confidential_instance_config: Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
        :param str description: An optional text description for the instances that are created from these properties.
        :param Sequence['AttachedDiskResponse'] disks: An array of disks that are associated with the instances that are created from these properties.
        :param 'DisplayDeviceResponse' display_device: Display Device properties to enable support for remote display products like: Teradici, VNC and TeamViewer Note that for MachineImage, this is not supported yet.
        :param Sequence['AcceleratorConfigResponse'] guest_accelerators: A list of guest accelerator cards' type and count to use for instances created from these properties.
        :param Mapping[str, str] labels: Labels to apply to instances that are created from these properties.
        :param str machine_type: The machine type to use for instances that are created from these properties.
        :param 'MetadataResponse' metadata: The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
        :param str min_cpu_platform: Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: An array of network access configurations for this interface.
        :param 'NetworkPerformanceConfigResponse' network_performance_config: Note that for MachineImage, this is not supported yet.
        :param str post_key_revocation_action_type: PostKeyRevocationActionType of the instance.
        :param str private_ipv6_google_access: The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
        :param 'ReservationAffinityResponse' reservation_affinity: Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
        :param Mapping[str, str] resource_manager_tags: Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        :param Sequence[str] resource_policies: Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
        :param 'SchedulingResponse' scheduling: Specifies the scheduling options for the instances that are created from these properties.
        :param Sequence['ServiceAccountResponse'] service_accounts: A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
        :param 'ShieldedInstanceConfigResponse' shielded_instance_config: Note that for MachineImage, this is not supported yet.
        :param 'ShieldedVmConfigResponse' shielded_vm_config: Specifies the Shielded VM options for the instances that are created from these properties.
        :param 'TagsResponse' tags: A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
        """
        pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "display_device", display_device)
        pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "network_performance_config", network_performance_config)
        pulumi.set(__self__, "post_key_revocation_action_type", post_key_revocation_action_type)
        pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        pulumi.set(__self__, "resource_manager_tags", resource_manager_tags)
        pulumi.set(__self__, "resource_policies", resource_policies)
        pulumi.set(__self__, "scheduling", scheduling)
        pulumi.set(__self__, "service_accounts", service_accounts)
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        pulumi.set(__self__, "shielded_vm_config", shielded_vm_config)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> 'outputs.AdvancedMachineFeaturesResponse':
        """
        Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "advanced_machine_features")

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> bool:
        """
        Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
        """
        return pulumi.get(self, "can_ip_forward")

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> 'outputs.ConfidentialInstanceConfigResponse':
        """
        Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "confidential_instance_config")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional text description for the instances that are created from these properties.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.AttachedDiskResponse']:
        """
        An array of disks that are associated with the instances that are created from these properties.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="displayDevice")
    def display_device(self) -> 'outputs.DisplayDeviceResponse':
        """
        Display Device properties to enable support for remote display products like: Teradici, VNC and TeamViewer Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "display_device")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Sequence['outputs.AcceleratorConfigResponse']:
        """
        A list of guest accelerator cards' type and count to use for instances created from these properties.
        """
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels to apply to instances that are created from these properties.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The machine type to use for instances that are created from these properties.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.MetadataResponse':
        """
        The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        An array of network access configurations for this interface.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> 'outputs.NetworkPerformanceConfigResponse':
        """
        Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "network_performance_config")

    @property
    @pulumi.getter(name="postKeyRevocationActionType")
    def post_key_revocation_action_type(self) -> str:
        """
        PostKeyRevocationActionType of the instance.
        """
        return pulumi.get(self, "post_key_revocation_action_type")

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> str:
        """
        The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> 'outputs.ReservationAffinityResponse':
        """
        Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter(name="resourceManagerTags")
    def resource_manager_tags(self) -> Mapping[str, str]:
        """
        Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        """
        return pulumi.get(self, "resource_manager_tags")

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Sequence[str]:
        """
        Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "resource_policies")

    @property
    @pulumi.getter
    def scheduling(self) -> 'outputs.SchedulingResponse':
        """
        Specifies the scheduling options for the instances that are created from these properties.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Sequence['outputs.ServiceAccountResponse']:
        """
        A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
        """
        return pulumi.get(self, "service_accounts")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.ShieldedInstanceConfigResponse':
        """
        Note that for MachineImage, this is not supported yet.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter(name="shieldedVmConfig")
    def shielded_vm_config(self) -> 'outputs.ShieldedVmConfigResponse':
        """
        Specifies the Shielded VM options for the instances that are created from these properties.
        """
        return pulumi.get(self, "shielded_vm_config")

    @property
    @pulumi.getter
    def tags(self) -> 'outputs.TagsResponse':
        """
        A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class Int64RangeMatchResponse(dict):
    """
    HttpRouteRuleMatch criteria for field values that must stay within the specified integer range.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rangeEnd":
            suggest = "range_end"
        elif key == "rangeStart":
            suggest = "range_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Int64RangeMatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Int64RangeMatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Int64RangeMatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range_end: str,
                 range_start: str):
        """
        HttpRouteRuleMatch criteria for field values that must stay within the specified integer range.
        :param str range_end: The end of the range (exclusive) in signed long integer format.
        :param str range_start: The start of the range (inclusive) in signed long integer format.
        """
        pulumi.set(__self__, "range_end", range_end)
        pulumi.set(__self__, "range_start", range_start)

    @property
    @pulumi.getter(name="rangeEnd")
    def range_end(self) -> str:
        """
        The end of the range (exclusive) in signed long integer format.
        """
        return pulumi.get(self, "range_end")

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> str:
        """
        The start of the range (inclusive) in signed long integer format.
        """
        return pulumi.get(self, "range_start")


@pulumi.output_type
class InterconnectAttachmentPartnerMetadataResponse(dict):
    """
    Informational metadata about Partner attachments from Partners to display to customers. These fields are propagated from PARTNER_PROVIDER attachments to their corresponding PARTNER attachments.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interconnectName":
            suggest = "interconnect_name"
        elif key == "partnerName":
            suggest = "partner_name"
        elif key == "portalUrl":
            suggest = "portal_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InterconnectAttachmentPartnerMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InterconnectAttachmentPartnerMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InterconnectAttachmentPartnerMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interconnect_name: str,
                 partner_name: str,
                 portal_url: str):
        """
        Informational metadata about Partner attachments from Partners to display to customers. These fields are propagated from PARTNER_PROVIDER attachments to their corresponding PARTNER attachments.
        :param str interconnect_name: Plain text name of the Interconnect this attachment is connected to, as displayed in the Partner's portal. For instance "Chicago 1". This value may be validated to match approved Partner values.
        :param str partner_name: Plain text name of the Partner providing this attachment. This value may be validated to match approved Partner values.
        :param str portal_url: URL of the Partner's portal for this Attachment. Partners may customise this to be a deep link to the specific resource on the Partner portal. This value may be validated to match approved Partner values.
        """
        pulumi.set(__self__, "interconnect_name", interconnect_name)
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "portal_url", portal_url)

    @property
    @pulumi.getter(name="interconnectName")
    def interconnect_name(self) -> str:
        """
        Plain text name of the Interconnect this attachment is connected to, as displayed in the Partner's portal. For instance "Chicago 1". This value may be validated to match approved Partner values.
        """
        return pulumi.get(self, "interconnect_name")

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> str:
        """
        Plain text name of the Partner providing this attachment. This value may be validated to match approved Partner values.
        """
        return pulumi.get(self, "partner_name")

    @property
    @pulumi.getter(name="portalUrl")
    def portal_url(self) -> str:
        """
        URL of the Partner's portal for this Attachment. Partners may customise this to be a deep link to the specific resource on the Partner portal. This value may be validated to match approved Partner values.
        """
        return pulumi.get(self, "portal_url")


@pulumi.output_type
class InterconnectAttachmentPrivateInfoResponse(dict):
    """
    Information for an interconnect attachment when this belongs to an interconnect of type DEDICATED.
    """
    def __init__(__self__, *,
                 tag8021q: int):
        """
        Information for an interconnect attachment when this belongs to an interconnect of type DEDICATED.
        :param int tag8021q: 802.1q encapsulation tag to be used for traffic between Google and the customer, going to and from this network and region.
        """
        pulumi.set(__self__, "tag8021q", tag8021q)

    @property
    @pulumi.getter
    def tag8021q(self) -> int:
        """
        802.1q encapsulation tag to be used for traffic between Google and the customer, going to and from this network and region.
        """
        return pulumi.get(self, "tag8021q")


@pulumi.output_type
class InterconnectCircuitInfoResponse(dict):
    """
    Describes a single physical circuit between the Customer and Google. CircuitInfo objects are created by Google, so all fields are output only.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerDemarcId":
            suggest = "customer_demarc_id"
        elif key == "googleCircuitId":
            suggest = "google_circuit_id"
        elif key == "googleDemarcId":
            suggest = "google_demarc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InterconnectCircuitInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InterconnectCircuitInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InterconnectCircuitInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_demarc_id: str,
                 google_circuit_id: str,
                 google_demarc_id: str):
        """
        Describes a single physical circuit between the Customer and Google. CircuitInfo objects are created by Google, so all fields are output only.
        :param str customer_demarc_id: Customer-side demarc ID for this circuit.
        :param str google_circuit_id: Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
        :param str google_demarc_id: Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to the customer in the LOA.
        """
        pulumi.set(__self__, "customer_demarc_id", customer_demarc_id)
        pulumi.set(__self__, "google_circuit_id", google_circuit_id)
        pulumi.set(__self__, "google_demarc_id", google_demarc_id)

    @property
    @pulumi.getter(name="customerDemarcId")
    def customer_demarc_id(self) -> str:
        """
        Customer-side demarc ID for this circuit.
        """
        return pulumi.get(self, "customer_demarc_id")

    @property
    @pulumi.getter(name="googleCircuitId")
    def google_circuit_id(self) -> str:
        """
        Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
        """
        return pulumi.get(self, "google_circuit_id")

    @property
    @pulumi.getter(name="googleDemarcId")
    def google_demarc_id(self) -> str:
        """
        Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to the customer in the LOA.
        """
        return pulumi.get(self, "google_demarc_id")


@pulumi.output_type
class InterconnectOutageNotificationResponse(dict):
    """
    Description of a planned outage on this Interconnect.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "affectedCircuits":
            suggest = "affected_circuits"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "issueType":
            suggest = "issue_type"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InterconnectOutageNotificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InterconnectOutageNotificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InterconnectOutageNotificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affected_circuits: Sequence[str],
                 description: str,
                 end_time: str,
                 issue_type: str,
                 name: str,
                 source: str,
                 start_time: str,
                 state: str):
        """
        Description of a planned outage on this Interconnect.
        :param Sequence[str] affected_circuits: If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
        :param str description: A description about the purpose of the outage.
        :param str end_time: Scheduled end time for the outage (milliseconds since Unix epoch).
        :param str issue_type: Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
        :param str name: Unique identifier for this outage notification.
        :param str source: The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
        :param str start_time: Scheduled start time for the outage (milliseconds since Unix epoch).
        :param str state: State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
        """
        pulumi.set(__self__, "affected_circuits", affected_circuits)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "issue_type", issue_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="affectedCircuits")
    def affected_circuits(self) -> Sequence[str]:
        """
        If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
        """
        return pulumi.get(self, "affected_circuits")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description about the purpose of the outage.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Scheduled end time for the outage (milliseconds since Unix epoch).
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="issueType")
    def issue_type(self) -> str:
        """
        Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
        """
        return pulumi.get(self, "issue_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier for this outage notification.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Scheduled start time for the outage (milliseconds since Unix epoch).
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class LicenseResourceCommitmentResponse(dict):
    """
    Commitment for a particular license resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coresPerLicense":
            suggest = "cores_per_license"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicenseResourceCommitmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicenseResourceCommitmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicenseResourceCommitmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 amount: str,
                 cores_per_license: str,
                 license: str):
        """
        Commitment for a particular license resource.
        :param str amount: The number of licenses purchased.
        :param str cores_per_license: Specifies the core range of the instance for which this license applies.
        :param str license: Any applicable license URI.
        """
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "cores_per_license", cores_per_license)
        pulumi.set(__self__, "license", license)

    @property
    @pulumi.getter
    def amount(self) -> str:
        """
        The number of licenses purchased.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="coresPerLicense")
    def cores_per_license(self) -> str:
        """
        Specifies the core range of the instance for which this license applies.
        """
        return pulumi.get(self, "cores_per_license")

    @property
    @pulumi.getter
    def license(self) -> str:
        """
        Any applicable license URI.
        """
        return pulumi.get(self, "license")


@pulumi.output_type
class LicenseResourceRequirementsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minGuestCpuCount":
            suggest = "min_guest_cpu_count"
        elif key == "minMemoryMb":
            suggest = "min_memory_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicenseResourceRequirementsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicenseResourceRequirementsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicenseResourceRequirementsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_guest_cpu_count: int,
                 min_memory_mb: int):
        """
        :param int min_guest_cpu_count: Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and Instance start.
        :param int min_memory_mb: Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
        """
        pulumi.set(__self__, "min_guest_cpu_count", min_guest_cpu_count)
        pulumi.set(__self__, "min_memory_mb", min_memory_mb)

    @property
    @pulumi.getter(name="minGuestCpuCount")
    def min_guest_cpu_count(self) -> int:
        """
        Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and Instance start.
        """
        return pulumi.get(self, "min_guest_cpu_count")

    @property
    @pulumi.getter(name="minMemoryMb")
    def min_memory_mb(self) -> int:
        """
        Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
        """
        return pulumi.get(self, "min_memory_mb")


@pulumi.output_type
class LocalDiskResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskCount":
            suggest = "disk_count"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_count: int,
                 disk_size_gb: int,
                 disk_type: str):
        """
        :param int disk_count: Specifies the number of such disks.
        :param int disk_size_gb: Specifies the size of the disk in base-2 GB.
        :param str disk_type: Specifies the desired disk type on the node. This disk type must be a local storage type (e.g.: local-ssd). Note that for nodeTemplates, this should be the name of the disk type and not its URL.
        """
        pulumi.set(__self__, "disk_count", disk_count)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> int:
        """
        Specifies the number of such disks.
        """
        return pulumi.get(self, "disk_count")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        """
        Specifies the size of the disk in base-2 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Specifies the desired disk type on the node. This disk type must be a local storage type (e.g.: local-ssd). Note that for nodeTemplates, this should be the name of the disk type and not its URL.
        """
        return pulumi.get(self, "disk_type")


@pulumi.output_type
class LogConfigCloudAuditOptionsResponse(dict):
    """
    This is deprecated and has no effect. Do not use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationLoggingOptions":
            suggest = "authorization_logging_options"
        elif key == "logName":
            suggest = "log_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogConfigCloudAuditOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogConfigCloudAuditOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogConfigCloudAuditOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_logging_options: 'outputs.AuthorizationLoggingOptionsResponse',
                 log_name: str):
        """
        This is deprecated and has no effect. Do not use.
        :param 'AuthorizationLoggingOptionsResponse' authorization_logging_options: This is deprecated and has no effect. Do not use.
        :param str log_name: This is deprecated and has no effect. Do not use.
        """
        pulumi.set(__self__, "authorization_logging_options", authorization_logging_options)
        pulumi.set(__self__, "log_name", log_name)

    @property
    @pulumi.getter(name="authorizationLoggingOptions")
    def authorization_logging_options(self) -> 'outputs.AuthorizationLoggingOptionsResponse':
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "authorization_logging_options")

    @property
    @pulumi.getter(name="logName")
    def log_name(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "log_name")


@pulumi.output_type
class LogConfigCounterOptionsCustomFieldResponse(dict):
    """
    This is deprecated and has no effect. Do not use.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        This is deprecated and has no effect. Do not use.
        :param str name: This is deprecated and has no effect. Do not use.
        :param str value: This is deprecated and has no effect. Do not use.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LogConfigCounterOptionsResponse(dict):
    """
    This is deprecated and has no effect. Do not use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customFields":
            suggest = "custom_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogConfigCounterOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogConfigCounterOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogConfigCounterOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_fields: Sequence['outputs.LogConfigCounterOptionsCustomFieldResponse'],
                 field: str,
                 metric: str):
        """
        This is deprecated and has no effect. Do not use.
        :param Sequence['LogConfigCounterOptionsCustomFieldResponse'] custom_fields: This is deprecated and has no effect. Do not use.
        :param str field: This is deprecated and has no effect. Do not use.
        :param str metric: This is deprecated and has no effect. Do not use.
        """
        pulumi.set(__self__, "custom_fields", custom_fields)
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Sequence['outputs.LogConfigCounterOptionsCustomFieldResponse']:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "custom_fields")

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def metric(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class LogConfigDataAccessOptionsResponse(dict):
    """
    This is deprecated and has no effect. Do not use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logMode":
            suggest = "log_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogConfigDataAccessOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogConfigDataAccessOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogConfigDataAccessOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_mode: str):
        """
        This is deprecated and has no effect. Do not use.
        :param str log_mode: This is deprecated and has no effect. Do not use.
        """
        pulumi.set(__self__, "log_mode", log_mode)

    @property
    @pulumi.getter(name="logMode")
    def log_mode(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "log_mode")


@pulumi.output_type
class LogConfigResponse(dict):
    """
    This is deprecated and has no effect. Do not use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudAudit":
            suggest = "cloud_audit"
        elif key == "dataAccess":
            suggest = "data_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_audit: 'outputs.LogConfigCloudAuditOptionsResponse',
                 counter: 'outputs.LogConfigCounterOptionsResponse',
                 data_access: 'outputs.LogConfigDataAccessOptionsResponse'):
        """
        This is deprecated and has no effect. Do not use.
        :param 'LogConfigCloudAuditOptionsResponse' cloud_audit: This is deprecated and has no effect. Do not use.
        :param 'LogConfigCounterOptionsResponse' counter: This is deprecated and has no effect. Do not use.
        :param 'LogConfigDataAccessOptionsResponse' data_access: This is deprecated and has no effect. Do not use.
        """
        pulumi.set(__self__, "cloud_audit", cloud_audit)
        pulumi.set(__self__, "counter", counter)
        pulumi.set(__self__, "data_access", data_access)

    @property
    @pulumi.getter(name="cloudAudit")
    def cloud_audit(self) -> 'outputs.LogConfigCloudAuditOptionsResponse':
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "cloud_audit")

    @property
    @pulumi.getter
    def counter(self) -> 'outputs.LogConfigCounterOptionsResponse':
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "counter")

    @property
    @pulumi.getter(name="dataAccess")
    def data_access(self) -> 'outputs.LogConfigDataAccessOptionsResponse':
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "data_access")


@pulumi.output_type
class MetadataFilterLabelMatchResponse(dict):
    """
    MetadataFilter label name value pairs that are expected to match corresponding labels presented as metadata to the load balancer.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        MetadataFilter label name value pairs that are expected to match corresponding labels presented as metadata to the load balancer.
        :param str name: Name of metadata label. The name can have a maximum length of 1024 characters and must be at least 1 character long.
        :param str value: The value of the label must match the specified value. value can have a maximum length of 1024 characters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of metadata label. The name can have a maximum length of 1024 characters and must be at least 1 character long.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the label must match the specified value. value can have a maximum length of 1024 characters.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MetadataFilterResponse(dict):
    """
    Opaque filter criteria used by load balancers to restrict routing configuration to a limited set of load balancing proxies. Proxies and sidecars involved in load balancing would typically present metadata to the load balancers that need to match criteria specified here. If a match takes place, the relevant configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. An example for using metadataFilters would be: if load balancing involves Envoys, they receive routing configuration when values in metadataFilters match values supplied in of their XDS requests to loadbalancers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterLabels":
            suggest = "filter_labels"
        elif key == "filterMatchCriteria":
            suggest = "filter_match_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_labels: Sequence['outputs.MetadataFilterLabelMatchResponse'],
                 filter_match_criteria: str):
        """
        Opaque filter criteria used by load balancers to restrict routing configuration to a limited set of load balancing proxies. Proxies and sidecars involved in load balancing would typically present metadata to the load balancers that need to match criteria specified here. If a match takes place, the relevant configuration is made available to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. An example for using metadataFilters would be: if load balancing involves Envoys, they receive routing configuration when values in metadataFilters match values supplied in of their XDS requests to loadbalancers.
        :param Sequence['MetadataFilterLabelMatchResponse'] filter_labels: The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
        :param str filter_match_criteria: Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata. 
        """
        pulumi.set(__self__, "filter_labels", filter_labels)
        pulumi.set(__self__, "filter_match_criteria", filter_match_criteria)

    @property
    @pulumi.getter(name="filterLabels")
    def filter_labels(self) -> Sequence['outputs.MetadataFilterLabelMatchResponse']:
        """
        The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria This list must not be empty and can have at the most 64 entries.
        """
        return pulumi.get(self, "filter_labels")

    @property
    @pulumi.getter(name="filterMatchCriteria")
    def filter_match_criteria(self) -> str:
        """
        Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata. 
        """
        return pulumi.get(self, "filter_match_criteria")


@pulumi.output_type
class MetadataItemsItemResponse(dict):
    """
    Metadata
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Metadata
        :param str key: Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be less than 128 bytes in length. This is reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project.
        :param str value: Value for the metadata entry. These are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on values is that their size must be less than or equal to 262144 bytes (256 KiB).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be less than 128 bytes in length. This is reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value for the metadata entry. These are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on values is that their size must be less than or equal to 262144 bytes (256 KiB).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MetadataResponse(dict):
    """
    A metadata key/value entry.
    """
    def __init__(__self__, *,
                 fingerprint: str,
                 items: Sequence['outputs.MetadataItemsItemResponse'],
                 kind: str):
        """
        A metadata key/value entry.
        :param str fingerprint: Specifies a fingerprint for this request, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the resource.
        :param Sequence['MetadataItemsItemResponse'] items: Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
        :param str kind: Type of the resource. Always compute#metadata for metadata.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        Specifies a fingerprint for this request, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the resource.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.MetadataItemsItemResponse']:
        """
        Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#metadata for metadata.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class NamedPortResponse(dict):
    """
    The named port. For example: <"http", 80>.
    """
    def __init__(__self__, *,
                 name: str,
                 port: int):
        """
        The named port. For example: <"http", 80>.
        :param str name: The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
        :param int port: The port number, which can be a value between 1 and 65535.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number, which can be a value between 1 and 65535.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class NetworkEndpointGroupAppEngineResponse(dict):
    """
    Configuration for an App Engine network endpoint group (NEG). The service is optional, may be provided explicitly or in the URL mask. The version is optional and can only be provided explicitly or in the URL mask when service is present. Note: App Engine service must be in the same project and located in the same region as the Serverless NEG.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlMask":
            suggest = "url_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkEndpointGroupAppEngineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkEndpointGroupAppEngineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkEndpointGroupAppEngineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service: str,
                 url_mask: str,
                 version: str):
        """
        Configuration for an App Engine network endpoint group (NEG). The service is optional, may be provided explicitly or in the URL mask. The version is optional and can only be provided explicitly or in the URL mask when service is present. Note: App Engine service must be in the same project and located in the same region as the Serverless NEG.
        :param str service: Optional serving service. The service name is case-sensitive and must be 1-63 characters long. Example value: "default", "my-service".
        :param str url_mask: A template to parse service and version fields from a request URL. URL mask allows for routing to multiple App Engine services without having to create multiple Network Endpoint Groups and backend services. For example, the request URLs "foo1-dot-appname.appspot.com/v1" and "foo1-dot-appname.appspot.com/v2" can be backed by the same Serverless NEG with URL mask "-dot-appname.appspot.com/". The URL mask will parse them to { service = "foo1", version = "v1" } and { service = "foo1", version = "v2" } respectively.
        :param str version: Optional serving version. The version name is case-sensitive and must be 1-100 characters long. Example value: "v1", "v2".
        """
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "url_mask", url_mask)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Optional serving service. The service name is case-sensitive and must be 1-63 characters long. Example value: "default", "my-service".
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="urlMask")
    def url_mask(self) -> str:
        """
        A template to parse service and version fields from a request URL. URL mask allows for routing to multiple App Engine services without having to create multiple Network Endpoint Groups and backend services. For example, the request URLs "foo1-dot-appname.appspot.com/v1" and "foo1-dot-appname.appspot.com/v2" can be backed by the same Serverless NEG with URL mask "-dot-appname.appspot.com/". The URL mask will parse them to { service = "foo1", version = "v1" } and { service = "foo1", version = "v2" } respectively.
        """
        return pulumi.get(self, "url_mask")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Optional serving version. The version name is case-sensitive and must be 1-100 characters long. Example value: "v1", "v2".
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class NetworkEndpointGroupCloudFunctionResponse(dict):
    """
    Configuration for a Cloud Function network endpoint group (NEG). The function must be provided explicitly or in the URL mask. Note: Cloud Function must be in the same project and located in the same region as the Serverless NEG.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlMask":
            suggest = "url_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkEndpointGroupCloudFunctionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkEndpointGroupCloudFunctionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkEndpointGroupCloudFunctionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function: str,
                 url_mask: str):
        """
        Configuration for a Cloud Function network endpoint group (NEG). The function must be provided explicitly or in the URL mask. Note: Cloud Function must be in the same project and located in the same region as the Serverless NEG.
        :param str function: A user-defined name of the Cloud Function. The function name is case-sensitive and must be 1-63 characters long. Example value: "func1".
        :param str url_mask: A template to parse function field from a request URL. URL mask allows for routing to multiple Cloud Functions without having to create multiple Network Endpoint Groups and backend services. For example, request URLs " mydomain.com/function1" and "mydomain.com/function2" can be backed by the same Serverless NEG with URL mask "/". The URL mask will parse them to { function = "function1" } and { function = "function2" } respectively.
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "url_mask", url_mask)

    @property
    @pulumi.getter
    def function(self) -> str:
        """
        A user-defined name of the Cloud Function. The function name is case-sensitive and must be 1-63 characters long. Example value: "func1".
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter(name="urlMask")
    def url_mask(self) -> str:
        """
        A template to parse function field from a request URL. URL mask allows for routing to multiple Cloud Functions without having to create multiple Network Endpoint Groups and backend services. For example, request URLs " mydomain.com/function1" and "mydomain.com/function2" can be backed by the same Serverless NEG with URL mask "/". The URL mask will parse them to { function = "function1" } and { function = "function2" } respectively.
        """
        return pulumi.get(self, "url_mask")


@pulumi.output_type
class NetworkEndpointGroupCloudRunResponse(dict):
    """
    Configuration for a Cloud Run network endpoint group (NEG). The service must be provided explicitly or in the URL mask. The tag is optional, may be provided explicitly or in the URL mask. Note: Cloud Run service must be in the same project and located in the same region as the Serverless NEG.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlMask":
            suggest = "url_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkEndpointGroupCloudRunResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkEndpointGroupCloudRunResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkEndpointGroupCloudRunResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service: str,
                 tag: str,
                 url_mask: str):
        """
        Configuration for a Cloud Run network endpoint group (NEG). The service must be provided explicitly or in the URL mask. The tag is optional, may be provided explicitly or in the URL mask. Note: Cloud Run service must be in the same project and located in the same region as the Serverless NEG.
        :param str service: Cloud Run service is the main resource of Cloud Run. The service must be 1-63 characters long, and comply with RFC1035. Example value: "run-service".
        :param str tag: Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained traffic routing information. The tag must be 1-63 characters long, and comply with RFC1035. Example value: "revision-0010".
        :param str url_mask: A template to parse service and tag fields from a request URL. URL mask allows for routing to multiple Run services without having to create multiple network endpoint groups and backend services. For example, request URLs "foo1.domain.com/bar1" and "foo1.domain.com/bar2" can be backed by the same Serverless Network Endpoint Group (NEG) with URL mask ".domain.com/". The URL mask will parse them to { service="bar1", tag="foo1" } and { service="bar2", tag="foo2" } respectively.
        """
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "url_mask", url_mask)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Cloud Run service is the main resource of Cloud Run. The service must be 1-63 characters long, and comply with RFC1035. Example value: "run-service".
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained traffic routing information. The tag must be 1-63 characters long, and comply with RFC1035. Example value: "revision-0010".
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="urlMask")
    def url_mask(self) -> str:
        """
        A template to parse service and tag fields from a request URL. URL mask allows for routing to multiple Run services without having to create multiple network endpoint groups and backend services. For example, request URLs "foo1.domain.com/bar1" and "foo1.domain.com/bar2" can be backed by the same Serverless Network Endpoint Group (NEG) with URL mask ".domain.com/". The URL mask will parse them to { service="bar1", tag="foo1" } and { service="bar2", tag="foo2" } respectively.
        """
        return pulumi.get(self, "url_mask")


@pulumi.output_type
class NetworkEndpointGroupServerlessDeploymentResponse(dict):
    """
    Configuration for a serverless network endpoint group (NEG). The platform must be provided. Note: The target backend service must be in the same project and located in the same region as the Serverless NEG.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlMask":
            suggest = "url_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkEndpointGroupServerlessDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkEndpointGroupServerlessDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkEndpointGroupServerlessDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 platform: str,
                 resource: str,
                 url_mask: str,
                 version: str):
        """
        Configuration for a serverless network endpoint group (NEG). The platform must be provided. Note: The target backend service must be in the same project and located in the same region as the Serverless NEG.
        :param str platform: The platform of the backend target(s) of this NEG. Possible values include: 1. API Gateway: apigateway.googleapis.com 2. App Engine: appengine.googleapis.com 3. Cloud Functions: cloudfunctions.googleapis.com 4. Cloud Run: run.googleapis.com 
        :param str resource: The user-defined name of the workload/instance. This value must be provided explicitly or in the urlMask. The resource identified by this value is platform-specific and is as follows: 1. API Gateway: The gateway ID 2. App Engine: The service name 3. Cloud Functions: The function name 4. Cloud Run: The service name 
        :param str url_mask: A template to parse platform-specific fields from a request URL. URL mask allows for routing to multiple resources on the same serverless platform without having to create multiple Network Endpoint Groups and backend resources. The fields parsed by this template are platform-specific and are as follows: 1. API Gateway: The gateway ID 2. App Engine: The service and version 3. Cloud Functions: The function name 4. Cloud Run: The service and tag 
        :param str version: The optional resource version. The version identified by this value is platform-specific and is follows: 1. API Gateway: Unused 2. App Engine: The service version 3. Cloud Functions: Unused 4. Cloud Run: The service tag 
        """
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "url_mask", url_mask)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        The platform of the backend target(s) of this NEG. Possible values include: 1. API Gateway: apigateway.googleapis.com 2. App Engine: appengine.googleapis.com 3. Cloud Functions: cloudfunctions.googleapis.com 4. Cloud Run: run.googleapis.com 
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        The user-defined name of the workload/instance. This value must be provided explicitly or in the urlMask. The resource identified by this value is platform-specific and is as follows: 1. API Gateway: The gateway ID 2. App Engine: The service name 3. Cloud Functions: The function name 4. Cloud Run: The service name 
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="urlMask")
    def url_mask(self) -> str:
        """
        A template to parse platform-specific fields from a request URL. URL mask allows for routing to multiple resources on the same serverless platform without having to create multiple Network Endpoint Groups and backend resources. The fields parsed by this template are platform-specific and are as follows: 1. API Gateway: The gateway ID 2. App Engine: The service and version 3. Cloud Functions: The function name 4. Cloud Run: The service and tag 
        """
        return pulumi.get(self, "url_mask")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The optional resource version. The version identified by this value is platform-specific and is follows: 1. API Gateway: Unused 2. App Engine: The service version 3. Cloud Functions: Unused 4. Cloud Run: The service tag 
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class NetworkInterfaceResponse(dict):
    """
    A network interface resource attached to an instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessConfigs":
            suggest = "access_configs"
        elif key == "aliasIpRanges":
            suggest = "alias_ip_ranges"
        elif key == "ipv6AccessConfigs":
            suggest = "ipv6_access_configs"
        elif key == "ipv6AccessType":
            suggest = "ipv6_access_type"
        elif key == "ipv6Address":
            suggest = "ipv6_address"
        elif key == "networkIP":
            suggest = "network_ip"
        elif key == "nicType":
            suggest = "nic_type"
        elif key == "queueCount":
            suggest = "queue_count"
        elif key == "stackType":
            suggest = "stack_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_configs: Sequence['outputs.AccessConfigResponse'],
                 alias_ip_ranges: Sequence['outputs.AliasIpRangeResponse'],
                 fingerprint: str,
                 ipv6_access_configs: Sequence['outputs.AccessConfigResponse'],
                 ipv6_access_type: str,
                 ipv6_address: str,
                 kind: str,
                 name: str,
                 network: str,
                 network_ip: str,
                 nic_type: str,
                 queue_count: int,
                 stack_type: str,
                 subnetwork: str):
        """
        A network interface resource attached to an instance.
        :param Sequence['AccessConfigResponse'] access_configs: An array of configurations for this interface. Currently, only one access config, ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance will have no external internet access.
        :param Sequence['AliasIpRangeResponse'] alias_ip_ranges: An array of alias IP ranges for this network interface. You can only specify this field for network interfaces in VPC networks.
        :param str fingerprint: Fingerprint hash of contents stored in this network interface. This field will be ignored when inserting an Instance or adding a NetworkInterface. An up-to-date fingerprint must be provided in order to update the NetworkInterface. The request will fail with error 400 Bad Request if the fingerprint is not provided, or 412 Precondition Failed if the fingerprint is out of date.
        :param Sequence['AccessConfigResponse'] ipv6_access_configs: An array of IPv6 access configurations for this interface. Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there is no ipv6AccessConfig specified, then this instance will have no external IPv6 Internet access.
        :param str ipv6_access_type: One of EXTERNAL, INTERNAL to indicate whether the IP can be accessed from the Internet. This field is always inherited from its subnetwork. Valid only if stackType is IPV4_IPV6.
        :param str ipv6_address: An IPv6 internal network address for this network interface.
        :param str kind: Type of the resource. Always compute#networkInterface for network interfaces.
        :param str name: The name of the network interface, which is generated by the server. For network devices, these are eth0, eth1, etc.
        :param str network: URL of the VPC network resource for this instance. When creating an instance, if neither the network nor the subnetwork is specified, the default network global/networks/default is used. If the selected project doesn't have the default network, you must specify a network or subnet. If the network is not specified but the subnetwork is specified, the network is inferred. If you specify this property, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/global/networks/ network - projects/project/global/networks/network - global/networks/default 
        :param str network_ip: An IPv4 internal IP address to assign to the instance for this network interface. If not specified by the user, an unused internal IP is assigned by the system.
        :param str nic_type: The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
        :param int queue_count: The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It'll be empty if not specified by the users.
        :param str stack_type: The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at instance creation and update network interface operations.
        :param str subnetwork: The URL of the Subnetwork resource for this instance. If the network resource is in legacy mode, do not specify this field. If the network is in auto subnet mode, specifying the subnetwork is optional. If the network is in custom subnet mode, specifying the subnetwork is required. If you specify this field, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/regions/region /subnetworks/subnetwork - regions/region/subnetworks/subnetwork 
        """
        pulumi.set(__self__, "access_configs", access_configs)
        pulumi.set(__self__, "alias_ip_ranges", alias_ip_ranges)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "ipv6_access_configs", ipv6_access_configs)
        pulumi.set(__self__, "ipv6_access_type", ipv6_access_type)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "network_ip", network_ip)
        pulumi.set(__self__, "nic_type", nic_type)
        pulumi.set(__self__, "queue_count", queue_count)
        pulumi.set(__self__, "stack_type", stack_type)
        pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Sequence['outputs.AccessConfigResponse']:
        """
        An array of configurations for this interface. Currently, only one access config, ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance will have no external internet access.
        """
        return pulumi.get(self, "access_configs")

    @property
    @pulumi.getter(name="aliasIpRanges")
    def alias_ip_ranges(self) -> Sequence['outputs.AliasIpRangeResponse']:
        """
        An array of alias IP ranges for this network interface. You can only specify this field for network interfaces in VPC networks.
        """
        return pulumi.get(self, "alias_ip_ranges")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        Fingerprint hash of contents stored in this network interface. This field will be ignored when inserting an Instance or adding a NetworkInterface. An up-to-date fingerprint must be provided in order to update the NetworkInterface. The request will fail with error 400 Bad Request if the fingerprint is not provided, or 412 Precondition Failed if the fingerprint is out of date.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="ipv6AccessConfigs")
    def ipv6_access_configs(self) -> Sequence['outputs.AccessConfigResponse']:
        """
        An array of IPv6 access configurations for this interface. Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there is no ipv6AccessConfig specified, then this instance will have no external IPv6 Internet access.
        """
        return pulumi.get(self, "ipv6_access_configs")

    @property
    @pulumi.getter(name="ipv6AccessType")
    def ipv6_access_type(self) -> str:
        """
        One of EXTERNAL, INTERNAL to indicate whether the IP can be accessed from the Internet. This field is always inherited from its subnetwork. Valid only if stackType is IPV4_IPV6.
        """
        return pulumi.get(self, "ipv6_access_type")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        An IPv6 internal network address for this network interface.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#networkInterface for network interfaces.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the network interface, which is generated by the server. For network devices, these are eth0, eth1, etc.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        URL of the VPC network resource for this instance. When creating an instance, if neither the network nor the subnetwork is specified, the default network global/networks/default is used. If the selected project doesn't have the default network, you must specify a network or subnet. If the network is not specified but the subnetwork is specified, the network is inferred. If you specify this property, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/global/networks/ network - projects/project/global/networks/network - global/networks/default 
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkIP")
    def network_ip(self) -> str:
        """
        An IPv4 internal IP address to assign to the instance for this network interface. If not specified by the user, an unused internal IP is assigned by the system.
        """
        return pulumi.get(self, "network_ip")

    @property
    @pulumi.getter(name="nicType")
    def nic_type(self) -> str:
        """
        The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
        """
        return pulumi.get(self, "nic_type")

    @property
    @pulumi.getter(name="queueCount")
    def queue_count(self) -> int:
        """
        The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It'll be empty if not specified by the users.
        """
        return pulumi.get(self, "queue_count")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> str:
        """
        The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at instance creation and update network interface operations.
        """
        return pulumi.get(self, "stack_type")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The URL of the Subnetwork resource for this instance. If the network resource is in legacy mode, do not specify this field. If the network is in auto subnet mode, specifying the subnetwork is optional. If the network is in custom subnet mode, specifying the subnetwork is required. If you specify this field, you can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/project/regions/region /subnetworks/subnetwork - regions/region/subnetworks/subnetwork 
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class NetworkPeeringResponse(dict):
    """
    A network peering attached to a network resource. The message includes the peering name, peer network, peering state, and a flag indicating whether Google Compute Engine should automatically create routes for the peering.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoCreateRoutes":
            suggest = "auto_create_routes"
        elif key == "exchangeSubnetRoutes":
            suggest = "exchange_subnet_routes"
        elif key == "exportCustomRoutes":
            suggest = "export_custom_routes"
        elif key == "exportSubnetRoutesWithPublicIp":
            suggest = "export_subnet_routes_with_public_ip"
        elif key == "importCustomRoutes":
            suggest = "import_custom_routes"
        elif key == "importSubnetRoutesWithPublicIp":
            suggest = "import_subnet_routes_with_public_ip"
        elif key == "peerMtu":
            suggest = "peer_mtu"
        elif key == "stateDetails":
            suggest = "state_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPeeringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPeeringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPeeringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_create_routes: bool,
                 exchange_subnet_routes: bool,
                 export_custom_routes: bool,
                 export_subnet_routes_with_public_ip: bool,
                 import_custom_routes: bool,
                 import_subnet_routes_with_public_ip: bool,
                 name: str,
                 network: str,
                 peer_mtu: int,
                 state: str,
                 state_details: str):
        """
        A network peering attached to a network resource. The message includes the peering name, peer network, peering state, and a flag indicating whether Google Compute Engine should automatically create routes for the peering.
        :param bool auto_create_routes: This field will be deprecated soon. Use the exchange_subnet_routes field instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
        :param bool exchange_subnet_routes: Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
        :param bool export_custom_routes: Whether to export the custom routes to peer network. The default value is false.
        :param bool export_subnet_routes_with_public_ip: Whether subnet routes with public IP range are exported. The default value is true, all subnet routes are exported. IPv4 special-use ranges are always exported to peers and are not controlled by this field.
        :param bool import_custom_routes: Whether to import the custom routes from peer network. The default value is false.
        :param bool import_subnet_routes_with_public_ip: Whether subnet routes with public IP range are imported. The default value is false. IPv4 special-use ranges are always imported from peers and are not controlled by this field.
        :param str name: Name of this peering. Provided by the client when the peering is created. The name must comply with RFC1035. Specifically, the name must be 1-63 characters long and match regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all the following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param str network: The URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.
        :param int peer_mtu: Maximum Transmission Unit in bytes.
        :param str state: State for the peering, either `ACTIVE` or `INACTIVE`. The peering is `ACTIVE` when there's a matching configuration in the peer network.
        :param str state_details: Details about the current state of the peering.
        """
        pulumi.set(__self__, "auto_create_routes", auto_create_routes)
        pulumi.set(__self__, "exchange_subnet_routes", exchange_subnet_routes)
        pulumi.set(__self__, "export_custom_routes", export_custom_routes)
        pulumi.set(__self__, "export_subnet_routes_with_public_ip", export_subnet_routes_with_public_ip)
        pulumi.set(__self__, "import_custom_routes", import_custom_routes)
        pulumi.set(__self__, "import_subnet_routes_with_public_ip", import_subnet_routes_with_public_ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "peer_mtu", peer_mtu)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_details", state_details)

    @property
    @pulumi.getter(name="autoCreateRoutes")
    def auto_create_routes(self) -> bool:
        """
        This field will be deprecated soon. Use the exchange_subnet_routes field instead. Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
        """
        return pulumi.get(self, "auto_create_routes")

    @property
    @pulumi.getter(name="exchangeSubnetRoutes")
    def exchange_subnet_routes(self) -> bool:
        """
        Indicates whether full mesh connectivity is created and managed automatically between peered networks. Currently this field should always be true since Google Compute Engine will automatically create and manage subnetwork routes between two networks when peering state is ACTIVE.
        """
        return pulumi.get(self, "exchange_subnet_routes")

    @property
    @pulumi.getter(name="exportCustomRoutes")
    def export_custom_routes(self) -> bool:
        """
        Whether to export the custom routes to peer network. The default value is false.
        """
        return pulumi.get(self, "export_custom_routes")

    @property
    @pulumi.getter(name="exportSubnetRoutesWithPublicIp")
    def export_subnet_routes_with_public_ip(self) -> bool:
        """
        Whether subnet routes with public IP range are exported. The default value is true, all subnet routes are exported. IPv4 special-use ranges are always exported to peers and are not controlled by this field.
        """
        return pulumi.get(self, "export_subnet_routes_with_public_ip")

    @property
    @pulumi.getter(name="importCustomRoutes")
    def import_custom_routes(self) -> bool:
        """
        Whether to import the custom routes from peer network. The default value is false.
        """
        return pulumi.get(self, "import_custom_routes")

    @property
    @pulumi.getter(name="importSubnetRoutesWithPublicIp")
    def import_subnet_routes_with_public_ip(self) -> bool:
        """
        Whether subnet routes with public IP range are imported. The default value is false. IPv4 special-use ranges are always imported from peers and are not controlled by this field.
        """
        return pulumi.get(self, "import_subnet_routes_with_public_ip")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this peering. Provided by the client when the peering is created. The name must comply with RFC1035. Specifically, the name must be 1-63 characters long and match regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all the following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The URL of the peer network. It can be either full URL or partial URL. The peer network may belong to a different project. If the partial URL does not contain project, it is assumed that the peer network is in the same project as the current network.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="peerMtu")
    def peer_mtu(self) -> int:
        """
        Maximum Transmission Unit in bytes.
        """
        return pulumi.get(self, "peer_mtu")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State for the peering, either `ACTIVE` or `INACTIVE`. The peering is `ACTIVE` when there's a matching configuration in the peer network.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> str:
        """
        Details about the current state of the peering.
        """
        return pulumi.get(self, "state_details")


@pulumi.output_type
class NetworkPerformanceConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "totalEgressBandwidthTier":
            suggest = "total_egress_bandwidth_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPerformanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPerformanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPerformanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 total_egress_bandwidth_tier: str):
        pulumi.set(__self__, "total_egress_bandwidth_tier", total_egress_bandwidth_tier)

    @property
    @pulumi.getter(name="totalEgressBandwidthTier")
    def total_egress_bandwidth_tier(self) -> str:
        return pulumi.get(self, "total_egress_bandwidth_tier")


@pulumi.output_type
class NetworkRoutingConfigResponse(dict):
    """
    A routing configuration attached to a network resource. The message includes the list of routers associated with the network, and a flag indicating the type of routing behavior to enforce network-wide.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routingMode":
            suggest = "routing_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRoutingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRoutingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRoutingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 routing_mode: str):
        """
        A routing configuration attached to a network resource. The message includes the list of routers associated with the network, and a flag indicating the type of routing behavior to enforce network-wide.
        :param str routing_mode: The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
        """
        pulumi.set(__self__, "routing_mode", routing_mode)

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> str:
        """
        The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
        """
        return pulumi.get(self, "routing_mode")


@pulumi.output_type
class NodeGroupAutoscalingPolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodes":
            suggest = "max_nodes"
        elif key == "minNodes":
            suggest = "min_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupAutoscalingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupAutoscalingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupAutoscalingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_nodes: int,
                 min_nodes: int,
                 mode: str):
        """
        :param int max_nodes: The maximum number of nodes that the group should have. Must be set if autoscaling is enabled. Maximum value allowed is 100.
        :param int min_nodes: The minimum number of nodes that the group should have.
        :param str mode: The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see Autoscaler modes.
        """
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> int:
        """
        The maximum number of nodes that the group should have. Must be set if autoscaling is enabled. Maximum value allowed is 100.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> int:
        """
        The minimum number of nodes that the group should have.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see Autoscaler modes.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class NodeGroupMaintenanceWindowResponse(dict):
    """
    Time window specified for daily maintenance operations. GCE's internal maintenance will be performed within this window.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceDuration":
            suggest = "maintenance_duration"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupMaintenanceWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupMaintenanceWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupMaintenanceWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maintenance_duration: 'outputs.DurationResponse',
                 start_time: str):
        """
        Time window specified for daily maintenance operations. GCE's internal maintenance will be performed within this window.
        :param 'DurationResponse' maintenance_duration: [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
        :param str start_time: Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
        """
        pulumi.set(__self__, "maintenance_duration", maintenance_duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="maintenanceDuration")
    def maintenance_duration(self) -> 'outputs.DurationResponse':
        """
        [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
        """
        return pulumi.get(self, "maintenance_duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class NodeTemplateNodeTypeFlexibilityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localSsd":
            suggest = "local_ssd"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeTemplateNodeTypeFlexibilityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeTemplateNodeTypeFlexibilityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeTemplateNodeTypeFlexibilityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpus: str,
                 local_ssd: str,
                 memory: str):
        pulumi.set(__self__, "cpus", cpus)
        pulumi.set(__self__, "local_ssd", local_ssd)
        pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpus(self) -> str:
        return pulumi.get(self, "cpus")

    @property
    @pulumi.getter(name="localSsd")
    def local_ssd(self) -> str:
        return pulumi.get(self, "local_ssd")

    @property
    @pulumi.getter
    def memory(self) -> str:
        return pulumi.get(self, "memory")


@pulumi.output_type
class NotificationEndpointGrpcSettingsResponse(dict):
    """
    Represents a gRPC setting that describes one gRPC notification endpoint and the retry duration attempting to send notification to this endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "payloadName":
            suggest = "payload_name"
        elif key == "resendInterval":
            suggest = "resend_interval"
        elif key == "retryDurationSec":
            suggest = "retry_duration_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationEndpointGrpcSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationEndpointGrpcSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationEndpointGrpcSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority: str,
                 endpoint: str,
                 payload_name: str,
                 resend_interval: 'outputs.DurationResponse',
                 retry_duration_sec: int):
        """
        Represents a gRPC setting that describes one gRPC notification endpoint and the retry duration attempting to send notification to this endpoint.
        :param str authority: Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
        :param str endpoint: Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
        :param str payload_name: Optional. If specified, this field is used to populate the "name" field in gRPC requests.
        :param 'DurationResponse' resend_interval: Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed.
        :param int retry_duration_sec: How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
        """
        pulumi.set(__self__, "authority", authority)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "payload_name", payload_name)
        pulumi.set(__self__, "resend_interval", resend_interval)
        pulumi.set(__self__, "retry_duration_sec", retry_duration_sec)

    @property
    @pulumi.getter
    def authority(self) -> str:
        """
        Optional. If specified, this field is used to set the authority header by the sender of notifications. See https://tools.ietf.org/html/rfc7540#section-8.1.2.3
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Endpoint to which gRPC notifications are sent. This must be a valid gRPCLB DNS name.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="payloadName")
    def payload_name(self) -> str:
        """
        Optional. If specified, this field is used to populate the "name" field in gRPC requests.
        """
        return pulumi.get(self, "payload_name")

    @property
    @pulumi.getter(name="resendInterval")
    def resend_interval(self) -> 'outputs.DurationResponse':
        """
        Optional. This field is used to configure how often to send a full update of all non-healthy backends. If unspecified, full updates are not sent. If specified, must be in the range between 600 seconds to 3600 seconds. Nanos are disallowed.
        """
        return pulumi.get(self, "resend_interval")

    @property
    @pulumi.getter(name="retryDurationSec")
    def retry_duration_sec(self) -> int:
        """
        How much time (in seconds) is spent attempting notification retries until a successful response is received. Default is 30s. Limit is 20m (1200s). Must be a positive number.
        """
        return pulumi.get(self, "retry_duration_sec")


@pulumi.output_type
class OutlierDetectionResponse(dict):
    """
    Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseEjectionTime":
            suggest = "base_ejection_time"
        elif key == "consecutiveErrors":
            suggest = "consecutive_errors"
        elif key == "consecutiveGatewayFailure":
            suggest = "consecutive_gateway_failure"
        elif key == "enforcingConsecutiveErrors":
            suggest = "enforcing_consecutive_errors"
        elif key == "enforcingConsecutiveGatewayFailure":
            suggest = "enforcing_consecutive_gateway_failure"
        elif key == "enforcingSuccessRate":
            suggest = "enforcing_success_rate"
        elif key == "maxEjectionPercent":
            suggest = "max_ejection_percent"
        elif key == "successRateMinimumHosts":
            suggest = "success_rate_minimum_hosts"
        elif key == "successRateRequestVolume":
            suggest = "success_rate_request_volume"
        elif key == "successRateStdevFactor":
            suggest = "success_rate_stdev_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutlierDetectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutlierDetectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutlierDetectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_ejection_time: 'outputs.DurationResponse',
                 consecutive_errors: int,
                 consecutive_gateway_failure: int,
                 enforcing_consecutive_errors: int,
                 enforcing_consecutive_gateway_failure: int,
                 enforcing_success_rate: int,
                 interval: 'outputs.DurationResponse',
                 max_ejection_percent: int,
                 success_rate_minimum_hosts: int,
                 success_rate_request_volume: int,
                 success_rate_stdev_factor: int):
        """
        Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service.
        :param 'DurationResponse' base_ejection_time: The base time that a host is ejected for. The real ejection time is equal to the base ejection time multiplied by the number of times the host has been ejected. Defaults to 30000ms or 30s.
        :param int consecutive_errors: Number of errors before a host is ejected from the connection pool. When the backend host is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
        :param int consecutive_gateway_failure: The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
        :param int enforcing_consecutive_errors: The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
        :param int enforcing_consecutive_gateway_failure: The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
        :param int enforcing_success_rate: The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
        :param 'DurationResponse' interval: Time interval between ejection analysis sweeps. This can result in both new ejections as well as hosts being returned to service. Defaults to 1 second.
        :param int max_ejection_percent: Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 50%.
        :param int success_rate_minimum_hosts: The number of hosts in a cluster that must have enough request volume to detect success rate outliers. If the number of hosts is less than this setting, outlier detection via success rate statistics is not performed for any host in the cluster. Defaults to 5.
        :param int success_rate_request_volume: The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that host. Defaults to 100.
        :param int success_rate_stdev_factor: This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900.
        """
        pulumi.set(__self__, "base_ejection_time", base_ejection_time)
        pulumi.set(__self__, "consecutive_errors", consecutive_errors)
        pulumi.set(__self__, "consecutive_gateway_failure", consecutive_gateway_failure)
        pulumi.set(__self__, "enforcing_consecutive_errors", enforcing_consecutive_errors)
        pulumi.set(__self__, "enforcing_consecutive_gateway_failure", enforcing_consecutive_gateway_failure)
        pulumi.set(__self__, "enforcing_success_rate", enforcing_success_rate)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "max_ejection_percent", max_ejection_percent)
        pulumi.set(__self__, "success_rate_minimum_hosts", success_rate_minimum_hosts)
        pulumi.set(__self__, "success_rate_request_volume", success_rate_request_volume)
        pulumi.set(__self__, "success_rate_stdev_factor", success_rate_stdev_factor)

    @property
    @pulumi.getter(name="baseEjectionTime")
    def base_ejection_time(self) -> 'outputs.DurationResponse':
        """
        The base time that a host is ejected for. The real ejection time is equal to the base ejection time multiplied by the number of times the host has been ejected. Defaults to 30000ms or 30s.
        """
        return pulumi.get(self, "base_ejection_time")

    @property
    @pulumi.getter(name="consecutiveErrors")
    def consecutive_errors(self) -> int:
        """
        Number of errors before a host is ejected from the connection pool. When the backend host is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
        """
        return pulumi.get(self, "consecutive_errors")

    @property
    @pulumi.getter(name="consecutiveGatewayFailure")
    def consecutive_gateway_failure(self) -> int:
        """
        The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
        """
        return pulumi.get(self, "consecutive_gateway_failure")

    @property
    @pulumi.getter(name="enforcingConsecutiveErrors")
    def enforcing_consecutive_errors(self) -> int:
        """
        The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
        """
        return pulumi.get(self, "enforcing_consecutive_errors")

    @property
    @pulumi.getter(name="enforcingConsecutiveGatewayFailure")
    def enforcing_consecutive_gateway_failure(self) -> int:
        """
        The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
        """
        return pulumi.get(self, "enforcing_consecutive_gateway_failure")

    @property
    @pulumi.getter(name="enforcingSuccessRate")
    def enforcing_success_rate(self) -> int:
        """
        The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
        """
        return pulumi.get(self, "enforcing_success_rate")

    @property
    @pulumi.getter
    def interval(self) -> 'outputs.DurationResponse':
        """
        Time interval between ejection analysis sweeps. This can result in both new ejections as well as hosts being returned to service. Defaults to 1 second.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maxEjectionPercent")
    def max_ejection_percent(self) -> int:
        """
        Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 50%.
        """
        return pulumi.get(self, "max_ejection_percent")

    @property
    @pulumi.getter(name="successRateMinimumHosts")
    def success_rate_minimum_hosts(self) -> int:
        """
        The number of hosts in a cluster that must have enough request volume to detect success rate outliers. If the number of hosts is less than this setting, outlier detection via success rate statistics is not performed for any host in the cluster. Defaults to 5.
        """
        return pulumi.get(self, "success_rate_minimum_hosts")

    @property
    @pulumi.getter(name="successRateRequestVolume")
    def success_rate_request_volume(self) -> int:
        """
        The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that host. Defaults to 100.
        """
        return pulumi.get(self, "success_rate_request_volume")

    @property
    @pulumi.getter(name="successRateStdevFactor")
    def success_rate_stdev_factor(self) -> int:
        """
        This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900.
        """
        return pulumi.get(self, "success_rate_stdev_factor")


@pulumi.output_type
class PacketMirroringFilterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrRanges":
            suggest = "cidr_ranges"
        elif key == "ipProtocols":
            suggest = "ip_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketMirroringFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketMirroringFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketMirroringFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_ranges: Sequence[str],
                 direction: str,
                 ip_protocols: Sequence[str]):
        """
        :param Sequence[str] cidr_ranges: IP CIDR ranges that apply as filter on the source (ingress) or destination (egress) IP in the IP header. Only IPv4 is supported. If no ranges are specified, all traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
        :param str direction: Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
        :param Sequence[str] ip_protocols: Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
        """
        pulumi.set(__self__, "cidr_ranges", cidr_ranges)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "ip_protocols", ip_protocols)

    @property
    @pulumi.getter(name="cidrRanges")
    def cidr_ranges(self) -> Sequence[str]:
        """
        IP CIDR ranges that apply as filter on the source (ingress) or destination (egress) IP in the IP header. Only IPv4 is supported. If no ranges are specified, all traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
        """
        return pulumi.get(self, "cidr_ranges")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="ipProtocols")
    def ip_protocols(self) -> Sequence[str]:
        """
        Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all traffic is mirrored.
        """
        return pulumi.get(self, "ip_protocols")


@pulumi.output_type
class PacketMirroringForwardingRuleInfoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canonicalUrl":
            suggest = "canonical_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketMirroringForwardingRuleInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketMirroringForwardingRuleInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketMirroringForwardingRuleInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canonical_url: str,
                 url: str):
        """
        :param str canonical_url: Unique identifier for the forwarding rule; defined by the server.
        :param str url: Resource URL to the forwarding rule representing the ILB configured as destination of the mirrored traffic.
        """
        pulumi.set(__self__, "canonical_url", canonical_url)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="canonicalUrl")
    def canonical_url(self) -> str:
        """
        Unique identifier for the forwarding rule; defined by the server.
        """
        return pulumi.get(self, "canonical_url")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Resource URL to the forwarding rule representing the ILB configured as destination of the mirrored traffic.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class PacketMirroringMirroredResourceInfoInstanceInfoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canonicalUrl":
            suggest = "canonical_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketMirroringMirroredResourceInfoInstanceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketMirroringMirroredResourceInfoInstanceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketMirroringMirroredResourceInfoInstanceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canonical_url: str,
                 url: str):
        """
        :param str canonical_url: Unique identifier for the instance; defined by the server.
        :param str url: Resource URL to the virtual machine instance which is being mirrored.
        """
        pulumi.set(__self__, "canonical_url", canonical_url)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="canonicalUrl")
    def canonical_url(self) -> str:
        """
        Unique identifier for the instance; defined by the server.
        """
        return pulumi.get(self, "canonical_url")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Resource URL to the virtual machine instance which is being mirrored.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class PacketMirroringMirroredResourceInfoResponse(dict):
    def __init__(__self__, *,
                 instances: Sequence['outputs.PacketMirroringMirroredResourceInfoInstanceInfoResponse'],
                 subnetworks: Sequence['outputs.PacketMirroringMirroredResourceInfoSubnetInfoResponse'],
                 tags: Sequence[str]):
        """
        :param Sequence['PacketMirroringMirroredResourceInfoInstanceInfoResponse'] instances: A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
        :param Sequence['PacketMirroringMirroredResourceInfoSubnetInfoResponse'] subnetworks: A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
        :param Sequence[str] tags: A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
        """
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "subnetworks", subnetworks)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.PacketMirroringMirroredResourceInfoInstanceInfoResponse']:
        """
        A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def subnetworks(self) -> Sequence['outputs.PacketMirroringMirroredResourceInfoSubnetInfoResponse']:
        """
        A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
        """
        return pulumi.get(self, "subnetworks")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PacketMirroringMirroredResourceInfoSubnetInfoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canonicalUrl":
            suggest = "canonical_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketMirroringMirroredResourceInfoSubnetInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketMirroringMirroredResourceInfoSubnetInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketMirroringMirroredResourceInfoSubnetInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canonical_url: str,
                 url: str):
        """
        :param str canonical_url: Unique identifier for the subnetwork; defined by the server.
        :param str url: Resource URL to the subnetwork for which traffic from/to all VM instances will be mirrored.
        """
        pulumi.set(__self__, "canonical_url", canonical_url)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="canonicalUrl")
    def canonical_url(self) -> str:
        """
        Unique identifier for the subnetwork; defined by the server.
        """
        return pulumi.get(self, "canonical_url")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Resource URL to the subnetwork for which traffic from/to all VM instances will be mirrored.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class PacketMirroringNetworkInfoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canonicalUrl":
            suggest = "canonical_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketMirroringNetworkInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketMirroringNetworkInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketMirroringNetworkInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canonical_url: str,
                 url: str):
        """
        :param str canonical_url: Unique identifier for the network; defined by the server.
        :param str url: URL of the network resource.
        """
        pulumi.set(__self__, "canonical_url", canonical_url)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="canonicalUrl")
    def canonical_url(self) -> str:
        """
        Unique identifier for the network; defined by the server.
        """
        return pulumi.get(self, "canonical_url")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL of the network resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class PathMatcherResponse(dict):
    """
    A matcher for the path portion of the URL. The BackendService from the longest-matched rule will serve the URL. If no rule was matched, the default service is used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRouteAction":
            suggest = "default_route_action"
        elif key == "defaultService":
            suggest = "default_service"
        elif key == "defaultUrlRedirect":
            suggest = "default_url_redirect"
        elif key == "headerAction":
            suggest = "header_action"
        elif key == "pathRules":
            suggest = "path_rules"
        elif key == "routeRules":
            suggest = "route_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathMatcherResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathMatcherResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathMatcherResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_route_action: 'outputs.HttpRouteActionResponse',
                 default_service: str,
                 default_url_redirect: 'outputs.HttpRedirectActionResponse',
                 description: str,
                 header_action: 'outputs.HttpHeaderActionResponse',
                 name: str,
                 path_rules: Sequence['outputs.PathRuleResponse'],
                 route_rules: Sequence['outputs.HttpRouteRuleResponse']):
        """
        A matcher for the path portion of the URL. The BackendService from the longest-matched rule will serve the URL. If no rule was matched, the default service is used.
        :param 'HttpRouteActionResponse' default_route_action: defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. Only one of defaultRouteAction or defaultUrlRedirect must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a path matcher's defaultRouteAction.
        :param str default_service: The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. Only one of defaultService, defaultUrlRedirect , or defaultRouteAction.weightedBackendService must be set. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use 
        :param 'HttpRedirectActionResponse' default_url_redirect: When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or defaultRouteAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        :param str description: An optional description of this resource. Provide this property when you create the resource.
        :param 'HttpHeaderActionResponse' header_action: Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param str name: The name to which this PathMatcher is referred by the HostRule.
        :param Sequence['PathRuleResponse'] path_rules: The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/* will match before /a/b/* irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
        :param Sequence['HttpRouteRuleResponse'] route_rules: The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
        """
        pulumi.set(__self__, "default_route_action", default_route_action)
        pulumi.set(__self__, "default_service", default_service)
        pulumi.set(__self__, "default_url_redirect", default_url_redirect)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "header_action", header_action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path_rules", path_rules)
        pulumi.set(__self__, "route_rules", route_rules)

    @property
    @pulumi.getter(name="defaultRouteAction")
    def default_route_action(self) -> 'outputs.HttpRouteActionResponse':
        """
        defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. Only one of defaultRouteAction or defaultUrlRedirect must be set. UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a path matcher's defaultRouteAction.
        """
        return pulumi.get(self, "default_route_action")

    @property
    @pulumi.getter(name="defaultService")
    def default_service(self) -> str:
        """
        The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. Only one of defaultService, defaultUrlRedirect , or defaultRouteAction.weightedBackendService must be set. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use 
        """
        return pulumi.get(self, "default_service")

    @property
    @pulumi.getter(name="defaultUrlRedirect")
    def default_url_redirect(self) -> 'outputs.HttpRedirectActionResponse':
        """
        When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or defaultRouteAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "default_url_redirect")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> 'outputs.HttpHeaderActionResponse':
        """
        Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to which this PathMatcher is referred by the HostRule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathRules")
    def path_rules(self) -> Sequence['outputs.PathRuleResponse']:
        """
        The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/* will match before /a/b/* irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
        """
        return pulumi.get(self, "path_rules")

    @property
    @pulumi.getter(name="routeRules")
    def route_rules(self) -> Sequence['outputs.HttpRouteRuleResponse']:
        """
        The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
        """
        return pulumi.get(self, "route_rules")


@pulumi.output_type
class PathRuleResponse(dict):
    """
    A path-matching rule for a URL. If matched, will use the specified BackendService to handle the traffic arriving at this URL.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routeAction":
            suggest = "route_action"
        elif key == "urlRedirect":
            suggest = "url_redirect"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 paths: Sequence[str],
                 route_action: 'outputs.HttpRouteActionResponse',
                 service: str,
                 url_redirect: 'outputs.HttpRedirectActionResponse'):
        """
        A path-matching rule for a URL. If matched, will use the specified BackendService to handle the traffic arriving at this URL.
        :param Sequence[str] paths: The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
        :param 'HttpRouteActionResponse' route_action: In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for external HTTP(S) load balancers support only the urlRewrite action within a path rule's routeAction.
        :param str service: The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
        :param 'HttpRedirectActionResponse' url_redirect: When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "route_action", route_action)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "url_redirect", url_redirect)

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="routeAction")
    def route_action(self) -> 'outputs.HttpRouteActionResponse':
        """
        In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for external HTTP(S) load balancers support only the urlRewrite action within a path rule's routeAction.
        """
        return pulumi.get(self, "route_action")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="urlRedirect")
    def url_redirect(self) -> 'outputs.HttpRedirectActionResponse':
        """
        When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
        """
        return pulumi.get(self, "url_redirect")


@pulumi.output_type
class PublicAdvertisedPrefixPublicDelegatedPrefixResponse(dict):
    """
    Represents a CIDR range which can be used to assign addresses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicAdvertisedPrefixPublicDelegatedPrefixResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicAdvertisedPrefixPublicDelegatedPrefixResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicAdvertisedPrefixPublicDelegatedPrefixResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_range: str,
                 name: str,
                 project: str,
                 region: str,
                 status: str):
        """
        Represents a CIDR range which can be used to assign addresses.
        :param str ip_range: The IP address range of the public delegated prefix
        :param str name: The name of the public delegated prefix
        :param str project: The project number of the public delegated prefix
        :param str region: The region of the public delegated prefix if it is regional. If absent, the prefix is global.
        :param str status: The status of the public delegated prefix. Possible values are: INITIALIZING: The public delegated prefix is being initialized and addresses cannot be created yet. ANNOUNCED: The public delegated prefix is active.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        """
        The IP address range of the public delegated prefix
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the public delegated prefix
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The project number of the public delegated prefix
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of the public delegated prefix if it is regional. If absent, the prefix is global.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the public delegated prefix. Possible values are: INITIALIZING: The public delegated prefix is being initialized and addresses cannot be created yet. ANNOUNCED: The public delegated prefix is active.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PublicDelegatedPrefixPublicDelegatedSubPrefixResponse(dict):
    """
    Represents a sub PublicDelegatedPrefix.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delegateeProject":
            suggest = "delegatee_project"
        elif key == "ipCidrRange":
            suggest = "ip_cidr_range"
        elif key == "isAddress":
            suggest = "is_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicDelegatedPrefixPublicDelegatedSubPrefixResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicDelegatedPrefixPublicDelegatedSubPrefixResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicDelegatedPrefixPublicDelegatedSubPrefixResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delegatee_project: str,
                 description: str,
                 ip_cidr_range: str,
                 is_address: bool,
                 name: str,
                 region: str,
                 status: str):
        """
        Represents a sub PublicDelegatedPrefix.
        :param str delegatee_project: Name of the project scoping this PublicDelegatedSubPrefix.
        :param str description: An optional description of this resource. Provide this property when you create the resource.
        :param str ip_cidr_range: The IPv4 address range, in CIDR format, represented by this sub public delegated prefix.
        :param bool is_address: Whether the sub prefix is delegated to create Address resources in the delegatee project.
        :param str name: The name of the sub public delegated prefix.
        :param str region: The region of the sub public delegated prefix if it is regional. If absent, the sub prefix is global.
        :param str status: The status of the sub public delegated prefix.
        """
        pulumi.set(__self__, "delegatee_project", delegatee_project)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        pulumi.set(__self__, "is_address", is_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="delegateeProject")
    def delegatee_project(self) -> str:
        """
        Name of the project scoping this PublicDelegatedSubPrefix.
        """
        return pulumi.get(self, "delegatee_project")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> str:
        """
        The IPv4 address range, in CIDR format, represented by this sub public delegated prefix.
        """
        return pulumi.get(self, "ip_cidr_range")

    @property
    @pulumi.getter(name="isAddress")
    def is_address(self) -> bool:
        """
        Whether the sub prefix is delegated to create Address resources in the delegatee project.
        """
        return pulumi.get(self, "is_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the sub public delegated prefix.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of the sub public delegated prefix if it is regional. If absent, the sub prefix is global.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the sub public delegated prefix.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RequestMirrorPolicyResponse(dict):
    """
    A policy that specifies how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer doesn't wait for responses from the shadow service. Before sending traffic to the shadow service, the host or authority header is suffixed with -shadow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendService":
            suggest = "backend_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestMirrorPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestMirrorPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestMirrorPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_service: str):
        """
        A policy that specifies how requests intended for the route's backends are shadowed to a separate mirrored backend service. The load balancer doesn't wait for responses from the shadow service. Before sending traffic to the shadow service, the host or authority header is suffixed with -shadow.
        :param str backend_service: The full or partial URL to the BackendService resource being mirrored to.
        """
        pulumi.set(__self__, "backend_service", backend_service)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> str:
        """
        The full or partial URL to the BackendService resource being mirrored to.
        """
        return pulumi.get(self, "backend_service")


@pulumi.output_type
class ReservationAffinityResponse(dict):
    """
    Specifies the reservations that this instance can consume from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumeReservationType":
            suggest = "consume_reservation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservationAffinityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservationAffinityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservationAffinityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consume_reservation_type: str,
                 key: str,
                 values: Sequence[str]):
        """
        Specifies the reservations that this instance can consume from.
        :param str consume_reservation_type: Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See Consuming reserved instances for examples.
        :param str key: Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify googleapis.com/reservation-name as the key and specify the name of your reservation as its value.
        :param Sequence[str] values: Corresponds to the label values of a reservation resource. This can be either a name to a reservation in the same project or "projects/different-project/reservations/some-reservation-name" to target a shared reservation in the same zone but in a different project.
        """
        pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> str:
        """
        Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See Consuming reserved instances for examples.
        """
        return pulumi.get(self, "consume_reservation_type")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify googleapis.com/reservation-name as the key and specify the name of your reservation as its value.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Corresponds to the label values of a reservation resource. This can be either a name to a reservation in the same project or "projects/different-project/reservations/some-reservation-name" to target a shared reservation in the same zone but in a different project.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ReservationResponse(dict):
    """
    Represents a reservation resource. A reservation ensures that capacity is held in a specific zone even if the reserved VMs are not running. For more information, read Reserving zonal resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTimestamp":
            suggest = "creation_timestamp"
        elif key == "satisfiesPzs":
            suggest = "satisfies_pzs"
        elif key == "selfLink":
            suggest = "self_link"
        elif key == "shareSettings":
            suggest = "share_settings"
        elif key == "specificReservation":
            suggest = "specific_reservation"
        elif key == "specificReservationRequired":
            suggest = "specific_reservation_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commitment: str,
                 creation_timestamp: str,
                 description: str,
                 kind: str,
                 name: str,
                 satisfies_pzs: bool,
                 self_link: str,
                 share_settings: 'outputs.ShareSettingsResponse',
                 specific_reservation: 'outputs.AllocationSpecificSKUReservationResponse',
                 specific_reservation_required: bool,
                 status: str,
                 zone: str):
        """
        Represents a reservation resource. A reservation ensures that capacity is held in a specific zone even if the reserved VMs are not running. For more information, read Reserving zonal resources.
        :param str commitment: Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
        :param str creation_timestamp: Creation timestamp in RFC3339 text format.
        :param str description: An optional description of this resource. Provide this property when you create the resource.
        :param str kind: Type of the resource. Always compute#reservations for reservations.
        :param str name: The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param bool satisfies_pzs: Reserved for future use.
        :param str self_link: Server-defined fully-qualified URL for this resource.
        :param 'ShareSettingsResponse' share_settings: Share-settings for shared-reservation
        :param 'AllocationSpecificSKUReservationResponse' specific_reservation: Reservation for instances with specific machine shapes.
        :param bool specific_reservation_required: Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
        :param str status: The status of the reservation.
        :param str zone: Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
        """
        pulumi.set(__self__, "commitment", commitment)
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "satisfies_pzs", satisfies_pzs)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "share_settings", share_settings)
        pulumi.set(__self__, "specific_reservation", specific_reservation)
        pulumi.set(__self__, "specific_reservation_required", specific_reservation_required)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def commitment(self) -> str:
        """
        Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
        """
        return pulumi.get(self, "commitment")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> str:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#reservations for reservations.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> bool:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        Server-defined fully-qualified URL for this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> 'outputs.ShareSettingsResponse':
        """
        Share-settings for shared-reservation
        """
        return pulumi.get(self, "share_settings")

    @property
    @pulumi.getter(name="specificReservation")
    def specific_reservation(self) -> 'outputs.AllocationSpecificSKUReservationResponse':
        """
        Reservation for instances with specific machine shapes.
        """
        return pulumi.get(self, "specific_reservation")

    @property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> bool:
        """
        Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
        """
        return pulumi.get(self, "specific_reservation_required")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the reservation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ResourceCommitmentResponse(dict):
    """
    Commitment for a particular resource (a Commitment is composed of one or more of these).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorType":
            suggest = "accelerator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceCommitmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceCommitmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceCommitmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_type: str,
                 amount: str,
                 type: str):
        """
        Commitment for a particular resource (a Commitment is composed of one or more of these).
        :param str accelerator_type: Name of the accelerator type resource. Applicable only when the type is ACCELERATOR.
        :param str amount: The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of 256 MB, with up to 6.5GB of memory per every vCPU.
        :param str type: Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
        """
        pulumi.set(__self__, "accelerator_type", accelerator_type)
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> str:
        """
        Name of the accelerator type resource. Applicable only when the type is ACCELERATOR.
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter
    def amount(self) -> str:
        """
        The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of 256 MB, with up to 6.5GB of memory per every vCPU.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ResourcePolicyDailyCycleResponse(dict):
    """
    Time window specified for daily operations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysInCycle":
            suggest = "days_in_cycle"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyDailyCycleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyDailyCycleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyDailyCycleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_in_cycle: int,
                 duration: str,
                 start_time: str):
        """
        Time window specified for daily operations.
        :param int days_in_cycle: Defines a schedule with units measured in months. The value determines how many months pass between the start of each cycle.
        :param str duration: [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
        :param str start_time: Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
        """
        pulumi.set(__self__, "days_in_cycle", days_in_cycle)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="daysInCycle")
    def days_in_cycle(self) -> int:
        """
        Defines a schedule with units measured in months. The value determines how many months pass between the start of each cycle.
        """
        return pulumi.get(self, "days_in_cycle")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        [Output only] A predetermined duration for the window, automatically chosen to be the smallest possible in the given scenario.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ResourcePolicyGroupPlacementPolicyResponse(dict):
    """
    A GroupPlacementPolicy specifies resource placement configuration. It specifies the failure bucket separation as well as network locality
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomainCount":
            suggest = "availability_domain_count"
        elif key == "vmCount":
            suggest = "vm_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyGroupPlacementPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyGroupPlacementPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyGroupPlacementPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain_count: int,
                 collocation: str,
                 vm_count: int):
        """
        A GroupPlacementPolicy specifies resource placement configuration. It specifies the failure bucket separation as well as network locality
        :param int availability_domain_count: The number of availability domains instances will be spread across. If two instances are in different availability domain, they will not be put in the same low latency network
        :param str collocation: Specifies network collocation
        :param int vm_count: Number of vms in this placement group
        """
        pulumi.set(__self__, "availability_domain_count", availability_domain_count)
        pulumi.set(__self__, "collocation", collocation)
        pulumi.set(__self__, "vm_count", vm_count)

    @property
    @pulumi.getter(name="availabilityDomainCount")
    def availability_domain_count(self) -> int:
        """
        The number of availability domains instances will be spread across. If two instances are in different availability domain, they will not be put in the same low latency network
        """
        return pulumi.get(self, "availability_domain_count")

    @property
    @pulumi.getter
    def collocation(self) -> str:
        """
        Specifies network collocation
        """
        return pulumi.get(self, "collocation")

    @property
    @pulumi.getter(name="vmCount")
    def vm_count(self) -> int:
        """
        Number of vms in this placement group
        """
        return pulumi.get(self, "vm_count")


@pulumi.output_type
class ResourcePolicyHourlyCycleResponse(dict):
    """
    Time window specified for hourly operations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hoursInCycle":
            suggest = "hours_in_cycle"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyHourlyCycleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyHourlyCycleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyHourlyCycleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 hours_in_cycle: int,
                 start_time: str):
        """
        Time window specified for hourly operations.
        :param str duration: [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
        :param int hours_in_cycle: Defines a schedule with units measured in hours. The value determines how many hours pass between the start of each cycle.
        :param str start_time: Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "hours_in_cycle", hours_in_cycle)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="hoursInCycle")
    def hours_in_cycle(self) -> int:
        """
        Defines a schedule with units measured in hours. The value determines how many hours pass between the start of each cycle.
        """
        return pulumi.get(self, "hours_in_cycle")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ResourcePolicyInstanceSchedulePolicyResponse(dict):
    """
    An InstanceSchedulePolicy specifies when and how frequent certain operations are performed on the instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationTime":
            suggest = "expiration_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "vmStartSchedule":
            suggest = "vm_start_schedule"
        elif key == "vmStopSchedule":
            suggest = "vm_stop_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyInstanceSchedulePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyInstanceSchedulePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyInstanceSchedulePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_time: str,
                 start_time: str,
                 time_zone: str,
                 vm_start_schedule: 'outputs.ResourcePolicyInstanceSchedulePolicyScheduleResponse',
                 vm_stop_schedule: 'outputs.ResourcePolicyInstanceSchedulePolicyScheduleResponse'):
        """
        An InstanceSchedulePolicy specifies when and how frequent certain operations are performed on the instance.
        :param str expiration_time: The expiration time of the schedule. The timestamp is an RFC3339 string.
        :param str start_time: The start time of the schedule. The timestamp is an RFC3339 string.
        :param str time_zone: Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
        :param 'ResourcePolicyInstanceSchedulePolicyScheduleResponse' vm_start_schedule: Specifies the schedule for starting instances.
        :param 'ResourcePolicyInstanceSchedulePolicyScheduleResponse' vm_stop_schedule: Specifies the schedule for stopping instances.
        """
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "vm_start_schedule", vm_start_schedule)
        pulumi.set(__self__, "vm_stop_schedule", vm_stop_schedule)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        The expiration time of the schedule. The timestamp is an RFC3339 string.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the schedule. The timestamp is an RFC3339 string.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vmStartSchedule")
    def vm_start_schedule(self) -> 'outputs.ResourcePolicyInstanceSchedulePolicyScheduleResponse':
        """
        Specifies the schedule for starting instances.
        """
        return pulumi.get(self, "vm_start_schedule")

    @property
    @pulumi.getter(name="vmStopSchedule")
    def vm_stop_schedule(self) -> 'outputs.ResourcePolicyInstanceSchedulePolicyScheduleResponse':
        """
        Specifies the schedule for stopping instances.
        """
        return pulumi.get(self, "vm_stop_schedule")


@pulumi.output_type
class ResourcePolicyInstanceSchedulePolicyScheduleResponse(dict):
    """
    Schedule for an instance operation.
    """
    def __init__(__self__, *,
                 schedule: str):
        """
        Schedule for an instance operation.
        :param str schedule: Specifies the frequency for the operation, using the unix-cron format.
        """
        pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Specifies the frequency for the operation, using the unix-cron format.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class ResourcePolicyResourceStatusInstanceSchedulePolicyStatusResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRunStartTime":
            suggest = "last_run_start_time"
        elif key == "nextRunStartTime":
            suggest = "next_run_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyResourceStatusInstanceSchedulePolicyStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyResourceStatusInstanceSchedulePolicyStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyResourceStatusInstanceSchedulePolicyStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_run_start_time: str,
                 next_run_start_time: str):
        """
        :param str last_run_start_time: The last time the schedule successfully ran. The timestamp is an RFC3339 string.
        :param str next_run_start_time: The next time the schedule is planned to run. The actual time might be slightly different. The timestamp is an RFC3339 string.
        """
        pulumi.set(__self__, "last_run_start_time", last_run_start_time)
        pulumi.set(__self__, "next_run_start_time", next_run_start_time)

    @property
    @pulumi.getter(name="lastRunStartTime")
    def last_run_start_time(self) -> str:
        """
        The last time the schedule successfully ran. The timestamp is an RFC3339 string.
        """
        return pulumi.get(self, "last_run_start_time")

    @property
    @pulumi.getter(name="nextRunStartTime")
    def next_run_start_time(self) -> str:
        """
        The next time the schedule is planned to run. The actual time might be slightly different. The timestamp is an RFC3339 string.
        """
        return pulumi.get(self, "next_run_start_time")


@pulumi.output_type
class ResourcePolicyResourceStatusResponse(dict):
    """
    Contains output only fields. Use this sub-message for all output fields set on ResourcePolicy. The internal structure of this "status" field should mimic the structure of ResourcePolicy proto specification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceSchedulePolicy":
            suggest = "instance_schedule_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyResourceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyResourceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyResourceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_schedule_policy: 'outputs.ResourcePolicyResourceStatusInstanceSchedulePolicyStatusResponse'):
        """
        Contains output only fields. Use this sub-message for all output fields set on ResourcePolicy. The internal structure of this "status" field should mimic the structure of ResourcePolicy proto specification.
        :param 'ResourcePolicyResourceStatusInstanceSchedulePolicyStatusResponse' instance_schedule_policy: Specifies a set of output values reffering to the instance_schedule_policy system status. This field should have the same name as corresponding policy field.
        """
        pulumi.set(__self__, "instance_schedule_policy", instance_schedule_policy)

    @property
    @pulumi.getter(name="instanceSchedulePolicy")
    def instance_schedule_policy(self) -> 'outputs.ResourcePolicyResourceStatusInstanceSchedulePolicyStatusResponse':
        """
        Specifies a set of output values reffering to the instance_schedule_policy system status. This field should have the same name as corresponding policy field.
        """
        return pulumi.get(self, "instance_schedule_policy")


@pulumi.output_type
class ResourcePolicySnapshotSchedulePolicyResponse(dict):
    """
    A snapshot schedule policy specifies when and how frequently snapshots are to be created for the target disk. Also specifies how many and how long these scheduled snapshots should be retained.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "snapshotProperties":
            suggest = "snapshot_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicySnapshotSchedulePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicySnapshotSchedulePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicySnapshotSchedulePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_policy: 'outputs.ResourcePolicySnapshotSchedulePolicyRetentionPolicyResponse',
                 schedule: 'outputs.ResourcePolicySnapshotSchedulePolicyScheduleResponse',
                 snapshot_properties: 'outputs.ResourcePolicySnapshotSchedulePolicySnapshotPropertiesResponse'):
        """
        A snapshot schedule policy specifies when and how frequently snapshots are to be created for the target disk. Also specifies how many and how long these scheduled snapshots should be retained.
        :param 'ResourcePolicySnapshotSchedulePolicyRetentionPolicyResponse' retention_policy: Retention policy applied to snapshots created by this resource policy.
        :param 'ResourcePolicySnapshotSchedulePolicyScheduleResponse' schedule: A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
        :param 'ResourcePolicySnapshotSchedulePolicySnapshotPropertiesResponse' snapshot_properties: Properties with which snapshots are created such as labels, encryption keys.
        """
        pulumi.set(__self__, "retention_policy", retention_policy)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "snapshot_properties", snapshot_properties)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> 'outputs.ResourcePolicySnapshotSchedulePolicyRetentionPolicyResponse':
        """
        Retention policy applied to snapshots created by this resource policy.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter
    def schedule(self) -> 'outputs.ResourcePolicySnapshotSchedulePolicyScheduleResponse':
        """
        A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="snapshotProperties")
    def snapshot_properties(self) -> 'outputs.ResourcePolicySnapshotSchedulePolicySnapshotPropertiesResponse':
        """
        Properties with which snapshots are created such as labels, encryption keys.
        """
        return pulumi.get(self, "snapshot_properties")


@pulumi.output_type
class ResourcePolicySnapshotSchedulePolicyRetentionPolicyResponse(dict):
    """
    Policy for retention of scheduled snapshots.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRetentionDays":
            suggest = "max_retention_days"
        elif key == "onSourceDiskDelete":
            suggest = "on_source_disk_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicySnapshotSchedulePolicyRetentionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicySnapshotSchedulePolicyRetentionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicySnapshotSchedulePolicyRetentionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_retention_days: int,
                 on_source_disk_delete: str):
        """
        Policy for retention of scheduled snapshots.
        :param int max_retention_days: Maximum age of the snapshot that is allowed to be kept.
        :param str on_source_disk_delete: Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
        """
        pulumi.set(__self__, "max_retention_days", max_retention_days)
        pulumi.set(__self__, "on_source_disk_delete", on_source_disk_delete)

    @property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> int:
        """
        Maximum age of the snapshot that is allowed to be kept.
        """
        return pulumi.get(self, "max_retention_days")

    @property
    @pulumi.getter(name="onSourceDiskDelete")
    def on_source_disk_delete(self) -> str:
        """
        Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
        """
        return pulumi.get(self, "on_source_disk_delete")


@pulumi.output_type
class ResourcePolicySnapshotSchedulePolicyScheduleResponse(dict):
    """
    A schedule for disks where the schedueled operations are performed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailySchedule":
            suggest = "daily_schedule"
        elif key == "hourlySchedule":
            suggest = "hourly_schedule"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicySnapshotSchedulePolicyScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicySnapshotSchedulePolicyScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicySnapshotSchedulePolicyScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_schedule: 'outputs.ResourcePolicyDailyCycleResponse',
                 hourly_schedule: 'outputs.ResourcePolicyHourlyCycleResponse',
                 weekly_schedule: 'outputs.ResourcePolicyWeeklyCycleResponse'):
        """
        A schedule for disks where the schedueled operations are performed.
        """
        pulumi.set(__self__, "daily_schedule", daily_schedule)
        pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> 'outputs.ResourcePolicyDailyCycleResponse':
        return pulumi.get(self, "daily_schedule")

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> 'outputs.ResourcePolicyHourlyCycleResponse':
        return pulumi.get(self, "hourly_schedule")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> 'outputs.ResourcePolicyWeeklyCycleResponse':
        return pulumi.get(self, "weekly_schedule")


@pulumi.output_type
class ResourcePolicySnapshotSchedulePolicySnapshotPropertiesResponse(dict):
    """
    Specified snapshot properties for scheduled snapshots created by this policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chainName":
            suggest = "chain_name"
        elif key == "guestFlush":
            suggest = "guest_flush"
        elif key == "storageLocations":
            suggest = "storage_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicySnapshotSchedulePolicySnapshotPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicySnapshotSchedulePolicySnapshotPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicySnapshotSchedulePolicySnapshotPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chain_name: str,
                 guest_flush: bool,
                 labels: Mapping[str, str],
                 storage_locations: Sequence[str]):
        """
        Specified snapshot properties for scheduled snapshots created by this policy.
        :param str chain_name: Chain name that the snapshot is created in.
        :param bool guest_flush: Indication to perform a 'guest aware' snapshot.
        :param Mapping[str, str] labels: Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
        :param Sequence[str] storage_locations: Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
        """
        pulumi.set(__self__, "chain_name", chain_name)
        pulumi.set(__self__, "guest_flush", guest_flush)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "storage_locations", storage_locations)

    @property
    @pulumi.getter(name="chainName")
    def chain_name(self) -> str:
        """
        Chain name that the snapshot is created in.
        """
        return pulumi.get(self, "chain_name")

    @property
    @pulumi.getter(name="guestFlush")
    def guest_flush(self) -> bool:
        """
        Indication to perform a 'guest aware' snapshot.
        """
        return pulumi.get(self, "guest_flush")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels to apply to scheduled snapshots. These can be later modified by the setLabels method. Label values may be empty.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="storageLocations")
    def storage_locations(self) -> Sequence[str]:
        """
        Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
        """
        return pulumi.get(self, "storage_locations")


@pulumi.output_type
class ResourcePolicyWeeklyCycleDayOfWeekResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyWeeklyCycleDayOfWeekResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyWeeklyCycleDayOfWeekResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyWeeklyCycleDayOfWeekResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: str,
                 duration: str,
                 start_time: str):
        """
        :param str day: Defines a schedule that runs on specific days of the week. Specify one or more days. The following options are available: MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.
        :param str duration: [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
        :param str start_time: Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        Defines a schedule that runs on specific days of the week. Specify one or more days. The following options are available: MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time within the window to start the operations. It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ResourcePolicyWeeklyCycleResponse(dict):
    """
    Time window specified for weekly operations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeeks":
            suggest = "day_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePolicyWeeklyCycleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePolicyWeeklyCycleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePolicyWeeklyCycleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_weeks: Sequence['outputs.ResourcePolicyWeeklyCycleDayOfWeekResponse']):
        """
        Time window specified for weekly operations.
        :param Sequence['ResourcePolicyWeeklyCycleDayOfWeekResponse'] day_of_weeks: Up to 7 intervals/windows, one for each day of the week.
        """
        pulumi.set(__self__, "day_of_weeks", day_of_weeks)

    @property
    @pulumi.getter(name="dayOfWeeks")
    def day_of_weeks(self) -> Sequence['outputs.ResourcePolicyWeeklyCycleDayOfWeekResponse']:
        """
        Up to 7 intervals/windows, one for each day of the week.
        """
        return pulumi.get(self, "day_of_weeks")


@pulumi.output_type
class RolloutPolicyResponse(dict):
    """
    A rollout policy configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRolloutTime":
            suggest = "default_rollout_time"
        elif key == "locationRolloutPolicies":
            suggest = "location_rollout_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolloutPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolloutPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolloutPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_rollout_time: str,
                 location_rollout_policies: Mapping[str, str]):
        """
        A rollout policy configuration.
        :param str default_rollout_time: An optional RFC3339 timestamp on or after which the update is considered rolled out to any zone that is not explicitly stated.
        :param Mapping[str, str] location_rollout_policies: Location based rollout policies to apply to the resource. Currently only zone names are supported and must be represented as valid URLs, like: zones/us-central1-a. The value expects an RFC3339 timestamp on or after which the update is considered rolled out to the specified location.
        """
        pulumi.set(__self__, "default_rollout_time", default_rollout_time)
        pulumi.set(__self__, "location_rollout_policies", location_rollout_policies)

    @property
    @pulumi.getter(name="defaultRolloutTime")
    def default_rollout_time(self) -> str:
        """
        An optional RFC3339 timestamp on or after which the update is considered rolled out to any zone that is not explicitly stated.
        """
        return pulumi.get(self, "default_rollout_time")

    @property
    @pulumi.getter(name="locationRolloutPolicies")
    def location_rollout_policies(self) -> Mapping[str, str]:
        """
        Location based rollout policies to apply to the resource. Currently only zone names are supported and must be represented as valid URLs, like: zones/us-central1-a. The value expects an RFC3339 timestamp on or after which the update is considered rolled out to the specified location.
        """
        return pulumi.get(self, "location_rollout_policies")


@pulumi.output_type
class RouteAsPathResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "asLists":
            suggest = "as_lists"
        elif key == "pathSegmentType":
            suggest = "path_segment_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteAsPathResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteAsPathResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteAsPathResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 as_lists: Sequence[int],
                 path_segment_type: str):
        """
        :param Sequence[int] as_lists: The AS numbers of the AS Path.
        :param str path_segment_type: The type of the AS Path, which can be one of the following values: - 'AS_SET': unordered set of autonomous systems that the route in has traversed - 'AS_SEQUENCE': ordered set of autonomous systems that the route has traversed - 'AS_CONFED_SEQUENCE': ordered set of Member Autonomous Systems in the local confederation that the route has traversed - 'AS_CONFED_SET': unordered set of Member Autonomous Systems in the local confederation that the route has traversed 
        """
        pulumi.set(__self__, "as_lists", as_lists)
        pulumi.set(__self__, "path_segment_type", path_segment_type)

    @property
    @pulumi.getter(name="asLists")
    def as_lists(self) -> Sequence[int]:
        """
        The AS numbers of the AS Path.
        """
        return pulumi.get(self, "as_lists")

    @property
    @pulumi.getter(name="pathSegmentType")
    def path_segment_type(self) -> str:
        """
        The type of the AS Path, which can be one of the following values: - 'AS_SET': unordered set of autonomous systems that the route in has traversed - 'AS_SEQUENCE': ordered set of autonomous systems that the route has traversed - 'AS_CONFED_SEQUENCE': ordered set of Member Autonomous Systems in the local confederation that the route has traversed - 'AS_CONFED_SET': unordered set of Member Autonomous Systems in the local confederation that the route has traversed 
        """
        return pulumi.get(self, "path_segment_type")


@pulumi.output_type
class RouteWarningsItemDataItemResponse(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: A key that provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement, or a warning about invalid network settings (for example, if an instance attempts to perform IP forwarding but is not enabled for IP forwarding).
        :param str value: A warning data value corresponding to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A key that provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement, or a warning about invalid network settings (for example, if an instance attempts to perform IP forwarding but is not enabled for IP forwarding).
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A warning data value corresponding to the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RouteWarningsItemResponse(dict):
    def __init__(__self__, *,
                 code: str,
                 data: Sequence['outputs.RouteWarningsItemDataItemResponse'],
                 message: str):
        """
        :param str code: A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
        :param Sequence['RouteWarningsItemDataItemResponse'] data: Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } 
        :param str message: A human-readable description of the warning code.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def data(self) -> Sequence['outputs.RouteWarningsItemDataItemResponse']:
        """
        Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } 
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable description of the warning code.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class RouterAdvertisedIpRangeResponse(dict):
    """
    Description-tagged IP ranges for the router to advertise.
    """
    def __init__(__self__, *,
                 description: str,
                 range: str):
        """
        Description-tagged IP ranges for the router to advertise.
        :param str description: User-specified description for the IP range.
        :param str range: The IP range to advertise. The value must be a CIDR-formatted string.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User-specified description for the IP range.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def range(self) -> str:
        """
        The IP range to advertise. The value must be a CIDR-formatted string.
        """
        return pulumi.get(self, "range")


@pulumi.output_type
class RouterBgpPeerBfdResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReceiveInterval":
            suggest = "min_receive_interval"
        elif key == "minTransmitInterval":
            suggest = "min_transmit_interval"
        elif key == "sessionInitializationMode":
            suggest = "session_initialization_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouterBgpPeerBfdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouterBgpPeerBfdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouterBgpPeerBfdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_receive_interval: int,
                 min_transmit_interval: int,
                 multiplier: int,
                 session_initialization_mode: str):
        """
        :param int min_receive_interval: The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
        :param int min_transmit_interval: The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
        :param int multiplier: The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
        :param str session_initialization_mode: The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is PASSIVE.
        """
        pulumi.set(__self__, "min_receive_interval", min_receive_interval)
        pulumi.set(__self__, "min_transmit_interval", min_transmit_interval)
        pulumi.set(__self__, "multiplier", multiplier)
        pulumi.set(__self__, "session_initialization_mode", session_initialization_mode)

    @property
    @pulumi.getter(name="minReceiveInterval")
    def min_receive_interval(self) -> int:
        """
        The minimum interval, in milliseconds, between BFD control packets received from the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the transmit interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
        """
        return pulumi.get(self, "min_receive_interval")

    @property
    @pulumi.getter(name="minTransmitInterval")
    def min_transmit_interval(self) -> int:
        """
        The minimum interval, in milliseconds, between BFD control packets transmitted to the peer router. The actual value is negotiated between the two routers and is equal to the greater of this value and the corresponding receive interval of the other router. If set, this value must be between 1000 and 30000. The default is 1000.
        """
        return pulumi.get(self, "min_transmit_interval")

    @property
    @pulumi.getter
    def multiplier(self) -> int:
        """
        The number of consecutive BFD packets that must be missed before BFD declares that a peer is unavailable. If set, the value must be a value between 5 and 16. The default is 5.
        """
        return pulumi.get(self, "multiplier")

    @property
    @pulumi.getter(name="sessionInitializationMode")
    def session_initialization_mode(self) -> str:
        """
        The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is PASSIVE.
        """
        return pulumi.get(self, "session_initialization_mode")


@pulumi.output_type
class RouterBgpPeerResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advertiseMode":
            suggest = "advertise_mode"
        elif key == "advertisedGroups":
            suggest = "advertised_groups"
        elif key == "advertisedIpRanges":
            suggest = "advertised_ip_ranges"
        elif key == "advertisedRoutePriority":
            suggest = "advertised_route_priority"
        elif key == "enableIpv6":
            suggest = "enable_ipv6"
        elif key == "interfaceName":
            suggest = "interface_name"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipv6NexthopAddress":
            suggest = "ipv6_nexthop_address"
        elif key == "managementType":
            suggest = "management_type"
        elif key == "peerAsn":
            suggest = "peer_asn"
        elif key == "peerIpAddress":
            suggest = "peer_ip_address"
        elif key == "peerIpv6NexthopAddress":
            suggest = "peer_ipv6_nexthop_address"
        elif key == "routerApplianceInstance":
            suggest = "router_appliance_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouterBgpPeerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouterBgpPeerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouterBgpPeerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advertise_mode: str,
                 advertised_groups: Sequence[str],
                 advertised_ip_ranges: Sequence['outputs.RouterAdvertisedIpRangeResponse'],
                 advertised_route_priority: int,
                 bfd: 'outputs.RouterBgpPeerBfdResponse',
                 enable: str,
                 enable_ipv6: bool,
                 interface_name: str,
                 ip_address: str,
                 ipv6_nexthop_address: str,
                 management_type: str,
                 name: str,
                 peer_asn: int,
                 peer_ip_address: str,
                 peer_ipv6_nexthop_address: str,
                 router_appliance_instance: str):
        """
        :param str advertise_mode: User-specified flag to indicate which mode to use for advertisement.
        :param Sequence[str] advertised_groups: User-specified list of prefix groups to advertise in custom mode, which can take one of the following options: - ALL_SUBNETS: Advertises all available subnets, including peer VPC subnets. - ALL_VPC_SUBNETS: Advertises the router's own VPC subnets. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
        :param Sequence['RouterAdvertisedIpRangeResponse'] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
        :param int advertised_route_priority: The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
        :param 'RouterBgpPeerBfdResponse' bfd: BFD configuration for the BGP peering.
        :param str enable: The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
        :param bool enable_ipv6: Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        :param str interface_name: Name of the interface the BGP peer is associated with.
        :param str ip_address: IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.
        :param str ipv6_nexthop_address: IPv6 address of the interface inside Google Cloud Platform.
        :param str management_type: The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted. 
        :param str name: Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param int peer_asn: Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
        :param str peer_ip_address: IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported.
        :param str peer_ipv6_nexthop_address: IPv6 address of the BGP interface outside Google Cloud Platform.
        :param str router_appliance_instance: URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        pulumi.set(__self__, "advertise_mode", advertise_mode)
        pulumi.set(__self__, "advertised_groups", advertised_groups)
        pulumi.set(__self__, "advertised_ip_ranges", advertised_ip_ranges)
        pulumi.set(__self__, "advertised_route_priority", advertised_route_priority)
        pulumi.set(__self__, "bfd", bfd)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        pulumi.set(__self__, "interface_name", interface_name)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ipv6_nexthop_address", ipv6_nexthop_address)
        pulumi.set(__self__, "management_type", management_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        pulumi.set(__self__, "peer_ipv6_nexthop_address", peer_ipv6_nexthop_address)
        pulumi.set(__self__, "router_appliance_instance", router_appliance_instance)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> str:
        """
        User-specified flag to indicate which mode to use for advertisement.
        """
        return pulumi.get(self, "advertise_mode")

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> Sequence[str]:
        """
        User-specified list of prefix groups to advertise in custom mode, which can take one of the following options: - ALL_SUBNETS: Advertises all available subnets, including peer VPC subnets. - ALL_VPC_SUBNETS: Advertises the router's own VPC subnets. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
        """
        return pulumi.get(self, "advertised_groups")

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> Sequence['outputs.RouterAdvertisedIpRangeResponse']:
        """
        User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @property
    @pulumi.getter(name="advertisedRoutePriority")
    def advertised_route_priority(self) -> int:
        """
        The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
        """
        return pulumi.get(self, "advertised_route_priority")

    @property
    @pulumi.getter
    def bfd(self) -> 'outputs.RouterBgpPeerBfdResponse':
        """
        BFD configuration for the BGP peering.
        """
        return pulumi.get(self, "bfd")

    @property
    @pulumi.getter
    def enable(self) -> str:
        """
        The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> bool:
        """
        Enable IPv6 traffic over BGP Peer. If not specified, it is disabled by default.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> str:
        """
        Name of the interface the BGP peer is associated with.
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP address of the interface inside Google Cloud Platform. Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipv6NexthopAddress")
    def ipv6_nexthop_address(self) -> str:
        """
        IPv6 address of the interface inside Google Cloud Platform.
        """
        return pulumi.get(self, "ipv6_nexthop_address")

    @property
    @pulumi.getter(name="managementType")
    def management_type(self) -> str:
        """
        The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted. 
        """
        return pulumi.get(self, "management_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> int:
        """
        Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> str:
        """
        IP address of the BGP interface outside Google Cloud Platform. Only IPv4 is supported.
        """
        return pulumi.get(self, "peer_ip_address")

    @property
    @pulumi.getter(name="peerIpv6NexthopAddress")
    def peer_ipv6_nexthop_address(self) -> str:
        """
        IPv6 address of the BGP interface outside Google Cloud Platform.
        """
        return pulumi.get(self, "peer_ipv6_nexthop_address")

    @property
    @pulumi.getter(name="routerApplianceInstance")
    def router_appliance_instance(self) -> str:
        """
        URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        return pulumi.get(self, "router_appliance_instance")


@pulumi.output_type
class RouterBgpResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advertiseMode":
            suggest = "advertise_mode"
        elif key == "advertisedGroups":
            suggest = "advertised_groups"
        elif key == "advertisedIpRanges":
            suggest = "advertised_ip_ranges"
        elif key == "keepaliveInterval":
            suggest = "keepalive_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouterBgpResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouterBgpResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouterBgpResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advertise_mode: str,
                 advertised_groups: Sequence[str],
                 advertised_ip_ranges: Sequence['outputs.RouterAdvertisedIpRangeResponse'],
                 asn: int,
                 keepalive_interval: int):
        """
        :param str advertise_mode: User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
        :param Sequence[str] advertised_groups: User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
        :param Sequence['RouterAdvertisedIpRangeResponse'] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
        :param int asn: Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
        :param int keepalive_interval: The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
        """
        pulumi.set(__self__, "advertise_mode", advertise_mode)
        pulumi.set(__self__, "advertised_groups", advertised_groups)
        pulumi.set(__self__, "advertised_ip_ranges", advertised_ip_ranges)
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "keepalive_interval", keepalive_interval)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> str:
        """
        User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
        """
        return pulumi.get(self, "advertise_mode")

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> Sequence[str]:
        """
        User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
        """
        return pulumi.get(self, "advertised_groups")

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> Sequence['outputs.RouterAdvertisedIpRangeResponse']:
        """
        User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @property
    @pulumi.getter
    def asn(self) -> int:
        """
        Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="keepaliveInterval")
    def keepalive_interval(self) -> int:
        """
        The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
        """
        return pulumi.get(self, "keepalive_interval")


@pulumi.output_type
class RouterInterfaceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "linkedInterconnectAttachment":
            suggest = "linked_interconnect_attachment"
        elif key == "linkedVpnTunnel":
            suggest = "linked_vpn_tunnel"
        elif key == "managementType":
            suggest = "management_type"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "redundantInterface":
            suggest = "redundant_interface"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouterInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouterInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouterInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_range: str,
                 linked_interconnect_attachment: str,
                 linked_vpn_tunnel: str,
                 management_type: str,
                 name: str,
                 private_ip_address: str,
                 redundant_interface: str,
                 subnetwork: str):
        """
        :param str ip_range: IP address and range of the interface. The IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate the address as it represents the IP address of the interface.
        :param str linked_interconnect_attachment: URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
        :param str linked_vpn_tunnel: URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
        :param str management_type: The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted. 
        :param str name: Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param str private_ip_address: The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
        :param str redundant_interface: Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param str subnetwork: The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "linked_interconnect_attachment", linked_interconnect_attachment)
        pulumi.set(__self__, "linked_vpn_tunnel", linked_vpn_tunnel)
        pulumi.set(__self__, "management_type", management_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "redundant_interface", redundant_interface)
        pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        """
        IP address and range of the interface. The IP range must be in the RFC3927 link-local IP address space. The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate the address as it represents the IP address of the interface.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter(name="linkedInterconnectAttachment")
    def linked_interconnect_attachment(self) -> str:
        """
        URI of the linked Interconnect attachment. It must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
        """
        return pulumi.get(self, "linked_interconnect_attachment")

    @property
    @pulumi.getter(name="linkedVpnTunnel")
    def linked_vpn_tunnel(self) -> str:
        """
        URI of the linked VPN tunnel, which must be in the same region as the router. Each interface can have one linked resource, which can be a VPN tunnel, an Interconnect attachment, or a virtual machine instance.
        """
        return pulumi.get(self, "linked_vpn_tunnel")

    @property
    @pulumi.getter(name="managementType")
    def management_type(self) -> str:
        """
        The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted. 
        """
        return pulumi.get(self, "management_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this interface entry. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        The regional private internal IP address that is used to establish BGP sessions to a VM instance acting as a third-party Router Appliance, such as a Next Gen Firewall, a Virtual Router, or an SD-WAN VM.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="redundantInterface")
    def redundant_interface(self) -> str:
        """
        Name of the interface that will be redundant with the current interface you are creating. The redundantInterface must belong to the same Cloud Router as the interface here. To establish the BGP session to a Router Appliance VM, you must create two BGP peers. The two BGP peers must be attached to two separate interfaces that are redundant with each other. The redundant_interface must be 1-63 characters long, and comply with RFC1035. Specifically, the redundant_interface must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "redundant_interface")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The URI of the subnetwork resource that this interface belongs to, which must be in the same region as the Cloud Router. When you establish a BGP session to a VM instance using this interface, the VM instance must belong to the same subnetwork as the subnetwork specified here.
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class RouterNatLogConfigResponse(dict):
    """
    Configuration of logging on a NAT.
    """
    def __init__(__self__, *,
                 enable: bool,
                 filter: str):
        """
        Configuration of logging on a NAT.
        :param bool enable: Indicates whether or not to export logs. This is false by default.
        :param str filter: Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all connections handled by this NAT. This option can take one of the following values: - ERRORS_ONLY: Export logs only for connection failures. - TRANSLATIONS_ONLY: Export logs only for successful connections. - ALL: Export logs for all connections, successful and unsuccessful. 
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Indicates whether or not to export logs. This is false by default.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all connections handled by this NAT. This option can take one of the following values: - ERRORS_ONLY: Export logs only for connection failures. - TRANSLATIONS_ONLY: Export logs only for successful connections. - ALL: Export logs for all connections, successful and unsuccessful. 
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class RouterNatResponse(dict):
    """
    Represents a Nat resource. It enables the VMs within the specified subnetworks to access Internet without external IP addresses. It specifies a list of subnetworks (and the ranges within) that want to use NAT. Customers can also provide the external IPs that would be used for NAT. GCP would auto-allocate ephemeral IPs if no external IPs are provided.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drainNatIps":
            suggest = "drain_nat_ips"
        elif key == "enableDynamicPortAllocation":
            suggest = "enable_dynamic_port_allocation"
        elif key == "enableEndpointIndependentMapping":
            suggest = "enable_endpoint_independent_mapping"
        elif key == "icmpIdleTimeoutSec":
            suggest = "icmp_idle_timeout_sec"
        elif key == "logConfig":
            suggest = "log_config"
        elif key == "maxPortsPerVm":
            suggest = "max_ports_per_vm"
        elif key == "minPortsPerVm":
            suggest = "min_ports_per_vm"
        elif key == "natIpAllocateOption":
            suggest = "nat_ip_allocate_option"
        elif key == "natIps":
            suggest = "nat_ips"
        elif key == "sourceSubnetworkIpRangesToNat":
            suggest = "source_subnetwork_ip_ranges_to_nat"
        elif key == "tcpEstablishedIdleTimeoutSec":
            suggest = "tcp_established_idle_timeout_sec"
        elif key == "tcpTimeWaitTimeoutSec":
            suggest = "tcp_time_wait_timeout_sec"
        elif key == "tcpTransitoryIdleTimeoutSec":
            suggest = "tcp_transitory_idle_timeout_sec"
        elif key == "udpIdleTimeoutSec":
            suggest = "udp_idle_timeout_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouterNatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouterNatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouterNatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drain_nat_ips: Sequence[str],
                 enable_dynamic_port_allocation: bool,
                 enable_endpoint_independent_mapping: bool,
                 icmp_idle_timeout_sec: int,
                 log_config: 'outputs.RouterNatLogConfigResponse',
                 max_ports_per_vm: int,
                 min_ports_per_vm: int,
                 name: str,
                 nat_ip_allocate_option: str,
                 nat_ips: Sequence[str],
                 rules: Sequence['outputs.RouterNatRuleResponse'],
                 source_subnetwork_ip_ranges_to_nat: str,
                 subnetworks: Sequence['outputs.RouterNatSubnetworkToNatResponse'],
                 tcp_established_idle_timeout_sec: int,
                 tcp_time_wait_timeout_sec: int,
                 tcp_transitory_idle_timeout_sec: int,
                 udp_idle_timeout_sec: int):
        """
        Represents a Nat resource. It enables the VMs within the specified subnetworks to access Internet without external IP addresses. It specifies a list of subnetworks (and the ranges within) that want to use NAT. Customers can also provide the external IPs that would be used for NAT. GCP would auto-allocate ephemeral IPs if no external IPs are provided.
        :param Sequence[str] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
        :param bool enable_dynamic_port_allocation: Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config. 
        :param int icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param 'RouterNatLogConfigResponse' log_config: Configure logging on this NAT.
        :param int max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        :param int min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
        :param str name: Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
        :param str nat_ip_allocate_option: Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty. 
        :param Sequence[str] nat_ips: A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
        :param Sequence['RouterNatRuleResponse'] rules: A list of rules associated with this NAT.
        :param str source_subnetwork_ip_ranges_to_nat: Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
        :param Sequence['RouterNatSubnetworkToNatResponse'] subnetworks: A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
        :param int tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
        :param int tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
        :param int tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
        :param int udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        pulumi.set(__self__, "drain_nat_ips", drain_nat_ips)
        pulumi.set(__self__, "enable_dynamic_port_allocation", enable_dynamic_port_allocation)
        pulumi.set(__self__, "enable_endpoint_independent_mapping", enable_endpoint_independent_mapping)
        pulumi.set(__self__, "icmp_idle_timeout_sec", icmp_idle_timeout_sec)
        pulumi.set(__self__, "log_config", log_config)
        pulumi.set(__self__, "max_ports_per_vm", max_ports_per_vm)
        pulumi.set(__self__, "min_ports_per_vm", min_ports_per_vm)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_ip_allocate_option", nat_ip_allocate_option)
        pulumi.set(__self__, "nat_ips", nat_ips)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "source_subnetwork_ip_ranges_to_nat", source_subnetwork_ip_ranges_to_nat)
        pulumi.set(__self__, "subnetworks", subnetworks)
        pulumi.set(__self__, "tcp_established_idle_timeout_sec", tcp_established_idle_timeout_sec)
        pulumi.set(__self__, "tcp_time_wait_timeout_sec", tcp_time_wait_timeout_sec)
        pulumi.set(__self__, "tcp_transitory_idle_timeout_sec", tcp_transitory_idle_timeout_sec)
        pulumi.set(__self__, "udp_idle_timeout_sec", udp_idle_timeout_sec)

    @property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> Sequence[str]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
        """
        return pulumi.get(self, "drain_nat_ips")

    @property
    @pulumi.getter(name="enableDynamicPortAllocation")
    def enable_dynamic_port_allocation(self) -> bool:
        """
        Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config. 
        """
        return pulumi.get(self, "enable_dynamic_port_allocation")

    @property
    @pulumi.getter(name="enableEndpointIndependentMapping")
    def enable_endpoint_independent_mapping(self) -> bool:
        return pulumi.get(self, "enable_endpoint_independent_mapping")

    @property
    @pulumi.getter(name="icmpIdleTimeoutSec")
    def icmp_idle_timeout_sec(self) -> int:
        """
        Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "icmp_idle_timeout_sec")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> 'outputs.RouterNatLogConfigResponse':
        """
        Configure logging on this NAT.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter(name="maxPortsPerVm")
    def max_ports_per_vm(self) -> int:
        """
        Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        """
        return pulumi.get(self, "max_ports_per_vm")

    @property
    @pulumi.getter(name="minPortsPerVm")
    def min_ports_per_vm(self) -> int:
        """
        Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
        """
        return pulumi.get(self, "min_ports_per_vm")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natIpAllocateOption")
    def nat_ip_allocate_option(self) -> str:
        """
        Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty. 
        """
        return pulumi.get(self, "nat_ip_allocate_option")

    @property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> Sequence[str]:
        """
        A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
        """
        return pulumi.get(self, "nat_ips")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.RouterNatRuleResponse']:
        """
        A list of rules associated with this NAT.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat")
    def source_subnetwork_ip_ranges_to_nat(self) -> str:
        """
        Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat")

    @property
    @pulumi.getter
    def subnetworks(self) -> Sequence['outputs.RouterNatSubnetworkToNatResponse']:
        """
        A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
        """
        return pulumi.get(self, "subnetworks")

    @property
    @pulumi.getter(name="tcpEstablishedIdleTimeoutSec")
    def tcp_established_idle_timeout_sec(self) -> int:
        """
        Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
        """
        return pulumi.get(self, "tcp_established_idle_timeout_sec")

    @property
    @pulumi.getter(name="tcpTimeWaitTimeoutSec")
    def tcp_time_wait_timeout_sec(self) -> int:
        """
        Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
        """
        return pulumi.get(self, "tcp_time_wait_timeout_sec")

    @property
    @pulumi.getter(name="tcpTransitoryIdleTimeoutSec")
    def tcp_transitory_idle_timeout_sec(self) -> int:
        """
        Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "tcp_transitory_idle_timeout_sec")

    @property
    @pulumi.getter(name="udpIdleTimeoutSec")
    def udp_idle_timeout_sec(self) -> int:
        """
        Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "udp_idle_timeout_sec")


@pulumi.output_type
class RouterNatRuleActionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceNatActiveIps":
            suggest = "source_nat_active_ips"
        elif key == "sourceNatDrainIps":
            suggest = "source_nat_drain_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouterNatRuleActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouterNatRuleActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouterNatRuleActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_nat_active_ips: Sequence[str],
                 source_nat_drain_ips: Sequence[str]):
        """
        :param Sequence[str] source_nat_active_ips: A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
        :param Sequence[str] source_nat_drain_ips: A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
        """
        pulumi.set(__self__, "source_nat_active_ips", source_nat_active_ips)
        pulumi.set(__self__, "source_nat_drain_ips", source_nat_drain_ips)

    @property
    @pulumi.getter(name="sourceNatActiveIps")
    def source_nat_active_ips(self) -> Sequence[str]:
        """
        A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
        """
        return pulumi.get(self, "source_nat_active_ips")

    @property
    @pulumi.getter(name="sourceNatDrainIps")
    def source_nat_drain_ips(self) -> Sequence[str]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
        """
        return pulumi.get(self, "source_nat_drain_ips")


@pulumi.output_type
class RouterNatRuleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleNumber":
            suggest = "rule_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouterNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouterNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouterNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'outputs.RouterNatRuleActionResponse',
                 description: str,
                 match: str,
                 rule_number: int):
        """
        :param 'RouterNatRuleActionResponse' action: The action to be enforced for traffic that matches this rule.
        :param str description: An optional description of this rule.
        :param str match: CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: "inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')" "destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'" The following example is a valid match expression for private NAT: "nexthop.hub == 'https://networkconnectivity.googleapis.com/v1alpha1/projects/my-project/global/hub/hub-1'"
        :param int rule_number: An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "rule_number", rule_number)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.RouterNatRuleActionResponse':
        """
        The action to be enforced for traffic that matches this rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def match(self) -> str:
        """
        CEL expression that specifies the match condition that egress traffic from a VM is evaluated against. If it evaluates to true, the corresponding `action` is enforced. The following examples are valid match expressions for public NAT: "inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')" "destination.ip == '1.1.0.1' || destination.ip == '8.8.8.8'" The following example is a valid match expression for private NAT: "nexthop.hub == 'https://networkconnectivity.googleapis.com/v1alpha1/projects/my-project/global/hub/hub-1'"
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> int:
        """
        An integer uniquely identifying a rule in the list. The rule number must be a positive value between 0 and 65000, and must be unique among rules within a NAT.
        """
        return pulumi.get(self, "rule_number")


@pulumi.output_type
class RouterNatSubnetworkToNatResponse(dict):
    """
    Defines the IP ranges that want to use NAT for a subnetwork.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secondaryIpRangeNames":
            suggest = "secondary_ip_range_names"
        elif key == "sourceIpRangesToNat":
            suggest = "source_ip_ranges_to_nat"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouterNatSubnetworkToNatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouterNatSubnetworkToNatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouterNatSubnetworkToNatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 secondary_ip_range_names: Sequence[str],
                 source_ip_ranges_to_nat: Sequence[str]):
        """
        Defines the IP ranges that want to use NAT for a subnetwork.
        :param str name: URL for the subnetwork resource that will use NAT.
        :param Sequence[str] secondary_ip_range_names: A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
        :param Sequence[str] source_ip_ranges_to_nat: Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secondary_ip_range_names", secondary_ip_range_names)
        pulumi.set(__self__, "source_ip_ranges_to_nat", source_ip_ranges_to_nat)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        URL for the subnetwork resource that will use NAT.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secondaryIpRangeNames")
    def secondary_ip_range_names(self) -> Sequence[str]:
        """
        A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
        """
        return pulumi.get(self, "secondary_ip_range_names")

    @property
    @pulumi.getter(name="sourceIpRangesToNat")
    def source_ip_ranges_to_nat(self) -> Sequence[str]:
        """
        Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
        """
        return pulumi.get(self, "source_ip_ranges_to_nat")


@pulumi.output_type
class RuleResponse(dict):
    """
    This is deprecated and has no effect. Do not use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logConfigs":
            suggest = "log_configs"
        elif key == "notIns":
            suggest = "not_ins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 conditions: Sequence['outputs.ConditionResponse'],
                 description: str,
                 ins: Sequence[str],
                 log_configs: Sequence['outputs.LogConfigResponse'],
                 not_ins: Sequence[str],
                 permissions: Sequence[str]):
        """
        This is deprecated and has no effect. Do not use.
        :param str action: This is deprecated and has no effect. Do not use.
        :param Sequence['ConditionResponse'] conditions: This is deprecated and has no effect. Do not use.
        :param str description: This is deprecated and has no effect. Do not use.
        :param Sequence[str] ins: This is deprecated and has no effect. Do not use.
        :param Sequence['LogConfigResponse'] log_configs: This is deprecated and has no effect. Do not use.
        :param Sequence[str] not_ins: This is deprecated and has no effect. Do not use.
        :param Sequence[str] permissions: This is deprecated and has no effect. Do not use.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ins", ins)
        pulumi.set(__self__, "log_configs", log_configs)
        pulumi.set(__self__, "not_ins", not_ins)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ConditionResponse']:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def ins(self) -> Sequence[str]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "ins")

    @property
    @pulumi.getter(name="logConfigs")
    def log_configs(self) -> Sequence['outputs.LogConfigResponse']:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "log_configs")

    @property
    @pulumi.getter(name="notIns")
    def not_ins(self) -> Sequence[str]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "not_ins")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        This is deprecated and has no effect. Do not use.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class SSLHealthCheckResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"
        elif key == "portSpecification":
            suggest = "port_specification"
        elif key == "proxyHeader":
            suggest = "proxy_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SSLHealthCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SSLHealthCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SSLHealthCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 port_name: str,
                 port_specification: str,
                 proxy_header: str,
                 request: str,
                 response: str):
        """
        :param int port: The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        :param str port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param str port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, SSL health check follows behavior specified in port and portName fields.
        :param str proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param str request: The application data to send once the SSL connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
        :param str response: The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_name", port_name)
        pulumi.set(__self__, "port_specification", port_specification)
        pulumi.set(__self__, "proxy_header", proxy_header)
        pulumi.set(__self__, "request", request)
        pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> str:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> str:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, SSL health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> str:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @property
    @pulumi.getter
    def request(self) -> str:
        """
        The application data to send once the SSL connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def response(self) -> str:
        """
        The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class SavedAttachedDiskResponse(dict):
    """
    DEPRECATED: Please use compute#savedDisk instead. An instance-attached disk resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDelete":
            suggest = "auto_delete"
        elif key == "deviceName":
            suggest = "device_name"
        elif key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "guestOsFeatures":
            suggest = "guest_os_features"
        elif key == "storageBytes":
            suggest = "storage_bytes"
        elif key == "storageBytesStatus":
            suggest = "storage_bytes_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SavedAttachedDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SavedAttachedDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SavedAttachedDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete: bool,
                 boot: bool,
                 device_name: str,
                 disk_encryption_key: 'outputs.CustomerEncryptionKeyResponse',
                 disk_size_gb: str,
                 disk_type: str,
                 guest_os_features: Sequence['outputs.GuestOsFeatureResponse'],
                 index: int,
                 interface: str,
                 kind: str,
                 licenses: Sequence[str],
                 mode: str,
                 source: str,
                 storage_bytes: str,
                 storage_bytes_status: str,
                 type: str):
        """
        DEPRECATED: Please use compute#savedDisk instead. An instance-attached disk resource.
        :param bool auto_delete: Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        :param bool boot: Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        :param str device_name: Specifies the name of the disk attached to the source instance.
        :param 'CustomerEncryptionKeyResponse' disk_encryption_key: The encryption key for the disk.
        :param str disk_size_gb: The size of the disk in base-2 GB.
        :param str disk_type: URL of the disk type resource. For example: projects/project /zones/zone/diskTypes/pd-standard or pd-ssd
        :param Sequence['GuestOsFeatureResponse'] guest_os_features: A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        :param int index: Specifies zero-based index of the disk that is attached to the source instance.
        :param str interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
        :param str kind: Type of the resource. Always compute#attachedDisk for attached disks.
        :param Sequence[str] licenses: Any valid publicly visible licenses.
        :param str mode: The mode in which this disk is attached to the source instance, either READ_WRITE or READ_ONLY.
        :param str source: Specifies a URL of the disk attached to the source instance.
        :param str storage_bytes: A size of the storage used by the disk's snapshot by this machine image.
        :param str storage_bytes_status: An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
        :param str type: Specifies the type of the attached disk, either SCRATCH or PERSISTENT.
        """
        pulumi.set(__self__, "auto_delete", auto_delete)
        pulumi.set(__self__, "boot", boot)
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "guest_os_features", guest_os_features)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "interface", interface)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "storage_bytes", storage_bytes)
        pulumi.set(__self__, "storage_bytes_status", storage_bytes_status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> bool:
        """
        Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        """
        return pulumi.get(self, "auto_delete")

    @property
    @pulumi.getter
    def boot(self) -> bool:
        """
        Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        """
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Specifies the name of the disk attached to the source instance.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> 'outputs.CustomerEncryptionKeyResponse':
        """
        The encryption key for the disk.
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> str:
        """
        The size of the disk in base-2 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        URL of the disk type resource. For example: projects/project /zones/zone/diskTypes/pd-standard or pd-ssd
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Sequence['outputs.GuestOsFeatureResponse']:
        """
        A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        """
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        Specifies zero-based index of the disk that is attached to the source instance.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def interface(self) -> str:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#attachedDisk for attached disks.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def licenses(self) -> Sequence[str]:
        """
        Any valid publicly visible licenses.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The mode in which this disk is attached to the source instance, either READ_WRITE or READ_ONLY.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Specifies a URL of the disk attached to the source instance.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="storageBytes")
    def storage_bytes(self) -> str:
        """
        A size of the storage used by the disk's snapshot by this machine image.
        """
        return pulumi.get(self, "storage_bytes")

    @property
    @pulumi.getter(name="storageBytesStatus")
    def storage_bytes_status(self) -> str:
        """
        An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
        """
        return pulumi.get(self, "storage_bytes_status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the attached disk, either SCRATCH or PERSISTENT.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SavedDiskResponse(dict):
    """
    An instance-attached disk resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceDisk":
            suggest = "source_disk"
        elif key == "storageBytes":
            suggest = "storage_bytes"
        elif key == "storageBytesStatus":
            suggest = "storage_bytes_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SavedDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SavedDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SavedDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 source_disk: str,
                 storage_bytes: str,
                 storage_bytes_status: str):
        """
        An instance-attached disk resource.
        :param str kind: Type of the resource. Always compute#savedDisk for attached disks.
        :param str source_disk: Specifies a URL of the disk attached to the source instance.
        :param str storage_bytes: Size of the individual disk snapshot used by this machine image.
        :param str storage_bytes_status: An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "source_disk", source_disk)
        pulumi.set(__self__, "storage_bytes", storage_bytes)
        pulumi.set(__self__, "storage_bytes_status", storage_bytes_status)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#savedDisk for attached disks.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> str:
        """
        Specifies a URL of the disk attached to the source instance.
        """
        return pulumi.get(self, "source_disk")

    @property
    @pulumi.getter(name="storageBytes")
    def storage_bytes(self) -> str:
        """
        Size of the individual disk snapshot used by this machine image.
        """
        return pulumi.get(self, "storage_bytes")

    @property
    @pulumi.getter(name="storageBytesStatus")
    def storage_bytes_status(self) -> str:
        """
        An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
        """
        return pulumi.get(self, "storage_bytes_status")


@pulumi.output_type
class SchedulingNodeAffinityResponse(dict):
    """
    Node Affinity: the configuration of desired nodes onto which this Instance could be scheduled.
    """
    def __init__(__self__, *,
                 key: str,
                 operator: str,
                 values: Sequence[str]):
        """
        Node Affinity: the configuration of desired nodes onto which this Instance could be scheduled.
        :param str key: Corresponds to the label key of Node resource.
        :param str operator: Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for anti-affinity.
        :param Sequence[str] values: Corresponds to the label values of Node resource.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Corresponds to the label key of Node resource.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for anti-affinity.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Corresponds to the label values of Node resource.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SchedulingResponse(dict):
    """
    Sets the scheduling options for an Instance. NextID: 21
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticRestart":
            suggest = "automatic_restart"
        elif key == "hostErrorTimeoutSeconds":
            suggest = "host_error_timeout_seconds"
        elif key == "instanceTerminationAction":
            suggest = "instance_termination_action"
        elif key == "locationHint":
            suggest = "location_hint"
        elif key == "maintenanceFreezeDurationHours":
            suggest = "maintenance_freeze_duration_hours"
        elif key == "maintenanceInterval":
            suggest = "maintenance_interval"
        elif key == "minNodeCpus":
            suggest = "min_node_cpus"
        elif key == "nodeAffinities":
            suggest = "node_affinities"
        elif key == "onHostMaintenance":
            suggest = "on_host_maintenance"
        elif key == "provisioningModel":
            suggest = "provisioning_model"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_restart: bool,
                 host_error_timeout_seconds: int,
                 instance_termination_action: str,
                 location_hint: str,
                 maintenance_freeze_duration_hours: int,
                 maintenance_interval: str,
                 min_node_cpus: int,
                 node_affinities: Sequence['outputs.SchedulingNodeAffinityResponse'],
                 on_host_maintenance: str,
                 preemptible: bool,
                 provisioning_model: str):
        """
        Sets the scheduling options for an Instance. NextID: 21
        :param bool automatic_restart: Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
        :param int host_error_timeout_seconds: Specify the time in seconds for host error detection, the value must be within the range of [90, 330] with the increment of 30, if unset, the default behavior of host error recovery will be used.
        :param str instance_termination_action: Specifies the termination action for the instance.
        :param str location_hint: An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
        :param int maintenance_freeze_duration_hours: Specifies the number of hours after VM instance creation where the VM won't be scheduled for maintenance.
        :param str maintenance_interval: For more information about maintenance intervals, see Setting maintenance intervals.
        :param int min_node_cpus: The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
        :param Sequence['SchedulingNodeAffinityResponse'] node_affinities: A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
        :param str on_host_maintenance: Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM availability policies.
        :param bool preemptible: Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
        :param str provisioning_model: Specifies the provisioning model of the instance.
        """
        pulumi.set(__self__, "automatic_restart", automatic_restart)
        pulumi.set(__self__, "host_error_timeout_seconds", host_error_timeout_seconds)
        pulumi.set(__self__, "instance_termination_action", instance_termination_action)
        pulumi.set(__self__, "location_hint", location_hint)
        pulumi.set(__self__, "maintenance_freeze_duration_hours", maintenance_freeze_duration_hours)
        pulumi.set(__self__, "maintenance_interval", maintenance_interval)
        pulumi.set(__self__, "min_node_cpus", min_node_cpus)
        pulumi.set(__self__, "node_affinities", node_affinities)
        pulumi.set(__self__, "on_host_maintenance", on_host_maintenance)
        pulumi.set(__self__, "preemptible", preemptible)
        pulumi.set(__self__, "provisioning_model", provisioning_model)

    @property
    @pulumi.getter(name="automaticRestart")
    def automatic_restart(self) -> bool:
        """
        Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
        """
        return pulumi.get(self, "automatic_restart")

    @property
    @pulumi.getter(name="hostErrorTimeoutSeconds")
    def host_error_timeout_seconds(self) -> int:
        """
        Specify the time in seconds for host error detection, the value must be within the range of [90, 330] with the increment of 30, if unset, the default behavior of host error recovery will be used.
        """
        return pulumi.get(self, "host_error_timeout_seconds")

    @property
    @pulumi.getter(name="instanceTerminationAction")
    def instance_termination_action(self) -> str:
        """
        Specifies the termination action for the instance.
        """
        return pulumi.get(self, "instance_termination_action")

    @property
    @pulumi.getter(name="locationHint")
    def location_hint(self) -> str:
        """
        An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
        """
        return pulumi.get(self, "location_hint")

    @property
    @pulumi.getter(name="maintenanceFreezeDurationHours")
    def maintenance_freeze_duration_hours(self) -> int:
        """
        Specifies the number of hours after VM instance creation where the VM won't be scheduled for maintenance.
        """
        return pulumi.get(self, "maintenance_freeze_duration_hours")

    @property
    @pulumi.getter(name="maintenanceInterval")
    def maintenance_interval(self) -> str:
        """
        For more information about maintenance intervals, see Setting maintenance intervals.
        """
        return pulumi.get(self, "maintenance_interval")

    @property
    @pulumi.getter(name="minNodeCpus")
    def min_node_cpus(self) -> int:
        """
        The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
        """
        return pulumi.get(self, "min_node_cpus")

    @property
    @pulumi.getter(name="nodeAffinities")
    def node_affinities(self) -> Sequence['outputs.SchedulingNodeAffinityResponse']:
        """
        A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
        """
        return pulumi.get(self, "node_affinities")

    @property
    @pulumi.getter(name="onHostMaintenance")
    def on_host_maintenance(self) -> str:
        """
        Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM availability policies.
        """
        return pulumi.get(self, "on_host_maintenance")

    @property
    @pulumi.getter
    def preemptible(self) -> bool:
        """
        Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
        """
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> str:
        """
        Specifies the provisioning model of the instance.
        """
        return pulumi.get(self, "provisioning_model")


@pulumi.output_type
class SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigResponse(dict):
    """
    Configuration options for L7 DDoS detection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleVisibility":
            suggest = "rule_visibility"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: bool,
                 rule_visibility: str):
        """
        Configuration options for L7 DDoS detection.
        :param bool enable: If set to true, enables CAAP for L7 DDoS detection.
        :param str rule_visibility: Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "rule_visibility", rule_visibility)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        If set to true, enables CAAP for L7 DDoS detection.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="ruleVisibility")
    def rule_visibility(self) -> str:
        """
        Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules.
        """
        return pulumi.get(self, "rule_visibility")


@pulumi.output_type
class SecurityPolicyAdaptiveProtectionConfigResponse(dict):
    """
    Configuration options for Cloud Armor Adaptive Protection (CAAP).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "layer7DdosDefenseConfig":
            suggest = "layer7_ddos_defense_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyAdaptiveProtectionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyAdaptiveProtectionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyAdaptiveProtectionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 layer7_ddos_defense_config: 'outputs.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigResponse'):
        """
        Configuration options for Cloud Armor Adaptive Protection (CAAP).
        :param 'SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigResponse' layer7_ddos_defense_config: If set to true, enables Cloud Armor Machine Learning.
        """
        pulumi.set(__self__, "layer7_ddos_defense_config", layer7_ddos_defense_config)

    @property
    @pulumi.getter(name="layer7DdosDefenseConfig")
    def layer7_ddos_defense_config(self) -> 'outputs.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigResponse':
        """
        If set to true, enables Cloud Armor Machine Learning.
        """
        return pulumi.get(self, "layer7_ddos_defense_config")


@pulumi.output_type
class SecurityPolicyAdvancedOptionsConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonParsing":
            suggest = "json_parsing"
        elif key == "logLevel":
            suggest = "log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyAdvancedOptionsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyAdvancedOptionsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyAdvancedOptionsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_parsing: str,
                 log_level: str):
        pulumi.set(__self__, "json_parsing", json_parsing)
        pulumi.set(__self__, "log_level", log_level)

    @property
    @pulumi.getter(name="jsonParsing")
    def json_parsing(self) -> str:
        return pulumi.get(self, "json_parsing")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> str:
        return pulumi.get(self, "log_level")


@pulumi.output_type
class SecurityPolicyAssociationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attachmentId":
            suggest = "attachment_id"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "securityPolicyId":
            suggest = "security_policy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyAssociationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyAssociationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyAssociationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attachment_id: str,
                 display_name: str,
                 name: str,
                 security_policy_id: str):
        """
        :param str attachment_id: The resource that the security policy is attached to.
        :param str display_name: The display name of the security policy of the association.
        :param str name: The name for an association.
        :param str security_policy_id: The security policy ID of the association.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "security_policy_id", security_policy_id)

    @property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> str:
        """
        The resource that the security policy is attached to.
        """
        return pulumi.get(self, "attachment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the security policy of the association.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name for an association.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> str:
        """
        The security policy ID of the association.
        """
        return pulumi.get(self, "security_policy_id")


@pulumi.output_type
class SecurityPolicyRecaptchaOptionsConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectSiteKey":
            suggest = "redirect_site_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyRecaptchaOptionsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyRecaptchaOptionsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyRecaptchaOptionsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redirect_site_key: str):
        """
        :param str redirect_site_key: An optional field to supply a reCAPTCHA site key to be used for all the rules using the redirect action with the type of GOOGLE_RECAPTCHA under the security policy. The specified site key needs to be created from the reCAPTCHA API. The user is responsible for the validity of the specified site key. If not specified, a Google-managed site key is used.
        """
        pulumi.set(__self__, "redirect_site_key", redirect_site_key)

    @property
    @pulumi.getter(name="redirectSiteKey")
    def redirect_site_key(self) -> str:
        """
        An optional field to supply a reCAPTCHA site key to be used for all the rules using the redirect action with the type of GOOGLE_RECAPTCHA under the security policy. The specified site key needs to be created from the reCAPTCHA API. The user is responsible for the validity of the specified site key. If not specified, a Google-managed site key is used.
        """
        return pulumi.get(self, "redirect_site_key")


@pulumi.output_type
class SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str,
                 header_value: str):
        """
        :param str header_name: The name of the header to set.
        :param str header_value: The value to set the named header to.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        The name of the header to set.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> str:
        """
        The value to set the named header to.
        """
        return pulumi.get(self, "header_value")


@pulumi.output_type
class SecurityPolicyRuleHttpHeaderActionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestHeadersToAdds":
            suggest = "request_headers_to_adds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyRuleHttpHeaderActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyRuleHttpHeaderActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyRuleHttpHeaderActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_headers_to_adds: Sequence['outputs.SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionResponse']):
        """
        :param Sequence['SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionResponse'] request_headers_to_adds: The list of request headers to add or overwrite if they're already present.
        """
        pulumi.set(__self__, "request_headers_to_adds", request_headers_to_adds)

    @property
    @pulumi.getter(name="requestHeadersToAdds")
    def request_headers_to_adds(self) -> Sequence['outputs.SecurityPolicyRuleHttpHeaderActionHttpHeaderOptionResponse']:
        """
        The list of request headers to add or overwrite if they're already present.
        """
        return pulumi.get(self, "request_headers_to_adds")


@pulumi.output_type
class SecurityPolicyRuleMatcherConfigLayer4ConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipProtocol":
            suggest = "ip_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyRuleMatcherConfigLayer4ConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyRuleMatcherConfigLayer4ConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyRuleMatcherConfigLayer4ConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_protocol: str,
                 ports: Sequence[str]):
        """
        :param str ip_protocol: The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
        :param Sequence[str] ports: An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"]. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> str:
        """
        The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[str]:
        """
        An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"]. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class SecurityPolicyRuleMatcherConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destIpRanges":
            suggest = "dest_ip_ranges"
        elif key == "layer4Configs":
            suggest = "layer4_configs"
        elif key == "srcIpRanges":
            suggest = "src_ip_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyRuleMatcherConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyRuleMatcherConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyRuleMatcherConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dest_ip_ranges: Sequence[str],
                 layer4_configs: Sequence['outputs.SecurityPolicyRuleMatcherConfigLayer4ConfigResponse'],
                 src_ip_ranges: Sequence[str]):
        """
        :param Sequence[str] dest_ip_ranges: CIDR IP address range. This field may only be specified when versioned_expr is set to FIREWALL.
        :param Sequence['SecurityPolicyRuleMatcherConfigLayer4ConfigResponse'] layer4_configs: Pairs of IP protocols and ports that the rule should match. This field may only be specified when versioned_expr is set to FIREWALL.
        :param Sequence[str] src_ip_ranges: CIDR IP address range. Maximum number of src_ip_ranges allowed is 10.
        """
        pulumi.set(__self__, "dest_ip_ranges", dest_ip_ranges)
        pulumi.set(__self__, "layer4_configs", layer4_configs)
        pulumi.set(__self__, "src_ip_ranges", src_ip_ranges)

    @property
    @pulumi.getter(name="destIpRanges")
    def dest_ip_ranges(self) -> Sequence[str]:
        """
        CIDR IP address range. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "dest_ip_ranges")

    @property
    @pulumi.getter(name="layer4Configs")
    def layer4_configs(self) -> Sequence['outputs.SecurityPolicyRuleMatcherConfigLayer4ConfigResponse']:
        """
        Pairs of IP protocols and ports that the rule should match. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "layer4_configs")

    @property
    @pulumi.getter(name="srcIpRanges")
    def src_ip_ranges(self) -> Sequence[str]:
        """
        CIDR IP address range. Maximum number of src_ip_ranges allowed is 10.
        """
        return pulumi.get(self, "src_ip_ranges")


@pulumi.output_type
class SecurityPolicyRuleMatcherResponse(dict):
    """
    Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionedExpr":
            suggest = "versioned_expr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyRuleMatcherResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyRuleMatcherResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyRuleMatcherResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: 'outputs.SecurityPolicyRuleMatcherConfigResponse',
                 expr: 'outputs.ExprResponse',
                 versioned_expr: str):
        """
        Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
        :param 'SecurityPolicyRuleMatcherConfigResponse' config: The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
        :param 'ExprResponse' expr: User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header.
        :param str versioned_expr: Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "expr", expr)
        pulumi.set(__self__, "versioned_expr", versioned_expr)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.SecurityPolicyRuleMatcherConfigResponse':
        """
        The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def expr(self) -> 'outputs.ExprResponse':
        """
        User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header.
        """
        return pulumi.get(self, "expr")

    @property
    @pulumi.getter(name="versionedExpr")
    def versioned_expr(self) -> str:
        """
        Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
        """
        return pulumi.get(self, "versioned_expr")


@pulumi.output_type
class SecurityPolicyRuleRateLimitOptionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "banDurationSec":
            suggest = "ban_duration_sec"
        elif key == "banThreshold":
            suggest = "ban_threshold"
        elif key == "conformAction":
            suggest = "conform_action"
        elif key == "enforceOnKey":
            suggest = "enforce_on_key"
        elif key == "enforceOnKeyName":
            suggest = "enforce_on_key_name"
        elif key == "exceedAction":
            suggest = "exceed_action"
        elif key == "exceedRedirectOptions":
            suggest = "exceed_redirect_options"
        elif key == "rateLimitThreshold":
            suggest = "rate_limit_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyRuleRateLimitOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyRuleRateLimitOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyRuleRateLimitOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ban_duration_sec: int,
                 ban_threshold: 'outputs.SecurityPolicyRuleRateLimitOptionsThresholdResponse',
                 conform_action: str,
                 enforce_on_key: str,
                 enforce_on_key_name: str,
                 exceed_action: str,
                 exceed_redirect_options: 'outputs.SecurityPolicyRuleRedirectOptionsResponse',
                 rate_limit_threshold: 'outputs.SecurityPolicyRuleRateLimitOptionsThresholdResponse'):
        """
        :param int ban_duration_sec: Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
        :param 'SecurityPolicyRuleRateLimitOptionsThresholdResponse' ban_threshold: Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
        :param str conform_action: Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
        :param str enforce_on_key: Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if this field 'enforce_on_key' is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key type defaults to ALL. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. 
        :param str enforce_on_key_name: Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
        :param str exceed_action: Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the redirect parameters come from exceed_redirect_options below.
        :param 'SecurityPolicyRuleRedirectOptionsResponse' exceed_redirect_options: Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect.
        :param 'SecurityPolicyRuleRateLimitOptionsThresholdResponse' rate_limit_threshold: Threshold at which to begin ratelimiting.
        """
        pulumi.set(__self__, "ban_duration_sec", ban_duration_sec)
        pulumi.set(__self__, "ban_threshold", ban_threshold)
        pulumi.set(__self__, "conform_action", conform_action)
        pulumi.set(__self__, "enforce_on_key", enforce_on_key)
        pulumi.set(__self__, "enforce_on_key_name", enforce_on_key_name)
        pulumi.set(__self__, "exceed_action", exceed_action)
        pulumi.set(__self__, "exceed_redirect_options", exceed_redirect_options)
        pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)

    @property
    @pulumi.getter(name="banDurationSec")
    def ban_duration_sec(self) -> int:
        """
        Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
        """
        return pulumi.get(self, "ban_duration_sec")

    @property
    @pulumi.getter(name="banThreshold")
    def ban_threshold(self) -> 'outputs.SecurityPolicyRuleRateLimitOptionsThresholdResponse':
        """
        Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
        """
        return pulumi.get(self, "ban_threshold")

    @property
    @pulumi.getter(name="conformAction")
    def conform_action(self) -> str:
        """
        Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
        """
        return pulumi.get(self, "conform_action")

    @property
    @pulumi.getter(name="enforceOnKey")
    def enforce_on_key(self) -> str:
        """
        Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if this field 'enforce_on_key' is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key type defaults to ALL. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforce_on_key_name". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. 
        """
        return pulumi.get(self, "enforce_on_key")

    @property
    @pulumi.getter(name="enforceOnKeyName")
    def enforce_on_key_name(self) -> str:
        """
        Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
        """
        return pulumi.get(self, "enforce_on_key_name")

    @property
    @pulumi.getter(name="exceedAction")
    def exceed_action(self) -> str:
        """
        Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the redirect parameters come from exceed_redirect_options below.
        """
        return pulumi.get(self, "exceed_action")

    @property
    @pulumi.getter(name="exceedRedirectOptions")
    def exceed_redirect_options(self) -> 'outputs.SecurityPolicyRuleRedirectOptionsResponse':
        """
        Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect.
        """
        return pulumi.get(self, "exceed_redirect_options")

    @property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> 'outputs.SecurityPolicyRuleRateLimitOptionsThresholdResponse':
        """
        Threshold at which to begin ratelimiting.
        """
        return pulumi.get(self, "rate_limit_threshold")


@pulumi.output_type
class SecurityPolicyRuleRateLimitOptionsThresholdResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalSec":
            suggest = "interval_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyRuleRateLimitOptionsThresholdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyRuleRateLimitOptionsThresholdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyRuleRateLimitOptionsThresholdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: int,
                 interval_sec: int):
        """
        :param int count: Number of HTTP(S) requests for calculating the threshold.
        :param int interval_sec: Interval over which the threshold is computed.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "interval_sec", interval_sec)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        Number of HTTP(S) requests for calculating the threshold.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="intervalSec")
    def interval_sec(self) -> int:
        """
        Interval over which the threshold is computed.
        """
        return pulumi.get(self, "interval_sec")


@pulumi.output_type
class SecurityPolicyRuleRedirectOptionsResponse(dict):
    def __init__(__self__, *,
                 target: str,
                 type: str):
        """
        :param str target: Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
        :param str type: Type of the redirect action.
        """
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the redirect action.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SecurityPolicyRuleResponse(dict):
    """
    Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableLogging":
            suggest = "enable_logging"
        elif key == "headerAction":
            suggest = "header_action"
        elif key == "rateLimitOptions":
            suggest = "rate_limit_options"
        elif key == "redirectOptions":
            suggest = "redirect_options"
        elif key == "ruleNumber":
            suggest = "rule_number"
        elif key == "ruleTupleCount":
            suggest = "rule_tuple_count"
        elif key == "targetResources":
            suggest = "target_resources"
        elif key == "targetServiceAccounts":
            suggest = "target_service_accounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityPolicyRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityPolicyRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityPolicyRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 description: str,
                 direction: str,
                 enable_logging: bool,
                 header_action: 'outputs.SecurityPolicyRuleHttpHeaderActionResponse',
                 kind: str,
                 match: 'outputs.SecurityPolicyRuleMatcherResponse',
                 preview: bool,
                 priority: int,
                 rate_limit_options: 'outputs.SecurityPolicyRuleRateLimitOptionsResponse',
                 redirect_options: 'outputs.SecurityPolicyRuleRedirectOptionsResponse',
                 rule_number: str,
                 rule_tuple_count: int,
                 target_resources: Sequence[str],
                 target_service_accounts: Sequence[str]):
        """
        Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
        :param str action: The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(): deny access to target, returns the HTTP response code specified (valid values are 403, 404, and 502). - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. 
        :param str description: An optional description of this resource. Provide this property when you create the resource.
        :param str direction: The direction in which this rule applies. This field may only be specified when versioned_expr is set to FIREWALL.
        :param bool enable_logging: Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules. This field may only be specified when the versioned_expr is set to FIREWALL.
        :param 'SecurityPolicyRuleHttpHeaderActionResponse' header_action: Optional, additional actions that are performed on headers.
        :param str kind: [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
        :param 'SecurityPolicyRuleMatcherResponse' match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        :param bool preview: If set to true, the specified action is not enforced.
        :param int priority: An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param 'SecurityPolicyRuleRateLimitOptionsResponse' rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        :param 'SecurityPolicyRuleRedirectOptionsResponse' redirect_options: Parameters defining the redirect action. Cannot be specified for any other actions.
        :param str rule_number: Identifier for the rule. This is only unique within the given security policy. This can only be set during rule creation, if rule number is not specified it will be generated by the server.
        :param int rule_tuple_count: Calculation of the complexity of a single firewall security policy rule.
        :param Sequence[str] target_resources: A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule. This field may only be specified when versioned_expr is set to FIREWALL.
        :param Sequence[str] target_service_accounts: A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "enable_logging", enable_logging)
        pulumi.set(__self__, "header_action", header_action)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "preview", preview)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rate_limit_options", rate_limit_options)
        pulumi.set(__self__, "redirect_options", redirect_options)
        pulumi.set(__self__, "rule_number", rule_number)
        pulumi.set(__self__, "rule_tuple_count", rule_tuple_count)
        pulumi.set(__self__, "target_resources", target_resources)
        pulumi.set(__self__, "target_service_accounts", target_service_accounts)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(): deny access to target, returns the HTTP response code specified (valid values are 403, 404, and 502). - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. 
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction in which this rule applies. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> bool:
        """
        Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules. This field may only be specified when the versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> 'outputs.SecurityPolicyRuleHttpHeaderActionResponse':
        """
        Optional, additional actions that are performed on headers.
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def match(self) -> 'outputs.SecurityPolicyRuleMatcherResponse':
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def preview(self) -> bool:
        """
        If set to true, the specified action is not enforced.
        """
        return pulumi.get(self, "preview")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="rateLimitOptions")
    def rate_limit_options(self) -> 'outputs.SecurityPolicyRuleRateLimitOptionsResponse':
        """
        Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        """
        return pulumi.get(self, "rate_limit_options")

    @property
    @pulumi.getter(name="redirectOptions")
    def redirect_options(self) -> 'outputs.SecurityPolicyRuleRedirectOptionsResponse':
        """
        Parameters defining the redirect action. Cannot be specified for any other actions.
        """
        return pulumi.get(self, "redirect_options")

    @property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> str:
        """
        Identifier for the rule. This is only unique within the given security policy. This can only be set during rule creation, if rule number is not specified it will be generated by the server.
        """
        return pulumi.get(self, "rule_number")

    @property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> int:
        """
        Calculation of the complexity of a single firewall security policy rule.
        """
        return pulumi.get(self, "rule_tuple_count")

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Sequence[str]:
        """
        A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule. This field may only be specified when versioned_expr is set to FIREWALL.
        """
        return pulumi.get(self, "target_resources")

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Sequence[str]:
        """
        A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        return pulumi.get(self, "target_service_accounts")


@pulumi.output_type
class SecuritySettingsResponse(dict):
    """
    The authentication and authorization settings for a BackendService.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientTlsPolicy":
            suggest = "client_tls_policy"
        elif key == "subjectAltNames":
            suggest = "subject_alt_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecuritySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecuritySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecuritySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_tls_policy: str,
                 subject_alt_names: Sequence[str]):
        """
        The authentication and authorization settings for a BackendService.
        :param str client_tls_policy: Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how clients should authenticate with this service's backends. clientTlsPolicy only applies to a global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If left blank, communications are not encrypted. Note: This field currently has no impact.
        :param Sequence[str] subject_alt_names: Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual TLS handshake with an server/endpoint for this BackendService. When the server presents its X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If the field contains one of the specified values, the communication continues. Otherwise, it fails. This additional check enables the client to verify that the server is authorized to run the requested service. Note that the contents of the server certificate's subjectAltName field are configured by the Public Key Infrastructure which provisions server identities. Only applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode). Note: This field currently has no impact.
        """
        pulumi.set(__self__, "client_tls_policy", client_tls_policy)
        pulumi.set(__self__, "subject_alt_names", subject_alt_names)

    @property
    @pulumi.getter(name="clientTlsPolicy")
    def client_tls_policy(self) -> str:
        """
        Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how clients should authenticate with this service's backends. clientTlsPolicy only applies to a global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If left blank, communications are not encrypted. Note: This field currently has no impact.
        """
        return pulumi.get(self, "client_tls_policy")

    @property
    @pulumi.getter(name="subjectAltNames")
    def subject_alt_names(self) -> Sequence[str]:
        """
        Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual TLS handshake with an server/endpoint for this BackendService. When the server presents its X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If the field contains one of the specified values, the communication continues. Otherwise, it fails. This additional check enables the client to verify that the server is authorized to run the requested service. Note that the contents of the server certificate's subjectAltName field are configured by the Public Key Infrastructure which provisions server identities. Only applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode). Note: This field currently has no impact.
        """
        return pulumi.get(self, "subject_alt_names")


@pulumi.output_type
class ServerBindingResponse(dict):
    def __init__(__self__, *,
                 type: str):
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceAccountResponse(dict):
    """
    A service account.
    """
    def __init__(__self__, *,
                 email: str,
                 scopes: Sequence[str]):
        """
        A service account.
        :param str email: Email address of the service account.
        :param Sequence[str] scopes: The list of scopes to be made available for this service account.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Email address of the service account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        """
        The list of scopes to be made available for this service account.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class ServiceAttachmentConnectedEndpointResponse(dict):
    """
    [Output Only] A connection connected to this service attachment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pscConnectionId":
            suggest = "psc_connection_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAttachmentConnectedEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAttachmentConnectedEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAttachmentConnectedEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: str,
                 psc_connection_id: str,
                 status: str):
        """
        [Output Only] A connection connected to this service attachment.
        :param str endpoint: The url of a connected endpoint.
        :param str psc_connection_id: The PSC connection id of the connected endpoint.
        :param str status: The status of a connected endpoint to this service attachment.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The url of a connected endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> str:
        """
        The PSC connection id of the connected endpoint.
        """
        return pulumi.get(self, "psc_connection_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of a connected endpoint to this service attachment.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceAttachmentConsumerProjectLimitResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionLimit":
            suggest = "connection_limit"
        elif key == "projectIdOrNum":
            suggest = "project_id_or_num"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAttachmentConsumerProjectLimitResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAttachmentConsumerProjectLimitResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAttachmentConsumerProjectLimitResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_limit: int,
                 project_id_or_num: str):
        """
        :param int connection_limit: The value of the limit to set.
        :param str project_id_or_num: The project id or number for the project to set the limit for.
        """
        pulumi.set(__self__, "connection_limit", connection_limit)
        pulumi.set(__self__, "project_id_or_num", project_id_or_num)

    @property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> int:
        """
        The value of the limit to set.
        """
        return pulumi.get(self, "connection_limit")

    @property
    @pulumi.getter(name="projectIdOrNum")
    def project_id_or_num(self) -> str:
        """
        The project id or number for the project to set the limit for.
        """
        return pulumi.get(self, "project_id_or_num")


@pulumi.output_type
class ShareSettingsResponse(dict):
    """
    The share setting for reservations and sole tenancy node groups.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectMap":
            suggest = "project_map"
        elif key == "shareType":
            suggest = "share_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShareSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShareSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShareSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_map: Mapping[str, str],
                 projects: Sequence[str],
                 share_type: str):
        """
        The share setting for reservations and sole tenancy node groups.
        :param Mapping[str, str] project_map: A map of project id and project config. This is only valid when share_type's value is SPECIFIC_PROJECTS.
        :param Sequence[str] projects: A List of Project names to specify consumer projects for this shared-reservation. This is only valid when share_type's value is SPECIFIC_PROJECTS.
        :param str share_type: Type of sharing for this shared-reservation
        """
        pulumi.set(__self__, "project_map", project_map)
        pulumi.set(__self__, "projects", projects)
        pulumi.set(__self__, "share_type", share_type)

    @property
    @pulumi.getter(name="projectMap")
    def project_map(self) -> Mapping[str, str]:
        """
        A map of project id and project config. This is only valid when share_type's value is SPECIFIC_PROJECTS.
        """
        return pulumi.get(self, "project_map")

    @property
    @pulumi.getter
    def projects(self) -> Sequence[str]:
        """
        A List of Project names to specify consumer projects for this shared-reservation. This is only valid when share_type's value is SPECIFIC_PROJECTS.
        """
        return pulumi.get(self, "projects")

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> str:
        """
        Type of sharing for this shared-reservation
        """
        return pulumi.get(self, "share_type")


@pulumi.output_type
class ShieldedInstanceConfigResponse(dict):
    """
    A set of Shielded Instance options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShieldedInstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShieldedInstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShieldedInstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool,
                 enable_vtpm: bool):
        """
        A set of Shielded Instance options.
        :param bool enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled. Enabled by default.
        :param bool enable_secure_boot: Defines whether the instance has Secure Boot enabled. Disabled by default.
        :param bool enable_vtpm: Defines whether the instance has the vTPM enabled. Enabled by default.
        """
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        """
        Defines whether the instance has integrity monitoring enabled. Enabled by default.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled. Disabled by default.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> bool:
        """
        Defines whether the instance has the vTPM enabled. Enabled by default.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class ShieldedInstanceIntegrityPolicyResponse(dict):
    """
    The policy describes the baseline against which Instance boot integrity is measured.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateAutoLearnPolicy":
            suggest = "update_auto_learn_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShieldedInstanceIntegrityPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShieldedInstanceIntegrityPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShieldedInstanceIntegrityPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 update_auto_learn_policy: bool):
        """
        The policy describes the baseline against which Instance boot integrity is measured.
        :param bool update_auto_learn_policy: Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
        """
        pulumi.set(__self__, "update_auto_learn_policy", update_auto_learn_policy)

    @property
    @pulumi.getter(name="updateAutoLearnPolicy")
    def update_auto_learn_policy(self) -> bool:
        """
        Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
        """
        return pulumi.get(self, "update_auto_learn_policy")


@pulumi.output_type
class ShieldedVmConfigResponse(dict):
    """
    A set of Shielded VM options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShieldedVmConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShieldedVmConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShieldedVmConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool,
                 enable_vtpm: bool):
        """
        A set of Shielded VM options.
        :param bool enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled.
        :param bool enable_secure_boot: Defines whether the instance has Secure Boot enabled.
        :param bool enable_vtpm: Defines whether the instance has the vTPM enabled.
        """
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        """
        Defines whether the instance has integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> bool:
        """
        Defines whether the instance has the vTPM enabled.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class ShieldedVmIntegrityPolicyResponse(dict):
    """
    The policy describes the baseline against which VM instance boot integrity is measured.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateAutoLearnPolicy":
            suggest = "update_auto_learn_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShieldedVmIntegrityPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShieldedVmIntegrityPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShieldedVmIntegrityPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 update_auto_learn_policy: bool):
        """
        The policy describes the baseline against which VM instance boot integrity is measured.
        :param bool update_auto_learn_policy: Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
        """
        pulumi.set(__self__, "update_auto_learn_policy", update_auto_learn_policy)

    @property
    @pulumi.getter(name="updateAutoLearnPolicy")
    def update_auto_learn_policy(self) -> bool:
        """
        Updates the integrity policy baseline using the measurements from the VM instance's most recent boot.
        """
        return pulumi.get(self, "update_auto_learn_policy")


@pulumi.output_type
class SourceDiskEncryptionKeyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "sourceDisk":
            suggest = "source_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceDiskEncryptionKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceDiskEncryptionKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceDiskEncryptionKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_key: 'outputs.CustomerEncryptionKeyResponse',
                 source_disk: str):
        """
        :param 'CustomerEncryptionKeyResponse' disk_encryption_key: The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
        :param str source_disk: URL of the disk attached to the source instance. This can be a full or valid partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk 
        """
        pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        pulumi.set(__self__, "source_disk", source_disk)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> 'outputs.CustomerEncryptionKeyResponse':
        """
        The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> str:
        """
        URL of the disk attached to the source instance. This can be a full or valid partial URL. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk 
        """
        return pulumi.get(self, "source_disk")


@pulumi.output_type
class SourceInstanceParamsResponse(dict):
    """
    A specification of the parameters to use when creating the instance template from a source instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfigs":
            suggest = "disk_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceInstanceParamsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceInstanceParamsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceInstanceParamsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_configs: Sequence['outputs.DiskInstantiationConfigResponse']):
        """
        A specification of the parameters to use when creating the instance template from a source instance.
        :param Sequence['DiskInstantiationConfigResponse'] disk_configs: Attached disks configuration. If not provided, defaults are applied: For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
        """
        pulumi.set(__self__, "disk_configs", disk_configs)

    @property
    @pulumi.getter(name="diskConfigs")
    def disk_configs(self) -> Sequence['outputs.DiskInstantiationConfigResponse']:
        """
        Attached disks configuration. If not provided, defaults are applied: For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
        """
        return pulumi.get(self, "disk_configs")


@pulumi.output_type
class SourceInstancePropertiesResponse(dict):
    """
    DEPRECATED: Please use compute#instanceProperties instead. New properties will not be added to this field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canIpForward":
            suggest = "can_ip_forward"
        elif key == "deletionProtection":
            suggest = "deletion_protection"
        elif key == "guestAccelerators":
            suggest = "guest_accelerators"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "postKeyRevocationActionType":
            suggest = "post_key_revocation_action_type"
        elif key == "serviceAccounts":
            suggest = "service_accounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_ip_forward: bool,
                 deletion_protection: bool,
                 description: str,
                 disks: Sequence['outputs.SavedAttachedDiskResponse'],
                 guest_accelerators: Sequence['outputs.AcceleratorConfigResponse'],
                 labels: Mapping[str, str],
                 machine_type: str,
                 metadata: 'outputs.MetadataResponse',
                 min_cpu_platform: str,
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 post_key_revocation_action_type: str,
                 scheduling: 'outputs.SchedulingResponse',
                 service_accounts: Sequence['outputs.ServiceAccountResponse'],
                 tags: 'outputs.TagsResponse'):
        """
        DEPRECATED: Please use compute#instanceProperties instead. New properties will not be added to this field.
        :param bool can_ip_forward: Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
        :param bool deletion_protection: Whether the instance created from this machine image should be protected against deletion.
        :param str description: An optional text description for the instances that are created from this machine image.
        :param Sequence['SavedAttachedDiskResponse'] disks: An array of disks that are associated with the instances that are created from this machine image.
        :param Sequence['AcceleratorConfigResponse'] guest_accelerators: A list of guest accelerator cards' type and count to use for instances created from this machine image.
        :param Mapping[str, str] labels: Labels to apply to instances that are created from this machine image.
        :param str machine_type: The machine type to use for instances that are created from this machine image.
        :param 'MetadataResponse' metadata: The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
        :param str min_cpu_platform: Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: An array of network access configurations for this interface.
        :param str post_key_revocation_action_type: PostKeyRevocationActionType of the instance.
        :param 'SchedulingResponse' scheduling: Specifies the scheduling options for the instances that are created from this machine image.
        :param Sequence['ServiceAccountResponse'] service_accounts: A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
        :param 'TagsResponse' tags: A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
        """
        pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "post_key_revocation_action_type", post_key_revocation_action_type)
        pulumi.set(__self__, "scheduling", scheduling)
        pulumi.set(__self__, "service_accounts", service_accounts)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> bool:
        """
        Enables instances created based on this machine image to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
        """
        return pulumi.get(self, "can_ip_forward")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        Whether the instance created from this machine image should be protected against deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional text description for the instances that are created from this machine image.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.SavedAttachedDiskResponse']:
        """
        An array of disks that are associated with the instances that are created from this machine image.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Sequence['outputs.AcceleratorConfigResponse']:
        """
        A list of guest accelerator cards' type and count to use for instances created from this machine image.
        """
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels to apply to instances that are created from this machine image.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The machine type to use for instances that are created from this machine image.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.MetadataResponse':
        """
        The metadata key/value pairs to assign to instances that are created from this machine image. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        Minimum cpu/platform to be used by instances created from this machine image. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        An array of network access configurations for this interface.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="postKeyRevocationActionType")
    def post_key_revocation_action_type(self) -> str:
        """
        PostKeyRevocationActionType of the instance.
        """
        return pulumi.get(self, "post_key_revocation_action_type")

    @property
    @pulumi.getter
    def scheduling(self) -> 'outputs.SchedulingResponse':
        """
        Specifies the scheduling options for the instances that are created from this machine image.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Sequence['outputs.ServiceAccountResponse']:
        """
        A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from this machine image. Use metadata queries to obtain the access tokens for these instances.
        """
        return pulumi.get(self, "service_accounts")

    @property
    @pulumi.getter
    def tags(self) -> 'outputs.TagsResponse':
        """
        A list of tags to apply to the instances that are created from this machine image. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class SslCertificateManagedSslCertificateResponse(dict):
    """
    Configuration and status of a managed SSL certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainStatus":
            suggest = "domain_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SslCertificateManagedSslCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SslCertificateManagedSslCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SslCertificateManagedSslCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_status: Mapping[str, str],
                 domains: Sequence[str],
                 status: str):
        """
        Configuration and status of a managed SSL certificate.
        :param Mapping[str, str] domain_status: [Output only] Detailed statuses of the domains specified for managed certificate resource.
        :param Sequence[str] domains: The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
        :param str status: [Output only] Status of the managed certificate resource.
        """
        pulumi.set(__self__, "domain_status", domain_status)
        pulumi.set(__self__, "domains", domains)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="domainStatus")
    def domain_status(self) -> Mapping[str, str]:
        """
        [Output only] Detailed statuses of the domains specified for managed certificate resource.
        """
        return pulumi.get(self, "domain_status")

    @property
    @pulumi.getter
    def domains(self) -> Sequence[str]:
        """
        The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        [Output only] Status of the managed certificate resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SslCertificateSelfManagedSslCertificateResponse(dict):
    """
    Configuration and status of a self-managed SSL certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SslCertificateSelfManagedSslCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SslCertificateSelfManagedSslCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SslCertificateSelfManagedSslCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: str,
                 private_key: str):
        """
        Configuration and status of a self-managed SSL certificate.
        :param str certificate: A local certificate file. The certificate must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
        :param str private_key: A write-only private key in PEM format. Only insert requests will include this field.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        A local certificate file. The certificate must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        A write-only private key in PEM format. Only insert requests will include this field.
        """
        return pulumi.get(self, "private_key")


@pulumi.output_type
class SslPolicyWarningsItemDataItemResponse(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: A key that provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement, or a warning about invalid network settings (for example, if an instance attempts to perform IP forwarding but is not enabled for IP forwarding).
        :param str value: A warning data value corresponding to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A key that provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement, or a warning about invalid network settings (for example, if an instance attempts to perform IP forwarding but is not enabled for IP forwarding).
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A warning data value corresponding to the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SslPolicyWarningsItemResponse(dict):
    def __init__(__self__, *,
                 code: str,
                 data: Sequence['outputs.SslPolicyWarningsItemDataItemResponse'],
                 message: str):
        """
        :param str code: A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
        :param Sequence['SslPolicyWarningsItemDataItemResponse'] data: Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } 
        :param str message: A human-readable description of the warning code.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def data(self) -> Sequence['outputs.SslPolicyWarningsItemDataItemResponse']:
        """
        Metadata about this warning in key: value format. For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" } 
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable description of the warning code.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class StatefulPolicyPreservedStateResponse(dict):
    """
    Configuration of preserved resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalIPs":
            suggest = "external_ips"
        elif key == "internalIPs":
            suggest = "internal_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulPolicyPreservedStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulPolicyPreservedStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulPolicyPreservedStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disks: Mapping[str, str],
                 external_ips: Mapping[str, str],
                 internal_ips: Mapping[str, str]):
        """
        Configuration of preserved resources.
        :param Mapping[str, str] disks: Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
        :param Mapping[str, str] external_ips: External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
        :param Mapping[str, str] internal_ips: Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
        """
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "external_ips", external_ips)
        pulumi.set(__self__, "internal_ips", internal_ips)

    @property
    @pulumi.getter
    def disks(self) -> Mapping[str, str]:
        """
        Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="externalIPs")
    def external_ips(self) -> Mapping[str, str]:
        """
        External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
        """
        return pulumi.get(self, "external_ips")

    @property
    @pulumi.getter(name="internalIPs")
    def internal_ips(self) -> Mapping[str, str]:
        """
        Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
        """
        return pulumi.get(self, "internal_ips")


@pulumi.output_type
class StatefulPolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preservedState":
            suggest = "preserved_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preserved_state: 'outputs.StatefulPolicyPreservedStateResponse'):
        pulumi.set(__self__, "preserved_state", preserved_state)

    @property
    @pulumi.getter(name="preservedState")
    def preserved_state(self) -> 'outputs.StatefulPolicyPreservedStateResponse':
        return pulumi.get(self, "preserved_state")


@pulumi.output_type
class SubnetworkLogConfigResponse(dict):
    """
    The available logging options for this subnetwork.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregationInterval":
            suggest = "aggregation_interval"
        elif key == "filterExpr":
            suggest = "filter_expr"
        elif key == "flowSampling":
            suggest = "flow_sampling"
        elif key == "metadataFields":
            suggest = "metadata_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetworkLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetworkLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetworkLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregation_interval: str,
                 enable: bool,
                 filter_expr: str,
                 flow_sampling: float,
                 metadata: str,
                 metadata_fields: Sequence[str]):
        """
        The available logging options for this subnetwork.
        :param str aggregation_interval: Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
        :param bool enable: Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled.
        :param str filter_expr: Can only be specified if VPC flow logs for this subnetwork is enabled. Export filter used to define which VPC flow logs should be logged.
        :param float flow_sampling: Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
        :param str metadata: Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
        :param Sequence[str] metadata_fields: Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
        """
        pulumi.set(__self__, "aggregation_interval", aggregation_interval)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "filter_expr", filter_expr)
        pulumi.set(__self__, "flow_sampling", flow_sampling)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "metadata_fields", metadata_fields)

    @property
    @pulumi.getter(name="aggregationInterval")
    def aggregation_interval(self) -> str:
        """
        Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
        """
        return pulumi.get(self, "aggregation_interval")

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="filterExpr")
    def filter_expr(self) -> str:
        """
        Can only be specified if VPC flow logs for this subnetwork is enabled. Export filter used to define which VPC flow logs should be logged.
        """
        return pulumi.get(self, "filter_expr")

    @property
    @pulumi.getter(name="flowSampling")
    def flow_sampling(self) -> float:
        """
        Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
        """
        return pulumi.get(self, "flow_sampling")

    @property
    @pulumi.getter
    def metadata(self) -> str:
        """
        Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metadataFields")
    def metadata_fields(self) -> Sequence[str]:
        """
        Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
        """
        return pulumi.get(self, "metadata_fields")


@pulumi.output_type
class SubnetworkSecondaryRangeResponse(dict):
    """
    Represents a secondary IP range of a subnetwork.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipCidrRange":
            suggest = "ip_cidr_range"
        elif key == "rangeName":
            suggest = "range_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetworkSecondaryRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetworkSecondaryRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetworkSecondaryRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_cidr_range: str,
                 range_name: str):
        """
        Represents a secondary IP range of a subnetwork.
        :param str ip_cidr_range: The range of IP addresses belonging to this subnetwork secondary range. Provide this property when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and secondary IP ranges within a network. Only IPv4 is supported. The range can be any range listed in the Valid ranges list.
        :param str range_name: The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.
        """
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        pulumi.set(__self__, "range_name", range_name)

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> str:
        """
        The range of IP addresses belonging to this subnetwork secondary range. Provide this property when you create the subnetwork. Ranges must be unique and non-overlapping with all primary and secondary IP ranges within a network. Only IPv4 is supported. The range can be any range listed in the Valid ranges list.
        """
        return pulumi.get(self, "ip_cidr_range")

    @property
    @pulumi.getter(name="rangeName")
    def range_name(self) -> str:
        """
        The name associated with this subnetwork secondary range, used when adding an alias IP range to a VM instance. The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within the subnetwork.
        """
        return pulumi.get(self, "range_name")


@pulumi.output_type
class SubsettingResponse(dict):
    """
    Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing, Internal HTTP(S) load balancing and Traffic Director.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subsetSize":
            suggest = "subset_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubsettingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubsettingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubsettingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy: str,
                 subset_size: int):
        """
        Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing, Internal HTTP(S) load balancing and Traffic Director.
        :param int subset_size: The number of backends per backend group assigned to each proxy instance or each service mesh client. An input parameter to the `CONSISTENT_HASH_SUBSETTING` algorithm. Can only be set if `policy` is set to `CONSISTENT_HASH_SUBSETTING`. Can only be set if load balancing scheme is `INTERNAL_MANAGED` or `INTERNAL_SELF_MANAGED`. `subset_size` is optional for Internal HTTP(S) load balancing and required for Traffic Director. If you do not provide this value, Cloud Load Balancing will calculate it dynamically to optimize the number of proxies/clients visible to each backend and vice versa. Must be greater than 0. If `subset_size` is larger than the number of backends/endpoints, then subsetting is disabled.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "subset_size", subset_size)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="subsetSize")
    def subset_size(self) -> int:
        """
        The number of backends per backend group assigned to each proxy instance or each service mesh client. An input parameter to the `CONSISTENT_HASH_SUBSETTING` algorithm. Can only be set if `policy` is set to `CONSISTENT_HASH_SUBSETTING`. Can only be set if load balancing scheme is `INTERNAL_MANAGED` or `INTERNAL_SELF_MANAGED`. `subset_size` is optional for Internal HTTP(S) load balancing and required for Traffic Director. If you do not provide this value, Cloud Load Balancing will calculate it dynamically to optimize the number of proxies/clients visible to each backend and vice versa. Must be greater than 0. If `subset_size` is larger than the number of backends/endpoints, then subsetting is disabled.
        """
        return pulumi.get(self, "subset_size")


@pulumi.output_type
class TCPHealthCheckResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"
        elif key == "portSpecification":
            suggest = "port_specification"
        elif key == "proxyHeader":
            suggest = "proxy_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TCPHealthCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TCPHealthCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TCPHealthCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 port_name: str,
                 port_specification: str,
                 proxy_header: str,
                 request: str,
                 response: str):
        """
        :param int port: The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
        :param str port_name: Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        :param str port_specification: Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, TCP health check follows behavior specified in port and portName fields.
        :param str proxy_header: Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        :param str request: The application data to send once the TCP connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
        :param str response: The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_name", port_name)
        pulumi.set(__self__, "port_specification", port_specification)
        pulumi.set(__self__, "proxy_header", proxy_header)
        pulumi.set(__self__, "request", request)
        pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> str:
        """
        Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="portSpecification")
    def port_specification(self) -> str:
        """
        Specifies how port is selected for health checking, can be one of following values: USE_FIXED_PORT: The port number in port is used for health checking. USE_NAMED_PORT: The portName is used for health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking. If not specified, TCP health check follows behavior specified in port and portName fields.
        """
        return pulumi.get(self, "port_specification")

    @property
    @pulumi.getter(name="proxyHeader")
    def proxy_header(self) -> str:
        """
        Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        """
        return pulumi.get(self, "proxy_header")

    @property
    @pulumi.getter
    def request(self) -> str:
        """
        The application data to send once the TCP connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def response(self) -> str:
        """
        The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class TagsResponse(dict):
    """
    A set of instance tags.
    """
    def __init__(__self__, *,
                 fingerprint: str,
                 items: Sequence[str]):
        """
        A set of instance tags.
        :param str fingerprint: Specifies a fingerprint for this request, which is essentially a hash of the tags' contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update tags. You must always provide an up-to-date fingerprint hash in order to update or change tags. To see the latest fingerprint, make get() request to the instance.
        :param Sequence[str] items: An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        Specifies a fingerprint for this request, which is essentially a hash of the tags' contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update tags. You must always provide an up-to-date fingerprint hash in order to update or change tags. To see the latest fingerprint, make get() request to the instance.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        """
        An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class Uint128Response(dict):
    def __init__(__self__, *,
                 high: str,
                 low: str):
        pulumi.set(__self__, "high", high)
        pulumi.set(__self__, "low", low)

    @property
    @pulumi.getter
    def high(self) -> str:
        return pulumi.get(self, "high")

    @property
    @pulumi.getter
    def low(self) -> str:
        return pulumi.get(self, "low")


@pulumi.output_type
class UrlMapTestHeaderResponse(dict):
    """
    HTTP headers used in UrlMapTests.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        HTTP headers used in UrlMapTests.
        :param str name: Header name.
        :param str value: Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Header name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UrlMapTestResponse(dict):
    """
    Message for the expected URL mappings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedOutputUrl":
            suggest = "expected_output_url"
        elif key == "expectedRedirectResponseCode":
            suggest = "expected_redirect_response_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlMapTestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlMapTestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlMapTestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 expected_output_url: str,
                 expected_redirect_response_code: int,
                 headers: Sequence['outputs.UrlMapTestHeaderResponse'],
                 host: str,
                 path: str,
                 service: str):
        """
        Message for the expected URL mappings.
        :param str description: Description of this test case.
        :param str expected_output_url: The expected output URL evaluated by the load balancer containing the scheme, host, path and query parameters. For rules that forward requests to backends, the test passes only when expectedOutputUrl matches the request forwarded by the load balancer to backends. For rules with urlRewrite, the test verifies that the forwarded request matches hostRewrite and pathPrefixRewrite in the urlRewrite action. When service is specified, expectedOutputUrl`s scheme is ignored. For rules with urlRedirect, the test passes only if expectedOutputUrl matches the URL in the load balancer's redirect response. If urlRedirect specifies https_redirect, the test passes only if the scheme in expectedOutputUrl is also set to HTTPS. If urlRedirect specifies strip_query, the test passes only if expectedOutputUrl does not contain any query parameters. expectedOutputUrl is optional when service is specified.
        :param int expected_redirect_response_code: For rules with urlRedirect, the test passes only if expectedRedirectResponseCode matches the HTTP status code in load balancer's redirect response. expectedRedirectResponseCode cannot be set when service is set.
        :param Sequence['UrlMapTestHeaderResponse'] headers: HTTP headers for this request. If headers contains a host header, then host must also match the header value.
        :param str host: Host portion of the URL. If headers contains a host header, then host must also match the header value.
        :param str path: Path portion of the URL.
        :param str service: Expected BackendService or BackendBucket resource the given URL should be mapped to. The service field cannot be set if expectedRedirectResponseCode is set.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expected_output_url", expected_output_url)
        pulumi.set(__self__, "expected_redirect_response_code", expected_redirect_response_code)
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of this test case.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expectedOutputUrl")
    def expected_output_url(self) -> str:
        """
        The expected output URL evaluated by the load balancer containing the scheme, host, path and query parameters. For rules that forward requests to backends, the test passes only when expectedOutputUrl matches the request forwarded by the load balancer to backends. For rules with urlRewrite, the test verifies that the forwarded request matches hostRewrite and pathPrefixRewrite in the urlRewrite action. When service is specified, expectedOutputUrl`s scheme is ignored. For rules with urlRedirect, the test passes only if expectedOutputUrl matches the URL in the load balancer's redirect response. If urlRedirect specifies https_redirect, the test passes only if the scheme in expectedOutputUrl is also set to HTTPS. If urlRedirect specifies strip_query, the test passes only if expectedOutputUrl does not contain any query parameters. expectedOutputUrl is optional when service is specified.
        """
        return pulumi.get(self, "expected_output_url")

    @property
    @pulumi.getter(name="expectedRedirectResponseCode")
    def expected_redirect_response_code(self) -> int:
        """
        For rules with urlRedirect, the test passes only if expectedRedirectResponseCode matches the HTTP status code in load balancer's redirect response. expectedRedirectResponseCode cannot be set when service is set.
        """
        return pulumi.get(self, "expected_redirect_response_code")

    @property
    @pulumi.getter
    def headers(self) -> Sequence['outputs.UrlMapTestHeaderResponse']:
        """
        HTTP headers for this request. If headers contains a host header, then host must also match the header value.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host portion of the URL. If headers contains a host header, then host must also match the header value.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path portion of the URL.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Expected BackendService or BackendBucket resource the given URL should be mapped to. The service field cannot be set if expectedRedirectResponseCode is set.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class UrlRewriteResponse(dict):
    """
    The spec for modifying the path before sending the request to the matched backend service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRewrite":
            suggest = "host_rewrite"
        elif key == "pathPrefixRewrite":
            suggest = "path_prefix_rewrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlRewriteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlRewriteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlRewriteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_rewrite: str,
                 path_prefix_rewrite: str):
        """
        The spec for modifying the path before sending the request to the matched backend service.
        :param str host_rewrite: Before forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite. The value must be from 1 to 255 characters.
        :param str path_prefix_rewrite: Before forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite. The value must be from 1 to 1024 characters.
        """
        pulumi.set(__self__, "host_rewrite", host_rewrite)
        pulumi.set(__self__, "path_prefix_rewrite", path_prefix_rewrite)

    @property
    @pulumi.getter(name="hostRewrite")
    def host_rewrite(self) -> str:
        """
        Before forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite. The value must be from 1 to 255 characters.
        """
        return pulumi.get(self, "host_rewrite")

    @property
    @pulumi.getter(name="pathPrefixRewrite")
    def path_prefix_rewrite(self) -> str:
        """
        Before forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite. The value must be from 1 to 1024 characters.
        """
        return pulumi.get(self, "path_prefix_rewrite")


@pulumi.output_type
class VpnGatewayVpnGatewayInterfaceResponse(dict):
    """
    A VPN gateway interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interconnectAttachment":
            suggest = "interconnect_attachment"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnGatewayVpnGatewayInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnGatewayVpnGatewayInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnGatewayVpnGatewayInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interconnect_attachment: str,
                 ip_address: str):
        """
        A VPN gateway interface.
        :param str interconnect_attachment: URL of the VLAN attachment (interconnectAttachment) resource for this VPN gateway interface. When the value of this field is present, the VPN gateway is used for IPsec-encrypted Cloud Interconnect; all egress or ingress traffic for this VPN gateway interface goes through the specified VLAN attachment resource. Not currently available publicly. 
        :param str ip_address: IP address for this VPN interface associated with the VPN gateway. The IP address could be either a regional external IP address or a regional internal IP address. The two IP addresses for a VPN gateway must be all regional external or regional internal IP addresses. There cannot be a mix of regional external IP addresses and regional internal IP addresses. For IPsec-encrypted Cloud Interconnect, the IP addresses for both interfaces could either be regional internal IP addresses or regional external IP addresses. For regular (non IPsec-encrypted Cloud Interconnect) HA VPN tunnels, the IP address must be a regional external IP address.
        """
        pulumi.set(__self__, "interconnect_attachment", interconnect_attachment)
        pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> str:
        """
        URL of the VLAN attachment (interconnectAttachment) resource for this VPN gateway interface. When the value of this field is present, the VPN gateway is used for IPsec-encrypted Cloud Interconnect; all egress or ingress traffic for this VPN gateway interface goes through the specified VLAN attachment resource. Not currently available publicly. 
        """
        return pulumi.get(self, "interconnect_attachment")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP address for this VPN interface associated with the VPN gateway. The IP address could be either a regional external IP address or a regional internal IP address. The two IP addresses for a VPN gateway must be all regional external or regional internal IP addresses. There cannot be a mix of regional external IP addresses and regional internal IP addresses. For IPsec-encrypted Cloud Interconnect, the IP addresses for both interfaces could either be regional internal IP addresses or regional external IP addresses. For regular (non IPsec-encrypted Cloud Interconnect) HA VPN tunnels, the IP address must be a regional external IP address.
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class WeightedBackendServiceResponse(dict):
    """
    In contrast to a single BackendService in HttpRouteAction to which all matching traffic is directed to, WeightedBackendService allows traffic to be split across multiple backend services. The volume of traffic for each backend service is proportional to the weight specified in each WeightedBackendService
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendService":
            suggest = "backend_service"
        elif key == "headerAction":
            suggest = "header_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeightedBackendServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeightedBackendServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeightedBackendServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_service: str,
                 header_action: 'outputs.HttpHeaderActionResponse',
                 weight: int):
        """
        In contrast to a single BackendService in HttpRouteAction to which all matching traffic is directed to, WeightedBackendService allows traffic to be split across multiple backend services. The volume of traffic for each backend service is proportional to the weight specified in each WeightedBackendService
        :param str backend_service: The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
        :param 'HttpHeaderActionResponse' header_action: Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        :param int weight: Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. The value must be from 0 to 1000.
        """
        pulumi.set(__self__, "backend_service", backend_service)
        pulumi.set(__self__, "header_action", header_action)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> str:
        """
        The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
        """
        return pulumi.get(self, "backend_service")

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> 'outputs.HttpHeaderActionResponse':
        """
        Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. The value must be from 0 to 1000.
        """
        return pulumi.get(self, "weight")


