# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetImportJobResult',
    'AwaitableGetImportJobResult',
    'get_import_job',
    'get_import_job_output',
]

@pulumi.output_type
class GetImportJobResult:
    def __init__(__self__, attestation=None, create_time=None, expire_event_time=None, expire_time=None, generate_time=None, import_method=None, name=None, protection_level=None, public_key=None, state=None):
        if attestation and not isinstance(attestation, dict):
            raise TypeError("Expected argument 'attestation' to be a dict")
        pulumi.set(__self__, "attestation", attestation)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if expire_event_time and not isinstance(expire_event_time, str):
            raise TypeError("Expected argument 'expire_event_time' to be a str")
        pulumi.set(__self__, "expire_event_time", expire_event_time)
        if expire_time and not isinstance(expire_time, str):
            raise TypeError("Expected argument 'expire_time' to be a str")
        pulumi.set(__self__, "expire_time", expire_time)
        if generate_time and not isinstance(generate_time, str):
            raise TypeError("Expected argument 'generate_time' to be a str")
        pulumi.set(__self__, "generate_time", generate_time)
        if import_method and not isinstance(import_method, str):
            raise TypeError("Expected argument 'import_method' to be a str")
        pulumi.set(__self__, "import_method", import_method)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protection_level and not isinstance(protection_level, str):
            raise TypeError("Expected argument 'protection_level' to be a str")
        pulumi.set(__self__, "protection_level", protection_level)
        if public_key and not isinstance(public_key, dict):
            raise TypeError("Expected argument 'public_key' to be a dict")
        pulumi.set(__self__, "public_key", public_key)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def attestation(self) -> 'outputs.KeyOperationAttestationResponse':
        """
        Statement that was generated and signed by the key creator (for example, an HSM) at key creation time. Use this statement to verify attributes of the key as stored on the HSM, independently of Google. Only present if the chosen ImportMethod is one with a protection level of HSM.
        """
        return pulumi.get(self, "attestation")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which this ImportJob was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expireEventTime")
    def expire_event_time(self) -> str:
        """
        The time this ImportJob expired. Only present if state is EXPIRED.
        """
        return pulumi.get(self, "expire_event_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The time at which this ImportJob is scheduled for expiration and can no longer be used to import key material.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="generateTime")
    def generate_time(self) -> str:
        """
        The time this ImportJob's key material was generated.
        """
        return pulumi.get(self, "generate_time")

    @property
    @pulumi.getter(name="importMethod")
    def import_method(self) -> str:
        """
        Immutable. The wrapping method to be used for incoming key material.
        """
        return pulumi.get(self, "import_method")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name for this ImportJob in the format `projects/*/locations/*/keyRings/*/importJobs/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> str:
        """
        Immutable. The protection level of the ImportJob. This must match the protection_level of the version_template on the CryptoKey you attempt to import into.
        """
        return pulumi.get(self, "protection_level")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> 'outputs.WrappingPublicKeyResponse':
        """
        The public key with which to wrap key material prior to import. Only returned if state is ACTIVE.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the ImportJob, indicating if it can be used.
        """
        return pulumi.get(self, "state")


class AwaitableGetImportJobResult(GetImportJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImportJobResult(
            attestation=self.attestation,
            create_time=self.create_time,
            expire_event_time=self.expire_event_time,
            expire_time=self.expire_time,
            generate_time=self.generate_time,
            import_method=self.import_method,
            name=self.name,
            protection_level=self.protection_level,
            public_key=self.public_key,
            state=self.state)


def get_import_job(import_job_id: Optional[str] = None,
                   key_ring_id: Optional[str] = None,
                   location: Optional[str] = None,
                   project: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImportJobResult:
    """
    Returns metadata for a given ImportJob.
    """
    __args__ = dict()
    __args__['importJobId'] = import_job_id
    __args__['keyRingId'] = key_ring_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:cloudkms/v1:getImportJob', __args__, opts=opts, typ=GetImportJobResult).value

    return AwaitableGetImportJobResult(
        attestation=__ret__.attestation,
        create_time=__ret__.create_time,
        expire_event_time=__ret__.expire_event_time,
        expire_time=__ret__.expire_time,
        generate_time=__ret__.generate_time,
        import_method=__ret__.import_method,
        name=__ret__.name,
        protection_level=__ret__.protection_level,
        public_key=__ret__.public_key,
        state=__ret__.state)


@_utilities.lift_output_func(get_import_job)
def get_import_job_output(import_job_id: Optional[pulumi.Input[str]] = None,
                          key_ring_id: Optional[pulumi.Input[str]] = None,
                          location: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetImportJobResult]:
    """
    Returns metadata for a given ImportJob.
    """
    ...
