# -*- coding: utf-8 -*-
#
# fastr documentation build configuration file, created by
# sphinx-quickstart on Fri Aug 12 17:01:23 2011.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

from collections import namedtuple
import os
import sys

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.dirname(__file__))

# Read the docs hacks
on_rtd = os.environ.get('READTHEDOCS', None) == 'True'
if on_rtd:
    print('[conf.py] On Read the Docs')

from generate_modules import recurse_tree
from doc_clean import clean

# -- General configuration -----------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
        'sphinx.ext.autodoc',
        'sphinx_autodoc_typehints',
        'sphinx.ext.todo',
        'sphinx.ext.coverage',
        'sphinx.ext.viewcode',
        'sphinx.ext.inheritance_diagram',
        'sphinx.ext.intersphinx',
        'sphinx.ext.graphviz',
        'sphinxcontrib.httpdomain',
        'sphinxarg.ext'
]

# Intersphinx mapping to Pyhton documentation
intersphinx_mapping = {'python': ('https://docs.python.org/3', None)}

# Graphviz output format to svg
graphviz_output_format = 'svg'

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# Numbering references
numfig = True

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
# master_doc = 'modules'
master_doc = 'index'

# General information about the project.
project = 'FASTR'
copyright = '2011 -- 2019, Biomedical Imaging Group Rotterdam, Departments of ' \
            'Medical Informatics and Radiology, Erasmus MC, Rotterdam, The Netherlands'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#

try:
    import fastr.version
    release = fastr.version.version
except ImportError:
    with open(os.path.join(os.path.dirname(__file__),
                           '..', '..',
                           'version')) as version_file:
        release = version_file.read().strip()

# The short X.Y version.
version = '.'.join(release.split('.')[:2])
print('[conf.py] Found version: {}'.format(version))

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['_build']

# The reST default role (used for this markup: `text`) to use for all documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
if not on_rtd:
    import sphinx_rtd_theme
    html_theme = 'sphinx_rtd_theme'
    html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]
else:
    html_theme = 'default'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
# html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
# html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = 'static/images/logo.svg'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = 'static/images/favicon.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['static/sources']

html_css_files = ['extra.css']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_domain_indices = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
# html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = 'FASTRdoc'


# -- Options for LaTeX output --------------------------------------------------

# The paper size ('letter' or 'a4').
latex_element = {
    'papersize': 'a4',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howtos/manual]).
latex_documents = [
    ('index', 'FASTR.tex', 'FASTR Documentation',
     'Fastr contributors', 'manual'),
]

# -- Options for manual page output --------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ('index', 'bigr-fastr', 'FASTR Documentation',
     ['Fastr contributors'], 1)
]

# Some autogeneration of documentation (make autodoc index, generate plugin
# references etc.
if hasattr(sys, 'real_prefix'):
    print('[conf.py] Inside virtual env: {}'.format(sys.prefix))
else:
    print('[conf.py] Not inside a virtual env!')

try:
    import fastr
    print('[conf.py] Loaded fastr, will build reference of available plugins')
except ImportError:
    print('[conf.py] Cannot load fastr, will not build reference of plugins!')
    fastr = None

print('[conf.py] Current directory: {}'.format(os.path.abspath(os.curdir)))

print('[conf.py] Cleaning old files...')
clean()  # call doc_clean via code

if fastr is not None:
    print('[conf.py] Generating configuration reference')
    from generate_config import generate_config_doc
    generate_config_doc()

    print('[conf.py] Generating Plugin reference')
    from generate_plugins import generate_all
    generate_all()

    print('[conf.py] Generating Command-line reference')
    from generate_cmd import generate_command_reference
    generate_command_reference()

print('[conf.py] python generate_modules.py ..' + os.path.sep + ' -d .' + os.path.sep + ' -s rst -f')

# Call generate modules from code rather than via a subprocess
# Feed all options via opts namedtuple
options = {'destdir': './_autogen/',
           'dryrun': False,
           'force': True,
           'maxdepth': 4,
           'notoc': False,
           'suffix': 'rst'}

opts = namedtuple('opts', list(options.keys()))(*list(options.values()))
rootpath = '../'
excludes = [
    os.path.abspath(os.path.join(rootpath, 'doc')),
    os.path.abspath(os.path.join(rootpath, 'examples')),
    os.path.abspath(os.path.join(rootpath, 'resources')),
]
recurse_tree(rootpath, excludes, opts)

print('[conf.py] Done...')
print('[conf.py] Found files in curdir: {}'.format(os.listdir('.')))
