"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("@aws-cdk/core");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const autoscaler_1 = require("./autoscaler");
const path = require("path");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const stack = new cdk.Stack(app, 'FargateFastAutoscalerDemo');
        const vpc = new ec2.Vpc(stack, 'Vpc', { maxAzs: 3, natGateways: 1 });
        new autoscaler_1.FargateFastAutoscaler(stack, 'FargateFastAutoscaler', {
            vpc,
            backendContainer: {
                image: aws_ecs_1.ContainerImage.fromAsset(path.join(__dirname, '../sample/backend/php')),
                cpu: 0,
                logging: new aws_ecs_1.AwsLogDriver({
                    streamPrefix: 'echo-http-req',
                }),
            },
            backendContainerPortMapping: [
                { containerPort: 2015 },
            ],
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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