import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as sns from '@aws-cdk/aws-sns';
export interface FargateFastAutoscalerProps {
    /**
     * The VPC for the stack
     */
    readonly vpc: ec2.IVpc;
    /**
     * SNS Topic to publish the notification
     *
     * @default - do not publish to SNS
     */
    readonly snsTopic?: sns.ITopic;
    /**
     * AWS CLI Lambda layer ARN in Serverless App Repository
     *
     * @default - 'arn:aws:serverlessrepo:us-east-1:903779448426:applications/lambda-layer-awscli'
     */
    readonly awsCliLayerArn?: string;
    /**
     * The version of the Serverless App for AWS CLI Lambda layer
     *
     * @default - AWSCLI_LAYER_VERSION
     */
    readonly awsCliLayerVersion?: string;
    /**
     * backend container
     */
    readonly backendContainer: ecs.ContainerDefinitionOptions;
    /**
     * container port for the backend container
     */
    readonly backendContainerPortMapping: ecs.PortMapping[];
    /**
     * initial number of tasks for the service
     *
     * @default - 2
     */
    readonly initialTaskNumber?: number;
    /**
     * disable scale in
     *
     * @default - true
     */
    readonly disableScaleIn?: boolean;
}
export declare class FargateFastAutoscaler extends cdk.Construct {
    readonly fargateWatcherFuncArn: string;
    readonly layerVersionArn: string;
    readonly fargateService: ecs.FargateService;
    readonly fargateTaskDef: ecs.FargateTaskDefinition;
    readonly vpc: ec2.IVpc;
    readonly region: string;
    constructor(scope: cdk.Construct, id: string, props: FargateFastAutoscalerProps);
}
