#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Ядро
"""

# ######################################################################################################################
# Импорт необходимых инструментов
# ######################################################################################################################
import argparse   # Парсинг аргументов и параметров командной строки

from datetime import datetime  # Работа со временем

# Персональные
from oidv6.modules.core import config as cfg  # Глобальный файл настроек
from oidv6.modules.trml.shell import Shell  # Работа с Shell


# ######################################################################################################################
# Ядро для пакетов
# ######################################################################################################################
class Core(cfg.Messages):
    """Ядро для пакетов"""

    # ------------------------------------------------------------------------------------------------------------------
    # Конструктор
    # ------------------------------------------------------------------------------------------------------------------

    def __init__(self):
        super().__init__()  # Выполнение конструктора из суперкласса

        self._ap = None  # Парсер для параметров командной строки

    # ------------------------------------------------------------------------------------------------------------------
    # Внешние методы
    # ------------------------------------------------------------------------------------------------------------------

    # Построение аргументов командной строки
    def build_args(self, conv_to_dict = True):
        """
        Построение аргументов командной строки

        ([bool]) -> None or dict

        Аргументы:
           conv_to_dict - Преобразование списка аргументов командной строки в словарь

        Возвращает: dict если парсер командной строки окончательный, в обратном случае None
        """

        # Парсер для параметров командной строки
        self._ap = argparse.ArgumentParser(
            description = 'Массовая загрузка набора данных Open Images Dataset V6 (OIDv6)'
        )

        if conv_to_dict is True:
            return vars(self._ap.parse_args())  # Преобразование списка аргументов командной строки в словарь

    # Очистка консоли
    def clear_shell(self, cls, out = True):
        """
        Очистка консоли

        (bool [, bool]) -> None

        Аргументы:
           cls - Вариант очистки консоли
           out - Печатать процесс выполнения
        """

        # Проверка аргументов
        if type(cls) is not bool or type(out) is not bool:
            # Вывод сообщения
            if out is True:
                print(self._invalid_arguments.format(
                    self.red, datetime.now().strftime(self._format_time),
                    self.end, __class__.__name__ + '.' + self.clear_shell.__name__
                ))

            return False

        if cls is True:
            Shell.clear()  # Очистка консоли
