/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent.documentation;

import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MulticoreWrapperDemo {
    private static Redwood.RedwoodChannels log = Redwood.channels(MulticoreWrapperDemo.class);

    private MulticoreWrapperDemo() {
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.printf("Usage: java %s model_file < input_file%n", MulticoreWrapperDemo.class.getName());
            System.exit(-1);
        }
        try {
            String line;
            String modelFile = args[0];
            final MaxentTagger tagger = new MaxentTagger(modelFile);
            int nThreads = 4;
            MulticoreWrapper<String, String> wrapper = new MulticoreWrapper<String, String>(nThreads, new ThreadsafeProcessor<String, String>(){

                @Override
                public String process(String input) {
                    return tagger.tagString(input);
                }

                @Override
                public ThreadsafeProcessor<String, String> newInstance() {
                    return this;
                }
            });
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while ((line = br.readLine()) != null) {
                wrapper.put(line);
                while (wrapper.peek()) {
                    System.out.println(wrapper.poll());
                }
            }
            wrapper.join();
            while (wrapper.peek()) {
                System.out.println(wrapper.poll());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

