"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
/**
 * Network settings for the manager and runners.
 *
 * All EC2 instances should belong to the same subnet, availability zone and vpc.
 *
 * @stability stable
 */
class Network extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.vpc = (_b = props === null || props === void 0 ? void 0 : props.vpc) !== null && _b !== void 0 ? _b : new aws_ec2_1.Vpc(scope, `Vpc`, {
            maxAzs: 1,
        });
        this.subnet = this.findSubnet(this.vpc, props === null || props === void 0 ? void 0 : props.subnetSelection);
        this.availabilityZone = this.subnet.availabilityZone;
        if (!this.hasPrivateSubnet(this.vpc)) {
            core_1.Annotations.of(this).addWarning(`No private network found in ${this.vpc.vpcId}, using public addresses.`);
        }
    }
    hasPrivateSubnet(vpc) {
        return !!vpc.privateSubnets.length;
    }
    /**
     * Returns the first private or public subnet. Optionally filters by AZ.
     *
     * @exception Throws an error if no private or public is found.
     */
    findSubnet(vpc, subnetSelection) {
        const selectedSubnets = vpc.selectSubnets(subnetSelection || {
            subnetType: this.hasPrivateSubnet(vpc) ? aws_ec2_1.SubnetType.PRIVATE_WITH_NAT : aws_ec2_1.SubnetType.PUBLIC,
            availabilityZones: vpc.availabilityZones,
        });
        const subnet = selectedSubnets.subnets.find(() => true);
        if (!subnet) {
            throw new Error(`Neither a private nor a public subnet is found in ${vpc.vpcId}`);
        }
        return subnet;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@pepperize-testing/cdk-autoscaling-gitlab-runner.Network", version: "0.0.71" };
//# sourceMappingURL=data:application/json;base64,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