# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['smol_k8s_lab',
 'smol_k8s_lab.k8s_apps',
 'smol_k8s_lab.k8s_distros',
 'smol_k8s_lab.k8s_tools']

package_data = \
{'': ['*'], 'smol_k8s_lab': ['config/*', 'config/extras/*']}

install_requires = \
['bcrypt>=4.0.1,<5.0.0',
 'click>=8.1.3,<9.0.0',
 'pyyaml>=6.0,<7.0',
 'requests>=2.28.1,<3.0.0',
 'rich>=13.0.0,<14.0.0',
 'xdg>=5.1.1,<6.0.0']

entry_points = \
{'console_scripts': ['smol-k8s-lab = smol_k8s_lab:main']}

setup_kwargs = {
    'name': 'smol-k8s-lab',
    'version': '0.10.11',
    'description': 'bootstrap simple projects on kubernetes with kind and k3s',
    'long_description': '<h2 align="center">\n  <img\n    src="https://raw.githubusercontent.com/catppuccin/catppuccin/main/assets/misc/transparent.png"\n    height="30"\n    width="0px"\n  />\nsmol k8s lab 🧸\n</h2>\n\n<p align="center">\n  <a href="https://github.com/jessebot/smol-k8s-lab/releases">\n    <img src="https://img.shields.io/github/v/release/jessebot/smol-k8s-lab?style=plastic&labelColor=484848&color=3CA324&logo=GitHub&logoColor=white">\n  </a>\n</p>\n\nA tool to get up and running **quickly** with slimmer k8s distros on your local machine. Also helpful for benchmarking various k8s distros! :)\n\n<p align="center">\n  <a href="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/screenshots/help_text.svg">\n      <img src="./docs/screenshots/help_text.svg" alt="Output of smol-k8s-lab --help after cloning the directory and installing the prerequisites.">\n  </a>\n</p>\n\n\n## Getting Started\n\n### Installation\nIf you\'ve already got Python3.11 and brew installed, you should be able to:\n\n```bash\n# install the CLI\npip3.11 install smol-k8s-lab\n\n# Check the help menu before proceeding\nsmol-k8s-lab --help\n```\n\n### Configuration\nWe\'ve got a [Quickstart guide](https://jessebot.github.io/smol-k8s-lab/quickstart) for you to jump right in, but for sake of getting you up and running quickly, please run the following:\n\n```bash\n# create the directory structure. smol-k8s-lab will also use XDG base dir spec.\n# if you\'d like XDG, change the below line to: mkdir -p $XDG_CONFIG_HOME/smol-k8s-lab\nmkdir -p ~/.config/smol-k8s-lab\n\n# this doesn\'t have to be vim, you can use any editor of your choice :)\nvim config.yaml\n```\n\nIn the newly created `config.yaml`, add the following:\n\n```yaml\n# FQDN to access your web interfaces: all of these are only required if you\n# specify optional app installs, such as argo or minio.\ndomain:\n  # your base domain for use with subdomains below\n  # if commented out, you need to provide the entire domain name for each app\n  base: "coolwebsitefordogs.com"\n  # subdomain for Argo CD, if you had base set, this would be:\n  # argocd.coolwebsitefordogs.com, otherwise you\'d need to change to the FQDN\n  argo_cd: "argocd"\n  minio: "minio"\n  minio_console: "console.minio"\n\n# metallb IPs used for DNS later (make sure they\'re not in use)\nmetallb_address_pool:\n  # Example of required full CIDR notation\n  # - 192.168.90.01/32\n\n# Used for letsencrypt-staging, to generate certs, change this to your email\nemail: "coolemailfordogs@verygooddogs.net"\n\n# Use the external secrets provider with gitlab\nexternal_secrets:\n  gitlab:\n    # token from here: https://gitlab.com/-/profile/personal_access_tokens\n    access_token: "kjdfsk758934fkldsafds"\n    namespace: "nextcloud"\n\nlog:\n  # logging level, Options: debug, info, warn, error\n  level: "info"\n  # optional: path of file to log to\n  # file: "./smol-k8s-log.log"\n```\n\nThere\'s also full tutorials to manually set up different distros in the [docs we maintain](https://jessebot.github.io/smol-k8s-lab/distros) as well as BASH scripts for basic automation of each k8s distro in:\n\n`./bash_scripts/{NAME_OF_K8S_DISTRO}/bash_full_quickstart.sh`\n\n## Under the hood\n### Supported k8s distributions\nWe always install the latest version of kubernetes that is available from the distro\'s startup script.\n\n|  Distro    |         Description              |\n|:----------:|:------------------------------------------------------|\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/k0s-logo.svg" width="32">][k0s] <br /> [k0s] | Simple, Solid & Certified Kubernetes Distribution |\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/k3s_icon.ico" width="26">][k3s] <br /> [k3s] | The certified Kubernetes distribution built for IoT & Edge computing |\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/kind_icon.png" width="32">][KinD] <br /> [KinD] | kind is a tool for running local Kubernetes clusters using Docker container “nodes”. kind was primarily designed for testing Kubernetes itself, but may be used for local development or CI. |\n\nWe tend to test first on k3s first, then the other distros.\n\n\n### Stack We Install on K8s\nVersion is the helm chart version, or manifest version.\n\n|           Application           |    Version    |                      Description                      |\n|:-------------------------------:|:-------------:|:------------------------------------------------------|\n| 🐄 <br /> [Local Path Provisioner] |   k3s latest  | Default simple local file storage for persistent data |\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/metallb_icon.png" width="32px" alt="metallb logo, blue arrow pointing up, with small line on one leg of arrow to show balance">][metallb] <br /> [metallb] | 0.13.7 | loadbalancer for metal, since we\'re mostly selfhosting |\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/nginx.ico" width="32px" alt="nginx logo, white letter N with green background">][nginx-ingress] <br /> [nginx-ingress] | 4.4.0 | The ingress controller allows access to the cluster remotely, needed for web traffic |\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/cert-manager_icon.png" width="32px" alt="cert manager logo">][cert-manager] <br /> [cert-manager] | 1.10.1 | For SSL/TLS certificates |\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/k9s_icon.png" alt="k9s logo, outline of dog with ship wheels for eyes" width="32px">][k9s]</br>[k9s] | latest | Terminal based dashboard for kubernetes |\n\n\n#### Optionally installed\n\n| Application/Tool |    Version    | Description |\n|:----------------:|:-------------:|:------------|\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/eso_icon.png" width="32" alt="ESO logo, outline of robot with astricks in a screen in it\'s belly">][ESO] <br /> [ESO] | 0.6.1 | external-secrets-operator integrates external secret management systems like GitLab|\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/argo_icon.png" width="32" alt="argo CD logo, an organer squid wearing a fishbowl helmet">][Argo CD] <br /> [Argo CD] | 5.16.2 | Gitops - Continuous Deployment |\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/kyverno_icon.png"  width="32" alt="kyvero logo">][Kyverno] <br /> [Kyverno] | latest | Kubernetes native policy management to enforce policies on k8s resources |\n| [<img src="https://raw.githubusercontent.com/jessebot/smol-k8s-lab/main/docs/icons/minio_icon.png"  width="32" alt="minio logo">][MinIO] <br /> [MinIO] | | Local object storage, for testing apps that need the S3 API |\n\n\n### Tooling Used for the CLI itself and interface\nsmol-k8s-lab is written in Python and built and published using [Poetry]. You can check out the `pyproject.toml` for the versions of each library we install below:\n\n- [rich] (this is what makes all the pretty formatted text)\n- [PyYAML] (to handle the k8s yamls and configs)\n- [bcrypt] (to pass a password to argocd and automatically update your Bitwarden)\n- [click] (handles arguments for the CLI)\n\nWe also utilize the [Bitwarden cli], for a password manager so you never have to see/know your argocd password.\n\n\n## Troubleshooting\nIf you\'re stuck, checkout the [Notes](https://jessebot.github.io/smol-k8s-lab/notes) to see if we also got stuck on the same thing at some point :) Under each app or tool, we\'ll have notes on how to learn more about it, as well as any errors we\'ve already battled.\n\n\n## Other Notes\nCheck out the [`optional`](optional) directory for quick examples on apps this script does not default install.\n\ne.g. for postgres, go to [`./optional/postgres`](./optional/postgres)\n\n# Status\nThis is still in later alpha, as we figure out all the distros we want to support,\nand pin all the versions, but if you\'d like to contribute or just found a :bug:,\nfeel free to open an issue (or pull request), and we\'ll take a look! We\'ll try\nto get back to you asap!\n\n## Contributors\n\n<!-- readme: contributors -start -->\n<table>\n<tr>\n    <td align="center">\n        <a href="https://github.com/jessebot">\n            <img src="https://avatars.githubusercontent.com/u/2389292?v=4" width="100;" alt="jessebot"/>\n            <br />\n            <sub><b>JesseBot</b></sub>\n        </a>\n    </td>\n    <td align="center">\n        <a href="https://github.com/cloudymax">\n            <img src="https://avatars.githubusercontent.com/u/84841307?v=4" width="100;" alt="cloudymax"/>\n            <br />\n            <sub><b>Max!</b></sub>\n        </a>\n    </td></tr>\n</table>\n<!-- readme: contributors -end -->\n\n## And more!\n\nWant to get started with argocd? If you\'ve installed it via smol-k8s-lab, then you can jump [here](https://github.com/jessebot/argo-example#argo-via-the-gui). Otherwise, if you want to start from scratch, start [here](https://github.com/jessebot/argo-example#argocd)\n\n<!-- k8s distro link references -->\n[k3s]: https://k3s.io/\n[KinD]: https://kind.sigs.k8s.io/\n[k0s]: https://k0sproject.io/\n\n<!-- k8s apps link references -->\n[metallb]: https://github.io/metallb/metallb "metallb"\n[Local Path Provisioner]: https://github.com/rancher/local-path-provisioner\n[nginx-ingress]: https://github.io/kubernetes/ingress-nginx\n[cert-manager]: https://cert-manager.io/docs/\n\n<!-- k8s optional apps link references -->\n[MinIO]: https://github.com/minio/minio/tree/master/helm/minio\n[ESO]: https://external-secrets.io/v0.5.9/\n[Argo CD]: https://github.io/argoproj/argo-helm\n[Kyverno]: https://github.com/kyverno/kyverno/\n\n<!-- k8s tooling reference -->\n[k9s]: https://k9scli.io/topics/install/\n\n<!-- smol-k8s-lab dependency lib link references -->\n[Poetry]: https://python-poetry.org/\n[rich]: https://github.com/Textualize/richP\n[PyYAML]: https://pyyaml.org/\n[bcrypt]: https://pypi.org/project/bcrypt/\n[click]: https://pypi.org/project/click/\n[Bitwarden cli]: https://bitwarden.com/help/cli/\n',
    'author': 'Jesse Hitch',
    'author_email': 'jessebot@linux.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://jessebot.github.io/smol-k8s-lab',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.11,<4.0.0',
}


setup(**setup_kwargs)
