from enum import Enum, auto


class DataLevel(Enum):
    """Enum of the different Data Levels"""

    R0 = auto()  # Raw data in camera or simulation format
    R1 = auto()  # Raw data in common format, with preliminary calibration
    DL0 = auto()  # raw archived data in common format, with optional zero suppression
    DL1 = auto()  # processed data
    DL1_IMAGES = auto()  # processed data up to camera images
    DL1_PARAMETERS = auto()  #  parameters derived from camera images
    DL2 = auto()  # reconstructed data
    DL3 = auto()  # reduced reconstructed data

    # the rest are not generated by ctapipe, but are listed here in case this
    # code is used elsewhere:
    DL4 = auto()  # binned  datasets
    DL5 = auto()  # science datasets (fluxes)
    DL6 = auto()  # derived science data (catalogs, etc.)
