"""
All wgpu flags. Also available in the root wgpu namespace.
"""

# THIS CODE IS AUTOGENERATED - DO NOT EDIT

_use_sphinx_repr = False


class Flags:
    def __init__(self, name, **kwargs):
        self._name = name
        for key, val in kwargs.items():
            setattr(self, key, val)

    def __iter__(self):
        return iter([key for key in dir(self) if not key.startswith("_")])

    def __repr__(self):
        options = ", ".join(self)
        if _use_sphinx_repr:  # no-cover
            return options
        return f"<{self.__class__.__name__} {self._name}: {options}>"


# There are 5 flags

BufferUsage = Flags(
    "BufferUsage",
    MAP_READ=1,
    MAP_WRITE=2,
    COPY_SRC=4,
    COPY_DST=8,
    INDEX=16,
    VERTEX=32,
    UNIFORM=64,
    STORAGE=128,
    INDIRECT=256,
    QUERY_RESOLVE=512,
)  #:

MapMode = Flags(
    "MapMode",
    READ=1,
    WRITE=2,
)  #:

TextureUsage = Flags(
    "TextureUsage",
    COPY_SRC=1,
    COPY_DST=2,
    SAMPLED=4,
    STORAGE=8,
    RENDER_ATTACHMENT=16,
)  #:

ShaderStage = Flags(
    "ShaderStage",
    VERTEX=1,
    FRAGMENT=2,
    COMPUTE=4,
)  #:

ColorWrite = Flags(
    "ColorWrite",
    RED=1,
    GREEN=2,
    BLUE=4,
    ALPHA=8,
    ALL=15,
)  #:
