from distutils.core import setup
setup(
    name='dxfstructure',
    version='0.4.8',
    description='Structural engineering dxf drawing system',
    long_description = open("README.rst").read(),
    author='Lukasz Laba',
    author_email='lukaszlaba@gmail.com',
    url='https://bitbucket.org/lukaszlaba/dxfstructure',
    package_dir={'': 'src'},
    packages=[  'dxfstructure',
                'dxfstructure.example',
                'dxfstructure.pycore',
                'dxfstructure.memos',
                'dxfstructure.qtui'],
    package_data = {'': ['*.dxf', '*.png', '*.md', '*.rst']},
    license = 'GNU General Public License (GPL)',
    keywords = 'civil engineering ,structural engineering, concrete structures, steel structures',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: X11 Applications :: Qt',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Operating System :: POSIX :: Linux',
        'Operating System :: Microsoft :: Windows',
        'Programming Language :: Python',
        'Topic :: Scientific/Engineering',
        ],
    python_requires='>=3.5, <4',
    install_requires=['ezdxf==0.8.8', 'pyqt5>=5.6', 'strupy', 'tabulate==0.8.9', 'mistune==0.8.4', 'unum'],
    entry_points={'console_scripts':['DxfStructure = dxfstructure.DxfStructure:main']},
    )