"use strict";
// Copyright (c) Juelich Supercomputing Centre (JSC)
// Distributed under the terms of the Modified BSD License.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const version_1 = require("./version");
const SmartConnect_1 = __importDefault(require("wslink/src/SmartConnect"));
const RemoteRenderer_1 = __importDefault(require("paraviewweb/src/NativeUI/Canvas/RemoteRenderer"));
const SizeHelper_1 = __importDefault(require("paraviewweb/src/Common/Misc/SizeHelper"));
const ParaViewWebClient_1 = __importDefault(require("paraviewweb/src/IO/WebSocket/ParaViewWebClient"));
class RemoteRendererModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign({}, super.defaults(), { _model_name: RemoteRendererModel.model_name, _model_module: RemoteRendererModel.model_module, _model_module_version: RemoteRendererModel.model_module_version, _view_name: RemoteRendererModel.view_name, _view_module: RemoteRendererModel.view_module, _view_module_version: RemoteRendererModel.view_module_version });
    }
}
RemoteRendererModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
RemoteRendererModel.model_name = 'RemoteRendererModel';
RemoteRendererModel.model_module = version_1.MODULE_NAME;
RemoteRendererModel.model_module_version = version_1.MODULE_VERSION;
RemoteRendererModel.view_name = 'RemoteRendererView';
RemoteRendererModel.view_module = version_1.MODULE_NAME;
RemoteRendererModel.view_module_version = version_1.MODULE_VERSION;
exports.RemoteRendererModel = RemoteRendererModel;
class RemoteRendererView extends base_1.DOMWidgetView {
    render() {
        this.el.classList.add('custom-widget');
        var that = this;
        // div to hold the canvas of the RemoteRenderer.
        var render_div = document.createElement('div');
        render_div.style.height = '100%';
        render_div.style.minHeight = '300px';
        render_div.style.width = '100%';
        this.el.appendChild(render_div);
        /* Get configuration for SmartConnect.
        *  SmartConnect will establish a direct
        *  WebSocket connection using Autobahn.
        */
        var config = {
            sessionURL: this.model.get('sessionURL'),
            secret: this.model.get('authKey')
        };
        var smartConnect = SmartConnect_1.default.newInstance({ config: config });
        console.log(smartConnect);
        smartConnect.onConnectionReady(function (connection) {
            // Create the RemoteRenderer
            var pvwClient = ParaViewWebClient_1.default.createClient(connection, [
                'MouseHandler',
                'ViewPort',
                'ViewPortImageDelivery'
            ]);
            var renderer = new RemoteRenderer_1.default(pvwClient, render_div, that.model.get('viewID'));
            // renderer.setContainer(render_div);
            // renderer.setView(that.model.get('viewID'));
            renderer.onImageReady(function () {
                // Resize when the renderer is placed within a widget.
                if (that.el.style.width != '100%') {
                    that.el.style.width = '100%';
                    renderer.resize();
                }
                console.log("We are good.");
            });
            render_div.onresize = function () {
                if (that.el.style.width != '100%') {
                    that.el.style.width = '100%';
                    renderer.resize();
                }
                renderer.resize();
            };
            // Handle size changes when the entire window is resized.
            SizeHelper_1.default.onSizeChange(function () {
                renderer.resize();
            });
            SizeHelper_1.default.startListening();
            // Explicit render called from python side.
            that.model.on('change:_update', function () {
                renderer.render(true);
            }, that);
        });
        smartConnect.connect();
    }
}
exports.RemoteRendererView = RemoteRendererView;
//# sourceMappingURL=widget.js.map