"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Grafana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const dashboard_1 = require("./dashboard");
const datasource_1 = require("./datasource");
const grafana_1 = require("./imports/grafana");
/**
 * A Grafana instance.
 *
 * @stability stable
 */
class Grafana extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(scope, id);
        this.labels = (_b = props.labels) !== null && _b !== void 0 ? _b : { app: 'grafana' };
        this.dataSources = [];
        this.dashboards = [];
        this.namespace = props.namespace;
        const baseImage = (_c = props.image) !== null && _c !== void 0 ? _c : 'public.ecr.aws/ubuntu/grafana:latest';
        const ingress = (_d = props.ingress) !== null && _d !== void 0 ? _d : true;
        const adminUser = (_e = props.adminUser) !== null && _e !== void 0 ? _e : 'root';
        const adminPassword = (_f = props.adminPassword) !== null && _f !== void 0 ? _f : 'secret';
        const requireLogin = (_g = props.requireLogin) !== null && _g !== void 0 ? _g : false;
        const dashboardLabelSelectors = [{ matchLabels: (_h = this.labels) !== null && _h !== void 0 ? _h : { app: 'grafana' } }];
        new grafana_1.Grafana(this, 'Resource', {
            metadata: {
                labels: this.labels,
                namespace: this.namespace,
            },
            spec: {
                baseImage: baseImage,
                ingress: {
                    enabled: ingress,
                },
                client: {
                    // without this, dashboards may not be automatically discovered
                    // https://github.com/grafana-operator/grafana-operator/blob/master/documentation/deploy_grafana.md#configuring-grafana-api-access
                    preferService: true,
                },
                config: {
                    'log': {
                        mode: 'console',
                        level: 'info',
                    },
                    'auth.anonymous': {
                        enabled: !requireLogin,
                    },
                    'security': {
                        admin_user: adminUser,
                        admin_password: adminPassword,
                    },
                },
                deployment: {
                    labels: this.labels,
                },
                dashboardLabelSelector: dashboardLabelSelectors,
            },
        });
        if (props.defaultDataSource) {
            this.addDataSource('default-datasource', props.defaultDataSource);
        }
    }
    /**
     * Adds a data source.
     *
     * By default, labels are automatically added so that
     * the data source is detected by Grafana.
     *
     * @stability stable
     */
    addDataSource(id, props) {
        const labels = {
            ...this.labels,
            ...props.labels,
        };
        const datasource = new datasource_1.DataSource(this, id, {
            labels,
            namespace: this.namespace,
            ...props,
        });
        this.dataSources.push(datasource);
        return datasource;
    }
    /**
     * Creates a dashboard associated with a particular data source.
     *
     * By default,
     * labels are automatically added so that the data source is detected by
     * Grafana.
     *
     * @stability stable
     */
    addDashboard(id, props) {
        const labels = {
            ...this.labels,
            ...props.labels,
        };
        const dashboard = new dashboard_1.Dashboard(this, id, {
            labels,
            namespace: this.namespace,
            ...props,
        });
        this.dashboards.push(dashboard);
        return dashboard;
    }
}
exports.Grafana = Grafana;
_a = JSII_RTTI_SYMBOL_1;
Grafana[_a] = { fqn: "cdk8s-grafana.Grafana", version: "0.0.74" };
//# sourceMappingURL=data:application/json;base64,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