% Number of different bins in sensitivity calculation:

SENS_N_MAT = 1;
SENS_N_ZAI = 2;
SENS_N_PERT = 7;
SENS_N_ENE = 175;

% Materials included in sensitivity calculation:

SENS_MAT_LIST = [
'total               '
];

% Indices for different materials:

iSENS_MAT_TOT              = 1;

% Nuclides included in sensitivity calculation:

SENS_ZAI_LIST = [
0        % total
922380  
];

% Indices for different ZAIs:

iSENS_ZAI_TOT      = 1;
iSENS_ZAI_922380   = 2;

% Reactions included in sensitivity calculation:

SENS_PERT_LIST = [
'total xs            '
'ela scatt xs        '
'sab scatt xs        '
'inl scatt xs        '
'capture xs          '
'fission xs          '
'nxn xs              '
];

% Indices for different perturbations:

iSENS_PERT_TOT_XS       = 1;
iSENS_PERT_ELA_XS       = 2;
iSENS_PERT_SAB_XS       = 3;
iSENS_PERT_INL_XS       = 4;
iSENS_PERT_CAPT_XS      = 5;
iSENS_PERT_FISS_XS      = 6;
iSENS_PERT_NXN_XS       = 7;

% Sensitivity calculation energy group boundaries:

SENS_E = [  1.00001E-11  1.00001E-07  4.13994E-07  5.31579E-07  6.82560E-07  8.76425E-07  1.12300E-06  1.44000E-06  1.85539E-06  2.38237E-06  3.05902E-06  3.92786E-06  5.04348E-06  6.47595E-06  8.31529E-06  1.06770E-05  1.37096E-05  1.76035E-05  2.26033E-05  2.90232E-05  3.72665E-05  4.78512E-05  6.14421E-05  7.88932E-05  1.01301E-04  1.30073E-04  1.67017E-04  2.14454E-04  2.75364E-04  3.53575E-04  4.53999E-04  5.82947E-04  7.48518E-04  9.61117E-04  1.23410E-03  1.58461E-03  2.03468E-03  2.24867E-03  2.48517E-03  2.61259E-03  2.74654E-03  3.03539E-03  3.35463E-03  3.70744E-03  4.30742E-03  5.53084E-03  7.10174E-03  9.11882E-03  1.05946E-02  1.17088E-02  1.50344E-02  1.93045E-02  2.18749E-02  2.35786E-02  2.41755E-02  2.47875E-02  2.60584E-02  2.70001E-02  2.85011E-02  3.18278E-02  3.43067E-02  4.08677E-02  4.63092E-02  5.24752E-02  5.65622E-02  6.73795E-02  7.20245E-02  7.94987E-02  8.25034E-02  8.65170E-02  9.80365E-02  1.11090E-01  1.16786E-01  1.22773E-01  1.29068E-01  1.35686E-01  1.42642E-01  1.49956E-01  1.57644E-01  1.65727E-01  1.74224E-01  1.83156E-01  1.92547E-01  2.02419E-01  2.12797E-01  2.23708E-01  2.35177E-01  2.47235E-01  2.73237E-01  2.87246E-01  2.94518E-01  2.97211E-01  2.98491E-01  3.01974E-01  3.33733E-01  3.68832E-01  3.87742E-01  4.07622E-01  4.50492E-01  4.97871E-01  5.23397E-01  5.50232E-01  5.78443E-01  6.08101E-01  6.39279E-01  6.72055E-01  7.06512E-01  7.42736E-01  7.80817E-01  8.20850E-01  8.62936E-01  9.07180E-01  9.61672E-01  1.00259E+00  1.10803E+00  1.16484E+00  1.22456E+00  1.28735E+00  1.35335E+00  1.42274E+00  1.49569E+00  1.57237E+00  1.65299E+00  1.73774E+00  1.82684E+00  1.92050E+00  2.01897E+00  2.12248E+00  2.23130E+00  2.30693E+00  2.34570E+00  2.36533E+00  2.38513E+00  2.46597E+00  2.59240E+00  2.72532E+00  2.86505E+00  3.01194E+00  3.16637E+00  3.32871E+00  3.67879E+00  4.06570E+00  4.49329E+00  4.72367E+00  4.96585E+00  5.22046E+00  5.48812E+00  5.76950E+00  6.06531E+00  6.37628E+00  6.59241E+00  6.70320E+00  7.04688E+00  7.40818E+00  7.78801E+00  8.18731E+00  8.60708E+00  9.04837E+00  9.51229E+00  1.00000E+01  1.05127E+01  1.10517E+01  1.16183E+01  1.22140E+01  1.25232E+01  1.28403E+01  1.34986E+01  1.38403E+01  1.41907E+01  1.45499E+01  1.49182E+01  1.56831E+01  1.64872E+01  1.69046E+01  1.73325E+01  1.96403E+01 ];

% Sensitivity calculation energy group lethargy widths:

SENS_LETHARGY_WIDTHS = [  9.21034E+00  1.42067E+00  2.50000E-01  2.49999E-01  2.50001E-01  2.47908E-01  2.48639E-01  2.53452E-01  2.50001E-01  2.49999E-01  2.50000E-01  2.50002E-01  2.49999E-01  2.50001E-01  2.49996E-01  2.50004E-01  2.50001E-01  2.49998E-01  2.50000E-01  2.49999E-01  2.50001E-01  2.49999E-01  2.50000E-01  2.50001E-01  2.50000E-01  2.50000E-01  2.50000E-01  2.49999E-01  2.50002E-01  2.49999E-01  2.50001E-01  2.49999E-01  2.50001E-01  2.50001E-01  2.49996E-01  2.50000E-01  1.00000E-01  1.00002E-01  5.00010E-02  4.99999E-02  9.99980E-02  1.00002E-01  1.00000E-01  1.49998E-01  2.50001E-01  2.50000E-01  2.50001E-01  1.50004E-01  9.99963E-02  2.50000E-01  2.49997E-01  1.25002E-01  7.49997E-02  2.50002E-02  2.49998E-02  5.00007E-02  3.55004E-02  5.41021E-02  1.10397E-01  7.50005E-02  1.74999E-01  1.25001E-01  1.25000E-01  7.50002E-02  1.75000E-01  6.66655E-02  9.87343E-02  3.70988E-02  4.75014E-02  1.24999E-01  1.25001E-01  5.00025E-02  4.99939E-02  5.00023E-02  5.00040E-02  4.99946E-02  5.00039E-02  4.99974E-02  5.00025E-02  5.00000E-02  4.99964E-02  5.00020E-02  4.99995E-02  4.99989E-02  5.00030E-02  4.99968E-02  5.00009E-02  1.00000E-01  4.99994E-02  2.50011E-02  9.10220E-03  4.29746E-03  1.16011E-02  1.00000E-01  1.00000E-01  4.99989E-02  5.00001E-02  1.00000E-01  1.00001E-01  4.99993E-02  4.99997E-02  5.00000E-02  5.00010E-02  5.00000E-02  4.99992E-02  5.00000E-02  5.00005E-02  5.00001E-02  4.99996E-02  5.00001E-02  5.00004E-02  5.83325E-02  4.16685E-02  9.99970E-02  5.00001E-02  4.99979E-02  5.00042E-02  4.99972E-02  5.00016E-02  5.00030E-02  4.99964E-02  5.00017E-02  4.99996E-02  5.00023E-02  4.99979E-02  5.00019E-02  4.99977E-02  4.99992E-02  3.33333E-02  1.66662E-02  8.33368E-03  8.33608E-03  3.33316E-02  4.99988E-02  5.00018E-02  4.99999E-02  4.99986E-02  5.00014E-02  4.99990E-02  9.99991E-02  1.00002E-01  9.99992E-02  5.00009E-02  4.99984E-02  5.00010E-02  5.00002E-02  4.99997E-02  5.00002E-02  4.99992E-02  3.33341E-02  1.66660E-02  4.99999E-02  4.99998E-02  5.00006E-02  5.00000E-02  4.99997E-02  4.99995E-02  5.00000E-02  5.00004E-02  4.99990E-02  5.00002E-02  4.99972E-02  5.00014E-02  2.50001E-02  2.50057E-02  4.99973E-02  2.49986E-02  2.50022E-02  2.49973E-02  2.49978E-02  5.00018E-02  5.00006E-02  2.50015E-02  2.49976E-02  1.25000E-01 ];

% Sensitivities with 15 latent generations:

% Effective multiplication factor:

ADJ_PERT_KEFF_SENS = [
  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  3.59000E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -4.69400E-06 1.0E+00  1.33549E-05 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  3.42429E-06 1.0E+00 -1.44220E-06 1.0E+00  1.87892E-05 5.6E-01  9.11498E-06 1.0E+00  1.14976E-04 1.0E+00 -7.39979E-05 5.2E-01  2.94839E-05 5.3E-01  4.93940E-05 1.0E+00  8.19002E-07 1.0E+00 -1.17119E-05 1.0E+00 -1.62398E-07 1.0E+00 -1.91459E-05 1.0E+00  3.53267E-05 4.0E-01  5.84330E-05 6.7E-01  1.13868E-05 1.0E+00  9.01978E-05 5.9E-01  2.74867E-04 6.7E-01 -9.51859E-05 1.0E+00  1.82050E-04 8.9E-01  1.43431E-04 9.4E-01  1.79415E-04 7.1E-01  1.16149E-04 1.0E+00  1.09808E-03 4.3E-01 -2.43058E-04 8.4E-01  6.41973E-04 3.2E-01  2.03312E-04 8.5E-01 -4.44909E-06 1.0E+00  6.00923E-04 2.7E-01  4.40591E-04 3.8E-01  9.87611E-04 2.4E-01  6.33206E-04 7.1E-01  2.19400E-04 1.0E+00  2.30192E-03 3.7E-01  1.54006E-03 3.1E-01  2.31153E-03 2.5E-01  3.97549E-04 1.0E+00  3.74196E-03 1.4E-01  9.85087E-04 6.2E-01  2.83976E-03 3.7E-01  9.30542E-04 4.8E-01  1.45274E-03 2.6E-01  4.83560E-03 2.2E-01  6.74188E-03 1.6E-01  2.70644E-03 1.9E-01  2.70419E-03 2.9E-01  2.91525E-03 2.9E-01  2.62597E-03 2.3E-01  3.20869E-03 3.0E-01  2.71596E-03 1.8E-01  3.23811E-03 2.9E-01  4.67436E-03 2.5E-01  4.44402E-03 1.1E-01  4.21338E-03 1.9E-01  5.38405E-03 1.6E-01  5.54476E-03 9.0E-02  5.55359E-03 1.2E-01  5.90826E-03 1.5E-01  6.36304E-03 6.4E-02  6.86248E-03 1.3E-01  1.23942E-02 2.9E-02  8.08186E-03 7.9E-02  4.47209E-03 9.1E-02  1.56583E-03 1.0E-01  7.72888E-04 2.0E-01  2.00033E-03 2.2E-01  1.77367E-02 7.7E-02  1.88029E-02 6.6E-02  9.85184E-03 1.1E-01  1.10446E-02 8.3E-02  1.98337E-02 3.6E-02  2.18708E-02 5.7E-02  1.22169E-02 5.2E-02  1.06212E-02 8.0E-02  1.29217E-02 5.1E-02  1.18766E-02 5.8E-02  1.30597E-02 4.8E-02  1.25670E-02 4.4E-02  1.20066E-02 5.3E-02  1.29018E-02 4.0E-02  1.25136E-02 4.8E-02  1.43091E-02 4.2E-02  1.37072E-02 5.0E-02  1.34890E-02 6.0E-02  1.62579E-02 3.6E-02  1.17397E-02 3.7E-02  2.88266E-02 2.9E-02  1.38690E-02 3.9E-02  1.38285E-02 2.9E-02  1.51492E-02 2.7E-02  1.53819E-02 5.2E-02  1.45150E-02 3.9E-02  1.41490E-02 4.0E-02  1.52645E-02 3.3E-02  1.59265E-02 2.4E-02  1.59050E-02 1.9E-02  1.61795E-02 2.8E-02  1.59820E-02 3.7E-02  1.60270E-02 3.8E-02  1.71258E-02 2.7E-02  1.67961E-02 3.2E-02  9.70884E-03 4.5E-02  4.74475E-03 4.7E-02  2.72838E-03 7.8E-02  2.61169E-03 6.7E-02  9.98465E-03 2.3E-02  1.51040E-02 2.1E-02  1.50655E-02 4.0E-02  1.42426E-02 2.5E-02  1.46177E-02 3.2E-02  1.36431E-02 2.9E-02  1.31079E-02 3.3E-02  2.41536E-02 2.3E-02  2.23004E-02 1.9E-02  1.89855E-02 2.7E-02  8.35165E-03 3.6E-02  8.18079E-03 4.1E-02  6.60175E-03 4.0E-02  6.02705E-03 5.9E-02  5.55651E-03 2.6E-02  5.17782E-03 5.6E-02  4.71330E-03 6.4E-02  2.87722E-03 9.8E-02  1.29558E-03 6.6E-02  3.68042E-03 4.4E-02  3.08565E-03 5.1E-02  2.58951E-03 8.3E-02  1.93749E-03 8.9E-02  1.77253E-03 6.9E-02  1.46137E-03 9.5E-02  1.28236E-03 9.7E-02  8.27458E-04 1.2E-01  5.85933E-04 1.9E-01  4.50926E-04 1.1E-01  2.63853E-04 2.1E-01  3.49503E-04 1.8E-01  9.76657E-05 4.1E-01  9.36234E-05 2.4E-01  6.31322E-05 4.7E-01  5.75666E-05 4.8E-01  4.25494E-05 4.3E-01  2.98380E-05 7.5E-01  2.82408E-05 3.3E-01  5.46864E-05 3.8E-01  3.05985E-05 7.6E-01 -4.89605E-06 1.0E+00  9.33234E-06 8.4E-01  3.03028E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  1.79500E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -2.34700E-06 1.0E+00  6.67744E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -2.88440E-06 1.0E+00  1.06378E-05 6.7E-01  1.93284E-06 1.0E+00  1.08441E-04 1.0E+00 -8.50181E-05 5.9E-01  1.97277E-05 4.2E-01  4.70241E-05 9.3E-01  7.30553E-06 1.0E+00 -7.09763E-06 1.0E+00 -1.70971E-06 1.0E+00 -1.35298E-05 1.0E+00  3.90867E-05 4.2E-01  4.49086E-05 7.6E-01  1.51871E-05 1.0E+00  8.12791E-05 6.6E-01  2.13704E-04 7.6E-01 -9.61845E-05 1.0E+00  9.19356E-05 1.0E+00  1.83541E-04 5.9E-01  1.00339E-04 1.0E+00 -3.10374E-05 1.0E+00  7.22840E-04 6.3E-01 -3.88078E-04 4.2E-01  5.27167E-04 3.9E-01  1.03507E-04 1.0E+00  9.56426E-06 1.0E+00  4.48656E-04 3.6E-01  1.74680E-04 9.0E-01  8.71336E-04 2.8E-01  3.05942E-04 1.0E+00 -2.59790E-04 1.0E+00  1.33015E-03 6.0E-01  6.00919E-04 7.3E-01  1.38386E-03 3.8E-01 -2.03003E-04 1.0E+00  1.57173E-03 3.3E-01  2.22330E-04 1.0E+00  9.85781E-04 9.1E-01  3.50232E-04 1.0E+00  4.10554E-04 7.7E-01  1.55602E-03 6.6E-01  2.94574E-03 3.3E-01  1.45422E-03 4.2E-01  6.31570E-04 1.0E+00  1.17347E-03 6.9E-01  8.10214E-04 6.4E-01  1.36898E-03 6.7E-01 -1.32396E-05 1.0E+00  8.68004E-04 8.5E-01  1.66413E-03 6.4E-01  1.80700E-03 2.8E-01  1.11455E-03 7.1E-01  2.23737E-03 3.3E-01  2.52480E-03 2.1E-01  2.23423E-03 2.6E-01  2.14080E-03 4.3E-01  2.49563E-03 1.3E-01  3.02290E-03 2.9E-01  3.23285E-03 1.8E-01  3.51663E-03 2.2E-01  1.76010E-03 2.1E-01  4.35803E-04 4.4E-01  2.61065E-04 7.1E-01  6.23119E-04 6.2E-01  5.91295E-03 1.5E-01  5.88239E-03 1.5E-01  3.15653E-03 3.0E-01  3.41680E-03 2.6E-01  4.84266E-03 1.5E-01  6.29902E-03 1.4E-01  3.56588E-03 1.4E-01  2.12312E-03 3.1E-01  4.00919E-03 1.2E-01  2.49821E-03 2.2E-01  3.36424E-03 1.6E-01  3.21734E-03 1.2E-01  2.62831E-03 1.9E-01  3.11479E-03 2.0E-01  2.87249E-03 1.8E-01  3.51316E-03 1.5E-01  2.98177E-03 1.9E-01  2.55318E-03 2.4E-01  3.20663E-03 1.8E-01  2.39459E-03 1.4E-01  4.68561E-03 1.0E-01  2.00758E-03 1.7E-01  1.54135E-03 2.3E-01  2.31480E-03 1.2E-01  2.24430E-03 2.2E-01  1.32591E-03 3.2E-01  6.59322E-04 4.7E-01  1.25379E-03 2.6E-01  1.47005E-03 1.8E-01  1.26642E-03 2.3E-01  1.33597E-03 3.1E-01  1.06700E-03 4.3E-01  7.79395E-04 3.5E-01  1.72094E-03 2.0E-01  1.98636E-03 1.8E-01  3.14689E-04 1.0E+00  1.85592E-04 1.0E+00  1.10341E-04 1.0E+00  1.25849E-04 1.0E+00  5.12730E-04 4.2E-01  5.75887E-04 4.4E-01  8.67288E-04 5.5E-01  3.80558E-04 8.6E-01  1.18198E-03 2.5E-01  8.29087E-04 2.7E-01  6.66477E-04 4.4E-01  3.55972E-04 1.0E+00  1.50197E-03 3.2E-01  6.38494E-04 4.7E-01  1.14659E-05 1.0E+00  6.21337E-04 4.4E-01 -1.29042E-05 1.0E+00  1.22984E-04 1.0E+00  2.36614E-04 4.5E-01  3.18226E-04 7.8E-01  3.29840E-04 6.9E-01  1.34206E-04 1.0E+00 -3.64294E-05 1.0E+00  8.97482E-05 1.0E+00  1.88781E-04 5.6E-01  9.39562E-06 1.0E+00 -8.02863E-05 1.0E+00  1.39730E-04 6.9E-01  1.72948E-04 4.8E-01  1.70884E-04 4.1E-01  1.56171E-04 4.9E-01 -5.45508E-05 1.0E+00 -1.31659E-05 1.0E+00 -4.32490E-05 6.5E-01  6.33316E-05 8.5E-01 -5.67124E-07 1.0E+00  1.17625E-05 1.0E+00 -2.05383E-05 1.0E+00  2.79398E-05 1.0E+00 -1.66787E-05 1.0E+00 -1.43824E-05 7.2E-01  4.25030E-06 1.0E+00  2.17462E-05 6.6E-01  1.57155E-05 7.6E-01 -3.67953E-06 1.0E+00  5.24462E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  3.27031E-06 1.0E+00 -8.06777E-06 1.0E+00  1.24231E-05 6.2E-01  2.30240E-05 5.0E-01 -3.15357E-05 8.4E-01  3.02315E-05 7.7E-01 -1.28454E-05 1.0E+00  3.44059E-05 3.1E-01  1.55282E-05 6.6E-01 -1.44346E-05 1.0E+00  1.07860E-05 9.5E-01 -1.15514E-05 9.2E-01 -1.43168E-05 1.0E+00  2.06544E-05 1.0E+00  2.21257E-05 1.0E+00  1.15185E-04 3.2E-01 -1.73181E-04 3.4E-01 -1.44801E-04 6.8E-01 -2.53731E-04 5.1E-01 -3.38376E-04 3.3E-01 -1.05963E-04 1.0E+00 -1.38271E-04 5.4E-01  5.93151E-05 1.0E+00  5.59334E-05 1.0E+00 -1.94873E-04 8.3E-01 -2.87050E-04 3.5E-01  9.84302E-05 1.0E+00 -3.31945E-04 5.2E-01 -5.92045E-05 1.0E+00 -2.00744E-04 5.8E-01  4.02730E-04 4.2E-01  4.58218E-05 1.0E+00  1.31903E-04 1.0E+00  1.22619E-04 1.0E+00  1.22890E-04 1.0E+00  4.25712E-04 4.7E-01  1.21747E-04 1.0E+00 -4.33562E-05 1.0E+00  3.66322E-04 6.8E-01  8.99034E-05 1.0E+00  2.22464E-04 9.7E-01  9.06335E-04 3.0E-01  3.39024E-04 7.6E-01  5.51986E-04 4.2E-01  1.96166E-04 5.8E-01  2.09536E-04 4.5E-01  2.27400E-04 8.2E-01  2.12564E-03 2.1E-01  2.18547E-03 2.0E-01  7.90043E-04 4.5E-01  1.45422E-03 3.4E-01  2.81099E-03 1.4E-01  2.48793E-03 2.6E-01  1.79992E-03 2.5E-01  1.43604E-03 1.8E-01  1.67199E-03 2.3E-01  1.78894E-03 2.4E-01  2.01841E-03 1.2E-01  1.12795E-03 1.9E-01  1.20179E-03 2.6E-01  1.65416E-03 1.9E-01  1.03678E-03 2.5E-01  1.94923E-03 1.6E-01  1.95245E-03 1.3E-01  1.99797E-03 1.7E-01  2.01610E-03 1.0E-01  1.53739E-03 2.1E-01  4.60919E-03 8.7E-02  2.29468E-03 2.0E-01  2.20185E-03 7.8E-02  2.21278E-03 9.6E-02  2.02480E-03 1.8E-01  1.97834E-03 1.2E-01  1.45415E-03 9.4E-02  1.44275E-03 2.1E-01  1.17765E-03 2.3E-01  1.29560E-03 2.7E-01  1.60999E-03 1.6E-01  8.74592E-04 3.7E-01  9.44603E-04 3.1E-01  1.50837E-03 1.8E-01  8.91079E-04 2.5E-01  5.15314E-04 4.4E-01  1.74726E-04 8.4E-01  3.15962E-04 2.8E-01  1.72515E-04 5.8E-01  6.42029E-04 4.0E-01  1.44975E-03 1.2E-01  1.15728E-03 2.4E-01  1.02954E-03 1.2E-01  1.16629E-03 2.4E-01  7.88976E-04 2.7E-01  1.29190E-03 1.9E-01  2.41739E-03 1.6E-01  1.70332E-03 1.0E-01  1.20570E-03 3.0E-01  1.03380E-03 1.7E-01  4.35004E-04 3.0E-01  6.99732E-04 2.5E-01  5.67203E-04 2.5E-01  3.64239E-04 5.0E-01  1.99393E-04 5.6E-01  2.01996E-04 5.1E-01  3.50780E-05 1.0E+00  1.86770E-04 4.0E-01 -4.76700E-05 1.0E+00  6.63101E-05 1.0E+00 -1.25101E-04 7.6E-01 -6.05936E-05 1.0E+00 -4.61936E-05 1.0E+00  1.45197E-05 1.0E+00  7.54496E-05 3.2E-01 -9.65552E-05 5.1E-01 -1.05947E-05 1.0E+00  1.55687E-06 1.0E+00 -4.64460E-06 1.0E+00  1.88452E-05 7.8E-01  5.03657E-06 1.0E+00  5.49427E-06 1.0E+00 -5.19922E-06 1.0E+00 -2.05407E-06 1.0E+00  9.90570E-06 7.5E-01 -4.22357E-06 6.7E-01 -4.57162E-06 9.3E-01 -2.46580E-06 1.0E+00 -6.76977E-06 1.0E+00 -3.67953E-06 1.0E+00  1.46541E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -4.69400E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -4.52969E-06 6.9E-01  0.00000E+00 0.0E+00 -7.01197E-06 6.7E-01 -9.06219E-07 1.0E+00 -1.92523E-05 3.9E-01 -1.15111E-05 4.9E-01 -7.15998E-06 3.2E-01 -6.30342E-06 4.7E-01 -1.39430E-05 7.2E-01 -1.06991E-05 5.9E-01 -1.05122E-05 5.3E-01 -2.63479E-05 5.1E-01 -5.25747E-05 3.0E-01 -7.05534E-05 2.3E-01 -1.24189E-04 1.5E-01 -1.57456E-04 1.4E-01 -1.88759E-04 1.6E-01 -1.70649E-04 1.7E-01 -4.03224E-04 1.6E-01 -5.50783E-04 8.8E-02 -5.12566E-04 9.4E-02 -3.30227E-04 8.1E-02 -1.20299E-04 1.3E-01 -1.57012E-04 1.3E-01 -2.00154E-04 1.2E-01 -1.60502E-04 1.8E-01 -3.21439E-04 1.6E-01 -6.56807E-04 1.0E-01 -5.53612E-04 1.1E-01 -1.53079E-03 5.0E-02 -1.21281E-03 6.7E-02 -1.25657E-03 9.3E-02 -9.10314E-04 8.8E-02 -1.93736E-03 5.1E-02 -7.44519E-04 8.6E-02 -1.12014E-03 6.2E-02 -4.20332E-04 1.1E-01 -6.52260E-04 8.6E-02 -1.56650E-03 7.6E-02 -1.72903E-03 3.8E-02 -8.09946E-04 1.0E-01 -6.92228E-04 8.9E-02 -7.11867E-04 8.4E-02 -7.93699E-04 6.0E-02 -8.28115E-04 6.6E-02 -7.90645E-04 5.4E-02 -7.72456E-04 7.9E-02 -7.56083E-04 9.5E-02 -7.82036E-04 4.3E-02 -8.60773E-04 6.6E-02 -8.14409E-04 6.7E-02 -7.44268E-04 6.5E-02 -8.38180E-04 9.7E-02 -8.60546E-04 9.5E-02 -8.00866E-04 5.9E-02 -8.21319E-04 4.5E-02 -1.61221E-03 5.4E-02 -9.24190E-04 7.8E-02 -5.18174E-04 8.4E-02 -1.68947E-04 2.6E-01 -7.92883E-05 2.5E-01 -1.72447E-04 1.6E-01 -1.86488E-03 5.6E-02 -1.80548E-03 4.9E-02 -7.89854E-04 5.6E-02 -8.23855E-04 8.6E-02 -1.81406E-03 5.0E-02 -1.66364E-03 2.6E-02 -7.25465E-04 7.7E-02 -6.90973E-04 8.3E-02 -7.52808E-04 8.7E-02 -6.81935E-04 4.5E-02 -6.92542E-04 3.7E-02 -6.77454E-04 4.6E-02 -6.21975E-04 8.9E-02 -5.45247E-04 6.1E-02 -5.35962E-04 9.1E-02 -3.62072E-04 1.0E-01 -4.37852E-04 1.0E-01 -4.83221E-04 1.4E-01 -4.77488E-04 1.1E-01 -3.49149E-04 1.2E-01 -6.37785E-04 9.7E-02 -2.40769E-04 1.7E-01 -1.78586E-04 2.0E-01 -2.36124E-04 1.5E-01 -1.88542E-04 7.7E-02 -2.24452E-04 1.4E-01 -1.68281E-04 1.3E-01 -1.82653E-04 2.2E-01 -1.62322E-04 1.5E-01 -1.06987E-04 2.3E-01 -1.11815E-04 2.2E-01 -6.75695E-05 2.0E-01 -9.45130E-05 2.7E-01 -1.04736E-04 2.1E-01 -6.38683E-05 2.0E-01 -5.58056E-05 1.6E-01 -2.80203E-05 3.3E-01 -1.60996E-05 5.9E-01 -1.57073E-05 2.8E-01 -4.47320E-05 3.3E-01 -4.14520E-05 2.8E-01 -4.05097E-05 3.0E-01 -2.36682E-05 4.1E-01 -2.94808E-05 3.0E-01 -1.82089E-05 5.4E-01 -1.67949E-05 4.8E-01 -3.06939E-05 2.7E-01 -1.92887E-05 5.0E-01 -4.83112E-06 5.6E-01  0.00000E+00 0.0E+00 -1.04144E-05 8.0E-01 -6.07998E-07 6.7E-01  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -4.86843E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -1.81641E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -5.08579E-06 6.8E-01  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -1.18209E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -5.79092E-07 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  1.79500E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  2.34700E-06 1.0E+00  6.67744E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  3.42429E-06 1.0E+00  1.44220E-06 1.0E+00  8.15141E-06 8.3E-01  1.17118E-05 6.3E-01  6.53501E-06 6.0E-01  1.80322E-05 6.9E-01  1.06624E-05 7.5E-01  2.16221E-05 5.9E-01  5.02454E-06 5.6E-01  2.54572E-06 1.0E+00  7.85073E-06 4.0E-01  8.32687E-06 1.0E+00  6.93908E-06 6.1E-01  2.40366E-05 3.1E-01  2.25475E-05 3.5E-01  6.14934E-05 2.8E-01  1.31716E-04 2.0E-01  1.25188E-04 1.8E-01  2.44300E-04 2.6E-01  1.56716E-04 2.1E-01  2.37302E-04 1.5E-01  5.27386E-04 9.3E-02  9.57554E-04 7.8E-02  6.27354E-04 8.3E-02  4.57878E-04 1.5E-01  1.85699E-04 2.3E-01  1.27470E-04 2.9E-01  3.66856E-04 1.5E-01  4.15627E-04 1.2E-01  4.49266E-04 1.5E-01  9.98389E-04 9.6E-02  1.01215E-03 7.5E-02  2.48044E-03 6.1E-02  2.03677E-03 8.2E-02  2.35742E-03 4.4E-02  1.65567E-03 4.5E-02  4.36133E-03 3.7E-02  1.84565E-03 5.6E-02  3.08008E-03 3.2E-02  1.13891E-03 5.6E-02  1.63513E-03 6.1E-02  4.79015E-03 3.9E-02  5.72004E-03 2.5E-02  2.34921E-03 5.0E-02  2.66642E-03 4.4E-02  2.78559E-03 4.9E-02  2.66866E-03 4.1E-02  2.86857E-03 7.0E-02  3.11711E-03 4.0E-02  3.09674E-03 4.2E-02  3.63440E-03 5.6E-02  3.29644E-03 3.5E-02  3.83671E-03 2.9E-02  3.53538E-03 4.3E-02  3.64249E-03 4.0E-02  4.20089E-03 3.2E-02  4.26169E-03 2.0E-02  4.57837E-03 4.4E-02  4.43843E-03 4.3E-02  9.86720E-03 3.2E-02  5.15039E-03 2.9E-02  2.67817E-03 4.6E-02  1.10280E-03 7.4E-02  3.81575E-04 1.3E-01  1.32226E-03 8.0E-02  1.15630E-02 2.5E-02  1.25405E-02 2.2E-02  6.69513E-03 3.5E-02  6.99742E-03 2.0E-02  1.39941E-02 1.8E-02  1.47475E-02 1.8E-02  7.57652E-03 2.3E-02  7.75306E-03 2.5E-02  7.99332E-03 2.6E-02  8.27142E-03 2.2E-02  8.36961E-03 2.3E-02  8.89919E-03 2.0E-02  8.79847E-03 2.2E-02  8.67815E-03 2.5E-02  9.14032E-03 1.8E-02  9.20878E-03 1.6E-02  9.21084E-03 2.0E-02  9.42103E-03 2.7E-02  1.15127E-02 2.6E-02  8.15683E-03 4.0E-02  2.01696E-02 1.5E-02  9.80750E-03 2.9E-02  1.02639E-02 2.1E-02  1.08577E-02 2.3E-02  1.13014E-02 2.8E-02  1.14352E-02 1.9E-02  1.22039E-02 3.4E-02  1.27506E-02 2.7E-02  1.34411E-02 1.9E-02  1.34500E-02 2.1E-02  1.33454E-02 1.6E-02  1.41080E-02 2.3E-02  1.43975E-02 2.3E-02  1.40012E-02 2.1E-02  1.39825E-02 2.5E-02  8.93464E-03 2.0E-02  4.41245E-03 3.2E-02  2.31817E-03 3.8E-02  2.32904E-03 4.7E-02  8.87463E-03 1.6E-02  1.31198E-02 2.2E-02  1.30815E-02 1.9E-02  1.28561E-02 2.5E-02  1.22989E-02 2.2E-02  1.20432E-02 1.9E-02  1.11663E-02 2.7E-02  2.14109E-02 1.1E-02  1.91144E-02 1.2E-02  1.71461E-02 1.3E-02  7.30639E-03 1.0E-02  7.13486E-03 2.7E-02  5.91553E-03 4.8E-02  5.33686E-03 3.1E-02  4.95566E-03 2.5E-02  4.66020E-03 3.0E-02  4.18146E-03 5.1E-02  2.70794E-03 8.4E-02  1.14524E-03 5.9E-02  3.64321E-03 5.1E-02  2.83056E-03 4.4E-02  2.70522E-03 4.3E-02  2.08019E-03 4.9E-02  1.67899E-03 5.3E-02  1.27390E-03 7.4E-02  1.03603E-03 8.0E-02  7.72927E-04 7.9E-02  6.51079E-04 9.6E-02  4.62535E-04 1.0E-01  3.12928E-04 1.3E-01  2.67326E-04 8.4E-02  9.31962E-05 3.1E-01  7.63666E-05 2.2E-01  8.94488E-05 1.7E-01  3.16809E-05 5.8E-01  4.93224E-05 2.7E-01  4.84440E-05 3.8E-01  2.85622E-05 2.9E-01  3.54060E-05 3.1E-01  2.16528E-05 8.5E-01  2.46302E-06 7.7E-01  2.62231E-06 1.0E+00  3.03028E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  7.54043E-06 1.0E+00  1.09735E-05 7.4E-01  6.09110E-05 3.6E-01  5.28183E-05 2.4E-01  3.34946E-06 1.0E+00  1.30332E-04 4.1E-01  8.92544E-05 4.7E-01  9.77946E-05 5.9E-01  1.35233E-04 5.2E-01  1.17425E-04 3.7E-01  1.40456E-04 2.9E-01  6.19925E-05 5.8E-01  6.82098E-05 5.5E-01  4.27202E-05 9.6E-01  5.83838E-05 6.4E-01 -1.69372E-05 1.0E+00  3.61320E-05 5.4E-01 -2.13643E-05 6.3E-01 -4.21234E-07 1.0E+00  4.71304E-06 1.0E+00  6.63371E-06 1.0E+00  9.42039E-06 9.9E-01 -2.14145E-06 1.0E+00  0.00000E+00 0.0E+00  7.36343E-06 8.3E-01  8.49725E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  6.23418E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  1.44220E-06 1.0E+00 -6.16234E-06 1.0E+00  1.04167E-04 1.0E+00 -4.26100E-05 6.2E-01  7.01874E-06 1.0E+00  2.58781E-05 1.0E+00  3.02772E-06 1.0E+00 -1.34174E-05 1.0E+00  2.48333E-06 1.0E+00 -2.09719E-05 7.9E-01  3.35286E-05 4.9E-01  1.85666E-05 1.0E+00 -5.52223E-06 1.0E+00  5.40760E-05 7.4E-01  1.55504E-04 9.1E-01 -3.17216E-04 5.0E-01 -2.92804E-05 1.0E+00 -2.02796E-05 1.0E+00 -1.16687E-05 1.0E+00 -3.01135E-04 4.8E-01  2.91539E-04 1.0E+00 -6.40137E-04 1.9E-01  2.58883E-04 7.3E-01 -4.65788E-06 1.0E+00  1.74498E-06 1.0E+00  1.63565E-04 7.2E-01  2.88568E-05 1.0E+00  4.54818E-04 4.1E-01 -2.43339E-04 1.0E+00 -3.89188E-04 8.1E-01 -2.18220E-04 1.0E+00 -2.15343E-04 1.0E+00  8.51484E-05 1.0E+00 -8.73487E-04 7.1E-01  3.38909E-04 1.0E+00 -4.16102E-04 1.0E+00  2.05878E-04 1.0E+00 -3.17103E-04 1.0E+00 -3.67759E-08 1.0E+00  4.77172E-05 1.0E+00  1.46819E-03 6.6E-01  5.99508E-04 8.6E-01  2.18774E-05 1.0E+00  3.47444E-04 1.0E+00  1.70841E-04 1.0E+00  7.06462E-04 1.0E+00 -3.99635E-04 1.0E+00  4.44980E-04 1.0E+00  9.16856E-04 1.0E+00  1.14580E-03 3.4E-01  6.61460E-04 1.0E+00  2.20588E-03 3.4E-01  1.75591E-03 2.5E-01  1.19953E-03 5.1E-01  1.64009E-03 5.0E-01  1.47767E-03 1.4E-01  1.76071E-03 4.3E-01  2.74479E-03 2.4E-01  2.97427E-03 1.4E-01  1.68200E-03 2.1E-01  4.60502E-04 3.5E-01  2.92162E-04 7.5E-01  6.94691E-04 4.9E-01  6.58566E-03 1.7E-01  5.47513E-03 2.1E-01  2.91067E-03 2.8E-01  3.31723E-03 1.8E-01  5.06661E-03 1.3E-01  5.96738E-03 1.8E-01  4.56182E-03 1.5E-01  2.48481E-03 3.0E-01  4.16016E-03 2.1E-01  3.18421E-03 1.5E-01  3.71542E-03 1.2E-01  3.33459E-03 1.6E-01  2.99458E-03 1.3E-01  3.53491E-03 1.3E-01  3.44927E-03 1.7E-01  4.46865E-03 9.5E-02  3.92381E-03 1.7E-01  3.34142E-03 1.8E-01  3.90436E-03 9.6E-02  2.94564E-03 1.6E-01  6.97906E-03 6.3E-02  3.20435E-03 1.4E-01  2.94969E-03 7.2E-02  3.09200E-03 1.0E-01  3.31640E-03 1.3E-01  3.30428E-03 9.2E-02  3.30723E-03 7.2E-02  3.32138E-03 1.0E-01  3.68170E-03 5.7E-02  4.01077E-03 6.7E-02  3.83024E-03 8.1E-02  3.66378E-03 1.1E-01  3.50797E-03 7.6E-02  3.85497E-03 4.4E-02  3.86576E-03 5.9E-02  2.10431E-03 7.3E-02  1.09082E-03 1.8E-01  6.47107E-04 1.6E-01  5.25154E-04 2.6E-01  2.32452E-03 1.1E-01  4.00294E-03 5.4E-02  3.57857E-03 9.9E-02  3.37152E-03 9.0E-02  3.55947E-03 8.7E-02  3.19926E-03 7.5E-02  3.12550E-03 1.1E-01  5.34494E-03 6.8E-02  5.23522E-03 8.7E-02  4.62884E-03 7.7E-02  2.08513E-03 6.9E-02  1.90566E-03 1.1E-01  1.60731E-03 1.4E-01  1.29945E-03 1.6E-01  1.38634E-03 7.3E-02  1.08946E-03 1.0E-01  1.22154E-03 1.3E-01  9.18171E-04 1.1E-01  4.63964E-04 1.7E-01  9.74272E-04 8.3E-02  8.55457E-04 2.0E-01  7.42656E-04 1.5E-01  4.49412E-04 3.0E-01  3.33947E-04 2.6E-01  4.08936E-04 9.6E-02  3.87142E-04 1.8E-01  2.20970E-04 3.3E-01  1.08154E-04 4.3E-01  1.64229E-04 1.5E-01  3.94953E-05 8.9E-01  8.26521E-05 3.6E-01  1.28794E-05 8.3E-01  1.51148E-05 8.9E-01  3.66673E-05 4.8E-01  3.02301E-05 7.7E-01  2.07590E-05 7.9E-01  1.14560E-05 1.0E+00  2.83191E-07 1.0E+00  1.82870E-05 1.0E+00  6.03568E-07 1.0E+00  0.00000E+00 0.0E+00  1.46541E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  1.44220E-06 1.0E+00 -4.37960E-06 1.0E+00  1.04167E-04 1.0E+00 -4.26100E-05 6.2E-01  7.01874E-06 1.0E+00  3.12531E-05 1.0E+00  8.63217E-06 5.9E-01 -1.16332E-05 1.0E+00  4.86683E-06 5.0E-01 -2.09719E-05 7.9E-01  4.07008E-05 4.3E-01  1.85666E-05 1.0E+00  8.37639E-06 1.0E+00  8.60617E-05 5.5E-01  1.98632E-04 7.4E-01 -2.31579E-04 6.6E-01  4.71358E-05 1.0E+00  9.82831E-05 1.0E+00  1.29249E-04 9.7E-01 -1.74875E-05 1.0E+00  6.71124E-04 5.0E-01 -2.88792E-04 4.0E-01  4.85538E-04 3.7E-01  8.56569E-05 1.0E+00  1.21217E-04 1.0E+00  3.20858E-04 3.3E-01  1.35630E-04 9.7E-01  6.81851E-04 2.6E-01  2.54574E-04 1.0E+00  6.53224E-05 1.0E+00  9.33441E-04 8.5E-01  7.60277E-04 6.6E-01  1.12624E-03 5.7E-01 -3.90080E-05 1.0E+00  2.10032E-03 2.7E-01  3.84183E-04 1.0E+00  1.18686E-03 5.0E-01  4.92644E-05 1.0E+00  4.80020E-04 6.5E-01  1.16594E-03 7.7E-01  3.18130E-03 2.8E-01  1.42800E-03 3.7E-01  4.55403E-04 1.0E+00  1.18513E-03 5.9E-01  9.23303E-04 5.9E-01  1.47460E-03 5.9E-01 -1.41801E-04 1.0E+00  7.97885E-04 8.0E-01  1.39821E-03 6.9E-01  1.47803E-03 2.7E-01  1.16557E-03 6.9E-01  2.58286E-03 2.7E-01  2.04363E-03 2.2E-01  1.70466E-03 3.2E-01  1.90050E-03 4.0E-01  1.95919E-03 1.3E-01  2.21265E-03 3.2E-01  3.06138E-03 2.2E-01  3.26447E-03 1.7E-01  1.51094E-03 2.1E-01  3.86348E-04 4.3E-01  2.45655E-04 8.7E-01  6.63424E-04 4.9E-01  5.66046E-03 1.4E-01  4.98851E-03 1.7E-01  2.69603E-03 2.6E-01  2.95944E-03 2.0E-01  4.28738E-03 1.8E-01  5.06473E-03 1.2E-01  3.52615E-03 1.7E-01  1.81857E-03 3.3E-01  3.27474E-03 1.9E-01  2.22175E-03 1.8E-01  2.40505E-03 1.6E-01  2.73109E-03 1.5E-01  2.36411E-03 1.5E-01  2.39223E-03 2.2E-01  2.76399E-03 1.6E-01  2.96525E-03 1.2E-01  2.45003E-03 1.9E-01  1.99458E-03 2.9E-01  2.57935E-03 1.8E-01  1.83030E-03 1.6E-01  3.47124E-03 1.2E-01  1.45767E-03 1.7E-01  1.18293E-03 2.2E-01  1.26182E-03 1.5E-01  1.46829E-03 2.1E-01  7.92694E-04 2.9E-01  8.72202E-04 2.6E-01  6.64986E-04 4.1E-01  8.74680E-04 2.2E-01  8.80226E-04 2.2E-01  7.74083E-04 2.9E-01  8.22899E-04 3.4E-01  4.69044E-04 4.0E-01  9.29658E-04 1.9E-01  1.08117E-03 1.4E-01  2.51189E-04 7.5E-01  2.74303E-04 6.1E-01  3.77127E-05 1.0E+00 -6.95898E-06 1.0E+00  4.54954E-04 2.6E-01  7.57865E-04 1.6E-01  5.16430E-04 4.5E-01  4.77585E-04 3.7E-01  6.83388E-04 3.0E-01  5.58123E-04 3.0E-01  3.84944E-04 5.7E-01  2.67153E-04 1.0E+00  9.08975E-04 3.3E-01  6.74492E-04 3.3E-01  1.95596E-04 6.0E-01  2.68657E-04 6.5E-01  2.01398E-04 6.8E-01 -5.49210E-05 1.0E+00  1.24770E-04 8.6E-01  7.70679E-05 1.0E+00  1.74629E-04 4.9E-01  1.34396E-04 5.6E-01  3.73893E-05 1.0E+00  7.76741E-05 1.0E+00  8.96156E-05 1.0E+00  1.32196E-04 5.9E-01  2.50237E-05 1.0E+00  2.98084E-05 1.0E+00  7.56257E-05 5.8E-01  4.07683E-05 9.3E-01  1.02634E-04 5.2E-01 -2.30004E-05 1.0E+00  2.24658E-05 1.0E+00  1.22708E-06 1.0E+00  3.13684E-05 1.0E+00 -1.29776E-05 7.4E-01  1.16171E-05 1.0E+00  8.31631E-06 1.0E+00  3.02242E-05 1.0E+00 -9.03805E-06 1.0E+00 -6.37915E-07 1.0E+00  2.14422E-06 1.0E+00  1.07708E-05 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  1.17164E-05 1.0E+00 -8.70313E-05 6.1E-01 -1.13510E-04 6.8E-01 -2.24212E-04 4.6E-01 -2.34235E-04 3.8E-01 -1.12713E-04 1.0E+00 -2.59206E-05 1.0E+00  4.77844E-05 1.0E+00  1.69695E-05 1.0E+00 -3.73029E-04 3.9E-01 -2.63750E-04 4.2E-01  8.66025E-05 1.0E+00 -3.04432E-04 5.3E-01 -1.73824E-04 1.0E+00 -1.59682E-04 7.2E-01  3.41452E-04 3.7E-01  1.80144E-04 8.0E-01  9.38810E-05 1.0E+00  1.92985E-04 8.7E-01  7.36048E-05 1.0E+00  2.06645E-04 8.5E-01  2.05767E-04 9.6E-01  1.15282E-04 1.0E+00  3.65575E-04 6.1E-01  5.46850E-05 1.0E+00  1.42557E-04 1.0E+00  7.34930E-04 3.9E-01  3.88649E-04 6.7E-01  5.35064E-04 3.5E-01  2.08963E-04 4.6E-01  1.02121E-04 7.5E-01  1.60025E-04 8.8E-01  2.14709E-03 1.7E-01  1.80113E-03 2.3E-01  8.17456E-04 2.9E-01  9.77526E-04 4.0E-01  2.07508E-03 1.6E-01  2.14382E-03 2.8E-01  1.58050E-03 2.4E-01  1.18028E-03 2.1E-01  1.48456E-03 2.4E-01  1.50644E-03 2.3E-01  1.82928E-03 9.3E-02  1.05222E-03 2.0E-01  1.11607E-03 2.2E-01  1.49471E-03 1.8E-01  1.09055E-03 1.7E-01  1.78079E-03 1.3E-01  1.78312E-03 1.6E-01  1.68094E-03 1.6E-01  1.62204E-03 1.3E-01  1.31540E-03 1.9E-01  3.76346E-03 1.0E-01  1.80158E-03 1.2E-01  1.72152E-03 1.1E-01  1.83909E-03 1.0E-01  1.54299E-03 1.9E-01  1.84913E-03 1.4E-01  1.19310E-03 1.1E-01  1.30551E-03 1.3E-01  1.07152E-03 1.7E-01  1.32546E-03 2.0E-01  1.08346E-03 1.3E-01  7.36015E-04 2.4E-01  8.25997E-04 1.7E-01  1.08168E-03 1.0E-01  8.45893E-04 2.1E-01  5.58909E-04 1.6E-01  2.14091E-04 6.9E-01  2.94246E-04 3.1E-01  1.55061E-04 3.8E-01  5.34922E-04 3.7E-01  1.30233E-03 1.3E-01  1.05233E-03 1.8E-01  7.87625E-04 1.4E-01  9.28066E-04 2.0E-01  8.75977E-04 1.6E-01  1.02975E-03 2.1E-01  1.83567E-03 1.3E-01  1.30607E-03 1.7E-01  9.45366E-04 2.4E-01  6.01718E-04 2.2E-01  3.99413E-04 2.0E-01  4.35099E-04 2.4E-01  4.23242E-04 2.0E-01  3.55279E-04 2.7E-01  1.17214E-04 9.1E-01  9.58977E-05 6.8E-01  1.27345E-04 2.8E-01  1.53595E-04 3.0E-01  6.38279E-05 6.8E-01  3.43156E-05 1.0E+00  1.10656E-05 1.0E+00 -5.49050E-06 1.0E+00 -2.54595E-05 7.9E-01  3.50604E-05 6.0E-01  4.00166E-05 5.5E-01 -7.50173E-05 3.7E-01 -2.74310E-05 6.7E-01  4.46429E-06 1.0E+00 -1.42707E-05 8.3E-01  8.06854E-06 1.0E+00  9.90979E-06 6.5E-01  4.92354E-06 1.0E+00 -8.43475E-06 1.0E+00  3.06656E-06 6.8E-01  7.25885E-06 1.0E+00 -1.81623E-06 1.0E+00 -2.14422E-06 1.0E+00  4.33999E-08 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  1.46541E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -1.78275E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -5.37495E-06 5.3E-01 -5.60445E-06 7.0E-01 -1.78427E-06 7.1E-01 -2.38350E-06 1.0E+00  0.00000E+00 0.0E+00 -7.17219E-06 8.3E-01  0.00000E+00 0.0E+00 -1.38986E-05 5.8E-01 -3.19857E-05 4.7E-01 -4.31280E-05 2.5E-01 -8.56374E-05 2.4E-01 -7.64162E-05 2.6E-01 -1.18563E-04 1.8E-01 -1.40917E-04 1.5E-01 -2.83648E-04 2.0E-01 -3.79585E-04 1.2E-01 -3.51345E-04 1.1E-01 -2.26655E-04 1.3E-01 -9.03148E-05 1.3E-01 -1.19472E-04 1.9E-01 -1.57294E-04 1.3E-01 -1.06773E-04 1.6E-01 -2.30041E-04 1.7E-01 -4.97913E-04 1.0E-01 -4.54810E-04 1.2E-01 -1.15166E-03 6.5E-02 -9.87336E-04 8.3E-02 -9.60707E-04 1.1E-01 -7.20968E-04 9.7E-02 -1.53720E-03 6.2E-02 -5.66050E-04 8.2E-02 -8.68871E-04 6.3E-02 -3.40447E-04 1.3E-01 -5.27841E-04 9.5E-02 -1.13175E-03 5.9E-02 -1.34009E-03 3.7E-02 -5.64741E-04 9.2E-02 -5.23990E-04 7.2E-02 -5.33540E-04 1.2E-01 -5.78638E-04 6.8E-02 -6.09930E-04 6.4E-02 -5.98985E-04 7.0E-02 -5.40784E-04 8.0E-02 -5.75234E-04 9.2E-02 -5.28452E-04 7.7E-02 -5.77718E-04 6.5E-02 -5.89060E-04 8.3E-02 -4.93485E-04 8.6E-02 -6.20415E-04 1.0E-01 -6.25987E-04 1.2E-01 -5.36207E-04 1.0E-01 -5.94505E-04 7.4E-02 -1.05728E-03 7.5E-02 -6.86492E-04 6.0E-02 -3.64002E-04 9.2E-02 -1.34809E-04 3.1E-01 -5.56138E-05 3.8E-01 -1.28759E-04 1.8E-01 -1.22406E-03 5.6E-02 -1.31918E-03 5.8E-02 -6.10589E-04 8.8E-02 -6.23244E-04 9.5E-02 -1.29121E-03 5.9E-02 -1.23572E-03 2.5E-02 -5.56659E-04 7.2E-02 -5.19105E-04 8.6E-02 -5.94938E-04 7.9E-02 -5.46954E-04 5.2E-02 -5.32394E-04 5.3E-02 -4.62548E-04 6.0E-02 -5.07942E-04 1.3E-01 -3.84348E-04 9.1E-02 -4.26828E-04 8.8E-02 -2.98108E-04 1.0E-01 -3.41700E-04 1.1E-01 -4.00188E-04 1.7E-01 -4.11232E-04 1.3E-01 -2.79106E-04 1.3E-01 -5.12157E-04 1.1E-01 -1.64244E-04 1.7E-01 -1.32054E-04 2.1E-01 -1.84910E-04 1.8E-01 -1.45308E-04 1.3E-01 -1.80620E-04 1.6E-01 -1.22134E-04 1.5E-01 -1.50201E-04 2.3E-01 -1.31080E-04 1.7E-01 -7.96841E-05 1.8E-01 -7.69487E-05 2.4E-01 -5.55196E-05 2.0E-01 -6.41485E-05 2.1E-01 -8.88864E-05 2.5E-01 -4.35660E-05 1.9E-01 -4.14612E-05 2.0E-01 -1.69797E-05 3.8E-01 -1.58027E-05 6.1E-01 -1.07371E-05 4.1E-01 -2.87891E-05 3.8E-01 -3.30112E-05 3.2E-01 -2.72349E-05 2.9E-01 -1.79838E-05 3.7E-01 -1.51720E-05 3.8E-01 -1.06784E-05 5.1E-01 -9.76310E-06 5.0E-01 -1.62967E-05 3.3E-01 -1.22606E-05 5.5E-01 -3.92056E-06 6.9E-01  0.00000E+00 0.0E+00 -1.79171E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -4.86843E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  3.00725E-06 1.0E+00  0.00000E+00 0.0E+00  2.99577E-07 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  6.64475E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  6.00818E-07 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00 -3.44531E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  3.86185E-06 1.0E+00  2.90091E-07 1.0E+00  0.00000E+00 0.0E+00  1.47712E-06 1.0E+00 -3.00812E-07 1.0E+00  7.73456E-06 1.0E+00  0.00000E+00 0.0E+00  3.24083E-06 8.1E-01  0.00000E+00 0.0E+00  5.42795E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  5.74928E-06 1.0E+00  7.63621E-06 7.8E-01  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  2.16494E-06 1.0E+00  4.66930E-06 9.3E-01  7.77323E-06 5.8E-01  3.50793E-06 1.0E+00 -4.65054E-06 8.6E-01 -5.45420E-06 1.0E+00  1.18276E-05 7.2E-01  5.07607E-06 1.0E+00 -4.19611E-06 1.0E+00  2.96904E-06 1.0E+00  1.34800E-05 9.2E-01  1.38234E-05 7.3E-01  2.23409E-05 4.7E-01  3.23192E-05 4.9E-01  2.15564E-05 4.4E-01  2.07079E-05 6.4E-01  3.23541E-05 8.1E-01  6.60821E-05 3.4E-01  1.14204E-04 2.4E-01  7.90348E-05 2.8E-01  2.56514E-04 2.5E-01  1.09354E-04 3.1E-01  1.77296E-04 1.7E-01  1.75997E-04 1.9E-01  4.50425E-04 1.0E-01  8.43078E-04 7.0E-02  1.36405E-03 6.7E-02  1.50109E-03 7.8E-02  1.86658E-03 5.6E-02  1.88477E-03 3.3E-02  2.04964E-03 4.5E-02  2.16039E-03 7.6E-02  2.27708E-03 5.1E-02  1.93252E-03 6.5E-02  1.98227E-03 5.5E-02  1.33568E-03 7.1E-02  6.19406E-04 1.2E-01  3.30952E-04 1.0E-01  3.87789E-04 1.4E-01  1.36343E-03 5.9E-02  1.97576E-03 4.5E-02  2.03704E-03 5.0E-02  2.12429E-03 5.0E-02  1.96319E-03 7.2E-02  1.77584E-03 6.6E-02  1.72057E-03 4.0E-02  3.25842E-03 2.6E-02  3.03244E-03 4.5E-02  3.01291E-03 3.6E-02  1.28782E-03 6.8E-02  1.23938E-03 5.7E-02  9.70813E-04 7.2E-02  9.31128E-04 4.6E-02  9.06293E-04 8.1E-02  8.95180E-04 9.6E-02  9.51016E-04 1.0E-01  6.56430E-04 7.8E-02  2.72979E-04 1.3E-01  8.37639E-04 5.6E-02  7.31526E-04 8.9E-02  5.99394E-04 1.5E-01  4.29879E-04 1.2E-01  3.29598E-04 1.4E-01  2.98250E-04 7.6E-02  3.06358E-04 1.6E-01  1.93352E-04 1.4E-01  1.58585E-04 1.9E-01  1.37299E-04 2.0E-01  5.25389E-05 3.4E-01  4.32152E-05 2.3E-01  1.59472E-05 6.4E-01 -1.42576E-06 1.0E+00  3.67858E-05 3.9E-01 -3.06070E-06 1.0E+00  2.25382E-05 3.4E-01  1.39101E-05 5.5E-01  2.83191E-07 1.0E+00  7.47288E-06 6.0E-01  6.03568E-07 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  4.02461E-06 1.0E+00  3.64027E-05 2.3E-01  2.44633E-05 5.2E-01  1.20049E-04 3.6E-01  9.09373E-05 5.4E-01  8.99133E-05 5.3E-01  8.50460E-05 6.7E-01  1.04106E-04 2.9E-01  1.06849E-04 3.3E-01  8.02267E-05 2.1E-01  8.88640E-05 3.8E-01  4.23224E-05 6.0E-01  1.81438E-05 1.0E+00 -1.98003E-05 9.9E-01  3.19820E-05 3.5E-01 -2.10959E-05 5.8E-01  4.05844E-06 1.0E+00  4.34119E-06 1.0E+00  1.16755E-05 7.0E-01  9.42039E-06 9.9E-01 -3.32233E-06 5.8E-01  0.00000E+00 0.0E+00  6.76697E-06 9.0E-01  8.49725E-06 1.0E+00  0.00000E+00 0.0E+00  0.00000E+00 0.0E+00  6.53902E-06 1.0E+00
];

ADJ_PERT_KEFF_SENS = reshape(ADJ_PERT_KEFF_SENS, [2, SENS_N_ENE, SENS_N_PERT, SENS_N_ZAI, SENS_N_MAT]);
ADJ_PERT_KEFF_SENS = permute(ADJ_PERT_KEFF_SENS, [5, 4, 3, 2, 1]);

ADJ_PERT_KEFF_SENS_E_INT = [
  9.04963E-01 6.7E-03  1.57783E-01 3.2E-02  0.00000E+00 0.0E+00  8.17144E-02 1.8E-02 -5.40618E-02 1.1E-02  7.19527E-01 2.0E-03  1.11552E-03 1.0E-01  2.18023E-01 2.5E-02  1.32040E-01 3.7E-02  0.00000E+00 0.0E+00  6.92511E-02 2.1E-02 -4.00483E-02 1.5E-02  5.67801E-02 1.2E-02  9.30410E-04 1.1E-01
];

ADJ_PERT_KEFF_SENS_E_INT = reshape(ADJ_PERT_KEFF_SENS_E_INT, [2, SENS_N_PERT, SENS_N_ZAI, SENS_N_MAT]);
ADJ_PERT_KEFF_SENS_E_INT = permute(ADJ_PERT_KEFF_SENS_E_INT, [4, 3, 2, 1]);



