# -*- coding: utf-8 -*-
#
# yggdrasil documentation build configuration file, created by
# sphinx-quickstart on Wed Sep  6 12:03:29 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import glob
import sys
import sphinx_rtd_theme
import yggdrasil
from yggdrasil import tools, languages, components
# sys.path.insert(0, os.path.abspath('.'))
doxydir = os.path.join(os.path.abspath('../'), "doxy", "xml")
rootdir = os.path.abspath('../../')
srcdir = os.path.join(rootdir, "yggdrasil")
sys.path.append(doxydir)


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.mathjax',
    'sphinx.ext.ifconfig',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages',
    'sphinx.ext.napoleon',
    'sphinxarg.ext',
    'breathe',
]


relative_files = []
for lang in tools.get_supported_lang():
    if lang == 'python':
        continue
    try:
        lang_dir = languages.get_language_dir(lang)
        lang_ext = components.import_component('model', lang).get_language_ext()
    except ValueError:
        continue
    for iext in lang_ext:
        relative_files += [os.path.relpath(f, start=srcdir) for f in
                           glob.glob(os.path.join(lang_dir, '*' + iext))]
        relative_files += [os.path.relpath(f, start=srcdir) for f in
                           glob.glob(os.path.join(lang_dir, '*', '*' + iext))]

breathe_projects = {"yggdrasil": doxydir}
breathe_default_project = "yggdrasil"
breathe_projects_source = {"yggdrasil": (srcdir, relative_files)}
breathe_implementation_filename_extensions = ['.c', '.cc', '.cpp', '.m', '.f90']
filter_method = os.path.abspath(os.path.join(doxydir, '..', 'filter.py'))
filter_source_method = os.path.abspath(os.path.join(doxydir, '..',
                                                    'filter_source.py'))
breathe_doxygen_config_options = {
    'EXTENSION_MAPPING': 'm=C++ f90=C++',
    # 'EXTENSION_MAPPING': 'm=C++ f90=FortranFree',
    'FILTER_PATTERNS': '*.m=%s *.f90=%s' % (filter_method, filter_method),
    # 'FILTER_PATTERNS': '*.m=%s' % (filter_method),
    'FILTER_SOURCE_FILES': 'YES',
    'FILTER_SOURCE_PATTERNS': '*.m=%s *.f90=%s' % (filter_source_method,
                                                   filter_source_method),
    # 'FILTER_SOURCE_PATTERNS': '*.m=%s' % (filter_source_method),
    'SOURCE_BROWSER': 'YES',
    'ENABLE_PREPROCESSING': 'YES',
    'PREDEFINED': 'DOXYGEN_SHOULD_SKIP_THIS'}
# 'EXCLUDE': ('../../yggdrasil/rapidjson '
#             '../../yggdrasil/languages/C/serialize/base64.h '
#             '../../yggdrasil/examples')

# Napoleon settings
napoleon_google_docstring = True
napoleon_numpy_docstring = False
napoleon_include_init_with_doc = False
napoleon_include_private_with_doc = False
napoleon_include_special_with_doc = True
napoleon_use_admonition_for_examples = False
napoleon_use_admonition_for_notes = False
napoleon_use_admonition_for_references = False
napoleon_use_ivar = False
napoleon_use_param = True
napoleon_use_rtype = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'yggdrasil'
copyright = u'2017, Meagan Lang, David Raila'
author = u'Meagan Lang, David Raila'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The full version, including alpha/beta/rc tags.
release = yggdrasil.__version__
# The short X.Y version.
version = release.split('+')[0]

# Substitutions
# .. _Docs: http://yggdrasil.readthedocs.io/en/latest/
rst_epilog = """
.. _Docs: https://cropsinsilico.github.io/yggdrasil/
.. _Meagan Lang: langmm.astro@gmail.com
.. |yggdrasil| replace:: yggdrasil
"""

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
# html_theme = 'alabaster'
html_theme = "sphinx_rtd_theme"
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# html_context = {
#     'css_files': [
#         '_static/theme_overrides.css',  # override wide tables in RTD theme
#         ],
#      }


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'yggdrasildoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'yggdrasil.tex', u'ygg\\_interface Documentation',
     u'Meagan Lang, David Raila', 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'yggdrasil', u'yggdrasil Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'yggdrasil', u'yggdrasil Documentation',
     author, 'yggdrasil', 'One line description of project.',
     'Miscellaneous'),
]

# -- Options for Epub output ----------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project
epub_author = author
epub_publisher = author
epub_copyright = copyright

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'https://docs.python.org/': None}
