#!/usr/bin/env python3
# See LICENSE for licensing information.
#
# Copyright (c) 2016-2023 Regents of the University of California, Santa Cruz
# All rights reserved.
#
import unittest
from testutils import *
import sys, os

import openram
from openram import debug
from openram.sram_factory import factory
from openram import OPTS


class port_data_test(openram_test):

    def runTest(self):
        config_file = "{}/tests/configs/config".format(os.getenv("OPENRAM_HOME"))
        openram.init_openram(config_file, is_unit_test=True)
        from openram import sram_config

        if OPTS.tech_name == "sky130":
            num_spare_rows = 1
            num_spare_cols = 1
        else:
            num_spare_rows = 0
            num_spare_cols = 0

        c = sram_config(word_size=4,
                        num_words=16,
                        num_spare_cols=num_spare_cols,
                        num_spare_rows=num_spare_rows)

        c.word_size=2
        c.num_words=128
        c.words_per_row=16
        c.recompute_sizes()
        debug.info(1, "Sixteen way column mux")
        a = factory.create("port_data", sram_config=c, port=0)
        self.local_check(a)

        openram.end_openram()


# run the test from the command line
if __name__ == "__main__":
    (OPTS, args) = openram.parse_args()
    del sys.argv[1:]
    header(__file__, OPTS.tech_name)
    unittest.main(testRunner=debugTestRunner())
