# This file is automatically generated. DO NOT EDIT!
# fmt: off

from __future__ import annotations

from typing import Any, List, Literal, Optional, Protocol, Tuple, TypedDict

# ======== helper classes ========



class AvrApriltagsSelectedPos(TypedDict):
    """
    The position of the vehicle in world frame **in cm**
    """

    n: float
    """
    The +north position of the vehicle relative to the world origin in world frame
    """
    e: float
    """
    The +east position of the vehicle relative to the world origin in world frame
    """
    d: float
    """
    The +down position of the vehicle relative to the world origin in world frame
    """



class AvrApriltagsRawTags(TypedDict):
    id: int
    """
    The ID of the tag
    """
    pos: AvrApriltagsRawTagsPos
    rotation: Tuple[Tuple[float, float, float], Tuple[float, float, float], Tuple[float, float, float]]
    """
    The 3x3 rotation matrix
    """



class AvrApriltagsRawTagsPos(TypedDict):
    x: float
    """
    The position **in meters** of the camera relative to the **tag's x** frame
    """
    y: float
    """
    The position **in meters** of the camera relative to the **tag's y** frame
    """
    z: float
    """
    The position **in meters** of the camera relative to the **tag's z** frame
    """



class AvrApriltagsVisibleTags(TypedDict):
    id: int
    """
    The ID of the tag
    """
    horizontal_dist: float
    """
    The horizontal scalar distance from vehicle to tag, **in cm**
    """
    vertical_dist: float
    """
    The vertical scalar distance from vehicle to tag, **in cm**
    """
    angle_to_tag: float
    """
    The angle formed by the vector pointing from the vehicles body to the tag in world frame relative to world-north
    """
    heading: float
    """
    The heading of the vehicle in world frame
    """
    pos_rel: AvrApriltagsVisibleTagsPosRel
    """
    The relative position of the vehicle to the tag in world frame **in cm**
    """
    pos_world: AvrApriltagsVisibleTagsPosWorld
    """
    The position of the vehicle in world frame **in cm** (if the tag has no truth data, this will not be present in the output)
    """



class AvrApriltagsVisibleTagsPosRel(TypedDict):
    """
    The relative position of the vehicle to the tag in world frame **in cm**
    """

    x: float
    """
    The x (+north/-south) position of the vehicle relative to the tag in world frame (for reference the mountain is **north** of the beach)
    """
    y: float
    """
    The y (+east/-west) position of the vehicle relative to the tag in world frame
    """
    z: float
    """
    The z (+down/-up) position of the vehicle relative to the tag in world frame (no, this is not a typo, up is really - )
    """



class AvrApriltagsVisibleTagsPosWorld(TypedDict):
    """
    The position of the vehicle in world frame **in cm** (if the tag has no truth data, this will not be present in the output)
    """

    x: Optional[float]
    """
    The x position of the vehicle relative to the world origin (this is the ship) in world frame (for reference the mountain is **north** of the beach)
    """
    y: Optional[float]
    """
    The y position of the vehicle relative to the world origin in world frame
    """
    z: Optional[float]
    """
    The z position of the vehicle relative to the world origin in world frame
    """


# =========== payloads ===========



class AvrAutonomousPayload(TypedDict):
    """
    Topic: `avr/autonomous`
    
    This enables enable or disable autonomous mode. This is not used by any Bell code, but available to students to listen to who may wish to not always be running their autonomous mode,
    """

    enable: bool


class _AvrAutonomousCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrAutonomousPayload) -> Any:
        ...


class AvrPcmSetBaseColorPayload(TypedDict):
    """
    Topic: `avr/pcm/set_base_color`
    
    This sets the color of the LED strip on the PCC
    """

    wrgb: Tuple[int, int, int, int]
    """
    A list of 4 `int`s between 0 and 255 to set the base color of the LEDs. Example: [255, 0, 128, 255].
    """


class _AvrPcmSetBaseColorCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrPcmSetBaseColorPayload) -> Any:
        ...


class AvrPcmSetTempColorPayload(TypedDict):
    """
    Topic: `avr/pcm/set_temp_color`
    
    This sets the color of the LED strip on the PCC temporarily
    """

    wrgb: Tuple[int, int, int, int]
    """
    A list of 4 `int`s between 0 and 255 to set the base color of the LEDs. Example: [255, 0, 128, 255].
    """
    time: float
    """
    Optional `float` for the number of seconds the color should be set for. Default is 0.5.
    """


class _AvrPcmSetTempColorCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrPcmSetTempColorPayload) -> Any:
        ...


class AvrPcmSetLaserOnPayload(TypedDict):
    """
    Topic: `avr/pcm/set_laser_on`
    """



class _AvrPcmSetLaserOnCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrPcmSetLaserOnPayload) -> Any:
        ...


class AvrPcmSetLaserOffPayload(TypedDict):
    """
    Topic: `avr/pcm/set_laser_off`
    """



class _AvrPcmSetLaserOffCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrPcmSetLaserOffPayload) -> Any:
        ...


class AvrPcmSetServoOpenClosePayload(TypedDict):
    """
    Topic: `avr/pcm/set_servo_open_close`
    """

    servo: int
    """
    ID of the servo to open or close as an `int`. This is 0-indexed.
    """
    action: Literal["open", "close"]
    """
    Either the literal string "open" or "close".
    """


class _AvrPcmSetServoOpenCloseCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrPcmSetServoOpenClosePayload) -> Any:
        ...


class AvrPcmSetServoMinPayload(TypedDict):
    """
    Topic: `avr/pcm/set_servo_min`
    """

    servo: int
    """
    ID of the servo to set the minimum pulse width as an `int`. This is 0-indexed.
    """
    min_pulse: int
    """
    A `int` between 0 and 1000.
    """


class _AvrPcmSetServoMinCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrPcmSetServoMinPayload) -> Any:
        ...


class AvrPcmSetServoMaxPayload(TypedDict):
    """
    Topic: `avr/pcm/set_servo_max`
    """

    servo: int
    """
    ID of the servo to set the maximum pulse width as an `int`. This is 0-indexed.
    """
    max_pulse: int
    """
    A `int` between 0 and 1000.
    """


class _AvrPcmSetServoMaxCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrPcmSetServoMaxPayload) -> Any:
        ...


class AvrPcmSetServoPctPayload(TypedDict):
    """
    Topic: `avr/pcm/set_servo_pct`
    """

    servo: int
    """
    ID of the servo to set the percent as an `int`. This is 0-indexed.
    """
    percent: int
    """
    A `int` between 0 and 100.
    """


class _AvrPcmSetServoPctCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrPcmSetServoPctPayload) -> Any:
        ...


class AvrPcmResetPayload(TypedDict):
    """
    Topic: `avr/pcm/reset`
    
    This resets the PCC
    """



class _AvrPcmResetCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrPcmResetPayload) -> Any:
        ...


class AvrFcmHilGpsStatsPayload(TypedDict):
    """
    Topic: `avr/fcm/hil_gps_stats`
    """

    num_frames: int


class _AvrFcmHilGpsStatsCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmHilGpsStatsPayload) -> Any:
        ...


class AvrFcmEventsPayload(TypedDict):
    """
    Topic: `avr/fcm/events`
    """

    name: str
    payload: str
    timestamp: str


class _AvrFcmEventsCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmEventsPayload) -> Any:
        ...


class AvrFcmBatteryPayload(TypedDict):
    """
    Topic: `avr/fcm/battery`
    """

    voltage: float
    """
    Battery voltage
    """
    soc: float
    """
    State of charge (0 - 100)
    """
    timestamp: str
    """
    Time the message was sent in [ISO 8601 format](https://docs.python.org/3/library/datetime.html#datetime.datetime.isoformat)
    """


class _AvrFcmBatteryCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmBatteryPayload) -> Any:
        ...


class AvrFcmStatusPayload(TypedDict):
    """
    Topic: `avr/fcm/status`
    """

    armed: bool
    """
    True/False if the drone is currently armed
    """
    mode: str
    """
    Current flight mode, which is one of the following:
    - 'UNKNOWN'
    - 'READY'
    - 'TAKEOFF'
    - 'HOLD'
    - 'MISSION'
    - 'RETURN_TO_LAUNCH'
    - 'LAND'
    - 'OFFBOARD'
    - 'FOLLOW_ME'
    - 'MANUAL'
    - 'ALTCTL'
    - 'POSCTL'
    - 'ACRO'
    - 'STABILIZED'
    - 'RATTITUDE'
    """
    timestamp: str
    """
    Time the message was sent in [ISO 8601 format](https://docs.python.org/3/library/datetime.html#datetime.datetime.isoformat)
    """


class _AvrFcmStatusCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmStatusPayload) -> Any:
        ...


class AvrFcmLocationLocalPayload(TypedDict):
    """
    Topic: `avr/fcm/location/local`
    """

    dX: float
    """
    X position in a local North/East/Down coordinate system
    """
    dY: float
    """
    Y position in a local North/East/Down coordinate system
    """
    dZ: float
    """
    Z position in a local North/East/Down coordinate system
    """
    timestamp: str
    """
    Time the message was sent in [ISO 8601 format](https://docs.python.org/3/library/datetime.html#datetime.datetime.isoformat)
    """


class _AvrFcmLocationLocalCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmLocationLocalPayload) -> Any:
        ...


class AvrFcmLocationGlobalPayload(TypedDict):
    """
    Topic: `avr/fcm/location/global`
    """

    lat: float
    """
    Latitude in global coordinates
    """
    lon: float
    """
    Longitude in global coordinates
    """
    alt: float
    """
    Relative altitude in global coordinates
    """
    hdg: float
    """
    Heading
    """
    timestamp: str
    """
    Time the message was sent in [ISO 8601 format](https://docs.python.org/3/library/datetime.html#datetime.datetime.isoformat)
    """


class _AvrFcmLocationGlobalCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmLocationGlobalPayload) -> Any:
        ...


class AvrFcmLocationHomePayload(TypedDict):
    """
    Topic: `avr/fcm/location/home`
    """

    lat: float
    """
    Latitude relative to the home position
    """
    lon: float
    """
    Longitude relative to the home position
    """
    alt: float
    """
    Relative altitude to the home position
    """
    timestamp: str
    """
    Time the message was sent in [ISO 8601 format](https://docs.python.org/3/library/datetime.html#datetime.datetime.isoformat)
    """


class _AvrFcmLocationHomeCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmLocationHomePayload) -> Any:
        ...


class AvrFcmAttitudeEulerPayload(TypedDict):
    """
    Topic: `avr/fcm/attitude/euler`
    """

    roll: float
    """
    Roll in degrees
    """
    pitch: float
    """
    Pitch in degrees
    """
    yaw: float
    """
    Yaw in degrees
    """
    timestamp: str
    """
    Time the message was sent in [ISO 8601 format](https://docs.python.org/3/library/datetime.html#datetime.datetime.isoformat)
    """


class _AvrFcmAttitudeEulerCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmAttitudeEulerPayload) -> Any:
        ...


class AvrFcmVelocityPayload(TypedDict):
    """
    Topic: `avr/fcm/velocity`
    """

    vX: float
    """
    X velocity in a local North/East/Down coordinate system
    """
    vY: float
    """
    Y velocity in a local North/East/Down coordinate system
    """
    vZ: float
    """
    Z velocity in a local North/East/Down coordinate system
    """
    timestamp: str
    """
    Time the message was sent in [ISO 8601 format](https://docs.python.org/3/library/datetime.html#datetime.datetime.isoformat)
    """


class _AvrFcmVelocityCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmVelocityPayload) -> Any:
        ...


class AvrFcmGpsInfoPayload(TypedDict):
    """
    Topic: `avr/fcm/gps_info`
    """

    num_satellites: int
    """
    Number of visible satellites in use
    """
    fix_type: str
    """
    GPS fix type
    """
    timestamp: str
    """
    Time the message was sent in [ISO 8601 format](https://docs.python.org/3/library/datetime.html#datetime.datetime.isoformat)
    """


class _AvrFcmGpsInfoCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFcmGpsInfoPayload) -> Any:
        ...


class AvrFusionPositionNedPayload(TypedDict):
    """
    Topic: `avr/fusion/position/ned`
    """

    n: float
    e: float
    d: float


class _AvrFusionPositionNedCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionPositionNedPayload) -> Any:
        ...


class AvrFusionVelocityNedPayload(TypedDict):
    """
    Topic: `avr/fusion/velocity/ned`
    """

    Vn: float
    Ve: float
    Vd: float


class _AvrFusionVelocityNedCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionVelocityNedPayload) -> Any:
        ...


class AvrFusionGeoPayload(TypedDict):
    """
    Topic: `avr/fusion/geo`
    """

    lat: float
    lon: float
    alt: float


class _AvrFusionGeoCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionGeoPayload) -> Any:
        ...


class AvrFusionGroundspeedPayload(TypedDict):
    """
    Topic: `avr/fusion/groundspeed`
    """

    groundspeed: float


class _AvrFusionGroundspeedCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionGroundspeedPayload) -> Any:
        ...


class AvrFusionCoursePayload(TypedDict):
    """
    Topic: `avr/fusion/course`
    """

    course: float


class _AvrFusionCourseCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionCoursePayload) -> Any:
        ...


class AvrFusionClimbratePayload(TypedDict):
    """
    Topic: `avr/fusion/climbrate`
    """

    climb_rate_fps: float


class _AvrFusionClimbrateCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionClimbratePayload) -> Any:
        ...


class AvrFusionAttitudeQuatPayload(TypedDict):
    """
    Topic: `avr/fusion/attitude/quat`
    """

    w: float
    x: float
    y: float
    z: float


class _AvrFusionAttitudeQuatCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionAttitudeQuatPayload) -> Any:
        ...


class AvrFusionAttitudeEulerPayload(TypedDict):
    """
    Topic: `avr/fusion/attitude/euler`
    """

    psi: float
    theta: float
    phi: float


class _AvrFusionAttitudeEulerCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionAttitudeEulerPayload) -> Any:
        ...


class AvrFusionAttitudeHeadingPayload(TypedDict):
    """
    Topic: `avr/fusion/attitude/heading`
    """

    heading: float


class _AvrFusionAttitudeHeadingCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionAttitudeHeadingPayload) -> Any:
        ...


class AvrFusionHilGpsPayload(TypedDict):
    """
    Topic: `avr/fusion/hil_gps`
    """

    time_usec: int
    fix_type: int
    lat: int
    lon: int
    alt: int
    eph: int
    epv: int
    vel: int
    vn: int
    ve: int
    vd: int
    cog: int
    satellites_visible: int
    heading: int


class _AvrFusionHilGpsCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrFusionHilGpsPayload) -> Any:
        ...


class AvrVioResyncPayload(TypedDict):
    """
    Topic: `avr/vio/resync`
    """

    n: float
    e: float
    d: float
    heading: float


class _AvrVioResyncCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrVioResyncPayload) -> Any:
        ...


class AvrVioPositionNedPayload(TypedDict):
    """
    Topic: `avr/vio/position/ned`
    """

    n: float
    e: float
    d: float


class _AvrVioPositionNedCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrVioPositionNedPayload) -> Any:
        ...


class AvrVioVelocityNedPayload(TypedDict):
    """
    Topic: `avr/vio/velocity/ned`
    """

    n: float
    e: float
    d: float


class _AvrVioVelocityNedCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrVioVelocityNedPayload) -> Any:
        ...


class AvrVioOrientationEulPayload(TypedDict):
    """
    Topic: `avr/vio/orientation/eul`
    """

    psi: float
    theta: float
    phi: float


class _AvrVioOrientationEulCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrVioOrientationEulPayload) -> Any:
        ...


class AvrVioOrientationQuatPayload(TypedDict):
    """
    Topic: `avr/vio/orientation/quat`
    """

    w: float
    x: float
    y: float
    z: float


class _AvrVioOrientationQuatCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrVioOrientationQuatPayload) -> Any:
        ...


class AvrVioHeadingPayload(TypedDict):
    """
    Topic: `avr/vio/heading`
    """

    degrees: float


class _AvrVioHeadingCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrVioHeadingPayload) -> Any:
        ...


class AvrVioConfidencePayload(TypedDict):
    """
    Topic: `avr/vio/confidence`
    """

    tracker: float
    """
    Number between 0 and 100 of tracking confidence
    """


class _AvrVioConfidenceCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrVioConfidencePayload) -> Any:
        ...


class AvrApriltagsSelectedPayload(TypedDict):
    """
    Topic: `avr/apriltags/selected`
    
    This topic publishes its best candidate for position feedback
    """

    tag_id: int
    """
    The id of the tag
    """
    pos: AvrApriltagsSelectedPos
    """
    The position of the vehicle in world frame **in cm**
    """
    heading: float


class _AvrApriltagsSelectedCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrApriltagsSelectedPayload) -> Any:
        ...


class AvrApriltagsRawPayload(TypedDict):
    """
    Topic: `avr/apriltags/raw`
    
    This topic publishes the raw tag data
    """

    tags: List[AvrApriltagsRawTags]


class _AvrApriltagsRawCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrApriltagsRawPayload) -> Any:
        ...


class AvrApriltagsVisiblePayload(TypedDict):
    """
    Topic: `avr/apriltags/visible`
    
    This topic publishes the transformed tag data
    """

    tags: List[AvrApriltagsVisibleTags]


class _AvrApriltagsVisibleCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrApriltagsVisiblePayload) -> Any:
        ...


class AvrApriltagsFpsPayload(TypedDict):
    """
    Topic: `avr/apriltags/fps`
    """

    fps: int


class _AvrApriltagsFpsCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrApriltagsFpsPayload) -> Any:
        ...


class AvrThermalReadingPayload(TypedDict):
    """
    Topic: `avr/thermal/reading`
    """

    data: str


class _AvrThermalReadingCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrThermalReadingPayload) -> Any:
        ...


class AvrStatusLightPcmPayload(TypedDict):
    """
    Topic: `avr/status/light/pcm`
    """



class _AvrStatusLightPcmCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrStatusLightPcmPayload) -> Any:
        ...


class AvrStatusLightVioPayload(TypedDict):
    """
    Topic: `avr/status/light/vio`
    """



class _AvrStatusLightVioCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrStatusLightVioPayload) -> Any:
        ...


class AvrStatusLightApriltagsPayload(TypedDict):
    """
    Topic: `avr/status/light/apriltags`
    """



class _AvrStatusLightApriltagsCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrStatusLightApriltagsPayload) -> Any:
        ...


class AvrStatusLightFcmPayload(TypedDict):
    """
    Topic: `avr/status/light/fcm`
    """



class _AvrStatusLightFcmCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrStatusLightFcmPayload) -> Any:
        ...


class AvrStatusLightThermalPayload(TypedDict):
    """
    Topic: `avr/status/light/thermal`
    """



class _AvrStatusLightThermalCallable(Protocol):
    """
    Class used only for type-hinting MQTT callbacks
    """
    def __call__(self, payload: AvrStatusLightThermalPayload) -> Any:
        ...
