/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.tree;

import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.tree.DefaultTreeLayer;
import io.qameta.allure.tree.TestResultTreeGroup;
import io.qameta.allure.tree.TestResultTreeLeaf;
import io.qameta.allure.tree.TreeLayer;
import io.qameta.allure.tree.TreeNode;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;

public final class TreeUtils {
    private TreeUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static String createGroupUid(String parentUid, String groupName) {
        MessageDigest md = TreeUtils.getMessageDigest();
        md.update(Objects.toString(parentUid).getBytes(StandardCharsets.UTF_8));
        md.update(Objects.toString(groupName).getBytes(StandardCharsets.UTF_8));
        return DatatypeConverter.printHexBinary((byte[])md.digest()).toLowerCase();
    }

    public static List<TreeLayer> groupByLabels(TestResult testResult, LabelName ... labelNames) {
        return Stream.of(labelNames).map(testResult::findAllLabels).filter(strings -> !strings.isEmpty()).map(DefaultTreeLayer::new).collect(Collectors.toList());
    }

    public static Statistic calculateStatisticByLeafs(TestResultTreeGroup group) {
        return group.getChildren().stream().reduce(new Statistic(), TreeUtils::updateStatisticRecursive, TreeUtils::mergeStatistic);
    }

    public static Statistic calculateStatisticByChildren(TestResultTreeGroup group) {
        return group.getChildren().stream().reduce(new Statistic(), TreeUtils::updateStatistic, TreeUtils::mergeStatistic);
    }

    public static Statistic updateStatisticRecursive(Statistic statistic, TreeNode treeNode) {
        if (treeNode instanceof TestResultTreeGroup) {
            statistic.merge(TreeUtils.calculateStatisticByLeafs((TestResultTreeGroup)treeNode));
        } else if (treeNode instanceof TestResultTreeLeaf) {
            statistic.update(((TestResultTreeLeaf)treeNode).getStatus());
        }
        return statistic;
    }

    public static Statistic updateStatistic(Statistic statistic, TreeNode treeNode) {
        if (treeNode instanceof TestResultTreeGroup) {
            Statistic byLeafs = TreeUtils.calculateStatisticByLeafs((TestResultTreeGroup)treeNode);
            statistic.update(byLeafs.getStatus());
        } else if (treeNode instanceof TestResultTreeLeaf) {
            statistic.update(((TestResultTreeLeaf)treeNode).getStatus());
        }
        return statistic;
    }

    public static Statistic mergeStatistic(Statistic a, Statistic b) {
        Statistic statistic = new Statistic();
        statistic.merge(a);
        statistic.merge(b);
        return statistic;
    }

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Can not find hashing algorithm", e);
        }
    }
}

