/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.AttributeImpl;
import com.vladsch.flexmark.util.html.Attributes;
import java.util.LinkedHashMap;

public class MutableAttributes
extends Attributes {
    public MutableAttributes() {
    }

    public MutableAttributes(Attributes attributes) {
        super(attributes);
    }

    @Override
    public MutableAttributes toMutable() {
        return this;
    }

    @Override
    public Attributes toImmutable() {
        return new Attributes(this);
    }

    protected LinkedHashMap<String, Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap();
        }
        return this.attributes;
    }

    public Attribute replaceValue(Attribute attribute) {
        return this.replaceValue(attribute.getName(), attribute.getValue());
    }

    public Attribute replaceValue(CharSequence key, CharSequence value) {
        Attribute attribute;
        String useKey = String.valueOf(key);
        attribute = this.attributes == null ? AttributeImpl.of(useKey, value) : ((attribute = (Attribute)this.attributes.get(useKey)) != null ? attribute.replaceValue(value) : AttributeImpl.of(useKey, value));
        this.getAttributes().put(useKey, attribute);
        return attribute;
    }

    public Attribute addValue(Attribute attribute) {
        return this.addValue(attribute.getName(), attribute.getValue());
    }

    public MutableAttributes addValues(Attributes attributes) {
        for (Attribute attribute : attributes.values()) {
            this.addValue(attribute.getName(), attribute.getValue());
        }
        return this;
    }

    public Attribute addValue(CharSequence key, CharSequence value) {
        Attribute attribute;
        String useKey = String.valueOf(key);
        attribute = this.attributes == null ? AttributeImpl.of(key, value) : ((attribute = (Attribute)this.attributes.get(useKey)) != null ? attribute.setValue(value) : AttributeImpl.of(useKey, value));
        this.getAttributes().put(useKey, attribute);
        return attribute;
    }

    public Attribute removeValue(Attribute attribute) {
        return this.removeValue(attribute.getName(), attribute.getValue());
    }

    public Attribute remove(Attribute attribute) {
        return this.remove(attribute.getName());
    }

    public Attribute removeValue(CharSequence key, CharSequence value) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return null;
        }
        String useKey = String.valueOf(key);
        Attribute oldAttribute = (Attribute)this.attributes.get(useKey);
        Attribute attribute = oldAttribute.removeValue(value);
        this.getAttributes().put(useKey, attribute);
        return attribute;
    }

    public void clear() {
        this.attributes = null;
    }

    public Attribute remove(CharSequence key) {
        if (this.attributes == null || key == null || key.length() == 0) {
            return null;
        }
        String useKey = String.valueOf(key);
        Attribute oldAttribute = (Attribute)this.attributes.get(useKey);
        this.attributes.remove(useKey);
        return oldAttribute;
    }

    public void replaceValues(MutableAttributes attributes) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap(attributes.attributes);
        } else {
            this.attributes.putAll(attributes.attributes);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String attrName : this.keySet()) {
            sb.append(sep).append(attrName);
            Attribute attribute = (Attribute)this.attributes.get(attrName);
            if (!attribute.getValue().isEmpty()) {
                sb.append("=").append("\"").append(attribute.getValue().replace("\"", "\\\"")).append("\"");
            }
            sep = " ";
        }
        return "MutableAttributes{" + sb.toString() + '}';
    }
}

