drop table if exists pesstoObjects;
CREATE TABLE `pesstoObjects` (
  `pesstoObjectsId` int(11) NOT NULL AUTO_INCREMENT COMMENT 'This is the primary ID for all pessto objects. All helper tables with reference this ID to associate data with the pessto object.',
  `transientBucketId` int(11) NOT NULL COMMENT 'the primary ID of the pessto object in the master_sn_list table.',
  `classifiedFlag` tinyint(4) NOT NULL DEFAULT '0',
  `marshallWorkflowLocation` varchar(45) NOT NULL COMMENT 'pessto workflow status flag 01 (cannot be null)',
  `alertWorkflowLocation` varchar(45) NOT NULL COMMENT 'pessto workflow status flag 02 (can be null)',
  `publicStatus` int(11) NOT NULL COMMENT 'the release status of the object',
  `dateAdded` datetime NOT NULL COMMENT 'date the pessto object was added to this database',
  `dateLastModified` datetime NOT NULL COMMENT 'date the entry for the pessto object **in this table** was last modified.',
  `finderChartLocalUrl` varchar(300) DEFAULT NULL,
  `lsq_stamp` tinyint(4) DEFAULT NULL,
  `css_stamp` tinyint(4) DEFAULT NULL,
  `lsq_lightcurve` tinyint(4) DEFAULT NULL,
  `ogle_target_stamp` tinyint(4) DEFAULT NULL,
  `ogle_lightcurve` tinyint(4) DEFAULT NULL,
  `ogle_subtracted_stamp` tinyint(4) DEFAULT NULL,
  `ogle_reference_stamp` tinyint(4) DEFAULT NULL,
  `mls_stamp` tinyint(4) DEFAULT NULL,
  `sss_stamp` tinyint(4) DEFAULT NULL,
  `css_lightcurve` tinyint(4) DEFAULT NULL,
  `sss_lightcurve` tinyint(4) DEFAULT NULL,
  `mls_lightcurve` tinyint(4) DEFAULT NULL,
  `ps1_subtracted_stamp` tinyint(4) DEFAULT NULL,
  `ps1_target_stamp` tinyint(4) DEFAULT NULL,
  `ps1_reference_stamp` tinyint(4) DEFAULT NULL,
  `skymapper_reference_stamp` tinyint(4) DEFAULT NULL,
  `skymapper_subtracted_stamp` tinyint(4) DEFAULT NULL,
  `skymapper_target_stamp` tinyint(4) DEFAULT NULL,
  `ogle_color_context_stamp` tinyint(4) DEFAULT NULL,
  `pi_name` varchar(200) DEFAULT NULL,
  `pi_email` varchar(200) DEFAULT NULL,
  `master_pessto_lightcurve` tinyint(4) DEFAULT NULL,
  `classification_finalised` tinyint(4) NOT NULL DEFAULT '0',
  `master_stamp` tinyint(4) DEFAULT NULL,
  `bsl_stamp` tinyint(4) DEFAULT NULL,
  `observationPriority` tinyint(4) DEFAULT '2',
  `lastTimeReviewed` datetime DEFAULT NULL,
  `mpcMatch` varchar(200) DEFAULT NULL,
  `snoozed` tinyint(4) DEFAULT '0',
  `lastReviewedMag` float DEFAULT NULL,
  `lastReviewedMagDate` datetime DEFAULT NULL,
  `des_target_stamp` tinyint(4) DEFAULT NULL,
  `des_reference_stamp` tinyint(4) DEFAULT NULL,
  `des_subtracted_stamp` tinyint(4) DEFAULT NULL,
  `gaia_stamp` tinyint(4) DEFAULT NULL,
  `ps1_map` tinyint(4) DEFAULT NULL,
  `photometry_catalogue_release` varchar(45) DEFAULT NULL,
  `transient_catalogue_release` varchar(45) DEFAULT NULL,
  `followup_target_release` varchar(45) DEFAULT NULL,
  `pessto_citations` varchar(200) DEFAULT NULL,
  `atlas_target_stamp` tinyint(4) DEFAULT NULL,
  `atlas_subtracted_stamp` tinyint(4) DEFAULT NULL,
  `atlas_reference_stamp` tinyint(4) DEFAULT NULL,
  `atlas_fp_lightcurve` datetime DEFAULT NULL,
  PRIMARY KEY (`pesstoObjectsId`) KEY_BLOCK_SIZE=1024,
  UNIQUE KEY `pesstoObjectId_UNIQUE` (`pesstoObjectsId`) KEY_BLOCK_SIZE=1024,
  UNIQUE KEY `masterSnId_UNIQUE` (`transientBucketId`) KEY_BLOCK_SIZE=1024,
  KEY `transientBucketId` (`transientBucketId`),
  KEY `classified` (`classifiedFlag`),
  KEY `mwl` (`marshallWorkflowLocation`),
  KEY `awl` (`alertWorkflowLocation`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPRESSED KEY_BLOCK_SIZE=8;



INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1420021,1420021,0,'archive','Pending Classification',1,'2016-10-03 18:18:14','2016-10-03 18:18:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.327,'2016-09-30 12:07:27',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1420024,1420024,1,'archive','external alert released',1,'2016-10-03 18:18:14','2016-10-03 18:18:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.2904,'2016-09-30 15:08:41',1,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1420027,1420027,0,'archive','Pending Classification',1,'2016-10-03 18:18:14','2016-10-03 18:18:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.0759,'2016-09-30 14:40:25',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1428023,1428023,0,'archive','Pending Classification',1,'2016-10-04 06:25:22','2016-10-04 06:25:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.7,'2016-10-03 18:40:07',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1428024,1428024,1,'archive','external alert released',1,'2016-10-04 06:25:22','2016-10-04 06:25:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.9,'2016-10-03 18:38:51',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:11');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1428025,1428025,0,'archive','Pending Classification',1,'2016-10-04 06:25:22','2016-10-04 06:25:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,19,'2016-10-03 17:34:26',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1429493,1429493,0,'archive','Pending Classification',1,'2016-10-04 09:21:54','2016-10-04 09:21:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,19.89,'2016-10-01 10:00:29',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1429494,1429494,0,'archive','Pending Classification',1,'2016-10-04 09:21:54','2016-10-04 09:21:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.32,'2016-10-01 10:58:05',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1429495,1429495,0,'archive','Pending Classification',1,'2016-10-04 09:21:54','2016-10-04 09:21:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.17,'2016-10-01 10:03:22',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1429496,1429496,0,'archive','Pending Classification',1,'2016-10-04 09:21:54','2016-10-04 09:21:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,19.61,'2016-10-01 10:03:22',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1429497,1429497,0,'archive','Pending Classification',1,'2016-10-04 09:21:54','2016-10-04 09:21:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,19.3,'2016-09-29 11:32:38',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1429499,1429499,0,'archive','Pending Classification',1,'2016-10-04 09:21:54','2016-10-04 09:21:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.97,'2016-10-01 11:08:10',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:38');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1429500,1429500,0,'archive','Pending Classification',1,'2016-10-04 09:21:54','2016-10-04 09:21:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,20.28,'2016-09-27 12:36:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430313,1430313,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,16.3,'2016-05-16 22:39:21',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430316,1430316,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,18.8,'2016-05-03 01:43:40',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430317,1430317,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,18.1,'2016-04-27 18:34:33',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430323,1430323,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,17.7,'2016-03-30 00:34:33',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430324,1430324,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,17.4,'2016-03-23 00:23:02',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430327,1430327,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17,'2016-02-13 21:14:23',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430328,1430328,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,15.8,'2016-02-11 22:45:07',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430330,1430330,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,17.5,'2015-12-17 22:26:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430331,1430331,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,18.7,'2015-12-10 22:55:12',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430332,1430332,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,17.8,'2015-12-17 00:17:16',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430338,1430338,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,17.9,'2015-10-17 01:53:45',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430340,1430340,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17,'2015-10-13 20:44:09',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430341,1430341,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,17.8,'2015-10-11 01:06:14',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430342,1430342,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,18.1,'2015-10-06 00:43:12',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430343,1430343,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.6,'2015-10-06 01:06:14',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430344,1430344,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,17,'2015-09-30 21:48:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430347,1430347,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.5,'2015-09-12 16:37:55',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430353,1430353,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,16.9,'2015-06-20 15:48:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430359,1430359,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,16.6,'2015-05-25 18:37:26',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430360,1430360,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,16.3,'2015-04-26 18:02:52',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430361,1430361,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,18,'2015-04-08 23:31:12',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430362,1430362,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,16.9,'2015-04-09 23:57:07',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430363,1430363,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,17.8,'2015-04-08 19:47:59',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430364,1430364,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,17.8,'2015-04-08 19:33:35',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430365,1430365,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.6,'2015-04-01 23:22:33',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430368,1430368,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,18.1,'2015-03-22 01:33:36',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430369,1430369,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,18.4,'2015-03-25 19:13:26',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430370,1430370,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.3,'2015-03-22 17:57:07',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430371,1430371,0,'archive','Pending Classification',1,'2016-10-04 11:17:12','2016-10-04 11:17:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,18.7,'2015-03-18 19:26:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430444,1430444,0,'archive','Pending Classification',1,'2016-10-04 11:54:23','2016-10-04 11:54:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,17.3,'2016-09-20 01:32:09',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430447,1430447,0,'archive','Pending Classification',1,'2016-10-04 11:54:23','2016-10-04 11:54:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,16.7,'2016-09-07 03:07:11',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430448,1430448,0,'archive','Pending Classification',1,'2016-10-04 11:54:23','2016-10-04 11:54:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,17.2,'2016-09-06 05:34:04',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430450,1430450,0,'archive','Pending Classification',1,'2016-10-04 11:54:23','2016-10-04 11:54:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,'2016-11-09 08:31:03',NULL,1,17.8,'2016-08-16 00:51:50',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1430451,1430451,0,'archive','Pending Classification',1,'2016-10-04 11:54:23','2016-10-04 11:54:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,1,2,'2016-11-09 08:31:03',NULL,1,18.6,'2016-08-19 00:28:47',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1434167,1434167,0,'archive','Pending Classification',1,'2016-10-04 18:25:16','2016-10-04 18:25:16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.49,'2016-10-01 23:11:02',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1434168,1434168,0,'archive','Pending Classification',1,'2016-10-04 18:25:16','2016-10-04 18:25:16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19,'2016-10-02 14:58:33',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1434169,1434169,0,'archive','Pending Classification',1,'2016-10-04 18:25:16','2016-10-04 18:25:16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.74,'2016-10-02 04:04:48',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1434544,1434544,0,'archive','Pending Classification',1,'2016-10-04 19:24:48','2016-10-04 19:24:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.23,'2016-09-26 09:31:40',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1434545,1434545,0,'archive','Pending Classification',1,'2016-10-04 19:24:48','2016-10-04 19:24:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.36,'2016-09-26 09:37:26',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1434546,1434546,0,'archive','Pending Classification',1,'2016-10-04 19:24:48','2016-10-04 19:24:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.51,'2016-09-27 11:18:14',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1434547,1434547,0,'archive','Pending Classification',1,'2016-10-04 19:24:48','2016-10-04 19:24:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.56,'2016-09-27 06:51:50',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1434548,1434548,0,'archive','Pending Classification',1,'2016-10-04 19:24:48','2016-10-04 19:24:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,19.54,'2016-09-30 09:01:26',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1436871,1436871,0,'archive','Pending Classification',1,'2016-10-05 00:22:34','2016-10-05 00:22:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.2781,'2016-09-25 13:10:04',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1436876,1436876,0,'archive','Pending Classification',1,'2016-10-05 00:22:34','2016-10-05 00:22:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1775,'2016-09-25 13:17:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1436885,1436885,0,'archive','Pending Classification',1,'2016-10-05 00:22:34','2016-10-05 00:22:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.9929,'2016-09-26 08:37:29',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1436890,1436890,0,'archive','Pending Classification',1,'2016-10-05 00:22:34','2016-10-05 00:22:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.9454,'2016-09-30 06:43:01',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1436900,1436900,0,'archive','Pending Classification',1,'2016-10-05 00:22:34','2016-10-05 00:22:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8148,'2016-09-30 12:19:41',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1436905,1436905,0,'archive','Pending Classification',1,'2016-10-05 00:22:34','2016-10-05 00:22:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.4643,'2016-09-30 14:35:18',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1436909,1436909,0,'archive','Pending Classification',1,'2016-10-05 00:22:34','2016-10-05 00:22:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.7844,'2016-10-02 11:27:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1438424,1438424,0,'archive','Pending Classification',1,'2016-10-05 03:26:34','2016-10-05 03:26:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.6,'2016-07-29 10:10:33',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:39');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1441947,1441947,1,'archive','archived without alert',1,'2016-10-05 09:22:36','2016-10-05 09:22:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.36,'2016-10-03 10:26:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1441948,1441948,1,'archive','archived without alert',1,'2016-10-05 09:24:55','2016-10-05 09:24:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.6,'2016-10-04 16:32:06',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1442325,1442325,0,'archive','Pending Classification',1,'2016-10-05 11:13:17','2016-10-05 11:13:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.32,'2016-09-25 08:46:10',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-08 00:19:48');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1442331,1442331,0,'archive','Pending Classification',1,'2016-10-05 11:13:17','2016-10-05 11:13:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.04,'2016-09-25 08:40:15',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:40');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1442706,1442706,1,'archive','archived without alert',1,'2016-10-05 11:25:00','2016-10-05 11:25:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,15.95,'2016-10-02 22:09:07',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1444210,1444210,0,'archive','Pending Classification',1,'2016-10-05 14:18:43','2016-10-05 14:18:43',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,1,2,'2016-11-09 08:31:03',NULL,0,21.289,'2016-09-07 07:21:16',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1444239,1444239,0,'archive','Pending Classification',1,'2016-10-05 14:18:43','2016-10-05 14:18:43',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,1,2,'2016-11-09 08:31:03',NULL,0,20.113,'2016-10-05 05:13:36',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1444617,1444617,0,'archive','Pending Classification',1,'2016-10-05 15:17:57','2016-10-05 15:17:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.4925,'2016-09-30 06:48:35',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1444624,1444624,0,'archive','Pending Classification',1,'2016-10-05 15:17:57','2016-10-05 15:17:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.9234,'2016-09-27 11:58:51',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1444629,1444629,0,'archive','Pending Classification',1,'2016-10-05 15:17:57','2016-10-05 15:17:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.4441,'2016-10-02 12:58:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1444635,1444635,0,'archive','Pending Classification',1,'2016-10-05 15:17:57','2016-10-05 15:17:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.8656,'2016-09-30 06:40:15',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1444644,1444644,0,'archive','Pending Classification',1,'2016-10-05 15:17:57','2016-10-05 15:17:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.9898,'2016-09-30 06:45:48',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445024,1445024,0,'archive','Pending Classification',1,'2016-10-05 15:26:57','2016-10-05 15:26:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.06,'2016-10-03 04:16:19',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445025,1445025,0,'archive','Pending Classification',1,'2016-10-05 15:26:57','2016-10-05 15:26:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.71,'2016-10-03 04:11:59',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445026,1445026,0,'archive','Pending Classification',1,'2016-10-05 15:26:57','2016-10-05 15:26:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.06,'2016-10-03 15:48:57',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445027,1445027,0,'archive','Pending Classification',1,'2016-10-05 15:26:57','2016-10-05 15:26:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,16.4,'2016-10-03 03:46:04',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445028,1445028,0,'archive','Pending Classification',1,'2016-10-05 15:26:57','2016-10-05 15:26:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.52,'2016-10-03 11:35:31',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445029,1445029,0,'archive','Pending Classification',1,'2016-10-05 15:26:57','2016-10-05 15:26:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.64,'2016-08-29 01:03:21',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445030,1445030,0,'archive','Pending Classification',1,'2016-10-05 15:26:57','2016-10-05 15:26:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,14.9,'2016-10-03 06:01:26',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445031,1445031,0,'archive','Pending Classification',1,'2016-10-05 15:26:57','2016-10-05 15:26:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.76,'2016-10-04 00:46:04',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445032,1445032,0,'archive','Pending Classification',1,'2016-10-05 15:26:57','2016-10-05 15:26:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.85,'2016-10-04 08:57:07',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1445427,1445427,0,'archive','Pending Classification',1,'2016-10-05 16:23:38','2016-10-05 16:23:38',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.71,'2016-09-24 12:20:09',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1446171,1446171,0,'archive','Pending Classification',1,'2016-10-05 18:18:18','2016-10-05 18:18:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.8936,'2016-09-26 10:20:58',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1446176,1446176,0,'archive','Pending Classification',1,'2016-10-05 18:18:18','2016-10-05 18:18:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,22.1895,'2016-09-25 13:16:56',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1446181,1446181,0,'archive','Pending Classification',1,'2016-10-05 18:18:18','2016-10-05 18:18:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.8259,'2016-09-27 11:54:05',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1446214,1446214,0,'archive','Pending Classification',1,'2016-10-05 18:18:18','2016-10-05 18:18:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.4437,'2016-09-25 13:17:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1446219,1446219,0,'archive','Pending Classification',1,'2016-10-05 18:18:18','2016-10-05 18:18:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.659,'2016-09-27 12:04:33',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1446228,1446228,0,'archive','Pending Classification',1,'2016-10-05 18:18:18','2016-10-05 18:18:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.5414,'2016-09-27 12:06:25',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1447399,1447399,1,'archive','external alert released',1,'2016-10-05 20:23:29','2016-10-05 20:23:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,1,2,'2016-11-09 08:31:03',NULL,0,18.6,'2016-10-05 07:36:46',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:41');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1448142,1448142,1,'archive','archived without alert',1,'2016-10-05 21:37:49','2016-10-05 21:37:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,18.9,'2016-10-04 10:53:21',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1448159,1448159,0,'archive','Pending Classification',1,'2016-10-05 23:15:09','2016-10-05 23:15:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,16.71,'2016-10-05 05:36:43',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:39:54');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1448163,1448163,0,'archive','Pending Classification',1,'2016-10-05 23:15:09','2016-10-05 23:15:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.07,'2016-09-26 06:38:32',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-01 19:20:53');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1448190,1448190,0,'archive','Pending Classification',1,'2016-10-05 23:15:09','2016-10-05 23:15:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.73,'2016-09-26 09:12:09',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 15:00:28');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1454305,1454305,0,'archive','Pending Classification',1,'2016-10-06 09:22:47','2016-10-06 09:22:47',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.28,'2016-10-05 11:13:55',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1454307,1454307,0,'archive','Pending Classification',1,'2016-10-06 09:22:47','2016-10-06 09:22:47',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,19.5,'2016-10-05 10:24:58',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1456719,1456719,0,'archive','Pending Classification',1,'2016-10-06 14:18:36','2016-10-06 14:18:36',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,1,3,'2016-11-09 08:31:03',NULL,0,21.429,'2016-09-22 04:09:05',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1458722,1458722,0,'archive','Pending Classification',1,'2016-10-06 18:17:59','2016-10-06 18:17:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.7521,'2016-09-30 13:24:10',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1459475,1459475,0,'archive','Pending Classification',1,'2016-10-06 19:23:45','2016-10-06 19:23:45',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.43,'2016-10-02 10:53:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1462288,1462288,0,'archive','Pending Classification',1,'2016-10-07 00:30:56','2016-10-07 00:30:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,17.13,'2016-10-06 05:59:40',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-15 11:15:25');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1462293,1462293,0,'archive','Pending Classification',1,'2016-10-07 00:30:56','2016-10-07 00:30:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,17.89,'2016-10-06 06:06:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:39:55');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1462299,1462299,0,'archive','Pending Classification',1,'2016-10-07 00:30:56','2016-10-07 00:30:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.32,'2016-09-26 10:01:19',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 15:00:28');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1462305,1462305,0,'archive','Pending Classification',1,'2016-10-07 00:30:56','2016-10-07 00:30:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.14,'2016-09-26 10:40:30',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-09 00:19:31');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1466519,1466519,0,'archive','Pending Classification',1,'2016-10-07 08:23:37','2016-10-07 08:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.5,'2016-09-29 02:24:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1467285,1467285,1,'archive','archived without alert',1,'2016-10-07 09:24:37','2016-10-07 09:24:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,16.2,'2016-10-06 04:48:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1467670,1467670,0,'archive','Pending Classification',1,'2016-10-07 10:24:56','2016-10-07 10:24:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.02,'2016-10-05 18:04:19',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1467671,1467671,0,'archive','Pending Classification',1,'2016-10-07 10:24:56','2016-10-07 10:24:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.79,'2016-10-05 11:22:33',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1467672,1467672,0,'archive','Pending Classification',1,'2016-10-07 10:24:56','2016-10-07 10:24:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.55,'2016-10-04 16:23:31',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1468638,1468638,0,'archive','Pending Classification',1,'2016-10-07 14:23:53','2016-10-07 14:23:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.71,'2016-10-04 18:01:26',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1470711,1470711,0,'archive','Pending Classification',1,'2016-10-07 18:19:04','2016-10-07 18:19:04',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,17.4,'2016-10-04 21:27:21',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1470712,1470712,1,'archive','external alert released',1,'2016-10-07 18:19:04','2016-10-07 18:19:04',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,1,2,'2016-11-09 08:31:03',NULL,0,16.8,'2016-10-03 23:51:21',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 18:22:28');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1471484,1471484,0,'archive','Pending Classification',1,'2016-10-07 19:24:20','2016-10-07 19:24:20',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.01,'2016-10-05 20:47:02',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1471485,1471485,0,'archive','Pending Classification',1,'2016-10-07 19:24:20','2016-10-07 19:24:20',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,18.87,'2016-10-06 10:00:28',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1471872,1471872,1,'archive','archived without alert',1,'2016-10-07 20:23:52','2016-10-07 20:23:52',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.1,'2016-09-26 06:43:12',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1473027,1473027,0,'archive','Pending Classification',1,'2016-10-08 00:15:34','2016-10-08 00:15:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.08,'2016-10-07 10:17:07',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:43');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1473038,1473038,0,'archive','Pending Classification',1,'2016-10-08 00:15:34','2016-10-08 00:15:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.93,'2016-05-07 11:27:01',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-11-08 15:04:44');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1473049,1473049,0,'archive','Pending Classification',1,'2016-10-08 00:15:34','2016-10-08 00:15:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.85,'2016-07-12 12:59:55',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:45');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1473059,1473059,0,'archive','Pending Classification',1,'2016-10-08 00:15:34','2016-10-08 00:15:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.89,'2016-06-07 13:03:28',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:46');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1480817,1480817,0,'archive','Pending Classification',1,'2016-10-08 14:13:15','2016-10-08 14:13:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.18,'2016-10-07 10:10:44',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:47');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1480823,1480823,0,'archive','Pending Classification',1,'2016-10-08 14:13:15','2016-10-08 14:13:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.36,'2016-04-14 13:38:22',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:48');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1480831,1480831,0,'archive','Pending Classification',1,'2016-10-08 14:13:15','2016-10-08 14:13:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.52,'2016-09-26 11:13:22',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 18:22:29');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1480912,1480912,0,'archive','Pending Classification',1,'2016-10-08 14:13:15','2016-10-08 14:13:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.79,'2016-10-07 11:12:41',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:49');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1481302,1481302,0,'archive','Pending Classification',1,'2016-10-08 15:13:11','2016-10-08 15:13:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.26,'2016-09-30 11:10:56',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 18:22:29');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1482968,1482968,0,'archive','Pending Classification',1,'2016-10-08 18:17:57','2016-10-08 18:17:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.0392,'2016-10-07 07:09:59',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1482973,1482973,0,'archive','Pending Classification',1,'2016-10-08 18:17:57','2016-10-08 18:17:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.1891,'2016-10-06 10:35:43',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1482982,1482982,0,'archive','Pending Classification',1,'2016-10-08 18:17:57','2016-10-08 18:17:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.3339,'2016-10-06 11:52:50',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1485435,1485435,0,'archive','Pending Classification',1,'2016-10-08 23:46:22','2016-10-08 23:46:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.81,'2016-09-21 13:55:12',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:50');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1485436,1485436,0,'archive','Pending Classification',1,'2016-10-08 23:46:22','2016-10-08 23:46:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.15,'2016-10-07 13:09:07',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:51');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1485438,1485438,0,'archive','Pending Classification',1,'2016-10-08 23:46:22','2016-10-08 23:46:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.39,'2016-10-07 13:55:12',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:52');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1485444,1485444,0,'archive','Pending Classification',1,'2016-10-09 00:15:16','2016-10-09 00:15:16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.52,'2016-05-24 14:02:21',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 14:00:50');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1485454,1485454,0,'archive','Pending Classification',1,'2016-10-09 00:15:16','2016-10-09 00:15:16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,15.53,'2016-09-25 13:55:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:53');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1485468,1485468,0,'archive','Pending Classification',1,'2016-10-09 00:15:16','2016-10-09 00:15:16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.46,'2016-10-08 07:21:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 15:00:31');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1485478,1485478,0,'archive','Pending Classification',1,'2016-10-09 00:15:16','2016-10-09 00:15:16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,15.75,'2016-04-09 15:09:56',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-01 19:21:00');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1491182,1491182,1,'following','external alert released',1,'2016-10-09 08:24:00','2016-10-09 08:24:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,4,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1496462,1496462,1,'archive','external alert released',1,'2016-10-09 18:24:37','2016-10-09 18:24:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.3,'2016-10-09 14:38:24',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:54');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498067,1498067,0,'archive','Pending Classification',1,'2016-10-09 21:41:29','2016-10-09 21:41:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.92,'2016-10-08 05:55:40',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498068,1498068,0,'archive','Pending Classification',1,'2016-10-09 21:41:29','2016-10-09 21:41:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.95,'2016-10-06 18:41:45',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498069,1498069,0,'archive','Pending Classification',1,'2016-10-09 21:41:29','2016-10-09 21:41:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.72,'2016-10-07 06:05:45',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498070,1498070,0,'archive','Pending Classification',1,'2016-10-09 21:41:29','2016-10-09 21:41:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.94,'2016-10-06 21:10:04',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498071,1498071,0,'archive','Pending Classification',1,'2016-10-09 21:41:29','2016-10-09 21:41:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,19,'2016-10-07 03:34:33',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498072,1498072,0,'archive','Pending Classification',1,'2016-10-09 21:41:29','2016-10-09 21:41:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.79,'2016-10-06 21:51:50',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498073,1498073,0,'archive','Pending Classification',1,'2016-10-09 21:41:29','2016-10-09 21:41:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.35,'2016-09-10 04:19:12',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498074,1498074,0,'archive','Pending Classification',1,'2016-10-09 21:41:29','2016-10-09 21:41:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.5,'2016-10-07 11:11:02',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498075,1498075,0,'archive','Pending Classification',1,'2016-10-09 21:41:29','2016-10-09 21:41:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.96,'2016-10-08 04:52:19',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498096,1498096,0,'archive','Pending Classification',1,'2016-10-09 21:50:24','2016-10-09 21:50:24',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,20.45,'2016-10-01 07:52:29',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498097,1498097,0,'pending observation','Pending Classification',1,'2016-10-09 21:50:24','2016-10-09 21:50:24',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498098,1498098,0,'archive','Pending Classification',1,'2016-10-09 21:50:24','2016-10-09 21:50:24',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.76,'2016-10-07 18:17:57',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498507,1498507,0,'archive','Pending Classification',1,'2016-10-10 00:16:07','2016-10-10 00:16:07',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.01,'2016-10-08 14:26:04',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 18:22:30');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498516,1498516,0,'archive','Pending Classification',1,'2016-10-10 00:16:07','2016-10-10 00:16:07',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.72,'2016-10-08 13:14:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 18:22:31');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1498522,1498522,0,'archive','Pending Classification',1,'2016-10-10 00:16:07','2016-10-10 00:16:07',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.75,'2016-10-08 13:13:32',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 18:22:32');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1504753,1504753,0,'archive','Pending Classification',1,'2016-10-10 09:22:15','2016-10-10 09:22:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.65,'2016-10-09 11:31:12',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1505979,1505979,0,'archive','Pending Classification',1,'2016-10-10 12:19:05','2016-10-10 12:19:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.5,'2016-10-08 02:55:40',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1508441,1508441,0,'archive','Pending Classification',1,'2016-10-10 16:18:31','2016-10-10 16:18:31',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,19.681,'2016-10-10 08:46:12',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1508469,1508469,1,'archive','pessto classification released',1,'2016-10-10 16:18:31','2016-10-10 16:18:31',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.307,'2016-01-29 03:47:50',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1508497,1508497,0,'archive','Pending Classification',1,'2016-10-10 16:18:31','2016-10-10 16:18:31',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,21.153,'2016-01-23 04:32:41',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1508942,1508942,1,'archive','external alert released',1,'2016-10-10 17:24:02','2016-10-10 17:24:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.26,'2016-10-02 23:12:28',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509385,1509385,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.916,'2016-10-06 11:56:33',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509390,1509390,1,'archive','external alert released',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,19.0725,'2016-10-06 13:05:13',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509404,1509404,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.614,'2016-10-06 13:18:40',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509409,1509409,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.2375,'2016-10-06 12:38:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509412,1509412,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.9013,'2016-10-06 07:17:14',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509421,1509421,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,19.3274,'2016-10-06 09:27:17',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509436,1509436,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.175,'2016-10-08 10:20:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509441,1509441,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,20.1296,'2016-10-08 06:46:19',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509446,1509446,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.6334,'2016-10-08 08:18:35',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509460,1509460,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,20.0468,'2016-10-08 12:26:03',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509465,1509465,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.6859,'2016-10-06 11:50:58',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509470,1509470,1,'archive','external alert released',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.7885,'2016-10-09 08:10:38',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509486,1509486,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.8392,'2016-10-06 09:21:39',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509496,1509496,0,'archive','Pending Classification',1,'2016-10-10 18:17:09','2016-10-10 18:17:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,20.2225,'2016-10-09 08:08:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509912,1509912,0,'archive','Pending Classification',1,'2016-10-10 18:27:09','2016-10-10 18:27:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.59,'2016-10-09 09:11:31',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509913,1509913,0,'archive','Pending Classification',1,'2016-10-10 18:27:09','2016-10-10 18:27:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.61,'2016-10-09 10:33:36',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1509914,1509914,0,'archive','Pending Classification',1,'2016-10-10 18:27:09','2016-10-10 18:27:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.61,'2016-10-08 17:42:43',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1510411,1510411,1,'archive','external alert released',1,'2016-10-10 19:28:22','2016-10-10 19:28:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,1,2,'2016-11-09 08:31:03',NULL,0,18.6,'2016-10-09 03:30:30',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-02 12:18:00');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1511650,1511650,0,'archive','Pending Classification',1,'2016-10-10 21:40:00','2016-10-10 21:40:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.2,'2016-10-07 07:43:19',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1511667,1511667,0,'archive','Pending Classification',1,'2016-10-10 22:14:49','2016-10-10 22:14:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.05,'2016-10-09 10:32:29',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:12');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1514652,1514652,0,'archive','Pending Classification',1,'2016-10-11 03:20:05','2016-10-11 03:20:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.4945,'2016-10-06 13:10:06',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1514657,1514657,0,'archive','Pending Classification',1,'2016-10-11 03:20:05','2016-10-11 03:20:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.111,'2016-10-06 13:10:06',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1514662,1514662,0,'archive','Pending Classification',1,'2016-10-11 03:20:05','2016-10-11 03:20:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.7562,'2016-10-09 10:38:38',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1518406,1518406,0,'archive','Pending Classification',1,'2016-10-11 09:22:46','2016-10-11 09:22:46',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.92,'2016-10-08 13:00:29',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1522457,1522457,0,'archive','Pending Classification',1,'2016-10-11 17:13:12','2016-10-11 17:13:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,16.92,'2016-10-10 05:29:10',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-20 14:47:10');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1535534,1535534,0,'archive','Pending Classification',1,'2016-10-12 15:26:33','2016-10-12 15:26:33',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.26,'2016-09-13 13:24:57',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:55');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1535535,1535535,0,'archive','Pending Classification',1,'2016-10-12 15:26:33','2016-10-12 15:26:33',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.65,'2016-10-10 12:10:04',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1535536,1535536,0,'archive','Pending Classification',1,'2016-10-12 15:26:33','2016-10-12 15:26:33',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.45,'2016-10-10 03:02:52',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1535537,1535537,0,'archive','Pending Classification',1,'2016-10-12 15:26:33','2016-10-12 15:26:33',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.36,'2016-10-09 17:28:19',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1535538,1535538,0,'archive','Pending Classification',1,'2016-10-12 15:26:33','2016-10-12 15:26:33',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.98,'2016-10-10 03:43:12',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1535539,1535539,0,'archive','Pending Classification',1,'2016-10-12 15:26:33','2016-10-12 15:26:33',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.7,'2016-10-10 00:25:55',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:11');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1535540,1535540,0,'pending observation','Pending Classification',1,'2016-10-12 15:26:33','2016-10-12 15:26:33',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:12');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1536438,1536438,0,'archive','Pending Classification',1,'2016-10-12 17:50:06','2016-10-12 17:50:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.86,'2016-10-10 03:11:31',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1538943,1538943,0,'archive','Pending Classification',1,'2016-10-13 00:15:30','2016-10-13 00:15:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.58,'2016-06-22 11:49:41',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-31 11:20:54');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1539593,1539593,0,'archive','Pending Classification',1,'2016-10-13 00:23:36','2016-10-13 00:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.4726,'2016-10-06 09:24:29',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1539598,1539598,0,'archive','Pending Classification',1,'2016-10-13 00:23:36','2016-10-13 00:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.6395,'2016-10-08 06:54:50',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1539607,1539607,0,'archive','Pending Classification',1,'2016-10-13 00:23:36','2016-10-13 00:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.5544,'2016-10-09 12:56:51',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1539612,1539612,0,'archive','Pending Classification',1,'2016-10-13 00:23:36','2016-10-13 00:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.5213,'2016-10-10 09:32:41',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1539617,1539617,0,'archive','Pending Classification',1,'2016-10-13 00:23:36','2016-10-13 00:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.4505,'2016-10-11 07:00:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1539622,1539622,0,'archive','Pending Classification',1,'2016-10-13 00:23:36','2016-10-13 00:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.4272,'2016-10-11 06:58:09',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1539627,1539627,0,'archive','Pending Classification',1,'2016-10-13 00:23:36','2016-10-13 00:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.9022,'2016-10-11 08:17:20',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1547844,1547844,0,'archive','Pending Classification',1,'2016-10-13 14:26:15','2016-10-13 14:26:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.43,'2016-10-11 07:35:02',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1547845,1547845,0,'archive','Pending Classification',1,'2016-10-13 14:26:15','2016-10-13 14:26:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.95,'2016-10-11 07:13:26',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:56');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1547846,1547846,0,'archive','Pending Classification',1,'2016-10-13 14:26:15','2016-10-13 14:26:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.93,'2016-10-10 05:15:21',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1547847,1547847,0,'archive','Pending Classification',1,'2016-10-13 14:26:15','2016-10-13 14:26:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.52,'2016-10-10 21:21:36',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1548692,1548692,0,'archive','Pending Classification',1,'2016-10-13 15:24:46','2016-10-13 15:24:46',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.38,'2016-09-27 04:59:31',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1550839,1550839,0,'archive','Pending Classification',1,'2016-10-13 20:13:13','2016-10-13 20:13:13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.42,'2016-10-13 08:35:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:57');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1550850,1550850,0,'archive','Pending Classification',1,'2016-10-13 20:13:13','2016-10-13 20:13:13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.04,'2016-10-07 11:12:41',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:58');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1559706,1559706,0,'archive','Pending Classification',1,'2016-10-14 11:25:44','2016-10-14 11:25:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.67,'2016-10-10 18:51:50',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1559707,1559707,0,'archive','Pending Classification',1,'2016-10-14 11:25:44','2016-10-14 11:25:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.27,'2016-10-11 06:36:00',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1559708,1559708,0,'archive','Pending Classification',1,'2016-10-14 11:25:44','2016-10-14 11:25:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.48,'2016-10-10 17:02:24',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1559709,1559709,0,'archive','Pending Classification',1,'2016-10-14 11:25:44','2016-10-14 11:25:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.75,'2016-10-10 22:55:12',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1559710,1559710,0,'archive','Pending Classification',1,'2016-10-14 11:25:44','2016-10-14 11:25:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,16.98,'2016-10-11 23:29:45',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1560138,1560138,0,'archive','Pending Classification',1,'2016-10-14 12:18:29','2016-10-14 12:18:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.0918,'2016-10-06 13:12:01',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1560143,1560143,0,'archive','Pending Classification',1,'2016-10-14 12:18:29','2016-10-14 12:18:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.0265,'2016-10-10 08:26:15',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1560156,1560156,0,'archive','Pending Classification',1,'2016-10-14 12:18:29','2016-10-14 12:18:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.4118,'2016-10-10 08:38:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1560171,1560171,1,'archive','external alert released',1,'2016-10-14 12:18:29','2016-10-14 12:18:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.45,'2016-10-11 10:22:22',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1560642,1560642,0,'archive','Pending Classification',1,'2016-10-14 13:13:16','2016-10-14 13:13:16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.33,'2016-10-07 09:18:55',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:04:59');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1561075,1561075,0,'archive','Pending Classification',1,'2016-10-14 14:13:12','2016-10-14 14:13:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.31,'2016-09-21 14:13:04',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:00');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1562916,1562916,0,'archive','Pending Classification',1,'2016-10-14 17:13:22','2016-10-14 17:13:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.34,'2016-03-15 05:22:59',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:01');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1562925,1562925,0,'archive','Pending Classification',1,'2016-10-14 17:13:22','2016-10-14 17:13:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.03,'2016-10-13 10:06:44',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:02');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1562931,1562931,0,'archive','Pending Classification',1,'2016-10-14 17:13:22','2016-10-14 17:13:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.38,'2016-10-06 06:15:16',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-20 14:47:17');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1562952,1562952,1,'archive','pessto classification released',1,'2016-10-14 17:13:22','2016-10-14 17:13:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,17.44,'2016-10-14 05:44:07',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:19');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1563385,1563385,0,'archive','Pending Classification',1,'2016-10-14 18:13:17','2016-10-14 18:13:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.24,'2016-09-26 13:37:44',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 18:22:33');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1563400,1563400,0,'archive','Pending Classification',1,'2016-10-14 18:13:17','2016-10-14 18:13:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.95,'2016-09-22 05:47:32',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-31 11:21:03');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1564256,1564256,0,'archive','Pending Classification',1,'2016-10-14 19:13:14','2016-10-14 19:13:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.07,'2016-10-07 06:26:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:04');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1564267,1564267,0,'archive','Pending Classification',1,'2016-10-14 19:13:14','2016-10-14 19:13:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.74,'2016-09-21 05:56:48',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:05');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1564291,1564291,0,'archive','Pending Classification',1,'2016-10-14 19:13:14','2016-10-14 19:13:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.09,'2016-09-30 06:26:13',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-31 11:21:06');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1593053,1593053,0,'archive','Pending Classification',1,'2016-10-16 21:16:16','2016-10-16 21:16:16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.43,'2016-10-10 14:43:49',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:13');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601228,1601228,0,'archive','Pending Classification',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.5243,'2016-10-09 12:51:49',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601233,1601233,1,'archive','external alert released',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.8758,'2016-10-10 08:33:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601238,1601238,0,'archive','Pending Classification',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.6271,'2016-10-12 14:38:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601243,1601243,0,'archive','Pending Classification',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.981,'2016-10-12 06:31:13',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601248,1601248,0,'archive','Pending Classification',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.4602,'2016-10-12 06:43:17',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601258,1601258,1,'archive','pessto classification released',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.6506,'2016-10-13 13:48:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601263,1601263,0,'archive','Pending Classification',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.7781,'2016-10-14 06:24:30',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601268,1601268,0,'archive','Pending Classification',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.0809,'2016-10-14 13:02:12',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601281,1601281,0,'archive','Pending Classification',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.4776,'2016-10-15 09:07:56',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:07');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601290,1601290,0,'archive','Pending Classification',1,'2016-10-17 15:16:59','2016-10-17 15:16:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.9455,'2016-10-16 09:29:11',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:23');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601296,1601296,0,'archive','Pending Classification',1,'2016-10-17 16:22:40','2016-10-17 16:22:40',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.15,'2016-10-14 07:04:48',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601297,1601297,0,'archive','Pending Classification',1,'2016-10-17 16:22:40','2016-10-17 16:22:40',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.99,'2016-10-13 16:55:12',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601298,1601298,0,'archive','Pending Classification',1,'2016-10-17 16:22:40','2016-10-17 16:22:40',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.05,'2016-10-13 15:53:16',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601336,1601336,0,'archive','Pending Classification',1,'2016-10-17 17:14:03','2016-10-17 17:14:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.59,'2016-10-17 07:55:35',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:08');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601353,1601353,0,'archive','Pending Classification',1,'2016-10-17 17:21:53','2016-10-17 17:21:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.98,'2016-10-13 09:27:21',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601394,1601394,0,'archive','Pending Classification',1,'2016-10-17 20:14:02','2016-10-17 20:14:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.9,'2016-10-17 10:25:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:10');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601400,1601400,0,'archive','Pending Classification',1,'2016-10-17 20:14:02','2016-10-17 20:14:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,17.67,'2016-10-16 12:30:33',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:10');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601407,1601407,0,'archive','Pending Classification',1,'2016-10-17 20:14:02','2016-10-17 20:14:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.53,'2016-09-21 07:50:48',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:11');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601422,1601422,0,'archive','Pending Classification',1,'2016-10-17 21:48:27','2016-10-17 21:48:27',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.93,'2016-10-14 10:20:31',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601526,1601526,0,'archive','Pending Classification',1,'2016-10-18 12:14:01','2016-10-18 12:14:01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.16,'2016-10-16 10:42:12',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:13');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601537,1601537,1,'archive','external alert released',1,'2016-10-18 12:18:17','2016-10-18 12:18:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.6,'2016-10-09 22:39:21',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601538,1601538,0,'archive','Pending Classification',1,'2016-10-18 12:22:14','2016-10-18 12:22:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.62,'2016-10-16 05:35:31',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601539,1601539,0,'archive','Pending Classification',1,'2016-10-18 12:22:14','2016-10-18 12:22:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.09,'2016-09-17 21:37:26',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601607,1601607,1,'archive','external alert released',1,'2016-10-18 17:14:00','2016-10-18 17:14:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,17.74,'2016-10-13 15:03:49',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:14');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601618,1601618,0,'archive','Pending Classification',1,'2016-10-19 00:52:37','2016-10-19 00:52:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.25,'2016-10-09 11:54:14',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601659,1601659,0,'archive','Pending Classification',1,'2016-10-19 15:18:19','2016-10-19 15:18:19',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,13.2,'2016-10-19 13:49:35',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601701,1601701,1,'archive','archived without alert',1,'2016-10-19 17:23:35','2016-10-19 17:23:35',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.84,'2016-10-16 08:55:40',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601702,1601702,0,'archive','Pending Classification',1,'2016-10-19 17:23:35','2016-10-19 17:23:35',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.06,'2016-09-25 20:05:16',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601703,1601703,0,'archive','Pending Classification',1,'2016-10-19 17:23:35','2016-10-19 17:23:35',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.73,'2016-10-16 01:36:28',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601704,1601704,0,'archive','Pending Classification',1,'2016-10-19 17:23:35','2016-10-19 17:23:35',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.38,'2016-10-15 19:32:09',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601705,1601705,0,'archive','Pending Classification',1,'2016-10-19 17:23:35','2016-10-19 17:23:35',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.67,'2016-10-15 22:22:04',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601706,1601706,0,'archive','Pending Classification',1,'2016-10-19 17:23:35','2016-10-19 17:23:35',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.44,'2016-10-16 04:20:38',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601707,1601707,0,'archive','Pending Classification',1,'2016-10-19 17:23:35','2016-10-19 17:23:35',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.25,'2016-10-16 16:53:45',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601722,1601722,1,'archive','pessto classification released',1,'2016-10-19 19:22:25','2016-10-19 19:22:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,17.9,'2016-10-19 09:10:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:14');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601734,1601734,0,'archive','Pending Classification',1,'2016-10-19 23:33:58','2016-10-19 23:33:58',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,18.963,'2016-10-19 08:30:43',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601762,1601762,0,'archive','Pending Classification',1,'2016-10-19 23:33:58','2016-10-19 23:33:58',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.559,'2016-10-19 08:18:09',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601790,1601790,1,'archive','pessto classification released',1,'2016-10-20 00:41:59','2016-10-20 00:41:59',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.79,'2016-10-17 08:57:07',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601793,1601793,0,'archive','Pending Classification',1,'2016-10-20 11:02:14','2016-10-20 11:02:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,10.7,'2016-10-20 09:11:13',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601950,1601950,1,'archive','pessto classification released',1,'2016-10-20 13:17:25','2016-10-20 13:17:25',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,21.1,'2016-10-01 04:27:18',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1601983,1601983,1,'archive','external alert released',1,'2016-10-20 13:21:22','2016-10-20 13:21:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.1409,'2016-10-10 09:46:40',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1602565,1602565,0,'archive','Pending Classification',1,'2016-10-20 14:35:46','2016-10-20 14:35:46',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,1,19.96,'2016-07-06 14:42:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-11-08 15:05:15');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1608929,1608929,1,'archive','external alert released',1,'2016-10-20 21:24:41','2016-10-20 21:24:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,17.53,'2016-10-19 11:55:58',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:15');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1616985,1616985,1,'archive','archived without alert',1,'2016-10-21 12:15:15','2016-10-21 12:15:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,15.9,'2016-10-20 00:00:00',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1617438,1617438,0,'archive','Pending Classification',1,'2016-10-21 12:23:17','2016-10-21 12:23:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,1,3,'2016-11-09 08:31:03',NULL,0,16.8,'2016-10-10 00:56:09',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1617887,1617887,0,'archive','Pending Classification',1,'2016-10-21 13:21:27','2016-10-21 13:21:27',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.593,'2016-10-12 08:48:23',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1617914,1617914,0,'archive','Pending Classification',1,'2016-10-21 13:21:27','2016-10-21 13:21:27',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.581,'2016-01-17 03:48:46',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1617945,1617945,1,'archive','archived without alert',1,'2016-10-21 13:21:27','2016-10-21 13:21:27',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.085,'2016-10-21 03:26:41',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618422,1618422,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.379,'2016-08-10 06:52:04',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618442,1618442,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.266,'2016-08-11 07:39:00',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618470,1618470,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.582,'2016-09-20 04:25:36',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618497,1618497,0,'inbox','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-06 18:31:02',NULL,2,20.733,'2016-08-03 09:05:37',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618524,1618524,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.927,'2016-09-18 07:22:38',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618552,1618552,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.246,'2016-09-12 07:07:08',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618580,1618580,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.845,'2016-08-03 09:52:04',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618608,1618608,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.384,'2016-01-02 02:54:14',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618634,1618634,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.642,'2016-03-25 00:56:22',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618657,1618657,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.312,'2016-01-02 05:40:50',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618681,1618681,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.86,'2016-09-06 09:39:37',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618708,1618708,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.723,'2016-09-06 09:16:55',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618734,1618734,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.643,'2016-03-16 02:08:40',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618758,1618758,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.819,'2016-09-04 04:45:20',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618783,1618783,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.106,'2016-08-29 08:18:08',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618812,1618812,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.705,'2016-08-30 08:32:41',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618843,1618843,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.12,'2016-09-01 08:02:08',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1618874,1618874,0,'archive','Pending Classification',1,'2016-10-21 14:20:28','2016-10-21 14:20:28',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.398,'2016-08-31 10:01:49',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1622337,1622337,0,'archive','Pending Classification',1,'2016-10-21 19:25:49','2016-10-21 19:25:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.337,'2016-10-19 09:58:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1622338,1622338,0,'archive','Pending Classification',1,'2016-10-21 19:25:49','2016-10-21 19:25:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.9199,'2016-10-19 09:48:30',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:21:47');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1625026,1625026,0,'archive','Pending Classification',1,'2016-10-22 00:54:56','2016-10-22 00:54:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.063,'2016-10-17 13:44:27',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1625028,1625028,0,'archive','Pending Classification',1,'2016-10-22 00:54:56','2016-10-22 00:54:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.0474,'2016-10-19 06:34:36',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1625916,1625916,1,'archive','external alert released',1,'2016-10-22 02:40:24','2016-10-22 02:40:24',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,15.5,'2016-10-19 14:52:48',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1637055,1637055,0,'archive','Pending Classification',1,'2016-10-22 20:25:34','2016-10-22 20:25:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.3,'2016-10-16 11:00:57',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1637056,1637056,0,'archive','Pending Classification',1,'2016-10-22 20:25:34','2016-10-22 20:25:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,15.54,'2016-10-17 04:42:14',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1639779,1639779,0,'archive','Pending Classification',1,'2016-10-23 01:45:17','2016-10-23 01:45:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,16.5,'2016-10-22 19:25:18',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648841,1648841,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.25,'2016-10-07 06:25:55',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648842,1648842,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.81,'2016-10-09 07:13:26',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648843,1648843,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.88,'2016-10-07 06:23:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648844,1648844,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8,'2016-10-08 07:37:55',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648845,1648845,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.14,'2016-10-06 11:26:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648846,1648846,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.26,'2016-10-08 09:37:26',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648847,1648847,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21,'2016-10-06 12:23:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648848,1648848,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.43,'2016-10-06 08:51:21',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648849,1648849,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.21,'2016-10-08 07:35:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648850,1648850,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.84,'2016-10-06 07:43:40',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648851,1648851,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.97,'2016-10-06 08:51:21',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648852,1648852,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.86,'2016-10-06 08:35:31',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648853,1648853,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.14,'2016-10-09 07:17:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648854,1648854,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.9,'2016-10-09 06:12:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648855,1648855,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.08,'2016-10-06 07:43:40',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1648856,1648856,0,'archive','Pending Classification',1,'2016-10-23 16:30:11','2016-10-23 16:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21,'2016-10-06 11:05:16',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1649326,1649326,1,'archive','external alert released',1,'2016-10-23 17:25:13','2016-10-23 17:25:13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20,'2016-10-22 07:39:45',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:16');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1652158,1652158,0,'pending observation','Pending Classification',1,'2016-10-23 22:33:23','2016-10-23 22:33:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1652187,1652187,1,'following','pessto classification released',1,'2016-10-23 22:33:23','2016-10-23 22:33:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Santiago González-Gaitán','gongsale@gmail.com',1,0,NULL,NULL,4,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1652219,1652219,1,'following','pessto classification released',1,'2016-10-23 22:33:23','2016-10-23 22:33:23',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,4,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653715,1653715,0,'pending observation','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653716,1653716,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1521,'2016-10-19 10:58:17',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653717,1653717,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.3132,'2016-10-19 14:05:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653718,1653718,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.7429,'2016-10-19 14:01:41',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653719,1653719,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.6194,'2016-10-19 07:39:41',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653720,1653720,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.4691,'2016-10-19 06:25:19',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653721,1653721,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1524,'2016-10-19 07:40:36',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653722,1653722,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.0716,'2016-10-20 11:22:05',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653723,1653723,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.4183,'2016-10-19 07:48:56',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653724,1653724,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1549,'2016-10-10 10:57:04',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653725,1653725,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.9722,'2016-10-12 09:14:12',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653726,1653726,1,'archive','archived without alert',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.6889,'2016-10-20 11:23:01',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:17');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653727,1653727,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.4904,'2016-10-13 14:57:29',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1653728,1653728,0,'archive','Pending Classification',1,'2016-10-24 01:08:25','2016-10-24 01:08:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.8781,'2016-10-16 15:07:20',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661424,1661424,1,'archive','pessto classification released',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.53,'2016-08-03 02:41:16',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,1,1,'2016-11-08 18:21:16');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661428,1661428,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.23,'2016-08-07 10:56:38',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,1,1,'2016-10-31 11:21:17');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661884,1661884,1,'archive','external alert released',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.33,'2016-10-08 11:06:06',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 18:22:35');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661903,1661903,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.83,'2016-10-25 07:47:32',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:19');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661914,1661914,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.96,'2016-10-25 05:02:39',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:20');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661925,1661925,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.38,'2016-10-25 05:39:35',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:21');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661935,1661935,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.63,'2016-02-24 07:57:22',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:22');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661948,1661948,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.34,'2015-12-28 06:26:51',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:23');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661969,1661969,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.31,'2016-10-25 05:25:58',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:24');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661974,1661974,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.95,'2016-10-25 07:04:03',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:25');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661984,1661984,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.84,'2016-10-25 05:09:07',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:26');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1661988,1661988,1,'archive','external alert released',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.91,'2016-10-16 11:40:43',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:27');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662007,1662007,1,'archive','external alert released',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.04,'2016-10-25 10:31:32',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:28');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662027,1662027,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.79,'2016-10-25 14:36:59',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:29');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662034,1662034,0,'pending observation','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:43');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662040,1662040,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.56,'2016-10-26 10:25:34',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:30');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662046,1662046,0,'pending observation','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:31');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662062,1662062,0,'pending observation','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:45');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662089,1662089,0,'pending observation','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:46');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662095,1662095,0,'pending observation','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:47');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662100,1662100,1,'archive','archived without alert',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.13,'2016-10-14 15:00:55',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:32');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662111,1662111,0,'pending observation','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:33');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662120,1662120,0,'pending observation','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:34');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662128,1662128,1,'archive','archived without alert',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,17.16,'2016-10-27 12:44:12',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:17');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662133,1662133,1,'following','pessto classification released',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Lluis Galbany','lluisgalbany@gmail.com',1,0,NULL,NULL,4,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:18');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662139,1662139,1,'review for followup','external alert released',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:36');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662154,1662154,0,'pending observation','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:19');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662164,1662164,0,'pending observation','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-31 11:21:40');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662172,1662172,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.49,'2016-10-28 05:13:46',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-01 19:21:10');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662176,1662176,1,'inbox','archived without alert',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-07 15:01:02',NULL,0,17.78,'2016-10-28 07:07:17',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 15:00:35');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662182,1662182,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.27,'2016-10-29 05:04:15',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:38');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662188,1662188,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.02,'2016-10-29 05:57:10',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:38');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662194,1662194,0,'archive','Pending Classification',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.07,'2016-10-17 13:51:21',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:39');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662208,1662208,1,'archive','archived without alert',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,17.56,'2016-10-30 05:47:30',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:53');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1662214,1662214,1,'archive','archived without alert',1,'2016-10-31 10:25:03','2016-10-31 10:25:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.03,'2016-10-30 14:02:46',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:40');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1666352,1666352,0,'archive','Pending Classification',1,'2016-10-31 10:35:58','2016-10-31 10:35:58',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.69,'2016-10-26 04:18:15',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1666388,1666388,0,'archive','Pending Classification',1,'2016-10-31 10:35:58','2016-10-31 10:35:58',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.304,'2016-10-21 01:47:47',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1666419,1666419,1,'archive','archived without alert',1,'2016-10-31 10:35:58','2016-10-31 10:35:58',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.657,'2016-10-19 06:58:48',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1666448,1666448,0,'archive','Pending Classification',1,'2016-10-31 10:35:58','2016-10-31 10:35:58',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.529,'2016-07-01 09:48:55',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1666476,1666476,1,'archive','external alert released',1,'2016-10-31 10:38:06','2016-10-31 10:38:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.63,'2016-10-25 06:00:00',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1666477,1666477,1,'archive','external alert released',1,'2016-10-31 10:38:06','2016-10-31 10:38:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-09 08:31:03',NULL,0,16.99,'2016-10-21 02:09:36',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1666478,1666478,1,'archive','archived without alert',1,'2016-10-31 10:38:06','2016-10-31 10:38:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,16.34,'2016-10-28 14:38:24',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1666479,1666479,0,'archive','Pending Classification',1,'2016-10-31 10:38:06','2016-10-31 10:38:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.41,'2016-10-29 04:19:12',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667864,1667864,0,'archive','Pending Classification',1,'2016-10-31 12:16:31','2016-10-31 12:16:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,22.2876,'2016-10-09 23:51:22',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667899,1667899,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.817,'2016-10-10 08:33:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667900,1667900,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.8858,'2016-10-10 09:31:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667901,1667901,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.3441,'2016-10-10 09:43:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667902,1667902,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.3741,'2016-10-10 11:01:58',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667905,1667905,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.7716,'2016-10-12 14:46:37',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667906,1667906,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.6315,'2016-10-12 06:38:39',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667907,1667907,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.3451,'2016-10-12 06:11:17',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667909,1667909,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.1006,'2016-10-13 08:47:08',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667910,1667910,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.2139,'2016-10-13 08:46:11',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667912,1667912,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.7811,'2016-10-13 15:01:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667913,1667913,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.1652,'2016-10-14 12:47:47',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667914,1667914,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.4138,'2016-10-19 14:05:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667915,1667915,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.6208,'2016-10-10 08:37:49',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667916,1667916,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.7389,'2016-10-10 09:45:44',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667917,1667917,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1684,'2016-10-20 10:56:09',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667918,1667918,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.9593,'2016-10-12 14:44:36',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667919,1667919,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.0137,'2016-10-12 13:35:17',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667920,1667920,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.1213,'2016-10-12 06:38:39',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667921,1667921,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.0877,'2016-10-13 15:21:32',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667922,1667922,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.056,'2016-10-13 13:57:47',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667923,1667923,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.3655,'2016-10-08 10:17:33',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667924,1667924,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.9135,'2016-10-13 05:30:21',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667925,1667925,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.5041,'2016-10-08 10:28:10',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667926,1667926,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.0134,'2016-10-10 09:33:37',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667927,1667927,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.1472,'2016-10-10 12:16:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667928,1667928,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.7674,'2016-10-12 13:27:43',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667929,1667929,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.4335,'2016-10-13 08:46:11',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667930,1667930,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.3152,'2016-10-13 09:42:48',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667932,1667932,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.9433,'2016-10-16 09:32:59',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667933,1667933,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.8853,'2016-10-17 09:40:06',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667934,1667934,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.9302,'2016-10-17 09:45:43',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667935,1667935,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.2079,'2016-10-19 14:10:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667936,1667936,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.2072,'2016-10-19 06:36:27',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667937,1667937,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.7617,'2016-10-19 09:55:07',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667938,1667938,1,'following','archived without alert',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,'Claudia Gutierrez','cgutierr@das.uchile.cl',1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667940,1667940,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.2254,'2016-10-25 11:43:07',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667941,1667941,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.3597,'2016-10-25 11:44:13',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667942,1667942,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8478,'2016-10-25 13:05:15',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667944,1667944,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8745,'2016-10-25 14:34:46',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667945,1667945,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.3887,'2016-10-09 12:56:51',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667949,1667949,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.4292,'2016-10-24 14:39:09',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667950,1667950,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.3962,'2016-10-24 14:42:17',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667951,1667951,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.7631,'2016-10-25 06:50:46',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667952,1667952,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.485,'2016-10-25 06:30:01',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667953,1667953,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.1545,'2016-10-25 11:47:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667954,1667954,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.5803,'2016-10-25 11:56:18',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667955,1667955,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.9382,'2016-10-25 12:47:56',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667956,1667956,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.3824,'2016-10-25 14:27:34',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667957,1667957,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.2861,'2016-10-07 06:55:42',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667958,1667958,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.152,'2016-10-25 13:06:11',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667959,1667959,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.0756,'2016-10-09 10:38:38',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667960,1667960,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8159,'2016-10-09 10:40:29',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667961,1667961,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.887,'2016-10-10 09:34:34',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667962,1667962,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.712,'2016-10-10 10:59:58',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667964,1667964,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.9655,'2016-10-19 06:20:40',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667967,1667967,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.9999,'2016-10-25 11:54:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667970,1667970,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1749,'2016-10-25 13:04:19',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667971,1667971,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.3031,'2016-10-25 13:08:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667972,1667972,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.3467,'2016-10-25 13:07:06',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667973,1667973,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.2291,'2016-10-26 10:52:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667974,1667974,0,'pending observation','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667975,1667975,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.2108,'2016-10-27 06:27:55',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667976,1667976,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.1854,'2016-10-26 06:36:36',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667977,1667977,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.5422,'2016-10-27 10:35:39',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667978,1667978,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.3761,'2016-10-27 10:36:35',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667979,1667979,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.3781,'2016-10-27 10:37:31',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667980,1667980,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.1457,'2016-10-27 10:40:17',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667981,1667981,0,'pending observation','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667982,1667982,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8721,'2016-10-27 10:45:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667983,1667983,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.4584,'2016-10-27 10:02:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667984,1667984,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.4668,'2016-10-27 10:48:38',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667985,1667985,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.6778,'2016-10-27 10:50:30',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667986,1667986,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1461,'2016-10-27 10:49:34',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667987,1667987,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.4313,'2016-10-27 10:51:26',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667988,1667988,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.4546,'2016-10-27 10:52:22',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667989,1667989,0,'pending observation','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1667996,1667996,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.4445,'2016-10-11 07:05:47',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668008,1668008,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.4202,'2016-10-27 15:09:18',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668009,1668009,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1649,'2016-10-27 15:10:14',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668011,1668011,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8861,'2016-10-28 14:32:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668012,1668012,0,'archive','Pending Classification',1,'2016-10-31 12:17:05','2016-10-31 12:17:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.8799,'2016-10-28 05:49:55',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668013,1668013,0,'archive','Pending Classification',1,'2016-10-31 12:19:41','2016-10-31 12:19:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.7,'2016-10-23 01:30:43',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668514,1668514,0,'archive','Pending Classification',1,'2016-10-31 12:23:51','2016-10-31 12:23:51',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.27,'2016-10-24 10:39:22',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668520,1668520,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,13.71,'2016-10-17 12:59:20',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668521,1668521,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.5,'2016-10-13 04:57:50',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668522,1668522,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.78,'2016-09-19 18:38:02',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668523,1668523,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.93,'2016-10-12 16:07:04',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668524,1668524,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.48,'2016-10-12 17:44:47',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668526,1668526,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.17,'2016-10-12 05:35:02',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668527,1668527,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.57,'2016-10-13 07:31:54',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668528,1668528,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.77,'2016-10-12 09:51:21',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668529,1668529,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,16.5,'2016-10-12 11:02:49',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668530,1668530,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.32,'2016-10-13 01:10:10',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668531,1668531,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.69,'2016-10-12 05:35:46',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668532,1668532,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.96,'2016-10-12 17:01:23',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668533,1668533,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.01,'2016-10-18 15:11:53',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668534,1668534,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.62,'2016-10-18 22:48:58',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668535,1668535,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.57,'2016-09-16 15:46:53',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668536,1668536,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.78,'2016-10-17 23:29:02',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668537,1668537,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.37,'2016-10-19 19:38:50',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668538,1668538,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.67,'2016-10-18 11:35:16',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668539,1668539,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.79,'2016-10-20 06:13:51',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668540,1668540,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.81,'2016-10-18 00:56:24',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668541,1668541,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.92,'2016-10-20 07:37:59',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668542,1668542,0,'pending observation','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,'2016-11-01 14:50:09',NULL,0,17.7,'2016-10-19 19:04:27',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668543,1668543,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.79,'2016-10-13 00:26:11',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668545,1668545,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.95,'2016-10-21 00:02:50',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668546,1668546,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.82,'2016-10-17 14:15:52',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668547,1668547,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,16.47,'2016-10-18 04:31:25',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668548,1668548,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.62,'2016-10-20 03:18:59',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668549,1668549,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.39,'2016-10-19 14:56:33',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668551,1668551,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.22,'2016-10-19 08:11:54',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668552,1668552,0,'pending observation','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668553,1668553,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.33,'2016-10-19 03:02:00',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668554,1668554,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.43,'2016-10-19 05:45:29',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668555,1668555,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,17.45,'2016-10-21 20:25:11',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668556,1668556,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.04,'2016-10-23 10:49:28',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668557,1668557,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.15,'2016-10-07 12:28:07',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668558,1668558,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,16.04,'2016-09-24 10:15:31',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668559,1668559,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.6,'2016-10-20 12:54:13',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668560,1668560,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.61,'2016-10-13 03:38:11',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668561,1668561,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.1,'2016-10-23 23:23:27',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668563,1668563,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.89,'2016-10-21 14:04:22',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668564,1668564,0,'archive','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.81,'2016-10-21 11:16:51',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1668566,1668566,0,'pending observation','Pending Classification',1,'2016-10-31 12:32:41','2016-10-31 12:32:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1671496,1671496,0,'archive','Pending Classification',1,'2016-10-31 18:14:11','2016-10-31 18:14:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.26,'2016-10-25 05:25:58',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:41');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1671506,1671506,0,'pending observation','Pending Classification',1,'2016-10-31 18:14:11','2016-10-31 18:14:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:42');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1671511,1671511,1,'archive','archived without alert',1,'2016-10-31 18:14:11','2016-10-31 18:14:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.35,'2016-10-24 15:00:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:43');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1671516,1671516,1,'archive','archived without alert',1,'2016-10-31 18:14:11','2016-10-31 18:14:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.91,'2016-10-26 06:24:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:40:56');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1671525,1671525,0,'pending observation','Pending Classification',1,'2016-10-31 18:14:11','2016-10-31 18:14:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-10-31 18:16:52');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1672129,1672129,0,'archive','Pending Classification',1,'2016-10-31 18:17:20','2016-10-31 18:17:20',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.5163,'2016-10-28 14:23:40',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1672130,1672130,0,'pending observation','Pending Classification',1,'2016-10-31 18:17:20','2016-10-31 18:17:20',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1672133,1672133,0,'pending observation','Pending Classification',1,'2016-10-31 18:17:20','2016-10-31 18:17:20',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-11-08 15:21:49');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1672683,1672683,1,'archive','archived without alert',1,'2016-10-31 19:15:22','2016-10-31 19:15:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,18.44,'2016-10-24 11:49:33',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:20');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674543,1674543,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.6181,'2016-10-17 13:35:56',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674544,1674544,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1022,'2016-10-17 09:54:27',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674545,1674545,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.2061,'2016-10-19 10:59:20',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674546,1674546,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.8775,'2016-10-19 14:07:15',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674547,1674547,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.8021,'2016-10-19 14:11:53',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674548,1674548,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.6454,'2016-10-27 06:10:54',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674549,1674549,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.3135,'2016-10-27 06:39:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674550,1674550,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.0822,'2016-10-19 06:27:10',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674551,1674551,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8845,'2016-10-27 06:21:25',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674552,1674552,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.4012,'2016-10-19 06:36:27',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674553,1674553,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.7408,'2016-10-19 06:35:32',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674554,1674554,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.9242,'2016-10-19 06:35:32',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674555,1674555,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.967,'2016-10-19 07:43:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674556,1674556,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8411,'2016-10-19 09:48:30',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674557,1674557,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.4742,'2016-10-19 09:52:13',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674558,1674558,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.3565,'2016-10-19 09:56:03',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1674559,1674559,0,'archive','Pending Classification',1,'2016-10-31 21:21:10','2016-10-31 21:21:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.5973,'2016-10-19 09:58:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675061,1675061,1,'archive','external alert released',1,'2016-10-31 21:45:48','2016-10-31 21:45:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.9,'2016-10-30 21:28:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 18:22:38');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675093,1675093,0,'pending observation','Pending Classification',1,'2016-10-31 21:45:48','2016-10-31 21:45:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675162,1675162,0,'archive','Pending Classification',1,'2016-10-31 21:45:48','2016-10-31 21:45:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.1,'2016-10-27 14:38:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675205,1675205,1,'following','archived without alert',1,'2016-10-31 21:45:48','2016-10-31 21:45:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Claudia Gutierrez','cgutierr@das.uchile.cl',1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675207,1675207,0,'pending observation','Pending Classification',1,'2016-10-31 21:45:48','2016-10-31 21:45:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675213,1675213,0,'archive','Pending Classification',1,'2016-10-31 21:45:48','2016-10-31 21:45:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,14.818,'2016-10-30 03:55:26',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675214,1675214,1,'archive','external alert released',1,'2016-10-31 21:45:48','2016-10-31 21:45:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675216,1675216,1,'archive','external alert released',1,'2016-10-31 21:45:48','2016-10-31 21:45:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675218,1675218,1,'archive','external alert released',1,'2016-10-31 21:45:48','2016-10-31 21:45:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1675379,1675379,0,'pending observation','Pending Classification',1,'2016-10-31 22:15:22','2016-10-31 22:15:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:45');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1685038,1685038,0,'archive','Pending Classification',1,'2016-11-01 12:32:36','2016-11-01 12:32:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.24,'2016-10-21 11:41:48',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1685039,1685039,0,'archive','Pending Classification',1,'2016-11-01 12:32:36','2016-11-01 12:32:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.04,'2016-09-29 12:09:51',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1685040,1685040,0,'archive','Pending Classification',1,'2016-11-01 12:32:36','2016-11-01 12:32:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.72,'2016-10-21 23:19:39',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1685041,1685041,0,'pending observation','Pending Classification',1,'2016-11-01 12:32:36','2016-11-01 12:32:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1685042,1685042,0,'pending observation','Pending Classification',1,'2016-11-01 12:32:36','2016-11-01 12:32:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1685043,1685043,0,'archive','Pending Classification',1,'2016-11-01 12:32:36','2016-11-01 12:32:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,14.97,'2016-10-26 09:53:42',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1685044,1685044,0,'pending observation','Pending Classification',1,'2016-11-01 12:32:36','2016-11-01 12:32:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1685045,1685045,0,'pending observation','Pending Classification',1,'2016-11-01 12:32:36','2016-11-01 12:32:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1685046,1685046,0,'archive','Pending Classification',1,'2016-11-01 12:32:36','2016-11-01 12:32:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.41,'2016-10-22 15:09:39',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1691397,1691397,0,'archive','Pending Classification',1,'2016-11-01 22:03:05','2016-11-01 22:03:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.76,'2016-10-22 22:21:37',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1691398,1691398,0,'archive','Pending Classification',1,'2016-11-01 22:03:05','2016-11-01 22:03:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.53,'2016-10-22 16:28:48',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1691399,1691399,0,'archive','Pending Classification',1,'2016-11-01 22:03:05','2016-11-01 22:03:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.89,'2016-10-22 15:08:23',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1691400,1691400,0,'pending observation','Pending Classification',1,'2016-11-01 22:03:05','2016-11-01 22:03:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1691401,1691401,0,'archive','Pending Classification',1,'2016-11-01 22:03:05','2016-11-01 22:03:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.54,'2016-10-26 19:07:28',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1691402,1691402,0,'archive','Pending Classification',1,'2016-11-01 22:16:07','2016-11-01 22:16:07',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.83,'2016-11-01 04:55:15',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-02 00:20:08');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1691406,1691406,0,'archive','Pending Classification',1,'2016-11-01 22:16:07','2016-11-01 22:16:07',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.7,'2016-10-28 04:53:01',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-02 00:20:09');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1694480,1694480,0,'archive','Pending Classification',1,'2016-11-02 03:38:06','2016-11-02 03:38:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.4396,'2016-10-27 15:10:14',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1694481,1694481,0,'archive','Pending Classification',1,'2016-11-02 03:38:06','2016-11-02 03:38:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8158,'2016-10-28 15:11:06',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1694482,1694482,0,'archive','Pending Classification',1,'2016-11-02 03:38:06','2016-11-02 03:38:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.3144,'2016-10-29 10:02:44',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1694483,1694483,0,'archive','Pending Classification',1,'2016-11-02 03:38:06','2016-11-02 03:38:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.3171,'2016-10-29 06:35:35',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1694484,1694484,0,'pending observation','Pending Classification',1,'2016-11-02 03:38:06','2016-11-02 03:38:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1699508,1699508,1,'archive','archived without alert',1,'2016-11-02 11:14:41','2016-11-02 11:14:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,19.08,'2016-10-24 08:41:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 15:00:37');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702494,1702494,0,'pending observation','Pending Classification',1,'2016-11-02 15:22:37','2016-11-02 15:22:37',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702546,1702546,1,'archive','archived without alert',1,'2016-11-02 15:22:37','2016-11-02 15:22:37',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.571,'2016-10-23 08:35:25',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702590,1702590,1,'review for followup','pessto classification released',1,'2016-11-02 15:22:37','2016-11-02 15:22:37',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702800,1702800,0,'archive','Pending Classification',1,'2016-11-02 15:32:02','2016-11-02 15:32:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.51,'2016-10-24 15:23:15',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702801,1702801,0,'pending observation','Pending Classification',1,'2016-11-02 15:32:02','2016-11-02 15:32:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702802,1702802,0,'pending observation','Pending Classification',1,'2016-11-02 15:32:02','2016-11-02 15:32:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702804,1702804,0,'archive','Pending Classification',1,'2016-11-02 15:32:02','2016-11-02 15:32:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.84,'2016-09-22 23:41:45',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702805,1702805,0,'archive','Pending Classification',1,'2016-11-02 15:32:02','2016-11-02 15:32:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.38,'2016-09-27 11:53:24',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702850,1702850,0,'archive','Pending Classification',1,'2016-11-02 15:50:14','2016-11-02 15:50:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.4,'2016-10-31 03:36:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:46');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1702858,1702858,1,'archive','external alert released',1,'2016-11-02 15:50:14','2016-11-02 15:50:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1706066,1706066,0,'archive','Pending Classification',1,'2016-11-02 19:25:11','2016-11-02 19:25:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.23,'2016-11-01 08:31:12',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1706601,1706601,0,'archive','Pending Classification',1,'2016-11-02 20:24:36','2016-11-02 20:24:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.5,'2016-11-02 08:00:47',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1719902,1719902,0,'archive','Pending Classification',1,'2016-11-03 00:18:48','2016-11-03 00:18:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,15.15,'2016-11-02 09:37:26',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:47');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1719907,1719907,0,'archive','Pending Classification',1,'2016-11-03 00:18:48','2016-11-03 00:18:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.31,'2016-07-12 13:54:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:48');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1721011,1721011,1,'archive','external alert released',1,'2016-11-03 00:55:49','2016-11-03 00:55:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1721012,1721012,1,'archive','external alert released',1,'2016-11-03 00:55:49','2016-11-03 00:55:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1728570,1728570,0,'archive','Pending Classification',1,'2016-11-03 11:26:14','2016-11-03 11:26:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.59,'2016-10-23 09:37:26',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1728571,1728571,0,'archive','Pending Classification',1,'2016-11-03 11:26:14','2016-11-03 11:26:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.9,'2016-10-23 15:54:43',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1729660,1729660,0,'archive','Pending Classification',1,'2016-11-03 13:14:38','2016-11-03 13:14:38',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.23,'2016-10-29 08:38:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:49');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1730184,1730184,1,'archive','archived without alert',1,'2016-11-03 13:25:25','2016-11-03 13:25:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.15,'2016-11-03 10:04:48',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1730692,1730692,0,'archive','Pending Classification',1,'2016-11-03 14:26:10','2016-11-03 14:26:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.9,'2016-10-26 00:54:43',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1731706,1731706,0,'archive','Pending Classification',1,'2016-11-03 14:58:44','2016-11-03 14:58:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.48,'2016-10-24 18:34:33',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1731708,1731708,0,'archive','Pending Classification',1,'2016-11-03 14:58:44','2016-11-03 14:58:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.77,'2016-10-25 07:36:28',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1731709,1731709,0,'pending observation','Pending Classification',1,'2016-11-03 14:58:44','2016-11-03 14:58:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1732220,1732220,0,'pending observation','Pending Classification',1,'2016-11-03 15:01:24','2016-11-03 15:01:24',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1732221,1732221,0,'archive','Pending Classification',1,'2016-11-03 15:01:24','2016-11-03 15:01:24',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.25,'2016-10-24 23:29:16',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1732224,1732224,0,'archive','Pending Classification',1,'2016-11-03 15:11:32','2016-11-03 15:11:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.39,'2016-10-25 09:14:24',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1733143,1733143,0,'archive','Pending Classification',1,'2016-11-03 15:31:23','2016-11-03 15:31:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.71,'2016-10-25 21:37:38',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1733144,1733144,0,'archive','Pending Classification',1,'2016-11-03 15:31:23','2016-11-03 15:31:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.47,'2016-10-24 21:31:15',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1733145,1733145,0,'archive','Pending Classification',1,'2016-11-03 15:31:23','2016-11-03 15:31:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.77,'2016-10-25 15:33:14',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1733658,1733658,0,'pending observation','Pending Classification',1,'2016-11-03 16:11:56','2016-11-03 16:11:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1733659,1733659,0,'archive','Pending Classification',1,'2016-11-03 16:11:56','2016-11-03 16:11:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,18.09,'2016-10-19 04:01:55',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1734203,1734203,0,'pending observation','Pending Classification',1,'2016-11-03 17:57:32','2016-11-03 17:57:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:41:00');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1734207,1734207,0,'pending observation','Pending Classification',1,'2016-11-03 17:57:32','2016-11-03 17:57:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:41:01');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1734215,1734215,1,'archive','archived without alert',1,'2016-11-03 17:57:32','2016-11-03 17:57:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,17.04,'2016-11-03 06:40:31',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:41:02');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1734220,1734220,0,'pending observation','Pending Classification',1,'2016-11-03 17:57:32','2016-11-03 17:57:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:41:03');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1734225,1734225,1,'archive','archived without alert',1,'2016-11-03 17:57:32','2016-11-03 17:57:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,18.3,'2016-10-30 06:01:32',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:41:04');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1734232,1734232,0,'pending observation','Pending Classification',1,'2016-11-03 17:57:32','2016-11-03 17:57:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-04 20:41:05');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1737616,1737616,1,'archive','archived without alert',1,'2016-11-04 00:00:02','2016-11-04 00:00:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,17.55,'2016-11-03 10:23:35',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:50');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1737620,1737620,0,'Inbox','Pending Classification',1,'2016-11-04 00:00:02','2016-11-04 00:00:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:51');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1737624,1737624,1,'archive','archived without alert',1,'2016-11-04 00:00:02','2016-11-04 00:00:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,18.08,'2016-11-03 10:12:30',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:52');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738143,1738143,0,'pending observation','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738144,1738144,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.8102,'2016-10-25 06:54:28',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738145,1738145,0,'pending observation','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738146,1738146,0,'pending observation','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738147,1738147,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1621,'2016-10-25 10:34:59',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738148,1738148,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.1268,'2016-10-25 10:34:03',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738149,1738149,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.3057,'2016-10-25 10:37:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738150,1738150,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.1422,'2016-10-25 11:49:46',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738151,1738151,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.2298,'2016-10-25 11:48:51',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738152,1738152,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.432,'2016-10-25 12:39:35',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738153,1738153,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.6064,'2016-10-25 13:08:58',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738154,1738154,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.3291,'2016-10-25 13:08:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738155,1738155,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.3494,'2016-10-28 14:35:45',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738156,1738156,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8913,'2016-10-29 10:08:25',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738157,1738157,0,'archive','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.0335,'2016-10-30 06:31:00',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1738158,1738158,0,'pending observation','Pending Classification',1,'2016-11-04 00:23:49','2016-11-04 00:23:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1746515,1746515,0,'archive','Pending Classification',1,'2016-11-04 12:16:23','2016-11-04 12:16:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,22.3172,'2016-10-25 03:53:17',1,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1748702,1748702,1,'archive','archived without alert',1,'2016-11-04 14:11:04','2016-11-04 14:11:04',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,16.8,'2016-11-04 07:26:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1749472,1749472,0,'archive','Pending Classification',1,'2016-11-04 15:17:22','2016-11-04 15:17:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.7305,'2016-11-01 09:22:28',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1749473,1749473,0,'archive','Pending Classification',1,'2016-11-04 15:17:22','2016-11-04 15:17:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.1986,'2016-11-01 09:30:08',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1749474,1749474,0,'archive','Pending Classification',1,'2016-11-04 15:17:22','2016-11-04 15:17:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.2679,'2016-11-01 11:42:13',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1750552,1750552,0,'pending observation','Pending Classification',1,'2016-11-04 16:57:18','2016-11-04 16:57:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:52');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1752763,1752763,0,'archive','Pending Classification',1,'2016-11-04 19:10:56','2016-11-04 19:10:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19,'2016-11-03 09:02:57',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1756399,1756399,0,'pending observation','Pending Classification',1,'2016-11-04 23:36:49','2016-11-04 23:36:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:21');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1765838,1765838,0,'pending observation','Pending Classification',1,'2016-11-05 12:57:44','2016-11-05 12:57:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 14:00:55');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767603,1767603,0,'archive','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.0613,'2016-11-01 09:16:53',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767604,1767604,0,'archive','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.3497,'2016-11-01 09:16:53',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767605,1767605,0,'archive','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8019,'2016-11-01 09:22:28',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767606,1767606,0,'archive','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.092,'2016-11-01 09:21:33',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767607,1767607,0,'archive','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.3113,'2016-11-01 08:45:34',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767608,1767608,0,'archive','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8551,'2016-11-01 09:24:19',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767609,1767609,0,'archive','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.8421,'2016-11-01 14:48:48',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767610,1767610,0,'archive','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,21.1001,'2016-11-03 05:42:39',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767611,1767611,0,'archive','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.8079,'2016-11-03 06:12:23',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767612,1767612,0,'pending observation','Pending Classification',1,'2016-11-05 15:17:31','2016-11-05 15:17:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767614,1767614,1,'archive','archived without alert',1,'2016-11-05 15:57:27','2016-11-05 15:57:27',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,17.43,'2016-11-04 14:31:22',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 18:21:22');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1767619,1767619,1,'following','archived without alert',1,'2016-11-05 15:57:27','2016-11-05 15:57:27',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Georgios Dimitriadis','gd1g13@soton.ac.uk',1,0,NULL,NULL,4,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-05 17:00:21');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1770434,1770434,0,'archive','Pending Classification',1,'2016-11-05 19:10:19','2016-11-05 19:10:19',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,19.79,'2016-10-28 13:36:28',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1770435,1770435,0,'archive','Pending Classification',1,'2016-11-05 19:10:19','2016-11-05 19:10:19',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,1,20.83,'2016-10-27 09:47:31',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1772539,1772539,0,'Inbox','Pending Classification',1,'2016-11-05 23:59:25','2016-11-05 23:59:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:53');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1773622,1773622,0,'archive','Pending Classification',1,'2016-11-06 00:33:03','2016-11-06 00:33:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,15.8,'2016-11-05 13:26:24',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1776244,1776244,0,'pending observation','Pending Classification',1,'2016-11-06 09:11:27','2016-11-06 09:11:27',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1778016,1778016,0,'pending observation','Pending Classification',1,'2016-11-06 11:20:41','2016-11-06 11:20:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,3,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1781760,1781760,1,'archive','archived without alert',1,'2016-11-06 16:10:48','2016-11-06 16:10:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,1,'2016-11-09 08:31:03',NULL,0,19.1467,'2016-11-06 07:04:48',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 17:00:11');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1782325,1782325,0,'archive','Pending Classification',1,'2016-11-06 17:58:32','2016-11-06 17:58:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.68,'2016-11-06 06:38:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:54');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1782331,1782331,0,'archive','Pending Classification',1,'2016-11-06 17:58:32','2016-11-06 17:58:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.41,'2016-11-06 07:39:48',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:56');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1782337,1782337,0,'archive','Pending Classification',1,'2016-11-06 17:58:32','2016-11-06 17:58:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.61,'2016-11-06 05:29:38',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:57');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1784975,1784975,0,'archive','Pending Classification',1,'2016-11-06 21:58:25','2016-11-06 21:58:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,16.35,'2016-11-06 08:10:16',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:57');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1790213,1790213,0,'Inbox','Pending Classification',1,'2016-11-07 06:09:15','2016-11-07 06:09:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1790737,1790737,0,'Inbox','Pending Classification',1,'2016-11-07 06:21:41','2016-11-07 06:21:41',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1793372,1793372,0,'archive','Pending Classification',1,'2016-11-07 10:57:22','2016-11-07 10:57:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.06,'2016-10-29 14:29:09',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 15:05:58');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1796085,1796085,0,'Inbox','Pending Classification',1,'2016-11-07 14:09:32','2016-11-07 14:09:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1796615,1796615,0,'Inbox','Pending Classification',1,'2016-11-07 15:11:27','2016-11-07 15:11:27',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-11-08 15:05:59');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1796616,1796616,0,'archive','Pending Classification',1,'2016-11-07 15:11:27','2016-11-07 15:11:27',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.7,'2016-10-26 06:59:02',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1796617,1796617,0,'Inbox','Pending Classification',1,'2016-11-07 15:11:27','2016-11-07 15:11:27',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1797672,1797672,0,'Inbox','Pending Classification',1,'2016-11-07 16:10:04','2016-11-07 16:10:04',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1797673,1797673,0,'Inbox','Pending Classification',1,'2016-11-07 16:10:04','2016-11-07 16:10:04',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1797674,1797674,0,'Inbox','Pending Classification',1,'2016-11-07 16:10:04','2016-11-07 16:10:04',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1798213,1798213,0,'Inbox','Pending Classification',1,'2016-11-07 17:09:54','2016-11-07 17:09:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1800853,1800853,0,'Inbox','Pending Classification',1,'2016-11-07 21:53:14','2016-11-07 21:53:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1800854,1800854,0,'archive','Pending Classification',1,'2016-11-07 21:53:14','2016-11-07 21:53:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,17.22,'2016-10-30 23:56:12',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1800855,1800855,0,'archive','Pending Classification',1,'2016-11-07 21:53:14','2016-11-07 21:53:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.55,'2016-10-29 06:17:55',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1800857,1800857,0,'Inbox','Pending Classification',1,'2016-11-07 21:53:14','2016-11-07 21:53:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1800858,1800858,0,'Inbox','Pending Classification',1,'2016-11-07 21:53:14','2016-11-07 21:53:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1801388,1801388,0,'Inbox','Pending Classification',1,'2016-11-07 22:22:00','2016-11-07 22:22:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1801389,1801389,0,'Inbox','Pending Classification',1,'2016-11-07 22:22:00','2016-11-07 22:22:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1808202,1808202,0,'Inbox','Pending Classification',1,'2016-11-08 09:18:00','2016-11-08 09:18:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,1,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1810839,1810839,0,'archive','Pending Classification',1,'2016-11-08 12:35:01','2016-11-08 12:35:01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.23,'2016-11-01 13:36:04',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1810840,1810840,0,'Inbox','Pending Classification',1,'2016-11-08 12:35:01','2016-11-08 12:35:01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1811409,1811409,0,'Inbox','Pending Classification',1,'2016-11-08 13:11:09','2016-11-08 13:11:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1811942,1811942,0,'Inbox','Pending Classification',1,'2016-11-08 14:58:45','2016-11-08 14:58:45',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,1,'2016-11-08 17:00:12');
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813911,1813911,0,'Inbox','Pending Classification',1,'2016-11-08 15:15:55','2016-11-08 15:15:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813913,1813913,0,'Inbox','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813914,1813914,0,'Inbox','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813915,1813915,0,'Inbox','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813916,1813916,0,'Inbox','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813917,1813917,0,'Inbox','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813918,1813918,0,'Inbox','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813919,1813919,0,'Inbox','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813920,1813920,0,'Inbox','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813921,1813921,0,'archive','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,19.93,'2016-11-06 07:27:50',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813922,1813922,0,'archive','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.2934,'2016-11-07 04:52:47',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813923,1813923,0,'archive','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.5807,'2016-11-07 04:53:28',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1813924,1813924,0,'Inbox','Pending Classification',1,'2016-11-08 15:16:37','2016-11-08 15:16:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815068,1815068,0,'archive','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.05,'2016-11-06 14:52:48',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815073,1815073,0,'Inbox','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815076,1815076,0,'Inbox','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815077,1815077,0,'Inbox','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815082,1815082,0,'archive','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.58,'2016-11-06 07:14:52',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815085,1815085,0,'archive','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,18.24,'2016-11-06 06:24:28',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815086,1815086,0,'archive','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.92,'2016-11-06 14:45:36',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815087,1815087,0,'archive','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.95,'2016-11-06 14:44:09',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815088,1815088,0,'archive','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.6,'2016-11-06 14:47:02',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815089,1815089,0,'archive','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,21.32,'2016-11-06 14:45:36',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815090,1815090,0,'archive','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,'2016-11-09 08:31:03',NULL,0,20.21,'2016-11-06 14:48:28',NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815091,1815091,0,'Inbox','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815092,1815092,0,'Inbox','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815093,1815093,0,'Inbox','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815094,1815094,0,'Inbox','Pending Classification',1,'2016-11-08 16:21:23','2016-11-08 16:21:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1815798,1815798,0,'Inbox','Pending Classification',1,'2016-11-08 17:10:31','2016-11-08 17:10:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1816345,1816345,0,'Inbox','Pending Classification',1,'2016-11-08 18:16:15','2016-11-08 18:16:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,`ogle_lightcurve`,`ogle_subtracted_stamp`,`ogle_reference_stamp`,`mls_stamp`,`sss_stamp`,`css_lightcurve`,`sss_lightcurve`,`mls_lightcurve`,`ps1_subtracted_stamp`,`ps1_target_stamp`,`ps1_reference_stamp`,`skymapper_reference_stamp`,`skymapper_subtracted_stamp`,`skymapper_target_stamp`,`ogle_color_context_stamp`,`pi_name`,`pi_email`,`master_pessto_lightcurve`,`classification_finalised`,`master_stamp`,`bsl_stamp`,`observationPriority`,`lastTimeReviewed`,`mpcMatch`,`snoozed`,`lastReviewedMag`,`lastReviewedMagDate`,`des_target_stamp`,`des_reference_stamp`,`des_subtracted_stamp`,`gaia_stamp`,`ps1_map`,`photometry_catalogue_release`,`transient_catalogue_release`,`followup_target_release`,`pessto_citations`,`atlas_target_stamp`,`atlas_subtracted_stamp`,`atlas_reference_stamp`,`atlas_fp_lightcurve`) VALUES (1816346,1816346,0,'Inbox','Pending Classification',1,'2016-11-08 18:16:15','2016-11-08 18:16:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,2,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `pesstoObjects` (`pesstoObjectsId`,`transientBucketId`,`classifiedFlag`,`marshallWorkflowLocation`,`alertWorkflowLocation`,`publicStatus`,`dateAdded`,`dateLastModified`,`finderChartLocalUrl`,`lsq_stamp`,`css_stamp`,`lsq_lightcurve`,`ogle_target_stamp`,