## Module for command simplification when using Python with the AWR Design Environment 

AWR Design Environment Python module that wraps lower level API commands into higher level function calls

# Installation
    pip install pyawr-utils

# Upgrade

    pip install --upgrade pyawr-utils

# Requirements
* Python >= 3.9
* pyawr
* numpy

# Usage

    See https://kb.awr.com/display/awrscripts/Pyawr+Utilities for details
	
# History

# 0.30
* Added Yield Analysis
# 0.22
* Added Project Open and Close
* Added Project Save As, Project Save As Version
* Added goal measurement name and goal source document read
# 0.21
* Changed how element is enabled/disabled to be consistent with other enable/disable commands
* Added read for element enabled state
* Added parameter value float for system diagrams
* Optimization Variables: only read if element or equation is enabled
* Added Show Files/Directories
* Optinal command to bypass initializations when calling the Project class
* Read/Parse Opimization Log File
# 0.20
* Add/Remove Global Definitions Documents
* Edit element parameters and equations in Global Definitions Documents
* Read/Set Element Parameter optimization constraints
* Read/Set Equation optimization constraints
* Read optimization variables
* Read optimization goals
* Modify optimization goals
* Add/Remove optimization goals
* Read/Set Optimizer options
* Run Optimization
* equation enable/disable
# 0.16
* Added modify_measurement
# 0.15
* project_path: replace '\' with '/'
* Added measurement_doc_source
* Added element_enable
* Added element_disable
* Added element_nodes_dict
* Added add_wire
* Added remove_wire
* Added wire_segments_dict
* Fixed bugs with system simulate
# 0.14
* Element dictionary update automatically when element is added or removed
# 0.13
* Added add_element(), remove element(), element xy_position()
* Fixed error in remove_schematic()
# 0.12
* Added equations to Schematics
# 0.11
* Fixed PyPI Installation and Upgrade commands
# 0.1
* Beta version


