# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['flake8_annotations']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=21.4', 'flake8>=5.0']

entry_points = \
{'flake8.extension': ['ANN = flake8_annotations.checker:TypeHintChecker']}

setup_kwargs = {
    'name': 'flake8-annotations',
    'version': '3.0.0',
    'description': 'Flake8 Type Annotation Checks',
    'long_description': '# flake8-annotations\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/flake8-annotations/3.0.0?logo=python&logoColor=FFD43B)](https://pypi.org/project/flake8-annotations/)\n[![PyPI](https://img.shields.io/pypi/v/flake8-annotations?logo=Python&logoColor=FFD43B)](https://pypi.org/project/flake8-annotations/)\n[![PyPI - License](https://img.shields.io/pypi/l/flake8-annotations?color=magenta)](https://github.com/sco1/flake8-annotations/blob/main/LICENSE)\n[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/sco1/flake8-annotations/main.svg)](https://results.pre-commit.ci/latest/github/sco1/flake8-annotations/main)\n[![Open in Visual Studio Code](https://img.shields.io/badge/Open%20in-VSCode.dev-blue)](https://github.dev/sco1/flake8-annotations)\n\n`flake8-annotations` is a plugin for [Flake8](http://flake8.pycqa.org/en/latest/) that detects the absence of [PEP 3107-style](https://www.python.org/dev/peps/pep-3107/) function annotations.\n\nWhat this won\'t do: replace [mypy](http://mypy-lang.org/), check type comments (see: [PEP 484](https://peps.python.org/pep-0484/#type-comments)), check variable annotations (see: [PEP 526](https://www.python.org/dev/peps/pep-0526/)), or respect stub files.\n\n## Installation\nInstall from PyPi with your favorite `pip` invocation:\n\n```bash\n$ pip install flake8-annotations\n```\n\nIt will then be run automatically as part of flake8.\n\nYou can verify it\'s being picked up by invoking the following in your shell:\n\n\n<!-- [[[cog\nimport cog\nfrom subprocess import PIPE, run\nout = run(["flake8", "--version"], stdout=PIPE, encoding="ascii")\nver_str = out.stdout.replace("\\n", "")\ncog.out(\n    f"```bash\\n$ flake8 --version\\n{ver_str}\\n```"\n)\n]]] -->\n```bash\n$ flake8 --version\n6.0.0 (flake8-annotations: 3.0.0, mccabe: 0.7.0, pycodestyle: 2.10.0, pyflakes: 3.0.1) CPython 3.11.0 on Darwin\n```\n<!-- [[[end]]] -->\n\n## Table of Warnings\nWith the exception of `ANN4xx`-level warnings, all warnings are enabled by default.\n\n### Function Annotations\n| ID       | Description                                   |\n|----------|-----------------------------------------------|\n| `ANN001` | Missing type annotation for function argument |\n| `ANN002` | Missing type annotation for `*args`           |\n| `ANN003` | Missing type annotation for `**kwargs`        |\n\n### Method Annotations\n| ID       | Description                                                  |\n|----------|--------------------------------------------------------------|\n| `ANN101` | Missing type annotation for `self` in method<sup>1</sup>     |\n| `ANN102` | Missing type annotation for `cls` in classmethod<sup>1</sup> |\n\n### Return Annotations\n| ID       | Description                                           |\n|----------|-------------------------------------------------------|\n| `ANN201` | Missing return type annotation for public function    |\n| `ANN202` | Missing return type annotation for protected function |\n| `ANN203` | Missing return type annotation for secret function    |\n| `ANN204` | Missing return type annotation for special method     |\n| `ANN205` | Missing return type annotation for staticmethod       |\n| `ANN206` | Missing return type annotation for classmethod        |\n\n### Opinionated Warnings\nThese warnings are disabled by default.\n| ID       | Description                                                            |\n|----------|------------------------------------------------------------------------|\n| `ANN401` | Dynamically typed expressions (typing.Any) are disallowed.<sup>2</sup> |\n| `ANN402` | Type comments are disallowed.                                          |\n\nUse [`extend-select`](https://flake8.pycqa.org/en/latest/user/options.html#cmdoption-flake8-extend-ignore) to enable opinionated warnings without overriding other implicit configurations<sup>3</sup>.\n\n**Notes:**\n1. See: [PEP 484](https://www.python.org/dev/peps/pep-0484/#annotating-instance-and-class-methods) and [PEP 563](https://www.python.org/dev/peps/pep-0563/) for suggestions on annotating `self` and `cls` arguments\n2. See: [Dynamic Typing Caveats](#dynamic-typing-caveats)\n3. Common pitfall: the use of [`ignore`](https://flake8.pycqa.org/en/latest/user/options.html#cmdoption-flake8-ignore) will enable all implicitly disabled warnings\n\n## Configuration Options\nSome opinionated flags are provided to tailor the linting errors emitted.\n\n### `--suppress-none-returning`: `bool`\nSuppress `ANN200`-level errors for functions that meet one of the following criteria:\n  * Contain no `return` statement, or\n  * Explicit `return` statement(s) all return `None` (explicitly or implicitly).\n\nDefault: `False`\n\n### `--suppress-dummy-args`: `bool`\nSuppress `ANN000`-level errors for dummy arguments, defined as `_`.\n\nDefault: `False`\n\n### `--allow-untyped-defs`: `bool`\nSuppress all errors for dynamically typed functions. A function is considered dynamically typed if it does not contain any type hints.\n\nDefault: `False`\n\n### `--allow-untyped-nested`: `bool`\nSuppress all errors for dynamically typed nested functions. A function is considered dynamically typed if it does not contain any type hints.\n\nDefault: `False`\n\n### `--mypy-init-return`: `bool`\nAllow omission of a return type hint for `__init__` if at least one argument is annotated. See [mypy\'s documentation](https://mypy.readthedocs.io/en/stable/class_basics.html?#annotating-init-methods) for additional details.\n\nDefault: `False`\n\n### `--dispatch-decorators`: `list[str]`\nComma-separated list of decorators flake8-annotations should consider as dispatch decorators. Linting errors are suppressed for functions decorated with at least one of these functions.\n\nDecorators are matched based on their attribute name. For example, `"singledispatch"` will match any of the following:\n  * `import functools; @functools.singledispatch`\n  * `import functools as <alias>; @<alias>.singledispatch`\n  * `from functools import singledispatch; @singledispatch`\n\n**NOTE:** Deeper imports, such as `a.b.singledispatch` are not supported.\n\nSee: [Generic Functions](#generic-functions) for additional information.\n\nDefault: `"singledispatch, singledispatchmethod"`\n\n### `--overload-decorators`: `list[str]`\nComma-separated list of decorators flake8-annotations should consider as [`typing.overload`](https://docs.python.org/3/library/typing.html#typing.overload) decorators.\n\nDecorators are matched based on their attribute name. For example, `"overload"` will match any of the following:\n  * `import typing; @typing.overload`\n  * `import typing as <alias>; @<alias>.overload`\n  * `from typing import overload; @overload`\n\n**NOTE:** Deeper imports, such as `a.b.overload` are not supported.\n\nSee: [The `typing.overload` Decorator](#the-typingoverload-decorator) for additional information.\n\nDefault: `"overload"`\n\n### `--allow-star-arg-any`\nSuppress `ANN401` for dynamically typed `*args` and `**kwargs`.\n\nDefault: `False`\n\n## Generic Functions\nPer the Python Glossary, a [generic function](https://docs.python.org/3/glossary.html#term-generic-function) is defined as:\n\n> A function composed of multiple functions implementing the same operation for different types. Which implementation should be used during a call is determined by the dispatch algorithm.\n\nIn the standard library we have some examples of decorators for implementing these generic functions: [`functools.singledispatch`](https://docs.python.org/3/library/functools.html#functools.singledispatch) and [`functools.singledispatchmethod`](https://docs.python.org/3/library/functools.html#functools.singledispatchmethod). In the spirit of the purpose of these decorators, errors for missing annotations for functions decorated with at least one of these are ignored.\n\nFor example, this code:\n\n```py\nimport functools\n\n@functools.singledispatch\ndef foo(a):\n    print(a)\n\n@foo.register\ndef _(a: list) -> None:\n    for idx, thing in enumerate(a):\n        print(idx, thing)\n```\n\nWill not raise any linting errors for `foo`.\n\nDecorator(s) to treat as defining generic functions may be specified by the [`--dispatch-decorators`](#--dispatch-decorators-liststr) configuration option.\n\n## The `typing.overload` Decorator\nPer the [`typing`](https://docs.python.org/3/library/typing.html#typing.overload) documentation:\n\n> The `@overload` decorator allows describing functions and methods that support multiple different combinations of argument types. A series of `@overload`-decorated definitions must be followed by exactly one non-`@overload`-decorated definition (for the same function/method).\n\nIn the spirit of the purpose of this decorator, errors for missing annotations for non-`@overload`-decorated functions are ignored if they meet this criteria.\n\nFor example, this code:\n\n```py\nimport typing\n\n\n@typing.overload\ndef foo(a: int) -> int:\n    ...\n\ndef foo(a):\n    ...\n```\n\nWill not raise linting errors for missing annotations for the arguments & return of the non-decorated `foo` definition.\n\nDecorator(s) to treat as `typing.overload` may be specified by the [`--overload-decorators`](#--overload-decorators-liststr) configuration option.\n\n## Dynamic Typing Caveats\nSupport is only provided for the following patterns:\n  * `from typing import any; foo: Any`\n  * `import typing; foo: typing.Any`\n  * `import typing as <alias>; foo: <alias>.Any`\n\nNested dynamic types (e.g. `typing.Tuple[typing.Any]`) and redefinition (e.g. `from typing import Any as Foo`) will not be identified.\n\n## Contributing\n\n### Development Environment\nThis project uses [Poetry](https://python-poetry.org/) to manage dependencies. With your fork cloned to your local machine, you can install the project and its dependencies to create a development environment using:\n\n```bash\n$ poetry install\n```\n\nNote: An editable installation of `flake8-annotations` in the developer environment is required in order for the plugin to be registered for Flake8. By default, Poetry includes an editable install of the project itself when `poetry install` is invoked.\n\nA [pre-commit](https://pre-commit.com) configuration is also provided to create a pre-commit hook so linting errors aren\'t committed:\n\n```bash\n$ pre-commit install\n```\n\n### Testing & Coverage\nA [pytest](https://docs.pytest.org/en/latest/) suite is provided, with coverage reporting from [pytest-cov](https://github.com/pytest-dev/pytest-cov). A [tox](https://github.com/tox-dev/tox/) configuration is provided to test across all supported versions of Python. Testing will be skipped for Python versions that cannot be found.\n\n```bash\n$ tox\n```\n\nDetails on missing coverage, including in the test suite, is provided in the report to allow the user to generate additional tests for full coverage.\n',
    'author': 'S Co1',
    'author_email': 'sco1.git@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/sco1/flake8-annotations',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
