import holoviews as hv
import panel as pn
import numpy as np

hv.extension('bokeh')


def sine(frequency, phase, amplitude):
    xs = np.linspace(0, np.pi * 4)
    return hv.Curve((xs, np.sin(frequency * xs + phase) * amplitude)).options(responsive=True)


if __name__ == '__main__':
    ranges = dict(frequency=(1, 5), phase=(-np.pi, np.pi), amplitude=(-2, 2), y=(-2, 2))
    dmap = hv.DynamicMap(sine, kdims=['frequency', 'phase', 'amplitude']).redim.range(**ranges)
    pn.serve(dmap, port=5006, websocket_origin=["localhost:5000", "127.0.0.1:5000"], show=False)
