# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class AttachmentMetaData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'content_type': 'str',
        'content_length': 'int',
        'id': 'str'
    }

    attribute_map = {
        'name': 'name',
        'content_type': 'contentType',
        'content_length': 'contentLength',
        'id': 'id'
    }

    def __init__(self, name=None, content_type=None, content_length=None, id=None, local_vars_configuration=None):  # noqa: E501
        """AttachmentMetaData - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._content_type = None
        self._content_length = None
        self._id = None
        self.discriminator = None

        self.name = name
        self.content_type = content_type
        self.content_length = content_length
        self.id = id

    @property
    def name(self):
        """Gets the name of this AttachmentMetaData.  # noqa: E501

        Name of attachment if given  # noqa: E501

        :return: The name of this AttachmentMetaData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AttachmentMetaData.

        Name of attachment if given  # noqa: E501

        :param name: The name of this AttachmentMetaData.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def content_type(self):
        """Gets the content_type of this AttachmentMetaData.  # noqa: E501

        Content type of attachment such as `image/png`  # noqa: E501

        :return: The content_type of this AttachmentMetaData.  # noqa: E501
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """Sets the content_type of this AttachmentMetaData.

        Content type of attachment such as `image/png`  # noqa: E501

        :param content_type: The content_type of this AttachmentMetaData.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and content_type is None:  # noqa: E501
            raise ValueError("Invalid value for `content_type`, must not be `None`")  # noqa: E501

        self._content_type = content_type

    @property
    def content_length(self):
        """Gets the content_length of this AttachmentMetaData.  # noqa: E501

        Size of attachment in bytes  # noqa: E501

        :return: The content_length of this AttachmentMetaData.  # noqa: E501
        :rtype: int
        """
        return self._content_length

    @content_length.setter
    def content_length(self, content_length):
        """Sets the content_length of this AttachmentMetaData.

        Size of attachment in bytes  # noqa: E501

        :param content_length: The content_length of this AttachmentMetaData.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and content_length is None:  # noqa: E501
            raise ValueError("Invalid value for `content_length`, must not be `None`")  # noqa: E501

        self._content_length = content_length

    @property
    def id(self):
        """Gets the id of this AttachmentMetaData.  # noqa: E501

        ID of attachment. Can be used to with attachment controller endpoints to download attachment or with sending methods to attach to an email.  # noqa: E501

        :return: The id of this AttachmentMetaData.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AttachmentMetaData.

        ID of attachment. Can be used to with attachment controller endpoints to download attachment or with sending methods to attach to an email.  # noqa: E501

        :param id: The id of this AttachmentMetaData.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AttachmentMetaData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AttachmentMetaData):
            return True

        return self.to_dict() != other.to_dict()
