# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytimedinput']

package_data = \
{'': ['*']}

extras_require = \
{':sys_platform == "win32"': ['colorama']}

setup_kwargs = {
    'name': 'pytimedinput',
    'version': '1.3.1',
    'description': 'Query a user for input with a timeout.',
    'long_description': 'pytimedinput\n============\n\nDescription\n-----------\n\nA tiny, simplistic little alternative to the standard Python input()-function allowing you to specify a timeout for the function.\n\npytimedinput should work on both Windows and Linux, though no exceedingly extensive testing has been done and there might be bugs.\n\nInstall\n-------\n\n.. code:: bash\n\n    $ pip3 install pytimedinput\n\nUsage\n-----\n\ntimedInput()\n............\n\n*timedInput()* works similar to Python\'s default *input()* - function, asking user for a string of text, but *timedInput()* allows you to define an amount of time the user has to enter any text or how many consecutive seconds to wait for input, if the user goes idle. Pressing ENTER, carriage-return or ESC will end input and return from the function.\n\n.. code:: python\n\n    def timedInput(prompt="", timeOut=5, forcedTimeout=False, maxLength=0)\n\nThe function *timedInput()* from *pytimedinput* accepts the following parameters:\n\n - **prompt**, *str*: a string to show the user as a prompt when waiting for input.\n     *Defaults to an empty string.*\n - **timeout**, *int*: how many seconds to wait before timing out.\n     *Defaults to 5 seconds.*\n - **forcedTimeout**, *bool*: whether to wait for \'timeout\' many consecutive seconds of idle time or simply time out regardless of user-input.\n     *Defaults to False, ie. consecutive.*\n - **maxLength** [], *int*: the maximum length of the string user is allowed to enter.\n     *Defaults to 0, ie. unlimited.*\n\nThe function returns a tuple of:\n\n - *str*: a string containing whatever the user typed, regardless of whether the function timed out or not.\n - *bool*: whether the function timed out or not.\n\n.. code:: python\n\n    from pytimedinput import timedInput\n    userText, timedOut = timedInput("Please, do enter something: ")\n    if(timedOut):\n        print("Timed out when waiting for input.")\n        print(f"User-input so far: \'{userText}\'")\n    else:\n        print(f"User-input: \'{userText}\'")\n\ntimedKey()\n..........\n*timedKey()* waits for the user to press one of a set of predefined keys, with a timeout, while ignoring any keys not on the list.\n\n.. code:: python\n\n    def timedKey(prompt="", timeOut=5, forcedTimeout=False, allowCharacters=[\'y\', \'n\'])\n\nThe function *timedKey()* from *pytimedinput* accepts the following parameters:\n\n - **prompt**, *str*: a string to show the user as a prompt when waiting for input.\n     *Defaults to an empty string.*\n - **timeout**, *int*: how many seconds to wait before timing out.\n     *Defaults to 5 seconds.*\n - **forcedTimeout**, *bool*: whether to wait for \'timeout\' many consecutive seconds of idle time or simply time out regardless of user-input.\n     *Defaults to False, ie. consecutive.*\n - **allowCharacters** [], *list*: list of valid characters for the user to use.\n     *Defaults to \'y\' and \'n\'.*\n\nThe function returns a tuple of:\n\n - *str*: a string containing the key user pressed, if on the endCharacters - list, or an empty string.\n - *bool*: whether the function timed out or not.\n\n.. code:: python\n\n    from pytimedinput import timedKey\n    userText, timedOut = timedKey("Please, press \'y\' to accept or \'n\' to decline: ", endCharacters=[\'y\', \'n\'])\n    if(timedOut):\n        print("Timed out when waiting for input. Pester the user later.")\n    else:\n        if(userText == "y"):\n            print("User consented to selling their first-born child!")\n        else:\n            print("User unfortunately declined to sell their first-born child!")\n\ntimedInteger() and timedFloat()\n...............................\n*timedInteger()* and *timedFloat* work like *timedInput()*, except only allows the user to enter numbers, and comma or period in case of *timedFloat*.\n\n.. code:: python\n\n    def timedInteger(prompt="", timeOut=5, forcedTimeout=False, maxLength=0)\n\nThe function *timedInteger()* and *timedFloat()* from *pytimedinput* accept the following parameters:\n\n - **prompt**, *str*: a string to show the user as a prompt when waiting for input.\n     *Defaults to an empty string.*\n - **timeout**, *int*: how many seconds to wait before timing out.\n     *Defaults to 5 seconds.*\n - **forcedTimeout**, *bool*: whether to wait for \'timeout\' many consecutive seconds of idle time or simply time out regardless of user-input.\n     *Defaults to False, ie. consecutive.*\n - **maxLength** [], *int*: the maximum length of numbers the user is allowed to enter. The decimal-separator does not count.\n     *Defaults to 0, ie. unlimited.*\n\nThe function returns a tuple of:\n\n - *int/float* or *None*: an integer or float, depending on which function was called or None, if no number was entered.\n - *bool*: whether the function timed out or not.\n\n.. code:: python\n\n    from pytimedinput import *\n    userText, timedOut = timedInput("Please, do enter something: ")\n    if(timedOut):\n        print("Timed out when waiting for input.")\n        print(f"User-input so far: \'{userText}\'")\n    else:\n        print(f"User-input: \'{userText}\'")\n    userNumber, timedOut = timedFloat("Enter a number: ", maxLength = 5)\n    if(not timedOut):\n        if(userNumber == None):\n            print("We wanted a number, but got none.")\n        else:\n            print(f"We should do some fancy maths with {userNumber}!")\n\n\nExceptions\n----------\n\nBoth *timedInput()* and *timedKey()* require an interactive shell to function and will raise a Runtimerror - exception otherwise, which will need to be caught in any script that will be used both interactively and non-interactively.\n\nLicense\n-------\n\nMIT',
    'author': 'WereCatf',
    'author_email': 'werecatf@runbox.com',
    'maintainer': 'WereCatf',
    'maintainer_email': 'werecatf@runbox.com',
    'url': 'https://github.com/werecatf/pytimedinput/',
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
