# Copyright (C) 2021 Intel Corporation
# SPDX-License-Identifier: GPL-3.0-or-later


"""
CVE checker for mdadm

https://www.cvedetails.com/product/56966/?q=Mdadm

"""
from cve_bin_tool.checkers import Checker


class MdadmChecker(Checker):

    CONTAINS_PATTERNS = [
        r"# do not edit this file, it is automatically generated by mdadm",
        r"--version     -V   : Print version information for mdadm",
        r"After these arrays are assembled, mdadm will look for other devices",
        r"For each array, mdadm needs to know the md device, the identity of",
        r"When fail mode is invoked, mdadm will see if the device belongs to an array",
        r"mdadm is used for building, managing, and monitoring",
    ]
    FILENAME_PATTERNS = [
        r"mdadm",
        r"mdmon",
    ]
    VERSION_PATTERNS = [r"mdadm - v([0-9]+\.[0-9]+)"]
    VENDOR_PRODUCT = [("mdadm_project", "mdadm")]
