# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtWebChannel, except for defaults which are replaced by "...".
"""

# Module PySide2.QtWebChannel
import PySide2
import typing

import shiboken2 as Shiboken

import PySide2.QtCore
import PySide2.QtWebChannel


class QWebChannel(PySide2.QtCore.QObject):

    blockUpdatesChanged: PySide2.QtCore.Signal


    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def blockUpdates(self) -> bool: ...
    def connectTo(self, transport:PySide2.QtWebChannel.QWebChannelAbstractTransport) -> None: ...
    def deregisterObject(self, object:PySide2.QtCore.QObject) -> None: ...
    def disconnectFrom(self, transport:PySide2.QtWebChannel.QWebChannelAbstractTransport) -> None: ...
    def registerObject(self, id:str, object:PySide2.QtCore.QObject) -> None: ...
    def registerObjects(self, objects:typing.Dict) -> None: ...
    def registeredObjects(self) -> typing.Dict: ...
    def setBlockUpdates(self, block:bool) -> None: ...


class QWebChannelAbstractTransport(PySide2.QtCore.QObject):

    messageReceived: PySide2.QtCore.Signal


    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def sendMessage(self, message:typing.Dict) -> None: ...

# eof
