# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtLocation, except for defaults which are replaced by "...".
"""

# Module PySide2.QtLocation
import PySide2
import typing

import shiboken2 as Shiboken

import PySide2.QtCore
import PySide2.QtPositioning
import PySide2.QtLocation


class QGeoCodeReply(PySide2.QtCore.QObject):

    aborted: PySide2.QtCore.Signal
    error: PySide2.QtCore.Signal
    finished: PySide2.QtCore.Signal

    NoError                  : QGeoCodeReply.Error = ... # 0x0
    EngineNotSetError        : QGeoCodeReply.Error = ... # 0x1
    CommunicationError       : QGeoCodeReply.Error = ... # 0x2
    ParseError               : QGeoCodeReply.Error = ... # 0x3
    UnsupportedOptionError   : QGeoCodeReply.Error = ... # 0x4
    CombinationError         : QGeoCodeReply.Error = ... # 0x5
    UnknownError             : QGeoCodeReply.Error = ... # 0x6

    class Error(object):
        NoError                  : QGeoCodeReply.Error = ... # 0x0
        EngineNotSetError        : QGeoCodeReply.Error = ... # 0x1
        CommunicationError       : QGeoCodeReply.Error = ... # 0x2
        ParseError               : QGeoCodeReply.Error = ... # 0x3
        UnsupportedOptionError   : QGeoCodeReply.Error = ... # 0x4
        CombinationError         : QGeoCodeReply.Error = ... # 0x5
        UnknownError             : QGeoCodeReply.Error = ... # 0x6

    @typing.overload
    def __init__(self, error:PySide2.QtLocation.QGeoCodeReply.Error, errorString:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def abort(self) -> None: ...
    def addLocation(self, location:PySide2.QtPositioning.QGeoLocation) -> None: ...
    def error(self) -> PySide2.QtLocation.QGeoCodeReply.Error: ...
    def errorString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def limit(self) -> int: ...
    def locations(self) -> typing.List: ...
    def offset(self) -> int: ...
    def setError(self, error:PySide2.QtLocation.QGeoCodeReply.Error, errorString:str) -> None: ...
    def setFinished(self, finished:bool) -> None: ...
    def setLimit(self, limit:int) -> None: ...
    def setLocations(self, locations:typing.Sequence) -> None: ...
    def setOffset(self, offset:int) -> None: ...
    def setViewport(self, viewport:PySide2.QtPositioning.QGeoShape) -> None: ...
    def viewport(self) -> PySide2.QtPositioning.QGeoShape: ...


class QGeoCodingManager(PySide2.QtCore.QObject):

    error: PySide2.QtCore.Signal
    finished: PySide2.QtCore.Signal

    @typing.overload
    def geocode(self, address:PySide2.QtPositioning.QGeoAddress, bounds:PySide2.QtPositioning.QGeoShape=...) -> PySide2.QtLocation.QGeoCodeReply: ...
    @typing.overload
    def geocode(self, searchString:str, limit:int=..., offset:int=..., bounds:PySide2.QtPositioning.QGeoShape=...) -> PySide2.QtLocation.QGeoCodeReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def reverseGeocode(self, coordinate:PySide2.QtPositioning.QGeoCoordinate, bounds:PySide2.QtPositioning.QGeoShape=...) -> PySide2.QtLocation.QGeoCodeReply: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...


class QGeoCodingManagerEngine(PySide2.QtCore.QObject):

    error: PySide2.QtCore.Signal
    finished: PySide2.QtCore.Signal


    def __init__(self, parameters:typing.Dict, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    @typing.overload
    def geocode(self, address:PySide2.QtPositioning.QGeoAddress, bounds:PySide2.QtPositioning.QGeoShape) -> PySide2.QtLocation.QGeoCodeReply: ...
    @typing.overload
    def geocode(self, address:str, limit:int, offset:int, bounds:PySide2.QtPositioning.QGeoShape) -> PySide2.QtLocation.QGeoCodeReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def reverseGeocode(self, coordinate:PySide2.QtPositioning.QGeoCoordinate, bounds:PySide2.QtPositioning.QGeoShape) -> PySide2.QtLocation.QGeoCodeReply: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...


class QGeoManeuver(Shiboken.Object):
    NoDirection              : QGeoManeuver.InstructionDirection = ... # 0x0
    DirectionForward         : QGeoManeuver.InstructionDirection = ... # 0x1
    DirectionBearRight       : QGeoManeuver.InstructionDirection = ... # 0x2
    DirectionLightRight      : QGeoManeuver.InstructionDirection = ... # 0x3
    DirectionRight           : QGeoManeuver.InstructionDirection = ... # 0x4
    DirectionHardRight       : QGeoManeuver.InstructionDirection = ... # 0x5
    DirectionUTurnRight      : QGeoManeuver.InstructionDirection = ... # 0x6
    DirectionUTurnLeft       : QGeoManeuver.InstructionDirection = ... # 0x7
    DirectionHardLeft        : QGeoManeuver.InstructionDirection = ... # 0x8
    DirectionLeft            : QGeoManeuver.InstructionDirection = ... # 0x9
    DirectionLightLeft       : QGeoManeuver.InstructionDirection = ... # 0xa
    DirectionBearLeft        : QGeoManeuver.InstructionDirection = ... # 0xb

    class InstructionDirection(object):
        NoDirection              : QGeoManeuver.InstructionDirection = ... # 0x0
        DirectionForward         : QGeoManeuver.InstructionDirection = ... # 0x1
        DirectionBearRight       : QGeoManeuver.InstructionDirection = ... # 0x2
        DirectionLightRight      : QGeoManeuver.InstructionDirection = ... # 0x3
        DirectionRight           : QGeoManeuver.InstructionDirection = ... # 0x4
        DirectionHardRight       : QGeoManeuver.InstructionDirection = ... # 0x5
        DirectionUTurnRight      : QGeoManeuver.InstructionDirection = ... # 0x6
        DirectionUTurnLeft       : QGeoManeuver.InstructionDirection = ... # 0x7
        DirectionHardLeft        : QGeoManeuver.InstructionDirection = ... # 0x8
        DirectionLeft            : QGeoManeuver.InstructionDirection = ... # 0x9
        DirectionLightLeft       : QGeoManeuver.InstructionDirection = ... # 0xa
        DirectionBearLeft        : QGeoManeuver.InstructionDirection = ... # 0xb

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QGeoManeuver) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def direction(self) -> PySide2.QtLocation.QGeoManeuver.InstructionDirection: ...
    def distanceToNextInstruction(self) -> float: ...
    def extendedAttributes(self) -> typing.Dict: ...
    def instructionText(self) -> str: ...
    def isValid(self) -> bool: ...
    def position(self) -> PySide2.QtPositioning.QGeoCoordinate: ...
    def setDirection(self, direction:PySide2.QtLocation.QGeoManeuver.InstructionDirection) -> None: ...
    def setDistanceToNextInstruction(self, distance:float) -> None: ...
    def setExtendedAttributes(self, extendedAttributes:typing.Dict) -> None: ...
    def setInstructionText(self, instructionText:str) -> None: ...
    def setPosition(self, position:PySide2.QtPositioning.QGeoCoordinate) -> None: ...
    def setTimeToNextInstruction(self, secs:int) -> None: ...
    def setWaypoint(self, coordinate:PySide2.QtPositioning.QGeoCoordinate) -> None: ...
    def timeToNextInstruction(self) -> int: ...
    def waypoint(self) -> PySide2.QtPositioning.QGeoCoordinate: ...


class QGeoRoute(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QGeoRoute) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bounds(self) -> PySide2.QtPositioning.QGeoRectangle: ...
    def distance(self) -> float: ...
    def extendedAttributes(self) -> typing.Dict: ...
    def firstRouteSegment(self) -> PySide2.QtLocation.QGeoRouteSegment: ...
    def path(self) -> typing.List: ...
    def request(self) -> PySide2.QtLocation.QGeoRouteRequest: ...
    def routeId(self) -> str: ...
    def setBounds(self, bounds:PySide2.QtPositioning.QGeoRectangle) -> None: ...
    def setDistance(self, distance:float) -> None: ...
    def setExtendedAttributes(self, extendedAttributes:typing.Dict) -> None: ...
    def setFirstRouteSegment(self, routeSegment:PySide2.QtLocation.QGeoRouteSegment) -> None: ...
    def setPath(self, path:typing.Sequence) -> None: ...
    def setRequest(self, request:PySide2.QtLocation.QGeoRouteRequest) -> None: ...
    def setRouteId(self, id:str) -> None: ...
    def setTravelMode(self, mode:PySide2.QtLocation.QGeoRouteRequest.TravelMode) -> None: ...
    def setTravelTime(self, secs:int) -> None: ...
    def travelMode(self) -> PySide2.QtLocation.QGeoRouteRequest.TravelMode: ...
    def travelTime(self) -> int: ...


class QGeoRouteReply(PySide2.QtCore.QObject):

    aborted: PySide2.QtCore.Signal
    error: PySide2.QtCore.Signal
    finished: PySide2.QtCore.Signal

    NoError                  : QGeoRouteReply.Error = ... # 0x0
    EngineNotSetError        : QGeoRouteReply.Error = ... # 0x1
    CommunicationError       : QGeoRouteReply.Error = ... # 0x2
    ParseError               : QGeoRouteReply.Error = ... # 0x3
    UnsupportedOptionError   : QGeoRouteReply.Error = ... # 0x4
    UnknownError             : QGeoRouteReply.Error = ... # 0x5

    class Error(object):
        NoError                  : QGeoRouteReply.Error = ... # 0x0
        EngineNotSetError        : QGeoRouteReply.Error = ... # 0x1
        CommunicationError       : QGeoRouteReply.Error = ... # 0x2
        ParseError               : QGeoRouteReply.Error = ... # 0x3
        UnsupportedOptionError   : QGeoRouteReply.Error = ... # 0x4
        UnknownError             : QGeoRouteReply.Error = ... # 0x5

    @typing.overload
    def __init__(self, error:PySide2.QtLocation.QGeoRouteReply.Error, errorString:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, request:PySide2.QtLocation.QGeoRouteRequest, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def abort(self) -> None: ...
    def addRoutes(self, routes:typing.Sequence) -> None: ...
    def error(self) -> PySide2.QtLocation.QGeoRouteReply.Error: ...
    def errorString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def request(self) -> PySide2.QtLocation.QGeoRouteRequest: ...
    def routes(self) -> typing.List: ...
    def setError(self, error:PySide2.QtLocation.QGeoRouteReply.Error, errorString:str) -> None: ...
    def setFinished(self, finished:bool) -> None: ...
    def setRoutes(self, routes:typing.Sequence) -> None: ...


class QGeoRouteRequest(Shiboken.Object):
    NeutralFeatureWeight     : QGeoRouteRequest.FeatureWeight = ... # 0x0
    NoFeature                : QGeoRouteRequest.FeatureType = ... # 0x0
    NoManeuvers              : QGeoRouteRequest.ManeuverDetail = ... # 0x0
    NoSegmentData            : QGeoRouteRequest.SegmentDetail = ... # 0x0
    BasicManeuvers           : QGeoRouteRequest.ManeuverDetail = ... # 0x1
    BasicSegmentData         : QGeoRouteRequest.SegmentDetail = ... # 0x1
    CarTravel                : QGeoRouteRequest.TravelMode = ... # 0x1
    PreferFeatureWeight      : QGeoRouteRequest.FeatureWeight = ... # 0x1
    ShortestRoute            : QGeoRouteRequest.RouteOptimization = ... # 0x1
    TollFeature              : QGeoRouteRequest.FeatureType = ... # 0x1
    FastestRoute             : QGeoRouteRequest.RouteOptimization = ... # 0x2
    HighwayFeature           : QGeoRouteRequest.FeatureType = ... # 0x2
    PedestrianTravel         : QGeoRouteRequest.TravelMode = ... # 0x2
    RequireFeatureWeight     : QGeoRouteRequest.FeatureWeight = ... # 0x2
    AvoidFeatureWeight       : QGeoRouteRequest.FeatureWeight = ... # 0x4
    BicycleTravel            : QGeoRouteRequest.TravelMode = ... # 0x4
    MostEconomicRoute        : QGeoRouteRequest.RouteOptimization = ... # 0x4
    PublicTransitFeature     : QGeoRouteRequest.FeatureType = ... # 0x4
    DisallowFeatureWeight    : QGeoRouteRequest.FeatureWeight = ... # 0x8
    FerryFeature             : QGeoRouteRequest.FeatureType = ... # 0x8
    MostScenicRoute          : QGeoRouteRequest.RouteOptimization = ... # 0x8
    PublicTransitTravel      : QGeoRouteRequest.TravelMode = ... # 0x8
    TruckTravel              : QGeoRouteRequest.TravelMode = ... # 0x10
    TunnelFeature            : QGeoRouteRequest.FeatureType = ... # 0x10
    DirtRoadFeature          : QGeoRouteRequest.FeatureType = ... # 0x20
    ParksFeature             : QGeoRouteRequest.FeatureType = ... # 0x40
    MotorPoolLaneFeature     : QGeoRouteRequest.FeatureType = ... # 0x80
    TrafficFeature           : QGeoRouteRequest.FeatureType = ... # 0x100

    class FeatureType(object):
        NoFeature                : QGeoRouteRequest.FeatureType = ... # 0x0
        TollFeature              : QGeoRouteRequest.FeatureType = ... # 0x1
        HighwayFeature           : QGeoRouteRequest.FeatureType = ... # 0x2
        PublicTransitFeature     : QGeoRouteRequest.FeatureType = ... # 0x4
        FerryFeature             : QGeoRouteRequest.FeatureType = ... # 0x8
        TunnelFeature            : QGeoRouteRequest.FeatureType = ... # 0x10
        DirtRoadFeature          : QGeoRouteRequest.FeatureType = ... # 0x20
        ParksFeature             : QGeoRouteRequest.FeatureType = ... # 0x40
        MotorPoolLaneFeature     : QGeoRouteRequest.FeatureType = ... # 0x80
        TrafficFeature           : QGeoRouteRequest.FeatureType = ... # 0x100
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, FeatureType] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, FeatureType]) -> FeatureTypes: ...
        def __and__(self, other: typing.Union[int, FeatureType]) -> FeatureTypes: ...
        def __xor__(self, other: typing.Union[int, FeatureType]) -> FeatureTypes: ...
        def __ror__(self, other: typing.Union[int, FeatureType]) -> FeatureTypes: ...
        def __rand__(self, other: typing.Union[int, FeatureType]) -> FeatureTypes: ...
        def __rxor__(self, other: typing.Union[int, FeatureType]) -> FeatureTypes: ...
        def __ior__(self, other: typing.Union[int, FeatureType]) -> FeatureTypes: ...
        def __iand__(self, other: typing.Union[int, FeatureType]) -> FeatureTypes: ...
        def __ixor__(self, other: typing.Union[int, FeatureType]) -> FeatureTypes: ...
        def __invert__(self) -> FeatureTypes: ...

    class FeatureTypes(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, FeatureType, FeatureTypes] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, FeatureType, FeatureTypes]) -> FeatureTypes: ...
        def __and__(self, other: typing.Union[int, FeatureType, FeatureTypes]) -> FeatureTypes: ...
        def __xor__(self, other: typing.Union[int, FeatureType, FeatureTypes]) -> FeatureTypes: ...
        def __ror__(self, other: typing.Union[int, FeatureType, FeatureTypes]) -> FeatureTypes: ...
        def __rand__(self, other: typing.Union[int, FeatureType, FeatureTypes]) -> FeatureTypes: ...
        def __rxor__(self, other: typing.Union[int, FeatureType, FeatureTypes]) -> FeatureTypes: ...
        def __ior__(self, other: typing.Union[int, FeatureType, FeatureTypes]) -> FeatureTypes: ...
        def __iand__(self, other: typing.Union[int, FeatureType, FeatureTypes]) -> FeatureTypes: ...
        def __ixor__(self, other: typing.Union[int, FeatureType, FeatureTypes]) -> FeatureTypes: ...
        def __invert__(self) -> FeatureTypes: ...

    class FeatureWeight(object):
        NeutralFeatureWeight     : QGeoRouteRequest.FeatureWeight = ... # 0x0
        PreferFeatureWeight      : QGeoRouteRequest.FeatureWeight = ... # 0x1
        RequireFeatureWeight     : QGeoRouteRequest.FeatureWeight = ... # 0x2
        AvoidFeatureWeight       : QGeoRouteRequest.FeatureWeight = ... # 0x4
        DisallowFeatureWeight    : QGeoRouteRequest.FeatureWeight = ... # 0x8
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, FeatureWeight] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, FeatureWeight]) -> FeatureWeights: ...
        def __and__(self, other: typing.Union[int, FeatureWeight]) -> FeatureWeights: ...
        def __xor__(self, other: typing.Union[int, FeatureWeight]) -> FeatureWeights: ...
        def __ror__(self, other: typing.Union[int, FeatureWeight]) -> FeatureWeights: ...
        def __rand__(self, other: typing.Union[int, FeatureWeight]) -> FeatureWeights: ...
        def __rxor__(self, other: typing.Union[int, FeatureWeight]) -> FeatureWeights: ...
        def __ior__(self, other: typing.Union[int, FeatureWeight]) -> FeatureWeights: ...
        def __iand__(self, other: typing.Union[int, FeatureWeight]) -> FeatureWeights: ...
        def __ixor__(self, other: typing.Union[int, FeatureWeight]) -> FeatureWeights: ...
        def __invert__(self) -> FeatureWeights: ...

    class FeatureWeights(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, FeatureWeight, FeatureWeights] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, FeatureWeight, FeatureWeights]) -> FeatureWeights: ...
        def __and__(self, other: typing.Union[int, FeatureWeight, FeatureWeights]) -> FeatureWeights: ...
        def __xor__(self, other: typing.Union[int, FeatureWeight, FeatureWeights]) -> FeatureWeights: ...
        def __ror__(self, other: typing.Union[int, FeatureWeight, FeatureWeights]) -> FeatureWeights: ...
        def __rand__(self, other: typing.Union[int, FeatureWeight, FeatureWeights]) -> FeatureWeights: ...
        def __rxor__(self, other: typing.Union[int, FeatureWeight, FeatureWeights]) -> FeatureWeights: ...
        def __ior__(self, other: typing.Union[int, FeatureWeight, FeatureWeights]) -> FeatureWeights: ...
        def __iand__(self, other: typing.Union[int, FeatureWeight, FeatureWeights]) -> FeatureWeights: ...
        def __ixor__(self, other: typing.Union[int, FeatureWeight, FeatureWeights]) -> FeatureWeights: ...
        def __invert__(self) -> FeatureWeights: ...

    class ManeuverDetail(object):
        NoManeuvers              : QGeoRouteRequest.ManeuverDetail = ... # 0x0
        BasicManeuvers           : QGeoRouteRequest.ManeuverDetail = ... # 0x1
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, ManeuverDetail] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, ManeuverDetail]) -> ManeuverDetails: ...
        def __and__(self, other: typing.Union[int, ManeuverDetail]) -> ManeuverDetails: ...
        def __xor__(self, other: typing.Union[int, ManeuverDetail]) -> ManeuverDetails: ...
        def __ror__(self, other: typing.Union[int, ManeuverDetail]) -> ManeuverDetails: ...
        def __rand__(self, other: typing.Union[int, ManeuverDetail]) -> ManeuverDetails: ...
        def __rxor__(self, other: typing.Union[int, ManeuverDetail]) -> ManeuverDetails: ...
        def __ior__(self, other: typing.Union[int, ManeuverDetail]) -> ManeuverDetails: ...
        def __iand__(self, other: typing.Union[int, ManeuverDetail]) -> ManeuverDetails: ...
        def __ixor__(self, other: typing.Union[int, ManeuverDetail]) -> ManeuverDetails: ...
        def __invert__(self) -> ManeuverDetails: ...

    class ManeuverDetails(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, ManeuverDetail, ManeuverDetails] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, ManeuverDetail, ManeuverDetails]) -> ManeuverDetails: ...
        def __and__(self, other: typing.Union[int, ManeuverDetail, ManeuverDetails]) -> ManeuverDetails: ...
        def __xor__(self, other: typing.Union[int, ManeuverDetail, ManeuverDetails]) -> ManeuverDetails: ...
        def __ror__(self, other: typing.Union[int, ManeuverDetail, ManeuverDetails]) -> ManeuverDetails: ...
        def __rand__(self, other: typing.Union[int, ManeuverDetail, ManeuverDetails]) -> ManeuverDetails: ...
        def __rxor__(self, other: typing.Union[int, ManeuverDetail, ManeuverDetails]) -> ManeuverDetails: ...
        def __ior__(self, other: typing.Union[int, ManeuverDetail, ManeuverDetails]) -> ManeuverDetails: ...
        def __iand__(self, other: typing.Union[int, ManeuverDetail, ManeuverDetails]) -> ManeuverDetails: ...
        def __ixor__(self, other: typing.Union[int, ManeuverDetail, ManeuverDetails]) -> ManeuverDetails: ...
        def __invert__(self) -> ManeuverDetails: ...

    class RouteOptimization(object):
        ShortestRoute            : QGeoRouteRequest.RouteOptimization = ... # 0x1
        FastestRoute             : QGeoRouteRequest.RouteOptimization = ... # 0x2
        MostEconomicRoute        : QGeoRouteRequest.RouteOptimization = ... # 0x4
        MostScenicRoute          : QGeoRouteRequest.RouteOptimization = ... # 0x8
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, RouteOptimization] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, RouteOptimization]) -> RouteOptimizations: ...
        def __and__(self, other: typing.Union[int, RouteOptimization]) -> RouteOptimizations: ...
        def __xor__(self, other: typing.Union[int, RouteOptimization]) -> RouteOptimizations: ...
        def __ror__(self, other: typing.Union[int, RouteOptimization]) -> RouteOptimizations: ...
        def __rand__(self, other: typing.Union[int, RouteOptimization]) -> RouteOptimizations: ...
        def __rxor__(self, other: typing.Union[int, RouteOptimization]) -> RouteOptimizations: ...
        def __ior__(self, other: typing.Union[int, RouteOptimization]) -> RouteOptimizations: ...
        def __iand__(self, other: typing.Union[int, RouteOptimization]) -> RouteOptimizations: ...
        def __ixor__(self, other: typing.Union[int, RouteOptimization]) -> RouteOptimizations: ...
        def __invert__(self) -> RouteOptimizations: ...

    class RouteOptimizations(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, RouteOptimization, RouteOptimizations] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, RouteOptimization, RouteOptimizations]) -> RouteOptimizations: ...
        def __and__(self, other: typing.Union[int, RouteOptimization, RouteOptimizations]) -> RouteOptimizations: ...
        def __xor__(self, other: typing.Union[int, RouteOptimization, RouteOptimizations]) -> RouteOptimizations: ...
        def __ror__(self, other: typing.Union[int, RouteOptimization, RouteOptimizations]) -> RouteOptimizations: ...
        def __rand__(self, other: typing.Union[int, RouteOptimization, RouteOptimizations]) -> RouteOptimizations: ...
        def __rxor__(self, other: typing.Union[int, RouteOptimization, RouteOptimizations]) -> RouteOptimizations: ...
        def __ior__(self, other: typing.Union[int, RouteOptimization, RouteOptimizations]) -> RouteOptimizations: ...
        def __iand__(self, other: typing.Union[int, RouteOptimization, RouteOptimizations]) -> RouteOptimizations: ...
        def __ixor__(self, other: typing.Union[int, RouteOptimization, RouteOptimizations]) -> RouteOptimizations: ...
        def __invert__(self) -> RouteOptimizations: ...

    class SegmentDetail(object):
        NoSegmentData            : QGeoRouteRequest.SegmentDetail = ... # 0x0
        BasicSegmentData         : QGeoRouteRequest.SegmentDetail = ... # 0x1
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, SegmentDetail] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, SegmentDetail]) -> SegmentDetails: ...
        def __and__(self, other: typing.Union[int, SegmentDetail]) -> SegmentDetails: ...
        def __xor__(self, other: typing.Union[int, SegmentDetail]) -> SegmentDetails: ...
        def __ror__(self, other: typing.Union[int, SegmentDetail]) -> SegmentDetails: ...
        def __rand__(self, other: typing.Union[int, SegmentDetail]) -> SegmentDetails: ...
        def __rxor__(self, other: typing.Union[int, SegmentDetail]) -> SegmentDetails: ...
        def __ior__(self, other: typing.Union[int, SegmentDetail]) -> SegmentDetails: ...
        def __iand__(self, other: typing.Union[int, SegmentDetail]) -> SegmentDetails: ...
        def __ixor__(self, other: typing.Union[int, SegmentDetail]) -> SegmentDetails: ...
        def __invert__(self) -> SegmentDetails: ...

    class SegmentDetails(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, SegmentDetail, SegmentDetails] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, SegmentDetail, SegmentDetails]) -> SegmentDetails: ...
        def __and__(self, other: typing.Union[int, SegmentDetail, SegmentDetails]) -> SegmentDetails: ...
        def __xor__(self, other: typing.Union[int, SegmentDetail, SegmentDetails]) -> SegmentDetails: ...
        def __ror__(self, other: typing.Union[int, SegmentDetail, SegmentDetails]) -> SegmentDetails: ...
        def __rand__(self, other: typing.Union[int, SegmentDetail, SegmentDetails]) -> SegmentDetails: ...
        def __rxor__(self, other: typing.Union[int, SegmentDetail, SegmentDetails]) -> SegmentDetails: ...
        def __ior__(self, other: typing.Union[int, SegmentDetail, SegmentDetails]) -> SegmentDetails: ...
        def __iand__(self, other: typing.Union[int, SegmentDetail, SegmentDetails]) -> SegmentDetails: ...
        def __ixor__(self, other: typing.Union[int, SegmentDetail, SegmentDetails]) -> SegmentDetails: ...
        def __invert__(self) -> SegmentDetails: ...

    class TravelMode(object):
        CarTravel                : QGeoRouteRequest.TravelMode = ... # 0x1
        PedestrianTravel         : QGeoRouteRequest.TravelMode = ... # 0x2
        BicycleTravel            : QGeoRouteRequest.TravelMode = ... # 0x4
        PublicTransitTravel      : QGeoRouteRequest.TravelMode = ... # 0x8
        TruckTravel              : QGeoRouteRequest.TravelMode = ... # 0x10
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, TravelMode] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, TravelMode]) -> TravelModes: ...
        def __and__(self, other: typing.Union[int, TravelMode]) -> TravelModes: ...
        def __xor__(self, other: typing.Union[int, TravelMode]) -> TravelModes: ...
        def __ror__(self, other: typing.Union[int, TravelMode]) -> TravelModes: ...
        def __rand__(self, other: typing.Union[int, TravelMode]) -> TravelModes: ...
        def __rxor__(self, other: typing.Union[int, TravelMode]) -> TravelModes: ...
        def __ior__(self, other: typing.Union[int, TravelMode]) -> TravelModes: ...
        def __iand__(self, other: typing.Union[int, TravelMode]) -> TravelModes: ...
        def __ixor__(self, other: typing.Union[int, TravelMode]) -> TravelModes: ...
        def __invert__(self) -> TravelModes: ...

    class TravelModes(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, TravelMode, TravelModes] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, TravelMode, TravelModes]) -> TravelModes: ...
        def __and__(self, other: typing.Union[int, TravelMode, TravelModes]) -> TravelModes: ...
        def __xor__(self, other: typing.Union[int, TravelMode, TravelModes]) -> TravelModes: ...
        def __ror__(self, other: typing.Union[int, TravelMode, TravelModes]) -> TravelModes: ...
        def __rand__(self, other: typing.Union[int, TravelMode, TravelModes]) -> TravelModes: ...
        def __rxor__(self, other: typing.Union[int, TravelMode, TravelModes]) -> TravelModes: ...
        def __ior__(self, other: typing.Union[int, TravelMode, TravelModes]) -> TravelModes: ...
        def __iand__(self, other: typing.Union[int, TravelMode, TravelModes]) -> TravelModes: ...
        def __ixor__(self, other: typing.Union[int, TravelMode, TravelModes]) -> TravelModes: ...
        def __invert__(self) -> TravelModes: ...

    @typing.overload
    def __init__(self, origin:PySide2.QtPositioning.QGeoCoordinate, destination:PySide2.QtPositioning.QGeoCoordinate) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QGeoRouteRequest) -> None: ...
    @typing.overload
    def __init__(self, waypoints:typing.Sequence=...) -> None: ...

    def departureTime(self) -> PySide2.QtCore.QDateTime: ...
    def excludeAreas(self) -> typing.List: ...
    def extraParameters(self) -> typing.Dict: ...
    def featureTypes(self) -> typing.List: ...
    def featureWeight(self, featureType:PySide2.QtLocation.QGeoRouteRequest.FeatureType) -> PySide2.QtLocation.QGeoRouteRequest.FeatureWeight: ...
    def maneuverDetail(self) -> PySide2.QtLocation.QGeoRouteRequest.ManeuverDetail: ...
    def numberAlternativeRoutes(self) -> int: ...
    def routeOptimization(self) -> PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations: ...
    def segmentDetail(self) -> PySide2.QtLocation.QGeoRouteRequest.SegmentDetail: ...
    def setDepartureTime(self, departureTime:PySide2.QtCore.QDateTime) -> None: ...
    def setExcludeAreas(self, areas:typing.Sequence) -> None: ...
    def setExtraParameters(self, extraParameters:typing.Dict) -> None: ...
    def setFeatureWeight(self, featureType:PySide2.QtLocation.QGeoRouteRequest.FeatureType, featureWeight:PySide2.QtLocation.QGeoRouteRequest.FeatureWeight) -> None: ...
    def setManeuverDetail(self, maneuverDetail:PySide2.QtLocation.QGeoRouteRequest.ManeuverDetail) -> None: ...
    def setNumberAlternativeRoutes(self, alternatives:int) -> None: ...
    def setRouteOptimization(self, optimization:PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations) -> None: ...
    def setSegmentDetail(self, segmentDetail:PySide2.QtLocation.QGeoRouteRequest.SegmentDetail) -> None: ...
    def setTravelModes(self, travelModes:PySide2.QtLocation.QGeoRouteRequest.TravelModes) -> None: ...
    def setWaypoints(self, waypoints:typing.Sequence) -> None: ...
    def setWaypointsMetadata(self, waypointMetadata:typing.Sequence) -> None: ...
    def travelModes(self) -> PySide2.QtLocation.QGeoRouteRequest.TravelModes: ...
    def waypoints(self) -> typing.List: ...
    def waypointsMetadata(self) -> typing.List: ...


class QGeoRouteSegment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QGeoRouteSegment) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def distance(self) -> float: ...
    def isLegLastSegment(self) -> bool: ...
    def isValid(self) -> bool: ...
    def maneuver(self) -> PySide2.QtLocation.QGeoManeuver: ...
    def nextRouteSegment(self) -> PySide2.QtLocation.QGeoRouteSegment: ...
    def path(self) -> typing.List: ...
    def setDistance(self, distance:float) -> None: ...
    def setManeuver(self, maneuver:PySide2.QtLocation.QGeoManeuver) -> None: ...
    def setNextRouteSegment(self, routeSegment:PySide2.QtLocation.QGeoRouteSegment) -> None: ...
    def setPath(self, path:typing.Sequence) -> None: ...
    def setTravelTime(self, secs:int) -> None: ...
    def travelTime(self) -> int: ...


class QGeoRoutingManager(PySide2.QtCore.QObject):

    error: PySide2.QtCore.Signal
    finished: PySide2.QtCore.Signal

    def calculateRoute(self, request:PySide2.QtLocation.QGeoRouteRequest) -> PySide2.QtLocation.QGeoRouteReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def measurementSystem(self) -> PySide2.QtCore.QLocale.MeasurementSystem: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...
    def setMeasurementSystem(self, system:PySide2.QtCore.QLocale.MeasurementSystem) -> None: ...
    def supportedFeatureTypes(self) -> PySide2.QtLocation.QGeoRouteRequest.FeatureTypes: ...
    def supportedFeatureWeights(self) -> PySide2.QtLocation.QGeoRouteRequest.FeatureWeights: ...
    def supportedManeuverDetails(self) -> PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails: ...
    def supportedRouteOptimizations(self) -> PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations: ...
    def supportedSegmentDetails(self) -> PySide2.QtLocation.QGeoRouteRequest.SegmentDetails: ...
    def supportedTravelModes(self) -> PySide2.QtLocation.QGeoRouteRequest.TravelModes: ...
    def updateRoute(self, route:PySide2.QtLocation.QGeoRoute, position:PySide2.QtPositioning.QGeoCoordinate) -> PySide2.QtLocation.QGeoRouteReply: ...


class QGeoRoutingManagerEngine(PySide2.QtCore.QObject):

    error: PySide2.QtCore.Signal
    finished: PySide2.QtCore.Signal


    def __init__(self, parameters:typing.Dict, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def calculateRoute(self, request:PySide2.QtLocation.QGeoRouteRequest) -> PySide2.QtLocation.QGeoRouteReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def measurementSystem(self) -> PySide2.QtCore.QLocale.MeasurementSystem: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...
    def setMeasurementSystem(self, system:PySide2.QtCore.QLocale.MeasurementSystem) -> None: ...
    def setSupportedFeatureTypes(self, featureTypes:PySide2.QtLocation.QGeoRouteRequest.FeatureTypes) -> None: ...
    def setSupportedFeatureWeights(self, featureWeights:PySide2.QtLocation.QGeoRouteRequest.FeatureWeights) -> None: ...
    def setSupportedManeuverDetails(self, maneuverDetails:PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails) -> None: ...
    def setSupportedRouteOptimizations(self, optimizations:PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations) -> None: ...
    def setSupportedSegmentDetails(self, segmentDetails:PySide2.QtLocation.QGeoRouteRequest.SegmentDetails) -> None: ...
    def setSupportedTravelModes(self, travelModes:PySide2.QtLocation.QGeoRouteRequest.TravelModes) -> None: ...
    def supportedFeatureTypes(self) -> PySide2.QtLocation.QGeoRouteRequest.FeatureTypes: ...
    def supportedFeatureWeights(self) -> PySide2.QtLocation.QGeoRouteRequest.FeatureWeights: ...
    def supportedManeuverDetails(self) -> PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails: ...
    def supportedRouteOptimizations(self) -> PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations: ...
    def supportedSegmentDetails(self) -> PySide2.QtLocation.QGeoRouteRequest.SegmentDetails: ...
    def supportedTravelModes(self) -> PySide2.QtLocation.QGeoRouteRequest.TravelModes: ...
    def updateRoute(self, route:PySide2.QtLocation.QGeoRoute, position:PySide2.QtPositioning.QGeoCoordinate) -> PySide2.QtLocation.QGeoRouteReply: ...


class QGeoServiceProvider(PySide2.QtCore.QObject):
    AnyGeocodingFeatures     : QGeoServiceProvider.GeocodingFeature = ... # -0x1
    AnyMappingFeatures       : QGeoServiceProvider.MappingFeature = ... # -0x1
    AnyNavigationFeatures    : QGeoServiceProvider.NavigationFeature = ... # -0x1
    AnyPlacesFeatures        : QGeoServiceProvider.PlacesFeature = ... # -0x1
    AnyRoutingFeatures       : QGeoServiceProvider.RoutingFeature = ... # -0x1
    NoError                  : QGeoServiceProvider.Error = ... # 0x0
    NoGeocodingFeatures      : QGeoServiceProvider.GeocodingFeature = ... # 0x0
    NoMappingFeatures        : QGeoServiceProvider.MappingFeature = ... # 0x0
    NoNavigationFeatures     : QGeoServiceProvider.NavigationFeature = ... # 0x0
    NoPlacesFeatures         : QGeoServiceProvider.PlacesFeature = ... # 0x0
    NoRoutingFeatures        : QGeoServiceProvider.RoutingFeature = ... # 0x0
    NotSupportedError        : QGeoServiceProvider.Error = ... # 0x1
    OnlineGeocodingFeature   : QGeoServiceProvider.GeocodingFeature = ... # 0x1
    OnlineMappingFeature     : QGeoServiceProvider.MappingFeature = ... # 0x1
    OnlineNavigationFeature  : QGeoServiceProvider.NavigationFeature = ... # 0x1
    OnlinePlacesFeature      : QGeoServiceProvider.PlacesFeature = ... # 0x1
    OnlineRoutingFeature     : QGeoServiceProvider.RoutingFeature = ... # 0x1
    OfflineGeocodingFeature  : QGeoServiceProvider.GeocodingFeature = ... # 0x2
    OfflineMappingFeature    : QGeoServiceProvider.MappingFeature = ... # 0x2
    OfflineNavigationFeature : QGeoServiceProvider.NavigationFeature = ... # 0x2
    OfflinePlacesFeature     : QGeoServiceProvider.PlacesFeature = ... # 0x2
    OfflineRoutingFeature    : QGeoServiceProvider.RoutingFeature = ... # 0x2
    UnknownParameterError    : QGeoServiceProvider.Error = ... # 0x2
    MissingRequiredParameterError: QGeoServiceProvider.Error = ... # 0x3
    ConnectionError          : QGeoServiceProvider.Error = ... # 0x4
    LocalizedMappingFeature  : QGeoServiceProvider.MappingFeature = ... # 0x4
    LocalizedRoutingFeature  : QGeoServiceProvider.RoutingFeature = ... # 0x4
    ReverseGeocodingFeature  : QGeoServiceProvider.GeocodingFeature = ... # 0x4
    SavePlaceFeature         : QGeoServiceProvider.PlacesFeature = ... # 0x4
    LoaderError              : QGeoServiceProvider.Error = ... # 0x5
    LocalizedGeocodingFeature: QGeoServiceProvider.GeocodingFeature = ... # 0x8
    RemovePlaceFeature       : QGeoServiceProvider.PlacesFeature = ... # 0x8
    RouteUpdatesFeature      : QGeoServiceProvider.RoutingFeature = ... # 0x8
    AlternativeRoutesFeature : QGeoServiceProvider.RoutingFeature = ... # 0x10
    SaveCategoryFeature      : QGeoServiceProvider.PlacesFeature = ... # 0x10
    ExcludeAreasRoutingFeature: QGeoServiceProvider.RoutingFeature = ... # 0x20
    RemoveCategoryFeature    : QGeoServiceProvider.PlacesFeature = ... # 0x20
    PlaceRecommendationsFeature: QGeoServiceProvider.PlacesFeature = ... # 0x40
    SearchSuggestionsFeature : QGeoServiceProvider.PlacesFeature = ... # 0x80
    LocalizedPlacesFeature   : QGeoServiceProvider.PlacesFeature = ... # 0x100
    NotificationsFeature     : QGeoServiceProvider.PlacesFeature = ... # 0x200
    PlaceMatchingFeature     : QGeoServiceProvider.PlacesFeature = ... # 0x400

    class Error(object):
        NoError                  : QGeoServiceProvider.Error = ... # 0x0
        NotSupportedError        : QGeoServiceProvider.Error = ... # 0x1
        UnknownParameterError    : QGeoServiceProvider.Error = ... # 0x2
        MissingRequiredParameterError: QGeoServiceProvider.Error = ... # 0x3
        ConnectionError          : QGeoServiceProvider.Error = ... # 0x4
        LoaderError              : QGeoServiceProvider.Error = ... # 0x5

    class GeocodingFeature(object):
        AnyGeocodingFeatures     : QGeoServiceProvider.GeocodingFeature = ... # -0x1
        NoGeocodingFeatures      : QGeoServiceProvider.GeocodingFeature = ... # 0x0
        OnlineGeocodingFeature   : QGeoServiceProvider.GeocodingFeature = ... # 0x1
        OfflineGeocodingFeature  : QGeoServiceProvider.GeocodingFeature = ... # 0x2
        ReverseGeocodingFeature  : QGeoServiceProvider.GeocodingFeature = ... # 0x4
        LocalizedGeocodingFeature: QGeoServiceProvider.GeocodingFeature = ... # 0x8
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, GeocodingFeature] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, GeocodingFeature]) -> GeocodingFeatures: ...
        def __and__(self, other: typing.Union[int, GeocodingFeature]) -> GeocodingFeatures: ...
        def __xor__(self, other: typing.Union[int, GeocodingFeature]) -> GeocodingFeatures: ...
        def __ror__(self, other: typing.Union[int, GeocodingFeature]) -> GeocodingFeatures: ...
        def __rand__(self, other: typing.Union[int, GeocodingFeature]) -> GeocodingFeatures: ...
        def __rxor__(self, other: typing.Union[int, GeocodingFeature]) -> GeocodingFeatures: ...
        def __ior__(self, other: typing.Union[int, GeocodingFeature]) -> GeocodingFeatures: ...
        def __iand__(self, other: typing.Union[int, GeocodingFeature]) -> GeocodingFeatures: ...
        def __ixor__(self, other: typing.Union[int, GeocodingFeature]) -> GeocodingFeatures: ...
        def __invert__(self) -> GeocodingFeatures: ...

    class GeocodingFeatures(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, GeocodingFeature, GeocodingFeatures] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, GeocodingFeature, GeocodingFeatures]) -> GeocodingFeatures: ...
        def __and__(self, other: typing.Union[int, GeocodingFeature, GeocodingFeatures]) -> GeocodingFeatures: ...
        def __xor__(self, other: typing.Union[int, GeocodingFeature, GeocodingFeatures]) -> GeocodingFeatures: ...
        def __ror__(self, other: typing.Union[int, GeocodingFeature, GeocodingFeatures]) -> GeocodingFeatures: ...
        def __rand__(self, other: typing.Union[int, GeocodingFeature, GeocodingFeatures]) -> GeocodingFeatures: ...
        def __rxor__(self, other: typing.Union[int, GeocodingFeature, GeocodingFeatures]) -> GeocodingFeatures: ...
        def __ior__(self, other: typing.Union[int, GeocodingFeature, GeocodingFeatures]) -> GeocodingFeatures: ...
        def __iand__(self, other: typing.Union[int, GeocodingFeature, GeocodingFeatures]) -> GeocodingFeatures: ...
        def __ixor__(self, other: typing.Union[int, GeocodingFeature, GeocodingFeatures]) -> GeocodingFeatures: ...
        def __invert__(self) -> GeocodingFeatures: ...

    class MappingFeature(object):
        AnyMappingFeatures       : QGeoServiceProvider.MappingFeature = ... # -0x1
        NoMappingFeatures        : QGeoServiceProvider.MappingFeature = ... # 0x0
        OnlineMappingFeature     : QGeoServiceProvider.MappingFeature = ... # 0x1
        OfflineMappingFeature    : QGeoServiceProvider.MappingFeature = ... # 0x2
        LocalizedMappingFeature  : QGeoServiceProvider.MappingFeature = ... # 0x4
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, MappingFeature] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, MappingFeature]) -> MappingFeatures: ...
        def __and__(self, other: typing.Union[int, MappingFeature]) -> MappingFeatures: ...
        def __xor__(self, other: typing.Union[int, MappingFeature]) -> MappingFeatures: ...
        def __ror__(self, other: typing.Union[int, MappingFeature]) -> MappingFeatures: ...
        def __rand__(self, other: typing.Union[int, MappingFeature]) -> MappingFeatures: ...
        def __rxor__(self, other: typing.Union[int, MappingFeature]) -> MappingFeatures: ...
        def __ior__(self, other: typing.Union[int, MappingFeature]) -> MappingFeatures: ...
        def __iand__(self, other: typing.Union[int, MappingFeature]) -> MappingFeatures: ...
        def __ixor__(self, other: typing.Union[int, MappingFeature]) -> MappingFeatures: ...
        def __invert__(self) -> MappingFeatures: ...

    class MappingFeatures(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, MappingFeature, MappingFeatures] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, MappingFeature, MappingFeatures]) -> MappingFeatures: ...
        def __and__(self, other: typing.Union[int, MappingFeature, MappingFeatures]) -> MappingFeatures: ...
        def __xor__(self, other: typing.Union[int, MappingFeature, MappingFeatures]) -> MappingFeatures: ...
        def __ror__(self, other: typing.Union[int, MappingFeature, MappingFeatures]) -> MappingFeatures: ...
        def __rand__(self, other: typing.Union[int, MappingFeature, MappingFeatures]) -> MappingFeatures: ...
        def __rxor__(self, other: typing.Union[int, MappingFeature, MappingFeatures]) -> MappingFeatures: ...
        def __ior__(self, other: typing.Union[int, MappingFeature, MappingFeatures]) -> MappingFeatures: ...
        def __iand__(self, other: typing.Union[int, MappingFeature, MappingFeatures]) -> MappingFeatures: ...
        def __ixor__(self, other: typing.Union[int, MappingFeature, MappingFeatures]) -> MappingFeatures: ...
        def __invert__(self) -> MappingFeatures: ...

    class NavigationFeature(object):
        AnyNavigationFeatures    : QGeoServiceProvider.NavigationFeature = ... # -0x1
        NoNavigationFeatures     : QGeoServiceProvider.NavigationFeature = ... # 0x0
        OnlineNavigationFeature  : QGeoServiceProvider.NavigationFeature = ... # 0x1
        OfflineNavigationFeature : QGeoServiceProvider.NavigationFeature = ... # 0x2
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, NavigationFeature] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, NavigationFeature]) -> NavigationFeatures: ...
        def __and__(self, other: typing.Union[int, NavigationFeature]) -> NavigationFeatures: ...
        def __xor__(self, other: typing.Union[int, NavigationFeature]) -> NavigationFeatures: ...
        def __ror__(self, other: typing.Union[int, NavigationFeature]) -> NavigationFeatures: ...
        def __rand__(self, other: typing.Union[int, NavigationFeature]) -> NavigationFeatures: ...
        def __rxor__(self, other: typing.Union[int, NavigationFeature]) -> NavigationFeatures: ...
        def __ior__(self, other: typing.Union[int, NavigationFeature]) -> NavigationFeatures: ...
        def __iand__(self, other: typing.Union[int, NavigationFeature]) -> NavigationFeatures: ...
        def __ixor__(self, other: typing.Union[int, NavigationFeature]) -> NavigationFeatures: ...
        def __invert__(self) -> NavigationFeatures: ...

    class NavigationFeatures(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, NavigationFeature, NavigationFeatures] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, NavigationFeature, NavigationFeatures]) -> NavigationFeatures: ...
        def __and__(self, other: typing.Union[int, NavigationFeature, NavigationFeatures]) -> NavigationFeatures: ...
        def __xor__(self, other: typing.Union[int, NavigationFeature, NavigationFeatures]) -> NavigationFeatures: ...
        def __ror__(self, other: typing.Union[int, NavigationFeature, NavigationFeatures]) -> NavigationFeatures: ...
        def __rand__(self, other: typing.Union[int, NavigationFeature, NavigationFeatures]) -> NavigationFeatures: ...
        def __rxor__(self, other: typing.Union[int, NavigationFeature, NavigationFeatures]) -> NavigationFeatures: ...
        def __ior__(self, other: typing.Union[int, NavigationFeature, NavigationFeatures]) -> NavigationFeatures: ...
        def __iand__(self, other: typing.Union[int, NavigationFeature, NavigationFeatures]) -> NavigationFeatures: ...
        def __ixor__(self, other: typing.Union[int, NavigationFeature, NavigationFeatures]) -> NavigationFeatures: ...
        def __invert__(self) -> NavigationFeatures: ...

    class PlacesFeature(object):
        AnyPlacesFeatures        : QGeoServiceProvider.PlacesFeature = ... # -0x1
        NoPlacesFeatures         : QGeoServiceProvider.PlacesFeature = ... # 0x0
        OnlinePlacesFeature      : QGeoServiceProvider.PlacesFeature = ... # 0x1
        OfflinePlacesFeature     : QGeoServiceProvider.PlacesFeature = ... # 0x2
        SavePlaceFeature         : QGeoServiceProvider.PlacesFeature = ... # 0x4
        RemovePlaceFeature       : QGeoServiceProvider.PlacesFeature = ... # 0x8
        SaveCategoryFeature      : QGeoServiceProvider.PlacesFeature = ... # 0x10
        RemoveCategoryFeature    : QGeoServiceProvider.PlacesFeature = ... # 0x20
        PlaceRecommendationsFeature: QGeoServiceProvider.PlacesFeature = ... # 0x40
        SearchSuggestionsFeature : QGeoServiceProvider.PlacesFeature = ... # 0x80
        LocalizedPlacesFeature   : QGeoServiceProvider.PlacesFeature = ... # 0x100
        NotificationsFeature     : QGeoServiceProvider.PlacesFeature = ... # 0x200
        PlaceMatchingFeature     : QGeoServiceProvider.PlacesFeature = ... # 0x400
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, PlacesFeature] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, PlacesFeature]) -> PlacesFeatures: ...
        def __and__(self, other: typing.Union[int, PlacesFeature]) -> PlacesFeatures: ...
        def __xor__(self, other: typing.Union[int, PlacesFeature]) -> PlacesFeatures: ...
        def __ror__(self, other: typing.Union[int, PlacesFeature]) -> PlacesFeatures: ...
        def __rand__(self, other: typing.Union[int, PlacesFeature]) -> PlacesFeatures: ...
        def __rxor__(self, other: typing.Union[int, PlacesFeature]) -> PlacesFeatures: ...
        def __ior__(self, other: typing.Union[int, PlacesFeature]) -> PlacesFeatures: ...
        def __iand__(self, other: typing.Union[int, PlacesFeature]) -> PlacesFeatures: ...
        def __ixor__(self, other: typing.Union[int, PlacesFeature]) -> PlacesFeatures: ...
        def __invert__(self) -> PlacesFeatures: ...

    class PlacesFeatures(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, PlacesFeature, PlacesFeatures] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, PlacesFeature, PlacesFeatures]) -> PlacesFeatures: ...
        def __and__(self, other: typing.Union[int, PlacesFeature, PlacesFeatures]) -> PlacesFeatures: ...
        def __xor__(self, other: typing.Union[int, PlacesFeature, PlacesFeatures]) -> PlacesFeatures: ...
        def __ror__(self, other: typing.Union[int, PlacesFeature, PlacesFeatures]) -> PlacesFeatures: ...
        def __rand__(self, other: typing.Union[int, PlacesFeature, PlacesFeatures]) -> PlacesFeatures: ...
        def __rxor__(self, other: typing.Union[int, PlacesFeature, PlacesFeatures]) -> PlacesFeatures: ...
        def __ior__(self, other: typing.Union[int, PlacesFeature, PlacesFeatures]) -> PlacesFeatures: ...
        def __iand__(self, other: typing.Union[int, PlacesFeature, PlacesFeatures]) -> PlacesFeatures: ...
        def __ixor__(self, other: typing.Union[int, PlacesFeature, PlacesFeatures]) -> PlacesFeatures: ...
        def __invert__(self) -> PlacesFeatures: ...

    class RoutingFeature(object):
        AnyRoutingFeatures       : QGeoServiceProvider.RoutingFeature = ... # -0x1
        NoRoutingFeatures        : QGeoServiceProvider.RoutingFeature = ... # 0x0
        OnlineRoutingFeature     : QGeoServiceProvider.RoutingFeature = ... # 0x1
        OfflineRoutingFeature    : QGeoServiceProvider.RoutingFeature = ... # 0x2
        LocalizedRoutingFeature  : QGeoServiceProvider.RoutingFeature = ... # 0x4
        RouteUpdatesFeature      : QGeoServiceProvider.RoutingFeature = ... # 0x8
        AlternativeRoutesFeature : QGeoServiceProvider.RoutingFeature = ... # 0x10
        ExcludeAreasRoutingFeature: QGeoServiceProvider.RoutingFeature = ... # 0x20
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, RoutingFeature] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, RoutingFeature]) -> RoutingFeatures: ...
        def __and__(self, other: typing.Union[int, RoutingFeature]) -> RoutingFeatures: ...
        def __xor__(self, other: typing.Union[int, RoutingFeature]) -> RoutingFeatures: ...
        def __ror__(self, other: typing.Union[int, RoutingFeature]) -> RoutingFeatures: ...
        def __rand__(self, other: typing.Union[int, RoutingFeature]) -> RoutingFeatures: ...
        def __rxor__(self, other: typing.Union[int, RoutingFeature]) -> RoutingFeatures: ...
        def __ior__(self, other: typing.Union[int, RoutingFeature]) -> RoutingFeatures: ...
        def __iand__(self, other: typing.Union[int, RoutingFeature]) -> RoutingFeatures: ...
        def __ixor__(self, other: typing.Union[int, RoutingFeature]) -> RoutingFeatures: ...
        def __invert__(self) -> RoutingFeatures: ...

    class RoutingFeatures(object):
        
        def __index__(self) -> int: ...
        def __init__(self, value: typing.Union[int, RoutingFeature, RoutingFeatures] = ...) -> None: ...
        def __or__(self, other: typing.Union[int, RoutingFeature, RoutingFeatures]) -> RoutingFeatures: ...
        def __and__(self, other: typing.Union[int, RoutingFeature, RoutingFeatures]) -> RoutingFeatures: ...
        def __xor__(self, other: typing.Union[int, RoutingFeature, RoutingFeatures]) -> RoutingFeatures: ...
        def __ror__(self, other: typing.Union[int, RoutingFeature, RoutingFeatures]) -> RoutingFeatures: ...
        def __rand__(self, other: typing.Union[int, RoutingFeature, RoutingFeatures]) -> RoutingFeatures: ...
        def __rxor__(self, other: typing.Union[int, RoutingFeature, RoutingFeatures]) -> RoutingFeatures: ...
        def __ior__(self, other: typing.Union[int, RoutingFeature, RoutingFeatures]) -> RoutingFeatures: ...
        def __iand__(self, other: typing.Union[int, RoutingFeature, RoutingFeatures]) -> RoutingFeatures: ...
        def __ixor__(self, other: typing.Union[int, RoutingFeature, RoutingFeatures]) -> RoutingFeatures: ...
        def __invert__(self) -> RoutingFeatures: ...

    def __init__(self, providerName:str, parameters:typing.Dict=..., allowExperimental:bool=...) -> None: ...

    @staticmethod
    def availableServiceProviders() -> typing.List: ...
    def error(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def errorString(self) -> str: ...
    def geocodingError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def geocodingErrorString(self) -> str: ...
    def geocodingFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.GeocodingFeatures: ...
    def geocodingManager(self) -> PySide2.QtLocation.QGeoCodingManager: ...
    def mappingError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def mappingErrorString(self) -> str: ...
    def mappingFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.MappingFeatures: ...
    def navigationError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def navigationErrorString(self) -> str: ...
    def navigationFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.NavigationFeatures: ...
    def placeManager(self) -> PySide2.QtLocation.QPlaceManager: ...
    def placesError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def placesErrorString(self) -> str: ...
    def placesFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.PlacesFeatures: ...
    def routingError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def routingErrorString(self) -> str: ...
    def routingFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.RoutingFeatures: ...
    def routingManager(self) -> PySide2.QtLocation.QGeoRoutingManager: ...
    def setAllowExperimental(self, allow:bool) -> None: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...
    def setParameters(self, parameters:typing.Dict) -> None: ...


class QGeoServiceProviderFactory(Shiboken.Object):

    def __init__(self) -> None: ...

    def createGeocodingManagerEngine(self, parameters:typing.Dict, error:PySide2.QtLocation.QGeoServiceProvider.Error) -> typing.Tuple: ...
    def createPlaceManagerEngine(self, parameters:typing.Dict, error:PySide2.QtLocation.QGeoServiceProvider.Error) -> typing.Tuple: ...
    def createRoutingManagerEngine(self, parameters:typing.Dict, error:PySide2.QtLocation.QGeoServiceProvider.Error) -> typing.Tuple: ...


class QGeoServiceProviderFactoryV2(PySide2.QtLocation.QGeoServiceProviderFactory):

    def __init__(self) -> None: ...


class QPlace(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlace) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def appendContactDetail(self, contactType:str, detail:PySide2.QtLocation.QPlaceContactDetail) -> None: ...
    def attribution(self) -> str: ...
    def categories(self) -> typing.List: ...
    def contactDetails(self, contactType:str) -> typing.List: ...
    def contactTypes(self) -> typing.List: ...
    def content(self, type:PySide2.QtLocation.QPlaceContent.Type) -> typing.Dict: ...
    def detailsFetched(self) -> bool: ...
    def extendedAttribute(self, attributeType:str) -> PySide2.QtLocation.QPlaceAttribute: ...
    def extendedAttributeTypes(self) -> typing.List: ...
    def icon(self) -> PySide2.QtLocation.QPlaceIcon: ...
    def insertContent(self, type:PySide2.QtLocation.QPlaceContent.Type, content:typing.Dict) -> None: ...
    def isEmpty(self) -> bool: ...
    def location(self) -> PySide2.QtPositioning.QGeoLocation: ...
    def name(self) -> str: ...
    def placeId(self) -> str: ...
    def primaryEmail(self) -> str: ...
    def primaryFax(self) -> str: ...
    def primaryPhone(self) -> str: ...
    def primaryWebsite(self) -> PySide2.QtCore.QUrl: ...
    def ratings(self) -> PySide2.QtLocation.QPlaceRatings: ...
    def removeContactDetails(self, contactType:str) -> None: ...
    def removeExtendedAttribute(self, attributeType:str) -> None: ...
    def setAttribution(self, attribution:str) -> None: ...
    def setCategories(self, categories:typing.Sequence) -> None: ...
    def setCategory(self, category:PySide2.QtLocation.QPlaceCategory) -> None: ...
    def setContactDetails(self, contactType:str, details:typing.Sequence) -> None: ...
    def setContent(self, type:PySide2.QtLocation.QPlaceContent.Type, content:typing.Dict) -> None: ...
    def setDetailsFetched(self, fetched:bool) -> None: ...
    def setExtendedAttribute(self, attributeType:str, attribute:PySide2.QtLocation.QPlaceAttribute) -> None: ...
    def setIcon(self, icon:PySide2.QtLocation.QPlaceIcon) -> None: ...
    def setLocation(self, location:PySide2.QtPositioning.QGeoLocation) -> None: ...
    def setName(self, name:str) -> None: ...
    def setPlaceId(self, identifier:str) -> None: ...
    def setRatings(self, ratings:PySide2.QtLocation.QPlaceRatings) -> None: ...
    def setSupplier(self, supplier:PySide2.QtLocation.QPlaceSupplier) -> None: ...
    def setTotalContentCount(self, type:PySide2.QtLocation.QPlaceContent.Type, total:int) -> None: ...
    def supplier(self) -> PySide2.QtLocation.QPlaceSupplier: ...
    def totalContentCount(self, type:PySide2.QtLocation.QPlaceContent.Type) -> int: ...


class QPlaceAttribute(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceAttribute) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isEmpty(self) -> bool: ...
    def label(self) -> str: ...
    def setLabel(self, label:str) -> None: ...
    def setText(self, text:str) -> None: ...
    def text(self) -> str: ...


class QPlaceCategory(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceCategory) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def categoryId(self) -> str: ...
    def icon(self) -> PySide2.QtLocation.QPlaceIcon: ...
    def isEmpty(self) -> bool: ...
    def name(self) -> str: ...
    def setCategoryId(self, identifier:str) -> None: ...
    def setIcon(self, icon:PySide2.QtLocation.QPlaceIcon) -> None: ...
    def setName(self, name:str) -> None: ...


class QPlaceContactDetail(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContactDetail) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    def label(self) -> str: ...
    def setLabel(self, label:str) -> None: ...
    def setValue(self, value:str) -> None: ...
    def value(self) -> str: ...


class QPlaceContent(Shiboken.Object):
    NoType                   : QPlaceContent.Type = ... # 0x0
    ImageType                : QPlaceContent.Type = ... # 0x1
    ReviewType               : QPlaceContent.Type = ... # 0x2
    EditorialType            : QPlaceContent.Type = ... # 0x3
    CustomType               : QPlaceContent.Type = ... # 0x100

    class Type(object):
        NoType                   : QPlaceContent.Type = ... # 0x0
        ImageType                : QPlaceContent.Type = ... # 0x1
        ReviewType               : QPlaceContent.Type = ... # 0x2
        EditorialType            : QPlaceContent.Type = ... # 0x3
        CustomType               : QPlaceContent.Type = ... # 0x100

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContent) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def attribution(self) -> str: ...
    def setAttribution(self, attribution:str) -> None: ...
    def setSupplier(self, supplier:PySide2.QtLocation.QPlaceSupplier) -> None: ...
    def setUser(self, user:PySide2.QtLocation.QPlaceUser) -> None: ...
    def supplier(self) -> PySide2.QtLocation.QPlaceSupplier: ...
    def type(self) -> PySide2.QtLocation.QPlaceContent.Type: ...
    def user(self) -> PySide2.QtLocation.QPlaceUser: ...


class QPlaceContentReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def content(self) -> typing.Dict: ...
    def nextPageRequest(self) -> PySide2.QtLocation.QPlaceContentRequest: ...
    def previousPageRequest(self) -> PySide2.QtLocation.QPlaceContentRequest: ...
    def request(self) -> PySide2.QtLocation.QPlaceContentRequest: ...
    def setContent(self, content:typing.Dict) -> None: ...
    def setNextPageRequest(self, next:PySide2.QtLocation.QPlaceContentRequest) -> None: ...
    def setPreviousPageRequest(self, previous:PySide2.QtLocation.QPlaceContentRequest) -> None: ...
    def setRequest(self, request:PySide2.QtLocation.QPlaceContentRequest) -> None: ...
    def setTotalCount(self, total:int) -> None: ...
    def totalCount(self) -> int: ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceContentRequest(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContentRequest) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    def contentContext(self) -> typing.Any: ...
    def contentType(self) -> PySide2.QtLocation.QPlaceContent.Type: ...
    def limit(self) -> int: ...
    def placeId(self) -> str: ...
    def setContentContext(self, context:typing.Any) -> None: ...
    def setContentType(self, type:PySide2.QtLocation.QPlaceContent.Type) -> None: ...
    def setLimit(self, limit:int) -> None: ...
    def setPlaceId(self, identifier:str) -> None: ...


class QPlaceDetailsReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def place(self) -> PySide2.QtLocation.QPlace: ...
    def setPlace(self, place:PySide2.QtLocation.QPlace) -> None: ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceEditorial(PySide2.QtLocation.QPlaceContent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContent) -> None: ...

    def language(self) -> str: ...
    def setLanguage(self, data:str) -> None: ...
    def setText(self, text:str) -> None: ...
    def setTitle(self, data:str) -> None: ...
    def text(self) -> str: ...
    def title(self) -> str: ...


class QPlaceIcon(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceIcon) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isEmpty(self) -> bool: ...
    def manager(self) -> PySide2.QtLocation.QPlaceManager: ...
    def parameters(self) -> typing.Dict: ...
    def setManager(self, manager:PySide2.QtLocation.QPlaceManager) -> None: ...
    def setParameters(self, parameters:typing.Dict) -> None: ...
    def url(self, size:PySide2.QtCore.QSize=...) -> PySide2.QtCore.QUrl: ...


class QPlaceIdReply(PySide2.QtLocation.QPlaceReply):
    SavePlace                : QPlaceIdReply.OperationType = ... # 0x0
    SaveCategory             : QPlaceIdReply.OperationType = ... # 0x1
    RemovePlace              : QPlaceIdReply.OperationType = ... # 0x2
    RemoveCategory           : QPlaceIdReply.OperationType = ... # 0x3

    class OperationType(object):
        SavePlace                : QPlaceIdReply.OperationType = ... # 0x0
        SaveCategory             : QPlaceIdReply.OperationType = ... # 0x1
        RemovePlace              : QPlaceIdReply.OperationType = ... # 0x2
        RemoveCategory           : QPlaceIdReply.OperationType = ... # 0x3

    def __init__(self, operationType:PySide2.QtLocation.QPlaceIdReply.OperationType, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def id(self) -> str: ...
    def operationType(self) -> PySide2.QtLocation.QPlaceIdReply.OperationType: ...
    def setId(self, identifier:str) -> None: ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceImage(PySide2.QtLocation.QPlaceContent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContent) -> None: ...

    def imageId(self) -> str: ...
    def mimeType(self) -> str: ...
    def setImageId(self, identifier:str) -> None: ...
    def setMimeType(self, data:str) -> None: ...
    def setUrl(self, url:PySide2.QtCore.QUrl) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QPlaceManager(PySide2.QtCore.QObject):

    categoryAdded: PySide2.QtCore.Signal
    categoryRemoved: PySide2.QtCore.Signal
    categoryUpdated: PySide2.QtCore.Signal
    dataChanged: PySide2.QtCore.Signal
    error: PySide2.QtCore.Signal
    finished: PySide2.QtCore.Signal
    placeAdded: PySide2.QtCore.Signal
    placeRemoved: PySide2.QtCore.Signal
    placeUpdated: PySide2.QtCore.Signal

    def category(self, categoryId:str) -> PySide2.QtLocation.QPlaceCategory: ...
    def childCategories(self, parentId:str=...) -> typing.List: ...
    def childCategoryIds(self, parentId:str=...) -> typing.List: ...
    def compatiblePlace(self, place:PySide2.QtLocation.QPlace) -> PySide2.QtLocation.QPlace: ...
    def getPlaceContent(self, request:PySide2.QtLocation.QPlaceContentRequest) -> PySide2.QtLocation.QPlaceContentReply: ...
    def getPlaceDetails(self, placeId:str) -> PySide2.QtLocation.QPlaceDetailsReply: ...
    def initializeCategories(self) -> PySide2.QtLocation.QPlaceReply: ...
    def locales(self) -> typing.List: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def matchingPlaces(self, request:PySide2.QtLocation.QPlaceMatchRequest) -> PySide2.QtLocation.QPlaceMatchReply: ...
    def parentCategoryId(self, categoryId:str) -> str: ...
    def removeCategory(self, categoryId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def removePlace(self, placeId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def saveCategory(self, category:PySide2.QtLocation.QPlaceCategory, parentId:str=...) -> PySide2.QtLocation.QPlaceIdReply: ...
    def savePlace(self, place:PySide2.QtLocation.QPlace) -> PySide2.QtLocation.QPlaceIdReply: ...
    def search(self, query:PySide2.QtLocation.QPlaceSearchRequest) -> PySide2.QtLocation.QPlaceSearchReply: ...
    def searchSuggestions(self, request:PySide2.QtLocation.QPlaceSearchRequest) -> PySide2.QtLocation.QPlaceSearchSuggestionReply: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...
    def setLocales(self, locale:typing.Sequence) -> None: ...


class QPlaceManagerEngine(PySide2.QtCore.QObject):

    categoryAdded: PySide2.QtCore.Signal
    categoryRemoved: PySide2.QtCore.Signal
    categoryUpdated: PySide2.QtCore.Signal
    dataChanged: PySide2.QtCore.Signal
    error: PySide2.QtCore.Signal
    finished: PySide2.QtCore.Signal
    placeAdded: PySide2.QtCore.Signal
    placeRemoved: PySide2.QtCore.Signal
    placeUpdated: PySide2.QtCore.Signal


    def __init__(self, parameters:typing.Dict, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def category(self, categoryId:str) -> PySide2.QtLocation.QPlaceCategory: ...
    def childCategories(self, parentId:str) -> typing.List: ...
    def childCategoryIds(self, categoryId:str) -> typing.List: ...
    def compatiblePlace(self, original:PySide2.QtLocation.QPlace) -> PySide2.QtLocation.QPlace: ...
    def constructIconUrl(self, icon:PySide2.QtLocation.QPlaceIcon, size:PySide2.QtCore.QSize) -> PySide2.QtCore.QUrl: ...
    def getPlaceContent(self, request:PySide2.QtLocation.QPlaceContentRequest) -> PySide2.QtLocation.QPlaceContentReply: ...
    def getPlaceDetails(self, placeId:str) -> PySide2.QtLocation.QPlaceDetailsReply: ...
    def initializeCategories(self) -> PySide2.QtLocation.QPlaceReply: ...
    def locales(self) -> typing.List: ...
    def manager(self) -> PySide2.QtLocation.QPlaceManager: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def matchingPlaces(self, request:PySide2.QtLocation.QPlaceMatchRequest) -> PySide2.QtLocation.QPlaceMatchReply: ...
    def parentCategoryId(self, categoryId:str) -> str: ...
    def removeCategory(self, categoryId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def removePlace(self, placeId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def saveCategory(self, category:PySide2.QtLocation.QPlaceCategory, parentId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def savePlace(self, place:PySide2.QtLocation.QPlace) -> PySide2.QtLocation.QPlaceIdReply: ...
    def search(self, request:PySide2.QtLocation.QPlaceSearchRequest) -> PySide2.QtLocation.QPlaceSearchReply: ...
    def searchSuggestions(self, request:PySide2.QtLocation.QPlaceSearchRequest) -> PySide2.QtLocation.QPlaceSearchSuggestionReply: ...
    def setLocales(self, locales:typing.Sequence) -> None: ...


class QPlaceMatchReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def places(self) -> typing.List: ...
    def request(self) -> PySide2.QtLocation.QPlaceMatchRequest: ...
    def setPlaces(self, results:typing.Sequence) -> None: ...
    def setRequest(self, request:PySide2.QtLocation.QPlaceMatchRequest) -> None: ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceMatchRequest(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceMatchRequest) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    def parameters(self) -> typing.Dict: ...
    def places(self) -> typing.List: ...
    def setParameters(self, parameters:typing.Dict) -> None: ...
    def setPlaces(self, places:typing.Sequence) -> None: ...
    def setResults(self, results:typing.Sequence) -> None: ...


class QPlaceProposedSearchResult(PySide2.QtLocation.QPlaceSearchResult):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSearchResult) -> None: ...

    def searchRequest(self) -> PySide2.QtLocation.QPlaceSearchRequest: ...
    def setSearchRequest(self, request:PySide2.QtLocation.QPlaceSearchRequest) -> None: ...


class QPlaceRatings(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceRatings) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def average(self) -> float: ...
    def count(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def maximum(self) -> float: ...
    def setAverage(self, average:float) -> None: ...
    def setCount(self, count:int) -> None: ...
    def setMaximum(self, max:float) -> None: ...


class QPlaceReply(PySide2.QtCore.QObject):

    aborted: PySide2.QtCore.Signal
    contentUpdated: PySide2.QtCore.Signal
    error: PySide2.QtCore.Signal
    finished: PySide2.QtCore.Signal

    NoError                  : QPlaceReply.Error = ... # 0x0
    Reply                    : QPlaceReply.Type = ... # 0x0
    DetailsReply             : QPlaceReply.Type = ... # 0x1
    PlaceDoesNotExistError   : QPlaceReply.Error = ... # 0x1
    CategoryDoesNotExistError: QPlaceReply.Error = ... # 0x2
    SearchReply              : QPlaceReply.Type = ... # 0x2
    CommunicationError       : QPlaceReply.Error = ... # 0x3
    SearchSuggestionReply    : QPlaceReply.Type = ... # 0x3
    ContentReply             : QPlaceReply.Type = ... # 0x4
    ParseError               : QPlaceReply.Error = ... # 0x4
    IdReply                  : QPlaceReply.Type = ... # 0x5
    PermissionsError         : QPlaceReply.Error = ... # 0x5
    MatchReply               : QPlaceReply.Type = ... # 0x6
    UnsupportedError         : QPlaceReply.Error = ... # 0x6
    BadArgumentError         : QPlaceReply.Error = ... # 0x7
    CancelError              : QPlaceReply.Error = ... # 0x8
    UnknownError             : QPlaceReply.Error = ... # 0x9

    class Error(object):
        NoError                  : QPlaceReply.Error = ... # 0x0
        PlaceDoesNotExistError   : QPlaceReply.Error = ... # 0x1
        CategoryDoesNotExistError: QPlaceReply.Error = ... # 0x2
        CommunicationError       : QPlaceReply.Error = ... # 0x3
        ParseError               : QPlaceReply.Error = ... # 0x4
        PermissionsError         : QPlaceReply.Error = ... # 0x5
        UnsupportedError         : QPlaceReply.Error = ... # 0x6
        BadArgumentError         : QPlaceReply.Error = ... # 0x7
        CancelError              : QPlaceReply.Error = ... # 0x8
        UnknownError             : QPlaceReply.Error = ... # 0x9

    class Type(object):
        Reply                    : QPlaceReply.Type = ... # 0x0
        DetailsReply             : QPlaceReply.Type = ... # 0x1
        SearchReply              : QPlaceReply.Type = ... # 0x2
        SearchSuggestionReply    : QPlaceReply.Type = ... # 0x3
        ContentReply             : QPlaceReply.Type = ... # 0x4
        IdReply                  : QPlaceReply.Type = ... # 0x5
        MatchReply               : QPlaceReply.Type = ... # 0x6

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def abort(self) -> None: ...
    def error(self) -> PySide2.QtLocation.QPlaceReply.Error: ...
    def errorString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def setError(self, error:PySide2.QtLocation.QPlaceReply.Error, errorString:str) -> None: ...
    def setFinished(self, finished:bool) -> None: ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceResult(PySide2.QtLocation.QPlaceSearchResult):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSearchResult) -> None: ...

    def distance(self) -> float: ...
    def isSponsored(self) -> bool: ...
    def place(self) -> PySide2.QtLocation.QPlace: ...
    def setDistance(self, distance:float) -> None: ...
    def setPlace(self, place:PySide2.QtLocation.QPlace) -> None: ...
    def setSponsored(self, sponsored:bool) -> None: ...


class QPlaceReview(PySide2.QtLocation.QPlaceContent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContent) -> None: ...

    def dateTime(self) -> PySide2.QtCore.QDateTime: ...
    def language(self) -> str: ...
    def rating(self) -> float: ...
    def reviewId(self) -> str: ...
    def setDateTime(self, dt:PySide2.QtCore.QDateTime) -> None: ...
    def setLanguage(self, data:str) -> None: ...
    def setRating(self, data:float) -> None: ...
    def setReviewId(self, identifier:str) -> None: ...
    def setText(self, text:str) -> None: ...
    def setTitle(self, data:str) -> None: ...
    def text(self) -> str: ...
    def title(self) -> str: ...


class QPlaceSearchReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def nextPageRequest(self) -> PySide2.QtLocation.QPlaceSearchRequest: ...
    def previousPageRequest(self) -> PySide2.QtLocation.QPlaceSearchRequest: ...
    def request(self) -> PySide2.QtLocation.QPlaceSearchRequest: ...
    def results(self) -> typing.List: ...
    def setNextPageRequest(self, next:PySide2.QtLocation.QPlaceSearchRequest) -> None: ...
    def setPreviousPageRequest(self, previous:PySide2.QtLocation.QPlaceSearchRequest) -> None: ...
    def setRequest(self, request:PySide2.QtLocation.QPlaceSearchRequest) -> None: ...
    def setResults(self, results:typing.Sequence) -> None: ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceSearchRequest(Shiboken.Object):
    UnspecifiedHint          : QPlaceSearchRequest.RelevanceHint = ... # 0x0
    DistanceHint             : QPlaceSearchRequest.RelevanceHint = ... # 0x1
    LexicalPlaceNameHint     : QPlaceSearchRequest.RelevanceHint = ... # 0x2

    class RelevanceHint(object):
        UnspecifiedHint          : QPlaceSearchRequest.RelevanceHint = ... # 0x0
        DistanceHint             : QPlaceSearchRequest.RelevanceHint = ... # 0x1
        LexicalPlaceNameHint     : QPlaceSearchRequest.RelevanceHint = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSearchRequest) -> None: ...

    def categories(self) -> typing.List: ...
    def clear(self) -> None: ...
    def limit(self) -> int: ...
    def recommendationId(self) -> str: ...
    def relevanceHint(self) -> PySide2.QtLocation.QPlaceSearchRequest.RelevanceHint: ...
    def searchArea(self) -> PySide2.QtPositioning.QGeoShape: ...
    def searchContext(self) -> typing.Any: ...
    def searchTerm(self) -> str: ...
    def setCategories(self, categories:typing.Sequence) -> None: ...
    def setCategory(self, category:PySide2.QtLocation.QPlaceCategory) -> None: ...
    def setLimit(self, limit:int) -> None: ...
    def setRecommendationId(self, recommendationId:str) -> None: ...
    def setRelevanceHint(self, hint:PySide2.QtLocation.QPlaceSearchRequest.RelevanceHint) -> None: ...
    def setSearchArea(self, area:PySide2.QtPositioning.QGeoShape) -> None: ...
    def setSearchContext(self, context:typing.Any) -> None: ...
    def setSearchTerm(self, term:str) -> None: ...


class QPlaceSearchResult(Shiboken.Object):
    UnknownSearchResult      : QPlaceSearchResult.SearchResultType = ... # 0x0
    PlaceResult              : QPlaceSearchResult.SearchResultType = ... # 0x1
    ProposedSearchResult     : QPlaceSearchResult.SearchResultType = ... # 0x2

    class SearchResultType(object):
        UnknownSearchResult      : QPlaceSearchResult.SearchResultType = ... # 0x0
        PlaceResult              : QPlaceSearchResult.SearchResultType = ... # 0x1
        ProposedSearchResult     : QPlaceSearchResult.SearchResultType = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSearchResult) -> None: ...

    def icon(self) -> PySide2.QtLocation.QPlaceIcon: ...
    def setIcon(self, icon:PySide2.QtLocation.QPlaceIcon) -> None: ...
    def setTitle(self, title:str) -> None: ...
    def title(self) -> str: ...
    def type(self) -> PySide2.QtLocation.QPlaceSearchResult.SearchResultType: ...


class QPlaceSearchSuggestionReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def setSuggestions(self, suggestions:typing.Sequence) -> None: ...
    def suggestions(self) -> typing.List: ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceSupplier(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSupplier) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def icon(self) -> PySide2.QtLocation.QPlaceIcon: ...
    def isEmpty(self) -> bool: ...
    def name(self) -> str: ...
    def setIcon(self, icon:PySide2.QtLocation.QPlaceIcon) -> None: ...
    def setName(self, data:str) -> None: ...
    def setSupplierId(self, identifier:str) -> None: ...
    def setUrl(self, data:PySide2.QtCore.QUrl) -> None: ...
    def supplierId(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QPlaceUser(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceUser) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def name(self) -> str: ...
    def setName(self, name:str) -> None: ...
    def setUserId(self, identifier:str) -> None: ...
    def userId(self) -> str: ...

# eof
