# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['arguebuf',
 'arguebuf.cli',
 'arguebuf.models',
 'arguebuf.schema',
 'arguebuf.services']

package_data = \
{'': ['*']}

install_requires = \
['arg-services>=1.0.4,<2.0.0',
 'graphviz>=0.20.1,<0.21.0',
 'lxml>=4.9.2,<5.0.0',
 'networkx>=2.8.8,<4.0',
 'pendulum>=2.1.2,<3.0.0']

extras_require = \
{'cli': ['typer[all]>=0.7.0,<0.8.0',
         'deepl>=1.12.0,<2.0.0',
         'multimethod>=1.9.1,<2.0.0'],
 'docs': ['sphinx>=5.0.0,<6.0.0',
          'furo>=2022.12.7,<2023.0.0',
          'myst-parser>=0.18.1,<0.19.0',
          'sphinx-autoapi>=2.0.0,<3.0.0',
          'autodocsumm>=0.2.9,<0.3.0'],
 'graphviz': ['pygraphviz>=1.10,<2.0']}

entry_points = \
{'console_scripts': ['arguebuf = arguebuf.cli.app:cli']}

setup_kwargs = {
    'name': 'arguebuf',
    'version': '2.0.0b8',
    'description': 'A library for loading argument graphs in various formats (e.g., AIF).',
    'long_description': '# Arguebuf\n\nArguebuf is a format for serializing argument graphs and specified using Protobuf.\nThe complete specification and documentation is available at the [Buf Schema Registry](https://buf.build/recap/arg-services/docs/main:arg_services.graph.v1).\nWhile Protobuf automatically generates native code for all major programming languages (including Python), we created a custom implementation that provides some additional benefits, including:\n\n- The ability to import existing formats like [AIF](http://www.argumentinterchange.org), [SADFace](https://github.com/Open-Argumentation/SADFace), and a few others.\n- Export of Arguebuf graphs to AIF, [NetworkX](https://networkx.org), and [Graphviz](https://graphviz.org).\n- Integration with the popular NLP library [spaCy](http://spacy.io).\n- Various helper methods to programmatically manipulate/create argument graphs.\n- More pythonic interfaces than the regular code generated by `protoc`.\n\nYou can easily install the library from [PyPI](https://pypi.org/project/arguebuf/) using pip. The documentation is hosted on [ReadTheDocs](https://arguebuf.readthedocs.io/en/latest/)\n\n## Command Line Interface (CLI)\n\nWe also offer some tools to simplify dealing with structured argument graphs.\nAmong others, it is possible to convert graphs between different formats, translate them, and render images using graphviz.\nTo use it, install the `cli` extras when installing the package.\nWhen using `pip`, this can be accomplished with\n\n`pip install arguebuf[cli]`\n\nAfterwards, you can execute it by calling `arguebuf`, for example:\n\n`arguebuf --help`\n',
    'author': 'Mirko Lenz',
    'author_email': 'info@mirko-lenz.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://recap.uni-trier.de',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
