# pysaint

[saint.ssu.ac.kr](https://saint.ssu.ac.kr) 에서 수강신청 과목정보를 실시간으로 가져오는 라이브러리 입니다.

최신버전은 20.11.7 입니다. (연도.월.일 순으로 버전을 표기합니다.)

## setup (for end user)
```sh
pip install pysaint
```

## setup (for library developer)
```sh
pip install .
```

## Usage

### get course data

```python
import pysaint

res = pysaint.get('전공', '2021', '1 학기', silent=True)

pysaint.save_json('./json/', '{}-{}-전공'.format('2020', '2 학기'), res)

res = pysaint.get('교양필수', range(2019, 2020), ('1 학기', '여름학기', '2 학기', '겨울학기'))

res = pysaint.get('교양선택', (2016, ), ('1 학기', ), silent=False)

res = pysaint.get('전공', '2021', '2 학기', line=200, silent=True)

res = pysaint.get('연계전공', '2021', '1 학기', line=200, silent=True)

res = pysaint.get('융합전공', '2021', '1 학기', line=200, silent=False)

res = pysaint.get('교직', '2021', '1 학기', line=200, silent=True)

res = pysaint.get('채플', '2021', '1 학기', line=200, silent=True)

# freeze as json file format
pysaint.save_json('./json/', '{}-{}-전공'.format('2016', '1 학기'), res)

# print result
import pprint
pprint.pprint(res)

```

### get grade data

```python
import pysaint

grades = pysaint.grade('2015xxxx')
# or you can pass password parameter after id
# e.g.) pysaint.grade('2015xxxx', 'example-password#%2015')
for grade in grades:
    print(grade)

>>>

{'과목ID': '21506737', '과목명': '기초공학수학', '이수년도': '2015', '이수학기': '1 학기', '학점수': '3', '성적기호': 'A-', '학술연구상태': '완료(성공)', '제외사유': 취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506736', '과목명': '물리1및실험', '이수년도': '2015', '이수학기': '1 학기', '학점수': '3', '성적기호': 'A-', '학술연구상태': '완료(성공)', '제외사유': '취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21503329', '과목명': '생활과경제', '이수년도': '2015', '이수학기': '1 학기', '학점수': '3', '성적기호': 'C+', '학술연구상태': '완료(성공)', '제외사유': '\소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506684', '과목명': '숭실인의역량과진로탐색1', '이수년도': '2015', '이수학기': '1 학기', '학점수': '1', '성적기호': 'A0', '학술연구상태': '완료(성공)', ' '\xa0', '승인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21501815', '과목명': '영어1', '이수년도': '2015', '이수학기': '1 학기', '학점수': '2', '성적기호': 'B-', '학술연구상태': '완료(성공)', '제외사유': '\xa0',': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506741', '과목명': '프로그래밍의이해', '이수년도': '2015', '이수학기': '1 학기', '학점수': '3', '성적기호': 'A0', '학술연구상태': '완료(성공)', '제외사유승인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506634', '과목명': '한반도평화와통일', '이수년도': '2015', '이수학기': '1 학기', '학점수': '1', '성적기호': 'B+', '학술연구상태': '완료(성공)', '제외사유일': '\xa0', '승인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21503037', '과목명': '현대인과성서1', '이수년도': '2015', '이수학기': '1 학기', '학점수': '3', '성적기호': 'A-', '학술연구상태': '완료(성공)', '제외사유':인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506797', '과목명': '공학수학', '이수년도': '2015', '이수학기': '2 학기', '학점수': '3', '성적기호': 'A-', '학술연구상태': '완료(성공)', '제외사유': '\xa일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506796', '과목명': '물리2및실험', '이수년도': '2015', '이수학기': '2 학기', '학점수': '3', '성적기호': 'A-', '학술연구상태': '완료(성공)', '제외사유': ' '신청일': '\xa0', '승인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21501816', '과목명': '영어2', '이수년도': '2015', '이수학기': '2 학기', '학점수': '2', '성적기호': 'A-', '학술연구상태': '완료(성공)', '제외사유': '\xa0',': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21505220', '과목명': '창의적사고와글쓰기', '이수년도': '2015', '이수학기': '2 학기', '학점수': '2', '성적기호': 'C+', '학술연구상태': '완료(성공)', '제외사'승인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506798', '과목명': '프로그래밍기초및실습', '이수년도': '2015', '이수학기': '2 학기', '학점수': '3', '성적기호': 'A-', '학술연구상태': '완료(성공)', '제외청구분': '\xa0', '신청일': '\xa0', '승인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21509167', '과목명': '현대음악의감상', '이수년도': '2015', '이수학기': '2 학기', '학점수': '3', '성적기호': 'B-', '학술연구상태': '완료(성공)', '제외사유'인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506867', '과목명': '고급프로그래밍및실습', '이수년도': '2016', '이수학기': '1 학기', '학점수': '3', '성적기호': 'A-', '학술연구상태': '완료(성공)', '제외 '승인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506870', '과목명': '디지털회로설계실험', '이수년도': '2016', '이수학기': '1 학기', '학점수': '1', '성적기호': 'B-', '학술연구상태': '완료(성공)', '제외사'신청구분': '\xa0', '신청일': '\xa0', '승인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506868', '과목명': '모바일프로그래밍', '이수년도': '2016', '이수학기': '1 학기', '학점수': '3', '성적기호': 'B-', '학술연구상태': '완료(성공)', '제외사유승인취소일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506866', '과목명': '이산수학', '이수년도': '2016', '이수학기': '1 학기', '학점수': '3', '성적기호': 'B-', '학술연구상태': '완료(성공)', '제외사유': '\xa일': '\xa0', '신청': '신청', '취소': '취소'}
{'과목ID': '21506685', '과목명': '창의적사고와독서토론', '이수년도': '2016', '이수학기': '1 학기', '학점수': '1', '성적기호': 'C-', '학술연구상태': '완료(성공)', '제외'\xa0', '신청구분': '\xa0', '신청일': '\xa0', '승인취소일': '\xa0', '신청': '신청', '취소': '취소'}

```
## data

### course

```python

전공

>>
{
    "2018": {
        "2 학기": {
            "인문대학": {
                "기독교학과": {
                    "기독교학과": [
                        {
                            "계획": " ",
                            "이수구분(주전공)": "전기-기독교",
                            "이수구분(다전공)": "복필-기독교/부필-기독교",
                            "공학인증": " ",
                            "교과영역": " ",
                            "과목번호": "2150655801",
                            "과목명": "기독교사회학개론",
                            "분반": " ",
                            "교수명": "이철\n이철",
                            "개설학과": "기독교학과",
                            "시간/학점(설계)": "3.00 /3",
                            "수강인원": "0",
                            "여석": "50",
                            "강의시간(강의실)": "수 10:30-11:45 (진리관 11307-이철)\n목 12:00-13:15 (조만식기념관 12202-이철)",
                            "수강대상": "1학년 기독교"
                        },
                        {
                            "계획": " ",
                            "이수구분(주전공)": "전기-기독교",
                            "이수구분(다전공)": "복필-기독교",
                            "공학인증": " ",
                            "교과영역": " ",
                            "과목번호": "2150655901",
                            "과목명": "기독교상담심리학",
                            "분반": " ",
                            "교수명": "박승민\n박승민",
                            "개설학과": "기독교학과",
                            "시간/학점(설계)": "3.00 /3",
                            "수강인원": "0",
                            "여석": "60",
                            "강의시간(강의실)": "화 12:00-13:15 (조만식기념관 12328-박승민)\n목 10:30-11:45 (조만식기념관 12202-박승민)",
                            "수강대상": "1학년 기독교"
                        },
                        {
                            "계획": " ",
                            "이수구분(주전공)": "전기-기독교",
                            "이수구분(다전공)": "복필-기독교/부필-기독교",
                            "공학인증": " ",
                            "교과영역": " ",
                            "과목번호": "2150517001",
                            "과목명": "기독교학서론",
                            "분반": " ",
                            "교수명": "권연경\n권연경",
                            "개설학과": "기독교학과",
                            "시간/학점(설계)": "3.00 /3 (0 )",
                            "수강인원": "0",
                            "여석": "60",
                            "강의시간(강의실)": "수 09:00-10:15 (조만식기념관 12202-권연경)\n금 12:00-13:15 (조만식기념관 12310-권연경)",
                            "수강대상": "1학년 기독교"
                        },
                        ...

교양필수

{
  "2015": {
    "1 학기": {
      "전체학년": {
        "CHAPEL": [
          {
            "계획": " ",
            "이수구분(주전공)": "교필",
            "이수구분(다전공)": " ",
            "공학인증": " ",
            "교과영역": "채플과목",
            "과목번호": "2150101513",
            "과목명": "채플",
            "분반": " ",
            "교수명": " ",
            "개설학과": "베어드학부대학 행정팀",
            "시간/학점(설계)": "1.00 /0 (0 )",
            "수강인원": "187",
            "여석": "812",
            "강의시간(강의실)": "토 07:00-07:50 (형남공학관 050115-)",
            "수강대상": "전체학년 금융경제 ,국제무역 ,혁신경영학과(계약학과) ,벤처경영학과(계약학과)"
          },
          {
            "계획": " ",
            "이수구분(주전공)": "교필",
            "이수구분(다전공)": " ",
            "공학인증": " ",
            "교과영역": "채플과목",
            "과목번호": "2150101512",
            "과목명": "채플(공통채플:기독인채플)",
            "분반": " ",
            "교수명": " ",
            "개설학과": "베어드학부대학 행정팀",
            "시간/학점(설계)": "1.00 /0 (0 )",
            "수강인원": "117",
            "여석": "0",
            "강의시간(강의실)": "수 15:00-15:50 (-)",
            "수강대상": "전체"
          },
          ...

교양선택

{
  "2016": {
    "1 학기": {
      "전체": [
        {
          "계획": " ",
          "이수구분(주전공)": "교선",
          "이수구분(다전공)": " ",
          "공학인증": " ",
          "교과영역": "균형교양(자연과학-자연과학)\n*자연과학과수리(융합-자연)",
          "과목번호": "2150116601",
          "과목명": "과학사",
          "분반": " ",
          "교수명": "이권재",
          "개설학과": "물리학과",
          "시간/학점(설계)": "3.00 /3 (0 )",
          "수강인원": "32",
          "여석": "18",
          "강의시간(강의실)": "월 수 16:30-17:45 (조만식기념관 12525-이권재)",
          "수강대상": "전체"
        },
        {
          "계획": " ",
          "이수구분(주전공)": "교선",
          "이수구분(다전공)": " ",
          "공학인증": " ",
          "교과영역": "균형교양(사회과학-사회/정치/경제)\n*세계의문화와국제관계(핵심-창의)",
          "과목번호": "2150121901",
          "과목명": "국제관계의이해",
          "분반": " ",
          "교수명": "이한규",
          "개설학과": "정치외교학과",
          "시간/학점(설계)": "3.00 /3 (0 )",
          "수강인원": "57",
          "여석": "3",
          "강의시간(강의실)": "월 수 15:00-16:15 (미래관 20403-이한규)",
          "수강대상": "전체"
        },
        ...

```
