# singlearity
Baseball optimization API using machine learning

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import singlearity
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import singlearity
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import singlearity
from singlearity.rest import ApiException
from pprint import pprint

configuration = singlearity.Configuration()
# Configure API key authorization: APIKeyHeader
configuration.api_key['SINGLEARITY_API_KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SINGLEARITY_API_KEY'] = 'Bearer'
configuration = singlearity.Configuration()
# Configure API key authorization: APIKeyQuery
configuration.api_key['SINGLEARITY_API_KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SINGLEARITY_API_KEY'] = 'Bearer'

# Defining host is optional and default to http://localhost
configuration.host = "http://localhost"
# Enter a context with an instance of the API client
with singlearity.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = singlearity.APIsApi(api_client)
    game = singlearity.Game() # Game | 
num_sims = 100 # int |  (optional) (default to 100)

    try:
        # Get Inning Sim
        api_response = api_instance.get_inning_sim(game, num_sims=num_sims)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling APIsApi->get_inning_sim: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIsApi* | [**get_inning_sim**](docs/APIsApi.md#get_inning_sim) | **POST** /inning_runs_sim/ | Get Inning Sim
*APIsApi* | [**get_pa_sim**](docs/APIsApi.md#get_pa_sim) | **POST** /pa_sim/ | Get Pa Sim
*APIsApi* | [**get_players**](docs/APIsApi.md#get_players) | **GET** /players/ | Get Players
*APIsApi* | [**get_teams**](docs/APIsApi.md#get_teams) | **GET** /teams/ | Get Teams
*APIsApi* | [**get_venues**](docs/APIsApi.md#get_venues) | **GET** /venues/ | Get Venues
*APIsApi* | [**hello**](docs/APIsApi.md#hello) | **GET** /hello/ | Hello
*APIsApi* | [**hello_with_key**](docs/APIsApi.md#hello_with_key) | **GET** /hello_with_key/ | Hello With Key


## Documentation For Models

 - [Atmosphere](docs/Atmosphere.md)
 - [Game](docs/Game.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [Lineup](docs/Lineup.md)
 - [LineupPos](docs/LineupPos.md)
 - [Matchup](docs/Matchup.md)
 - [Player](docs/Player.md)
 - [State](docs/State.md)
 - [Team](docs/Team.md)
 - [ValidationError](docs/ValidationError.md)
 - [Venue](docs/Venue.md)


## Documentation For Authorization


## APIKeyHeader

- **Type**: API key
- **API key parameter name**: SINGLEARITY_API_KEY
- **Location**: HTTP header


## APIKeyQuery

- **Type**: API key
- **API key parameter name**: SINGLEARITY_API_KEY
- **Location**: URL query string


## Author




