# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0-SDK.3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class NetworkLoadBalancerForwardingRuleTarget(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ip': 'str',
        'port': 'int',
        'weight': 'int',
        'health_check': 'NetworkLoadBalancerForwardingRuleTargetHealthCheck',
    }

    attribute_map = {
        'ip': 'ip',
        'port': 'port',
        'weight': 'weight',
        'health_check': 'healthCheck',
    }

    def __init__(self, ip=None, port=None, weight=None, health_check=None, local_vars_configuration=None):  # noqa: E501
        """NetworkLoadBalancerForwardingRuleTarget - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._ip = None
        self._port = None
        self._weight = None
        self._health_check = None
        self.discriminator = None

        self.ip = ip
        self.port = port
        self.weight = weight
        if health_check is not None:
            self.health_check = health_check

    @property
    def ip(self):
        """Gets the ip of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501

        IP of a balanced target VM  # noqa: E501

        :return: The ip of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """Sets the ip of this NetworkLoadBalancerForwardingRuleTarget.

        IP of a balanced target VM  # noqa: E501

        :param ip: The ip of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501
        :type ip: str
        """
        if self.local_vars_configuration.client_side_validation and ip is None:  # noqa: E501
            raise ValueError("Invalid value for `ip`, must not be `None`")  # noqa: E501

        self._ip = ip

    @property
    def port(self):
        """Gets the port of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501

        Port of the balanced target service. (range: 1 to 65535)  # noqa: E501

        :return: The port of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this NetworkLoadBalancerForwardingRuleTarget.

        Port of the balanced target service. (range: 1 to 65535)  # noqa: E501

        :param port: The port of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501
        :type port: int
        """
        if self.local_vars_configuration.client_side_validation and port is None:  # noqa: E501
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    @property
    def weight(self):
        """Gets the weight of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501

        Weight parameter is used to adjust the target VM's weight relative to other target VMs. All target VMs will receive a load proportional to their weight relative to the sum of all weights, so the higher the weight, the higher the load. The default weight is 1, and the maximal value is 256. A value of 0 means the target VM will not participate in load-balancing but will still accept persistent connections. If this parameter is used to distribute the load according to target VM's capacity, it is recommended to start with values which can both grow and shrink, for instance between 10 and 100 to leave enough room above and below for later adjustments.  # noqa: E501

        :return: The weight of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501
        :rtype: int
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """Sets the weight of this NetworkLoadBalancerForwardingRuleTarget.

        Weight parameter is used to adjust the target VM's weight relative to other target VMs. All target VMs will receive a load proportional to their weight relative to the sum of all weights, so the higher the weight, the higher the load. The default weight is 1, and the maximal value is 256. A value of 0 means the target VM will not participate in load-balancing but will still accept persistent connections. If this parameter is used to distribute the load according to target VM's capacity, it is recommended to start with values which can both grow and shrink, for instance between 10 and 100 to leave enough room above and below for later adjustments.  # noqa: E501

        :param weight: The weight of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501
        :type weight: int
        """
        if self.local_vars_configuration.client_side_validation and weight is None:  # noqa: E501
            raise ValueError("Invalid value for `weight`, must not be `None`")  # noqa: E501

        self._weight = weight

    @property
    def health_check(self):
        """Gets the health_check of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501


        :return: The health_check of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501
        :rtype: NetworkLoadBalancerForwardingRuleTargetHealthCheck
        """
        return self._health_check

    @health_check.setter
    def health_check(self, health_check):
        """Sets the health_check of this NetworkLoadBalancerForwardingRuleTarget.


        :param health_check: The health_check of this NetworkLoadBalancerForwardingRuleTarget.  # noqa: E501
        :type health_check: NetworkLoadBalancerForwardingRuleTargetHealthCheck
        """

        self._health_check = health_check

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkLoadBalancerForwardingRuleTarget):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NetworkLoadBalancerForwardingRuleTarget):
            return True

        return self.to_dict() != other.to_dict()
