import { Cluster, HelmChart, KubernetesVersion } from 'aws-cdk-lib/aws-eks';
import { Construct } from 'constructs';
import { ISubnet } from 'aws-cdk-lib/aws-ec2';
import { EmrEksCluster } from './emr-eks-cluster';
/**
 * @internal
 * Upload podTemplates to the Amazon S3 location used by the cluster.
 * @param {Cluster} cluster the unique ID of the CDK resource
 * @param {Construct} scope The local path of the yaml podTemplate files to upload
 * @param {string} eksAdminRoleArn The admin role of the EKS cluster
 */
export declare function eksClusterSetup(cluster: EmrEksCluster, scope: Construct, eksAdminRoleArn?: string): void;
/**
 * @internal
 * Method to add the default EKS Managed Nodegroups configured for Spark workloads
 */
export declare function setDefaultManagedNodeGroups(cluster: EmrEksCluster): void;
/**
 * @internal
 * Method to add the default Karpenter provisioners for Spark workloads
 */
export declare function setDefaultKarpenterProvisioners(cluster: EmrEksCluster): void;
/**
 * @internal
 * Method to generate the Karpenter manifests from templates and targeted to the specific EKS cluster
 */
export declare function karpenterManifestSetup(clusterName: string, path: string, subnet: ISubnet): any;
/**
 * @internal
 * Install all the required configurations of Karpenter SQS and Event rules to handle spot and unhealthy instance termination
 * Create a security group to be used by nodes created with karpenter
 * Tags the subnets and VPC to be used by karpenter
 * create a tooling provisioner that will deploy in each of the AZs, one per AZ
 */
export declare function karpenterSetup(cluster: Cluster, eksClusterName: string, scope: Construct, karpenterVersion?: string): HelmChart;
/**
 * @internal
 * Deploy the cluster autoscaler controller in the k8s cluster
 */
export declare function clusterAutoscalerSetup(cluster: Cluster, eksClusterName: string, scope: Construct, k8sVersion: KubernetesVersion): void;
