"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_private_bucket_1 = require("@pepperize/cdk-private-bucket");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * A GitLab Runner cache consisting of an Amazon S3 bucket.
 *
 * The bucket is encrypted with a KMS managed master key, it has public access blocked and will be cleared and deleted on CFN stack deletion.
 */
class Cache extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        const bucketName = props.bucketName || "runner-cache";
        const uniqueCacheBucketName = `${scope.stackName}-${bucketName}-${scope.account}-${scope.region}`
            .slice(-63)
            .toLocaleLowerCase();
        /* Enabled if not 0. If 0 - cache doesn't expire. If undefined - expiration sets to expire in 30 days */
        const expiration = (_b = props.expiration) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.Duration.days(30);
        const lifeCycleRuleEnabled = expiration.toDays() !== 0;
        this.bucket = new cdk_private_bucket_1.PrivateBucket(scope, "CacheBucket", {
            bucketName: uniqueCacheBucketName,
            lifecycleRules: [
                {
                    enabled: lifeCycleRuleEnabled,
                    expiration: expiration,
                },
            ],
            autoDeleteObjects: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Cache", version: "0.2.72" };
//# sourceMappingURL=data:application/json;base64,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