import { aws_rds as rds, aws_secretsmanager as secretsmanager } from "aws-cdk-lib";
import { Construct } from "constructs";
import { BootstrapPgStacProps } from "../bootstrapper";
/**
 * An RDS instance with pgSTAC installed. This is a wrapper around the
 * `rds.DatabaseInstance` higher-level construct making use
 * of the BootstrapPgStac construct.
 */
export declare class PgStacDatabase extends Construct {
    db: rds.DatabaseInstance;
    pgstacSecret: secretsmanager.ISecret;
    constructor(scope: Construct, id: string, props: PgStacDatabaseProps);
}
export interface PgStacDatabaseProps extends rds.DatabaseInstanceProps {
    readonly pgstacDbName?: BootstrapPgStacProps["pgstacDbName"];
    readonly pgstacVersion?: BootstrapPgStacProps["pgstacVersion"];
    readonly pgstacUsername?: BootstrapPgStacProps["pgstacUsername"];
    readonly secretsPrefix?: BootstrapPgStacProps["secretsPrefix"];
}
