# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceQueryLineagePipeline.json
#   timestamp: 2022-10-12T10:45:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..type import filterPattern


class DatabaseLineageConfigType(Enum):
    DatabaseLineage = 'DatabaseLineage'


class DatabaseServiceQueryLineagePipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabaseLineageConfigType] = Field(
        DatabaseLineageConfigType.DatabaseLineage, description='Pipeline type'
    )
    queryLogDuration: Optional[int] = Field(
        1,
        description='Configuration to tune how far we want to look back in query logs to process lineage data.',
    )
    queryLogFilePath: Optional[str] = Field(
        None, description='Configuration to set the file path for query logs'
    )
    resultLimit: Optional[int] = Field(
        '1000', description='Configuration to set the limit for query logs'
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex to only fetch databases that matches the pattern.'
    )
