# generated by datamodel-codegen:
#   filename:  entity/services/connections/messaging/redpandaConnection.json
#   timestamp: 2022-10-12T10:45:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from .. import connectionBasicType


class RedpandaType(Enum):
    Redpanda = 'Redpanda'


class RedpandaConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[RedpandaType] = Field(
        RedpandaType.Redpanda, description='Service Type', title='Service Type'
    )
    bootstrapServers: str = Field(
        ...,
        description='Redpanda bootstrap servers. add them in comma separated values ex: host1:9092,host2:9092',
        title='Bootstrap Servers',
    )
    schemaRegistryURL: Optional[AnyUrl] = Field(
        None,
        description='Confluent Redpanda Schema Registry URL.',
        title='Schema Registry URL',
    )
    consumerConfig: Optional[Dict[str, Any]] = Field(
        {}, description='Confluent Redpanda Consumer Config', title='Consumer Config'
    )
    schemaRegistryConfig: Optional[Dict[str, Any]] = Field(
        {},
        description='Confluent Redpanda Schema Registry Config.',
        title='Schema Registry Config',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
