# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/databricksConnection.json
#   timestamp: 2022-10-12T10:45:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class DatabricksType(Enum):
    Databricks = 'Databricks'


class DatabricksScheme(Enum):
    databricks_connector = 'databricks+connector'


class DatabricksConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabricksType] = Field(
        DatabricksType.Databricks, description='Service Type', title='Service Type'
    )
    scheme: Optional[DatabricksScheme] = Field(
        DatabricksScheme.databricks_connector,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    hostPort: str = Field(
        ...,
        description='Host and port of the Databricks service.',
        title='Host and Port',
    )
    token: SecretStr = Field(
        ..., description='Generated Token to connect to Databricks.', title='Token'
    )
    httpPath: Optional[str] = Field(
        None, description='Databricks compute resources URL.', title='Http Path'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
