"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NagRules = exports.NagRuleCompliance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
/**
 * The compliance level of a resource in relation to a rule.
 *
 * @stability stable
 */
var NagRuleCompliance;
(function (NagRuleCompliance) {
    NagRuleCompliance["COMPLIANT"] = "Compliant";
    NagRuleCompliance["NON_COMPLIANT"] = "Non-Compliant";
    NagRuleCompliance["NOT_APPLICABLE"] = "N/A";
})(NagRuleCompliance = exports.NagRuleCompliance || (exports.NagRuleCompliance = {}));
/**
 * Helper class with methods for rule creation.
 *
 * @stability stable
 */
class NagRules {
    /**
     * Use in cases where a primitive value must be known to pass a rule.
     *
     * https://developer.mozilla.org/en-US/docs/Glossary/Primitive
     *
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return a value if resolves to a primitive data type, otherwise throw an error.
     * @stability stable
     */
    static resolveIfPrimitive(node, parameter) {
        const resolvedValue = monocdk_1.Stack.of(node).resolve(parameter);
        if (resolvedValue === Object(resolvedValue)) {
            throw Error(`The parameter resolved to to a non-primitive value "${JSON.stringify(resolvedValue)}", therefore the rule could not be validated.`);
        }
        else {
            return resolvedValue;
        }
    }
    /**
     * Use in cases where a token resolves to an intrinsic function and the referenced resource must be known to pass a rule.
     *
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return the Logical resource Id if resolves to a intrinsic function, otherwise the resolved provided value.
     * @stability stable
     */
    static resolveResourceFromInstrinsic(node, parameter) {
        const resolvedValue = monocdk_1.Stack.of(node).resolve(parameter);
        const ref = resolvedValue === null || resolvedValue === void 0 ? void 0 : resolvedValue.Ref;
        const getAtt = resolvedValue === null || resolvedValue === void 0 ? void 0 : resolvedValue['Fn::GetAtt'];
        if (ref != undefined) {
            return ref;
        }
        else if (Array.isArray(getAtt) && getAtt.length > 0) {
            return getAtt[0];
        }
        return resolvedValue;
    }
}
exports.NagRules = NagRules;
_a = JSII_RTTI_SYMBOL_1;
NagRules[_a] = { fqn: "monocdk-nag.NagRules", version: "1.3.5" };
//# sourceMappingURL=data:application/json;base64,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