"""Initial Schema

Peek Plugin Database Migration Script

Revision ID: 5288d02e94e4
Revises: 
Create Date: 2017-04-09 12:10:02.829698

"""

# revision identifiers, used by Alembic.
revision = '5288d02e94e4'
down_revision = None
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('ChatTuple',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('lastActivity', sa.DateTime(), nullable=False),
    sa.Column('usersKey', sa.String(length=4000), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_chat'
    )
    op.create_index('idx_Chat_usersKey', 'ChatTuple', ['usersKey'], unique=True, schema='pl_chat')
    op.create_table('Setting',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_chat'
    )
    op.create_table('ChatUserTuple',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('chatId', sa.Integer(), nullable=False),
    sa.Column('userId', sa.String(length=2000), nullable=False),
    sa.Column('isUserExternal', sa.Boolean(), nullable=False),
    sa.Column('lastReadDate', sa.DateTime(), nullable=False),
    sa.ForeignKeyConstraint(['chatId'], ['pl_chat.ChatTuple.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_chat'
    )
    op.create_index('idx_ChatUser_chatId', 'ChatUserTuple', ['chatId'], unique=False, schema='pl_chat')
    op.create_index('idx_ChatUser_userId', 'ChatUserTuple', ['userId'], unique=False, schema='pl_chat')
    op.create_table('MessageTuple',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('chatId', sa.Integer(), nullable=False),
    sa.Column('message', sa.String(length=2000), nullable=False),
    sa.Column('priority', sa.Integer(), nullable=False),
    sa.Column('fromUserId', sa.String(length=40), nullable=False),
    sa.Column('dateTime', sa.DateTime(), nullable=False),
    sa.Column('onReadPayload', sa.LargeBinary(), nullable=True),
    sa.ForeignKeyConstraint(['chatId'], ['pl_chat.ChatTuple.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_chat'
    )
    op.create_index('idx_ChatMsgTuple_chatId', 'MessageTuple', ['chatId'], unique=False, schema='pl_chat')
    op.create_index('idx_ChatMsgTuple_dateTime', 'MessageTuple', ['dateTime'], unique=False, schema='pl_chat')
    op.create_table('SettingProperty',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('settingId', sa.Integer(), nullable=False),
    sa.Column('key', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=16), nullable=True),
    sa.Column('int_value', sa.Integer(), nullable=True),
    sa.Column('char_value', sa.String(), nullable=True),
    sa.Column('boolean_value', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['settingId'], ['pl_chat.Setting.id'], ),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_chat'
    )
    op.create_index('idx_SettingProperty_settingId', 'SettingProperty', ['settingId'], unique=False, schema='pl_chat')
    op.create_table('MessageReadPayloadTuple',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('messageId', sa.Integer(), nullable=False),
    sa.Column('chatUserId', sa.Integer(), nullable=True),
    sa.Column('onReadPayload', sa.LargeBinary(), nullable=False),
    sa.ForeignKeyConstraint(['chatUserId'], ['pl_chat.ChatUserTuple.id'], ondelete='NO ACTION'),
    sa.ForeignKeyConstraint(['messageId'], ['pl_chat.MessageTuple.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_chat'
    )
    op.create_index('idx_ChatPayloads', 'MessageReadPayloadTuple', ['messageId', 'chatUserId'], unique=False, schema='pl_chat')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('idx_ChatPayloads', table_name='MessageReadPayloadTuple', schema='pl_chat')
    op.drop_table('MessageReadPayloadTuple', schema='pl_chat')
    op.drop_index('idx_SettingProperty_settingId', table_name='SettingProperty', schema='pl_chat')
    op.drop_table('SettingProperty', schema='pl_chat')
    op.drop_index('idx_ChatMsgTuple_dateTime', table_name='MessageTuple', schema='pl_chat')
    op.drop_index('idx_ChatMsgTuple_chatId', table_name='MessageTuple', schema='pl_chat')
    op.drop_table('MessageTuple', schema='pl_chat')
    op.drop_index('idx_ChatUser_userId', table_name='ChatUserTuple', schema='pl_chat')
    op.drop_index('idx_ChatUser_chatId', table_name='ChatUserTuple', schema='pl_chat')
    op.drop_table('ChatUserTuple', schema='pl_chat')
    op.drop_table('Setting', schema='pl_chat')
    op.drop_index('idx_Chat_usersKey', table_name='ChatTuple', schema='pl_chat')
    op.drop_table('ChatTuple', schema='pl_chat')
    # ### end Alembic commands ###