# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['new_celery_config']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML']

setup_kwargs = {
    'name': 'new-celery-config',
    'version': '0.1.0',
    'description': 'new_celery_config specifies Celery configuration via environment variables.',
    'long_description': '``new_celery_config`` specifies Celery config via environment variables\n=======================================================================\n\n`Celery <https://docs.celeryproject.org/en/stable/>`_ is a distributed task queue library for Python. It accepts some of its configuration via environment variables--but some configuration needs to be specified as Python code.\n\n``new_celery_config`` is a Python package that lets you set any top-level Celery key using an environment variable containing YAML.\n\nInstallation\n------------\n\nThe latest stable can be installed via pip:\n\n.. code:: text\n\n    python3 -m pip install new-celery-config\n\nUsage\n-----\n\nTo set configuration values, you must set an environment variables for each top-level key (`as documented in the Celery documentation <https://docs.celeryproject.org/en/latest/userguide/configuration.html#configuration>`_).\n\nEach environment variable is prefixed with ``NEW_CELERY_``, followed by the config key name in lowercase. The value for each environment variable must be valid YAML (or JSON--remember that JSON is a subset of YAML).\n\nFor example, setting these variables in the shell looks like:\n\n.. code:: bash\n\n    export BROKER_URL=\'transport://userid:password@hostname:port/virtual_host\'\n    export NEW_CELERY_broker_transport_options=\'{"visibility_timeout": 36000}\'\n\nUsage (as an object)\n^^^^^^^^^^^^^^^^^^^^\n\nThen, when you create your Celery object in code, you can pass it a ``new_celery_config.Config`` object. For example:\n\n.. code:: python\n\n    from celery import Celery\n    import new_celery_config\n\n    app = Celery()\n    app.config_from_object(new_celery_config.Config())\n\n\nand you can test that the configuration works by examining the ``app.conf`` object:\n\n.. code:: python\n\n    print(app.conf.broker_transport_options)\n    # prints out {\'visibility_timeout\': 36000}\n\n(Usage) as a module\n^^^^^^^^^^^^^^^^^^^\n\nCelery also accepts configuration from a module with top-level variables mapping to config keys. The location of this module can be set via an environment variable.\n\nIf your existing configuration is already in an module, then your code probably already looks like:\n\n.. code:: python\n\n    app = Celery()\n    app.config_from_envvar("ARBITRARY_CELERY_CONFIG_MODULE")\n\nwhere the value of ``ARBITRARY_CELERY_CONFIG_MODULE`` is something like ``your_project.celeryconfig``.\n\nIf you don\'t want to change your Python code to read, then just set your ``ARBITRARY_CELERY_CONFIG_MODULE`` environment variable to ``new_celery_config.as_module`` and everything will work as expected.\n\nContributing changes to ``new_celery_config``\n---------------------------------------------\n\nIf you want to make changes to ``new_celery_config``, you can clone this repository. You can run ``make`` in the root directory to show commands relevant to development.\n\nFor example:\n - ``make fmt`` automatically formats Python code.\n - ``make lint`` runs pylint and mypy to catch errors.\n - ``make test`` runs unit tests.\n',
    'author': 'Neocrym Records Inc.',
    'author_email': 'opensource@neocrym.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/neocrym/new_celery_config',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
