# Generated by Django 2.2.27 on 2022-03-09 08:09

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_polls', '0002_auto_20220227_1910'),
    ]

    operations = [
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(max_length=250, verbose_name='Name of the question')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.CreateModel(
            name='QuestionProposition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, max_length=250, null=True, verbose_name='Title')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.CreateModel(
            name='Response',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='createdVotesResponses', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.CreateModel(
            name='ResponseItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('response', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='djangoldp_polls.Response')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.RemoveField(
            model_name='poll',
            name='authorNotificationOnComment',
        ),
        migrations.RemoveField(
            model_name='poll',
            name='creationDate',
        ),
        migrations.RemoveField(
            model_name='poll',
            name='debate',
        ),
        migrations.RemoveField(
            model_name='poll',
            name='hostingOrganisation',
        ),
        migrations.RemoveField(
            model_name='poll',
            name='image',
        ),
        migrations.RemoveField(
            model_name='poll',
            name='longDescription',
        ),
        migrations.RemoveField(
            model_name='poll',
            name='shortDescription',
        ),
        migrations.RemoveField(
            model_name='poll',
            name='tags',
        ),
        migrations.AddField(
            model_name='poll',
            name='description',
            field=models.TextField(blank=True, null=True, verbose_name='description'),
        ),
        migrations.CreateModel(
            name='QuestionFreeText',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.Question')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.question',),
        ),
        migrations.CreateModel(
            name='QuestionScale',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.Question')),
                ('scale', models.IntegerField()),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.question',),
        ),
        migrations.CreateModel(
            name='QuestionWithPropositions',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.Question')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.question',),
        ),
        migrations.CreateModel(
            name='ResponseItemFreeText',
            fields=[
                ('responseitem_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.ResponseItem')),
                ('content', models.TextField()),
                ('relatedQuestion', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='responses', to='djangoldp_polls.QuestionFreeText')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.responseitem',),
        ),
        migrations.CreateModel(
            name='ResponseItemScale',
            fields=[
                ('responseitem_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.ResponseItem')),
                ('scale', models.IntegerField()),
                ('relatedQuestion', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_polls.QuestionScale')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.responseitem',),
        ),
        migrations.CreateModel(
            name='ResponseItemWithPropositions',
            fields=[
                ('responseitem_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.ResponseItem')),
                ('relatedPropositions', models.ManyToManyField(to='djangoldp_polls.QuestionProposition')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.responseitem',),
        ),
        migrations.DeleteModel(
            name='Tag',
        ),
        migrations.AddField(
            model_name='response',
            name='poll',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='responses', to='djangoldp_polls.Poll'),
        ),
        migrations.AddField(
            model_name='question',
            name='poll',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questions', to='djangoldp_polls.Poll'),
        ),
        migrations.CreateModel(
            name='QuestionCheckboxes',
            fields=[
                ('questionwithpropositions_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.QuestionWithPropositions')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.questionwithpropositions',),
        ),
        migrations.CreateModel(
            name='QuestionMultipleChoice',
            fields=[
                ('questionwithpropositions_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.QuestionWithPropositions')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.questionwithpropositions',),
        ),
        migrations.CreateModel(
            name='QuestionRadio',
            fields=[
                ('questionwithpropositions_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.QuestionWithPropositions')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.questionwithpropositions',),
        ),
        migrations.CreateModel(
            name='QuestionSingleChoice',
            fields=[
                ('questionwithpropositions_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.QuestionWithPropositions')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.questionwithpropositions',),
        ),
        migrations.AddField(
            model_name='questionproposition',
            name='question',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='propositions', to='djangoldp_polls.QuestionWithPropositions'),
        ),
        migrations.CreateModel(
            name='ResponseItemSingleChoice',
            fields=[
                ('responseitemwithpropositions_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.ResponseItemWithPropositions')),
                ('relatedQuestion', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_polls.QuestionSingleChoice')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.responseitemwithpropositions',),
        ),
        migrations.CreateModel(
            name='ResponseItemRadio',
            fields=[
                ('responseitemwithpropositions_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.ResponseItemWithPropositions')),
                ('relatedQuestion', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_polls.QuestionRadio')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.responseitemwithpropositions',),
        ),
        migrations.CreateModel(
            name='ResponseItemMultipleChoice',
            fields=[
                ('responseitemwithpropositions_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.ResponseItemWithPropositions')),
                ('relatedQuestion', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_polls.QuestionMultipleChoice')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.responseitemwithpropositions',),
        ),
        migrations.CreateModel(
            name='ResponseItemCheckboxes',
            fields=[
                ('responseitemwithpropositions_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.ResponseItemWithPropositions')),
                ('relatedQuestion', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoldp_polls.QuestionCheckboxes')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.responseitemwithpropositions',),
        ),
    ]
