# Generated by Django 2.2.27 on 2022-02-18 07:32

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields
import djangoldp_polls.models.poll


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('djangoldp_conversation', '0007_auto_20200926_0911'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_circle', '0031_circle_parentcircle'),
    ]

    operations = [
        migrations.CreateModel(
            name='Poll',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('title', models.CharField(blank=True, max_length=250, null=True, verbose_name='Title')),
                ('image', models.URLField(blank=True, default='https://unpkg.com/@startinblox/component-poll@2.1/img/defaultpoll.png', null=True, verbose_name='Illustration')),
                ('hostingOrganisation', models.CharField(blank=True, max_length=250, null=True, verbose_name='Name of the hosting organisation')),
                ('startDate', models.DateField(blank=True, null=True, verbose_name='Start date')),
                ('endDate', models.DateField(blank=True, default=djangoldp_polls.models.poll.onMonthLater, null=True, verbose_name='End data')),
                ('shortDescription', models.CharField(blank=True, max_length=250, null=True, verbose_name='Short description')),
                ('longDescription', models.TextField(blank=True, null=True, verbose_name='Long description')),
                ('creationDate', models.DateTimeField(auto_now_add=True, null=True)),
                ('authorNotificationOnComment', models.BooleanField(default=True)),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='createdVotes', to=settings.AUTH_USER_MODEL)),
                ('circle', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='polls', to='djangoldp_circle.Circle')),
                ('debate', models.ManyToManyField(blank=True, related_name='polls', to='djangoldp_conversation.Conversation')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(max_length=250, verbose_name='Name of the question')),
                ('poll', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questions', to='djangoldp_polls.Poll')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, max_length=250, null=True, verbose_name='Name')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.CreateModel(
            name='QuestionCheckboxes',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.Question')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.question',),
        ),
        migrations.CreateModel(
            name='QuestionFreeText',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.Question')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.question',),
        ),
        migrations.CreateModel(
            name='QuestionMultipleChoice',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.Question')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.question',),
        ),
        migrations.CreateModel(
            name='QuestionRadio',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.Question')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.question',),
        ),
        migrations.CreateModel(
            name='QuestionRange',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.Question')),
                ('start', models.IntegerField()),
                ('end', models.IntegerField()),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.question',),
        ),
        migrations.CreateModel(
            name='QuestionSingleChoice',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djangoldp_polls.Question')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
            bases=('djangoldp_polls.question',),
        ),
        migrations.AddField(
            model_name='poll',
            name='tags',
            field=models.ManyToManyField(blank=True, related_name='polls', to='djangoldp_polls.Tag'),
        ),
        migrations.CreateModel(
            name='QuestionSingleChoiceProposition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, max_length=250, null=True, verbose_name='Title')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='propositions', to='djangoldp_polls.QuestionSingleChoice')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.CreateModel(
            name='QuestionRadioProposition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, max_length=250, null=True, verbose_name='Title')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='propositions', to='djangoldp_polls.QuestionRadio')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.CreateModel(
            name='QuestionMultipleChoiceProposition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, max_length=250, null=True, verbose_name='Title')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='propositions', to='djangoldp_polls.QuestionMultipleChoice')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
        migrations.CreateModel(
            name='QuestionCheckboxesProposition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, max_length=250, null=True, verbose_name='Title')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='propositions', to='djangoldp_polls.QuestionCheckboxes')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
            },
        ),
    ]
