/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <yarp/test/PointWithQuality.h>

namespace yarp {
namespace test {

// Default constructor
PointWithQuality::PointWithQuality() :
        WirePortable(),
        point(),
        quality(static_cast<PointQuality>(0))
{
}

// Constructor with field values
PointWithQuality::PointWithQuality(const PointD& point,
                                   const PointQuality quality) :
        WirePortable(),
        point(point),
        quality(quality)
{
}

// Read structure on a Wire
bool PointWithQuality::read(yarp::os::idl::WireReader& reader)
{
    if (!read_point(reader)) {
        return false;
    }
    if (!read_quality(reader)) {
        return false;
    }
    return !reader.isError();
}

// Read structure on a Connection
bool PointWithQuality::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader(4)) {
        return false;
    }
    return read(reader);
}

// Write structure on a Wire
bool PointWithQuality::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!write_point(writer)) {
        return false;
    }
    if (!write_quality(writer)) {
        return false;
    }
    return !writer.isError();
}

// Write structure on a Connection
bool PointWithQuality::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(4)) {
        return false;
    }
    return write(writer);
}

// Convert to a printable string
std::string PointWithQuality::toString() const
{
    yarp::os::Bottle b;
    b.read(*this);
    return b.toString();
}

// Editor: default constructor
PointWithQuality::Editor::Editor()
{
    group = 0;
    obj_owned = true;
    obj = new PointWithQuality;
    dirty_flags(false);
    yarp().setOwner(*this);
}

// Editor: constructor with base class
PointWithQuality::Editor::Editor(PointWithQuality& obj)
{
    group = 0;
    obj_owned = false;
    edit(obj, false);
    yarp().setOwner(*this);
}

// Editor: destructor
PointWithQuality::Editor::~Editor()
{
    if (obj_owned) {
        delete obj;
    }
}

// Editor: edit
bool PointWithQuality::Editor::edit(PointWithQuality& obj, bool dirty)
{
    if (obj_owned) {
        delete this->obj;
    }
    this->obj = &obj;
    obj_owned = false;
    dirty_flags(dirty);
    return true;
}

// Editor: validity check
bool PointWithQuality::Editor::isValid() const
{
    return obj != nullptr;
}

// Editor: state
PointWithQuality& PointWithQuality::Editor::state()
{
    return *obj;
}

// Editor: grouping begin
void PointWithQuality::Editor::start_editing()
{
    group++;
}

// Editor: grouping end
void PointWithQuality::Editor::stop_editing()
{
    group--;
    if (group == 0 && is_dirty) {
        communicate();
    }
}
// Editor: point setter
void PointWithQuality::Editor::set_point(const PointD& point)
{
    will_set_point();
    obj->point = point;
    mark_dirty_point();
    communicate();
    did_set_point();
}

// Editor: point getter
const PointD& PointWithQuality::Editor::get_point() const
{
    return obj->point;
}

// Editor: point will_set
bool PointWithQuality::Editor::will_set_point()
{
    return true;
}

// Editor: point did_set
bool PointWithQuality::Editor::did_set_point()
{
    return true;
}

// Editor: quality setter
void PointWithQuality::Editor::set_quality(const PointQuality quality)
{
    will_set_quality();
    obj->quality = quality;
    mark_dirty_quality();
    communicate();
    did_set_quality();
}

// Editor: quality getter
PointQuality PointWithQuality::Editor::get_quality() const
{
    return obj->quality;
}

// Editor: quality will_set
bool PointWithQuality::Editor::will_set_quality()
{
    return true;
}

// Editor: quality did_set
bool PointWithQuality::Editor::did_set_quality()
{
    return true;
}

// Editor: clean
void PointWithQuality::Editor::clean()
{
    dirty_flags(false);
}

// Editor: read
bool PointWithQuality::Editor::read(yarp::os::ConnectionReader& connection)
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        return false;
    }
    int len = reader.getLength();
    if (len == 0) {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(1)) {
            return false;
        }
        writer.writeString("send: 'help' or 'patch (param1 val1) (param2 val2)'");
        return true;
    }
    std::string tag;
    if (!reader.readString(tag)) {
        return false;
    }
    if (tag == "help") {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(2)) {
            return false;
        }
        if (!writer.writeTag("many", 1, 0)) {
            return false;
        }
        if (reader.getLength() > 0) {
            std::string field;
            if (!reader.readString(field)) {
                return false;
            }
            if (field == "point") {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeString("PointD point")) {
                    return false;
                }
            }
            if (field == "quality") {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeString("PointQuality quality")) {
                    return false;
                }
            }
        }
        if (!writer.writeListHeader(3)) {
            return false;
        }
        writer.writeString("*** Available fields:");
        writer.writeString("point");
        writer.writeString("quality");
        return true;
    }
    bool nested = true;
    bool have_act = false;
    if (tag != "patch") {
        if (((len - 1) % 2) != 0) {
            return false;
        }
        len = 1 + ((len - 1) / 2);
        nested = false;
        have_act = true;
    }
    for (int i = 1; i < len; ++i) {
        if (nested && !reader.readListHeader(3)) {
            return false;
        }
        std::string act;
        std::string key;
        if (have_act) {
            act = tag;
        } else if (!reader.readString(act)) {
            return false;
        }
        if (!reader.readString(key)) {
            return false;
        }
        if (key == "point") {
            will_set_point();
            if (!obj->nested_read_point(reader)) {
                return false;
            }
            did_set_point();
        } else if (key == "quality") {
            will_set_quality();
            if (!obj->nested_read_quality(reader)) {
                return false;
            }
            did_set_quality();
        } else {
            // would be useful to have a fallback here
        }
    }
    reader.accept();
    yarp::os::idl::WireWriter writer(reader);
    if (writer.isNull()) {
        return true;
    }
    writer.writeListHeader(1);
    writer.writeVocab32('o', 'k');
    return true;
}

// Editor: write
bool PointWithQuality::Editor::write(yarp::os::ConnectionWriter& connection) const
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(dirty_count + 1)) {
        return false;
    }
    if (!writer.writeString("patch")) {
        return false;
    }
    if (is_dirty_point) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("point")) {
            return false;
        }
        if (!obj->nested_write_point(writer)) {
            return false;
        }
    }
    if (is_dirty_quality) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("quality")) {
            return false;
        }
        if (!obj->nested_write_quality(writer)) {
            return false;
        }
    }
    return !writer.isError();
}

// Editor: send if possible
void PointWithQuality::Editor::communicate()
{
    if (group != 0) {
        return;
    }
    if (yarp().canWrite()) {
        yarp().write(*this);
        clean();
    }
}

// Editor: mark dirty overall
void PointWithQuality::Editor::mark_dirty()
{
    is_dirty = true;
}

// Editor: point mark_dirty
void PointWithQuality::Editor::mark_dirty_point()
{
    if (is_dirty_point) {
        return;
    }
    dirty_count++;
    is_dirty_point = true;
    mark_dirty();
}

// Editor: quality mark_dirty
void PointWithQuality::Editor::mark_dirty_quality()
{
    if (is_dirty_quality) {
        return;
    }
    dirty_count++;
    is_dirty_quality = true;
    mark_dirty();
}

// Editor: dirty_flags
void PointWithQuality::Editor::dirty_flags(bool flag)
{
    is_dirty = flag;
    is_dirty_point = flag;
    is_dirty_quality = flag;
    dirty_count = flag ? 2 : 0;
}

// read point field
bool PointWithQuality::read_point(yarp::os::idl::WireReader& reader)
{
    if (!reader.read(point)) {
        reader.fail();
        return false;
    }
    return true;
}

// write point field
bool PointWithQuality::write_point(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.write(point)) {
        return false;
    }
    return true;
}

// read (nested) point field
bool PointWithQuality::nested_read_point(yarp::os::idl::WireReader& reader)
{
    if (!reader.readNested(point)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) point field
bool PointWithQuality::nested_write_point(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeNested(point)) {
        return false;
    }
    return true;
}

// read quality field
bool PointWithQuality::read_quality(yarp::os::idl::WireReader& reader)
{
    int32_t ecast24;
    PointQualityVocab cvrt25;
    if (!reader.readEnum(ecast24, cvrt25)) {
        quality = UNKNOWN;
    } else {
        quality = static_cast<PointQuality>(ecast24);
    }
    return true;
}

// write quality field
bool PointWithQuality::write_quality(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeI32(static_cast<int32_t>(quality))) {
        return false;
    }
    return true;
}

// read (nested) quality field
bool PointWithQuality::nested_read_quality(yarp::os::idl::WireReader& reader)
{
    int32_t ecast26;
    PointQualityVocab cvrt27;
    if (!reader.readEnum(ecast26, cvrt27)) {
        quality = UNKNOWN;
    } else {
        quality = static_cast<PointQuality>(ecast26);
    }
    return true;
}

// write (nested) quality field
bool PointWithQuality::nested_write_quality(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeI32(static_cast<int32_t>(quality))) {
        return false;
    }
    return true;
}

} // namespace yarp
} // namespace test
