YARP 3.3.3 (2020-07-20)                                                {#v3_3_3}
=======================

[TOC]

YARP 3.3.3 Release Notes
========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v3.3.3%22).


Bug Fixes
---------

### Build System

* Bison and flex are no longer run when crosscompiling.


### Libraries

#### os

##### `Bottle`

* Fixed precision for floating point numbers, to ensure that they are read as
  the original floating point written.
* Fixed `toString` and `fromString` when writing or reading infinity, negative
  infinity or nan.
* Fixed `fromString` when reading a 64 bit integer.

##### `WireReader`

* Fixed reading a `Float32` from a `Float64` (#2227).
  This is not a common use case, but it can happen when a `Float32` is written
  on a file, and then read again into YARP (as a `Float64`), and then restored
  in the original type using `copyPortable()`.

##### `Timer`

* Fixed `Timer` in monothread mode taking 100% of the CPU.
* Fixed `Timer`s in separate threads not updating their settings.

#### dev

* Fixed dependency from `YARP_math` that should be `PUBLIC`. A few headers
  include `YARP_math` headers.


### Devices

##### `batteryClient`

* Fixed methods returning int instead of double:
  * `getVoltage()`
  * `getCurrent()`
  * `getCharge()`
  * `getTemperature()`

##### `batteryWraper`

* Fixed parameters accepted by subdevice not printed with --verbose.

##### `Navigation2DClient`
* The method `checkNearToLocation` now correctly checks if two orientations are
  similar (below a certain threshold), also considering the critical points
  0, 180, 360, -180, -180, etc.

##### `controlboardwrapper2`

* Exposed missing `yarp::dev::IMotor::setGearboxRatio` method via RPC.

##### `remote_controlboard`

* Implemented missing `yarp::dev::IMotor::setGearboxRatio` method.
* Fixed group command `yarp::dev::IInteractionMode::getInteractionModes`.

##### `fakeBattery`

* Fixed `PeriodicThread` using 100% CPU.


### GUIs

##### `yarpview`

* Now the "checked" state of the two checkable elements in the File menu of
  `yarpview` (i.e. "Save single image..." and "Save a set of images...") turns
  to false when the corresponding dialogs are closed.


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v3.3.2..v3.3.3`):
```
    28	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
     2	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
     2	Bartek Łukawski <bwmn.peter@gmail.com>
     1	Ettore Landini <ettore.landini@iit.it>
     1	Marco Randazzo <marco.randazzo@iit.it>
     1	Silvio Traversaro <silvio.traversaro@iit.it>
```
