"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const certmgr = require("../lib");
class CertStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const cert = new certmgr.Certificate(this, 'Certificate', {
            domainName: 'example.com',
        });
        /// !hide
        new core_1.CfnOutput(this, 'Output', {
            value: cert.certificateArn,
        });
    }
}
const app = new core_1.App();
new CertStack(app, 'MyStack4');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhhbXBsZS5zaW1wbGUtcmVxdWVzdC5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJleGFtcGxlLnNpbXBsZS1yZXF1ZXN0LmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHdDQUFpRTtBQUNqRSxrQ0FBa0M7QUFFbEMsTUFBTSxTQUFVLFNBQVEsWUFBSztJQUMzQixZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLFNBQVM7UUFDVCxNQUFNLElBQUksR0FBRyxJQUFJLE9BQU8sQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUN4RCxVQUFVLEVBQUUsYUFBYTtTQUMxQixDQUFDLENBQUM7UUFDSCxTQUFTO1FBRVQsSUFBSSxnQkFBUyxDQUFDLElBQUksRUFBRSxRQUFRLEVBQUU7WUFDNUIsS0FBSyxFQUFFLElBQUksQ0FBQyxjQUFjO1NBQzNCLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQUVELE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFDdEIsSUFBSSxTQUFTLENBQUMsR0FBRyxFQUFFLFVBQVUsQ0FBQyxDQUFDO0FBQy9CLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgQ2ZuT3V0cHV0LCBDb25zdHJ1Y3QsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjZXJ0bWdyIGZyb20gJy4uL2xpYic7XG5cbmNsYXNzIENlcnRTdGFjayBleHRlbmRzIFN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgLy8vICFzaG93XG4gICAgY29uc3QgY2VydCA9IG5ldyBjZXJ0bWdyLkNlcnRpZmljYXRlKHRoaXMsICdDZXJ0aWZpY2F0ZScsIHtcbiAgICAgIGRvbWFpbk5hbWU6ICdleGFtcGxlLmNvbScsXG4gICAgfSk7XG4gICAgLy8vICFoaWRlXG5cbiAgICBuZXcgQ2ZuT3V0cHV0KHRoaXMsICdPdXRwdXQnLCB7XG4gICAgICB2YWx1ZTogY2VydC5jZXJ0aWZpY2F0ZUFybixcbiAgICB9KTtcbiAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5uZXcgQ2VydFN0YWNrKGFwcCwgJ015U3RhY2s0Jyk7XG5hcHAuc3ludGgoKTtcbiJdfQ==