"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const route53 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const acm = require("../lib");
class AcmStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const exampleCom = new route53.HostedZone(this, 'ExampleCom', {
            zoneName: 'example.com',
        });
        const exampleNet = new route53.HostedZone(this, 'ExampelNet', {
            zoneName: 'example.net',
        });
        const cert = new acm.Certificate(this, 'Certificate', {
            domainName: 'test.example.com',
            subjectAlternativeNames: ['cool.example.com', 'test.example.net'],
            validation: acm.CertificateValidation.fromDnsMultiZone({
                'text.example.com': exampleCom,
                'cool.example.com': exampleCom,
                'test.example.net': exampleNet,
            }),
        });
        /// !hide
        new core_1.CfnOutput(this, 'Output', {
            value: cert.certificateArn,
        });
    }
}
const app = new core_1.App();
new AcmStack(app, 'AcmStack');
app.synth();
//# sourceMappingURL=data:application/json;base64,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